/* cmakeconfig.h.in */

#ifndef __CONFIG_H__
#define __CONFIG_H__

/* Note: You cannot use earlier #defines in later #cmakedefines (cmake 2.6.2). */

/* Name of package */
#define PACKAGE "wireshark"

#define VERSION_EXTRA ""

/* Version number of Wireshark and associated utilities */
#define VERSION "4.6.3"
#define VERSION_MAJOR 4
#define VERSION_MINOR 6
#define VERSION_MICRO 3

/* Version number of Stratoshark and associated utilities */
#define STRATOSHARK_VERSION "0.9.3rc0-1152-g648f69f3e168"

#define PLUGIN_PATH_ID "4.6"
#define VERSION_FLAVOR ""

/* Build wsutil with SIMD optimization */
#define HAVE_SSE4_2 1

/* Define to 1 if we want to enable plugins */
#define HAVE_PLUGINS 1

/*  Define to 1 if we check hf conflict */
/* #undef ENABLE_CHECK_FILTER */

/* Enable AddressSanitizer (and LeakSanitizer on clang/gcc) */
/* #undef ENABLE_ASAN */

/* Enable LeakSanitizer standalone */
/* #undef ENABLE_LSAN */

/* Adapt build products for fuzzing (e.g. accepting incorrect checksums or prioritizing determinism). */
/* #undef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */

/* Define to 1 if you have the <arpa/inet.h> header file. */
#define HAVE_ARPA_INET_H 1

/* Define to 1 if you have the `clock_gettime` function. */
#define HAVE_CLOCK_GETTIME 1

/* Define to 1 if you have the `timespec_get` function. */
#define HAVE_TIMESPEC_GET 1

/* Define to 1 if you have the `localtime_r` function. */
#define HAVE_LOCALTIME_R 1

/* Define to 1 if you have the `gmtime_r` function. */
#define HAVE_GMTIME_R 1

/* Define to 1 if you have the `timegm` function. */
#define HAVE_TIMEGM 1

/* Define to 1 if you have the `tzset` function. */
#define HAVE_TZSET 1

/* Define to use the MaxMind DB library */
#define HAVE_MAXMINDDB 1
/* MaxmindDB version */
#define MAXMINDDB_VERSION ""


/* Define to 1 if you have the <ifaddrs.h> header file. */
#define HAVE_IFADDRS_H 1

/* Define to 1 if yu have the `fseeko` function. */
#define HAVE_FSEEKO 1

/* Define to 1 if you have the `getexecname' function. */
/* #undef HAVE_GETEXECNAME */

/* Define to 1 if you have the `getifaddrs' function. */
#define HAVE_GETIFADDRS 1

/* Define if LIBSSH support is enabled */
#define HAVE_LIBSSH 1

/* Define if you have the 'dlget' function. */
/* #undef HAVE_DLGET */

/* Define to 1 if you have the <grp.h> header file. */
#define HAVE_GRP_H 1

/* Define to use heimdal kerberos */
/* #undef HAVE_HEIMDAL_KERBEROS */

/* Define to 1 if you have the `krb5_pac_verify' function. */
#define HAVE_KRB5_PAC_VERIFY 1

/* Define to 1 if you have the `krb5_c_fx_cf2_simple' function. */
#define HAVE_KRB5_C_FX_CF2_SIMPLE 1

/* Define to 1 if you have the `decode_krb5_enc_tkt_part' function. */
#define HAVE_DECODE_KRB5_ENC_TKT_PART 1

/* Define to 1 if you have the `encode_krb5_enc_tkt_part' function. */
#define HAVE_ENCODE_KRB5_ENC_TKT_PART 1

/* Define to 1 if you have the `inflatePrime' function. */
#define HAVE_INFLATEPRIME 1

/* Define to 1 if you have the `zng_gzopen' function. */
/* #undef WITH_GZFILEOP */

/* Define to 1 if you have the `issetugid' function. */
/* #undef HAVE_ISSETUGID */

/* Define to use kerberos */
#define HAVE_KERBEROS 1

/* Define to use nghttp2 */
#define HAVE_NGHTTP2 1

/* Define to use nghttp3 */
#define HAVE_NGHTTP3 1

/* Define to use the libcap library */
#define HAVE_LIBCAP 1

/* Define to use GnuTLS library */
#define HAVE_LIBGNUTLS 1

/* Define to 1 if GnuTLS was built with pkcs11 support. */
#define HAVE_GNUTLS_PKCS11 1

/* Enable libnl support */
#define HAVE_LIBNL 1

/* libnl version 3 */
#define HAVE_LIBNL3 1

/* Define to use libpcap library */
#define HAVE_LIBPCAP 1

/* Define to 1 if you have the `smi' library (-lsmi). */
#define HAVE_LIBSMI 1

/* Define to 1 if libsmi exports a version string (and that symbol is visible). */
#define HAVE_SMI_VERSION_STRING 1

/* Define to use xxhash library */
#define HAVE_XXHASH 1
#define XXHASH_VERSION_STRING "0.8.3"

/* Define to use zlib library */
#define HAVE_ZLIB 1

/* Define to use zlib-ng library */
/* #undef HAVE_ZLIBNG */
#define ZLIBNG_VERSION_STRING ""

/* Define to use the minizip library */
#define HAVE_MINIZIP 1
#define MINIZIP_VERSION "1.3.1"

/* Define to use the minizip-ng library */
/* #undef HAVE_MINIZIPNG */
#define MINIZIPNG_VERSION ""

/* Define if `dos_date' (with underscore) field exists in `zip_fileinfo'  */
/* #undef HAVE_MZCOMPAT_DOS_DATE */

/* Define to use brotli library */
#define HAVE_BROTLI 1

/* Define to use lz4 library */
#define HAVE_LZ4 1

/* Check for lz4frame */
#define HAVE_LZ4FRAME_H 1

/* Define to use snappy library */
#define HAVE_SNAPPY 1
#define SNAPPY_VERSION "1.2.2"

/* Define to use zstd library */
#define HAVE_ZSTD 1

/* Define to 1 if you have the <linux/sockios.h> header file. */
#define HAVE_LINUX_SOCKIOS_H 1

/* Define to 1 if you have the <linux/if_bonding.h> header file. */
#define HAVE_LINUX_IF_BONDING_H 1

/* Define to use Lua */
/* #undef HAVE_LUA */

/* Define to 1 if we have Lua with Unicode for Windows patches. */
/* #undef HAVE_LUA_UNICODE */

/* The size of the lua_Integer type, if we have Lua. */
/* #undef LUA_INTEGER_SIZE */

/* Define to use MIT kerberos */
#define HAVE_MIT_KERBEROS 1

/* Define to 1 if you have the <netdb.h> header file. */
#define HAVE_NETDB_H 1

/* Define to 1 if you have the <netinet/in.h> header file. */
#define HAVE_NETINET_IN_H 1

/* nl80211.h is new enough */
#define HAVE_NL80211 1

/* SET_CHANNEL is supported */
#define HAVE_NL80211_CMD_SET_CHANNEL 1

/* SPLIT_WIPHY_DUMP is supported */
#define HAVE_NL80211_SPLIT_WIPHY_DUMP 1

/* VHT_CAPABILITY is supported */
#define HAVE_NL80211_VHT_CAPABILITY 1

/* HE_CAPABILITY is supported */
#define HAVE_NL80211_HE_CAPABILITY 1

/* EHT_CAPABILITY is supported */
#define HAVE_NL80211_EHT_CAPABILITY 1

/* Define to 1 if you have macOS frameworks */
/* #undef HAVE_MACOS_FRAMEWORKS */

/* Define to 1 if you have the macOS CFPropertyListCreateWithStream function */
/* #undef HAVE_CFPROPERTYLISTCREATEWITHSTREAM */

/* Define to 1 if you have the `pcap_open' function. */
/* #undef HAVE_PCAP_OPEN */

/* Define to 1 if you have libpcap/Npcap remote capturing support. */
/* #undef HAVE_PCAP_REMOTE */

/* Define to 1 if you have the `pcap_setsampling' function. */
/* #undef HAVE_PCAP_SETSAMPLING */

/* Define to 1 if you have the <pwd.h> header file. */
#define HAVE_PWD_H 1

/* Define to 1 if you want to playing SBC by standalone BlueZ SBC library */
#define HAVE_SBC 1

/* Define to 1 if you have the SpanDSP library. */
#define HAVE_SPANDSP 1

/* Define to 1 if you have the bcg729 library. */
#define HAVE_BCG729 1

/* Define to 1 if you have the opencore-amrnb library. */
#define HAVE_AMRNB 1

/* Define to 1 if you have the ilbc library. */
#define HAVE_ILBC 1

/* Define to 1 if you have the opus library. */
#define HAVE_OPUS 1

/* Define to 1 if you have the `setresgid' function. */
#define HAVE_SETRESGID 1

/* Define to 1 if you have the `setresuid' function. */
#define HAVE_SETRESUID 1

/* Define to 1 if you have the Sparkle or WinSparkle library */
/* #undef HAVE_SOFTWARE_UPDATE */

/* Define if you have the 'strptime' function. */
#define HAVE_STRPTIME 1

/* Define if you have the 'memmem' function. */
#define HAVE_MEMMEM 1

/* Define if you have the 'memrchr' function. */
#define HAVE_MEMRCHR 1

/* Define if you have the 'strerrorname_np' function. */
#define HAVE_STRERRORNAME_NP 1

/* Define if you have the 'vasprintf' function. */
#define HAVE_VASPRINTF 1

/* Define to 1 if `st_birthtime' is a member of `struct stat'. */
/* #undef HAVE_STRUCT_STAT_ST_BIRTHTIME */

/* Define if st_blksize field exists in struct stat */
#define HAVE_STRUCT_STAT_ST_BLKSIZE 1

/* Define to 1 if `__st_birthtime' is a member of `struct stat'. */
/* #undef HAVE_STRUCT_STAT___ST_BIRTHTIME */

/* Define to 1 if you have the <sys/socket.h> header file. */
#define HAVE_SYS_SOCKET_H 1

/* Define to 1 if you have the <sys/time.h> header file. */
#define HAVE_SYS_TIME_H 1

/* Define to 1 if you have the <sys/utsname.h> header file. */
#define HAVE_SYS_UTSNAME_H 1

/* Define to 1 if you have the <sys/wait.h> header file. */
#define HAVE_SYS_WAIT_H 1

/* Define if tm_gmtoff field exists in struct tm */
#define HAVE_STRUCT_TM_TM_GMTOFF 1

/* Define if tm_zone field exists in struct tm */
#define HAVE_STRUCT_TM_TM_ZONE 1

/* Define if tzname array exists */
#define HAVE_TZNAME 1

/* Define to 1 if you have the <unistd.h> header file. */
#define HAVE_UNISTD_H 1

/* Define if we have QtMultimedia */
#define QT_MULTIMEDIA_LIB 1

/* Define if we have QtDBus */
#define QT_DBUS_LIB 1

/* Build androiddump with libpcap instead of wireshark stuff */
/* #undef ANDROIDDUMP_USE_LIBPCAP */

/* Define to 1 if `lex' declares `yytext' as a `char *' by default, not a
   `char[]'. */
/* Note: not use in the code */
/* #undef YYTEXT_POINTER */

/* Define to 1 if the 'ssize_t' type exists. */
#define HAVE_SSIZE_T 1

/* Define to 1 if we are using the msys2 environment to build. */
/* #undef HAVE_MSYSTEM */

/* Define if we have sinsp and scap */
/* #undef HAVE_SINSP */

#ifdef HAVE_SINSP
#define SINSP_VERSION_MAJOR 
#define SINSP_VERSION_MINOR 
#define SINSP_VERSION_MICRO 
#endif

#if defined(_MSC_VER)
#  define strncasecmp strnicmp
#  define popen       _popen
#  define pclose      _pclose
#endif

#if defined(_WIN32)
   /*
    * Flex (v 2.5.35) uses this symbol to "exclude" unistd.h
    */
#  define YY_NO_UNISTD_H

#  ifndef __STDC__
#    define __STDC__ 0
#  endif

/*
 * Make sure everyone is using the same API and that it's sufficient
 * for our needs.
 * This should match the following:
 * - The <compatibility><application> section in resources\wireshark.exe.manifest.in
 * - The WinVer parts of packaging\nsis\wireshark.nsi
 * - The VersionNT parts of packaging\wix\Prerequisites.wxi
 */
#  ifndef NTDDI_VERSION
#  define NTDDI_VERSION   NTDDI_WIN10_RS5
#  endif

#  ifndef _WIN32_WINNT
#  define _WIN32_WINNT    _WIN32_WINNT_WIN10
#  endif
#endif

#define PCRE2_CODE_UNIT_WIDTH  8

/*
 * If HAVE_PCAP_REMOTE is defined, it forces the WinPcap header files to
 * define things required for remote capture, by defining HAVE_REMOTE.
 *
 * With all versions of the WinPcap SDK, if:
 *
 *    1) you are building with any current WinPcap SDK;
 *    2) you do not define HAVE_REMOTE before including pcap.h (or
 *       pcap/pcap.h);
 *    3) you define a struct pcap_stat and pass it to a call to
 *       pcap_stats();
 *    4) the system you're running on has WinPcap, rather than Npcap,
 *       installed;
 *
 * whatever is in memory after the struct pcap_stat may get overwritten,
 * with unpredictable results, because the pcap_stats() implementation for
 * WinPcap will assume that the structure has the additional members that
 * are added if and only if HAVE_REMOTE is defined, and will fill them in,
 * even if they're not there.
 *
 * Yes, this is a WinPcap bug; if your project has a public header file
 * that checks or otherwise uses a #define that's defined by your project's
 * configuration process, and don't ensure that it's always defined
 * appropriately when that header file is included, before its first use,
 * you have made a mistake.
 *
 * In libpcap 1.7.0 and later, the pcap_stats() implementation for WinPcap
 * will not fill those fields in; however, no WinPcap implementation was
 * based on that recent a libpcap release, so they all have the bug.
 *
 * Npcap was originally based on libpcap 1.8.0, and later releases are
 * based on later releases of libpcap, so they will not overwrite memory
 * past the end of the structure.
 *
 * The header file bug is fixed in libpcap 1.9.0 or later - the fields
 * are present on Windows, regardless of whether HAVE_REMOTE is defined
 * or not when the header is included (and are not present on UN*X), so
 * if you build with an SDK with libpcap 1.9.0 or later headers, you
 * do not need to define HAVE_REMOTE before including pcap.h (including it
 * will make no difference).
 *
 * No version of the WinPcap SDK provided libpcap 1.9.0-or-later headers.
 * The Npcap SDK, as of SDK version 1.04, provides them, so this is
 * only necessary for building with the WinPcap SDK.
 *
 * Building against the WinPcap SDK isn't supported anymore, nor is running
 * with the WinPcap DLL installed, so needing this is very unlikely, though
 * libpcap 1.9.0 or later is not yet required.
 */
#ifdef HAVE_PCAP_REMOTE
#define HAVE_REMOTE
#endif

#include <ws_log_defs.h>

#endif /* __CONFIG_H__ */
