# frozen_string_literal: true
# :markup: markdown

=begin
--
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/serialize.rb.erb
if you are looking to modify the template
++
=end

require "stringio"
require_relative "polyfill/unpack1"

module Prism
  # A module responsible for deserializing parse results.
  module Serialize
    # The major version of prism that we are expecting to find in the serialized
    # strings.
    MAJOR_VERSION = 1

    # The minor version of prism that we are expecting to find in the serialized
    # strings.
    MINOR_VERSION = 9

    # The patch version of prism that we are expecting to find in the serialized
    # strings.
    PATCH_VERSION = 0

    # Deserialize the dumped output from a request to parse or parse_file.
    #
    # The formatting of the source of this method is purposeful to illustrate
    # the structure of the serialized data.
    def self.load_parse(input, serialized, freeze)
      input = input.dup
      source = Source.for(input)
      loader = Loader.new(source, serialized)

                       loader.load_header
      encoding =       loader.load_encoding
      start_line =     loader.load_varsint
      offsets =        loader.load_line_offsets(freeze)

      source.replace_start_line(start_line)
      source.replace_offsets(offsets)

      comments =       loader.load_comments(freeze)
      magic_comments = loader.load_magic_comments(freeze)
      data_loc =       loader.load_optional_location_object(freeze)
      errors =         loader.load_errors(encoding, freeze)
      warnings =       loader.load_warnings(encoding, freeze)
      cpool_base =     loader.load_uint32
      cpool_size =     loader.load_varuint

      constant_pool = ConstantPool.new(input, serialized, cpool_base, cpool_size)

      node =           loader.load_node(constant_pool, encoding, freeze)
                       loader.load_constant_pool(constant_pool)
      raise unless     loader.eof?

      result = ParseResult.new(node, comments, magic_comments, data_loc, errors, warnings, source)
      result.freeze if freeze

      input.force_encoding(encoding)

      # This is an extremely niche use-case where the file was marked as binary
      # but it contained UTF-8-encoded characters. In that case we will actually
      # put it back to UTF-8 to give the location APIs the best chance of being
      # correct.
      if !input.ascii_only? && input.encoding == Encoding::BINARY
        input.force_encoding(Encoding::UTF_8)
        input.force_encoding(Encoding::BINARY) unless input.valid_encoding?
      end

      if freeze
        input.freeze
        source.deep_freeze
      end

      result
    end

    # Deserialize the dumped output from a request to lex or lex_file.
    #
    # The formatting of the source of this method is purposeful to illustrate
    # the structure of the serialized data.
    def self.load_lex(input, serialized, freeze)
      source = Source.for(input)
      loader = Loader.new(source, serialized)

      tokens =         loader.load_tokens
      encoding =       loader.load_encoding
      start_line =     loader.load_varsint
      offsets =        loader.load_line_offsets(freeze)

      source.replace_start_line(start_line)
      source.replace_offsets(offsets)

      comments =       loader.load_comments(freeze)
      magic_comments = loader.load_magic_comments(freeze)
      data_loc =       loader.load_optional_location_object(freeze)
      errors =         loader.load_errors(encoding, freeze)
      warnings =       loader.load_warnings(encoding, freeze)
      raise unless     loader.eof?

      result = LexResult.new(tokens, comments, magic_comments, data_loc, errors, warnings, source)

      tokens.each do |token|
        token[0].value.force_encoding(encoding)

        if freeze
          token[0].deep_freeze
          token.freeze
        end
      end

      if freeze
        source.deep_freeze
        tokens.freeze
        result.freeze
      end

      result
    end

    # Deserialize the dumped output from a request to parse_comments or
    # parse_file_comments.
    #
    # The formatting of the source of this method is purposeful to illustrate
    # the structure of the serialized data.
    def self.load_parse_comments(input, serialized, freeze)
      source = Source.for(input)
      loader = Loader.new(source, serialized)

                   loader.load_header
                   loader.load_encoding
      start_line = loader.load_varsint

      source.replace_start_line(start_line)

      result =     loader.load_comments(freeze)
      raise unless loader.eof?

      source.deep_freeze if freeze
      result
    end

    # Deserialize the dumped output from a request to parse_lex or
    # parse_lex_file.
    #
    # The formatting of the source of this method is purposeful to illustrate
    # the structure of the serialized data.
    def self.load_parse_lex(input, serialized, freeze)
      source = Source.for(input)
      loader = Loader.new(source, serialized)

      tokens =         loader.load_tokens
                       loader.load_header
      encoding =       loader.load_encoding
      start_line =     loader.load_varsint
      offsets =        loader.load_line_offsets(freeze)

      source.replace_start_line(start_line)
      source.replace_offsets(offsets)

      comments =       loader.load_comments(freeze)
      magic_comments = loader.load_magic_comments(freeze)
      data_loc =       loader.load_optional_location_object(freeze)
      errors =         loader.load_errors(encoding, freeze)
      warnings =       loader.load_warnings(encoding, freeze)
      cpool_base =     loader.load_uint32
      cpool_size =     loader.load_varuint

      constant_pool = ConstantPool.new(input, serialized, cpool_base, cpool_size)

      node =           loader.load_node(constant_pool, encoding, freeze)
                       loader.load_constant_pool(constant_pool)
      raise unless     loader.eof?

      value = [node, tokens]
      result = ParseLexResult.new(value, comments, magic_comments, data_loc, errors, warnings, source)

      tokens.each do |token|
        token[0].value.force_encoding(encoding)

        if freeze
          token[0].deep_freeze
          token.freeze
        end
      end

      if freeze
        source.deep_freeze
        tokens.freeze
        value.freeze
        result.freeze
      end

      result
    end

    class ConstantPool # :nodoc:
      attr_reader :size

      def initialize(input, serialized, base, size)
        @input = input
        @serialized = serialized
        @base = base
        @size = size
        @pool = Array.new(size, nil)
      end

      def get(index, encoding)
        @pool[index] ||=
          begin
            offset = @base + index * 8
            start = @serialized.unpack1("L", offset: offset)
            length = @serialized.unpack1("L", offset: offset + 4)

            if start.nobits?(1 << 31)
              @input.byteslice(start, length).force_encoding(encoding).to_sym
            else
              @serialized.byteslice(start & ((1 << 31) - 1), length).force_encoding(encoding).to_sym
            end
          end
      end
    end

    if RUBY_ENGINE == "truffleruby"
      # StringIO is synchronized and that adds a high overhead on TruffleRuby.
      class FastStringIO # :nodoc:
        attr_accessor :pos

        def initialize(string)
          @string = string
          @pos = 0
        end

        def getbyte
          byte = @string.getbyte(@pos)
          @pos += 1
          byte
        end

        def read(n)
          slice = @string.byteslice(@pos, n)
          @pos += n
          slice
        end

        def eof?
          @pos >= @string.bytesize
        end
      end
    else
      FastStringIO = ::StringIO # :nodoc:
    end

    class Loader # :nodoc:
      attr_reader :input, :io, :source

      def initialize(source, serialized)
        @input = source.source.dup
        raise unless serialized.encoding == Encoding::BINARY
        @io = FastStringIO.new(serialized)
        @source = source
        define_load_node_lambdas if RUBY_ENGINE != "ruby"
      end

      def eof?
        io.getbyte
        io.eof?
      end

      def load_constant_pool(constant_pool)
        trailer = 0

        constant_pool.size.times do |index|
          start, length = io.read(8).unpack("L2")
          trailer += length if start.anybits?(1 << 31)
        end

        io.read(trailer)
      end

      def load_header
        raise "Invalid serialization" if io.read(5) != "PRISM"
        raise "Invalid serialization" if io.read(3).unpack("C3") != [MAJOR_VERSION, MINOR_VERSION, PATCH_VERSION]
        raise "Invalid serialization (location fields must be included but are not)" if io.getbyte != 0
      end

      def load_encoding
        encoding = Encoding.find(io.read(load_varuint))
        @input = input.force_encoding(encoding).freeze
        encoding
      end

      def load_line_offsets(freeze)
        offsets = Array.new(load_varuint) { load_varuint }
        offsets.freeze if freeze
        offsets
      end

      def load_comments(freeze)
        comments =
          Array.new(load_varuint) do
            comment =
              case load_varuint
              when 0 then InlineComment.new(load_location_object(freeze))
              when 1 then EmbDocComment.new(load_location_object(freeze))
              end

            comment.freeze if freeze
            comment
          end

        comments.freeze if freeze
        comments
      end

      def load_magic_comments(freeze)
        magic_comments =
          Array.new(load_varuint) do
            magic_comment =
              MagicComment.new(
                load_location_object(freeze),
                load_location_object(freeze)
              )

            magic_comment.freeze if freeze
            magic_comment
          end

        magic_comments.freeze if freeze
        magic_comments
      end

      DIAGNOSTIC_TYPES = [
        :alias_argument,
        :alias_argument_numbered_reference,
        :ampampeq_multi_assign,
        :argument_after_block,
        :argument_after_forwarding_ellipses,
        :argument_bare_hash,
        :argument_block_forwarding,
        :argument_block_multi,
        :argument_conflict_ampersand,
        :argument_conflict_star,
        :argument_conflict_star_star,
        :argument_formal_class,
        :argument_formal_constant,
        :argument_formal_global,
        :argument_formal_ivar,
        :argument_forwarding_unbound,
        :argument_no_forwarding_ampersand,
        :argument_no_forwarding_ellipses,
        :argument_no_forwarding_star,
        :argument_no_forwarding_star_star,
        :argument_splat_after_assoc_splat,
        :argument_splat_after_splat,
        :argument_term_paren,
        :argument_unexpected_block,
        :array_element,
        :array_expression,
        :array_expression_after_star,
        :array_separator,
        :array_term,
        :begin_lonely_else,
        :begin_term,
        :begin_upcase_brace,
        :begin_upcase_term,
        :begin_upcase_toplevel,
        :block_param_local_variable,
        :block_param_pipe_term,
        :block_term_brace,
        :block_term_end,
        :cannot_parse_expression,
        :cannot_parse_string_part,
        :case_expression_after_case,
        :case_expression_after_when,
        :case_match_missing_predicate,
        :case_missing_conditions,
        :case_term,
        :class_in_method,
        :class_name,
        :class_superclass,
        :class_term,
        :class_unexpected_end,
        :class_variable_bare,
        :conditional_elsif_predicate,
        :conditional_if_predicate,
        :conditional_predicate_term,
        :conditional_term,
        :conditional_term_else,
        :conditional_unless_predicate,
        :conditional_until_predicate,
        :conditional_while_predicate,
        :constant_path_colon_colon_constant,
        :def_endless,
        :def_endless_parameters,
        :def_endless_setter,
        :def_name,
        :def_params_term,
        :def_params_term_paren,
        :def_receiver,
        :def_receiver_term,
        :def_term,
        :defined_expression,
        :embdoc_term,
        :embexpr_end,
        :embvar_invalid,
        :end_upcase_brace,
        :end_upcase_term,
        :escape_invalid_control,
        :escape_invalid_control_repeat,
        :escape_invalid_hexadecimal,
        :escape_invalid_meta,
        :escape_invalid_meta_repeat,
        :escape_invalid_unicode,
        :escape_invalid_unicode_cm_flags,
        :escape_invalid_unicode_list,
        :escape_invalid_unicode_literal,
        :escape_invalid_unicode_long,
        :escape_invalid_unicode_short,
        :escape_invalid_unicode_term,
        :expect_argument,
        :expect_eol_after_statement,
        :expect_expression_after_ampampeq,
        :expect_expression_after_comma,
        :expect_expression_after_equal,
        :expect_expression_after_less_less,
        :expect_expression_after_lparen,
        :expect_expression_after_operator,
        :expect_expression_after_pipepipeeq,
        :expect_expression_after_question,
        :expect_expression_after_splat,
        :expect_expression_after_splat_hash,
        :expect_expression_after_star,
        :expect_for_delimiter,
        :expect_ident_req_parameter,
        :expect_in_delimiter,
        :expect_lparen_after_not_lparen,
        :expect_lparen_after_not_other,
        :expect_lparen_req_parameter,
        :expect_message,
        :expect_rbracket,
        :expect_rparen,
        :expect_rparen_after_multi,
        :expect_rparen_req_parameter,
        :expect_singleton_class_delimiter,
        :expect_string_content,
        :expect_when_delimiter,
        :expression_bare_hash,
        :expression_not_writable,
        :expression_not_writable_encoding,
        :expression_not_writable_false,
        :expression_not_writable_file,
        :expression_not_writable_line,
        :expression_not_writable_nil,
        :expression_not_writable_numbered,
        :expression_not_writable_self,
        :expression_not_writable_true,
        :float_parse,
        :for_collection,
        :for_in,
        :for_index,
        :for_term,
        :global_variable_bare,
        :hash_expression_after_label,
        :hash_key,
        :hash_rocket,
        :hash_term,
        :hash_value,
        :heredoc_identifier,
        :heredoc_term,
        :incomplete_question_mark,
        :incomplete_variable_class,
        :incomplete_variable_class_3_3,
        :incomplete_variable_instance,
        :incomplete_variable_instance_3_3,
        :instance_variable_bare,
        :invalid_block_exit,
        :invalid_character,
        :invalid_comma,
        :invalid_encoding_magic_comment,
        :invalid_escape_character,
        :invalid_float_exponent,
        :invalid_local_variable_read,
        :invalid_local_variable_write,
        :invalid_multibyte_char,
        :invalid_multibyte_character,
        :invalid_multibyte_escape,
        :invalid_number_binary,
        :invalid_number_decimal,
        :invalid_number_fraction,
        :invalid_number_hexadecimal,
        :invalid_number_octal,
        :invalid_number_underscore_inner,
        :invalid_number_underscore_trailing,
        :invalid_percent,
        :invalid_percent_eof,
        :invalid_printable_character,
        :invalid_retry_after_else,
        :invalid_retry_after_ensure,
        :invalid_retry_without_rescue,
        :invalid_symbol,
        :invalid_variable_global,
        :invalid_variable_global_3_3,
        :invalid_yield,
        :it_not_allowed_numbered,
        :it_not_allowed_ordinary,
        :lambda_open,
        :lambda_term_brace,
        :lambda_term_end,
        :list_i_lower_element,
        :list_i_lower_term,
        :list_i_upper_element,
        :list_i_upper_term,
        :list_w_lower_element,
        :list_w_lower_term,
        :list_w_upper_element,
        :list_w_upper_term,
        :malloc_failed,
        :mixed_encoding,
        :module_in_method,
        :module_name,
        :module_term,
        :multi_assign_multi_splats,
        :multi_assign_unexpected_rest,
        :nesting_too_deep,
        :no_local_variable,
        :non_associative_operator,
        :not_expression,
        :number_literal_underscore,
        :numbered_parameter_inner_block,
        :numbered_parameter_it,
        :numbered_parameter_ordinary,
        :numbered_parameter_outer_block,
        :operator_multi_assign,
        :operator_write_arguments,
        :operator_write_block,
        :parameter_assoc_splat_multi,
        :parameter_block_multi,
        :parameter_circular,
        :parameter_forwarding_after_rest,
        :parameter_method_name,
        :parameter_name_duplicated,
        :parameter_no_default,
        :parameter_no_default_kw,
        :parameter_numbered_reserved,
        :parameter_order,
        :parameter_splat_multi,
        :parameter_star,
        :parameter_unexpected_fwd,
        :parameter_unexpected_no_kw,
        :parameter_wild_loose_comma,
        :pattern_array_multiple_rests,
        :pattern_capture_duplicate,
        :pattern_capture_in_alternative,
        :pattern_expression_after_bracket,
        :pattern_expression_after_comma,
        :pattern_expression_after_hrocket,
        :pattern_expression_after_in,
        :pattern_expression_after_key,
        :pattern_expression_after_paren,
        :pattern_expression_after_pin,
        :pattern_expression_after_pipe,
        :pattern_expression_after_range,
        :pattern_expression_after_rest,
        :pattern_find_missing_inner,
        :pattern_hash_implicit,
        :pattern_hash_key,
        :pattern_hash_key_duplicate,
        :pattern_hash_key_interpolated,
        :pattern_hash_key_label,
        :pattern_hash_key_locals,
        :pattern_ident_after_hrocket,
        :pattern_label_after_comma,
        :pattern_rest,
        :pattern_term_brace,
        :pattern_term_bracket,
        :pattern_term_paren,
        :pipepipeeq_multi_assign,
        :regexp_encoding_option_mismatch,
        :regexp_incompat_char_encoding,
        :regexp_invalid_unicode_range,
        :regexp_non_escaped_mbc,
        :regexp_parse_error,
        :regexp_term,
        :regexp_unknown_options,
        :regexp_utf8_char_non_utf8_regexp,
        :rescue_expression,
        :rescue_modifier_value,
        :rescue_term,
        :rescue_variable,
        :return_invalid,
        :script_not_found,
        :singleton_for_literals,
        :statement_alias,
        :statement_postexe_end,
        :statement_preexe_begin,
        :statement_undef,
        :string_concatenation,
        :string_interpolated_term,
        :string_literal_eof,
        :string_literal_term,
        :symbol_invalid,
        :symbol_term_dynamic,
        :symbol_term_interpolated,
        :ternary_colon,
        :ternary_expression_false,
        :ternary_expression_true,
        :unary_disallowed,
        :unary_receiver,
        :undef_argument,
        :unexpected_block_argument,
        :unexpected_index_block,
        :unexpected_index_keywords,
        :unexpected_label,
        :unexpected_multi_write,
        :unexpected_parameter_default_value,
        :unexpected_range_operator,
        :unexpected_safe_navigation,
        :unexpected_token_close_context,
        :unexpected_token_ignore,
        :until_term,
        :void_expression,
        :while_term,
        :write_target_in_method,
        :write_target_readonly,
        :write_target_unexpected,
        :xstring_term,
        :ambiguous_binary_operator,
        :ambiguous_first_argument_minus,
        :ambiguous_first_argument_plus,
        :ambiguous_prefix_ampersand,
        :ambiguous_prefix_star,
        :ambiguous_prefix_star_star,
        :ambiguous_slash,
        :comparison_after_comparison,
        :dot_dot_dot_eol,
        :equal_in_conditional,
        :equal_in_conditional_3_3,
        :end_in_method,
        :duplicated_hash_key,
        :duplicated_when_clause,
        :float_out_of_range,
        :ignored_frozen_string_literal,
        :indentation_mismatch,
        :integer_in_flip_flop,
        :invalid_character,
        :invalid_magic_comment_value,
        :invalid_numbered_reference,
        :keyword_eol,
        :literal_in_condition_default,
        :literal_in_condition_verbose,
        :shareable_constant_value_line,
        :shebang_carriage_return,
        :unexpected_carriage_return,
        :unreachable_statement,
        :unused_local_variable,
        :void_statement,
      ].freeze

      private_constant :DIAGNOSTIC_TYPES

      def load_error_level
        level = io.getbyte

        case level
        when 0
          :syntax
        when 1
          :argument
        when 2
          :load
        else
          raise "Unknown level: #{level}"
        end
      end

      def load_errors(encoding, freeze)
        errors =
          Array.new(load_varuint) do
            error =
              ParseError.new(
                DIAGNOSTIC_TYPES.fetch(load_varuint),
                load_embedded_string(encoding),
                load_location_object(freeze),
                load_error_level
              )

            error.freeze if freeze
            error
          end

        errors.freeze if freeze
        errors
      end

      def load_warning_level
        level = io.getbyte

        case level
        when 0
          :default
        when 1
          :verbose
        else
          raise "Unknown level: #{level}"
        end
      end

      def load_warnings(encoding, freeze)
        warnings =
          Array.new(load_varuint) do
            warning =
              ParseWarning.new(
                DIAGNOSTIC_TYPES.fetch(load_varuint),
                load_embedded_string(encoding),
                load_location_object(freeze),
                load_warning_level
              )

            warning.freeze if freeze
            warning
          end

        warnings.freeze if freeze
        warnings
      end

      def load_tokens
        tokens = []

        while (type = TOKEN_TYPES.fetch(load_varuint))
          start = load_varuint
          length = load_varuint
          lex_state = load_varuint

          location = Location.new(@source, start, length)
          token = Token.new(@source, type, location.slice, location)

          tokens << [token, lex_state]
        end

        tokens
      end

      # variable-length integer using https://en.wikipedia.org/wiki/LEB128
      # This is also what protobuf uses: https://protobuf.dev/programming-guides/encoding/#varints
      def load_varuint
        n = io.getbyte
        if n < 128
          n
        else
          n -= 128
          shift = 0
          while (b = io.getbyte) >= 128
            n += (b - 128) << (shift += 7)
          end
          n + (b << (shift + 7))
        end
      end

      def load_varsint
        n = load_varuint
        (n >> 1) ^ (-(n & 1))
      end

      def load_integer
        negative = io.getbyte != 0
        length = load_varuint

        value = 0
        length.times { |index| value |= (load_varuint << (index * 32)) }

        value = -value if negative
        value
      end

      def load_double
        io.read(8).unpack1("D")
      end

      def load_uint32
        io.read(4).unpack1("L")
      end

      def load_optional_node(constant_pool, encoding, freeze)
        if io.getbyte != 0
          io.pos -= 1
          load_node(constant_pool, encoding, freeze)
        end
      end

      def load_embedded_string(encoding)
        io.read(load_varuint).force_encoding(encoding).freeze
      end

      def load_string(encoding)
        case (type = io.getbyte)
        when 1
          input.byteslice(load_varuint, load_varuint).force_encoding(encoding).freeze
        when 2
          load_embedded_string(encoding)
        else
          raise "Unknown serialized string type: #{type}"
        end
      end

      def load_location_object(freeze)
        location = Location.new(source, load_varuint, load_varuint)
        location.freeze if freeze
        location
      end

      def load_location(freeze)
        return load_location_object(freeze) if freeze
        (load_varuint << 32) | load_varuint
      end

      def load_optional_location(freeze)
        load_location(freeze) if io.getbyte != 0
      end

      def load_optional_location_object(freeze)
        load_location_object(freeze) if io.getbyte != 0
      end

      def load_constant(constant_pool, encoding)
        index = load_varuint
        constant_pool.get(index - 1, encoding)
      end

      def load_optional_constant(constant_pool, encoding)
        index = load_varuint
        constant_pool.get(index - 1, encoding) if index != 0
      end

      if RUBY_ENGINE == "ruby"
        def load_node(constant_pool, encoding, freeze)
          type = io.getbyte
          node_id = load_varuint
          location = load_location(freeze)
          value = case type
          when 1 then
            AliasGlobalVariableNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 2 then
            AliasMethodNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 3 then
            AlternationPatternNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 4 then
            AndNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 5 then
            ArgumentsNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze })
          when 6 then
            ArrayNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze), load_optional_location(freeze))
          when 7 then
            ArrayPatternNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze), load_optional_location(freeze))
          when 8 then
            AssocNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze))
          when 9 then
            AssocSplatNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 10 then
            BackReferenceReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 11 then
            BeginNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
          when 12 then
            BlockArgumentNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 13 then
            BlockLocalVariableNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 14 then
            BlockNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }.tap { |constants| constants.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze))
          when 15 then
            BlockParameterNode.new(source, node_id, location, load_varuint, load_optional_constant(constant_pool, encoding), load_optional_location(freeze), load_location(freeze))
          when 16 then
            BlockParametersNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze), load_optional_location(freeze))
          when 17 then
            BreakNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 18 then
            CallAndWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 19 then
            CallNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_constant(constant_pool, encoding), load_optional_location(freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze))
          when 20 then
            CallOperatorWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 21 then
            CallOrWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 22 then
            CallTargetNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_constant(constant_pool, encoding), load_location(freeze))
          when 23 then
            CapturePatternNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 24 then
            CaseMatchNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze))
          when 25 then
            CaseNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze))
          when 26 then
            ClassNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }.tap { |constants| constants.freeze if freeze }, load_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_constant(constant_pool, encoding))
          when 27 then
            ClassVariableAndWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 28 then
            ClassVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
          when 29 then
            ClassVariableOrWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 30 then
            ClassVariableReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 31 then
            ClassVariableTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 32 then
            ClassVariableWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 33 then
            ConstantAndWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 34 then
            ConstantOperatorWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
          when 35 then
            ConstantOrWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 36 then
            ConstantPathAndWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 37 then
            ConstantPathNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_constant(constant_pool, encoding), load_location(freeze), load_location(freeze))
          when 38 then
            ConstantPathOperatorWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
          when 39 then
            ConstantPathOrWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 40 then
            ConstantPathTargetNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_constant(constant_pool, encoding), load_location(freeze), load_location(freeze))
          when 41 then
            ConstantPathWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 42 then
            ConstantReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 43 then
            ConstantTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 44 then
            ConstantWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 45 then
            load_uint32
            DefNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_constant(constant_pool, encoding) }.tap { |constants| constants.freeze if freeze }, load_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_optional_location(freeze))
          when 46 then
            DefinedNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_location(freeze))
          when 47 then
            ElseNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
          when 48 then
            EmbeddedStatementsNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 49 then
            EmbeddedVariableNode.new(source, node_id, location, load_varuint, load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 50 then
            EnsureNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 51 then
            FalseNode.new(source, node_id, location, load_varuint)
          when 52 then
            FindPatternNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze))
          when 53 then
            FlipFlopNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 54 then
            FloatNode.new(source, node_id, location, load_varuint, load_double)
          when 55 then
            ForNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze), load_optional_location(freeze), load_location(freeze))
          when 56 then
            ForwardingArgumentsNode.new(source, node_id, location, load_varuint)
          when 57 then
            ForwardingParameterNode.new(source, node_id, location, load_varuint)
          when 58 then
            ForwardingSuperNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze))
          when 59 then
            GlobalVariableAndWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 60 then
            GlobalVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
          when 61 then
            GlobalVariableOrWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 62 then
            GlobalVariableReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 63 then
            GlobalVariableTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 64 then
            GlobalVariableWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 65 then
            HashNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_location(freeze))
          when 66 then
            HashPatternNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze))
          when 67 then
            IfNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
          when 68 then
            ImaginaryNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze))
          when 69 then
            ImplicitNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze))
          when 70 then
            ImplicitRestNode.new(source, node_id, location, load_varuint)
          when 71 then
            InNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_location(freeze))
          when 72 then
            IndexAndWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 73 then
            IndexOperatorWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 74 then
            IndexOrWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 75 then
            IndexTargetNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze))
          when 76 then
            InstanceVariableAndWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 77 then
            InstanceVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
          when 78 then
            InstanceVariableOrWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 79 then
            InstanceVariableReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 80 then
            InstanceVariableTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 81 then
            InstanceVariableWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 82 then
            IntegerNode.new(source, node_id, location, load_varuint, load_integer)
          when 83 then
            InterpolatedMatchLastLineNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_location(freeze))
          when 84 then
            InterpolatedRegularExpressionNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_location(freeze))
          when 85 then
            InterpolatedStringNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze))
          when 86 then
            InterpolatedSymbolNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze))
          when 87 then
            InterpolatedXStringNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_location(freeze))
          when 88 then
            ItLocalVariableReadNode.new(source, node_id, location, load_varuint)
          when 89 then
            ItParametersNode.new(source, node_id, location, load_varuint)
          when 90 then
            KeywordHashNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze })
          when 91 then
            KeywordRestParameterNode.new(source, node_id, location, load_varuint, load_optional_constant(constant_pool, encoding), load_optional_location(freeze), load_location(freeze))
          when 92 then
            LambdaNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }.tap { |constants| constants.freeze if freeze }, load_location(freeze), load_location(freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
          when 93 then
            LocalVariableAndWriteNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding), load_varuint)
          when 94 then
            LocalVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_varuint)
          when 95 then
            LocalVariableOrWriteNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding), load_varuint)
          when 96 then
            LocalVariableReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_varuint)
          when 97 then
            LocalVariableTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_varuint)
          when 98 then
            LocalVariableWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_varuint, load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 99 then
            MatchLastLineNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_location(freeze), load_string(encoding))
          when 100 then
            MatchPredicateNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 101 then
            MatchRequiredNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 102 then
            MatchWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze })
          when 103 then
            MissingNode.new(source, node_id, location, load_varuint)
          when 104 then
            ModuleNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }.tap { |constants| constants.freeze if freeze }, load_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_constant(constant_pool, encoding))
          when 105 then
            MultiTargetNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze), load_optional_location(freeze))
          when 106 then
            MultiWriteNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze), load_optional_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 107 then
            NextNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 108 then
            NilNode.new(source, node_id, location, load_varuint)
          when 109 then
            NoKeywordsParameterNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze))
          when 110 then
            NumberedParametersNode.new(source, node_id, location, load_varuint, io.getbyte)
          when 111 then
            NumberedReferenceReadNode.new(source, node_id, location, load_varuint, load_varuint)
          when 112 then
            OptionalKeywordParameterNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 113 then
            OptionalParameterNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 114 then
            OrNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 115 then
            ParametersNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
          when 116 then
            ParenthesesNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze))
          when 117 then
            PinnedExpressionNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze), load_location(freeze))
          when 118 then
            PinnedVariableNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze))
          when 119 then
            PostExecutionNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze), load_location(freeze))
          when 120 then
            PreExecutionNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze), load_location(freeze))
          when 121 then
            ProgramNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }.tap { |constants| constants.freeze if freeze }, load_node(constant_pool, encoding, freeze))
          when 122 then
            RangeNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 123 then
            RationalNode.new(source, node_id, location, load_varuint, load_integer, load_integer)
          when 124 then
            RedoNode.new(source, node_id, location, load_varuint)
          when 125 then
            RegularExpressionNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_location(freeze), load_string(encoding))
          when 126 then
            RequiredKeywordParameterNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze))
          when 127 then
            RequiredParameterNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
          when 128 then
            RescueModifierNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
          when 129 then
            RescueNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
          when 130 then
            RestParameterNode.new(source, node_id, location, load_varuint, load_optional_constant(constant_pool, encoding), load_optional_location(freeze), load_location(freeze))
          when 131 then
            RetryNode.new(source, node_id, location, load_varuint)
          when 132 then
            ReturnNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze))
          when 133 then
            SelfNode.new(source, node_id, location, load_varuint)
          when 134 then
            ShareableConstantNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze))
          when 135 then
            SingletonClassNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }.tap { |constants| constants.freeze if freeze }, load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
          when 136 then
            SourceEncodingNode.new(source, node_id, location, load_varuint)
          when 137 then
            SourceFileNode.new(source, node_id, location, load_varuint, load_string(encoding))
          when 138 then
            SourceLineNode.new(source, node_id, location, load_varuint)
          when 139 then
            SplatNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze))
          when 140 then
            StatementsNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze })
          when 141 then
            StringNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_location(freeze), load_optional_location(freeze), load_string(encoding))
          when 142 then
            SuperNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze))
          when 143 then
            SymbolNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_string(encoding))
          when 144 then
            TrueNode.new(source, node_id, location, load_varuint)
          when 145 then
            UndefNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_location(freeze))
          when 146 then
            UnlessNode.new(source, node_id, location, load_varuint, load_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
          when 147 then
            UntilNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
          when 148 then
            WhenNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }.tap { |nodes| nodes.freeze if freeze }, load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze))
          when 149 then
            WhileNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
          when 150 then
            XStringNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_location(freeze), load_string(encoding))
          when 151 then
            YieldNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
          end

          value.freeze if freeze
          value
        end
      else
        def load_node(constant_pool, encoding, freeze)
          @load_node_lambdas[io.getbyte].call(constant_pool, encoding, freeze)
        end

        def define_load_node_lambdas
          @load_node_lambdas = [
            nil,
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = AliasGlobalVariableNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = AliasMethodNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = AlternationPatternNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = AndNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ArgumentsNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) })
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ArrayNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ArrayPatternNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = AssocNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = AssocSplatNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = BackReferenceReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = BeginNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = BlockArgumentNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = BlockLocalVariableNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = BlockNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }, load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = BlockParameterNode.new(source, node_id, location, load_varuint, load_optional_constant(constant_pool, encoding), load_optional_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = BlockParametersNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = BreakNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = CallAndWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = CallNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_constant(constant_pool, encoding), load_optional_location(freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = CallOperatorWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = CallOrWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = CallTargetNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_constant(constant_pool, encoding), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = CapturePatternNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = CaseMatchNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = CaseNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ClassNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }, load_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ClassVariableAndWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ClassVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ClassVariableOrWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ClassVariableReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ClassVariableTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ClassVariableWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantAndWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantOperatorWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantOrWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantPathAndWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantPathNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_constant(constant_pool, encoding), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantPathOperatorWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantPathOrWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantPathTargetNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_constant(constant_pool, encoding), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantPathWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ConstantWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              load_uint32
              value = DefNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_constant(constant_pool, encoding) }, load_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = DefinedNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ElseNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = EmbeddedStatementsNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = EmbeddedVariableNode.new(source, node_id, location, load_varuint, load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = EnsureNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = FalseNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = FindPatternNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = FlipFlopNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = FloatNode.new(source, node_id, location, load_varuint, load_double)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ForNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze), load_optional_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ForwardingArgumentsNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ForwardingParameterNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ForwardingSuperNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = GlobalVariableAndWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = GlobalVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = GlobalVariableOrWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = GlobalVariableReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = GlobalVariableTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = GlobalVariableWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = HashNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = HashPatternNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = IfNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ImaginaryNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ImplicitNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ImplicitRestNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = IndexAndWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = IndexOperatorWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = IndexOrWriteNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = IndexTargetNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InstanceVariableAndWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InstanceVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InstanceVariableOrWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InstanceVariableReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InstanceVariableTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InstanceVariableWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = IntegerNode.new(source, node_id, location, load_varuint, load_integer)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InterpolatedMatchLastLineNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InterpolatedRegularExpressionNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InterpolatedStringNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InterpolatedSymbolNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = InterpolatedXStringNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ItLocalVariableReadNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ItParametersNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = KeywordHashNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) })
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = KeywordRestParameterNode.new(source, node_id, location, load_varuint, load_optional_constant(constant_pool, encoding), load_optional_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = LambdaNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }, load_location(freeze), load_location(freeze), load_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = LocalVariableAndWriteNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding), load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = LocalVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding), load_constant(constant_pool, encoding), load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = LocalVariableOrWriteNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_constant(constant_pool, encoding), load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = LocalVariableReadNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = LocalVariableTargetNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = LocalVariableWriteNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_varuint, load_location(freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = MatchLastLineNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_location(freeze), load_string(encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = MatchPredicateNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = MatchRequiredNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = MatchWriteNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) })
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = MissingNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ModuleNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }, load_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = MultiTargetNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = MultiWriteNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze), load_optional_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = NextNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = NilNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = NoKeywordsParameterNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = NumberedParametersNode.new(source, node_id, location, load_varuint, io.getbyte)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = NumberedReferenceReadNode.new(source, node_id, location, load_varuint, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = OptionalKeywordParameterNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = OptionalParameterNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = OrNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ParametersNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_node(constant_pool, encoding, freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ParenthesesNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = PinnedExpressionNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = PinnedVariableNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = PostExecutionNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = PreExecutionNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_location(freeze), load_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ProgramNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }, load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RangeNode.new(source, node_id, location, load_varuint, load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RationalNode.new(source, node_id, location, load_varuint, load_integer, load_integer)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RedoNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RegularExpressionNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_location(freeze), load_string(encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RequiredKeywordParameterNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RequiredParameterNode.new(source, node_id, location, load_varuint, load_constant(constant_pool, encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RescueModifierNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze), load_location(freeze), load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RescueNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RestParameterNode.new(source, node_id, location, load_varuint, load_optional_constant(constant_pool, encoding), load_optional_location(freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = RetryNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ReturnNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = SelfNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = ShareableConstantNode.new(source, node_id, location, load_varuint, load_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = SingletonClassNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_constant(constant_pool, encoding) }, load_location(freeze), load_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = SourceEncodingNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = SourceFileNode.new(source, node_id, location, load_varuint, load_string(encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = SourceLineNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = SplatNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = StatementsNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) })
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = StringNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_location(freeze), load_optional_location(freeze), load_string(encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = SuperNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = SymbolNode.new(source, node_id, location, load_varuint, load_optional_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_string(encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = TrueNode.new(source, node_id, location, load_varuint)
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = UndefNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = UnlessNode.new(source, node_id, location, load_varuint, load_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = UntilNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = WhenNode.new(source, node_id, location, load_varuint, load_location(freeze), Array.new(load_varuint) { load_node(constant_pool, encoding, freeze) }, load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = WhileNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_location(freeze), load_optional_location(freeze), load_node(constant_pool, encoding, freeze), load_optional_node(constant_pool, encoding, freeze))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = XStringNode.new(source, node_id, location, load_varuint, load_location(freeze), load_location(freeze), load_location(freeze), load_string(encoding))
              value.freeze if freeze
              value
            },
            -> (constant_pool, encoding, freeze) {
              node_id = load_varuint
              location = load_location(freeze)
              value = YieldNode.new(source, node_id, location, load_varuint, load_location(freeze), load_optional_location(freeze), load_optional_node(constant_pool, encoding, freeze), load_optional_location(freeze))
              value.freeze if freeze
              value
            },
          ]
        end
      end
    end

    # The token types that can be indexed by their enum values.
    TOKEN_TYPES = [
      nil,
      :EOF,
      :BRACE_RIGHT,
      :COMMA,
      :EMBEXPR_END,
      :KEYWORD_DO,
      :KEYWORD_ELSE,
      :KEYWORD_ELSIF,
      :KEYWORD_END,
      :KEYWORD_ENSURE,
      :KEYWORD_IN,
      :KEYWORD_RESCUE,
      :KEYWORD_THEN,
      :KEYWORD_WHEN,
      :NEWLINE,
      :PARENTHESIS_RIGHT,
      :PIPE,
      :SEMICOLON,
      :AMPERSAND,
      :AMPERSAND_AMPERSAND,
      :AMPERSAND_AMPERSAND_EQUAL,
      :AMPERSAND_DOT,
      :AMPERSAND_EQUAL,
      :BACKTICK,
      :BACK_REFERENCE,
      :BANG,
      :BANG_EQUAL,
      :BANG_TILDE,
      :BRACE_LEFT,
      :BRACKET_LEFT,
      :BRACKET_LEFT_ARRAY,
      :BRACKET_LEFT_RIGHT,
      :BRACKET_LEFT_RIGHT_EQUAL,
      :BRACKET_RIGHT,
      :CARET,
      :CARET_EQUAL,
      :CHARACTER_LITERAL,
      :CLASS_VARIABLE,
      :COLON,
      :COLON_COLON,
      :COMMENT,
      :CONSTANT,
      :DOT,
      :DOT_DOT,
      :DOT_DOT_DOT,
      :EMBDOC_BEGIN,
      :EMBDOC_END,
      :EMBDOC_LINE,
      :EMBEXPR_BEGIN,
      :EMBVAR,
      :EQUAL,
      :EQUAL_EQUAL,
      :EQUAL_EQUAL_EQUAL,
      :EQUAL_GREATER,
      :EQUAL_TILDE,
      :FLOAT,
      :FLOAT_IMAGINARY,
      :FLOAT_RATIONAL,
      :FLOAT_RATIONAL_IMAGINARY,
      :GLOBAL_VARIABLE,
      :GREATER,
      :GREATER_EQUAL,
      :GREATER_GREATER,
      :GREATER_GREATER_EQUAL,
      :HEREDOC_END,
      :HEREDOC_START,
      :IDENTIFIER,
      :IGNORED_NEWLINE,
      :INSTANCE_VARIABLE,
      :INTEGER,
      :INTEGER_IMAGINARY,
      :INTEGER_RATIONAL,
      :INTEGER_RATIONAL_IMAGINARY,
      :KEYWORD_ALIAS,
      :KEYWORD_AND,
      :KEYWORD_BEGIN,
      :KEYWORD_BEGIN_UPCASE,
      :KEYWORD_BREAK,
      :KEYWORD_CASE,
      :KEYWORD_CLASS,
      :KEYWORD_DEF,
      :KEYWORD_DEFINED,
      :KEYWORD_DO_LOOP,
      :KEYWORD_END_UPCASE,
      :KEYWORD_FALSE,
      :KEYWORD_FOR,
      :KEYWORD_IF,
      :KEYWORD_IF_MODIFIER,
      :KEYWORD_MODULE,
      :KEYWORD_NEXT,
      :KEYWORD_NIL,
      :KEYWORD_NOT,
      :KEYWORD_OR,
      :KEYWORD_REDO,
      :KEYWORD_RESCUE_MODIFIER,
      :KEYWORD_RETRY,
      :KEYWORD_RETURN,
      :KEYWORD_SELF,
      :KEYWORD_SUPER,
      :KEYWORD_TRUE,
      :KEYWORD_UNDEF,
      :KEYWORD_UNLESS,
      :KEYWORD_UNLESS_MODIFIER,
      :KEYWORD_UNTIL,
      :KEYWORD_UNTIL_MODIFIER,
      :KEYWORD_WHILE,
      :KEYWORD_WHILE_MODIFIER,
      :KEYWORD_YIELD,
      :KEYWORD___ENCODING__,
      :KEYWORD___FILE__,
      :KEYWORD___LINE__,
      :LABEL,
      :LABEL_END,
      :LAMBDA_BEGIN,
      :LESS,
      :LESS_EQUAL,
      :LESS_EQUAL_GREATER,
      :LESS_LESS,
      :LESS_LESS_EQUAL,
      :METHOD_NAME,
      :MINUS,
      :MINUS_EQUAL,
      :MINUS_GREATER,
      :NUMBERED_REFERENCE,
      :PARENTHESIS_LEFT,
      :PARENTHESIS_LEFT_PARENTHESES,
      :PERCENT,
      :PERCENT_EQUAL,
      :PERCENT_LOWER_I,
      :PERCENT_LOWER_W,
      :PERCENT_LOWER_X,
      :PERCENT_UPPER_I,
      :PERCENT_UPPER_W,
      :PIPE_EQUAL,
      :PIPE_PIPE,
      :PIPE_PIPE_EQUAL,
      :PLUS,
      :PLUS_EQUAL,
      :QUESTION_MARK,
      :REGEXP_BEGIN,
      :REGEXP_END,
      :SLASH,
      :SLASH_EQUAL,
      :STAR,
      :STAR_EQUAL,
      :STAR_STAR,
      :STAR_STAR_EQUAL,
      :STRING_BEGIN,
      :STRING_CONTENT,
      :STRING_END,
      :SYMBOL_BEGIN,
      :TILDE,
      :UAMPERSAND,
      :UCOLON_COLON,
      :UDOT_DOT,
      :UDOT_DOT_DOT,
      :UMINUS,
      :UMINUS_NUM,
      :UPLUS,
      :USTAR,
      :USTAR_STAR,
      :WORDS_SEP,
      :__END__,
      :MISSING,
      :NOT_PROVIDED,
    ].freeze

    private_constant :MAJOR_VERSION, :MINOR_VERSION, :PATCH_VERSION
    private_constant :ConstantPool, :FastStringIO, :Loader, :TOKEN_TYPES
  end

  private_constant :Serialize
end
