# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm and other development tools to provide
# more information, such as PEP 484 type hints, than it is able to glean from
# introspection of extension types and methods.  They are not intended to be
# imported, executed or used for any other purpose other than providing info
# to the tools. If you don't use use a tool that makes use of .pyi files then
# you can safely ignore this file.
#
# See: https://www.python.org/dev/peps/pep-0484/
#      https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
# Copyright: (c) 2020 by Total Control Software
# License:   wxWindows License
#---------------------------------------------------------------------------

#-- begin-typing-imports --#
from __future__ import annotations
from datetime import datetime, date
from enum import IntEnum, IntFlag, auto
from typing import (Any, overload, TypeAlias, Generic,
    Union, Optional, List, Tuple, Callable
)
try:
    from typing import ParamSpec
except ImportError:
    from typing_extensions import ParamSpec

_TwoInts: TypeAlias = Tuple[int, int]
_ThreeInts: TypeAlias = Tuple[int, int, int]
_FourInts: TypeAlias = Tuple[int, int, int, int]
_TwoFloats: TypeAlias = Tuple[float, float]
_FourFloats: TypeAlias = Tuple[float, float, float, float]

#-- end-typing-imports --#

"""
The classes in this module are the most commonly used classes for wxPython,
which is why they have been made visible in the core `wx` namespace.
Everything you need for building typical GUI applications is here.
"""
#-- begin-_core --#

#-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# This code block was included from src/core_ex.py
import sys as _sys

# Load version numbers from __version__ and some other initialization tasks...
if 'wxEVT_NULL' in dir():
    from wx.__version__ import *
    import wx._core
    __version__ = VERSION_STRING

    # Add the build type to PlatformInfo
    PlatformInfo = PlatformInfo + ('build-type: ' + BUILD_TYPE, )

    # Register a function to be called when Python terminates that will clean
    # up and release all system resources that wxWidgets allocated.
    import atexit
    atexit.register(wx._core._wxPyCleanup)
    del atexit

else:
    Port = ''
    Platform = ''
    PlatformInfo = []

# A little trick to make 'wx' be a reference to this module so wx.Names can
# be used in the python code here.
wx = _sys.modules[__name__]


import warnings
class wxPyDeprecationWarning(DeprecationWarning):
    pass

warnings.simplefilter('default', wxPyDeprecationWarning)
del warnings


def deprecated(item, msg='', useName=False):
    """
    Create a delegating wrapper that raises a deprecation warning.  Can be
    used with callable objects (functions, methods, classes) or with
    properties.
    """
    import warnings

    name = ''
    if useName:
        try:
            name = ' ' + item.__name__
        except AttributeError:
            pass

    if isinstance(item, type):
        # It is a class.  Make a subclass that raises a warning.
        class DeprecatedClassProxy(item):
            def __init__(*args, **kw):
                warnings.warn("Using deprecated class%s. %s" % (name, msg),
                          wxPyDeprecationWarning, stacklevel=2)
                item.__init__(*args, **kw)
        DeprecatedClassProxy.__name__ = item.__name__
        return DeprecatedClassProxy

    elif callable(item):
        # wrap a new function around the callable
        def deprecated_func(*args, **kw):
            warnings.warn("Call to deprecated item%s. %s" % (name, msg),
                          wxPyDeprecationWarning, stacklevel=2)
            if not kw:
                return item(*args)
            return item(*args, **kw)
        deprecated_func.__name__ = item.__name__
        deprecated_func.__doc__ = item.__doc__
        if hasattr(item, '__dict__'):
            deprecated_func.__dict__.update(item.__dict__)
        return deprecated_func

    elif hasattr(item, '__get__'):
        # it should be a property if there is a getter
        class DepGetProp(object):
            def __init__(self, item, msg):
                self.item = item
                self.msg = msg
            def __get__(self, inst, klass):
                warnings.warn("Accessing deprecated property. %s" % msg,
                              wxPyDeprecationWarning, stacklevel=2)
                return self.item.__get__(inst, klass)
        class DepGetSetProp(DepGetProp):
            def __set__(self, inst, val):
                warnings.warn("Accessing deprecated property. %s" % msg,
                              wxPyDeprecationWarning, stacklevel=2)
                return self.item.__set__(inst, val)
        class DepGetSetDelProp(DepGetSetProp):
            def __delete__(self, inst):
                warnings.warn("Accessing deprecated property. %s" % msg,
                              wxPyDeprecationWarning, stacklevel=2)
                return self.item.__delete__(inst)

        if hasattr(item, '__set__') and hasattr(item, '__delete__'):
            return DepGetSetDelProp(item, msg)
        elif hasattr(item, '__set__'):
            return DepGetSetProp(item, msg)
        else:
            return DepGetProp(item, msg)
    else:
        raise TypeError("unsupported type %s" % type(item))


def deprecatedMsg(msg):
    """
    A wrapper for the deprecated decorator that makes it easier to attach a
    custom message to the warning that is raised if the item is used. This
    can also be used in the @decorator role since it returns the real
    decorator when called.
    """
    import functools
    return functools.partial(deprecated, msg=msg, useName=True)

#----------------------------------------------------------------------------

EmptyString = ""

#----------------------------------------------------------------------------

# End of included code block
#-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

import typing

def version():
    """
    Returns a string containing version and port info
    """
    pass

_T = typing.TypeVar('_T')
try:
    _P = typing.ParamSpec('_P')
except AttributeError:
    import typing_extensions
    _P = typing_extensions.ParamSpec('_P')

def CallAfter(callableObj: typing.Callable[_P, _T], *args: _P.args, **kw: _P.kwargs) -> None:
    """
    Call the specified function after the current and pending event
    handlers have been completed.  This is also good for making GUI
    method calls from non-GUI threads.  Any extra positional or
    keyword args are passed on to the callable when it is called.
    
    :param PyObject callableObj: the callable object
    :param args: arguments to be passed to the callable object
    :param kw: keywords to be passed to the callable object
    
    .. seealso::
        :ref:`wx.CallLater`
    """
    pass
class CallLater(typing.Generic[_P, _T]):
    """
    A convenience class for :class:`wx.Timer`, that calls the given callable
    object once after the given amount of milliseconds, passing any
    positional or keyword args.  The return value of the callable is
    available after it has been run with the :meth:`~wx.CallLater.GetResult`
    method.
    
    If you don't need to get the return value or restart the timer
    then there is no need to hold a reference to this object. CallLater
    maintains references to its instances while they are running. When they
    finish, the internal reference is deleted and the GC is free to collect
    naturally.
    
    .. seealso::
        :func:`wx.CallAfter`
    """

    __instances = {}

    def __init__(self, millis, callableObj: typing.Callable[_P, _T], *args: _P.args, **kwargs: _P.kwargs) -> None:
        """
        Constructs a new :class:`wx.CallLater` object.
        
        :param int millis: number of milliseconds to delay until calling the callable object
        :param PyObject callableObj: the callable object
        :param args: arguments to be passed to the callable object
        :param kw: keyword arguments to be passed to the callable object
        """
        pass

    def __del__(self):
        pass

    def Start(self, millis: typing.Optional[int]=None, *args: _P.args, **kwargs: _P.kwargs) -> None:
        """
        (Re)start the timer
        
        :param int millis: number of milli seconds
        :param args: arguments to be passed to the callable object
        :param kw: keywords to be passed to the callable object
        """
        pass

    Restart = Start

    def Stop(self) -> None:
        """
        Stop and destroy the timer.
        """
        pass

    def GetInterval(self) -> int:
        pass

    def IsRunning(self) -> bool:
        pass

    def SetArgs(self, *args: _P.args, **kwargs: _P.kwargs) -> None:
        """
        (Re)set the args passed to the callable object.  This is
        useful in conjunction with :meth:`Start` if
        you want to schedule a new call to the same callable
        object but with different parameters.
        
        :param args: arguments to be passed to the callable object
        :param kw: keywords to be passed to the callable object
        """
        pass

    def HasRun(self) -> bool:
        """
        Returns whether or not the callable has run.
        
        :rtype: bool
        """
        pass

    def GetResult(self) -> _T:
        """
        Returns the value of the callable.
        
        :rtype: a Python object
        :return: result from callable
        """
        pass

    def Notify(self) -> None:
        """
        The timer has expired so call the callable.
        """
        pass
    Interval = property(GetInterval)
    Result = property(GetResult)

FutureCall = deprecated(CallLater, 'Use CallLater instead.')

def GetDefaultPyEncoding() -> str:
    return "utf-8"
GetDefaultPyEncoding = deprecated(GetDefaultPyEncoding, msg="wxPython now always uses utf-8")

def IsMainThread(self) -> bool:
    """
    IsMainThread() -> bool
    
    Returns ``True`` if the current thread is what wx considers the GUI
    thread.
    """
#-- end-_core --#
#-- begin-defs --#
INT8_MIN: int
INT8_MAX: int
UINT8_MAX: int
INT16_MIN: int
INT16_MAX: int
UINT16_MAX: int
INT32_MIN: int
INT32_MAX: int
UINT32_MAX: int
INT64_MIN: int
INT64_MAX: int
UINT64_MAX: int
SIZE_AUTO_WIDTH: int
SIZE_AUTO_HEIGHT: int
SIZE_AUTO: int
SIZE_USE_EXISTING: int
SIZE_ALLOW_MINUS_ONE: int
SIZE_NO_ADJUSTMENTS: int
SIZE_FORCE: int
SIZE_FORCE_EVENT: int
VSCROLL: int
HSCROLL: int
CAPTION: int
DOUBLE_BORDER: int
SUNKEN_BORDER: int
RAISED_BORDER: int
BORDER: int
SIMPLE_BORDER: int
STATIC_BORDER: int
NO_BORDER: int
ALWAYS_SHOW_SB: int
CLIP_CHILDREN: int
CLIP_SIBLINGS: int
TRANSPARENT_WINDOW: int
TAB_TRAVERSAL: int
WANTS_CHARS: int
RETAINED: int
BACKINGSTORE: int
POPUP_WINDOW: int
FULL_REPAINT_ON_RESIZE: int
NO_FULL_REPAINT_ON_RESIZE: int
WINDOW_STYLE_MASK: int
WS_EX_BLOCK_EVENTS: int
WS_EX_TRANSIENT: int
WS_EX_THEMED_BACKGROUND: int
WS_EX_PROCESS_IDLE: int
WS_EX_PROCESS_UI_UPDATES: int
FRAME_EX_METAL: int
DIALOG_EX_METAL: int
WS_EX_CONTEXTHELP: int
FRAME_EX_CONTEXTHELP: int
DIALOG_EX_CONTEXTHELP: int
FRAME_DRAWER: int
FRAME_NO_WINDOW_MENU: int
MB_DOCKABLE: int
MENU_TEAROFF: int
COLOURED: int
FIXED_LENGTH: int
LB_SORT: int
LB_SINGLE: int
LB_MULTIPLE: int
LB_EXTENDED: int
LB_NEEDED_SB: int
LB_OWNERDRAW: int
LB_ALWAYS_SB: int
LB_NO_SB: int
LB_HSCROLL: int
LB_INT_HEIGHT: int
CB_SIMPLE: int
CB_SORT: int
CB_READONLY: int
CB_DROPDOWN: int
RA_LEFTTORIGHT: int
RA_TOPTOBOTTOM: int
RA_SPECIFY_COLS: int
RA_SPECIFY_ROWS: int
RA_HORIZONTAL: int
RA_VERTICAL: int
RB_GROUP: int
RB_SINGLE: int
SB_HORIZONTAL: int
SB_VERTICAL: int
SP_HORIZONTAL: int
SP_VERTICAL: int
SP_ARROW_KEYS: int
SP_WRAP: int
TC_RIGHTJUSTIFY: int
TC_FIXEDWIDTH: int
TC_TOP: int
TC_LEFT: int
TC_RIGHT: int
TC_BOTTOM: int
TC_MULTILINE: int
TC_OWNERDRAW: int
BI_EXPAND: int
LI_HORIZONTAL: int
LI_VERTICAL: int
YES: int
OK: int
NO: int
YES_NO: int
CANCEL: int
APPLY: int
CLOSE: int
OK_DEFAULT: int
YES_DEFAULT: int
NO_DEFAULT: int
CANCEL_DEFAULT: int
ICON_EXCLAMATION: int
ICON_HAND: int
ICON_WARNING: int
ICON_ERROR: int
ICON_QUESTION: int
ICON_INFORMATION: int
ICON_STOP: int
ICON_ASTERISK: int
HELP: int
FORWARD: int
BACKWARD: int
RESET: int
MORE: int
SETUP: int
ICON_NONE: int
ICON_AUTH_NEEDED: int
ICON_MASK: int
NOT_FOUND: int
PRINT_QUALITY_HIGH: int
PRINT_QUALITY_MEDIUM: int
PRINT_QUALITY_LOW: int
PRINT_QUALITY_DRAFT: int
STAY_ON_TOP: int
ICONIZE: int
MINIMIZE: int
MAXIMIZE: int
CLOSE_BOX: int
SYSTEM_MENU: int
MINIMIZE_BOX: int
MAXIMIZE_BOX: int
TINY_CAPTION: int
RESIZE_BORDER: int

class _GeometryCentre(IntEnum):
    CENTRE = auto()
    CENTER = auto()
GeometryCentre: TypeAlias = Union[_GeometryCentre, int]
CENTRE = _GeometryCentre.CENTRE
CENTER = _GeometryCentre.CENTER

class _Orientation(IntEnum):
    HORIZONTAL = auto()
    VERTICAL = auto()
    BOTH = auto()
    ORIENTATION_MASK = auto()
Orientation: TypeAlias = Union[_Orientation, int]
HORIZONTAL = _Orientation.HORIZONTAL
VERTICAL = _Orientation.VERTICAL
BOTH = _Orientation.BOTH
ORIENTATION_MASK = _Orientation.ORIENTATION_MASK

class _Direction(IntEnum):
    LEFT = auto()
    RIGHT = auto()
    UP = auto()
    DOWN = auto()
    TOP = auto()
    BOTTOM = auto()
    NORTH = auto()
    SOUTH = auto()
    WEST = auto()
    EAST = auto()
    ALL = auto()
    DIRECTION_MASK = auto()
Direction: TypeAlias = Union[_Direction, int]
LEFT = _Direction.LEFT
RIGHT = _Direction.RIGHT
UP = _Direction.UP
DOWN = _Direction.DOWN
TOP = _Direction.TOP
BOTTOM = _Direction.BOTTOM
NORTH = _Direction.NORTH
SOUTH = _Direction.SOUTH
WEST = _Direction.WEST
EAST = _Direction.EAST
ALL = _Direction.ALL
DIRECTION_MASK = _Direction.DIRECTION_MASK

class _Alignment(IntEnum):
    ALIGN_INVALID = auto()
    ALIGN_NOT = auto()
    ALIGN_CENTER_HORIZONTAL = auto()
    ALIGN_CENTRE_HORIZONTAL = auto()
    ALIGN_LEFT = auto()
    ALIGN_TOP = auto()
    ALIGN_RIGHT = auto()
    ALIGN_BOTTOM = auto()
    ALIGN_CENTER_VERTICAL = auto()
    ALIGN_CENTRE_VERTICAL = auto()
    ALIGN_CENTER = auto()
    ALIGN_CENTRE = auto()
    ALIGN_MASK = auto()
Alignment: TypeAlias = Union[_Alignment, int]
ALIGN_INVALID = _Alignment.ALIGN_INVALID
ALIGN_NOT = _Alignment.ALIGN_NOT
ALIGN_CENTER_HORIZONTAL = _Alignment.ALIGN_CENTER_HORIZONTAL
ALIGN_CENTRE_HORIZONTAL = _Alignment.ALIGN_CENTRE_HORIZONTAL
ALIGN_LEFT = _Alignment.ALIGN_LEFT
ALIGN_TOP = _Alignment.ALIGN_TOP
ALIGN_RIGHT = _Alignment.ALIGN_RIGHT
ALIGN_BOTTOM = _Alignment.ALIGN_BOTTOM
ALIGN_CENTER_VERTICAL = _Alignment.ALIGN_CENTER_VERTICAL
ALIGN_CENTRE_VERTICAL = _Alignment.ALIGN_CENTRE_VERTICAL
ALIGN_CENTER = _Alignment.ALIGN_CENTER
ALIGN_CENTRE = _Alignment.ALIGN_CENTRE
ALIGN_MASK = _Alignment.ALIGN_MASK

class _SizerFlagBits(IntEnum):
    FIXED_MINSIZE = auto()
    RESERVE_SPACE_EVEN_IF_HIDDEN = auto()
    SIZER_FLAG_BITS_MASK = auto()
SizerFlagBits: TypeAlias = Union[_SizerFlagBits, int]
FIXED_MINSIZE = _SizerFlagBits.FIXED_MINSIZE
RESERVE_SPACE_EVEN_IF_HIDDEN = _SizerFlagBits.RESERVE_SPACE_EVEN_IF_HIDDEN
SIZER_FLAG_BITS_MASK = _SizerFlagBits.SIZER_FLAG_BITS_MASK

class _Stretch(IntEnum):
    STRETCH_NOT = auto()
    SHRINK = auto()
    GROW = auto()
    EXPAND = auto()
    SHAPED = auto()
    TILE = auto()
    STRETCH_MASK = auto()
Stretch: TypeAlias = Union[_Stretch, int]
STRETCH_NOT = _Stretch.STRETCH_NOT
SHRINK = _Stretch.SHRINK
GROW = _Stretch.GROW
EXPAND = _Stretch.EXPAND
SHAPED = _Stretch.SHAPED
TILE = _Stretch.TILE
STRETCH_MASK = _Stretch.STRETCH_MASK

class _Border(IntEnum):
    BORDER_DEFAULT = auto()
    BORDER_NONE = auto()
    BORDER_STATIC = auto()
    BORDER_SIMPLE = auto()
    BORDER_RAISED = auto()
    BORDER_SUNKEN = auto()
    BORDER_DOUBLE = auto()
    BORDER_THEME = auto()
    BORDER_MASK = auto()
Border: TypeAlias = Union[_Border, int]
BORDER_DEFAULT = _Border.BORDER_DEFAULT
BORDER_NONE = _Border.BORDER_NONE
BORDER_STATIC = _Border.BORDER_STATIC
BORDER_SIMPLE = _Border.BORDER_SIMPLE
BORDER_RAISED = _Border.BORDER_RAISED
BORDER_SUNKEN = _Border.BORDER_SUNKEN
BORDER_DOUBLE = _Border.BORDER_DOUBLE
BORDER_THEME = _Border.BORDER_THEME
BORDER_MASK = _Border.BORDER_MASK

class _BackgroundStyle(IntEnum):
    BG_STYLE_ERASE = auto()
    BG_STYLE_SYSTEM = auto()
    BG_STYLE_PAINT = auto()
    BG_STYLE_COLOUR = auto()
    BG_STYLE_TRANSPARENT = auto()
BackgroundStyle: TypeAlias = Union[_BackgroundStyle, int]
BG_STYLE_ERASE = _BackgroundStyle.BG_STYLE_ERASE
BG_STYLE_SYSTEM = _BackgroundStyle.BG_STYLE_SYSTEM
BG_STYLE_PAINT = _BackgroundStyle.BG_STYLE_PAINT
BG_STYLE_COLOUR = _BackgroundStyle.BG_STYLE_COLOUR
BG_STYLE_TRANSPARENT = _BackgroundStyle.BG_STYLE_TRANSPARENT

class _StandardID(IntEnum):
    ID_AUTO_LOWEST = auto()
    ID_AUTO_HIGHEST = auto()
    ID_NONE = auto()
    ID_SEPARATOR = auto()
    ID_ANY = auto()
    ID_LOWEST = auto()
    ID_OPEN = auto()
    ID_CLOSE = auto()
    ID_NEW = auto()
    ID_SAVE = auto()
    ID_SAVEAS = auto()
    ID_REVERT = auto()
    ID_EXIT = auto()
    ID_UNDO = auto()
    ID_REDO = auto()
    ID_HELP = auto()
    ID_PRINT = auto()
    ID_PRINT_SETUP = auto()
    ID_PAGE_SETUP = auto()
    ID_PREVIEW = auto()
    ID_ABOUT = auto()
    ID_HELP_CONTENTS = auto()
    ID_HELP_INDEX = auto()
    ID_HELP_SEARCH = auto()
    ID_HELP_COMMANDS = auto()
    ID_HELP_PROCEDURES = auto()
    ID_HELP_CONTEXT = auto()
    ID_CLOSE_ALL = auto()
    ID_PREFERENCES = auto()
    ID_EDIT = auto()
    ID_CUT = auto()
    ID_COPY = auto()
    ID_PASTE = auto()
    ID_CLEAR = auto()
    ID_FIND = auto()
    ID_DUPLICATE = auto()
    ID_SELECTALL = auto()
    ID_DELETE = auto()
    ID_REPLACE = auto()
    ID_REPLACE_ALL = auto()
    ID_PROPERTIES = auto()
    ID_VIEW_DETAILS = auto()
    ID_VIEW_LARGEICONS = auto()
    ID_VIEW_SMALLICONS = auto()
    ID_VIEW_LIST = auto()
    ID_VIEW_SORTDATE = auto()
    ID_VIEW_SORTNAME = auto()
    ID_VIEW_SORTSIZE = auto()
    ID_VIEW_SORTTYPE = auto()
    ID_FILE = auto()
    ID_FILE1 = auto()
    ID_FILE2 = auto()
    ID_FILE3 = auto()
    ID_FILE4 = auto()
    ID_FILE5 = auto()
    ID_FILE6 = auto()
    ID_FILE7 = auto()
    ID_FILE8 = auto()
    ID_FILE9 = auto()
    ID_OK = auto()
    ID_CANCEL = auto()
    ID_APPLY = auto()
    ID_YES = auto()
    ID_NO = auto()
    ID_STATIC = auto()
    ID_FORWARD = auto()
    ID_BACKWARD = auto()
    ID_DEFAULT = auto()
    ID_MORE = auto()
    ID_SETUP = auto()
    ID_RESET = auto()
    ID_CONTEXT_HELP = auto()
    ID_YESTOALL = auto()
    ID_NOTOALL = auto()
    ID_ABORT = auto()
    ID_RETRY = auto()
    ID_IGNORE = auto()
    ID_ADD = auto()
    ID_REMOVE = auto()
    ID_UP = auto()
    ID_DOWN = auto()
    ID_HOME = auto()
    ID_REFRESH = auto()
    ID_STOP = auto()
    ID_INDEX = auto()
    ID_BOLD = auto()
    ID_ITALIC = auto()
    ID_JUSTIFY_CENTER = auto()
    ID_JUSTIFY_FILL = auto()
    ID_JUSTIFY_RIGHT = auto()
    ID_JUSTIFY_LEFT = auto()
    ID_UNDERLINE = auto()
    ID_INDENT = auto()
    ID_UNINDENT = auto()
    ID_ZOOM_100 = auto()
    ID_ZOOM_FIT = auto()
    ID_ZOOM_IN = auto()
    ID_ZOOM_OUT = auto()
    ID_UNDELETE = auto()
    ID_REVERT_TO_SAVED = auto()
    ID_CDROM = auto()
    ID_CONVERT = auto()
    ID_EXECUTE = auto()
    ID_FLOPPY = auto()
    ID_HARDDISK = auto()
    ID_BOTTOM = auto()
    ID_FIRST = auto()
    ID_LAST = auto()
    ID_TOP = auto()
    ID_INFO = auto()
    ID_JUMP_TO = auto()
    ID_NETWORK = auto()
    ID_SELECT_COLOR = auto()
    ID_SELECT_FONT = auto()
    ID_SORT_ASCENDING = auto()
    ID_SORT_DESCENDING = auto()
    ID_SPELL_CHECK = auto()
    ID_STRIKETHROUGH = auto()
    ID_SYSTEM_MENU = auto()
    ID_CLOSE_FRAME = auto()
    ID_MOVE_FRAME = auto()
    ID_RESIZE_FRAME = auto()
    ID_MAXIMIZE_FRAME = auto()
    ID_ICONIZE_FRAME = auto()
    ID_RESTORE_FRAME = auto()
    ID_MDI_WINDOW_FIRST = auto()
    ID_MDI_WINDOW_CASCADE = auto()
    ID_MDI_WINDOW_TILE_HORZ = auto()
    ID_MDI_WINDOW_TILE_VERT = auto()
    ID_MDI_WINDOW_ARRANGE_ICONS = auto()
    ID_MDI_WINDOW_PREV = auto()
    ID_MDI_WINDOW_NEXT = auto()
    ID_MDI_WINDOW_LAST = auto()
    ID_FILEDLGG = auto()
    ID_FILECTRL = auto()
    ID_HIGHEST = auto()
StandardID: TypeAlias = Union[_StandardID, int]
ID_AUTO_LOWEST = _StandardID.ID_AUTO_LOWEST
ID_AUTO_HIGHEST = _StandardID.ID_AUTO_HIGHEST
ID_NONE = _StandardID.ID_NONE
ID_SEPARATOR = _StandardID.ID_SEPARATOR
ID_ANY = _StandardID.ID_ANY
ID_LOWEST = _StandardID.ID_LOWEST
ID_OPEN = _StandardID.ID_OPEN
ID_CLOSE = _StandardID.ID_CLOSE
ID_NEW = _StandardID.ID_NEW
ID_SAVE = _StandardID.ID_SAVE
ID_SAVEAS = _StandardID.ID_SAVEAS
ID_REVERT = _StandardID.ID_REVERT
ID_EXIT = _StandardID.ID_EXIT
ID_UNDO = _StandardID.ID_UNDO
ID_REDO = _StandardID.ID_REDO
ID_HELP = _StandardID.ID_HELP
ID_PRINT = _StandardID.ID_PRINT
ID_PRINT_SETUP = _StandardID.ID_PRINT_SETUP
ID_PAGE_SETUP = _StandardID.ID_PAGE_SETUP
ID_PREVIEW = _StandardID.ID_PREVIEW
ID_ABOUT = _StandardID.ID_ABOUT
ID_HELP_CONTENTS = _StandardID.ID_HELP_CONTENTS
ID_HELP_INDEX = _StandardID.ID_HELP_INDEX
ID_HELP_SEARCH = _StandardID.ID_HELP_SEARCH
ID_HELP_COMMANDS = _StandardID.ID_HELP_COMMANDS
ID_HELP_PROCEDURES = _StandardID.ID_HELP_PROCEDURES
ID_HELP_CONTEXT = _StandardID.ID_HELP_CONTEXT
ID_CLOSE_ALL = _StandardID.ID_CLOSE_ALL
ID_PREFERENCES = _StandardID.ID_PREFERENCES
ID_EDIT = _StandardID.ID_EDIT
ID_CUT = _StandardID.ID_CUT
ID_COPY = _StandardID.ID_COPY
ID_PASTE = _StandardID.ID_PASTE
ID_CLEAR = _StandardID.ID_CLEAR
ID_FIND = _StandardID.ID_FIND
ID_DUPLICATE = _StandardID.ID_DUPLICATE
ID_SELECTALL = _StandardID.ID_SELECTALL
ID_DELETE = _StandardID.ID_DELETE
ID_REPLACE = _StandardID.ID_REPLACE
ID_REPLACE_ALL = _StandardID.ID_REPLACE_ALL
ID_PROPERTIES = _StandardID.ID_PROPERTIES
ID_VIEW_DETAILS = _StandardID.ID_VIEW_DETAILS
ID_VIEW_LARGEICONS = _StandardID.ID_VIEW_LARGEICONS
ID_VIEW_SMALLICONS = _StandardID.ID_VIEW_SMALLICONS
ID_VIEW_LIST = _StandardID.ID_VIEW_LIST
ID_VIEW_SORTDATE = _StandardID.ID_VIEW_SORTDATE
ID_VIEW_SORTNAME = _StandardID.ID_VIEW_SORTNAME
ID_VIEW_SORTSIZE = _StandardID.ID_VIEW_SORTSIZE
ID_VIEW_SORTTYPE = _StandardID.ID_VIEW_SORTTYPE
ID_FILE = _StandardID.ID_FILE
ID_FILE1 = _StandardID.ID_FILE1
ID_FILE2 = _StandardID.ID_FILE2
ID_FILE3 = _StandardID.ID_FILE3
ID_FILE4 = _StandardID.ID_FILE4
ID_FILE5 = _StandardID.ID_FILE5
ID_FILE6 = _StandardID.ID_FILE6
ID_FILE7 = _StandardID.ID_FILE7
ID_FILE8 = _StandardID.ID_FILE8
ID_FILE9 = _StandardID.ID_FILE9
ID_OK = _StandardID.ID_OK
ID_CANCEL = _StandardID.ID_CANCEL
ID_APPLY = _StandardID.ID_APPLY
ID_YES = _StandardID.ID_YES
ID_NO = _StandardID.ID_NO
ID_STATIC = _StandardID.ID_STATIC
ID_FORWARD = _StandardID.ID_FORWARD
ID_BACKWARD = _StandardID.ID_BACKWARD
ID_DEFAULT = _StandardID.ID_DEFAULT
ID_MORE = _StandardID.ID_MORE
ID_SETUP = _StandardID.ID_SETUP
ID_RESET = _StandardID.ID_RESET
ID_CONTEXT_HELP = _StandardID.ID_CONTEXT_HELP
ID_YESTOALL = _StandardID.ID_YESTOALL
ID_NOTOALL = _StandardID.ID_NOTOALL
ID_ABORT = _StandardID.ID_ABORT
ID_RETRY = _StandardID.ID_RETRY
ID_IGNORE = _StandardID.ID_IGNORE
ID_ADD = _StandardID.ID_ADD
ID_REMOVE = _StandardID.ID_REMOVE
ID_UP = _StandardID.ID_UP
ID_DOWN = _StandardID.ID_DOWN
ID_HOME = _StandardID.ID_HOME
ID_REFRESH = _StandardID.ID_REFRESH
ID_STOP = _StandardID.ID_STOP
ID_INDEX = _StandardID.ID_INDEX
ID_BOLD = _StandardID.ID_BOLD
ID_ITALIC = _StandardID.ID_ITALIC
ID_JUSTIFY_CENTER = _StandardID.ID_JUSTIFY_CENTER
ID_JUSTIFY_FILL = _StandardID.ID_JUSTIFY_FILL
ID_JUSTIFY_RIGHT = _StandardID.ID_JUSTIFY_RIGHT
ID_JUSTIFY_LEFT = _StandardID.ID_JUSTIFY_LEFT
ID_UNDERLINE = _StandardID.ID_UNDERLINE
ID_INDENT = _StandardID.ID_INDENT
ID_UNINDENT = _StandardID.ID_UNINDENT
ID_ZOOM_100 = _StandardID.ID_ZOOM_100
ID_ZOOM_FIT = _StandardID.ID_ZOOM_FIT
ID_ZOOM_IN = _StandardID.ID_ZOOM_IN
ID_ZOOM_OUT = _StandardID.ID_ZOOM_OUT
ID_UNDELETE = _StandardID.ID_UNDELETE
ID_REVERT_TO_SAVED = _StandardID.ID_REVERT_TO_SAVED
ID_CDROM = _StandardID.ID_CDROM
ID_CONVERT = _StandardID.ID_CONVERT
ID_EXECUTE = _StandardID.ID_EXECUTE
ID_FLOPPY = _StandardID.ID_FLOPPY
ID_HARDDISK = _StandardID.ID_HARDDISK
ID_BOTTOM = _StandardID.ID_BOTTOM
ID_FIRST = _StandardID.ID_FIRST
ID_LAST = _StandardID.ID_LAST
ID_TOP = _StandardID.ID_TOP
ID_INFO = _StandardID.ID_INFO
ID_JUMP_TO = _StandardID.ID_JUMP_TO
ID_NETWORK = _StandardID.ID_NETWORK
ID_SELECT_COLOR = _StandardID.ID_SELECT_COLOR
ID_SELECT_FONT = _StandardID.ID_SELECT_FONT
ID_SORT_ASCENDING = _StandardID.ID_SORT_ASCENDING
ID_SORT_DESCENDING = _StandardID.ID_SORT_DESCENDING
ID_SPELL_CHECK = _StandardID.ID_SPELL_CHECK
ID_STRIKETHROUGH = _StandardID.ID_STRIKETHROUGH
ID_SYSTEM_MENU = _StandardID.ID_SYSTEM_MENU
ID_CLOSE_FRAME = _StandardID.ID_CLOSE_FRAME
ID_MOVE_FRAME = _StandardID.ID_MOVE_FRAME
ID_RESIZE_FRAME = _StandardID.ID_RESIZE_FRAME
ID_MAXIMIZE_FRAME = _StandardID.ID_MAXIMIZE_FRAME
ID_ICONIZE_FRAME = _StandardID.ID_ICONIZE_FRAME
ID_RESTORE_FRAME = _StandardID.ID_RESTORE_FRAME
ID_MDI_WINDOW_FIRST = _StandardID.ID_MDI_WINDOW_FIRST
ID_MDI_WINDOW_CASCADE = _StandardID.ID_MDI_WINDOW_CASCADE
ID_MDI_WINDOW_TILE_HORZ = _StandardID.ID_MDI_WINDOW_TILE_HORZ
ID_MDI_WINDOW_TILE_VERT = _StandardID.ID_MDI_WINDOW_TILE_VERT
ID_MDI_WINDOW_ARRANGE_ICONS = _StandardID.ID_MDI_WINDOW_ARRANGE_ICONS
ID_MDI_WINDOW_PREV = _StandardID.ID_MDI_WINDOW_PREV
ID_MDI_WINDOW_NEXT = _StandardID.ID_MDI_WINDOW_NEXT
ID_MDI_WINDOW_LAST = _StandardID.ID_MDI_WINDOW_LAST
ID_FILEDLGG = _StandardID.ID_FILEDLGG
ID_FILECTRL = _StandardID.ID_FILECTRL
ID_HIGHEST = _StandardID.ID_HIGHEST

class _ItemKind(IntEnum):
    ITEM_SEPARATOR = auto()
    ITEM_NORMAL = auto()
    ITEM_CHECK = auto()
    ITEM_RADIO = auto()
    ITEM_DROPDOWN = auto()
    ITEM_MAX = auto()
ItemKind: TypeAlias = Union[_ItemKind, int]
ITEM_SEPARATOR = _ItemKind.ITEM_SEPARATOR
ITEM_NORMAL = _ItemKind.ITEM_NORMAL
ITEM_CHECK = _ItemKind.ITEM_CHECK
ITEM_RADIO = _ItemKind.ITEM_RADIO
ITEM_DROPDOWN = _ItemKind.ITEM_DROPDOWN
ITEM_MAX = _ItemKind.ITEM_MAX

class _HitTest(IntEnum):
    HT_NOWHERE = auto()
    HT_SCROLLBAR_FIRST = auto()
    HT_SCROLLBAR_ARROW_LINE_1 = auto()
    HT_SCROLLBAR_ARROW_LINE_2 = auto()
    HT_SCROLLBAR_ARROW_PAGE_1 = auto()
    HT_SCROLLBAR_ARROW_PAGE_2 = auto()
    HT_SCROLLBAR_THUMB = auto()
    HT_SCROLLBAR_BAR_1 = auto()
    HT_SCROLLBAR_BAR_2 = auto()
    HT_SCROLLBAR_LAST = auto()
    HT_WINDOW_OUTSIDE = auto()
    HT_WINDOW_INSIDE = auto()
    HT_WINDOW_VERT_SCROLLBAR = auto()
    HT_WINDOW_HORZ_SCROLLBAR = auto()
    HT_WINDOW_CORNER = auto()
    HT_MAX = auto()
HitTest: TypeAlias = Union[_HitTest, int]
HT_NOWHERE = _HitTest.HT_NOWHERE
HT_SCROLLBAR_FIRST = _HitTest.HT_SCROLLBAR_FIRST
HT_SCROLLBAR_ARROW_LINE_1 = _HitTest.HT_SCROLLBAR_ARROW_LINE_1
HT_SCROLLBAR_ARROW_LINE_2 = _HitTest.HT_SCROLLBAR_ARROW_LINE_2
HT_SCROLLBAR_ARROW_PAGE_1 = _HitTest.HT_SCROLLBAR_ARROW_PAGE_1
HT_SCROLLBAR_ARROW_PAGE_2 = _HitTest.HT_SCROLLBAR_ARROW_PAGE_2
HT_SCROLLBAR_THUMB = _HitTest.HT_SCROLLBAR_THUMB
HT_SCROLLBAR_BAR_1 = _HitTest.HT_SCROLLBAR_BAR_1
HT_SCROLLBAR_BAR_2 = _HitTest.HT_SCROLLBAR_BAR_2
HT_SCROLLBAR_LAST = _HitTest.HT_SCROLLBAR_LAST
HT_WINDOW_OUTSIDE = _HitTest.HT_WINDOW_OUTSIDE
HT_WINDOW_INSIDE = _HitTest.HT_WINDOW_INSIDE
HT_WINDOW_VERT_SCROLLBAR = _HitTest.HT_WINDOW_VERT_SCROLLBAR
HT_WINDOW_HORZ_SCROLLBAR = _HitTest.HT_WINDOW_HORZ_SCROLLBAR
HT_WINDOW_CORNER = _HitTest.HT_WINDOW_CORNER
HT_MAX = _HitTest.HT_MAX

class _DataFormatId(IntEnum):
    DF_INVALID = auto()
    DF_TEXT = auto()
    DF_BITMAP = auto()
    DF_METAFILE = auto()
    DF_SYLK = auto()
    DF_DIF = auto()
    DF_TIFF = auto()
    DF_OEMTEXT = auto()
    DF_DIB = auto()
    DF_PALETTE = auto()
    DF_PENDATA = auto()
    DF_RIFF = auto()
    DF_WAVE = auto()
    DF_UNICODETEXT = auto()
    DF_ENHMETAFILE = auto()
    DF_FILENAME = auto()
    DF_LOCALE = auto()
    DF_PRIVATE = auto()
    DF_HTML = auto()
    DF_PNG = auto()
    DF_MAX = auto()
DataFormatId: TypeAlias = Union[_DataFormatId, int]
DF_INVALID = _DataFormatId.DF_INVALID
DF_TEXT = _DataFormatId.DF_TEXT
DF_BITMAP = _DataFormatId.DF_BITMAP
DF_METAFILE = _DataFormatId.DF_METAFILE
DF_SYLK = _DataFormatId.DF_SYLK
DF_DIF = _DataFormatId.DF_DIF
DF_TIFF = _DataFormatId.DF_TIFF
DF_OEMTEXT = _DataFormatId.DF_OEMTEXT
DF_DIB = _DataFormatId.DF_DIB
DF_PALETTE = _DataFormatId.DF_PALETTE
DF_PENDATA = _DataFormatId.DF_PENDATA
DF_RIFF = _DataFormatId.DF_RIFF
DF_WAVE = _DataFormatId.DF_WAVE
DF_UNICODETEXT = _DataFormatId.DF_UNICODETEXT
DF_ENHMETAFILE = _DataFormatId.DF_ENHMETAFILE
DF_FILENAME = _DataFormatId.DF_FILENAME
DF_LOCALE = _DataFormatId.DF_LOCALE
DF_PRIVATE = _DataFormatId.DF_PRIVATE
DF_HTML = _DataFormatId.DF_HTML
DF_PNG = _DataFormatId.DF_PNG
DF_MAX = _DataFormatId.DF_MAX

class _KeyCode(IntEnum):
    WXK_NONE = auto()
    WXK_CONTROL_A = auto()
    WXK_CONTROL_B = auto()
    WXK_CONTROL_C = auto()
    WXK_CONTROL_D = auto()
    WXK_CONTROL_E = auto()
    WXK_CONTROL_F = auto()
    WXK_CONTROL_G = auto()
    WXK_CONTROL_H = auto()
    WXK_CONTROL_I = auto()
    WXK_CONTROL_J = auto()
    WXK_CONTROL_K = auto()
    WXK_CONTROL_L = auto()
    WXK_CONTROL_M = auto()
    WXK_CONTROL_N = auto()
    WXK_CONTROL_O = auto()
    WXK_CONTROL_P = auto()
    WXK_CONTROL_Q = auto()
    WXK_CONTROL_R = auto()
    WXK_CONTROL_S = auto()
    WXK_CONTROL_T = auto()
    WXK_CONTROL_U = auto()
    WXK_CONTROL_V = auto()
    WXK_CONTROL_W = auto()
    WXK_CONTROL_X = auto()
    WXK_CONTROL_Y = auto()
    WXK_CONTROL_Z = auto()
    WXK_BACK = auto()
    WXK_TAB = auto()
    WXK_RETURN = auto()
    WXK_ESCAPE = auto()
    WXK_SPACE = auto()
    WXK_DELETE = auto()
    WXK_START = auto()
    WXK_LBUTTON = auto()
    WXK_RBUTTON = auto()
    WXK_CANCEL = auto()
    WXK_MBUTTON = auto()
    WXK_CLEAR = auto()
    WXK_SHIFT = auto()
    WXK_ALT = auto()
    WXK_CONTROL = auto()
    WXK_RAW_CONTROL = auto()
    WXK_MENU = auto()
    WXK_PAUSE = auto()
    WXK_CAPITAL = auto()
    WXK_END = auto()
    WXK_HOME = auto()
    WXK_LEFT = auto()
    WXK_UP = auto()
    WXK_RIGHT = auto()
    WXK_DOWN = auto()
    WXK_SELECT = auto()
    WXK_PRINT = auto()
    WXK_EXECUTE = auto()
    WXK_SNAPSHOT = auto()
    WXK_INSERT = auto()
    WXK_HELP = auto()
    WXK_NUMPAD0 = auto()
    WXK_NUMPAD1 = auto()
    WXK_NUMPAD2 = auto()
    WXK_NUMPAD3 = auto()
    WXK_NUMPAD4 = auto()
    WXK_NUMPAD5 = auto()
    WXK_NUMPAD6 = auto()
    WXK_NUMPAD7 = auto()
    WXK_NUMPAD8 = auto()
    WXK_NUMPAD9 = auto()
    WXK_MULTIPLY = auto()
    WXK_ADD = auto()
    WXK_SEPARATOR = auto()
    WXK_SUBTRACT = auto()
    WXK_DECIMAL = auto()
    WXK_DIVIDE = auto()
    WXK_F1 = auto()
    WXK_F2 = auto()
    WXK_F3 = auto()
    WXK_F4 = auto()
    WXK_F5 = auto()
    WXK_F6 = auto()
    WXK_F7 = auto()
    WXK_F8 = auto()
    WXK_F9 = auto()
    WXK_F10 = auto()
    WXK_F11 = auto()
    WXK_F12 = auto()
    WXK_F13 = auto()
    WXK_F14 = auto()
    WXK_F15 = auto()
    WXK_F16 = auto()
    WXK_F17 = auto()
    WXK_F18 = auto()
    WXK_F19 = auto()
    WXK_F20 = auto()
    WXK_F21 = auto()
    WXK_F22 = auto()
    WXK_F23 = auto()
    WXK_F24 = auto()
    WXK_NUMLOCK = auto()
    WXK_SCROLL = auto()
    WXK_PAGEUP = auto()
    WXK_PAGEDOWN = auto()
    WXK_NUMPAD_SPACE = auto()
    WXK_NUMPAD_TAB = auto()
    WXK_NUMPAD_ENTER = auto()
    WXK_NUMPAD_F1 = auto()
    WXK_NUMPAD_F2 = auto()
    WXK_NUMPAD_F3 = auto()
    WXK_NUMPAD_F4 = auto()
    WXK_NUMPAD_HOME = auto()
    WXK_NUMPAD_LEFT = auto()
    WXK_NUMPAD_UP = auto()
    WXK_NUMPAD_RIGHT = auto()
    WXK_NUMPAD_DOWN = auto()
    WXK_NUMPAD_PAGEUP = auto()
    WXK_NUMPAD_PAGEDOWN = auto()
    WXK_NUMPAD_END = auto()
    WXK_NUMPAD_BEGIN = auto()
    WXK_NUMPAD_INSERT = auto()
    WXK_NUMPAD_DELETE = auto()
    WXK_NUMPAD_EQUAL = auto()
    WXK_NUMPAD_MULTIPLY = auto()
    WXK_NUMPAD_ADD = auto()
    WXK_NUMPAD_SEPARATOR = auto()
    WXK_NUMPAD_SUBTRACT = auto()
    WXK_NUMPAD_DECIMAL = auto()
    WXK_NUMPAD_DIVIDE = auto()
    WXK_WINDOWS_LEFT = auto()
    WXK_WINDOWS_RIGHT = auto()
    WXK_WINDOWS_MENU = auto()
    WXK_COMMAND = auto()
    WXK_SPECIAL1 = auto()
    WXK_SPECIAL2 = auto()
    WXK_SPECIAL3 = auto()
    WXK_SPECIAL4 = auto()
    WXK_SPECIAL5 = auto()
    WXK_SPECIAL6 = auto()
    WXK_SPECIAL7 = auto()
    WXK_SPECIAL8 = auto()
    WXK_SPECIAL9 = auto()
    WXK_SPECIAL10 = auto()
    WXK_SPECIAL11 = auto()
    WXK_SPECIAL12 = auto()
    WXK_SPECIAL13 = auto()
    WXK_SPECIAL14 = auto()
    WXK_SPECIAL15 = auto()
    WXK_SPECIAL16 = auto()
    WXK_SPECIAL17 = auto()
    WXK_SPECIAL18 = auto()
    WXK_SPECIAL19 = auto()
    WXK_SPECIAL20 = auto()
    WXK_BROWSER_BACK = auto()
    WXK_BROWSER_FORWARD = auto()
    WXK_BROWSER_REFRESH = auto()
    WXK_BROWSER_STOP = auto()
    WXK_BROWSER_SEARCH = auto()
    WXK_BROWSER_FAVORITES = auto()
    WXK_BROWSER_HOME = auto()
    WXK_VOLUME_MUTE = auto()
    WXK_VOLUME_DOWN = auto()
    WXK_VOLUME_UP = auto()
    WXK_MEDIA_NEXT_TRACK = auto()
    WXK_MEDIA_PREV_TRACK = auto()
    WXK_MEDIA_STOP = auto()
    WXK_MEDIA_PLAY_PAUSE = auto()
    WXK_LAUNCH_MAIL = auto()
    WXK_LAUNCH_APP1 = auto()
    WXK_LAUNCH_APP2 = auto()
    WXK_LAUNCH_0 = auto()
    WXK_LAUNCH_1 = auto()
    WXK_LAUNCH_2 = auto()
    WXK_LAUNCH_3 = auto()
    WXK_LAUNCH_4 = auto()
    WXK_LAUNCH_5 = auto()
    WXK_LAUNCH_6 = auto()
    WXK_LAUNCH_7 = auto()
    WXK_LAUNCH_8 = auto()
    WXK_LAUNCH_9 = auto()
    WXK_LAUNCH_A = auto()
    WXK_LAUNCH_B = auto()
    WXK_LAUNCH_C = auto()
    WXK_LAUNCH_D = auto()
    WXK_LAUNCH_E = auto()
    WXK_LAUNCH_F = auto()
KeyCode: TypeAlias = Union[_KeyCode, int]
WXK_NONE = _KeyCode.WXK_NONE
WXK_CONTROL_A = _KeyCode.WXK_CONTROL_A
WXK_CONTROL_B = _KeyCode.WXK_CONTROL_B
WXK_CONTROL_C = _KeyCode.WXK_CONTROL_C
WXK_CONTROL_D = _KeyCode.WXK_CONTROL_D
WXK_CONTROL_E = _KeyCode.WXK_CONTROL_E
WXK_CONTROL_F = _KeyCode.WXK_CONTROL_F
WXK_CONTROL_G = _KeyCode.WXK_CONTROL_G
WXK_CONTROL_H = _KeyCode.WXK_CONTROL_H
WXK_CONTROL_I = _KeyCode.WXK_CONTROL_I
WXK_CONTROL_J = _KeyCode.WXK_CONTROL_J
WXK_CONTROL_K = _KeyCode.WXK_CONTROL_K
WXK_CONTROL_L = _KeyCode.WXK_CONTROL_L
WXK_CONTROL_M = _KeyCode.WXK_CONTROL_M
WXK_CONTROL_N = _KeyCode.WXK_CONTROL_N
WXK_CONTROL_O = _KeyCode.WXK_CONTROL_O
WXK_CONTROL_P = _KeyCode.WXK_CONTROL_P
WXK_CONTROL_Q = _KeyCode.WXK_CONTROL_Q
WXK_CONTROL_R = _KeyCode.WXK_CONTROL_R
WXK_CONTROL_S = _KeyCode.WXK_CONTROL_S
WXK_CONTROL_T = _KeyCode.WXK_CONTROL_T
WXK_CONTROL_U = _KeyCode.WXK_CONTROL_U
WXK_CONTROL_V = _KeyCode.WXK_CONTROL_V
WXK_CONTROL_W = _KeyCode.WXK_CONTROL_W
WXK_CONTROL_X = _KeyCode.WXK_CONTROL_X
WXK_CONTROL_Y = _KeyCode.WXK_CONTROL_Y
WXK_CONTROL_Z = _KeyCode.WXK_CONTROL_Z
WXK_BACK = _KeyCode.WXK_BACK
WXK_TAB = _KeyCode.WXK_TAB
WXK_RETURN = _KeyCode.WXK_RETURN
WXK_ESCAPE = _KeyCode.WXK_ESCAPE
WXK_SPACE = _KeyCode.WXK_SPACE
WXK_DELETE = _KeyCode.WXK_DELETE
WXK_START = _KeyCode.WXK_START
WXK_LBUTTON = _KeyCode.WXK_LBUTTON
WXK_RBUTTON = _KeyCode.WXK_RBUTTON
WXK_CANCEL = _KeyCode.WXK_CANCEL
WXK_MBUTTON = _KeyCode.WXK_MBUTTON
WXK_CLEAR = _KeyCode.WXK_CLEAR
WXK_SHIFT = _KeyCode.WXK_SHIFT
WXK_ALT = _KeyCode.WXK_ALT
WXK_CONTROL = _KeyCode.WXK_CONTROL
WXK_RAW_CONTROL = _KeyCode.WXK_RAW_CONTROL
WXK_MENU = _KeyCode.WXK_MENU
WXK_PAUSE = _KeyCode.WXK_PAUSE
WXK_CAPITAL = _KeyCode.WXK_CAPITAL
WXK_END = _KeyCode.WXK_END
WXK_HOME = _KeyCode.WXK_HOME
WXK_LEFT = _KeyCode.WXK_LEFT
WXK_UP = _KeyCode.WXK_UP
WXK_RIGHT = _KeyCode.WXK_RIGHT
WXK_DOWN = _KeyCode.WXK_DOWN
WXK_SELECT = _KeyCode.WXK_SELECT
WXK_PRINT = _KeyCode.WXK_PRINT
WXK_EXECUTE = _KeyCode.WXK_EXECUTE
WXK_SNAPSHOT = _KeyCode.WXK_SNAPSHOT
WXK_INSERT = _KeyCode.WXK_INSERT
WXK_HELP = _KeyCode.WXK_HELP
WXK_NUMPAD0 = _KeyCode.WXK_NUMPAD0
WXK_NUMPAD1 = _KeyCode.WXK_NUMPAD1
WXK_NUMPAD2 = _KeyCode.WXK_NUMPAD2
WXK_NUMPAD3 = _KeyCode.WXK_NUMPAD3
WXK_NUMPAD4 = _KeyCode.WXK_NUMPAD4
WXK_NUMPAD5 = _KeyCode.WXK_NUMPAD5
WXK_NUMPAD6 = _KeyCode.WXK_NUMPAD6
WXK_NUMPAD7 = _KeyCode.WXK_NUMPAD7
WXK_NUMPAD8 = _KeyCode.WXK_NUMPAD8
WXK_NUMPAD9 = _KeyCode.WXK_NUMPAD9
WXK_MULTIPLY = _KeyCode.WXK_MULTIPLY
WXK_ADD = _KeyCode.WXK_ADD
WXK_SEPARATOR = _KeyCode.WXK_SEPARATOR
WXK_SUBTRACT = _KeyCode.WXK_SUBTRACT
WXK_DECIMAL = _KeyCode.WXK_DECIMAL
WXK_DIVIDE = _KeyCode.WXK_DIVIDE
WXK_F1 = _KeyCode.WXK_F1
WXK_F2 = _KeyCode.WXK_F2
WXK_F3 = _KeyCode.WXK_F3
WXK_F4 = _KeyCode.WXK_F4
WXK_F5 = _KeyCode.WXK_F5
WXK_F6 = _KeyCode.WXK_F6
WXK_F7 = _KeyCode.WXK_F7
WXK_F8 = _KeyCode.WXK_F8
WXK_F9 = _KeyCode.WXK_F9
WXK_F10 = _KeyCode.WXK_F10
WXK_F11 = _KeyCode.WXK_F11
WXK_F12 = _KeyCode.WXK_F12
WXK_F13 = _KeyCode.WXK_F13
WXK_F14 = _KeyCode.WXK_F14
WXK_F15 = _KeyCode.WXK_F15
WXK_F16 = _KeyCode.WXK_F16
WXK_F17 = _KeyCode.WXK_F17
WXK_F18 = _KeyCode.WXK_F18
WXK_F19 = _KeyCode.WXK_F19
WXK_F20 = _KeyCode.WXK_F20
WXK_F21 = _KeyCode.WXK_F21
WXK_F22 = _KeyCode.WXK_F22
WXK_F23 = _KeyCode.WXK_F23
WXK_F24 = _KeyCode.WXK_F24
WXK_NUMLOCK = _KeyCode.WXK_NUMLOCK
WXK_SCROLL = _KeyCode.WXK_SCROLL
WXK_PAGEUP = _KeyCode.WXK_PAGEUP
WXK_PAGEDOWN = _KeyCode.WXK_PAGEDOWN
WXK_NUMPAD_SPACE = _KeyCode.WXK_NUMPAD_SPACE
WXK_NUMPAD_TAB = _KeyCode.WXK_NUMPAD_TAB
WXK_NUMPAD_ENTER = _KeyCode.WXK_NUMPAD_ENTER
WXK_NUMPAD_F1 = _KeyCode.WXK_NUMPAD_F1
WXK_NUMPAD_F2 = _KeyCode.WXK_NUMPAD_F2
WXK_NUMPAD_F3 = _KeyCode.WXK_NUMPAD_F3
WXK_NUMPAD_F4 = _KeyCode.WXK_NUMPAD_F4
WXK_NUMPAD_HOME = _KeyCode.WXK_NUMPAD_HOME
WXK_NUMPAD_LEFT = _KeyCode.WXK_NUMPAD_LEFT
WXK_NUMPAD_UP = _KeyCode.WXK_NUMPAD_UP
WXK_NUMPAD_RIGHT = _KeyCode.WXK_NUMPAD_RIGHT
WXK_NUMPAD_DOWN = _KeyCode.WXK_NUMPAD_DOWN
WXK_NUMPAD_PAGEUP = _KeyCode.WXK_NUMPAD_PAGEUP
WXK_NUMPAD_PAGEDOWN = _KeyCode.WXK_NUMPAD_PAGEDOWN
WXK_NUMPAD_END = _KeyCode.WXK_NUMPAD_END
WXK_NUMPAD_BEGIN = _KeyCode.WXK_NUMPAD_BEGIN
WXK_NUMPAD_INSERT = _KeyCode.WXK_NUMPAD_INSERT
WXK_NUMPAD_DELETE = _KeyCode.WXK_NUMPAD_DELETE
WXK_NUMPAD_EQUAL = _KeyCode.WXK_NUMPAD_EQUAL
WXK_NUMPAD_MULTIPLY = _KeyCode.WXK_NUMPAD_MULTIPLY
WXK_NUMPAD_ADD = _KeyCode.WXK_NUMPAD_ADD
WXK_NUMPAD_SEPARATOR = _KeyCode.WXK_NUMPAD_SEPARATOR
WXK_NUMPAD_SUBTRACT = _KeyCode.WXK_NUMPAD_SUBTRACT
WXK_NUMPAD_DECIMAL = _KeyCode.WXK_NUMPAD_DECIMAL
WXK_NUMPAD_DIVIDE = _KeyCode.WXK_NUMPAD_DIVIDE
WXK_WINDOWS_LEFT = _KeyCode.WXK_WINDOWS_LEFT
WXK_WINDOWS_RIGHT = _KeyCode.WXK_WINDOWS_RIGHT
WXK_WINDOWS_MENU = _KeyCode.WXK_WINDOWS_MENU
WXK_COMMAND = _KeyCode.WXK_COMMAND
WXK_SPECIAL1 = _KeyCode.WXK_SPECIAL1
WXK_SPECIAL2 = _KeyCode.WXK_SPECIAL2
WXK_SPECIAL3 = _KeyCode.WXK_SPECIAL3
WXK_SPECIAL4 = _KeyCode.WXK_SPECIAL4
WXK_SPECIAL5 = _KeyCode.WXK_SPECIAL5
WXK_SPECIAL6 = _KeyCode.WXK_SPECIAL6
WXK_SPECIAL7 = _KeyCode.WXK_SPECIAL7
WXK_SPECIAL8 = _KeyCode.WXK_SPECIAL8
WXK_SPECIAL9 = _KeyCode.WXK_SPECIAL9
WXK_SPECIAL10 = _KeyCode.WXK_SPECIAL10
WXK_SPECIAL11 = _KeyCode.WXK_SPECIAL11
WXK_SPECIAL12 = _KeyCode.WXK_SPECIAL12
WXK_SPECIAL13 = _KeyCode.WXK_SPECIAL13
WXK_SPECIAL14 = _KeyCode.WXK_SPECIAL14
WXK_SPECIAL15 = _KeyCode.WXK_SPECIAL15
WXK_SPECIAL16 = _KeyCode.WXK_SPECIAL16
WXK_SPECIAL17 = _KeyCode.WXK_SPECIAL17
WXK_SPECIAL18 = _KeyCode.WXK_SPECIAL18
WXK_SPECIAL19 = _KeyCode.WXK_SPECIAL19
WXK_SPECIAL20 = _KeyCode.WXK_SPECIAL20
WXK_BROWSER_BACK = _KeyCode.WXK_BROWSER_BACK
WXK_BROWSER_FORWARD = _KeyCode.WXK_BROWSER_FORWARD
WXK_BROWSER_REFRESH = _KeyCode.WXK_BROWSER_REFRESH
WXK_BROWSER_STOP = _KeyCode.WXK_BROWSER_STOP
WXK_BROWSER_SEARCH = _KeyCode.WXK_BROWSER_SEARCH
WXK_BROWSER_FAVORITES = _KeyCode.WXK_BROWSER_FAVORITES
WXK_BROWSER_HOME = _KeyCode.WXK_BROWSER_HOME
WXK_VOLUME_MUTE = _KeyCode.WXK_VOLUME_MUTE
WXK_VOLUME_DOWN = _KeyCode.WXK_VOLUME_DOWN
WXK_VOLUME_UP = _KeyCode.WXK_VOLUME_UP
WXK_MEDIA_NEXT_TRACK = _KeyCode.WXK_MEDIA_NEXT_TRACK
WXK_MEDIA_PREV_TRACK = _KeyCode.WXK_MEDIA_PREV_TRACK
WXK_MEDIA_STOP = _KeyCode.WXK_MEDIA_STOP
WXK_MEDIA_PLAY_PAUSE = _KeyCode.WXK_MEDIA_PLAY_PAUSE
WXK_LAUNCH_MAIL = _KeyCode.WXK_LAUNCH_MAIL
WXK_LAUNCH_APP1 = _KeyCode.WXK_LAUNCH_APP1
WXK_LAUNCH_APP2 = _KeyCode.WXK_LAUNCH_APP2
WXK_LAUNCH_0 = _KeyCode.WXK_LAUNCH_0
WXK_LAUNCH_1 = _KeyCode.WXK_LAUNCH_1
WXK_LAUNCH_2 = _KeyCode.WXK_LAUNCH_2
WXK_LAUNCH_3 = _KeyCode.WXK_LAUNCH_3
WXK_LAUNCH_4 = _KeyCode.WXK_LAUNCH_4
WXK_LAUNCH_5 = _KeyCode.WXK_LAUNCH_5
WXK_LAUNCH_6 = _KeyCode.WXK_LAUNCH_6
WXK_LAUNCH_7 = _KeyCode.WXK_LAUNCH_7
WXK_LAUNCH_8 = _KeyCode.WXK_LAUNCH_8
WXK_LAUNCH_9 = _KeyCode.WXK_LAUNCH_9
WXK_LAUNCH_A = _KeyCode.WXK_LAUNCH_A
WXK_LAUNCH_B = _KeyCode.WXK_LAUNCH_B
WXK_LAUNCH_C = _KeyCode.WXK_LAUNCH_C
WXK_LAUNCH_D = _KeyCode.WXK_LAUNCH_D
WXK_LAUNCH_E = _KeyCode.WXK_LAUNCH_E
WXK_LAUNCH_F = _KeyCode.WXK_LAUNCH_F

class _KeyModifier(IntEnum):
    MOD_NONE = auto()
    MOD_ALT = auto()
    MOD_CONTROL = auto()
    MOD_ALTGR = auto()
    MOD_SHIFT = auto()
    MOD_META = auto()
    MOD_WIN = auto()
    MOD_RAW_CONTROL = auto()
    MOD_CMD = auto()
    MOD_ALL = auto()
KeyModifier: TypeAlias = Union[_KeyModifier, int]
MOD_NONE = _KeyModifier.MOD_NONE
MOD_ALT = _KeyModifier.MOD_ALT
MOD_CONTROL = _KeyModifier.MOD_CONTROL
MOD_ALTGR = _KeyModifier.MOD_ALTGR
MOD_SHIFT = _KeyModifier.MOD_SHIFT
MOD_META = _KeyModifier.MOD_META
MOD_WIN = _KeyModifier.MOD_WIN
MOD_RAW_CONTROL = _KeyModifier.MOD_RAW_CONTROL
MOD_CMD = _KeyModifier.MOD_CMD
MOD_ALL = _KeyModifier.MOD_ALL

class _PaperSize(IntEnum):
    PAPER_10X11 = auto()
    PAPER_10X14 = auto()
    PAPER_11X17 = auto()
    PAPER_12X11 = auto()
    PAPER_15X11 = auto()
    PAPER_9X11 = auto()
    PAPER_A2 = auto()
    PAPER_A3 = auto()
    PAPER_A3_EXTRA = auto()
    PAPER_A3_EXTRA_TRANSVERSE = auto()
    PAPER_A3_ROTATED = auto()
    PAPER_A3_TRANSVERSE = auto()
    PAPER_A4 = auto()
    PAPER_A4SMALL = auto()
    PAPER_A4_EXTRA = auto()
    PAPER_A4_PLUS = auto()
    PAPER_A4_ROTATED = auto()
    PAPER_A4_TRANSVERSE = auto()
    PAPER_A5 = auto()
    PAPER_A5_EXTRA = auto()
    PAPER_A5_ROTATED = auto()
    PAPER_A5_TRANSVERSE = auto()
    PAPER_A6 = auto()
    PAPER_A6_ROTATED = auto()
    PAPER_A_PLUS = auto()
    PAPER_B4 = auto()
    PAPER_B4_JIS_ROTATED = auto()
    PAPER_B5 = auto()
    PAPER_B5_EXTRA = auto()
    PAPER_B5_JIS_ROTATED = auto()
    PAPER_B5_TRANSVERSE = auto()
    PAPER_B6_JIS = auto()
    PAPER_B6_JIS_ROTATED = auto()
    PAPER_B_PLUS = auto()
    PAPER_CSHEET = auto()
    PAPER_DBL_JAPANESE_POSTCARD = auto()
    PAPER_DBL_JAPANESE_POSTCARD_ROTATED = auto()
    PAPER_DSHEET = auto()
    PAPER_ENV_10 = auto()
    PAPER_ENV_11 = auto()
    PAPER_ENV_12 = auto()
    PAPER_ENV_14 = auto()
    PAPER_ENV_9 = auto()
    PAPER_ENV_B4 = auto()
    PAPER_ENV_B5 = auto()
    PAPER_ENV_B6 = auto()
    PAPER_ENV_C3 = auto()
    PAPER_ENV_C4 = auto()
    PAPER_ENV_C5 = auto()
    PAPER_ENV_C6 = auto()
    PAPER_ENV_C65 = auto()
    PAPER_ENV_DL = auto()
    PAPER_ENV_INVITE = auto()
    PAPER_ENV_ITALY = auto()
    PAPER_ENV_MONARCH = auto()
    PAPER_ENV_PERSONAL = auto()
    PAPER_ESHEET = auto()
    PAPER_EXECUTIVE = auto()
    PAPER_FANFOLD_LGL_GERMAN = auto()
    PAPER_FANFOLD_STD_GERMAN = auto()
    PAPER_FANFOLD_US = auto()
    PAPER_FOLIO = auto()
    PAPER_ISO_B4 = auto()
    PAPER_JAPANESE_POSTCARD = auto()
    PAPER_JAPANESE_POSTCARD_ROTATED = auto()
    PAPER_JENV_CHOU3 = auto()
    PAPER_JENV_CHOU3_ROTATED = auto()
    PAPER_JENV_CHOU4 = auto()
    PAPER_JENV_CHOU4_ROTATED = auto()
    PAPER_JENV_KAKU2 = auto()
    PAPER_JENV_KAKU2_ROTATED = auto()
    PAPER_JENV_KAKU3 = auto()
    PAPER_JENV_KAKU3_ROTATED = auto()
    PAPER_JENV_YOU4 = auto()
    PAPER_JENV_YOU4_ROTATED = auto()
    PAPER_LEDGER = auto()
    PAPER_LEGAL = auto()
    PAPER_LEGAL_EXTRA = auto()
    PAPER_LETTER = auto()
    PAPER_LETTERSMALL = auto()
    PAPER_LETTER_EXTRA = auto()
    PAPER_LETTER_EXTRA_TRANSVERSE = auto()
    PAPER_LETTER_PLUS = auto()
    PAPER_LETTER_ROTATED = auto()
    PAPER_LETTER_TRANSVERSE = auto()
    PAPER_NONE = auto()
    PAPER_NOTE = auto()
    PAPER_P16K = auto()
    PAPER_P16K_ROTATED = auto()
    PAPER_P32K = auto()
    PAPER_P32KBIG = auto()
    PAPER_P32KBIG_ROTATED = auto()
    PAPER_P32K_ROTATED = auto()
    PAPER_PENV_1 = auto()
    PAPER_PENV_10 = auto()
    PAPER_PENV_10_ROTATED = auto()
    PAPER_PENV_1_ROTATED = auto()
    PAPER_PENV_2 = auto()
    PAPER_PENV_2_ROTATED = auto()
    PAPER_PENV_3 = auto()
    PAPER_PENV_3_ROTATED = auto()
    PAPER_PENV_4 = auto()
    PAPER_PENV_4_ROTATED = auto()
    PAPER_PENV_5 = auto()
    PAPER_PENV_5_ROTATED = auto()
    PAPER_PENV_6 = auto()
    PAPER_PENV_6_ROTATED = auto()
    PAPER_PENV_7 = auto()
    PAPER_PENV_7_ROTATED = auto()
    PAPER_PENV_8 = auto()
    PAPER_PENV_8_ROTATED = auto()
    PAPER_PENV_9 = auto()
    PAPER_PENV_9_ROTATED = auto()
    PAPER_QUARTO = auto()
    PAPER_STATEMENT = auto()
    PAPER_TABLOID = auto()
    PAPER_TABLOID_EXTRA = auto()
PaperSize: TypeAlias = Union[_PaperSize, int]
PAPER_10X11 = _PaperSize.PAPER_10X11
PAPER_10X14 = _PaperSize.PAPER_10X14
PAPER_11X17 = _PaperSize.PAPER_11X17
PAPER_12X11 = _PaperSize.PAPER_12X11
PAPER_15X11 = _PaperSize.PAPER_15X11
PAPER_9X11 = _PaperSize.PAPER_9X11
PAPER_A2 = _PaperSize.PAPER_A2
PAPER_A3 = _PaperSize.PAPER_A3
PAPER_A3_EXTRA = _PaperSize.PAPER_A3_EXTRA
PAPER_A3_EXTRA_TRANSVERSE = _PaperSize.PAPER_A3_EXTRA_TRANSVERSE
PAPER_A3_ROTATED = _PaperSize.PAPER_A3_ROTATED
PAPER_A3_TRANSVERSE = _PaperSize.PAPER_A3_TRANSVERSE
PAPER_A4 = _PaperSize.PAPER_A4
PAPER_A4SMALL = _PaperSize.PAPER_A4SMALL
PAPER_A4_EXTRA = _PaperSize.PAPER_A4_EXTRA
PAPER_A4_PLUS = _PaperSize.PAPER_A4_PLUS
PAPER_A4_ROTATED = _PaperSize.PAPER_A4_ROTATED
PAPER_A4_TRANSVERSE = _PaperSize.PAPER_A4_TRANSVERSE
PAPER_A5 = _PaperSize.PAPER_A5
PAPER_A5_EXTRA = _PaperSize.PAPER_A5_EXTRA
PAPER_A5_ROTATED = _PaperSize.PAPER_A5_ROTATED
PAPER_A5_TRANSVERSE = _PaperSize.PAPER_A5_TRANSVERSE
PAPER_A6 = _PaperSize.PAPER_A6
PAPER_A6_ROTATED = _PaperSize.PAPER_A6_ROTATED
PAPER_A_PLUS = _PaperSize.PAPER_A_PLUS
PAPER_B4 = _PaperSize.PAPER_B4
PAPER_B4_JIS_ROTATED = _PaperSize.PAPER_B4_JIS_ROTATED
PAPER_B5 = _PaperSize.PAPER_B5
PAPER_B5_EXTRA = _PaperSize.PAPER_B5_EXTRA
PAPER_B5_JIS_ROTATED = _PaperSize.PAPER_B5_JIS_ROTATED
PAPER_B5_TRANSVERSE = _PaperSize.PAPER_B5_TRANSVERSE
PAPER_B6_JIS = _PaperSize.PAPER_B6_JIS
PAPER_B6_JIS_ROTATED = _PaperSize.PAPER_B6_JIS_ROTATED
PAPER_B_PLUS = _PaperSize.PAPER_B_PLUS
PAPER_CSHEET = _PaperSize.PAPER_CSHEET
PAPER_DBL_JAPANESE_POSTCARD = _PaperSize.PAPER_DBL_JAPANESE_POSTCARD
PAPER_DBL_JAPANESE_POSTCARD_ROTATED = _PaperSize.PAPER_DBL_JAPANESE_POSTCARD_ROTATED
PAPER_DSHEET = _PaperSize.PAPER_DSHEET
PAPER_ENV_10 = _PaperSize.PAPER_ENV_10
PAPER_ENV_11 = _PaperSize.PAPER_ENV_11
PAPER_ENV_12 = _PaperSize.PAPER_ENV_12
PAPER_ENV_14 = _PaperSize.PAPER_ENV_14
PAPER_ENV_9 = _PaperSize.PAPER_ENV_9
PAPER_ENV_B4 = _PaperSize.PAPER_ENV_B4
PAPER_ENV_B5 = _PaperSize.PAPER_ENV_B5
PAPER_ENV_B6 = _PaperSize.PAPER_ENV_B6
PAPER_ENV_C3 = _PaperSize.PAPER_ENV_C3
PAPER_ENV_C4 = _PaperSize.PAPER_ENV_C4
PAPER_ENV_C5 = _PaperSize.PAPER_ENV_C5
PAPER_ENV_C6 = _PaperSize.PAPER_ENV_C6
PAPER_ENV_C65 = _PaperSize.PAPER_ENV_C65
PAPER_ENV_DL = _PaperSize.PAPER_ENV_DL
PAPER_ENV_INVITE = _PaperSize.PAPER_ENV_INVITE
PAPER_ENV_ITALY = _PaperSize.PAPER_ENV_ITALY
PAPER_ENV_MONARCH = _PaperSize.PAPER_ENV_MONARCH
PAPER_ENV_PERSONAL = _PaperSize.PAPER_ENV_PERSONAL
PAPER_ESHEET = _PaperSize.PAPER_ESHEET
PAPER_EXECUTIVE = _PaperSize.PAPER_EXECUTIVE
PAPER_FANFOLD_LGL_GERMAN = _PaperSize.PAPER_FANFOLD_LGL_GERMAN
PAPER_FANFOLD_STD_GERMAN = _PaperSize.PAPER_FANFOLD_STD_GERMAN
PAPER_FANFOLD_US = _PaperSize.PAPER_FANFOLD_US
PAPER_FOLIO = _PaperSize.PAPER_FOLIO
PAPER_ISO_B4 = _PaperSize.PAPER_ISO_B4
PAPER_JAPANESE_POSTCARD = _PaperSize.PAPER_JAPANESE_POSTCARD
PAPER_JAPANESE_POSTCARD_ROTATED = _PaperSize.PAPER_JAPANESE_POSTCARD_ROTATED
PAPER_JENV_CHOU3 = _PaperSize.PAPER_JENV_CHOU3
PAPER_JENV_CHOU3_ROTATED = _PaperSize.PAPER_JENV_CHOU3_ROTATED
PAPER_JENV_CHOU4 = _PaperSize.PAPER_JENV_CHOU4
PAPER_JENV_CHOU4_ROTATED = _PaperSize.PAPER_JENV_CHOU4_ROTATED
PAPER_JENV_KAKU2 = _PaperSize.PAPER_JENV_KAKU2
PAPER_JENV_KAKU2_ROTATED = _PaperSize.PAPER_JENV_KAKU2_ROTATED
PAPER_JENV_KAKU3 = _PaperSize.PAPER_JENV_KAKU3
PAPER_JENV_KAKU3_ROTATED = _PaperSize.PAPER_JENV_KAKU3_ROTATED
PAPER_JENV_YOU4 = _PaperSize.PAPER_JENV_YOU4
PAPER_JENV_YOU4_ROTATED = _PaperSize.PAPER_JENV_YOU4_ROTATED
PAPER_LEDGER = _PaperSize.PAPER_LEDGER
PAPER_LEGAL = _PaperSize.PAPER_LEGAL
PAPER_LEGAL_EXTRA = _PaperSize.PAPER_LEGAL_EXTRA
PAPER_LETTER = _PaperSize.PAPER_LETTER
PAPER_LETTERSMALL = _PaperSize.PAPER_LETTERSMALL
PAPER_LETTER_EXTRA = _PaperSize.PAPER_LETTER_EXTRA
PAPER_LETTER_EXTRA_TRANSVERSE = _PaperSize.PAPER_LETTER_EXTRA_TRANSVERSE
PAPER_LETTER_PLUS = _PaperSize.PAPER_LETTER_PLUS
PAPER_LETTER_ROTATED = _PaperSize.PAPER_LETTER_ROTATED
PAPER_LETTER_TRANSVERSE = _PaperSize.PAPER_LETTER_TRANSVERSE
PAPER_NONE = _PaperSize.PAPER_NONE
PAPER_NOTE = _PaperSize.PAPER_NOTE
PAPER_P16K = _PaperSize.PAPER_P16K
PAPER_P16K_ROTATED = _PaperSize.PAPER_P16K_ROTATED
PAPER_P32K = _PaperSize.PAPER_P32K
PAPER_P32KBIG = _PaperSize.PAPER_P32KBIG
PAPER_P32KBIG_ROTATED = _PaperSize.PAPER_P32KBIG_ROTATED
PAPER_P32K_ROTATED = _PaperSize.PAPER_P32K_ROTATED
PAPER_PENV_1 = _PaperSize.PAPER_PENV_1
PAPER_PENV_10 = _PaperSize.PAPER_PENV_10
PAPER_PENV_10_ROTATED = _PaperSize.PAPER_PENV_10_ROTATED
PAPER_PENV_1_ROTATED = _PaperSize.PAPER_PENV_1_ROTATED
PAPER_PENV_2 = _PaperSize.PAPER_PENV_2
PAPER_PENV_2_ROTATED = _PaperSize.PAPER_PENV_2_ROTATED
PAPER_PENV_3 = _PaperSize.PAPER_PENV_3
PAPER_PENV_3_ROTATED = _PaperSize.PAPER_PENV_3_ROTATED
PAPER_PENV_4 = _PaperSize.PAPER_PENV_4
PAPER_PENV_4_ROTATED = _PaperSize.PAPER_PENV_4_ROTATED
PAPER_PENV_5 = _PaperSize.PAPER_PENV_5
PAPER_PENV_5_ROTATED = _PaperSize.PAPER_PENV_5_ROTATED
PAPER_PENV_6 = _PaperSize.PAPER_PENV_6
PAPER_PENV_6_ROTATED = _PaperSize.PAPER_PENV_6_ROTATED
PAPER_PENV_7 = _PaperSize.PAPER_PENV_7
PAPER_PENV_7_ROTATED = _PaperSize.PAPER_PENV_7_ROTATED
PAPER_PENV_8 = _PaperSize.PAPER_PENV_8
PAPER_PENV_8_ROTATED = _PaperSize.PAPER_PENV_8_ROTATED
PAPER_PENV_9 = _PaperSize.PAPER_PENV_9
PAPER_PENV_9_ROTATED = _PaperSize.PAPER_PENV_9_ROTATED
PAPER_QUARTO = _PaperSize.PAPER_QUARTO
PAPER_STATEMENT = _PaperSize.PAPER_STATEMENT
PAPER_TABLOID = _PaperSize.PAPER_TABLOID
PAPER_TABLOID_EXTRA = _PaperSize.PAPER_TABLOID_EXTRA

class _PrintOrientation(IntEnum):
    PORTRAIT = auto()
    LANDSCAPE = auto()
PrintOrientation: TypeAlias = Union[_PrintOrientation, int]
PORTRAIT = _PrintOrientation.PORTRAIT
LANDSCAPE = _PrintOrientation.LANDSCAPE

class _DuplexMode(IntEnum):
    DUPLEX_SIMPLEX = auto()
    DUPLEX_HORIZONTAL = auto()
    DUPLEX_VERTICAL = auto()
DuplexMode: TypeAlias = Union[_DuplexMode, int]
DUPLEX_SIMPLEX = _DuplexMode.DUPLEX_SIMPLEX
DUPLEX_HORIZONTAL = _DuplexMode.DUPLEX_HORIZONTAL
DUPLEX_VERTICAL = _DuplexMode.DUPLEX_VERTICAL

class _PrintMode(IntEnum):
    PRINT_MODE_NONE = auto()
    PRINT_MODE_PREVIEW = auto()
    PRINT_MODE_FILE = auto()
    PRINT_MODE_PRINTER = auto()
    PRINT_MODE_STREAM = auto()
PrintMode: TypeAlias = Union[_PrintMode, int]
PRINT_MODE_NONE = _PrintMode.PRINT_MODE_NONE
PRINT_MODE_PREVIEW = _PrintMode.PRINT_MODE_PREVIEW
PRINT_MODE_FILE = _PrintMode.PRINT_MODE_FILE
PRINT_MODE_PRINTER = _PrintMode.PRINT_MODE_PRINTER
PRINT_MODE_STREAM = _PrintMode.PRINT_MODE_STREAM

class _UpdateUI(IntEnum):
    UPDATE_UI_NONE = auto()
    UPDATE_UI_RECURSE = auto()
    UPDATE_UI_FROMIDLE = auto()
UpdateUI: TypeAlias = Union[_UpdateUI, int]
UPDATE_UI_NONE = _UpdateUI.UPDATE_UI_NONE
UPDATE_UI_RECURSE = _UpdateUI.UPDATE_UI_RECURSE
UPDATE_UI_FROMIDLE = _UpdateUI.UPDATE_UI_FROMIDLE
DefaultCoord: int
WARN_UNUSED: int

class _TextFileType(IntEnum):
    TextFileType_None = auto()
    TextFileType_Unix = auto()
    TextFileType_Dos = auto()
    TextFileType_Mac = auto()
    TextFileType_Os2 = auto()
TextFileType: TypeAlias = Union[_TextFileType, int]
TextFileType_None = _TextFileType.TextFileType_None
TextFileType_Unix = _TextFileType.TextFileType_Unix
TextFileType_Dos = _TextFileType.TextFileType_Dos
TextFileType_Mac = _TextFileType.TextFileType_Mac
TextFileType_Os2 = _TextFileType.TextFileType_Os2

BG_STYLE_CUSTOM = BG_STYLE_PAINT

ADJUST_MINSIZE = 0

WS_EX_VALIDATE_RECURSIVELY = 0
#-- end-defs --#
#-- begin-debug --#

def Abort() -> None:    """
    Abort() -> None
    
    Exits the program immediately.
    """

def DisableAsserts() -> None:    """
    DisableAsserts() -> None
    
    Disable the condition checks in the assertions.
    """

def Trap() -> None:    """
    Trap() -> None
    
    Generate a debugger exception meaning that the control is passed to
    the debugger if one is attached to the process.
    """
#-- end-debug --#
#-- begin-object --#

class RefCounter:
    """
    RefCounter() -> None
    
    This class is used to manage reference-counting providing a simple
    interface and a counter.
    """

    def __init__(self) -> None:
        """
        RefCounter() -> None
        
        This class is used to manage reference-counting providing a simple
        interface and a counter.
        """

    def DecRef(self) -> None:
        """
        DecRef() -> None
        
        Decrements the reference count associated with this shared data and,
        if it reaches zero, destroys this instance of wxRefCounter releasing
        its memory.
        """

    def GetRefCount(self) -> int:
        """
        GetRefCount() -> int
        
        Returns the reference count associated with this shared data.
        """

    def IncRef(self) -> None:
        """
        IncRef() -> None
        
        Increments the reference count associated with this shared data.
        """
    @property
    def RefCount(self) -> int: ...
# end of class RefCounter


class Object:
    """
    Object() -> None
    Object(other) -> None
    
    This is the root class of many of the wxWidgets classes.
    """

    @overload
    def __init__(self, other: Object) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Object() -> None
        Object(other) -> None
        
        This is the root class of many of the wxWidgets classes.
        """

    def GetClassInfo(self) -> ClassInfo:
        """
        GetClassInfo() -> ClassInfo
        
        This virtual function is redefined for every class that requires run-
        time type information, when using the wxDECLARE_CLASS macro (or
        similar).
        """

    def GetRefData(self) -> ObjectRefData:
        """
        GetRefData() -> ObjectRefData
        
        Returns the wxObject::m_refData pointer, i.e. the data referenced by
        this object.
        """

    def IsSameAs(self, obj: Object) -> bool:
        """
        IsSameAs(obj) -> bool
        
        Returns true if this object has the same data pointer as obj.
        """

    def Ref(self, clone: Object) -> None:
        """
        Ref(clone) -> None
        
        Makes this object refer to the data in clone.
        """

    def SetRefData(self, data: ObjectRefData) -> None:
        """
        SetRefData(data) -> None
        
        Sets the wxObject::m_refData pointer.
        """

    def UnRef(self) -> None:
        """
        UnRef() -> None
        
        Decrements the reference count in the associated data, and if it is
        zero, deletes the data.
        """

    def UnShare(self) -> None:
        """
        UnShare() -> None
        
        This is the same of AllocExclusive() but this method is public.
        """

    def GetClassName(self) -> str:
        """
        GetClassName() -> str
        
        Returns the class name of the C++ class using wxRTTI.
        """

    def Destroy(self) -> None:
        """
        Destroy() -> None
        
        Deletes the C++ object this Python object is a proxy for.
        """
    @property
    def ClassInfo(self) -> ClassInfo: ...
    @property
    def ClassName(self) -> str: ...
    @property
    def RefData(self) -> ObjectRefData: ...
    @RefData.setter
    def RefData(self, value: ObjectRefData, /) -> None: ...
# end of class Object


class ClassInfo:
    """
    This class stores meta-information about classes.
    """

    def CreateObject(self) -> Object:
        """
        CreateObject() -> Object
        
        Creates an object of the appropriate kind.
        """

    def GetBaseClassName1(self) -> str:
        """
        GetBaseClassName1() -> str
        
        Returns the name of the first base class (NULL if none).
        """

    def GetBaseClassName2(self) -> str:
        """
        GetBaseClassName2() -> str
        
        Returns the name of the second base class (NULL if none).
        """

    def GetClassName(self) -> str:
        """
        GetClassName() -> str
        
        Returns the string form of the class name.
        """

    def GetSize(self) -> int:
        """
        GetSize() -> int
        
        Returns the size of the class.
        """

    def IsDynamic(self) -> bool:
        """
        IsDynamic() -> bool
        
        Returns true if this class info can create objects of the associated
        class.
        """

    def IsKindOf(self, info: ClassInfo) -> bool:
        """
        IsKindOf(info) -> bool
        
        Returns true if this class is a kind of (inherits from) the given
        class.
        """

    @staticmethod
    def FindClass(className: str) -> ClassInfo:
        """
        FindClass(className) -> ClassInfo
        
        Finds the wxClassInfo object for a class with the given name.
        """
    @property
    def BaseClassName1(self) -> str: ...
    @property
    def BaseClassName2(self) -> str: ...
    @property
    def ClassName(self) -> str: ...
    @property
    def Size(self) -> int: ...
# end of class ClassInfo

#-- end-object --#
#-- begin-clntdatactnr --#

class ClientDataContainer:
    """
    ClientDataContainer() -> None
    
    This class is a mixin that provides storage and management of "client
    data".
    """

    def __init__(self) -> None:
        """
        ClientDataContainer() -> None
        
        This class is a mixin that provides storage and management of "client
        data".
        """

    def GetClientData(self) -> ClientData:
        """
        GetClientData() -> ClientData
        
        Get a pointer to the client data object.
        """

    def SetClientData(self, data: ClientData) -> None:
        """
        SetClientData(data) -> None
        
        Set the client data object.
        """

    def GetClientObject(self):
        """
        Alias for :meth:`GetClientData`
        """

    def SetClientObject(self, data):
        """
        Alias for :meth:`SetClientData`
        """
    ClientData = property(GetClientData, SetClientData)
# end of class ClientDataContainer


class SharedClientDataContainer:
    """
    This class is a replacement for wxClientDataContainer, and unlike
    wxClientDataContainer the wxSharedClientDataContainer client data is
    copiable, so it can be copied when objects containing it are cloned.
    """

    def GetClientData(self) -> Any:
        """
        GetClientData() -> Any
        
        Get the untyped client data.
        """

    def GetClientObject(self) -> ClientData:
        """
        GetClientObject() -> ClientData
        
        Get a pointer to the client data object.
        """

    def SetClientData(self, data: Any) -> None:
        """
        SetClientData(data) -> None
        
        Set the untyped client data.
        """

    def SetClientObject(self, data: ClientData) -> None:
        """
        SetClientObject(data) -> None
        
        Set the client data object.
        """
    @property
    def ClientData(self) -> Any: ...
    @ClientData.setter
    def ClientData(self, value: Any, /) -> None: ...
    @property
    def ClientObject(self) -> ClientData: ...
    @ClientObject.setter
    def ClientObject(self, value: ClientData, /) -> None: ...
# end of class SharedClientDataContainer

#-- end-clntdatactnr --#
#-- begin-wxdatetime --#
DefaultTimeSpanFormat: str
DefaultDateTimeFormat: str

class DateTime:
    """
    DateTime() -> None
    DateTime(date) -> None
    DateTime(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0) -> None
    
    wxDateTime class represents an absolute moment in time.
    """

    class TimeZone:
        """
        TimeZone(tz) -> None
        TimeZone(offset=0) -> None
        
        Class representing a time zone.
        """

        @overload
        def __init__(self, offset: int=0) -> None:
            ...

        @overload
        def __init__(self, tz: DateTime.TZ) -> None:
            """
            TimeZone(tz) -> None
            TimeZone(offset=0) -> None
            
            Class representing a time zone.
            """

        def IsLocal(self) -> bool:
            """
            IsLocal() -> bool
            
            Return true if this is the local time zone.
            """

        def GetOffset(self) -> int:
            """
            GetOffset() -> int
            
            Return the offset of this time zone from UTC, in seconds.
            """

        @staticmethod
        def Make(offset: int) -> DateTime.TimeZone:
            """
            Make(offset) -> DateTime.TimeZone
            
            Create a time zone with the given offset in seconds.
            """
        @property
        def Offset(self) -> int: ...
    # end of class TimeZone


    class Tm:
        """
        Contains broken down date-time representation.
        """
        msec: int
        sec: int
        min: int
        hour: int
        mday: int
        yday: int
        mon: DateTime.Month
        year: int

        def IsValid(self) -> bool:
            """
            IsValid() -> bool
            
            Check if the given date/time is valid (in Gregorian calendar).
            """

        def GetWeekDay(self) -> DateTime.WeekDay:
            """
            GetWeekDay() -> DateTime.WeekDay
            
            Return the week day corresponding to this date.
            """
        @property
        def WeekDay(self) -> DateTime.WeekDay: ...
    # end of class Tm


    class _TZ(IntEnum):
        Local = auto()
        GMT_12 = auto()
        GMT_11 = auto()
        GMT_10 = auto()
        GMT_9 = auto()
        GMT_8 = auto()
        GMT_7 = auto()
        GMT_6 = auto()
        GMT_5 = auto()
        GMT_4 = auto()
        GMT_3 = auto()
        GMT_2 = auto()
        GMT_1 = auto()
        GMT0 = auto()
        GMT1 = auto()
        GMT2 = auto()
        GMT3 = auto()
        GMT4 = auto()
        GMT5 = auto()
        GMT6 = auto()
        GMT7 = auto()
        GMT8 = auto()
        GMT9 = auto()
        GMT10 = auto()
        GMT11 = auto()
        GMT12 = auto()
        GMT13 = auto()
        WET = auto()
        WEST = auto()
        CET = auto()
        CEST = auto()
        EET = auto()
        EEST = auto()
        MSK = auto()
        MSD = auto()
        AST = auto()
        ADT = auto()
        EST = auto()
        EDT = auto()
        CST = auto()
        CDT = auto()
        MST = auto()
        MDT = auto()
        PST = auto()
        PDT = auto()
        HST = auto()
        AKST = auto()
        AKDT = auto()
        A_WST = auto()
        A_CST = auto()
        A_EST = auto()
        A_ESST = auto()
        NZST = auto()
        NZDT = auto()
        UTC = auto()
    TZ: TypeAlias = Union[_TZ, int]
    Local = _TZ.Local
    GMT_12 = _TZ.GMT_12
    GMT_11 = _TZ.GMT_11
    GMT_10 = _TZ.GMT_10
    GMT_9 = _TZ.GMT_9
    GMT_8 = _TZ.GMT_8
    GMT_7 = _TZ.GMT_7
    GMT_6 = _TZ.GMT_6
    GMT_5 = _TZ.GMT_5
    GMT_4 = _TZ.GMT_4
    GMT_3 = _TZ.GMT_3
    GMT_2 = _TZ.GMT_2
    GMT_1 = _TZ.GMT_1
    GMT0 = _TZ.GMT0
    GMT1 = _TZ.GMT1
    GMT2 = _TZ.GMT2
    GMT3 = _TZ.GMT3
    GMT4 = _TZ.GMT4
    GMT5 = _TZ.GMT5
    GMT6 = _TZ.GMT6
    GMT7 = _TZ.GMT7
    GMT8 = _TZ.GMT8
    GMT9 = _TZ.GMT9
    GMT10 = _TZ.GMT10
    GMT11 = _TZ.GMT11
    GMT12 = _TZ.GMT12
    GMT13 = _TZ.GMT13
    WET = _TZ.WET
    WEST = _TZ.WEST
    CET = _TZ.CET
    CEST = _TZ.CEST
    EET = _TZ.EET
    EEST = _TZ.EEST
    MSK = _TZ.MSK
    MSD = _TZ.MSD
    AST = _TZ.AST
    ADT = _TZ.ADT
    EST = _TZ.EST
    EDT = _TZ.EDT
    CST = _TZ.CST
    CDT = _TZ.CDT
    MST = _TZ.MST
    MDT = _TZ.MDT
    PST = _TZ.PST
    PDT = _TZ.PDT
    HST = _TZ.HST
    AKST = _TZ.AKST
    AKDT = _TZ.AKDT
    A_WST = _TZ.A_WST
    A_CST = _TZ.A_CST
    A_EST = _TZ.A_EST
    A_ESST = _TZ.A_ESST
    NZST = _TZ.NZST
    NZDT = _TZ.NZDT
    UTC = _TZ.UTC

    class _Calendar(IntEnum):
        Gregorian = auto()
        Julian = auto()
    Calendar: TypeAlias = Union[_Calendar, int]
    Gregorian = _Calendar.Gregorian
    Julian = _Calendar.Julian

    class _Country(IntEnum):
        Country_Unknown = auto()
        Country_Default = auto()
        Country_WesternEurope_Start = auto()
        Country_EEC = auto()
        France = auto()
        Germany = auto()
        UK = auto()
        Country_WesternEurope_End = auto()
        Russia = auto()
        USA = auto()
    Country: TypeAlias = Union[_Country, int]
    Country_Unknown = _Country.Country_Unknown
    Country_Default = _Country.Country_Default
    Country_WesternEurope_Start = _Country.Country_WesternEurope_Start
    Country_EEC = _Country.Country_EEC
    France = _Country.France
    Germany = _Country.Germany
    UK = _Country.UK
    Country_WesternEurope_End = _Country.Country_WesternEurope_End
    Russia = _Country.Russia
    USA = _Country.USA

    class _Month(IntEnum):
        Jan = auto()
        Feb = auto()
        Mar = auto()
        Apr = auto()
        May = auto()
        Jun = auto()
        Jul = auto()
        Aug = auto()
        Sep = auto()
        Oct = auto()
        Nov = auto()
        Dec = auto()
        Inv_Month = auto()
    Month: TypeAlias = Union[_Month, int]
    Jan = _Month.Jan
    Feb = _Month.Feb
    Mar = _Month.Mar
    Apr = _Month.Apr
    May = _Month.May
    Jun = _Month.Jun
    Jul = _Month.Jul
    Aug = _Month.Aug
    Sep = _Month.Sep
    Oct = _Month.Oct
    Nov = _Month.Nov
    Dec = _Month.Dec
    Inv_Month = _Month.Inv_Month

    class _WeekDay(IntEnum):
        Sun = auto()
        Mon = auto()
        Tue = auto()
        Wed = auto()
        Thu = auto()
        Fri = auto()
        Sat = auto()
        Inv_WeekDay = auto()
    WeekDay: TypeAlias = Union[_WeekDay, int]
    Sun = _WeekDay.Sun
    Mon = _WeekDay.Mon
    Tue = _WeekDay.Tue
    Wed = _WeekDay.Wed
    Thu = _WeekDay.Thu
    Fri = _WeekDay.Fri
    Sat = _WeekDay.Sat
    Inv_WeekDay = _WeekDay.Inv_WeekDay

    class _Year(IntEnum):
        Inv_Year = auto()
    Year: TypeAlias = Union[_Year, int]
    Inv_Year = _Year.Inv_Year

    class _NameFlags(IntFlag):
        Name_Full = auto()
        Name_Abbr = auto()
    NameFlags: TypeAlias = Union[_NameFlags, int]
    Name_Full = _NameFlags.Name_Full
    Name_Abbr = _NameFlags.Name_Abbr

    class _WeekFlags(IntFlag):
        Default_First = auto()
        Monday_First = auto()
        Sunday_First = auto()
    WeekFlags: TypeAlias = Union[_WeekFlags, int]
    Default_First = _WeekFlags.Default_First
    Monday_First = _WeekFlags.Monday_First
    Sunday_First = _WeekFlags.Sunday_First

    @overload
    def __init__(self, date: Union[DateTime, datetime, date]) -> None:
        ...

    @overload
    def __init__(self, day: int, month: DateTime.Month, year: int=Inv_Year, hour: int=0, minute: int=0, second: int=0, millisec: int=0) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        DateTime() -> None
        DateTime(date) -> None
        DateTime(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0) -> None
        
        wxDateTime class represents an absolute moment in time.
        """

    def ResetTime(self) -> DateTime:
        """
        ResetTime() -> DateTime
        
        Reset time to midnight (00:00:00) without changing the date.
        """

    def Set(self, day: int, month: DateTime.Month, year: int=Inv_Year, hour: int=0, minute: int=0, second: int=0, millisec: int=0) -> DateTime:
        """
        Set(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0) -> DateTime
        
        Sets the date and time from the parameters.
        """

    def SetHMS(self, hour: int, minute: int=0, second: int=0, millisec: int=0) -> DateTime:
        """
        SetHMS(hour, minute=0, second=0, millisec=0) -> DateTime
        
        Sets the date to be equal to Today() and the time from supplied
        parameters.
        """

    def SetJDN(self, jdn: float) -> DateTime:
        """
        SetJDN(jdn) -> DateTime
        
        Sets the date from the so-called Julian Day Number.
        """

    def SetTimeT(self, timet: int) -> DateTime:
        """
        SetTimeT(timet) -> DateTime
        
        Constructs the object from timet value holding the number of seconds
        since Jan 1, 1970 UTC.
        """

    def SetTm(self, tm: Tm) -> DateTime:
        """
        SetTm(tm) -> DateTime
        
        Sets the date and time from the broken down representation in the
        wxDateTime::Tm structure.
        """

    def SetDay(self, day: int) -> DateTime:
        """
        SetDay(day) -> DateTime
        
        Sets the day without changing other date components.
        """

    def SetFromDOS(self, ddt: int) -> DateTime:
        """
        SetFromDOS(ddt) -> DateTime
        
        Sets the date from the date and time in DOS format.
        """

    def SetHour(self, hour: int) -> DateTime:
        """
        SetHour(hour) -> DateTime
        
        Sets the hour without changing other date components.
        """

    def SetMillisecond(self, millisecond: int) -> DateTime:
        """
        SetMillisecond(millisecond) -> DateTime
        
        Sets the millisecond without changing other date components.
        """

    def SetMinute(self, minute: int) -> DateTime:
        """
        SetMinute(minute) -> DateTime
        
        Sets the minute without changing other date components.
        """

    def SetMonth(self, month: DateTime.Month) -> DateTime:
        """
        SetMonth(month) -> DateTime
        
        Sets the month without changing other date components.
        """

    def SetSecond(self, second: int) -> DateTime:
        """
        SetSecond(second) -> DateTime
        
        Sets the second without changing other date components.
        """

    def SetToCurrent(self) -> DateTime:
        """
        SetToCurrent() -> DateTime
        
        Sets the date and time of to the current values.
        """

    def SetYear(self, year: int) -> DateTime:
        """
        SetYear(year) -> DateTime
        
        Sets the year without changing other date components.
        """

    def GetAsDOS(self) -> int:
        """
        GetAsDOS() -> int
        
        Returns the date and time in DOS format.
        """

    def GetCentury(self, tz: TimeZone=Local) -> int:
        """
        GetCentury(tz=Local) -> int
        
        Returns the century of this date.
        """

    def GetDateOnly(self) -> DateTime:
        """
        GetDateOnly() -> DateTime
        
        Returns the object having the same date component as this one but time
        of 00:00:00.
        """

    def GetDay(self, tz: TimeZone=Local) -> int:
        """
        GetDay(tz=Local) -> int
        
        Returns the day in the given timezone (local one by default).
        """

    def GetDayOfYear(self, tz: TimeZone=Local) -> int:
        """
        GetDayOfYear(tz=Local) -> int
        
        Returns the day of the year (in 1-366 range) in the given timezone
        (local one by default).
        """

    def GetHour(self, tz: TimeZone=Local) -> int:
        """
        GetHour(tz=Local) -> int
        
        Returns the hour in the given timezone (local one by default).
        """

    def GetMillisecond(self, tz: TimeZone=Local) -> int:
        """
        GetMillisecond(tz=Local) -> int
        
        Returns the milliseconds in the given timezone (local one by default).
        """

    def GetMinute(self, tz: TimeZone=Local) -> int:
        """
        GetMinute(tz=Local) -> int
        
        Returns the minute in the given timezone (local one by default).
        """

    def GetMonth(self, tz: TimeZone=Local) -> DateTime.Month:
        """
        GetMonth(tz=Local) -> DateTime.Month
        
        Returns the month in the given timezone (local one by default).
        """

    def GetSecond(self, tz: TimeZone=Local) -> int:
        """
        GetSecond(tz=Local) -> int
        
        Returns the seconds in the given timezone (local one by default).
        """

    def GetTicks(self) -> int:
        """
        GetTicks() -> int
        
        Returns the number of seconds since Jan 1, 1970 UTC.
        """

    def GetValue(self) -> int:
        """
        GetValue() -> int
        
        Returns the number of milliseconds since Jan 1, 1970 UTC.
        """

    def GetTm(self, tz: TimeZone=Local) -> DateTime.Tm:
        """
        GetTm(tz=Local) -> DateTime.Tm
        
        Returns broken down representation of the date and time.
        """

    @overload
    def GetWeekDay(self, weekday: DateTime.WeekDay, n: int=1, month: DateTime.Month=Inv_Month, year: int=Inv_Year) -> DateTime:
        ...

    @overload
    def GetWeekDay(self, tz: TimeZone=Local) -> DateTime.WeekDay:
        """
        GetWeekDay(tz=Local) -> DateTime.WeekDay
        GetWeekDay(weekday, n=1, month=Inv_Month, year=Inv_Year) -> DateTime
        
        Returns the week day in the given timezone (local one by default).
        """

    def GetWeekBasedYear(self, tz: TimeZone) -> int:
        """
        GetWeekBasedYear(tz) -> int
        
        Returns the year to which the week containing this date belongs.
        """

    def GetWeekOfMonth(self, flags: WeekFlags=Monday_First, tz: TimeZone=Local) -> int:
        """
        GetWeekOfMonth(flags=Monday_First, tz=Local) -> int
        
        Returns the ordinal number of the week in the month (in 1-5 range).
        """

    def GetWeekOfYear(self, flags: WeekFlags=Monday_First, tz: TimeZone=Local) -> int:
        """
        GetWeekOfYear(flags=Monday_First, tz=Local) -> int
        
        Returns the number of the week of the year this date is in.
        """

    def GetYear(self, tz: TimeZone=Local) -> int:
        """
        GetYear(tz=Local) -> int
        
        Returns the year in the given timezone (local one by default).
        """

    def IsValid(self) -> bool:
        """
        IsValid() -> bool
        
        Returns true if the object represents a valid time moment.
        """

    def IsWorkDay(self, country: Country=Country_Default) -> bool:
        """
        IsWorkDay(country=Country_Default) -> bool
        
        Returns true is this day is not a holiday in the given country.
        """

    def IsEarlierThan(self, datetime: Union[DateTime, datetime, date]) -> bool:
        """
        IsEarlierThan(datetime) -> bool
        
        Returns true if this date precedes the given one.
        """

    def IsEqualTo(self, datetime: Union[DateTime, datetime, date]) -> bool:
        """
        IsEqualTo(datetime) -> bool
        
        Returns true if the two dates are strictly identical.
        """

    def IsEqualUpTo(self, dt: Union[DateTime, datetime, date], ts: TimeSpan) -> bool:
        """
        IsEqualUpTo(dt, ts) -> bool
        
        Returns true if the date is equal to another one up to the given time
        interval, i.e. if the absolute difference between the two dates is
        less than this interval.
        """

    def IsLaterThan(self, datetime: Union[DateTime, datetime, date]) -> bool:
        """
        IsLaterThan(datetime) -> bool
        
        Returns true if this date is later than the given one.
        """

    def IsSameDate(self, dt: Union[DateTime, datetime, date]) -> bool:
        """
        IsSameDate(dt) -> bool
        
        Returns true if the date is the same without comparing the time parts.
        """

    def IsSameTime(self, dt: Union[DateTime, datetime, date]) -> bool:
        """
        IsSameTime(dt) -> bool
        
        Returns true if the time is the same (although dates may differ).
        """

    def IsStrictlyBetween(self, t1: Union[DateTime, datetime, date], t2: Union[DateTime, datetime, date]) -> bool:
        """
        IsStrictlyBetween(t1, t2) -> bool
        
        Returns true if this date lies strictly between the two given dates.
        """

    def IsBetween(self, t1: Union[DateTime, datetime, date], t2: Union[DateTime, datetime, date]) -> bool:
        """
        IsBetween(t1, t2) -> bool
        
        Returns true if IsStrictlyBetween() is true or if the date is equal to
        one of the limit values.
        """

    @overload
    def Add(self, diff: TimeSpan) -> DateTime:
        ...

    @overload
    def Add(self, diff: DateSpan) -> DateTime:
        """
        Add(diff) -> DateTime
        Add(diff) -> DateTime
        
        Adds the given date span to this object.
        """

    @overload
    def Subtract(self, diff: DateSpan) -> DateTime:
        ...

    @overload
    def Subtract(self, dt: Union[DateTime, datetime, date]) -> TimeSpan:
        ...

    @overload
    def Subtract(self, diff: TimeSpan) -> DateTime:
        """
        Subtract(diff) -> DateTime
        Subtract(diff) -> DateTime
        Subtract(dt) -> TimeSpan
        
        Subtracts the given time span from this object.
        """

    def DiffAsDateSpan(self, dt: Union[DateTime, datetime, date]) -> DateSpan:
        """
        DiffAsDateSpan(dt) -> DateSpan
        
        Returns the difference between this object and dt as a wxDateSpan.
        """

    def Format(self, format: str=DefaultDateTimeFormat, tz: TimeZone=Local) -> str:
        """
        Format(format=DefaultDateTimeFormat, tz=Local) -> str
        
        This function does the same as the standard ANSI C strftime(3)
        function (https://cplusplus.com/reference/ctime/strftime/).
        """

    def FormatDate(self) -> str:
        """
        FormatDate() -> str
        
        Identical to calling Format() with "%x" argument (which means
        "preferred date representation for the current locale").
        """

    def FormatISOCombined(self, sep: str='T') -> str:
        """
        FormatISOCombined(sep='T') -> str
        
        Returns the combined date-time representation in the ISO 8601 format
        "YYYY-MM-DDTHH:MM:SS".
        """

    def FormatISODate(self) -> str:
        """
        FormatISODate() -> str
        
        This function returns the date representation in the ISO 8601 format
        "YYYY-MM-DD".
        """

    def FormatISOTime(self) -> str:
        """
        FormatISOTime() -> str
        
        This function returns the time representation in the ISO 8601 format
        "HH:MM:SS".
        """

    def FormatTime(self) -> str:
        """
        FormatTime() -> str
        
        Identical to calling Format() with "%X" argument (which means
        "preferred time representation for the current locale").
        """

    def ParseDate(self, date: str) -> int:
        """
        ParseDate(date) -> int
        
        This function is like ParseDateTime(), but it only allows the date to
        be specified.
        """

    def ParseDateTime(self, datetime: str) -> int:
        """
        ParseDateTime(datetime) -> int
        
        Parses the string datetime containing the date and time in free
        format.
        """

    @overload
    def ParseFormat(self, date: str, format: str) -> int:
        ...

    @overload
    def ParseFormat(self, date: str) -> int:
        ...

    @overload
    def ParseFormat(self, date: str, format: str, dateDef: Union[DateTime, datetime, date]) -> int:
        """
        ParseFormat(date, format, dateDef) -> int
        ParseFormat(date, format) -> int
        ParseFormat(date) -> int
        
        Parses the string date according to the given format.
        """

    def ParseISOCombined(self, date: str, sep: str='T') -> bool:
        """
        ParseISOCombined(date, sep='T') -> bool
        
        This function parses the string containing the date and time in ISO
        8601 combined format "YYYY-MM-DDTHH:MM:SS".
        """

    def ParseISODate(self, date: str) -> bool:
        """
        ParseISODate(date) -> bool
        
        This function parses the date in ISO 8601 format "YYYY-MM-DD".
        """

    def ParseISOTime(self, date: str) -> bool:
        """
        ParseISOTime(date) -> bool
        
        This function parses the time in ISO 8601 format "HH:MM:SS".
        """

    def ParseRfc822Date(self, date: str) -> int:
        """
        ParseRfc822Date(date) -> int
        
        Parses the string date looking for a date formatted according to the
        RFC 822 in it.
        """

    def ParseTime(self, time: str) -> int:
        """
        ParseTime(time) -> int
        
        This functions is like ParseDateTime(), but only allows the time to be
        specified in the input string.
        """

    def GetLastMonthDay(self, month: DateTime.Month=Inv_Month, year: int=Inv_Year) -> DateTime:
        """
        GetLastMonthDay(month=Inv_Month, year=Inv_Year) -> DateTime
        
        Returns the copy of this object to which SetToLastMonthDay() was
        applied.
        """

    def GetLastWeekDay(self, weekday: DateTime.WeekDay, month: DateTime.Month=Inv_Month, year: int=Inv_Year) -> DateTime:
        """
        GetLastWeekDay(weekday, month=Inv_Month, year=Inv_Year) -> DateTime
        
        Returns the copy of this object to which SetToLastWeekDay() was
        applied.
        """

    def GetNextWeekDay(self, weekday: DateTime.WeekDay) -> DateTime:
        """
        GetNextWeekDay(weekday) -> DateTime
        
        Returns the copy of this object to which SetToNextWeekDay() was
        applied.
        """

    def GetPrevWeekDay(self, weekday: DateTime.WeekDay) -> DateTime:
        """
        GetPrevWeekDay(weekday) -> DateTime
        
        Returns the copy of this object to which SetToPrevWeekDay() was
        applied.
        """

    def GetWeekDayInSameWeek(self, weekday: DateTime.WeekDay, flags: WeekFlags=Monday_First) -> DateTime:
        """
        GetWeekDayInSameWeek(weekday, flags=Monday_First) -> DateTime
        
        Returns the copy of this object to which SetToWeekDayInSameWeek() was
        applied.
        """

    def GetYearDay(self, yday: int) -> DateTime:
        """
        GetYearDay(yday) -> DateTime
        
        Returns the copy of this object to which SetToYearDay() was applied.
        """

    def SetToLastMonthDay(self, month: DateTime.Month=Inv_Month, year: int=Inv_Year) -> DateTime:
        """
        SetToLastMonthDay(month=Inv_Month, year=Inv_Year) -> DateTime
        
        Sets the date to the last day in the specified month (the current one
        by default).
        """

    def SetToLastWeekDay(self, weekday: DateTime.WeekDay, month: DateTime.Month=Inv_Month, year: int=Inv_Year) -> bool:
        """
        SetToLastWeekDay(weekday, month=Inv_Month, year=Inv_Year) -> bool
        
        The effect of calling this function is the same as of calling
        SetToWeekDay(-1, weekday, month, year).
        """

    def SetToNextWeekDay(self, weekday: DateTime.WeekDay) -> DateTime:
        """
        SetToNextWeekDay(weekday) -> DateTime
        
        Sets the date so that it will be the first weekday following the
        current date.
        """

    def SetToPrevWeekDay(self, weekday: DateTime.WeekDay) -> DateTime:
        """
        SetToPrevWeekDay(weekday) -> DateTime
        
        Sets the date so that it will be the last weekday before the current
        date.
        """

    def SetToWeekDay(self, weekday: DateTime.WeekDay, n: int=1, month: DateTime.Month=Inv_Month, year: int=Inv_Year) -> bool:
        """
        SetToWeekDay(weekday, n=1, month=Inv_Month, year=Inv_Year) -> bool
        
        Sets the date to the n-th weekday in the given month of the given year
        (the current month and year are used by default).
        """

    def SetToWeekDayInSameWeek(self, weekday: DateTime.WeekDay, flags: WeekFlags=Monday_First) -> DateTime:
        """
        SetToWeekDayInSameWeek(weekday, flags=Monday_First) -> DateTime
        
        Adjusts the date so that it will still lie in the same week as before,
        but its week day will be the given one.
        """

    def SetToYearDay(self, yday: int) -> DateTime:
        """
        SetToYearDay(yday) -> DateTime
        
        Sets the date to the day number yday in the same year (i.e. unlike the
        other functions, this one does not use the current year).
        """

    def GetJDN(self) -> float:
        """
        GetJDN() -> float
        
        Synonym for GetJulianDayNumber().
        """

    def GetJulianDayNumber(self) -> float:
        """
        GetJulianDayNumber() -> float
        
        Returns the JDN corresponding to this date.
        """

    def GetMJD(self) -> float:
        """
        GetMJD() -> float
        
        Synonym for GetModifiedJulianDayNumber().
        """

    def GetModifiedJulianDayNumber(self) -> float:
        """
        GetModifiedJulianDayNumber() -> float
        
        Returns the "Modified Julian Day Number" (MJD) which is, by
        definition, is equal to JDN - 2400000.5.
        """

    def GetRataDie(self) -> float:
        """
        GetRataDie() -> float
        
        Return the Rata Die number of this date.
        """

    def FromTimezone(self, tz: TimeZone, noDST: bool=False) -> DateTime:
        """
        FromTimezone(tz, noDST=False) -> DateTime
        
        Transform the date from the given time zone to the local one.
        """

    def IsDST(self, country: Country=Country_Default) -> int:
        """
        IsDST(country=Country_Default) -> int
        
        Returns true if the DST is applied for this date in the given country.
        """

    def MakeFromTimezone(self, tz: TimeZone, noDST: bool=False) -> DateTime:
        """
        MakeFromTimezone(tz, noDST=False) -> DateTime
        
        Same as FromTimezone() but modifies the object in place.
        """

    def MakeTimezone(self, tz: TimeZone, noDST: bool=False) -> DateTime:
        """
        MakeTimezone(tz, noDST=False) -> DateTime
        
        Modifies the object in place to represent the date in another time
        zone.
        """

    def MakeUTC(self, noDST: bool=False) -> DateTime:
        """
        MakeUTC(noDST=False) -> DateTime
        
        This is the same as calling MakeTimezone() with the argument GMT0.
        """

    def ToTimezone(self, tz: TimeZone, noDST: bool=False) -> DateTime:
        """
        ToTimezone(tz, noDST=False) -> DateTime
        
        Transform the date to the given time zone.
        """

    def ToUTC(self, noDST: bool=False) -> DateTime:
        """
        ToUTC(noDST=False) -> DateTime
        
        This is the same as calling ToTimezone() with the argument GMT0.
        """

    @staticmethod
    def ConvertYearToBC(year: int) -> int:
        """
        ConvertYearToBC(year) -> int
        
        Converts the year in absolute notation (i.e. a number which can be
        negative, positive or zero) to the year in BC/AD notation.
        """

    @staticmethod
    def GetAmPmStrings() -> Tuple[str, str]:
        """
        GetAmPmStrings() -> Tuple[str, str]
        
        Returns the translations of the strings AM and PM used for time
        formatting for the current locale.
        """

    @staticmethod
    def GetBeginDST(year: int=Inv_Year, country: Country=Country_Default) -> DateTime:
        """
        GetBeginDST(year=Inv_Year, country=Country_Default) -> DateTime
        
        Get the beginning of DST for the given country in the given year
        (current one by default).
        """

    @staticmethod
    def GetEndDST(year: int=Inv_Year, country: Country=Country_Default) -> DateTime:
        """
        GetEndDST(year=Inv_Year, country=Country_Default) -> DateTime
        
        Returns the end of DST for the given country in the given year
        (current one by default).
        """

    @staticmethod
    def GetCountry() -> Country:
        """
        GetCountry() -> Country
        
        Returns the current default country.
        """

    @staticmethod
    def GetCurrentMonth(cal: Calendar=Gregorian) -> DateTime.Month:
        """
        GetCurrentMonth(cal=Gregorian) -> DateTime.Month
        
        Get the current month in given calendar (only Gregorian is currently
        supported).
        """

    @staticmethod
    def GetCurrentYear(cal: Calendar=Gregorian) -> int:
        """
        GetCurrentYear(cal=Gregorian) -> int
        
        Get the current year in given calendar (only Gregorian is currently
        supported).
        """

    @staticmethod
    def GetEnglishMonthName(month: DateTime.Month, flags: NameFlags=Name_Full) -> str:
        """
        GetEnglishMonthName(month, flags=Name_Full) -> str
        
        Return the standard English name of the given month.
        """

    @staticmethod
    def GetEnglishWeekDayName(weekday: DateTime.WeekDay, flags: NameFlags=Name_Full) -> str:
        """
        GetEnglishWeekDayName(weekday, flags=Name_Full) -> str
        
        Return the standard English name of the given week day.
        """

    @staticmethod
    def GetMonthName(month: DateTime.Month, flags: NameFlags=Name_Full) -> str:
        """
        GetMonthName(month, flags=Name_Full) -> str
        
        Gets the full (default) or abbreviated name of the given month.
        """

    @staticmethod
    def GetNumberOfDays(month: DateTime.Month, year: int=Inv_Year, cal: Calendar=Gregorian) -> int:
        """
        GetNumberOfDays(month, year=Inv_Year, cal=Gregorian) -> int
        
        Returns the number of days in the given month of the given year.
        """

    @staticmethod
    def GetTimeNow() -> int:
        """
        GetTimeNow() -> int
        
        Returns the current time.
        """

    @staticmethod
    def GetWeekDayName(weekday: DateTime.WeekDay, flags: NameFlags=Name_Full) -> str:
        """
        GetWeekDayName(weekday, flags=Name_Full) -> str
        
        Gets the full (default) or abbreviated name of the given week day.
        """

    @staticmethod
    def IsDSTApplicable(year: int=Inv_Year, country: Country=Country_Default) -> bool:
        """
        IsDSTApplicable(year=Inv_Year, country=Country_Default) -> bool
        
        Returns true if DST was used in the given year (the current one by
        default) in the given country.
        """

    @staticmethod
    def GetFirstWeekDay(firstDay: WeekDay) -> bool:
        """
        GetFirstWeekDay(firstDay) -> bool
        
        Acquires the first weekday of a week based on locale and/or OS
        settings.
        """

    @staticmethod
    def IsLeapYear(year: int=Inv_Year, cal: Calendar=Gregorian) -> bool:
        """
        IsLeapYear(year=Inv_Year, cal=Gregorian) -> bool
        
        Returns true if the year is a leap one in the specified calendar.
        """

    @staticmethod
    def IsWestEuropeanCountry(country: Country=Country_Default) -> bool:
        """
        IsWestEuropeanCountry(country=Country_Default) -> bool
        
        This function returns true if the specified (or default) country is
        one of Western European ones.
        """

    @staticmethod
    def Now() -> DateTime:
        """
        Now() -> DateTime
        
        Returns the object corresponding to the current time in local time
        zone.
        """

    @staticmethod
    def SetCountry(country: Country) -> None:
        """
        SetCountry(country) -> None
        
        Sets the country to use by default.
        """

    @staticmethod
    def SetToWeekOfYear(year: int, numWeek: int, weekday: DateTime.WeekDay=Mon) -> DateTime:
        """
        SetToWeekOfYear(year, numWeek, weekday=Mon) -> DateTime
        
        Set the date to the given weekday in the week number numWeek of the
        given year .
        """

    @staticmethod
    def Today() -> DateTime:
        """
        Today() -> DateTime
        
        Returns the object corresponding to the midnight of the current day
        (i.e. the same as Now(), but the time part is set to 0).
        """

    @staticmethod
    def UNow() -> DateTime:
        """
        UNow() -> DateTime
        
        Returns the object corresponding to the current time including the
        milliseconds.
        """

    @staticmethod
    def FromTimeT(timet: int) -> DateTime:
        """
        FromTimeT(timet) -> DateTime
        
        Construct a :class:`DateTime` from a C ``time_t`` value, the number of
        seconds since the epoch.
        """

    @staticmethod
    def FromJDN(jdn: float) -> DateTime:
        """
        FromJDN(jdn) -> DateTime
        
        Construct a :class:`DateTime` from a Julian Day Number.
        
        By definition, the Julian Day Number, usually abbreviated as JDN, of a
        particular instant is the fractional number of days since 12 hours
        Universal Coordinated Time (Greenwich mean noon) on January 1 of the
        year -4712 in the Julian proleptic calendar.
        """

    @staticmethod
    def FromHMS(hour: int, minute: int=0, second: int=0, millisecond: int=0) -> DateTime:
        """
        FromHMS(hour, minute=0, second=0, millisecond=0) -> DateTime
        
        Construct a :class:`DateTime` equal to :meth:`Today` () with the time
        set to the supplied parameters.
        """

    @staticmethod
    def FromDMY(day: int, month: DateTime.Month, year: int=Inv_Year, hour: int=0, minute: int=0, second: int=0, millisecond: int=0) -> DateTime:
        """
        FromDMY(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisecond=0) -> DateTime
        
        Construct a :class:`DateTime` using the supplied parameters.
        """

    def __repr__(self):
        """
        
        """

    def __str__(self):
        """
        
        """
    @property
    def day(self) -> int: ...
    @day.setter
    def day(self, value: int, /) -> None: ...
    @property
    def month(self) -> DateTime.Month: ...
    @month.setter
    def month(self, value: DateTime.Month, /) -> None: ...
    @property
    def year(self) -> int: ...
    @year.setter
    def year(self, value: int, /) -> None: ...
    @property
    def hour(self) -> int: ...
    @hour.setter
    def hour(self, value: int, /) -> None: ...
    @property
    def minute(self) -> int: ...
    @minute.setter
    def minute(self, value: int, /) -> None: ...
    @property
    def second(self) -> int: ...
    @second.setter
    def second(self, value: int, /) -> None: ...
    @property
    def millisecond(self) -> int: ...
    @millisecond.setter
    def millisecond(self, value: int, /) -> None: ...
    @property
    def JDN(self) -> float: ...
    @JDN.setter
    def JDN(self, value: float, /) -> None: ...
    @property
    def DayOfYear(self) -> int: ...
    @property
    def JulianDayNumber(self) -> float: ...
    @property
    def LastMonthDay(self) -> DateTime: ...
    @property
    def MJD(self) -> float: ...
    @property
    def ModifiedJulianDayNumber(self) -> float: ...
    @property
    def RataDie(self) -> float: ...
    @property
    def Ticks(self) -> int: ...
    @property
    def WeekOfMonth(self) -> int: ...
    @property
    def WeekOfYear(self) -> int: ...
# end of class DateTime


class DateSpan:
    """
    DateSpan(years=0, months=0, weeks=0, days=0) -> None
    
    This class is a "logical time span" and is useful for implementing
    program logic for such things as "add one month to the date" which, in
    general, doesn't mean to add 60*60*24*31 seconds to it, but to take
    the same date the next month (to understand that this is indeed
    different consider adding one month to Feb, 15  we want to get Mar,
    15, of course).
    """

    def __init__(self, years: int=0, months: int=0, weeks: int=0, days: int=0) -> None:
        """
        DateSpan(years=0, months=0, weeks=0, days=0) -> None
        
        This class is a "logical time span" and is useful for implementing
        program logic for such things as "add one month to the date" which, in
        general, doesn't mean to add 60*60*24*31 seconds to it, but to take
        the same date the next month (to understand that this is indeed
        different consider adding one month to Feb, 15  we want to get Mar,
        15, of course).
        """

    def Add(self, other: DateSpan) -> DateSpan:
        """
        Add(other) -> DateSpan
        
        Adds the given wxDateSpan to this wxDateSpan and returns a reference to itself.
        """

    def GetDays(self) -> int:
        """
        GetDays() -> int
        
        Returns the number of days (not counting the weeks component) in this
        date span.
        """

    def GetMonths(self) -> int:
        """
        GetMonths() -> int
        
        Returns the number of the months (not counting the years) in this date
        span.
        """

    def GetTotalMonths(self) -> int:
        """
        GetTotalMonths() -> int
        
        Returns the combined number of months in this date span, counting both
        years and months.
        """

    def GetTotalDays(self) -> int:
        """
        GetTotalDays() -> int
        
        Returns the combined number of days in this date span, counting both
        weeks and days.
        """

    def GetWeeks(self) -> int:
        """
        GetWeeks() -> int
        
        Returns the number of weeks in this date span.
        """

    def GetYears(self) -> int:
        """
        GetYears() -> int
        
        Returns the number of years in this date span.
        """

    def Multiply(self, factor: int) -> DateSpan:
        """
        Multiply(factor) -> DateSpan
        
        Multiplies this date span by the specified factor.
        """

    def Neg(self) -> DateSpan:
        """
        Neg() -> DateSpan
        
        Changes the sign of this date span.
        """

    def Negate(self) -> DateSpan:
        """
        Negate() -> DateSpan
        
        Returns a date span with the opposite sign.
        """

    def SetDays(self, n: int) -> DateSpan:
        """
        SetDays(n) -> DateSpan
        
        Sets the number of days (without modifying any other components) in
        this date span.
        """

    def SetMonths(self, n: int) -> DateSpan:
        """
        SetMonths(n) -> DateSpan
        
        Sets the number of months (without modifying any other components) in
        this date span.
        """

    def SetWeeks(self, n: int) -> DateSpan:
        """
        SetWeeks(n) -> DateSpan
        
        Sets the number of weeks (without modifying any other components) in
        this date span.
        """

    def SetYears(self, n: int) -> DateSpan:
        """
        SetYears(n) -> DateSpan
        
        Sets the number of years (without modifying any other components) in
        this date span.
        """

    def Subtract(self, other: DateSpan) -> DateSpan:
        """
        Subtract(other) -> DateSpan
        
        Subtracts the given wxDateSpan to this wxDateSpan and returns a reference to itself.
        """

    @staticmethod
    def Day() -> DateSpan:
        """
        Day() -> DateSpan
        
        Returns a date span object corresponding to one day.
        """

    @staticmethod
    def Days(days: int) -> DateSpan:
        """
        Days(days) -> DateSpan
        
        Returns a date span object corresponding to the given number of days.
        """

    @staticmethod
    def Month() -> DateSpan:
        """
        Month() -> DateSpan
        
        Returns a date span object corresponding to one month.
        """

    @staticmethod
    def Months(mon: int) -> DateSpan:
        """
        Months(mon) -> DateSpan
        
        Returns a date span object corresponding to the given number of
        months.
        """

    @staticmethod
    def Week() -> DateSpan:
        """
        Week() -> DateSpan
        
        Returns a date span object corresponding to one week.
        """

    @staticmethod
    def Weeks(weeks: int) -> DateSpan:
        """
        Weeks(weeks) -> DateSpan
        
        Returns a date span object corresponding to the given number of weeks.
        """

    @staticmethod
    def Year() -> DateSpan:
        """
        Year() -> DateSpan
        
        Returns a date span object corresponding to one year.
        """

    @staticmethod
    def Years(years: int) -> DateSpan:
        """
        Years(years) -> DateSpan
        
        Returns a date span object corresponding to the given number of years.
        """
# end of class DateSpan


class TimeSpan:
    """
    TimeSpan() -> None
    TimeSpan(hours, min=0, sec=0, msec=0) -> None
    
    wxTimeSpan class represents a time interval.
    """

    @overload
    def __init__(self, hours: int, min: int=0, sec: int=0, msec: int=0) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        TimeSpan() -> None
        TimeSpan(hours, min=0, sec=0, msec=0) -> None
        
        wxTimeSpan class represents a time interval.
        """

    def Abs(self) -> TimeSpan:
        """
        Abs() -> TimeSpan
        
        Returns the absolute value of the timespan: does not modify the
        object.
        """

    def Add(self, diff: TimeSpan) -> TimeSpan:
        """
        Add(diff) -> TimeSpan
        
        Adds the given wxTimeSpan to this wxTimeSpan and returns a reference to itself.
        """

    def Format(self, format: str=DefaultTimeSpanFormat) -> str:
        """
        Format(format=DefaultTimeSpanFormat) -> str
        
        Returns the string containing the formatted representation of the time
        span.
        """

    def GetDays(self) -> int:
        """
        GetDays() -> int
        
        Returns the difference in number of days.
        """

    def GetHours(self) -> int:
        """
        GetHours() -> int
        
        Returns the difference in number of hours.
        """

    def GetMilliseconds(self) -> int:
        """
        GetMilliseconds() -> int
        
        Returns the difference in number of milliseconds.
        """

    def GetMinutes(self) -> int:
        """
        GetMinutes() -> int
        
        Returns the difference in number of minutes.
        """

    def GetSeconds(self) -> int:
        """
        GetSeconds() -> int
        
        Returns the difference in number of seconds.
        """

    def GetValue(self) -> int:
        """
        GetValue() -> int
        
        Returns the internal representation of timespan.
        """

    def GetWeeks(self) -> int:
        """
        GetWeeks() -> int
        
        Returns the difference in number of weeks.
        """

    def IsEqualTo(self, ts: TimeSpan) -> bool:
        """
        IsEqualTo(ts) -> bool
        
        Returns true if two timespans are equal.
        """

    def IsLongerThan(self, ts: TimeSpan) -> bool:
        """
        IsLongerThan(ts) -> bool
        
        Compares two timespans: works with the absolute values, i.e. -2 hours
        is longer than 1 hour.
        """

    def IsNegative(self) -> bool:
        """
        IsNegative() -> bool
        
        Returns true if the timespan is negative.
        """

    def IsNull(self) -> bool:
        """
        IsNull() -> bool
        
        Returns true if the timespan is empty.
        """

    def IsPositive(self) -> bool:
        """
        IsPositive() -> bool
        
        Returns true if the timespan is positive.
        """

    def IsShorterThan(self, ts: TimeSpan) -> bool:
        """
        IsShorterThan(ts) -> bool
        
        Compares two timespans: works with the absolute values, i.e. 1 hour is
        shorter than -2 hours.
        """

    def Multiply(self, n: int) -> TimeSpan:
        """
        Multiply(n) -> TimeSpan
        
        Multiplies this time span by n.
        """

    def Neg(self) -> TimeSpan:
        """
        Neg() -> TimeSpan
        
        Negate the value of the timespan.
        """

    def Negate(self) -> TimeSpan:
        """
        Negate() -> TimeSpan
        
        Returns timespan with inverted sign.
        """

    def Subtract(self, diff: TimeSpan) -> TimeSpan:
        """
        Subtract(diff) -> TimeSpan
        
        Subtracts the given wxTimeSpan to this wxTimeSpan and returns a reference to itself.
        """

    @staticmethod
    def Day() -> TimeSpan:
        """
        Day() -> TimeSpan
        
        Returns the timespan for one day.
        """

    @staticmethod
    def Days(days: int) -> TimeSpan:
        """
        Days(days) -> TimeSpan
        
        Returns the timespan for the given number of days.
        """

    @staticmethod
    def Hour() -> TimeSpan:
        """
        Hour() -> TimeSpan
        
        Returns the timespan for one hour.
        """

    @staticmethod
    def Hours(hours: int) -> TimeSpan:
        """
        Hours(hours) -> TimeSpan
        
        Returns the timespan for the given number of hours.
        """

    @staticmethod
    def Millisecond() -> TimeSpan:
        """
        Millisecond() -> TimeSpan
        
        Returns the timespan for one millisecond.
        """

    @staticmethod
    def Milliseconds(ms: int) -> TimeSpan:
        """
        Milliseconds(ms) -> TimeSpan
        
        Returns the timespan for the given number of milliseconds.
        """

    @staticmethod
    def Minute() -> TimeSpan:
        """
        Minute() -> TimeSpan
        
        Returns the timespan for one minute.
        """

    @staticmethod
    def Minutes(min: int) -> TimeSpan:
        """
        Minutes(min) -> TimeSpan
        
        Returns the timespan for the given number of minutes.
        """

    @staticmethod
    def Second() -> TimeSpan:
        """
        Second() -> TimeSpan
        
        Returns the timespan for one second.
        """

    @staticmethod
    def Seconds(sec: int) -> TimeSpan:
        """
        Seconds(sec) -> TimeSpan
        
        Returns the timespan for the given number of seconds.
        """

    @staticmethod
    def Week() -> TimeSpan:
        """
        Week() -> TimeSpan
        
        Returns the timespan for one week.
        """

    @staticmethod
    def Weeks(weeks: int) -> TimeSpan:
        """
        Weeks(weeks) -> TimeSpan
        
        Returns the timespan for the given number of weeks.
        """
# end of class TimeSpan

DefaultDateTime: DateTime

InvalidDateTime = DefaultDateTime

@wx.deprecated
def DateTimeFromTimeT(timet):
    """
    Compatibility wrapper for :meth:`DateTime.FromTimeT`
    """
    pass

@wx.deprecated
def DateTimeFromJDN(jdn):
    """
    Compatibility wrapper for :meth:`DateTime.FromJDN`
    """
    pass

@wx.deprecated
def DateTimeFromHMS(hour, minute=0, second=0, millisecond=0):
    """
    Compatibility wrapper for :meth:`DateTime.FromHMS`
    """
    pass

@wx.deprecated
def DateTimeFromDMY(day, month, year=DateTime.Inv_Year, hour=0, minute=0, second=0, millisecond=0):
    """
    Compatibility wrapper for :meth:`DateTime.FromDMY`
    """
    pass

def pydate2wxdate(date):
    """
    Convert a Python date or datetime to a :class:`DateTime` object
    """
    pass

def wxdate2pydate(date):
    """
    Convert a :class:`DateTime` object to a Python datetime.
    """
    pass
#-- end-wxdatetime --#
#-- begin-stopwatch --#

class StopWatch:
    """
    StopWatch() -> None
    
    The wxStopWatch class allow you to measure time intervals.
    """

    def __init__(self) -> None:
        """
        StopWatch() -> None
        
        The wxStopWatch class allow you to measure time intervals.
        """

    def Pause(self) -> None:
        """
        Pause() -> None
        
        Pauses the stop watch.
        """

    def Resume(self) -> None:
        """
        Resume() -> None
        
        Resumes the stop watch which had been paused with Pause().
        """

    def Start(self, milliseconds: int=0) -> None:
        """
        Start(milliseconds=0) -> None
        
        (Re)starts the stop watch with a given initial value.
        """

    def Time(self) -> int:
        """
        Time() -> int
        
        Returns the time in milliseconds since the start (or restart) or the
        last call of Pause().
        """

    def TimeInMicro(self) -> int:
        """
        TimeInMicro() -> int
        
        Returns elapsed time in microseconds.
        """
# end of class StopWatch

#-- end-stopwatch --#
#-- begin-windowid --#

class IdManager:
    """
    wxIdManager is responsible for allocating and releasing window IDs.
    """

    @staticmethod
    def ReserveId(count: int=1) -> int:
        """
        ReserveId(count=1) -> int
        
        Called directly by wxWindow::NewControlId(), this function will create
        a new ID or range of IDs.
        """

    @staticmethod
    def UnreserveId(id: int, count: int=1) -> None:
        """
        UnreserveId(id, count=1) -> None
        
        Called directly by wxWindow::UnreserveControlId(), this function will
        unreserve an ID or range of IDs that is currently reserved.
        """
# end of class IdManager


class WindowIDRef:
    """
    WindowIDRef() -> None
    WindowIDRef(id) -> None
    WindowIDRef(idref) -> None
    
    A wxWindowIDRef object wraps an ID value and marks it as being in-use
    until all references to that ID are gone.
    """

    @overload
    def __init__(self, id: int) -> None:
        ...

    @overload
    def __init__(self, idref: WindowIDRef) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        WindowIDRef() -> None
        WindowIDRef(id) -> None
        WindowIDRef(idref) -> None
        
        A wxWindowIDRef object wraps an ID value and marks it as being in-use
        until all references to that ID are gone.
        """

    def GetValue(self) -> int:
        """
        GetValue() -> int
        
        Get the ID value
        """

    def GetId(self) -> int:
        """
        GetId() -> int
        
        Alias for GetValue allowing the IDRef to be passed as the source
        parameter to :meth:`wx.EvtHandler.Bind`.
        """

    def __int__(self) -> int:
        """
        __int__() -> int
        
        Alias for GetValue allowing the IDRef to be passed as the WindowID
        parameter when creating widgets or other places an integer type is
        needed.
        """

    def __index__(self) -> int:
        """
        __index__() -> int
        
        See :meth:`__int__`
        """

    def __eq__(self, id: int) -> bool:
        """
        __eq__(id) -> bool
        """

    def __ne__(self, id: int) -> bool:
        """
        __ne__(id) -> bool
        """

    def __lt__(self, id: int) -> bool:
        """
        __lt__(id) -> bool
        """

    def __gt__(self, id: int) -> bool:
        """
        __gt__(id) -> bool
        """

    def __le__(self, id: int) -> bool:
        """
        __le__(id) -> bool
        """

    def __ge__(self, id: int) -> bool:
        """
        __ge__(id) -> bool
        """

    def __repr__(self):
        """
        
        """

    def __hash__(self):
        """
        
        """
    @property
    def Id(self) -> int: ...
    @property
    def Value(self) -> int: ...
# end of class WindowIDRef


def NewIdRef(count=1):
    """
    Reserves a new Window ID (or range of WindowIDs) and returns a
    :class:`wx.WindowIDRef` object (or list of them) that will help
    manage the reservation of that ID.
    
    This function is intended to be a drop-in replacement of the old
    and deprecated :func:`wx.NewId` function, with the added benefit
    that the ID should never conflict with an in-use ID or other IDs
    generated by this function.
    """
    pass
#-- end-windowid --#
#-- begin-platinfo --#

class _OperatingSystemId(IntEnum):
    OS_UNKNOWN = auto()
    OS_MAC_OS = auto()
    OS_MAC_OSX_DARWIN = auto()
    OS_MAC = auto()
    OS_WINDOWS_NT = auto()
    OS_WINDOWS = auto()
    OS_UNIX_LINUX = auto()
    OS_UNIX_FREEBSD = auto()
    OS_UNIX_OPENBSD = auto()
    OS_UNIX_NETBSD = auto()
    OS_UNIX_SOLARIS = auto()
    OS_UNIX_AIX = auto()
    OS_UNIX_HPUX = auto()
    OS_UNIX = auto()
OperatingSystemId: TypeAlias = Union[_OperatingSystemId, int]
OS_UNKNOWN = _OperatingSystemId.OS_UNKNOWN
OS_MAC_OS = _OperatingSystemId.OS_MAC_OS
OS_MAC_OSX_DARWIN = _OperatingSystemId.OS_MAC_OSX_DARWIN
OS_MAC = _OperatingSystemId.OS_MAC
OS_WINDOWS_NT = _OperatingSystemId.OS_WINDOWS_NT
OS_WINDOWS = _OperatingSystemId.OS_WINDOWS
OS_UNIX_LINUX = _OperatingSystemId.OS_UNIX_LINUX
OS_UNIX_FREEBSD = _OperatingSystemId.OS_UNIX_FREEBSD
OS_UNIX_OPENBSD = _OperatingSystemId.OS_UNIX_OPENBSD
OS_UNIX_NETBSD = _OperatingSystemId.OS_UNIX_NETBSD
OS_UNIX_SOLARIS = _OperatingSystemId.OS_UNIX_SOLARIS
OS_UNIX_AIX = _OperatingSystemId.OS_UNIX_AIX
OS_UNIX_HPUX = _OperatingSystemId.OS_UNIX_HPUX
OS_UNIX = _OperatingSystemId.OS_UNIX

class _PortId(IntEnum):
    PORT_UNKNOWN = auto()
    PORT_BASE = auto()
    PORT_MSW = auto()
    PORT_MOTIF = auto()
    PORT_GTK = auto()
    PORT_DFB = auto()
    PORT_X11 = auto()
    PORT_MAC = auto()
    PORT_COCOA = auto()
    PORT_QT = auto()
PortId: TypeAlias = Union[_PortId, int]
PORT_UNKNOWN = _PortId.PORT_UNKNOWN
PORT_BASE = _PortId.PORT_BASE
PORT_MSW = _PortId.PORT_MSW
PORT_MOTIF = _PortId.PORT_MOTIF
PORT_GTK = _PortId.PORT_GTK
PORT_DFB = _PortId.PORT_DFB
PORT_X11 = _PortId.PORT_X11
PORT_MAC = _PortId.PORT_MAC
PORT_COCOA = _PortId.PORT_COCOA
PORT_QT = _PortId.PORT_QT

class _Bitness(IntEnum):
    BITNESS_INVALID = auto()
    BITNESS_32 = auto()
    BITNESS_64 = auto()
    BITNESS_MAX = auto()
Bitness: TypeAlias = Union[_Bitness, int]
BITNESS_INVALID = _Bitness.BITNESS_INVALID
BITNESS_32 = _Bitness.BITNESS_32
BITNESS_64 = _Bitness.BITNESS_64
BITNESS_MAX = _Bitness.BITNESS_MAX

class _Architecture(IntEnum):
    ARCH_INVALID = auto()
    ARCH_32 = auto()
    ARCH_64 = auto()
    ARCH_MAX = auto()
Architecture: TypeAlias = Union[_Architecture, int]
ARCH_INVALID = _Architecture.ARCH_INVALID
ARCH_32 = _Architecture.ARCH_32
ARCH_64 = _Architecture.ARCH_64
ARCH_MAX = _Architecture.ARCH_MAX

class _Endianness(IntEnum):
    ENDIAN_INVALID = auto()
    ENDIAN_BIG = auto()
    ENDIAN_LITTLE = auto()
    ENDIAN_PDP = auto()
    ENDIAN_MAX = auto()
Endianness: TypeAlias = Union[_Endianness, int]
ENDIAN_INVALID = _Endianness.ENDIAN_INVALID
ENDIAN_BIG = _Endianness.ENDIAN_BIG
ENDIAN_LITTLE = _Endianness.ENDIAN_LITTLE
ENDIAN_PDP = _Endianness.ENDIAN_PDP
ENDIAN_MAX = _Endianness.ENDIAN_MAX

class PlatformInformation:
    """
    PlatformInfo() -> None
    PlatformInfo(pid, tkMajor=-1, tkMinor=-1, id=OS_UNKNOWN, osMajor=-1, osMinor=-1, bitness=BITNESS_INVALID, endian=ENDIAN_INVALID) -> None
    
    This class holds information about the operating system, the toolkit
    and the basic architecture bitness of the machine where the
    application is currently running.
    """

    @overload
    def __init__(self, pid: PortId, tkMajor: int=-1, tkMinor: int=-1, id: OperatingSystemId=OS_UNKNOWN, osMajor: int=-1, osMinor: int=-1, bitness: Bitness=BITNESS_INVALID, endian: Endianness=ENDIAN_INVALID) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        PlatformInfo() -> None
        PlatformInfo(pid, tkMajor=-1, tkMinor=-1, id=OS_UNKNOWN, osMajor=-1, osMinor=-1, bitness=BITNESS_INVALID, endian=ENDIAN_INVALID) -> None
        
        This class holds information about the operating system, the toolkit
        and the basic architecture bitness of the machine where the
        application is currently running.
        """

    def GetArchitecture(self) -> Architecture:
        """
        GetArchitecture() -> Architecture
        """

    def GetBitness(self) -> Bitness:
        """
        GetBitness() -> Bitness
        
        Returns the architecture bitness ID of this wxPlatformInfo instance.
        """

    def GetEndianness(self) -> Endianness:
        """
        GetEndianness() -> Endianness
        
        Returns the endianness ID of this wxPlatformInfo instance.
        """

    def GetCpuArchitectureName(self) -> str:
        """
        GetCpuArchitectureName() -> str
        
        Returns the CPU architecture name, if available.
        """

    def GetNativeCpuArchitectureName(self) -> str:
        """
        GetNativeCpuArchitectureName() -> str
        
        Returns the native CPU architecture name, if available.
        """

    def GetOSMajorVersion(self) -> int:
        """
        GetOSMajorVersion() -> int
        
        Returns the run-time major version of the OS associated with this
        wxPlatformInfo instance.
        """

    def GetOSMinorVersion(self) -> int:
        """
        GetOSMinorVersion() -> int
        
        Returns the run-time minor version of the OS associated with this
        wxPlatformInfo instance.
        """

    def GetOSMicroVersion(self) -> int:
        """
        GetOSMicroVersion() -> int
        
        Returns the run-time micro version of the OS associated with this
        wxPlatformInfo instance.
        """

    def GetOperatingSystemId(self) -> OperatingSystemId:
        """
        GetOperatingSystemId() -> OperatingSystemId
        
        Returns the operating system ID of this wxPlatformInfo instance.
        """

    def GetOperatingSystemDescription(self) -> str:
        """
        GetOperatingSystemDescription() -> str
        
        Returns the description of the operating system of this wxPlatformInfo
        instance.
        """

    def GetPortId(self) -> PortId:
        """
        GetPortId() -> PortId
        
        Returns the wxWidgets port ID associated with this wxPlatformInfo
        instance.
        """

    def GetLinuxDistributionInfo(self) -> LinuxDistributionInfo:
        """
        GetLinuxDistributionInfo() -> LinuxDistributionInfo
        
        Returns the Linux distribution info associated with this
        wxPlatformInfo instance.
        """

    def GetDesktopEnvironment(self) -> str:
        """
        GetDesktopEnvironment() -> str
        
        Returns the desktop environment associated with this wxPlatformInfo
        instance.
        """

    def GetToolkitMajorVersion(self) -> int:
        """
        GetToolkitMajorVersion() -> int
        
        Returns the run-time major version of the toolkit associated with this
        wxPlatformInfo instance.
        """

    def GetToolkitMinorVersion(self) -> int:
        """
        GetToolkitMinorVersion() -> int
        
        Returns the run-time minor version of the toolkit associated with this
        wxPlatformInfo instance.
        """

    def GetToolkitMicroVersion(self) -> int:
        """
        GetToolkitMicroVersion() -> int
        
        Returns the run-time micro version of the toolkit associated with this
        wxPlatformInfo instance.
        """

    def GetArchName(self) -> str:
        """
        GetArchName() -> str
        """

    @overload
    @staticmethod
    def GetBitnessName(bitness: Bitness) -> str:
        ...

    @overload
    def GetBitnessName(self) -> str:
        """
        GetBitnessName() -> str
        GetBitnessName(bitness) -> str
        
        Returns the name for the architecture bitness of this wxPlatformInfo
        instance.
        """

    def GetEndiannessName(self) -> str:
        """
        GetEndiannessName() -> str
        
        Returns the name for the endianness of this wxPlatformInfo instance.
        """

    def GetOperatingSystemFamilyName(self) -> str:
        """
        GetOperatingSystemFamilyName() -> str
        
        Returns the operating system family name of the OS associated with
        this wxPlatformInfo instance.
        """

    def GetOperatingSystemIdName(self) -> str:
        """
        GetOperatingSystemIdName() -> str
        
        Returns the operating system name of the OS associated with this
        wxPlatformInfo instance.
        """

    def GetPortIdName(self) -> str:
        """
        GetPortIdName() -> str
        
        Returns the name of the wxWidgets port ID associated with this
        wxPlatformInfo instance.
        """

    def GetPortIdShortName(self) -> str:
        """
        GetPortIdShortName() -> str
        
        Returns the short name of the wxWidgets port ID associated with this
        wxPlatformInfo instance.
        """

    def SetArchitecture(self, n: Architecture) -> None:
        """
        SetArchitecture(n) -> None
        """

    def SetBitness(self, n: Bitness) -> None:
        """
        SetBitness(n) -> None
        
        Sets the architecture bitness enum value associated with this
        wxPlatformInfo instance.
        """

    def SetEndianness(self, n: Endianness) -> None:
        """
        SetEndianness(n) -> None
        
        Sets the endianness enum value associated with this wxPlatformInfo
        instance.
        """

    def SetOSVersion(self, major: int, minor: int, micro: int=0) -> None:
        """
        SetOSVersion(major, minor, micro=0) -> None
        
        Sets the version of the operating system associated with this
        wxPlatformInfo instance.
        """

    def SetOperatingSystemId(self, n: OperatingSystemId) -> None:
        """
        SetOperatingSystemId(n) -> None
        
        Sets the operating system associated with this wxPlatformInfo
        instance.
        """

    def SetPortId(self, n: PortId) -> None:
        """
        SetPortId(n) -> None
        
        Sets the wxWidgets port ID associated with this wxPlatformInfo
        instance.
        """

    def SetToolkitVersion(self, major: int, minor: int, micro: int=0) -> None:
        """
        SetToolkitVersion(major, minor, micro=0) -> None
        
        Sets the version of the toolkit associated with this wxPlatformInfo
        instance.
        """

    def SetOperatingSystemDescription(self, desc: str) -> None:
        """
        SetOperatingSystemDescription(desc) -> None
        
        Sets the operating system description associated with this
        wxPlatformInfo instance.
        """

    def SetDesktopEnvironment(self, de: str) -> None:
        """
        SetDesktopEnvironment(de) -> None
        
        Sets the desktop environment associated with this wxPlatformInfo
        instance.
        """

    def SetLinuxDistributionInfo(self, di: LinuxDistributionInfo) -> None:
        """
        SetLinuxDistributionInfo(di) -> None
        
        Sets the linux distribution info associated with this wxPlatformInfo
        instance.
        """

    @staticmethod
    def GetArch(arch: str) -> Architecture:
        """
        GetArch(arch) -> Architecture
        """

    @staticmethod
    def GetOperatingSystemDirectory() -> str:
        """
        GetOperatingSystemDirectory() -> str
        
        Returns the operating system directory.
        """

    def CheckOSVersion(self, major: int, minor: int, micro: int=0) -> bool:
        """
        CheckOSVersion(major, minor, micro=0) -> bool
        
        Returns true if the OS version is at least major.minor.micro.
        """

    def CheckToolkitVersion(self, major: int, minor: int, micro: int=0) -> bool:
        """
        CheckToolkitVersion(major, minor, micro=0) -> bool
        
        Returns true if the toolkit version is at least major.minor.micro.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if this instance is fully initialized with valid values.
        """

    def IsUsingUniversalWidgets(self) -> bool:
        """
        IsUsingUniversalWidgets() -> bool
        
        Returns true if this wxPlatformInfo describes wxUniversal build.
        """

    def __ne__(self, t: PlatformInfo) -> bool:
        """
        """

    def __eq__(self, t: PlatformInfo) -> bool:
        """
        """

    @staticmethod
    def Get() -> PlatformInfo:
        """
        Get() -> PlatformInfo
        
        Returns the global wxPlatformInfo object, initialized with the values
        for the currently running platform.
        """
    @property
    def ArchName(self) -> str: ...
    @property
    def Architecture(self) -> Architecture: ...
    @Architecture.setter
    def Architecture(self, value: Architecture, /) -> None: ...
    @property
    def Bitness(self) -> Bitness: ...
    @Bitness.setter
    def Bitness(self, value: Bitness, /) -> None: ...
    @property
    def BitnessName(self) -> str: ...
    @property
    def CpuArchitectureName(self) -> str: ...
    @property
    def DesktopEnvironment(self) -> str: ...
    @DesktopEnvironment.setter
    def DesktopEnvironment(self, value: str, /) -> None: ...
    @property
    def Endianness(self) -> Endianness: ...
    @Endianness.setter
    def Endianness(self, value: Endianness, /) -> None: ...
    @property
    def EndiannessName(self) -> str: ...
    @property
    def LinuxDistributionInfo(self) -> LinuxDistributionInfo: ...
    @LinuxDistributionInfo.setter
    def LinuxDistributionInfo(self, value: LinuxDistributionInfo, /) -> None: ...
    @property
    def NativeCpuArchitectureName(self) -> str: ...
    @property
    def OSMajorVersion(self) -> int: ...
    @property
    def OSMicroVersion(self) -> int: ...
    @property
    def OSMinorVersion(self) -> int: ...
    @property
    def OperatingSystemDescription(self) -> str: ...
    @OperatingSystemDescription.setter
    def OperatingSystemDescription(self, value: str, /) -> None: ...
    @property
    def OperatingSystemFamilyName(self) -> str: ...
    @property
    def OperatingSystemId(self) -> OperatingSystemId: ...
    @OperatingSystemId.setter
    def OperatingSystemId(self, value: OperatingSystemId, /) -> None: ...
    @property
    def OperatingSystemIdName(self) -> str: ...
    @property
    def PortId(self) -> PortId: ...
    @PortId.setter
    def PortId(self, value: PortId, /) -> None: ...
    @property
    def PortIdName(self) -> str: ...
    @property
    def PortIdShortName(self) -> str: ...
    @property
    def ToolkitMajorVersion(self) -> int: ...
    @property
    def ToolkitMicroVersion(self) -> int: ...
    @property
    def ToolkitMinorVersion(self) -> int: ...
# end of class PlatformInformation


class LinuxDistributionInfo:
    """
    A structure containing information about a Linux distribution as
    returned by the lsb_release utility.
    """
    Id: str
    Release: str
    CodeName: str
    Description: str

    def __eq__(self, ldi: LinuxDistributionInfo) -> bool:
        """
        """

    def __ne__(self, ldi: LinuxDistributionInfo) -> bool:
        """
        """
# end of class LinuxDistributionInfo


class PlatformId:
    """
    Defines a very broad platform categorization.
    """
# end of class PlatformId


def IsRunningUnderWine() -> bool:    """
    IsRunningUnderWine() -> bool
    
    Returns true only for MSW programs running under Wine.
    """
#-- end-platinfo --#
#-- begin-vidmode --#

class VideoMode:
    """
    VideoMode(width=0, height=0, depth=0, freq=0) -> None
    
    Determines the sizes and locations of displays connected to the
    system.
    """

    def __init__(self, width: int=0, height: int=0, depth: int=0, freq: int=0) -> None:
        """
        VideoMode(width=0, height=0, depth=0, freq=0) -> None
        
        Determines the sizes and locations of displays connected to the
        system.
        """
    w: int
    h: int
    bpp: int
    refresh: int

    def Matches(self, other: VideoMode) -> bool:
        """
        Matches(other) -> bool
        
        Returns true if this mode matches the other one in the sense that all
        non zero fields of the other mode have the same value in this one
        (except for refresh which is allowed to have a greater value).
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Returns the screen width in pixels (e.g. 640), 0 means unspecified.
        """

    def GetHeight(self) -> int:
        """
        GetHeight() -> int
        
        Returns the screen height in pixels (e.g. 480), 0 means unspecified.
        """

    def GetDepth(self) -> int:
        """
        GetDepth() -> int
        
        Returns bits per pixel (e.g. 32), 1 is monochrome and 0 means
        unspecified/known.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the object has been initialized.
        """

    def __eq__(self, m: VideoMode) -> bool:
        """
        """

    def __ne__(self, mode: VideoMode) -> bool:
        """
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """
    @property
    def Depth(self) -> int: ...
    @property
    def Height(self) -> int: ...
    @property
    def Width(self) -> int: ...
# end of class VideoMode

DefaultVideoMode: VideoMode
#-- end-vidmode --#
#-- begin-display --#

class Display:
    """
    Display() -> None
    Display(index) -> None
    Display(window) -> None
    
    Determines the sizes and locations of displays connected to the
    system.
    """

    @overload
    def __init__(self, index: int) -> None:
        ...

    @overload
    def __init__(self, window: Window) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Display() -> None
        Display(index) -> None
        Display(window) -> None
        
        Determines the sizes and locations of displays connected to the
        system.
        """

    def ChangeMode(self, mode: VideoMode=DefaultVideoMode) -> bool:
        """
        ChangeMode(mode=DefaultVideoMode) -> bool
        
        Changes the video mode of this display to the mode specified in the
        mode parameter.
        """

    def GetClientArea(self) -> Rect:
        """
        GetClientArea() -> Rect
        
        Returns the client area of the display.
        """

    def GetCurrentMode(self) -> VideoMode:
        """
        GetCurrentMode() -> VideoMode
        
        Returns the current video mode that this display is in.
        """

    def GetGeometry(self) -> Rect:
        """
        GetGeometry() -> Rect
        
        Returns the bounding rectangle of the display whose index was passed
        to the constructor.
        """

    def GetModes(self, mode: VideoMode=DefaultVideoMode) -> List[VideoModes]:
        """
        GetModes(mode=DefaultVideoMode) -> List[VideoModes]
        
        Fills and returns an array with all the video modes that are supported
        by this display, or video modes that are supported by this display and
        match the mode parameter (if mode is not wxDefaultVideoMode).
        """

    def GetName(self) -> str:
        """
        GetName() -> str
        
        Returns the display's name.
        """

    def GetDepth(self) -> int:
        """
        GetDepth() -> int
        
        Returns display depth, i.e.
        """

    def GetPPI(self) -> Size:
        """
        GetPPI() -> Size
        
        Returns display resolution in pixels per inch.
        """

    def GetScaleFactor(self) -> float:
        """
        GetScaleFactor() -> float
        
        Returns scaling factor used by this display.
        """

    def IsPrimary(self) -> bool:
        """
        IsPrimary() -> bool
        
        Returns true if the display is the primary display.
        """

    @staticmethod
    def GetCount() -> int:
        """
        GetCount() -> int
        
        Returns the number of connected displays.
        """

    @staticmethod
    def GetFromPoint(pt: Point) -> int:
        """
        GetFromPoint(pt) -> int
        
        Returns the index of the display on which the given point lies, or
        wxNOT_FOUND if the point is not on any connected display.
        """

    @staticmethod
    def GetFromWindow(win: Window) -> int:
        """
        GetFromWindow(win) -> int
        
        Returns the index of the display on which the given window lies.
        """

    @staticmethod
    def GetStdPPIValue() -> int:
        """
        GetStdPPIValue() -> int
        
        Returns default display resolution for the current platform in pixels
        per inch.
        """

    @staticmethod
    def GetStdPPI() -> Size:
        """
        GetStdPPI() -> Size
        
        Returns default display resolution for the current platform as wxSize.
        """
    @property
    def ClientArea(self) -> Rect: ...
    @property
    def CurrentMode(self) -> VideoMode: ...
    @property
    def Geometry(self) -> Rect: ...
    @property
    def Name(self) -> str: ...
# end of class Display

#-- end-display --#
#-- begin-intl --#

class _Language(IntEnum):
    LANGUAGE_DEFAULT = auto()
    LANGUAGE_UNKNOWN = auto()
    LANGUAGE_ABKHAZIAN = auto()
    LANGUAGE_AFAR = auto()
    LANGUAGE_AFAR_DJIBOUTI = auto()
    LANGUAGE_AFAR_ERITREA = auto()
    LANGUAGE_AFAR_ETHIOPIA = auto()
    LANGUAGE_AFRIKAANS = auto()
    LANGUAGE_AFRIKAANS_NAMIBIA = auto()
    LANGUAGE_AFRIKAANS_SOUTH_AFRICA = auto()
    LANGUAGE_AGHEM = auto()
    LANGUAGE_AGHEM_CAMEROON = auto()
    LANGUAGE_AKAN = auto()
    LANGUAGE_AKAN_GHANA = auto()
    LANGUAGE_ALBANIAN = auto()
    LANGUAGE_ALBANIAN_ALBANIA = auto()
    LANGUAGE_ALBANIAN_KOSOVO = auto()
    LANGUAGE_ALBANIAN_NORTH_MACEDONIA = auto()
    LANGUAGE_ALSATIAN_FRANCE = auto()
    LANGUAGE_AMHARIC = auto()
    LANGUAGE_AMHARIC_ETHIOPIA = auto()
    LANGUAGE_ARABIC = auto()
    LANGUAGE_ARABIC_ALGERIA = auto()
    LANGUAGE_ARABIC_BAHRAIN = auto()
    LANGUAGE_ARABIC_CHAD = auto()
    LANGUAGE_ARABIC_COMOROS = auto()
    LANGUAGE_ARABIC_DJIBOUTI = auto()
    LANGUAGE_ARABIC_EGYPT = auto()
    LANGUAGE_ARABIC_ERITREA = auto()
    LANGUAGE_ARABIC_IRAQ = auto()
    LANGUAGE_ARABIC_ISRAEL = auto()
    LANGUAGE_ARABIC_JORDAN = auto()
    LANGUAGE_ARABIC_KUWAIT = auto()
    LANGUAGE_ARABIC_LEBANON = auto()
    LANGUAGE_ARABIC_LIBYA = auto()
    LANGUAGE_ARABIC_MAURITANIA = auto()
    LANGUAGE_ARABIC_MOROCCO = auto()
    LANGUAGE_ARABIC_OMAN = auto()
    LANGUAGE_ARABIC_PALESTINIAN_AUTHORITY = auto()
    LANGUAGE_ARABIC_QATAR = auto()
    LANGUAGE_ARABIC_SAUDI_ARABIA = auto()
    LANGUAGE_ARABIC_SOMALIA = auto()
    LANGUAGE_ARABIC_SOUTH_SUDAN = auto()
    LANGUAGE_ARABIC_SUDAN = auto()
    LANGUAGE_ARABIC_SYRIA = auto()
    LANGUAGE_ARABIC_TUNISIA = auto()
    LANGUAGE_ARABIC_UAE = auto()
    LANGUAGE_ARABIC_WORLD = auto()
    LANGUAGE_ARABIC_YEMEN = auto()
    LANGUAGE_ARMENIAN = auto()
    LANGUAGE_ARMENIAN_ARMENIA = auto()
    LANGUAGE_ASSAMESE = auto()
    LANGUAGE_ASSAMESE_INDIA = auto()
    LANGUAGE_ASTURIAN = auto()
    LANGUAGE_ASTURIAN_SPAIN = auto()
    LANGUAGE_ASU = auto()
    LANGUAGE_ASU_TANZANIA = auto()
    LANGUAGE_AYMARA = auto()
    LANGUAGE_AZERBAIJANI = auto()
    LANGUAGE_AZERBAIJANI_CYRILLIC = auto()
    LANGUAGE_AZERBAIJANI_CYRILLIC_AZERBAIJAN = auto()
    LANGUAGE_AZERBAIJANI_LATIN = auto()
    LANGUAGE_AZERBAIJANI_LATIN_AZERBAIJAN = auto()
    LANGUAGE_BAFIA = auto()
    LANGUAGE_BAFIA_CAMEROON = auto()
    LANGUAGE_BAMANANKAN = auto()
    LANGUAGE_BAMANANKAN_LATIN = auto()
    LANGUAGE_BAMANANKAN_LATIN_MALI = auto()
    LANGUAGE_BANGLA = auto()
    LANGUAGE_BANGLA_BANGLADESH = auto()
    LANGUAGE_BANGLA_INDIA = auto()
    LANGUAGE_BASAA = auto()
    LANGUAGE_BASAA_CAMEROON = auto()
    LANGUAGE_BASHKIR = auto()
    LANGUAGE_BASHKIR_RUSSIA = auto()
    LANGUAGE_BASQUE = auto()
    LANGUAGE_BASQUE_SPAIN = auto()
    LANGUAGE_BELARUSIAN = auto()
    LANGUAGE_BELARUSIAN_BELARUS = auto()
    LANGUAGE_BEMBA = auto()
    LANGUAGE_BEMBA_ZAMBIA = auto()
    LANGUAGE_BENA = auto()
    LANGUAGE_BENA_TANZANIA = auto()
    LANGUAGE_BIHARI = auto()
    LANGUAGE_BISLAMA = auto()
    LANGUAGE_BLIN = auto()
    LANGUAGE_BLIN_ERITREA = auto()
    LANGUAGE_BODO = auto()
    LANGUAGE_BODO_INDIA = auto()
    LANGUAGE_BOSNIAN = auto()
    LANGUAGE_BOSNIAN_CYRILLIC = auto()
    LANGUAGE_BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA = auto()
    LANGUAGE_BOSNIAN_LATIN = auto()
    LANGUAGE_BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA = auto()
    LANGUAGE_BRETON = auto()
    LANGUAGE_BRETON_FRANCE = auto()
    LANGUAGE_BULGARIAN = auto()
    LANGUAGE_BULGARIAN_BULGARIA = auto()
    LANGUAGE_BURMESE = auto()
    LANGUAGE_BURMESE_MYANMAR = auto()
    LANGUAGE_CATALAN = auto()
    LANGUAGE_CATALAN_ANDORRA = auto()
    LANGUAGE_CATALAN_FRANCE = auto()
    LANGUAGE_CATALAN_ITALY = auto()
    LANGUAGE_CATALAN_SPAIN = auto()
    LANGUAGE_CEBUANO = auto()
    LANGUAGE_CEBUANO_LATIN = auto()
    LANGUAGE_CEBUANO_LATIN_PHILIPPINES = auto()
    LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT = auto()
    LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC = auto()
    LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC_MOROCCO = auto()
    LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN = auto()
    LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_ALGERIA = auto()
    LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_MOROCCO = auto()
    LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH = auto()
    LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH_MOROCCO = auto()
    LANGUAGE_CENTRAL_KURDISH = auto()
    LANGUAGE_CENTRAL_KURDISH_IRAQ = auto()
    LANGUAGE_CHAKMA = auto()
    LANGUAGE_CHAKMA_CHAKMA = auto()
    LANGUAGE_CHAKMA_CHAKMA_BANGLADESH = auto()
    LANGUAGE_CHAKMA_CHAKMA_INDIA = auto()
    LANGUAGE_CHECHEN = auto()
    LANGUAGE_CHECHEN_RUSSIA = auto()
    LANGUAGE_CHEROKEE = auto()
    LANGUAGE_CHEROKEE_CHEROKEE = auto()
    LANGUAGE_CHEROKEE_US = auto()
    LANGUAGE_CHIGA = auto()
    LANGUAGE_CHIGA_UGANDA = auto()
    LANGUAGE_CHINESE = auto()
    LANGUAGE_CHINESE_CHINA = auto()
    LANGUAGE_CHINESE_HONGKONG = auto()
    LANGUAGE_CHINESE_MACAO = auto()
    LANGUAGE_CHINESE_SIMPLIFIED_EXPLICIT = auto()
    LANGUAGE_CHINESE_SIMPLIFIED_HONGKONG = auto()
    LANGUAGE_CHINESE_SIMPLIFIED_MACAO = auto()
    LANGUAGE_CHINESE_SINGAPORE = auto()
    LANGUAGE_CHINESE_TAIWAN = auto()
    LANGUAGE_CHINESE_TRADITIONAL_EXPLICIT = auto()
    LANGUAGE_CHURCH_SLAVIC = auto()
    LANGUAGE_CHURCH_SLAVIC_RUSSIA = auto()
    LANGUAGE_COLOGNIAN = auto()
    LANGUAGE_COLOGNIAN_GERMANY = auto()
    LANGUAGE_CORNISH = auto()
    LANGUAGE_CORNISH_UK = auto()
    LANGUAGE_CORSICAN = auto()
    LANGUAGE_CORSICAN_FRANCE = auto()
    LANGUAGE_CROATIAN = auto()
    LANGUAGE_CROATIAN_BOSNIA_AND_HERZEGOVINA = auto()
    LANGUAGE_CROATIAN_CROATIA = auto()
    LANGUAGE_CZECH = auto()
    LANGUAGE_CZECH_CZECHIA = auto()
    LANGUAGE_DANISH = auto()
    LANGUAGE_DANISH_DENMARK = auto()
    LANGUAGE_DANISH_GREENLAND = auto()
    LANGUAGE_DARI = auto()
    LANGUAGE_DARI_AFGHANISTAN = auto()
    LANGUAGE_DIVEHI = auto()
    LANGUAGE_DIVEHI_MALDIVES = auto()
    LANGUAGE_DUALA = auto()
    LANGUAGE_DUALA_CAMEROON = auto()
    LANGUAGE_DUTCH = auto()
    LANGUAGE_DUTCH_ARUBA = auto()
    LANGUAGE_DUTCH_BELGIAN = auto()
    LANGUAGE_DUTCH_BONAIRE_SINT_EUSTATIUS_AND_SABA = auto()
    LANGUAGE_DUTCH_CURACAO = auto()
    LANGUAGE_DUTCH_NETHERLANDS = auto()
    LANGUAGE_DUTCH_SINT_MAARTEN = auto()
    LANGUAGE_DUTCH_SURINAME = auto()
    LANGUAGE_DZONGKHA = auto()
    LANGUAGE_DZONGKHA_BHUTAN = auto()
    LANGUAGE_EDO = auto()
    LANGUAGE_EDO_NIGERIA = auto()
    LANGUAGE_EMBU = auto()
    LANGUAGE_EMBU_KENYA = auto()
    LANGUAGE_ENGLISH = auto()
    LANGUAGE_ENGLISH_AMERICAN_SAMOA = auto()
    LANGUAGE_ENGLISH_ANGUILLA = auto()
    LANGUAGE_ENGLISH_ANTIGUA_AND_BARBUDA = auto()
    LANGUAGE_ENGLISH_AUSTRALIA = auto()
    LANGUAGE_ENGLISH_AUSTRIA = auto()
    LANGUAGE_ENGLISH_BAHAMAS = auto()
    LANGUAGE_ENGLISH_BARBADOS = auto()
    LANGUAGE_ENGLISH_BELGIUM = auto()
    LANGUAGE_ENGLISH_BELIZE = auto()
    LANGUAGE_ENGLISH_BERMUDA = auto()
    LANGUAGE_ENGLISH_BOTSWANA = auto()
    LANGUAGE_ENGLISH_BRITISH_INDIAN_OCEAN_TERRITORY = auto()
    LANGUAGE_ENGLISH_BRITISH_VIRGIN_ISLANDS = auto()
    LANGUAGE_ENGLISH_BURUNDI = auto()
    LANGUAGE_ENGLISH_CAMEROON = auto()
    LANGUAGE_ENGLISH_CANADA = auto()
    LANGUAGE_ENGLISH_CARIBBEAN = auto()
    LANGUAGE_ENGLISH_CARIBBEAN_CB = auto()
    LANGUAGE_ENGLISH_CAYMAN_ISLANDS = auto()
    LANGUAGE_ENGLISH_CHRISTMAS_ISLAND = auto()
    LANGUAGE_ENGLISH_COCOS_KEELING_ISLANDS = auto()
    LANGUAGE_ENGLISH_COOK_ISLANDS = auto()
    LANGUAGE_ENGLISH_CYPRUS = auto()
    LANGUAGE_ENGLISH_DENMARK = auto()
    LANGUAGE_ENGLISH_DOMINICA = auto()
    LANGUAGE_ENGLISH_EIRE = auto()
    LANGUAGE_ENGLISH_ERITREA = auto()
    LANGUAGE_ENGLISH_ESWATINI = auto()
    LANGUAGE_ENGLISH_EUROPE = auto()
    LANGUAGE_ENGLISH_FALKLAND_ISLANDS = auto()
    LANGUAGE_ENGLISH_FIJI = auto()
    LANGUAGE_ENGLISH_FINLAND = auto()
    LANGUAGE_ENGLISH_GAMBIA = auto()
    LANGUAGE_ENGLISH_GERMANY = auto()
    LANGUAGE_ENGLISH_GHANA = auto()
    LANGUAGE_ENGLISH_GIBRALTAR = auto()
    LANGUAGE_ENGLISH_GRENADA = auto()
    LANGUAGE_ENGLISH_GUAM = auto()
    LANGUAGE_ENGLISH_GUERNSEY = auto()
    LANGUAGE_ENGLISH_GUYANA = auto()
    LANGUAGE_ENGLISH_HONG_KONG_SAR = auto()
    LANGUAGE_ENGLISH_INDIA = auto()
    LANGUAGE_ENGLISH_INDONESIA = auto()
    LANGUAGE_ENGLISH_ISLE_OF_MAN = auto()
    LANGUAGE_ENGLISH_ISRAEL = auto()
    LANGUAGE_ENGLISH_JAMAICA = auto()
    LANGUAGE_ENGLISH_JERSEY = auto()
    LANGUAGE_ENGLISH_KENYA = auto()
    LANGUAGE_ENGLISH_KIRIBATI = auto()
    LANGUAGE_ENGLISH_LESOTHO = auto()
    LANGUAGE_ENGLISH_LIBERIA = auto()
    LANGUAGE_ENGLISH_MACAO_SAR = auto()
    LANGUAGE_ENGLISH_MADAGASCAR = auto()
    LANGUAGE_ENGLISH_MALAWI = auto()
    LANGUAGE_ENGLISH_MALAYSIA = auto()
    LANGUAGE_ENGLISH_MALTA = auto()
    LANGUAGE_ENGLISH_MARSHALL_ISLANDS = auto()
    LANGUAGE_ENGLISH_MAURITIUS = auto()
    LANGUAGE_ENGLISH_MICRONESIA = auto()
    LANGUAGE_ENGLISH_MONTSERRAT = auto()
    LANGUAGE_ENGLISH_NAMIBIA = auto()
    LANGUAGE_ENGLISH_NAURU = auto()
    LANGUAGE_ENGLISH_NETHERLANDS = auto()
    LANGUAGE_ENGLISH_NEW_ZEALAND = auto()
    LANGUAGE_ENGLISH_NIGERIA = auto()
    LANGUAGE_ENGLISH_NIUE = auto()
    LANGUAGE_ENGLISH_NORFOLK_ISLAND = auto()
    LANGUAGE_ENGLISH_NORTHERN_MARIANA_ISLANDS = auto()
    LANGUAGE_ENGLISH_PAKISTAN = auto()
    LANGUAGE_ENGLISH_PALAU = auto()
    LANGUAGE_ENGLISH_PAPUA_NEW_GUINEA = auto()
    LANGUAGE_ENGLISH_PHILIPPINES = auto()
    LANGUAGE_ENGLISH_PITCAIRN_ISLANDS = auto()
    LANGUAGE_ENGLISH_PUERTO_RICO = auto()
    LANGUAGE_ENGLISH_RWANDA = auto()
    LANGUAGE_ENGLISH_SAMOA = auto()
    LANGUAGE_ENGLISH_SEYCHELLES = auto()
    LANGUAGE_ENGLISH_SIERRA_LEONE = auto()
    LANGUAGE_ENGLISH_SINGAPORE = auto()
    LANGUAGE_ENGLISH_SINT_MAARTEN = auto()
    LANGUAGE_ENGLISH_SLOVENIA = auto()
    LANGUAGE_ENGLISH_SOLOMON_ISLANDS = auto()
    LANGUAGE_ENGLISH_SOUTH_AFRICA = auto()
    LANGUAGE_ENGLISH_SOUTH_SUDAN = auto()
    LANGUAGE_ENGLISH_ST_HELENA_ASCENSION_TRISTAN_DA_CUNHA = auto()
    LANGUAGE_ENGLISH_ST_KITTS_AND_NEVIS = auto()
    LANGUAGE_ENGLISH_ST_LUCIA = auto()
    LANGUAGE_ENGLISH_ST_VINCENT_AND_GRENADINES = auto()
    LANGUAGE_ENGLISH_SUDAN = auto()
    LANGUAGE_ENGLISH_SWEDEN = auto()
    LANGUAGE_ENGLISH_SWITZERLAND = auto()
    LANGUAGE_ENGLISH_TANZANIA = auto()
    LANGUAGE_ENGLISH_TOKELAU = auto()
    LANGUAGE_ENGLISH_TONGA = auto()
    LANGUAGE_ENGLISH_TRINIDAD = auto()
    LANGUAGE_ENGLISH_TURKS_AND_CAICOS_ISLANDS = auto()
    LANGUAGE_ENGLISH_TUVALU = auto()
    LANGUAGE_ENGLISH_UGANDA = auto()
    LANGUAGE_ENGLISH_UK = auto()
    LANGUAGE_ENGLISH_UNITED_ARAB_EMIRATES = auto()
    LANGUAGE_ENGLISH_US = auto()
    LANGUAGE_ENGLISH_US_OUTLYING_ISLANDS = auto()
    LANGUAGE_ENGLISH_US_VIRGIN_ISLANDS = auto()
    LANGUAGE_ENGLISH_VANUATU = auto()
    LANGUAGE_ENGLISH_WORLD = auto()
    LANGUAGE_ENGLISH_ZAMBIA = auto()
    LANGUAGE_ENGLISH_ZIMBABWE = auto()
    LANGUAGE_ESPERANTO = auto()
    LANGUAGE_ESPERANTO_WORLD = auto()
    LANGUAGE_ESTONIAN = auto()
    LANGUAGE_ESTONIAN_ESTONIA = auto()
    LANGUAGE_EWE = auto()
    LANGUAGE_EWE_GHANA = auto()
    LANGUAGE_EWE_TOGO = auto()
    LANGUAGE_EWONDO = auto()
    LANGUAGE_EWONDO_CAMEROON = auto()
    LANGUAGE_FAEROESE = auto()
    LANGUAGE_FAEROESE_DENMARK = auto()
    LANGUAGE_FAEROESE_FAROE_ISLANDS = auto()
    LANGUAGE_FARSI = auto()
    LANGUAGE_FIJI = auto()
    LANGUAGE_FILIPINO = auto()
    LANGUAGE_FILIPINO_PHILIPPINES = auto()
    LANGUAGE_FINNISH = auto()
    LANGUAGE_FINNISH_FINLAND = auto()
    LANGUAGE_FRENCH = auto()
    LANGUAGE_FRENCH_ALGERIA = auto()
    LANGUAGE_FRENCH_BELGIAN = auto()
    LANGUAGE_FRENCH_BENIN = auto()
    LANGUAGE_FRENCH_BURKINA_FASO = auto()
    LANGUAGE_FRENCH_BURUNDI = auto()
    LANGUAGE_FRENCH_CAMEROON = auto()
    LANGUAGE_FRENCH_CANADIAN = auto()
    LANGUAGE_FRENCH_CARIBBEAN = auto()
    LANGUAGE_FRENCH_CENTRAL_AFRICAN_REPUBLIC = auto()
    LANGUAGE_FRENCH_CHAD = auto()
    LANGUAGE_FRENCH_COMOROS = auto()
    LANGUAGE_FRENCH_CONGO = auto()
    LANGUAGE_FRENCH_CONGO_DRC = auto()
    LANGUAGE_FRENCH_COTE_DIVOIRE = auto()
    LANGUAGE_FRENCH_DJIBOUTI = auto()
    LANGUAGE_FRENCH_EQUATORIAL_GUINEA = auto()
    LANGUAGE_FRENCH_FRANCE = auto()
    LANGUAGE_FRENCH_FRENCH_GUIANA = auto()
    LANGUAGE_FRENCH_FRENCH_POLYNESIA = auto()
    LANGUAGE_FRENCH_GABON = auto()
    LANGUAGE_FRENCH_GUADELOUPE = auto()
    LANGUAGE_FRENCH_GUINEA = auto()
    LANGUAGE_FRENCH_HAITI = auto()
    LANGUAGE_FRENCH_LUXEMBOURG = auto()
    LANGUAGE_FRENCH_MADAGASCAR = auto()
    LANGUAGE_FRENCH_MALI = auto()
    LANGUAGE_FRENCH_MARTINIQUE = auto()
    LANGUAGE_FRENCH_MAURITANIA = auto()
    LANGUAGE_FRENCH_MAURITIUS = auto()
    LANGUAGE_FRENCH_MAYOTTE = auto()
    LANGUAGE_FRENCH_MONACO = auto()
    LANGUAGE_FRENCH_MOROCCO = auto()
    LANGUAGE_FRENCH_NEW_CALEDONIA = auto()
    LANGUAGE_FRENCH_NIGER = auto()
    LANGUAGE_FRENCH_REUNION = auto()
    LANGUAGE_FRENCH_RWANDA = auto()
    LANGUAGE_FRENCH_SENEGAL = auto()
    LANGUAGE_FRENCH_SEYCHELLES = auto()
    LANGUAGE_FRENCH_ST_BARTHELEMY = auto()
    LANGUAGE_FRENCH_ST_MARTIN = auto()
    LANGUAGE_FRENCH_ST_PIERRE_AND_MIQUELON = auto()
    LANGUAGE_FRENCH_SWISS = auto()
    LANGUAGE_FRENCH_SYRIA = auto()
    LANGUAGE_FRENCH_TOGO = auto()
    LANGUAGE_FRENCH_TUNISIA = auto()
    LANGUAGE_FRENCH_VANUATU = auto()
    LANGUAGE_FRENCH_WALLIS_AND_FUTUNA = auto()
    LANGUAGE_FRISIAN = auto()
    LANGUAGE_FRISIAN_NETHERLANDS = auto()
    LANGUAGE_FRIULIAN = auto()
    LANGUAGE_FRIULIAN_ITALY = auto()
    LANGUAGE_FULAH = auto()
    LANGUAGE_FULAH_LATIN = auto()
    LANGUAGE_FULAH_LATIN_BURKINA_FASO = auto()
    LANGUAGE_FULAH_LATIN_CAMEROON = auto()
    LANGUAGE_FULAH_LATIN_GAMBIA = auto()
    LANGUAGE_FULAH_LATIN_GHANA = auto()
    LANGUAGE_FULAH_LATIN_GUINEA = auto()
    LANGUAGE_FULAH_LATIN_GUINEA_BISSAU = auto()
    LANGUAGE_FULAH_LATIN_LIBERIA = auto()
    LANGUAGE_FULAH_LATIN_MAURITANIA = auto()
    LANGUAGE_FULAH_LATIN_NIGER = auto()
    LANGUAGE_FULAH_LATIN_NIGERIA = auto()
    LANGUAGE_FULAH_LATIN_SENEGAL = auto()
    LANGUAGE_FULAH_LATIN_SIERRA_LEONE = auto()
    LANGUAGE_GALICIAN = auto()
    LANGUAGE_GALICIAN_SPAIN = auto()
    LANGUAGE_GANDA = auto()
    LANGUAGE_GANDA_UGANDA = auto()
    LANGUAGE_GEORGIAN = auto()
    LANGUAGE_GEORGIAN_GEORGIA = auto()
    LANGUAGE_GERMAN = auto()
    LANGUAGE_GERMAN_AUSTRIAN = auto()
    LANGUAGE_GERMAN_BELGIUM = auto()
    LANGUAGE_GERMAN_GERMANY = auto()
    LANGUAGE_GERMAN_ITALY = auto()
    LANGUAGE_GERMAN_LIECHTENSTEIN = auto()
    LANGUAGE_GERMAN_LUXEMBOURG = auto()
    LANGUAGE_GERMAN_SWISS = auto()
    LANGUAGE_GREEK = auto()
    LANGUAGE_GREEK_CYPRUS = auto()
    LANGUAGE_GREEK_GREECE = auto()
    LANGUAGE_GREENLANDIC = auto()
    LANGUAGE_GUARANI = auto()
    LANGUAGE_GUARANI_PARAGUAY = auto()
    LANGUAGE_GUJARATI = auto()
    LANGUAGE_GUJARATI_INDIA = auto()
    LANGUAGE_GUSII = auto()
    LANGUAGE_GUSII_KENYA = auto()
    LANGUAGE_HAUSA = auto()
    LANGUAGE_HAUSA_LATIN = auto()
    LANGUAGE_HAUSA_LATIN_GHANA = auto()
    LANGUAGE_HAUSA_LATIN_NIGER = auto()
    LANGUAGE_HAUSA_LATIN_NIGERIA = auto()
    LANGUAGE_HAWAIIAN = auto()
    LANGUAGE_HAWAIIAN_US = auto()
    LANGUAGE_HEBREW = auto()
    LANGUAGE_HEBREW_ISRAEL = auto()
    LANGUAGE_HINDI = auto()
    LANGUAGE_HINDI_INDIA = auto()
    LANGUAGE_HUNGARIAN = auto()
    LANGUAGE_HUNGARIAN_HUNGARY = auto()
    LANGUAGE_IBIBIO = auto()
    LANGUAGE_IBIBIO_NIGERIA = auto()
    LANGUAGE_ICELANDIC = auto()
    LANGUAGE_ICELANDIC_ICELAND = auto()
    LANGUAGE_IGBO = auto()
    LANGUAGE_IGBO_NIGERIA = auto()
    LANGUAGE_INDONESIAN = auto()
    LANGUAGE_INDONESIAN_INDONESIA = auto()
    LANGUAGE_INTERLINGUA = auto()
    LANGUAGE_INTERLINGUA_WORLD = auto()
    LANGUAGE_INTERLINGUE = auto()
    LANGUAGE_INUKTITUT = auto()
    LANGUAGE_INUKTITUT_LATIN = auto()
    LANGUAGE_INUKTITUT_LATIN_CANADA = auto()
    LANGUAGE_INUKTITUT_SYLLABICS = auto()
    LANGUAGE_INUKTITUT_SYLLABICS_CANADA = auto()
    LANGUAGE_INUPIAK = auto()
    LANGUAGE_IRISH = auto()
    LANGUAGE_IRISH_IRELAND = auto()
    LANGUAGE_ITALIAN = auto()
    LANGUAGE_ITALIAN_ITALY = auto()
    LANGUAGE_ITALIAN_SAN_MARINO = auto()
    LANGUAGE_ITALIAN_SWISS = auto()
    LANGUAGE_ITALIAN_VATICAN_CITY = auto()
    LANGUAGE_JAPANESE = auto()
    LANGUAGE_JAPANESE_JAPAN = auto()
    LANGUAGE_JAVANESE = auto()
    LANGUAGE_JAVANESE_INDONESIA = auto()
    LANGUAGE_JAVANESE_JAVANESE = auto()
    LANGUAGE_JAVANESE_JAVANESE_INDONESIA = auto()
    LANGUAGE_JOLA_FONYI = auto()
    LANGUAGE_JOLA_FONYI_SENEGAL = auto()
    LANGUAGE_KABUVERDIANU = auto()
    LANGUAGE_KABUVERDIANU_CABO_VERDE = auto()
    LANGUAGE_KABYLE = auto()
    LANGUAGE_KABYLE_ALGERIA = auto()
    LANGUAGE_KAKO = auto()
    LANGUAGE_KAKO_CAMEROON = auto()
    LANGUAGE_KALAALLISUT = auto()
    LANGUAGE_KALENJIN = auto()
    LANGUAGE_KALENJIN_KENYA = auto()
    LANGUAGE_KAMBA = auto()
    LANGUAGE_KAMBA_KENYA = auto()
    LANGUAGE_KANNADA = auto()
    LANGUAGE_KANNADA_INDIA = auto()
    LANGUAGE_KANURI = auto()
    LANGUAGE_KANURI_LATIN = auto()
    LANGUAGE_KANURI_NIGERIA = auto()
    LANGUAGE_KASHMIRI = auto()
    LANGUAGE_KASHMIRI_DEVANAGARI = auto()
    LANGUAGE_KASHMIRI_DEVANAGARI_INDIA = auto()
    LANGUAGE_KASHMIRI_INDIA = auto()
    LANGUAGE_KASHMIRI_PERSO_ARABIC = auto()
    LANGUAGE_KASHMIRI_PERSO_ARABIC_INDIA = auto()
    LANGUAGE_KAZAKH = auto()
    LANGUAGE_KAZAKH_KAZAKHSTAN = auto()
    LANGUAGE_KHMER = auto()
    LANGUAGE_KHMER_CAMBODIA = auto()
    LANGUAGE_KICHE = auto()
    LANGUAGE_KICHE_GUATEMALA = auto()
    LANGUAGE_KICHE_LATIN = auto()
    LANGUAGE_KIKUYU = auto()
    LANGUAGE_KIKUYU_KENYA = auto()
    LANGUAGE_KINYARWANDA = auto()
    LANGUAGE_KINYARWANDA_RWANDA = auto()
    LANGUAGE_KIRGHIZ = auto()
    LANGUAGE_KIRGHIZ_KYRGYZSTAN = auto()
    LANGUAGE_KIRUNDI = auto()
    LANGUAGE_KIRUNDI_BURUNDI = auto()
    LANGUAGE_KONKANI = auto()
    LANGUAGE_KONKANI_INDIA = auto()
    LANGUAGE_KOREAN = auto()
    LANGUAGE_KOREAN_KOREA = auto()
    LANGUAGE_KOREAN_NORTH_KOREA = auto()
    LANGUAGE_KOYRABORO_SENNI = auto()
    LANGUAGE_KOYRABORO_SENNI_MALI = auto()
    LANGUAGE_KOYRA_CHIINI = auto()
    LANGUAGE_KOYRA_CHIINI_MALI = auto()
    LANGUAGE_KURDISH = auto()
    LANGUAGE_KURDISH_PERSO_ARABIC_IRAN = auto()
    LANGUAGE_KWASIO = auto()
    LANGUAGE_KWASIO_CAMEROON = auto()
    LANGUAGE_LAKOTA = auto()
    LANGUAGE_LAKOTA_US = auto()
    LANGUAGE_LANGI = auto()
    LANGUAGE_LANGI_TANZANIA = auto()
    LANGUAGE_LAOTHIAN = auto()
    LANGUAGE_LAOTHIAN_LAOS = auto()
    LANGUAGE_LATIN = auto()
    LANGUAGE_LATIN_WORLD = auto()
    LANGUAGE_LATVIAN = auto()
    LANGUAGE_LATVIAN_LATVIA = auto()
    LANGUAGE_LINGALA = auto()
    LANGUAGE_LINGALA_ANGOLA = auto()
    LANGUAGE_LINGALA_CENTRAL_AFRICAN_REPUBLIC = auto()
    LANGUAGE_LINGALA_CONGO = auto()
    LANGUAGE_LINGALA_CONGO_DRC = auto()
    LANGUAGE_LITHUANIAN = auto()
    LANGUAGE_LITHUANIAN_LITHUANIA = auto()
    LANGUAGE_LOWER_SORBIAN = auto()
    LANGUAGE_LOWER_SORBIAN_GERMANY = auto()
    LANGUAGE_LOW_GERMAN = auto()
    LANGUAGE_LOW_GERMAN_GERMANY = auto()
    LANGUAGE_LOW_GERMAN_NETHERLANDS = auto()
    LANGUAGE_LUBA_KATANGA = auto()
    LANGUAGE_LUBA_KATANGA_CONGO_DRC = auto()
    LANGUAGE_LUO = auto()
    LANGUAGE_LUO_KENYA = auto()
    LANGUAGE_LUXEMBOURGISH = auto()
    LANGUAGE_LUXEMBOURGISH_LUXEMBOURG = auto()
    LANGUAGE_LUYIA = auto()
    LANGUAGE_LUYIA_KENYA = auto()
    LANGUAGE_MACEDONIAN = auto()
    LANGUAGE_MACEDONIAN_NORTH_MACEDONIA = auto()
    LANGUAGE_MACHAME = auto()
    LANGUAGE_MACHAME_TANZANIA = auto()
    LANGUAGE_MAKHUWA_MEETTO = auto()
    LANGUAGE_MAKHUWA_MEETTO_MOZAMBIQUE = auto()
    LANGUAGE_MAKONDE = auto()
    LANGUAGE_MAKONDE_TANZANIA = auto()
    LANGUAGE_MALAGASY = auto()
    LANGUAGE_MALAGASY_MADAGASCAR = auto()
    LANGUAGE_MALAY = auto()
    LANGUAGE_MALAYALAM = auto()
    LANGUAGE_MALAYALAM_INDIA = auto()
    LANGUAGE_MALAY_BRUNEI = auto()
    LANGUAGE_MALAY_MALAYSIA = auto()
    LANGUAGE_MALAY_SINGAPORE = auto()
    LANGUAGE_MALTESE = auto()
    LANGUAGE_MALTESE_MALTA = auto()
    LANGUAGE_MANIPURI = auto()
    LANGUAGE_MANIPURI_INDIA = auto()
    LANGUAGE_MANX = auto()
    LANGUAGE_MANX_ISLE_OF_MAN = auto()
    LANGUAGE_MAORI = auto()
    LANGUAGE_MAORI_NEW_ZEALAND = auto()
    LANGUAGE_MAPUCHE = auto()
    LANGUAGE_MAPUCHE_CHILE = auto()
    LANGUAGE_MARATHI = auto()
    LANGUAGE_MARATHI_INDIA = auto()
    LANGUAGE_MASAI = auto()
    LANGUAGE_MASAI_KENYA = auto()
    LANGUAGE_MASAI_TANZANIA = auto()
    LANGUAGE_MAZANDERANI = auto()
    LANGUAGE_MAZANDERANI_IRAN = auto()
    LANGUAGE_MERU = auto()
    LANGUAGE_MERU_KENYA = auto()
    LANGUAGE_META = auto()
    LANGUAGE_META_CAMEROON = auto()
    LANGUAGE_MOHAWK = auto()
    LANGUAGE_MOHAWK_CANADA = auto()
    LANGUAGE_MOLDAVIAN = auto()
    LANGUAGE_MONGOLIAN = auto()
    LANGUAGE_MONGOLIAN_CYRILLIC = auto()
    LANGUAGE_MONGOLIAN_MONGOLIA = auto()
    LANGUAGE_MONGOLIAN_TRADITIONAL = auto()
    LANGUAGE_MONGOLIAN_TRADITIONAL_CHINA = auto()
    LANGUAGE_MONGOLIAN_TRADITIONAL_MONGOLIA = auto()
    LANGUAGE_MORISYEN = auto()
    LANGUAGE_MORISYEN_MAURITIUS = auto()
    LANGUAGE_MUNDANG = auto()
    LANGUAGE_MUNDANG_CAMEROON = auto()
    LANGUAGE_NAMA = auto()
    LANGUAGE_NAMA_NAMIBIA = auto()
    LANGUAGE_NAURU = auto()
    LANGUAGE_NEPALI = auto()
    LANGUAGE_NEPALI_INDIA = auto()
    LANGUAGE_NEPALI_NEPAL = auto()
    LANGUAGE_NGIEMBOON = auto()
    LANGUAGE_NGIEMBOON_CAMEROON = auto()
    LANGUAGE_NGOMBA = auto()
    LANGUAGE_NGOMBA_CAMEROON = auto()
    LANGUAGE_NKO = auto()
    LANGUAGE_NKO_GUINEA = auto()
    LANGUAGE_NORTHERN_LURI = auto()
    LANGUAGE_NORTHERN_LURI_IRAN = auto()
    LANGUAGE_NORTHERN_LURI_IRAQ = auto()
    LANGUAGE_NORTH_NDEBELE = auto()
    LANGUAGE_NORTH_NDEBELE_ZIMBABWE = auto()
    LANGUAGE_NORWEGIAN = auto()
    LANGUAGE_NORWEGIAN_BOKMAL = auto()
    LANGUAGE_NORWEGIAN_BOKMAL_NORWAY = auto()
    LANGUAGE_NORWEGIAN_BOKMAL_SVALBARD_AND_JAN_MAYEN = auto()
    LANGUAGE_NORWEGIAN_NYNORSK = auto()
    LANGUAGE_NORWEGIAN_NYNORSK_NORWAY = auto()
    LANGUAGE_NUER = auto()
    LANGUAGE_NUER_SOUTH_SUDAN = auto()
    LANGUAGE_NYANKOLE = auto()
    LANGUAGE_NYANKOLE_UGANDA = auto()
    LANGUAGE_OCCITAN = auto()
    LANGUAGE_OCCITAN_FRANCE = auto()
    LANGUAGE_ODIA = auto()
    LANGUAGE_ODIA_INDIA = auto()
    LANGUAGE_OROMO = auto()
    LANGUAGE_OROMO_ETHIOPIA = auto()
    LANGUAGE_OROMO_KENYA = auto()
    LANGUAGE_OSSETIC = auto()
    LANGUAGE_OSSETIC_GEORGIA = auto()
    LANGUAGE_OSSETIC_RUSSIA = auto()
    LANGUAGE_PAPIAMENTO = auto()
    LANGUAGE_PAPIAMENTO_CARIBBEAN = auto()
    LANGUAGE_PASHTO = auto()
    LANGUAGE_PASHTO_AFGHANISTAN = auto()
    LANGUAGE_PASHTO_PAKISTAN = auto()
    LANGUAGE_PERSIAN_IRAN = auto()
    LANGUAGE_POLISH = auto()
    LANGUAGE_POLISH_POLAND = auto()
    LANGUAGE_PORTUGUESE = auto()
    LANGUAGE_PORTUGUESE_ANGOLA = auto()
    LANGUAGE_PORTUGUESE_BRAZILIAN = auto()
    LANGUAGE_PORTUGUESE_CABO_VERDE = auto()
    LANGUAGE_PORTUGUESE_EQUATORIAL_GUINEA = auto()
    LANGUAGE_PORTUGUESE_GUINEA_BISSAU = auto()
    LANGUAGE_PORTUGUESE_LUXEMBOURG = auto()
    LANGUAGE_PORTUGUESE_MACAO_SAR = auto()
    LANGUAGE_PORTUGUESE_MOZAMBIQUE = auto()
    LANGUAGE_PORTUGUESE_PORTUGAL = auto()
    LANGUAGE_PORTUGUESE_SAO_TOME_AND_PRINCIPE = auto()
    LANGUAGE_PORTUGUESE_SWITZERLAND = auto()
    LANGUAGE_PORTUGUESE_TIMOR_LESTE = auto()
    LANGUAGE_PRUSSIAN = auto()
    LANGUAGE_PRUSSIAN_WORLD = auto()
    LANGUAGE_PUNJABI = auto()
    LANGUAGE_PUNJABI_ARABIC = auto()
    LANGUAGE_PUNJABI_GURMUKHI = auto()
    LANGUAGE_PUNJABI_INDIA = auto()
    LANGUAGE_PUNJABI_PAKISTAN = auto()
    LANGUAGE_QUECHUA = auto()
    LANGUAGE_QUECHUA_BOLIVIA = auto()
    LANGUAGE_QUECHUA_ECUADOR = auto()
    LANGUAGE_QUECHUA_MACRO = auto()
    LANGUAGE_QUECHUA_PERU = auto()
    LANGUAGE_RHAETO_ROMANCE = auto()
    LANGUAGE_RHAETO_ROMANCE_SWITZERLAND = auto()
    LANGUAGE_ROMANIAN = auto()
    LANGUAGE_ROMANIAN_MOLDOVA = auto()
    LANGUAGE_ROMANIAN_ROMANIA = auto()
    LANGUAGE_ROMBO = auto()
    LANGUAGE_ROMBO_TANZANIA = auto()
    LANGUAGE_RUSSIAN = auto()
    LANGUAGE_RUSSIAN_BELARUS = auto()
    LANGUAGE_RUSSIAN_KAZAKHSTAN = auto()
    LANGUAGE_RUSSIAN_KYRGYZSTAN = auto()
    LANGUAGE_RUSSIAN_MOLDOVA = auto()
    LANGUAGE_RUSSIAN_RUSSIA = auto()
    LANGUAGE_RUSSIAN_UKRAINE = auto()
    LANGUAGE_RWA = auto()
    LANGUAGE_RWA_TANZANIA = auto()
    LANGUAGE_SAHO = auto()
    LANGUAGE_SAHO_ERITREA = auto()
    LANGUAGE_SAKHA = auto()
    LANGUAGE_SAKHA_RUSSIA = auto()
    LANGUAGE_SAMBURU = auto()
    LANGUAGE_SAMBURU_KENYA = auto()
    LANGUAGE_SAMI = auto()
    LANGUAGE_SAMI_FINLAND = auto()
    LANGUAGE_SAMI_INARI = auto()
    LANGUAGE_SAMI_INARI_FINLAND = auto()
    LANGUAGE_SAMI_LULE = auto()
    LANGUAGE_SAMI_LULE_NORWAY = auto()
    LANGUAGE_SAMI_LULE_SWEDEN = auto()
    LANGUAGE_SAMI_NORWAY = auto()
    LANGUAGE_SAMI_SKOLT = auto()
    LANGUAGE_SAMI_SKOLT_FINLAND = auto()
    LANGUAGE_SAMI_SOUTHERN = auto()
    LANGUAGE_SAMI_SOUTHERN_NORWAY = auto()
    LANGUAGE_SAMI_SOUTHERN_SWEDEN = auto()
    LANGUAGE_SAMI_SWEDEN = auto()
    LANGUAGE_SAMOAN = auto()
    LANGUAGE_SANGHO = auto()
    LANGUAGE_SANGHO_CENTRAL_AFRICAN_REPUBLIC = auto()
    LANGUAGE_SANGU = auto()
    LANGUAGE_SANGU_TANZANIA = auto()
    LANGUAGE_SANSKRIT = auto()
    LANGUAGE_SANSKRIT_INDIA = auto()
    LANGUAGE_SCOTS_GAELIC = auto()
    LANGUAGE_SCOTS_GAELIC_UK = auto()
    LANGUAGE_SENA = auto()
    LANGUAGE_SENA_MOZAMBIQUE = auto()
    LANGUAGE_SERBIAN = auto()
    LANGUAGE_SERBIAN_CYRILLIC = auto()
    LANGUAGE_SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA = auto()
    LANGUAGE_SERBIAN_CYRILLIC_KOSOVO = auto()
    LANGUAGE_SERBIAN_CYRILLIC_MONTENEGRO = auto()
    LANGUAGE_SERBIAN_CYRILLIC_SERBIA = auto()
    LANGUAGE_SERBIAN_CYRILLIC_YU = auto()
    LANGUAGE_SERBIAN_LATIN = auto()
    LANGUAGE_SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA = auto()
    LANGUAGE_SERBIAN_LATIN_KOSOVO = auto()
    LANGUAGE_SERBIAN_LATIN_MONTENEGRO = auto()
    LANGUAGE_SERBIAN_LATIN_SERBIA = auto()
    LANGUAGE_SERBIAN_LATIN_YU = auto()
    LANGUAGE_SERBIAN_SERBIA = auto()
    LANGUAGE_SERBIAN_YU = auto()
    LANGUAGE_SERBO_CROATIAN = auto()
    LANGUAGE_SESOTHO = auto()
    LANGUAGE_SESOTHO_LESOTHO = auto()
    LANGUAGE_SESOTHO_SA_LEBOA = auto()
    LANGUAGE_SESOTHO_SA_LEBOA_SOUTH_AFRICA = auto()
    LANGUAGE_SESOTHO_SOUTH_AFRICA = auto()
    LANGUAGE_SETSWANA = auto()
    LANGUAGE_SETSWANA_BOTSWANA = auto()
    LANGUAGE_SETSWANA_SOUTH_AFRICA = auto()
    LANGUAGE_SHAMBALA = auto()
    LANGUAGE_SHAMBALA_TANZANIA = auto()
    LANGUAGE_SHONA = auto()
    LANGUAGE_SHONA_LATIN = auto()
    LANGUAGE_SHONA_LATIN_ZIMBABWE = auto()
    LANGUAGE_SINDHI = auto()
    LANGUAGE_SINDHI_ARABIC = auto()
    LANGUAGE_SINDHI_DEVANAGARI = auto()
    LANGUAGE_SINDHI_DEVANAGARI_INDIA = auto()
    LANGUAGE_SINDHI_PAKISTAN = auto()
    LANGUAGE_SINHALESE = auto()
    LANGUAGE_SINHALESE_SRI_LANKA = auto()
    LANGUAGE_SISWATI = auto()
    LANGUAGE_SISWATI_ESWATINI = auto()
    LANGUAGE_SISWATI_SOUTH_AFRICA = auto()
    LANGUAGE_SLOVAK = auto()
    LANGUAGE_SLOVAK_SLOVAKIA = auto()
    LANGUAGE_SLOVENIAN = auto()
    LANGUAGE_SLOVENIAN_SLOVENIA = auto()
    LANGUAGE_SOGA = auto()
    LANGUAGE_SOGA_UGANDA = auto()
    LANGUAGE_SOMALI = auto()
    LANGUAGE_SOMALI_DJIBOUTI = auto()
    LANGUAGE_SOMALI_ETHIOPIA = auto()
    LANGUAGE_SOMALI_KENYA = auto()
    LANGUAGE_SOMALI_SOMALIA = auto()
    LANGUAGE_SOUTH_NDEBELE = auto()
    LANGUAGE_SOUTH_NDEBELE_SOUTH_AFRICA = auto()
    LANGUAGE_SPANISH = auto()
    LANGUAGE_SPANISH_ARGENTINA = auto()
    LANGUAGE_SPANISH_BELIZE = auto()
    LANGUAGE_SPANISH_BOLIVIA = auto()
    LANGUAGE_SPANISH_BRAZIL = auto()
    LANGUAGE_SPANISH_CHILE = auto()
    LANGUAGE_SPANISH_COLOMBIA = auto()
    LANGUAGE_SPANISH_COSTA_RICA = auto()
    LANGUAGE_SPANISH_CUBA = auto()
    LANGUAGE_SPANISH_DOMINICAN_REPUBLIC = auto()
    LANGUAGE_SPANISH_ECUADOR = auto()
    LANGUAGE_SPANISH_EL_SALVADOR = auto()
    LANGUAGE_SPANISH_EQUATORIAL_GUINEA = auto()
    LANGUAGE_SPANISH_GUATEMALA = auto()
    LANGUAGE_SPANISH_HONDURAS = auto()
    LANGUAGE_SPANISH_LATIN_AMERICA = auto()
    LANGUAGE_SPANISH_MEXICAN = auto()
    LANGUAGE_SPANISH_NICARAGUA = auto()
    LANGUAGE_SPANISH_PANAMA = auto()
    LANGUAGE_SPANISH_PARAGUAY = auto()
    LANGUAGE_SPANISH_PERU = auto()
    LANGUAGE_SPANISH_PHILIPPINES = auto()
    LANGUAGE_SPANISH_PUERTO_RICO = auto()
    LANGUAGE_SPANISH_SPAIN = auto()
    LANGUAGE_SPANISH_URUGUAY = auto()
    LANGUAGE_SPANISH_US = auto()
    LANGUAGE_SPANISH_VENEZUELA = auto()
    LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT = auto()
    LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH = auto()
    LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH_MOROCCO = auto()
    LANGUAGE_SUNDANESE = auto()
    LANGUAGE_SWAHILI = auto()
    LANGUAGE_SWAHILI_CONGO_DRC = auto()
    LANGUAGE_SWAHILI_KENYA = auto()
    LANGUAGE_SWAHILI_TANZANIA = auto()
    LANGUAGE_SWAHILI_UGANDA = auto()
    LANGUAGE_SWEDISH = auto()
    LANGUAGE_SWEDISH_ALAND_ISLANDS = auto()
    LANGUAGE_SWEDISH_FINLAND = auto()
    LANGUAGE_SWEDISH_SWEDEN = auto()
    LANGUAGE_SWISS_GERMAN = auto()
    LANGUAGE_SWISS_GERMAN_LIECHTENSTEIN = auto()
    LANGUAGE_SWISS_GERMAN_SWITZERLAND = auto()
    LANGUAGE_SYRIAC = auto()
    LANGUAGE_SYRIAC_SYRIA = auto()
    LANGUAGE_TACHELHIT = auto()
    LANGUAGE_TACHELHIT_LATIN = auto()
    LANGUAGE_TACHELHIT_LATIN_MOROCCO = auto()
    LANGUAGE_TACHELHIT_TIFINAGH = auto()
    LANGUAGE_TACHELHIT_TIFINAGH_MOROCCO = auto()
    LANGUAGE_TAGALOG = auto()
    LANGUAGE_TAITA = auto()
    LANGUAGE_TAITA_KENYA = auto()
    LANGUAGE_TAJIK = auto()
    LANGUAGE_TAJIK_CYRILLIC = auto()
    LANGUAGE_TAJIK_CYRILLIC_TAJIKISTAN = auto()
    LANGUAGE_TAMIL = auto()
    LANGUAGE_TAMIL_INDIA = auto()
    LANGUAGE_TAMIL_MALAYSIA = auto()
    LANGUAGE_TAMIL_SINGAPORE = auto()
    LANGUAGE_TAMIL_SRI_LANKA = auto()
    LANGUAGE_TASAWAQ = auto()
    LANGUAGE_TASAWAQ_NIGER = auto()
    LANGUAGE_TATAR = auto()
    LANGUAGE_TATAR_RUSSIA = auto()
    LANGUAGE_TELUGU = auto()
    LANGUAGE_TELUGU_INDIA = auto()
    LANGUAGE_TESO = auto()
    LANGUAGE_TESO_KENYA = auto()
    LANGUAGE_TESO_UGANDA = auto()
    LANGUAGE_THAI = auto()
    LANGUAGE_THAI_THAILAND = auto()
    LANGUAGE_TIBETAN = auto()
    LANGUAGE_TIBETAN_CHINA = auto()
    LANGUAGE_TIBETAN_INDIA = auto()
    LANGUAGE_TIGRE = auto()
    LANGUAGE_TIGRE_ERITREA = auto()
    LANGUAGE_TIGRINYA = auto()
    LANGUAGE_TIGRINYA_ERITREA = auto()
    LANGUAGE_TIGRINYA_ETHIOPIA = auto()
    LANGUAGE_TONGA = auto()
    LANGUAGE_TONGA_TONGA = auto()
    LANGUAGE_TSONGA = auto()
    LANGUAGE_TSONGA_SOUTH_AFRICA = auto()
    LANGUAGE_TURKISH = auto()
    LANGUAGE_TURKISH_CYPRUS = auto()
    LANGUAGE_TURKISH_TURKEY = auto()
    LANGUAGE_TURKMEN = auto()
    LANGUAGE_TURKMEN_TURKMENISTAN = auto()
    LANGUAGE_TWI = auto()
    LANGUAGE_UIGHUR = auto()
    LANGUAGE_UIGHUR_CHINA = auto()
    LANGUAGE_UKRAINIAN = auto()
    LANGUAGE_UKRAINIAN_UKRAINE = auto()
    LANGUAGE_UPPER_SORBIAN = auto()
    LANGUAGE_UPPER_SORBIAN_GERMANY = auto()
    LANGUAGE_URDU = auto()
    LANGUAGE_URDU_INDIA = auto()
    LANGUAGE_URDU_PAKISTAN = auto()
    LANGUAGE_UZBEK = auto()
    LANGUAGE_UZBEK_CYRILLIC = auto()
    LANGUAGE_UZBEK_CYRILLIC_UZBEKISTAN = auto()
    LANGUAGE_UZBEK_LATIN = auto()
    LANGUAGE_UZBEK_LATIN_UZBEKISTAN = auto()
    LANGUAGE_UZBEK_PERSO_ARABIC = auto()
    LANGUAGE_UZBEK_PERSO_ARABIC_AFGHANISTAN = auto()
    LANGUAGE_VAI = auto()
    LANGUAGE_VAI_LATIN = auto()
    LANGUAGE_VAI_LATIN_LIBERIA = auto()
    LANGUAGE_VAI_VAI = auto()
    LANGUAGE_VAI_VAI_LIBERIA = auto()
    LANGUAGE_VALENCIAN = auto()
    LANGUAGE_VENDA = auto()
    LANGUAGE_VENDA_SOUTH_AFRICA = auto()
    LANGUAGE_VIETNAMESE = auto()
    LANGUAGE_VIETNAMESE_VIETNAM = auto()
    LANGUAGE_VOLAPUK = auto()
    LANGUAGE_VOLAPUK_WORLD = auto()
    LANGUAGE_VUNJO = auto()
    LANGUAGE_VUNJO_TANZANIA = auto()
    LANGUAGE_WALSER = auto()
    LANGUAGE_WALSER_SWITZERLAND = auto()
    LANGUAGE_WELSH = auto()
    LANGUAGE_WELSH_UK = auto()
    LANGUAGE_WOLAYTTA = auto()
    LANGUAGE_WOLAYTTA_ETHIOPIA = auto()
    LANGUAGE_WOLOF = auto()
    LANGUAGE_WOLOF_SENEGAL = auto()
    LANGUAGE_XHOSA = auto()
    LANGUAGE_XHOSA_SOUTH_AFRICA = auto()
    LANGUAGE_YANGBEN = auto()
    LANGUAGE_YANGBEN_CAMEROON = auto()
    LANGUAGE_YI = auto()
    LANGUAGE_YIDDISH = auto()
    LANGUAGE_YIDDISH_WORLD = auto()
    LANGUAGE_YI_CHINA = auto()
    LANGUAGE_YORUBA = auto()
    LANGUAGE_YORUBA_BENIN = auto()
    LANGUAGE_YORUBA_NIGERIA = auto()
    LANGUAGE_ZARMA = auto()
    LANGUAGE_ZARMA_NIGER = auto()
    LANGUAGE_ZHUANG = auto()
    LANGUAGE_ZULU = auto()
    LANGUAGE_ZULU_SOUTH_AFRICA = auto()
    LANGUAGE_USER_DEFINED = auto()
    LANGUAGE_AZERI = auto()
    LANGUAGE_AZERI_CYRILLIC = auto()
    LANGUAGE_AZERI_LATIN = auto()
    LANGUAGE_BENGALI = auto()
    LANGUAGE_BENGALI_BANGLADESH = auto()
    LANGUAGE_BENGALI_INDIA = auto()
    LANGUAGE_BHUTANI = auto()
    LANGUAGE_CHINESE_SIMPLIFIED = auto()
    LANGUAGE_CHINESE_TRADITIONAL = auto()
    LANGUAGE_CHINESE_MACAU = auto()
    LANGUAGE_KERNEWEK = auto()
    LANGUAGE_MALAY_BRUNEI_DARUSSALAM = auto()
    LANGUAGE_ORIYA = auto()
    LANGUAGE_ORIYA_INDIA = auto()
    LANGUAGE_SPANISH_MODERN = auto()
    LANGUAGE_CAMBODIAN = auto()
Language: TypeAlias = Union[_Language, int]
LANGUAGE_DEFAULT = _Language.LANGUAGE_DEFAULT
LANGUAGE_UNKNOWN = _Language.LANGUAGE_UNKNOWN
LANGUAGE_ABKHAZIAN = _Language.LANGUAGE_ABKHAZIAN
LANGUAGE_AFAR = _Language.LANGUAGE_AFAR
LANGUAGE_AFAR_DJIBOUTI = _Language.LANGUAGE_AFAR_DJIBOUTI
LANGUAGE_AFAR_ERITREA = _Language.LANGUAGE_AFAR_ERITREA
LANGUAGE_AFAR_ETHIOPIA = _Language.LANGUAGE_AFAR_ETHIOPIA
LANGUAGE_AFRIKAANS = _Language.LANGUAGE_AFRIKAANS
LANGUAGE_AFRIKAANS_NAMIBIA = _Language.LANGUAGE_AFRIKAANS_NAMIBIA
LANGUAGE_AFRIKAANS_SOUTH_AFRICA = _Language.LANGUAGE_AFRIKAANS_SOUTH_AFRICA
LANGUAGE_AGHEM = _Language.LANGUAGE_AGHEM
LANGUAGE_AGHEM_CAMEROON = _Language.LANGUAGE_AGHEM_CAMEROON
LANGUAGE_AKAN = _Language.LANGUAGE_AKAN
LANGUAGE_AKAN_GHANA = _Language.LANGUAGE_AKAN_GHANA
LANGUAGE_ALBANIAN = _Language.LANGUAGE_ALBANIAN
LANGUAGE_ALBANIAN_ALBANIA = _Language.LANGUAGE_ALBANIAN_ALBANIA
LANGUAGE_ALBANIAN_KOSOVO = _Language.LANGUAGE_ALBANIAN_KOSOVO
LANGUAGE_ALBANIAN_NORTH_MACEDONIA = _Language.LANGUAGE_ALBANIAN_NORTH_MACEDONIA
LANGUAGE_ALSATIAN_FRANCE = _Language.LANGUAGE_ALSATIAN_FRANCE
LANGUAGE_AMHARIC = _Language.LANGUAGE_AMHARIC
LANGUAGE_AMHARIC_ETHIOPIA = _Language.LANGUAGE_AMHARIC_ETHIOPIA
LANGUAGE_ARABIC = _Language.LANGUAGE_ARABIC
LANGUAGE_ARABIC_ALGERIA = _Language.LANGUAGE_ARABIC_ALGERIA
LANGUAGE_ARABIC_BAHRAIN = _Language.LANGUAGE_ARABIC_BAHRAIN
LANGUAGE_ARABIC_CHAD = _Language.LANGUAGE_ARABIC_CHAD
LANGUAGE_ARABIC_COMOROS = _Language.LANGUAGE_ARABIC_COMOROS
LANGUAGE_ARABIC_DJIBOUTI = _Language.LANGUAGE_ARABIC_DJIBOUTI
LANGUAGE_ARABIC_EGYPT = _Language.LANGUAGE_ARABIC_EGYPT
LANGUAGE_ARABIC_ERITREA = _Language.LANGUAGE_ARABIC_ERITREA
LANGUAGE_ARABIC_IRAQ = _Language.LANGUAGE_ARABIC_IRAQ
LANGUAGE_ARABIC_ISRAEL = _Language.LANGUAGE_ARABIC_ISRAEL
LANGUAGE_ARABIC_JORDAN = _Language.LANGUAGE_ARABIC_JORDAN
LANGUAGE_ARABIC_KUWAIT = _Language.LANGUAGE_ARABIC_KUWAIT
LANGUAGE_ARABIC_LEBANON = _Language.LANGUAGE_ARABIC_LEBANON
LANGUAGE_ARABIC_LIBYA = _Language.LANGUAGE_ARABIC_LIBYA
LANGUAGE_ARABIC_MAURITANIA = _Language.LANGUAGE_ARABIC_MAURITANIA
LANGUAGE_ARABIC_MOROCCO = _Language.LANGUAGE_ARABIC_MOROCCO
LANGUAGE_ARABIC_OMAN = _Language.LANGUAGE_ARABIC_OMAN
LANGUAGE_ARABIC_PALESTINIAN_AUTHORITY = _Language.LANGUAGE_ARABIC_PALESTINIAN_AUTHORITY
LANGUAGE_ARABIC_QATAR = _Language.LANGUAGE_ARABIC_QATAR
LANGUAGE_ARABIC_SAUDI_ARABIA = _Language.LANGUAGE_ARABIC_SAUDI_ARABIA
LANGUAGE_ARABIC_SOMALIA = _Language.LANGUAGE_ARABIC_SOMALIA
LANGUAGE_ARABIC_SOUTH_SUDAN = _Language.LANGUAGE_ARABIC_SOUTH_SUDAN
LANGUAGE_ARABIC_SUDAN = _Language.LANGUAGE_ARABIC_SUDAN
LANGUAGE_ARABIC_SYRIA = _Language.LANGUAGE_ARABIC_SYRIA
LANGUAGE_ARABIC_TUNISIA = _Language.LANGUAGE_ARABIC_TUNISIA
LANGUAGE_ARABIC_UAE = _Language.LANGUAGE_ARABIC_UAE
LANGUAGE_ARABIC_WORLD = _Language.LANGUAGE_ARABIC_WORLD
LANGUAGE_ARABIC_YEMEN = _Language.LANGUAGE_ARABIC_YEMEN
LANGUAGE_ARMENIAN = _Language.LANGUAGE_ARMENIAN
LANGUAGE_ARMENIAN_ARMENIA = _Language.LANGUAGE_ARMENIAN_ARMENIA
LANGUAGE_ASSAMESE = _Language.LANGUAGE_ASSAMESE
LANGUAGE_ASSAMESE_INDIA = _Language.LANGUAGE_ASSAMESE_INDIA
LANGUAGE_ASTURIAN = _Language.LANGUAGE_ASTURIAN
LANGUAGE_ASTURIAN_SPAIN = _Language.LANGUAGE_ASTURIAN_SPAIN
LANGUAGE_ASU = _Language.LANGUAGE_ASU
LANGUAGE_ASU_TANZANIA = _Language.LANGUAGE_ASU_TANZANIA
LANGUAGE_AYMARA = _Language.LANGUAGE_AYMARA
LANGUAGE_AZERBAIJANI = _Language.LANGUAGE_AZERBAIJANI
LANGUAGE_AZERBAIJANI_CYRILLIC = _Language.LANGUAGE_AZERBAIJANI_CYRILLIC
LANGUAGE_AZERBAIJANI_CYRILLIC_AZERBAIJAN = _Language.LANGUAGE_AZERBAIJANI_CYRILLIC_AZERBAIJAN
LANGUAGE_AZERBAIJANI_LATIN = _Language.LANGUAGE_AZERBAIJANI_LATIN
LANGUAGE_AZERBAIJANI_LATIN_AZERBAIJAN = _Language.LANGUAGE_AZERBAIJANI_LATIN_AZERBAIJAN
LANGUAGE_BAFIA = _Language.LANGUAGE_BAFIA
LANGUAGE_BAFIA_CAMEROON = _Language.LANGUAGE_BAFIA_CAMEROON
LANGUAGE_BAMANANKAN = _Language.LANGUAGE_BAMANANKAN
LANGUAGE_BAMANANKAN_LATIN = _Language.LANGUAGE_BAMANANKAN_LATIN
LANGUAGE_BAMANANKAN_LATIN_MALI = _Language.LANGUAGE_BAMANANKAN_LATIN_MALI
LANGUAGE_BANGLA = _Language.LANGUAGE_BANGLA
LANGUAGE_BANGLA_BANGLADESH = _Language.LANGUAGE_BANGLA_BANGLADESH
LANGUAGE_BANGLA_INDIA = _Language.LANGUAGE_BANGLA_INDIA
LANGUAGE_BASAA = _Language.LANGUAGE_BASAA
LANGUAGE_BASAA_CAMEROON = _Language.LANGUAGE_BASAA_CAMEROON
LANGUAGE_BASHKIR = _Language.LANGUAGE_BASHKIR
LANGUAGE_BASHKIR_RUSSIA = _Language.LANGUAGE_BASHKIR_RUSSIA
LANGUAGE_BASQUE = _Language.LANGUAGE_BASQUE
LANGUAGE_BASQUE_SPAIN = _Language.LANGUAGE_BASQUE_SPAIN
LANGUAGE_BELARUSIAN = _Language.LANGUAGE_BELARUSIAN
LANGUAGE_BELARUSIAN_BELARUS = _Language.LANGUAGE_BELARUSIAN_BELARUS
LANGUAGE_BEMBA = _Language.LANGUAGE_BEMBA
LANGUAGE_BEMBA_ZAMBIA = _Language.LANGUAGE_BEMBA_ZAMBIA
LANGUAGE_BENA = _Language.LANGUAGE_BENA
LANGUAGE_BENA_TANZANIA = _Language.LANGUAGE_BENA_TANZANIA
LANGUAGE_BIHARI = _Language.LANGUAGE_BIHARI
LANGUAGE_BISLAMA = _Language.LANGUAGE_BISLAMA
LANGUAGE_BLIN = _Language.LANGUAGE_BLIN
LANGUAGE_BLIN_ERITREA = _Language.LANGUAGE_BLIN_ERITREA
LANGUAGE_BODO = _Language.LANGUAGE_BODO
LANGUAGE_BODO_INDIA = _Language.LANGUAGE_BODO_INDIA
LANGUAGE_BOSNIAN = _Language.LANGUAGE_BOSNIAN
LANGUAGE_BOSNIAN_CYRILLIC = _Language.LANGUAGE_BOSNIAN_CYRILLIC
LANGUAGE_BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA = _Language.LANGUAGE_BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA
LANGUAGE_BOSNIAN_LATIN = _Language.LANGUAGE_BOSNIAN_LATIN
LANGUAGE_BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA = _Language.LANGUAGE_BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA
LANGUAGE_BRETON = _Language.LANGUAGE_BRETON
LANGUAGE_BRETON_FRANCE = _Language.LANGUAGE_BRETON_FRANCE
LANGUAGE_BULGARIAN = _Language.LANGUAGE_BULGARIAN
LANGUAGE_BULGARIAN_BULGARIA = _Language.LANGUAGE_BULGARIAN_BULGARIA
LANGUAGE_BURMESE = _Language.LANGUAGE_BURMESE
LANGUAGE_BURMESE_MYANMAR = _Language.LANGUAGE_BURMESE_MYANMAR
LANGUAGE_CATALAN = _Language.LANGUAGE_CATALAN
LANGUAGE_CATALAN_ANDORRA = _Language.LANGUAGE_CATALAN_ANDORRA
LANGUAGE_CATALAN_FRANCE = _Language.LANGUAGE_CATALAN_FRANCE
LANGUAGE_CATALAN_ITALY = _Language.LANGUAGE_CATALAN_ITALY
LANGUAGE_CATALAN_SPAIN = _Language.LANGUAGE_CATALAN_SPAIN
LANGUAGE_CEBUANO = _Language.LANGUAGE_CEBUANO
LANGUAGE_CEBUANO_LATIN = _Language.LANGUAGE_CEBUANO_LATIN
LANGUAGE_CEBUANO_LATIN_PHILIPPINES = _Language.LANGUAGE_CEBUANO_LATIN_PHILIPPINES
LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT = _Language.LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT
LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC = _Language.LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC
LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC_MOROCCO = _Language.LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC_MOROCCO
LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN = _Language.LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN
LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_ALGERIA = _Language.LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_ALGERIA
LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_MOROCCO = _Language.LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_MOROCCO
LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH = _Language.LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH
LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH_MOROCCO = _Language.LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH_MOROCCO
LANGUAGE_CENTRAL_KURDISH = _Language.LANGUAGE_CENTRAL_KURDISH
LANGUAGE_CENTRAL_KURDISH_IRAQ = _Language.LANGUAGE_CENTRAL_KURDISH_IRAQ
LANGUAGE_CHAKMA = _Language.LANGUAGE_CHAKMA
LANGUAGE_CHAKMA_CHAKMA = _Language.LANGUAGE_CHAKMA_CHAKMA
LANGUAGE_CHAKMA_CHAKMA_BANGLADESH = _Language.LANGUAGE_CHAKMA_CHAKMA_BANGLADESH
LANGUAGE_CHAKMA_CHAKMA_INDIA = _Language.LANGUAGE_CHAKMA_CHAKMA_INDIA
LANGUAGE_CHECHEN = _Language.LANGUAGE_CHECHEN
LANGUAGE_CHECHEN_RUSSIA = _Language.LANGUAGE_CHECHEN_RUSSIA
LANGUAGE_CHEROKEE = _Language.LANGUAGE_CHEROKEE
LANGUAGE_CHEROKEE_CHEROKEE = _Language.LANGUAGE_CHEROKEE_CHEROKEE
LANGUAGE_CHEROKEE_US = _Language.LANGUAGE_CHEROKEE_US
LANGUAGE_CHIGA = _Language.LANGUAGE_CHIGA
LANGUAGE_CHIGA_UGANDA = _Language.LANGUAGE_CHIGA_UGANDA
LANGUAGE_CHINESE = _Language.LANGUAGE_CHINESE
LANGUAGE_CHINESE_CHINA = _Language.LANGUAGE_CHINESE_CHINA
LANGUAGE_CHINESE_HONGKONG = _Language.LANGUAGE_CHINESE_HONGKONG
LANGUAGE_CHINESE_MACAO = _Language.LANGUAGE_CHINESE_MACAO
LANGUAGE_CHINESE_SIMPLIFIED_EXPLICIT = _Language.LANGUAGE_CHINESE_SIMPLIFIED_EXPLICIT
LANGUAGE_CHINESE_SIMPLIFIED_HONGKONG = _Language.LANGUAGE_CHINESE_SIMPLIFIED_HONGKONG
LANGUAGE_CHINESE_SIMPLIFIED_MACAO = _Language.LANGUAGE_CHINESE_SIMPLIFIED_MACAO
LANGUAGE_CHINESE_SINGAPORE = _Language.LANGUAGE_CHINESE_SINGAPORE
LANGUAGE_CHINESE_TAIWAN = _Language.LANGUAGE_CHINESE_TAIWAN
LANGUAGE_CHINESE_TRADITIONAL_EXPLICIT = _Language.LANGUAGE_CHINESE_TRADITIONAL_EXPLICIT
LANGUAGE_CHURCH_SLAVIC = _Language.LANGUAGE_CHURCH_SLAVIC
LANGUAGE_CHURCH_SLAVIC_RUSSIA = _Language.LANGUAGE_CHURCH_SLAVIC_RUSSIA
LANGUAGE_COLOGNIAN = _Language.LANGUAGE_COLOGNIAN
LANGUAGE_COLOGNIAN_GERMANY = _Language.LANGUAGE_COLOGNIAN_GERMANY
LANGUAGE_CORNISH = _Language.LANGUAGE_CORNISH
LANGUAGE_CORNISH_UK = _Language.LANGUAGE_CORNISH_UK
LANGUAGE_CORSICAN = _Language.LANGUAGE_CORSICAN
LANGUAGE_CORSICAN_FRANCE = _Language.LANGUAGE_CORSICAN_FRANCE
LANGUAGE_CROATIAN = _Language.LANGUAGE_CROATIAN
LANGUAGE_CROATIAN_BOSNIA_AND_HERZEGOVINA = _Language.LANGUAGE_CROATIAN_BOSNIA_AND_HERZEGOVINA
LANGUAGE_CROATIAN_CROATIA = _Language.LANGUAGE_CROATIAN_CROATIA
LANGUAGE_CZECH = _Language.LANGUAGE_CZECH
LANGUAGE_CZECH_CZECHIA = _Language.LANGUAGE_CZECH_CZECHIA
LANGUAGE_DANISH = _Language.LANGUAGE_DANISH
LANGUAGE_DANISH_DENMARK = _Language.LANGUAGE_DANISH_DENMARK
LANGUAGE_DANISH_GREENLAND = _Language.LANGUAGE_DANISH_GREENLAND
LANGUAGE_DARI = _Language.LANGUAGE_DARI
LANGUAGE_DARI_AFGHANISTAN = _Language.LANGUAGE_DARI_AFGHANISTAN
LANGUAGE_DIVEHI = _Language.LANGUAGE_DIVEHI
LANGUAGE_DIVEHI_MALDIVES = _Language.LANGUAGE_DIVEHI_MALDIVES
LANGUAGE_DUALA = _Language.LANGUAGE_DUALA
LANGUAGE_DUALA_CAMEROON = _Language.LANGUAGE_DUALA_CAMEROON
LANGUAGE_DUTCH = _Language.LANGUAGE_DUTCH
LANGUAGE_DUTCH_ARUBA = _Language.LANGUAGE_DUTCH_ARUBA
LANGUAGE_DUTCH_BELGIAN = _Language.LANGUAGE_DUTCH_BELGIAN
LANGUAGE_DUTCH_BONAIRE_SINT_EUSTATIUS_AND_SABA = _Language.LANGUAGE_DUTCH_BONAIRE_SINT_EUSTATIUS_AND_SABA
LANGUAGE_DUTCH_CURACAO = _Language.LANGUAGE_DUTCH_CURACAO
LANGUAGE_DUTCH_NETHERLANDS = _Language.LANGUAGE_DUTCH_NETHERLANDS
LANGUAGE_DUTCH_SINT_MAARTEN = _Language.LANGUAGE_DUTCH_SINT_MAARTEN
LANGUAGE_DUTCH_SURINAME = _Language.LANGUAGE_DUTCH_SURINAME
LANGUAGE_DZONGKHA = _Language.LANGUAGE_DZONGKHA
LANGUAGE_DZONGKHA_BHUTAN = _Language.LANGUAGE_DZONGKHA_BHUTAN
LANGUAGE_EDO = _Language.LANGUAGE_EDO
LANGUAGE_EDO_NIGERIA = _Language.LANGUAGE_EDO_NIGERIA
LANGUAGE_EMBU = _Language.LANGUAGE_EMBU
LANGUAGE_EMBU_KENYA = _Language.LANGUAGE_EMBU_KENYA
LANGUAGE_ENGLISH = _Language.LANGUAGE_ENGLISH
LANGUAGE_ENGLISH_AMERICAN_SAMOA = _Language.LANGUAGE_ENGLISH_AMERICAN_SAMOA
LANGUAGE_ENGLISH_ANGUILLA = _Language.LANGUAGE_ENGLISH_ANGUILLA
LANGUAGE_ENGLISH_ANTIGUA_AND_BARBUDA = _Language.LANGUAGE_ENGLISH_ANTIGUA_AND_BARBUDA
LANGUAGE_ENGLISH_AUSTRALIA = _Language.LANGUAGE_ENGLISH_AUSTRALIA
LANGUAGE_ENGLISH_AUSTRIA = _Language.LANGUAGE_ENGLISH_AUSTRIA
LANGUAGE_ENGLISH_BAHAMAS = _Language.LANGUAGE_ENGLISH_BAHAMAS
LANGUAGE_ENGLISH_BARBADOS = _Language.LANGUAGE_ENGLISH_BARBADOS
LANGUAGE_ENGLISH_BELGIUM = _Language.LANGUAGE_ENGLISH_BELGIUM
LANGUAGE_ENGLISH_BELIZE = _Language.LANGUAGE_ENGLISH_BELIZE
LANGUAGE_ENGLISH_BERMUDA = _Language.LANGUAGE_ENGLISH_BERMUDA
LANGUAGE_ENGLISH_BOTSWANA = _Language.LANGUAGE_ENGLISH_BOTSWANA
LANGUAGE_ENGLISH_BRITISH_INDIAN_OCEAN_TERRITORY = _Language.LANGUAGE_ENGLISH_BRITISH_INDIAN_OCEAN_TERRITORY
LANGUAGE_ENGLISH_BRITISH_VIRGIN_ISLANDS = _Language.LANGUAGE_ENGLISH_BRITISH_VIRGIN_ISLANDS
LANGUAGE_ENGLISH_BURUNDI = _Language.LANGUAGE_ENGLISH_BURUNDI
LANGUAGE_ENGLISH_CAMEROON = _Language.LANGUAGE_ENGLISH_CAMEROON
LANGUAGE_ENGLISH_CANADA = _Language.LANGUAGE_ENGLISH_CANADA
LANGUAGE_ENGLISH_CARIBBEAN = _Language.LANGUAGE_ENGLISH_CARIBBEAN
LANGUAGE_ENGLISH_CARIBBEAN_CB = _Language.LANGUAGE_ENGLISH_CARIBBEAN_CB
LANGUAGE_ENGLISH_CAYMAN_ISLANDS = _Language.LANGUAGE_ENGLISH_CAYMAN_ISLANDS
LANGUAGE_ENGLISH_CHRISTMAS_ISLAND = _Language.LANGUAGE_ENGLISH_CHRISTMAS_ISLAND
LANGUAGE_ENGLISH_COCOS_KEELING_ISLANDS = _Language.LANGUAGE_ENGLISH_COCOS_KEELING_ISLANDS
LANGUAGE_ENGLISH_COOK_ISLANDS = _Language.LANGUAGE_ENGLISH_COOK_ISLANDS
LANGUAGE_ENGLISH_CYPRUS = _Language.LANGUAGE_ENGLISH_CYPRUS
LANGUAGE_ENGLISH_DENMARK = _Language.LANGUAGE_ENGLISH_DENMARK
LANGUAGE_ENGLISH_DOMINICA = _Language.LANGUAGE_ENGLISH_DOMINICA
LANGUAGE_ENGLISH_EIRE = _Language.LANGUAGE_ENGLISH_EIRE
LANGUAGE_ENGLISH_ERITREA = _Language.LANGUAGE_ENGLISH_ERITREA
LANGUAGE_ENGLISH_ESWATINI = _Language.LANGUAGE_ENGLISH_ESWATINI
LANGUAGE_ENGLISH_EUROPE = _Language.LANGUAGE_ENGLISH_EUROPE
LANGUAGE_ENGLISH_FALKLAND_ISLANDS = _Language.LANGUAGE_ENGLISH_FALKLAND_ISLANDS
LANGUAGE_ENGLISH_FIJI = _Language.LANGUAGE_ENGLISH_FIJI
LANGUAGE_ENGLISH_FINLAND = _Language.LANGUAGE_ENGLISH_FINLAND
LANGUAGE_ENGLISH_GAMBIA = _Language.LANGUAGE_ENGLISH_GAMBIA
LANGUAGE_ENGLISH_GERMANY = _Language.LANGUAGE_ENGLISH_GERMANY
LANGUAGE_ENGLISH_GHANA = _Language.LANGUAGE_ENGLISH_GHANA
LANGUAGE_ENGLISH_GIBRALTAR = _Language.LANGUAGE_ENGLISH_GIBRALTAR
LANGUAGE_ENGLISH_GRENADA = _Language.LANGUAGE_ENGLISH_GRENADA
LANGUAGE_ENGLISH_GUAM = _Language.LANGUAGE_ENGLISH_GUAM
LANGUAGE_ENGLISH_GUERNSEY = _Language.LANGUAGE_ENGLISH_GUERNSEY
LANGUAGE_ENGLISH_GUYANA = _Language.LANGUAGE_ENGLISH_GUYANA
LANGUAGE_ENGLISH_HONG_KONG_SAR = _Language.LANGUAGE_ENGLISH_HONG_KONG_SAR
LANGUAGE_ENGLISH_INDIA = _Language.LANGUAGE_ENGLISH_INDIA
LANGUAGE_ENGLISH_INDONESIA = _Language.LANGUAGE_ENGLISH_INDONESIA
LANGUAGE_ENGLISH_ISLE_OF_MAN = _Language.LANGUAGE_ENGLISH_ISLE_OF_MAN
LANGUAGE_ENGLISH_ISRAEL = _Language.LANGUAGE_ENGLISH_ISRAEL
LANGUAGE_ENGLISH_JAMAICA = _Language.LANGUAGE_ENGLISH_JAMAICA
LANGUAGE_ENGLISH_JERSEY = _Language.LANGUAGE_ENGLISH_JERSEY
LANGUAGE_ENGLISH_KENYA = _Language.LANGUAGE_ENGLISH_KENYA
LANGUAGE_ENGLISH_KIRIBATI = _Language.LANGUAGE_ENGLISH_KIRIBATI
LANGUAGE_ENGLISH_LESOTHO = _Language.LANGUAGE_ENGLISH_LESOTHO
LANGUAGE_ENGLISH_LIBERIA = _Language.LANGUAGE_ENGLISH_LIBERIA
LANGUAGE_ENGLISH_MACAO_SAR = _Language.LANGUAGE_ENGLISH_MACAO_SAR
LANGUAGE_ENGLISH_MADAGASCAR = _Language.LANGUAGE_ENGLISH_MADAGASCAR
LANGUAGE_ENGLISH_MALAWI = _Language.LANGUAGE_ENGLISH_MALAWI
LANGUAGE_ENGLISH_MALAYSIA = _Language.LANGUAGE_ENGLISH_MALAYSIA
LANGUAGE_ENGLISH_MALTA = _Language.LANGUAGE_ENGLISH_MALTA
LANGUAGE_ENGLISH_MARSHALL_ISLANDS = _Language.LANGUAGE_ENGLISH_MARSHALL_ISLANDS
LANGUAGE_ENGLISH_MAURITIUS = _Language.LANGUAGE_ENGLISH_MAURITIUS
LANGUAGE_ENGLISH_MICRONESIA = _Language.LANGUAGE_ENGLISH_MICRONESIA
LANGUAGE_ENGLISH_MONTSERRAT = _Language.LANGUAGE_ENGLISH_MONTSERRAT
LANGUAGE_ENGLISH_NAMIBIA = _Language.LANGUAGE_ENGLISH_NAMIBIA
LANGUAGE_ENGLISH_NAURU = _Language.LANGUAGE_ENGLISH_NAURU
LANGUAGE_ENGLISH_NETHERLANDS = _Language.LANGUAGE_ENGLISH_NETHERLANDS
LANGUAGE_ENGLISH_NEW_ZEALAND = _Language.LANGUAGE_ENGLISH_NEW_ZEALAND
LANGUAGE_ENGLISH_NIGERIA = _Language.LANGUAGE_ENGLISH_NIGERIA
LANGUAGE_ENGLISH_NIUE = _Language.LANGUAGE_ENGLISH_NIUE
LANGUAGE_ENGLISH_NORFOLK_ISLAND = _Language.LANGUAGE_ENGLISH_NORFOLK_ISLAND
LANGUAGE_ENGLISH_NORTHERN_MARIANA_ISLANDS = _Language.LANGUAGE_ENGLISH_NORTHERN_MARIANA_ISLANDS
LANGUAGE_ENGLISH_PAKISTAN = _Language.LANGUAGE_ENGLISH_PAKISTAN
LANGUAGE_ENGLISH_PALAU = _Language.LANGUAGE_ENGLISH_PALAU
LANGUAGE_ENGLISH_PAPUA_NEW_GUINEA = _Language.LANGUAGE_ENGLISH_PAPUA_NEW_GUINEA
LANGUAGE_ENGLISH_PHILIPPINES = _Language.LANGUAGE_ENGLISH_PHILIPPINES
LANGUAGE_ENGLISH_PITCAIRN_ISLANDS = _Language.LANGUAGE_ENGLISH_PITCAIRN_ISLANDS
LANGUAGE_ENGLISH_PUERTO_RICO = _Language.LANGUAGE_ENGLISH_PUERTO_RICO
LANGUAGE_ENGLISH_RWANDA = _Language.LANGUAGE_ENGLISH_RWANDA
LANGUAGE_ENGLISH_SAMOA = _Language.LANGUAGE_ENGLISH_SAMOA
LANGUAGE_ENGLISH_SEYCHELLES = _Language.LANGUAGE_ENGLISH_SEYCHELLES
LANGUAGE_ENGLISH_SIERRA_LEONE = _Language.LANGUAGE_ENGLISH_SIERRA_LEONE
LANGUAGE_ENGLISH_SINGAPORE = _Language.LANGUAGE_ENGLISH_SINGAPORE
LANGUAGE_ENGLISH_SINT_MAARTEN = _Language.LANGUAGE_ENGLISH_SINT_MAARTEN
LANGUAGE_ENGLISH_SLOVENIA = _Language.LANGUAGE_ENGLISH_SLOVENIA
LANGUAGE_ENGLISH_SOLOMON_ISLANDS = _Language.LANGUAGE_ENGLISH_SOLOMON_ISLANDS
LANGUAGE_ENGLISH_SOUTH_AFRICA = _Language.LANGUAGE_ENGLISH_SOUTH_AFRICA
LANGUAGE_ENGLISH_SOUTH_SUDAN = _Language.LANGUAGE_ENGLISH_SOUTH_SUDAN
LANGUAGE_ENGLISH_ST_HELENA_ASCENSION_TRISTAN_DA_CUNHA = _Language.LANGUAGE_ENGLISH_ST_HELENA_ASCENSION_TRISTAN_DA_CUNHA
LANGUAGE_ENGLISH_ST_KITTS_AND_NEVIS = _Language.LANGUAGE_ENGLISH_ST_KITTS_AND_NEVIS
LANGUAGE_ENGLISH_ST_LUCIA = _Language.LANGUAGE_ENGLISH_ST_LUCIA
LANGUAGE_ENGLISH_ST_VINCENT_AND_GRENADINES = _Language.LANGUAGE_ENGLISH_ST_VINCENT_AND_GRENADINES
LANGUAGE_ENGLISH_SUDAN = _Language.LANGUAGE_ENGLISH_SUDAN
LANGUAGE_ENGLISH_SWEDEN = _Language.LANGUAGE_ENGLISH_SWEDEN
LANGUAGE_ENGLISH_SWITZERLAND = _Language.LANGUAGE_ENGLISH_SWITZERLAND
LANGUAGE_ENGLISH_TANZANIA = _Language.LANGUAGE_ENGLISH_TANZANIA
LANGUAGE_ENGLISH_TOKELAU = _Language.LANGUAGE_ENGLISH_TOKELAU
LANGUAGE_ENGLISH_TONGA = _Language.LANGUAGE_ENGLISH_TONGA
LANGUAGE_ENGLISH_TRINIDAD = _Language.LANGUAGE_ENGLISH_TRINIDAD
LANGUAGE_ENGLISH_TURKS_AND_CAICOS_ISLANDS = _Language.LANGUAGE_ENGLISH_TURKS_AND_CAICOS_ISLANDS
LANGUAGE_ENGLISH_TUVALU = _Language.LANGUAGE_ENGLISH_TUVALU
LANGUAGE_ENGLISH_UGANDA = _Language.LANGUAGE_ENGLISH_UGANDA
LANGUAGE_ENGLISH_UK = _Language.LANGUAGE_ENGLISH_UK
LANGUAGE_ENGLISH_UNITED_ARAB_EMIRATES = _Language.LANGUAGE_ENGLISH_UNITED_ARAB_EMIRATES
LANGUAGE_ENGLISH_US = _Language.LANGUAGE_ENGLISH_US
LANGUAGE_ENGLISH_US_OUTLYING_ISLANDS = _Language.LANGUAGE_ENGLISH_US_OUTLYING_ISLANDS
LANGUAGE_ENGLISH_US_VIRGIN_ISLANDS = _Language.LANGUAGE_ENGLISH_US_VIRGIN_ISLANDS
LANGUAGE_ENGLISH_VANUATU = _Language.LANGUAGE_ENGLISH_VANUATU
LANGUAGE_ENGLISH_WORLD = _Language.LANGUAGE_ENGLISH_WORLD
LANGUAGE_ENGLISH_ZAMBIA = _Language.LANGUAGE_ENGLISH_ZAMBIA
LANGUAGE_ENGLISH_ZIMBABWE = _Language.LANGUAGE_ENGLISH_ZIMBABWE
LANGUAGE_ESPERANTO = _Language.LANGUAGE_ESPERANTO
LANGUAGE_ESPERANTO_WORLD = _Language.LANGUAGE_ESPERANTO_WORLD
LANGUAGE_ESTONIAN = _Language.LANGUAGE_ESTONIAN
LANGUAGE_ESTONIAN_ESTONIA = _Language.LANGUAGE_ESTONIAN_ESTONIA
LANGUAGE_EWE = _Language.LANGUAGE_EWE
LANGUAGE_EWE_GHANA = _Language.LANGUAGE_EWE_GHANA
LANGUAGE_EWE_TOGO = _Language.LANGUAGE_EWE_TOGO
LANGUAGE_EWONDO = _Language.LANGUAGE_EWONDO
LANGUAGE_EWONDO_CAMEROON = _Language.LANGUAGE_EWONDO_CAMEROON
LANGUAGE_FAEROESE = _Language.LANGUAGE_FAEROESE
LANGUAGE_FAEROESE_DENMARK = _Language.LANGUAGE_FAEROESE_DENMARK
LANGUAGE_FAEROESE_FAROE_ISLANDS = _Language.LANGUAGE_FAEROESE_FAROE_ISLANDS
LANGUAGE_FARSI = _Language.LANGUAGE_FARSI
LANGUAGE_FIJI = _Language.LANGUAGE_FIJI
LANGUAGE_FILIPINO = _Language.LANGUAGE_FILIPINO
LANGUAGE_FILIPINO_PHILIPPINES = _Language.LANGUAGE_FILIPINO_PHILIPPINES
LANGUAGE_FINNISH = _Language.LANGUAGE_FINNISH
LANGUAGE_FINNISH_FINLAND = _Language.LANGUAGE_FINNISH_FINLAND
LANGUAGE_FRENCH = _Language.LANGUAGE_FRENCH
LANGUAGE_FRENCH_ALGERIA = _Language.LANGUAGE_FRENCH_ALGERIA
LANGUAGE_FRENCH_BELGIAN = _Language.LANGUAGE_FRENCH_BELGIAN
LANGUAGE_FRENCH_BENIN = _Language.LANGUAGE_FRENCH_BENIN
LANGUAGE_FRENCH_BURKINA_FASO = _Language.LANGUAGE_FRENCH_BURKINA_FASO
LANGUAGE_FRENCH_BURUNDI = _Language.LANGUAGE_FRENCH_BURUNDI
LANGUAGE_FRENCH_CAMEROON = _Language.LANGUAGE_FRENCH_CAMEROON
LANGUAGE_FRENCH_CANADIAN = _Language.LANGUAGE_FRENCH_CANADIAN
LANGUAGE_FRENCH_CARIBBEAN = _Language.LANGUAGE_FRENCH_CARIBBEAN
LANGUAGE_FRENCH_CENTRAL_AFRICAN_REPUBLIC = _Language.LANGUAGE_FRENCH_CENTRAL_AFRICAN_REPUBLIC
LANGUAGE_FRENCH_CHAD = _Language.LANGUAGE_FRENCH_CHAD
LANGUAGE_FRENCH_COMOROS = _Language.LANGUAGE_FRENCH_COMOROS
LANGUAGE_FRENCH_CONGO = _Language.LANGUAGE_FRENCH_CONGO
LANGUAGE_FRENCH_CONGO_DRC = _Language.LANGUAGE_FRENCH_CONGO_DRC
LANGUAGE_FRENCH_COTE_DIVOIRE = _Language.LANGUAGE_FRENCH_COTE_DIVOIRE
LANGUAGE_FRENCH_DJIBOUTI = _Language.LANGUAGE_FRENCH_DJIBOUTI
LANGUAGE_FRENCH_EQUATORIAL_GUINEA = _Language.LANGUAGE_FRENCH_EQUATORIAL_GUINEA
LANGUAGE_FRENCH_FRANCE = _Language.LANGUAGE_FRENCH_FRANCE
LANGUAGE_FRENCH_FRENCH_GUIANA = _Language.LANGUAGE_FRENCH_FRENCH_GUIANA
LANGUAGE_FRENCH_FRENCH_POLYNESIA = _Language.LANGUAGE_FRENCH_FRENCH_POLYNESIA
LANGUAGE_FRENCH_GABON = _Language.LANGUAGE_FRENCH_GABON
LANGUAGE_FRENCH_GUADELOUPE = _Language.LANGUAGE_FRENCH_GUADELOUPE
LANGUAGE_FRENCH_GUINEA = _Language.LANGUAGE_FRENCH_GUINEA
LANGUAGE_FRENCH_HAITI = _Language.LANGUAGE_FRENCH_HAITI
LANGUAGE_FRENCH_LUXEMBOURG = _Language.LANGUAGE_FRENCH_LUXEMBOURG
LANGUAGE_FRENCH_MADAGASCAR = _Language.LANGUAGE_FRENCH_MADAGASCAR
LANGUAGE_FRENCH_MALI = _Language.LANGUAGE_FRENCH_MALI
LANGUAGE_FRENCH_MARTINIQUE = _Language.LANGUAGE_FRENCH_MARTINIQUE
LANGUAGE_FRENCH_MAURITANIA = _Language.LANGUAGE_FRENCH_MAURITANIA
LANGUAGE_FRENCH_MAURITIUS = _Language.LANGUAGE_FRENCH_MAURITIUS
LANGUAGE_FRENCH_MAYOTTE = _Language.LANGUAGE_FRENCH_MAYOTTE
LANGUAGE_FRENCH_MONACO = _Language.LANGUAGE_FRENCH_MONACO
LANGUAGE_FRENCH_MOROCCO = _Language.LANGUAGE_FRENCH_MOROCCO
LANGUAGE_FRENCH_NEW_CALEDONIA = _Language.LANGUAGE_FRENCH_NEW_CALEDONIA
LANGUAGE_FRENCH_NIGER = _Language.LANGUAGE_FRENCH_NIGER
LANGUAGE_FRENCH_REUNION = _Language.LANGUAGE_FRENCH_REUNION
LANGUAGE_FRENCH_RWANDA = _Language.LANGUAGE_FRENCH_RWANDA
LANGUAGE_FRENCH_SENEGAL = _Language.LANGUAGE_FRENCH_SENEGAL
LANGUAGE_FRENCH_SEYCHELLES = _Language.LANGUAGE_FRENCH_SEYCHELLES
LANGUAGE_FRENCH_ST_BARTHELEMY = _Language.LANGUAGE_FRENCH_ST_BARTHELEMY
LANGUAGE_FRENCH_ST_MARTIN = _Language.LANGUAGE_FRENCH_ST_MARTIN
LANGUAGE_FRENCH_ST_PIERRE_AND_MIQUELON = _Language.LANGUAGE_FRENCH_ST_PIERRE_AND_MIQUELON
LANGUAGE_FRENCH_SWISS = _Language.LANGUAGE_FRENCH_SWISS
LANGUAGE_FRENCH_SYRIA = _Language.LANGUAGE_FRENCH_SYRIA
LANGUAGE_FRENCH_TOGO = _Language.LANGUAGE_FRENCH_TOGO
LANGUAGE_FRENCH_TUNISIA = _Language.LANGUAGE_FRENCH_TUNISIA
LANGUAGE_FRENCH_VANUATU = _Language.LANGUAGE_FRENCH_VANUATU
LANGUAGE_FRENCH_WALLIS_AND_FUTUNA = _Language.LANGUAGE_FRENCH_WALLIS_AND_FUTUNA
LANGUAGE_FRISIAN = _Language.LANGUAGE_FRISIAN
LANGUAGE_FRISIAN_NETHERLANDS = _Language.LANGUAGE_FRISIAN_NETHERLANDS
LANGUAGE_FRIULIAN = _Language.LANGUAGE_FRIULIAN
LANGUAGE_FRIULIAN_ITALY = _Language.LANGUAGE_FRIULIAN_ITALY
LANGUAGE_FULAH = _Language.LANGUAGE_FULAH
LANGUAGE_FULAH_LATIN = _Language.LANGUAGE_FULAH_LATIN
LANGUAGE_FULAH_LATIN_BURKINA_FASO = _Language.LANGUAGE_FULAH_LATIN_BURKINA_FASO
LANGUAGE_FULAH_LATIN_CAMEROON = _Language.LANGUAGE_FULAH_LATIN_CAMEROON
LANGUAGE_FULAH_LATIN_GAMBIA = _Language.LANGUAGE_FULAH_LATIN_GAMBIA
LANGUAGE_FULAH_LATIN_GHANA = _Language.LANGUAGE_FULAH_LATIN_GHANA
LANGUAGE_FULAH_LATIN_GUINEA = _Language.LANGUAGE_FULAH_LATIN_GUINEA
LANGUAGE_FULAH_LATIN_GUINEA_BISSAU = _Language.LANGUAGE_FULAH_LATIN_GUINEA_BISSAU
LANGUAGE_FULAH_LATIN_LIBERIA = _Language.LANGUAGE_FULAH_LATIN_LIBERIA
LANGUAGE_FULAH_LATIN_MAURITANIA = _Language.LANGUAGE_FULAH_LATIN_MAURITANIA
LANGUAGE_FULAH_LATIN_NIGER = _Language.LANGUAGE_FULAH_LATIN_NIGER
LANGUAGE_FULAH_LATIN_NIGERIA = _Language.LANGUAGE_FULAH_LATIN_NIGERIA
LANGUAGE_FULAH_LATIN_SENEGAL = _Language.LANGUAGE_FULAH_LATIN_SENEGAL
LANGUAGE_FULAH_LATIN_SIERRA_LEONE = _Language.LANGUAGE_FULAH_LATIN_SIERRA_LEONE
LANGUAGE_GALICIAN = _Language.LANGUAGE_GALICIAN
LANGUAGE_GALICIAN_SPAIN = _Language.LANGUAGE_GALICIAN_SPAIN
LANGUAGE_GANDA = _Language.LANGUAGE_GANDA
LANGUAGE_GANDA_UGANDA = _Language.LANGUAGE_GANDA_UGANDA
LANGUAGE_GEORGIAN = _Language.LANGUAGE_GEORGIAN
LANGUAGE_GEORGIAN_GEORGIA = _Language.LANGUAGE_GEORGIAN_GEORGIA
LANGUAGE_GERMAN = _Language.LANGUAGE_GERMAN
LANGUAGE_GERMAN_AUSTRIAN = _Language.LANGUAGE_GERMAN_AUSTRIAN
LANGUAGE_GERMAN_BELGIUM = _Language.LANGUAGE_GERMAN_BELGIUM
LANGUAGE_GERMAN_GERMANY = _Language.LANGUAGE_GERMAN_GERMANY
LANGUAGE_GERMAN_ITALY = _Language.LANGUAGE_GERMAN_ITALY
LANGUAGE_GERMAN_LIECHTENSTEIN = _Language.LANGUAGE_GERMAN_LIECHTENSTEIN
LANGUAGE_GERMAN_LUXEMBOURG = _Language.LANGUAGE_GERMAN_LUXEMBOURG
LANGUAGE_GERMAN_SWISS = _Language.LANGUAGE_GERMAN_SWISS
LANGUAGE_GREEK = _Language.LANGUAGE_GREEK
LANGUAGE_GREEK_CYPRUS = _Language.LANGUAGE_GREEK_CYPRUS
LANGUAGE_GREEK_GREECE = _Language.LANGUAGE_GREEK_GREECE
LANGUAGE_GREENLANDIC = _Language.LANGUAGE_GREENLANDIC
LANGUAGE_GUARANI = _Language.LANGUAGE_GUARANI
LANGUAGE_GUARANI_PARAGUAY = _Language.LANGUAGE_GUARANI_PARAGUAY
LANGUAGE_GUJARATI = _Language.LANGUAGE_GUJARATI
LANGUAGE_GUJARATI_INDIA = _Language.LANGUAGE_GUJARATI_INDIA
LANGUAGE_GUSII = _Language.LANGUAGE_GUSII
LANGUAGE_GUSII_KENYA = _Language.LANGUAGE_GUSII_KENYA
LANGUAGE_HAUSA = _Language.LANGUAGE_HAUSA
LANGUAGE_HAUSA_LATIN = _Language.LANGUAGE_HAUSA_LATIN
LANGUAGE_HAUSA_LATIN_GHANA = _Language.LANGUAGE_HAUSA_LATIN_GHANA
LANGUAGE_HAUSA_LATIN_NIGER = _Language.LANGUAGE_HAUSA_LATIN_NIGER
LANGUAGE_HAUSA_LATIN_NIGERIA = _Language.LANGUAGE_HAUSA_LATIN_NIGERIA
LANGUAGE_HAWAIIAN = _Language.LANGUAGE_HAWAIIAN
LANGUAGE_HAWAIIAN_US = _Language.LANGUAGE_HAWAIIAN_US
LANGUAGE_HEBREW = _Language.LANGUAGE_HEBREW
LANGUAGE_HEBREW_ISRAEL = _Language.LANGUAGE_HEBREW_ISRAEL
LANGUAGE_HINDI = _Language.LANGUAGE_HINDI
LANGUAGE_HINDI_INDIA = _Language.LANGUAGE_HINDI_INDIA
LANGUAGE_HUNGARIAN = _Language.LANGUAGE_HUNGARIAN
LANGUAGE_HUNGARIAN_HUNGARY = _Language.LANGUAGE_HUNGARIAN_HUNGARY
LANGUAGE_IBIBIO = _Language.LANGUAGE_IBIBIO
LANGUAGE_IBIBIO_NIGERIA = _Language.LANGUAGE_IBIBIO_NIGERIA
LANGUAGE_ICELANDIC = _Language.LANGUAGE_ICELANDIC
LANGUAGE_ICELANDIC_ICELAND = _Language.LANGUAGE_ICELANDIC_ICELAND
LANGUAGE_IGBO = _Language.LANGUAGE_IGBO
LANGUAGE_IGBO_NIGERIA = _Language.LANGUAGE_IGBO_NIGERIA
LANGUAGE_INDONESIAN = _Language.LANGUAGE_INDONESIAN
LANGUAGE_INDONESIAN_INDONESIA = _Language.LANGUAGE_INDONESIAN_INDONESIA
LANGUAGE_INTERLINGUA = _Language.LANGUAGE_INTERLINGUA
LANGUAGE_INTERLINGUA_WORLD = _Language.LANGUAGE_INTERLINGUA_WORLD
LANGUAGE_INTERLINGUE = _Language.LANGUAGE_INTERLINGUE
LANGUAGE_INUKTITUT = _Language.LANGUAGE_INUKTITUT
LANGUAGE_INUKTITUT_LATIN = _Language.LANGUAGE_INUKTITUT_LATIN
LANGUAGE_INUKTITUT_LATIN_CANADA = _Language.LANGUAGE_INUKTITUT_LATIN_CANADA
LANGUAGE_INUKTITUT_SYLLABICS = _Language.LANGUAGE_INUKTITUT_SYLLABICS
LANGUAGE_INUKTITUT_SYLLABICS_CANADA = _Language.LANGUAGE_INUKTITUT_SYLLABICS_CANADA
LANGUAGE_INUPIAK = _Language.LANGUAGE_INUPIAK
LANGUAGE_IRISH = _Language.LANGUAGE_IRISH
LANGUAGE_IRISH_IRELAND = _Language.LANGUAGE_IRISH_IRELAND
LANGUAGE_ITALIAN = _Language.LANGUAGE_ITALIAN
LANGUAGE_ITALIAN_ITALY = _Language.LANGUAGE_ITALIAN_ITALY
LANGUAGE_ITALIAN_SAN_MARINO = _Language.LANGUAGE_ITALIAN_SAN_MARINO
LANGUAGE_ITALIAN_SWISS = _Language.LANGUAGE_ITALIAN_SWISS
LANGUAGE_ITALIAN_VATICAN_CITY = _Language.LANGUAGE_ITALIAN_VATICAN_CITY
LANGUAGE_JAPANESE = _Language.LANGUAGE_JAPANESE
LANGUAGE_JAPANESE_JAPAN = _Language.LANGUAGE_JAPANESE_JAPAN
LANGUAGE_JAVANESE = _Language.LANGUAGE_JAVANESE
LANGUAGE_JAVANESE_INDONESIA = _Language.LANGUAGE_JAVANESE_INDONESIA
LANGUAGE_JAVANESE_JAVANESE = _Language.LANGUAGE_JAVANESE_JAVANESE
LANGUAGE_JAVANESE_JAVANESE_INDONESIA = _Language.LANGUAGE_JAVANESE_JAVANESE_INDONESIA
LANGUAGE_JOLA_FONYI = _Language.LANGUAGE_JOLA_FONYI
LANGUAGE_JOLA_FONYI_SENEGAL = _Language.LANGUAGE_JOLA_FONYI_SENEGAL
LANGUAGE_KABUVERDIANU = _Language.LANGUAGE_KABUVERDIANU
LANGUAGE_KABUVERDIANU_CABO_VERDE = _Language.LANGUAGE_KABUVERDIANU_CABO_VERDE
LANGUAGE_KABYLE = _Language.LANGUAGE_KABYLE
LANGUAGE_KABYLE_ALGERIA = _Language.LANGUAGE_KABYLE_ALGERIA
LANGUAGE_KAKO = _Language.LANGUAGE_KAKO
LANGUAGE_KAKO_CAMEROON = _Language.LANGUAGE_KAKO_CAMEROON
LANGUAGE_KALAALLISUT = _Language.LANGUAGE_KALAALLISUT
LANGUAGE_KALENJIN = _Language.LANGUAGE_KALENJIN
LANGUAGE_KALENJIN_KENYA = _Language.LANGUAGE_KALENJIN_KENYA
LANGUAGE_KAMBA = _Language.LANGUAGE_KAMBA
LANGUAGE_KAMBA_KENYA = _Language.LANGUAGE_KAMBA_KENYA
LANGUAGE_KANNADA = _Language.LANGUAGE_KANNADA
LANGUAGE_KANNADA_INDIA = _Language.LANGUAGE_KANNADA_INDIA
LANGUAGE_KANURI = _Language.LANGUAGE_KANURI
LANGUAGE_KANURI_LATIN = _Language.LANGUAGE_KANURI_LATIN
LANGUAGE_KANURI_NIGERIA = _Language.LANGUAGE_KANURI_NIGERIA
LANGUAGE_KASHMIRI = _Language.LANGUAGE_KASHMIRI
LANGUAGE_KASHMIRI_DEVANAGARI = _Language.LANGUAGE_KASHMIRI_DEVANAGARI
LANGUAGE_KASHMIRI_DEVANAGARI_INDIA = _Language.LANGUAGE_KASHMIRI_DEVANAGARI_INDIA
LANGUAGE_KASHMIRI_INDIA = _Language.LANGUAGE_KASHMIRI_INDIA
LANGUAGE_KASHMIRI_PERSO_ARABIC = _Language.LANGUAGE_KASHMIRI_PERSO_ARABIC
LANGUAGE_KASHMIRI_PERSO_ARABIC_INDIA = _Language.LANGUAGE_KASHMIRI_PERSO_ARABIC_INDIA
LANGUAGE_KAZAKH = _Language.LANGUAGE_KAZAKH
LANGUAGE_KAZAKH_KAZAKHSTAN = _Language.LANGUAGE_KAZAKH_KAZAKHSTAN
LANGUAGE_KHMER = _Language.LANGUAGE_KHMER
LANGUAGE_KHMER_CAMBODIA = _Language.LANGUAGE_KHMER_CAMBODIA
LANGUAGE_KICHE = _Language.LANGUAGE_KICHE
LANGUAGE_KICHE_GUATEMALA = _Language.LANGUAGE_KICHE_GUATEMALA
LANGUAGE_KICHE_LATIN = _Language.LANGUAGE_KICHE_LATIN
LANGUAGE_KIKUYU = _Language.LANGUAGE_KIKUYU
LANGUAGE_KIKUYU_KENYA = _Language.LANGUAGE_KIKUYU_KENYA
LANGUAGE_KINYARWANDA = _Language.LANGUAGE_KINYARWANDA
LANGUAGE_KINYARWANDA_RWANDA = _Language.LANGUAGE_KINYARWANDA_RWANDA
LANGUAGE_KIRGHIZ = _Language.LANGUAGE_KIRGHIZ
LANGUAGE_KIRGHIZ_KYRGYZSTAN = _Language.LANGUAGE_KIRGHIZ_KYRGYZSTAN
LANGUAGE_KIRUNDI = _Language.LANGUAGE_KIRUNDI
LANGUAGE_KIRUNDI_BURUNDI = _Language.LANGUAGE_KIRUNDI_BURUNDI
LANGUAGE_KONKANI = _Language.LANGUAGE_KONKANI
LANGUAGE_KONKANI_INDIA = _Language.LANGUAGE_KONKANI_INDIA
LANGUAGE_KOREAN = _Language.LANGUAGE_KOREAN
LANGUAGE_KOREAN_KOREA = _Language.LANGUAGE_KOREAN_KOREA
LANGUAGE_KOREAN_NORTH_KOREA = _Language.LANGUAGE_KOREAN_NORTH_KOREA
LANGUAGE_KOYRABORO_SENNI = _Language.LANGUAGE_KOYRABORO_SENNI
LANGUAGE_KOYRABORO_SENNI_MALI = _Language.LANGUAGE_KOYRABORO_SENNI_MALI
LANGUAGE_KOYRA_CHIINI = _Language.LANGUAGE_KOYRA_CHIINI
LANGUAGE_KOYRA_CHIINI_MALI = _Language.LANGUAGE_KOYRA_CHIINI_MALI
LANGUAGE_KURDISH = _Language.LANGUAGE_KURDISH
LANGUAGE_KURDISH_PERSO_ARABIC_IRAN = _Language.LANGUAGE_KURDISH_PERSO_ARABIC_IRAN
LANGUAGE_KWASIO = _Language.LANGUAGE_KWASIO
LANGUAGE_KWASIO_CAMEROON = _Language.LANGUAGE_KWASIO_CAMEROON
LANGUAGE_LAKOTA = _Language.LANGUAGE_LAKOTA
LANGUAGE_LAKOTA_US = _Language.LANGUAGE_LAKOTA_US
LANGUAGE_LANGI = _Language.LANGUAGE_LANGI
LANGUAGE_LANGI_TANZANIA = _Language.LANGUAGE_LANGI_TANZANIA
LANGUAGE_LAOTHIAN = _Language.LANGUAGE_LAOTHIAN
LANGUAGE_LAOTHIAN_LAOS = _Language.LANGUAGE_LAOTHIAN_LAOS
LANGUAGE_LATIN = _Language.LANGUAGE_LATIN
LANGUAGE_LATIN_WORLD = _Language.LANGUAGE_LATIN_WORLD
LANGUAGE_LATVIAN = _Language.LANGUAGE_LATVIAN
LANGUAGE_LATVIAN_LATVIA = _Language.LANGUAGE_LATVIAN_LATVIA
LANGUAGE_LINGALA = _Language.LANGUAGE_LINGALA
LANGUAGE_LINGALA_ANGOLA = _Language.LANGUAGE_LINGALA_ANGOLA
LANGUAGE_LINGALA_CENTRAL_AFRICAN_REPUBLIC = _Language.LANGUAGE_LINGALA_CENTRAL_AFRICAN_REPUBLIC
LANGUAGE_LINGALA_CONGO = _Language.LANGUAGE_LINGALA_CONGO
LANGUAGE_LINGALA_CONGO_DRC = _Language.LANGUAGE_LINGALA_CONGO_DRC
LANGUAGE_LITHUANIAN = _Language.LANGUAGE_LITHUANIAN
LANGUAGE_LITHUANIAN_LITHUANIA = _Language.LANGUAGE_LITHUANIAN_LITHUANIA
LANGUAGE_LOWER_SORBIAN = _Language.LANGUAGE_LOWER_SORBIAN
LANGUAGE_LOWER_SORBIAN_GERMANY = _Language.LANGUAGE_LOWER_SORBIAN_GERMANY
LANGUAGE_LOW_GERMAN = _Language.LANGUAGE_LOW_GERMAN
LANGUAGE_LOW_GERMAN_GERMANY = _Language.LANGUAGE_LOW_GERMAN_GERMANY
LANGUAGE_LOW_GERMAN_NETHERLANDS = _Language.LANGUAGE_LOW_GERMAN_NETHERLANDS
LANGUAGE_LUBA_KATANGA = _Language.LANGUAGE_LUBA_KATANGA
LANGUAGE_LUBA_KATANGA_CONGO_DRC = _Language.LANGUAGE_LUBA_KATANGA_CONGO_DRC
LANGUAGE_LUO = _Language.LANGUAGE_LUO
LANGUAGE_LUO_KENYA = _Language.LANGUAGE_LUO_KENYA
LANGUAGE_LUXEMBOURGISH = _Language.LANGUAGE_LUXEMBOURGISH
LANGUAGE_LUXEMBOURGISH_LUXEMBOURG = _Language.LANGUAGE_LUXEMBOURGISH_LUXEMBOURG
LANGUAGE_LUYIA = _Language.LANGUAGE_LUYIA
LANGUAGE_LUYIA_KENYA = _Language.LANGUAGE_LUYIA_KENYA
LANGUAGE_MACEDONIAN = _Language.LANGUAGE_MACEDONIAN
LANGUAGE_MACEDONIAN_NORTH_MACEDONIA = _Language.LANGUAGE_MACEDONIAN_NORTH_MACEDONIA
LANGUAGE_MACHAME = _Language.LANGUAGE_MACHAME
LANGUAGE_MACHAME_TANZANIA = _Language.LANGUAGE_MACHAME_TANZANIA
LANGUAGE_MAKHUWA_MEETTO = _Language.LANGUAGE_MAKHUWA_MEETTO
LANGUAGE_MAKHUWA_MEETTO_MOZAMBIQUE = _Language.LANGUAGE_MAKHUWA_MEETTO_MOZAMBIQUE
LANGUAGE_MAKONDE = _Language.LANGUAGE_MAKONDE
LANGUAGE_MAKONDE_TANZANIA = _Language.LANGUAGE_MAKONDE_TANZANIA
LANGUAGE_MALAGASY = _Language.LANGUAGE_MALAGASY
LANGUAGE_MALAGASY_MADAGASCAR = _Language.LANGUAGE_MALAGASY_MADAGASCAR
LANGUAGE_MALAY = _Language.LANGUAGE_MALAY
LANGUAGE_MALAYALAM = _Language.LANGUAGE_MALAYALAM
LANGUAGE_MALAYALAM_INDIA = _Language.LANGUAGE_MALAYALAM_INDIA
LANGUAGE_MALAY_BRUNEI = _Language.LANGUAGE_MALAY_BRUNEI
LANGUAGE_MALAY_MALAYSIA = _Language.LANGUAGE_MALAY_MALAYSIA
LANGUAGE_MALAY_SINGAPORE = _Language.LANGUAGE_MALAY_SINGAPORE
LANGUAGE_MALTESE = _Language.LANGUAGE_MALTESE
LANGUAGE_MALTESE_MALTA = _Language.LANGUAGE_MALTESE_MALTA
LANGUAGE_MANIPURI = _Language.LANGUAGE_MANIPURI
LANGUAGE_MANIPURI_INDIA = _Language.LANGUAGE_MANIPURI_INDIA
LANGUAGE_MANX = _Language.LANGUAGE_MANX
LANGUAGE_MANX_ISLE_OF_MAN = _Language.LANGUAGE_MANX_ISLE_OF_MAN
LANGUAGE_MAORI = _Language.LANGUAGE_MAORI
LANGUAGE_MAORI_NEW_ZEALAND = _Language.LANGUAGE_MAORI_NEW_ZEALAND
LANGUAGE_MAPUCHE = _Language.LANGUAGE_MAPUCHE
LANGUAGE_MAPUCHE_CHILE = _Language.LANGUAGE_MAPUCHE_CHILE
LANGUAGE_MARATHI = _Language.LANGUAGE_MARATHI
LANGUAGE_MARATHI_INDIA = _Language.LANGUAGE_MARATHI_INDIA
LANGUAGE_MASAI = _Language.LANGUAGE_MASAI
LANGUAGE_MASAI_KENYA = _Language.LANGUAGE_MASAI_KENYA
LANGUAGE_MASAI_TANZANIA = _Language.LANGUAGE_MASAI_TANZANIA
LANGUAGE_MAZANDERANI = _Language.LANGUAGE_MAZANDERANI
LANGUAGE_MAZANDERANI_IRAN = _Language.LANGUAGE_MAZANDERANI_IRAN
LANGUAGE_MERU = _Language.LANGUAGE_MERU
LANGUAGE_MERU_KENYA = _Language.LANGUAGE_MERU_KENYA
LANGUAGE_META = _Language.LANGUAGE_META
LANGUAGE_META_CAMEROON = _Language.LANGUAGE_META_CAMEROON
LANGUAGE_MOHAWK = _Language.LANGUAGE_MOHAWK
LANGUAGE_MOHAWK_CANADA = _Language.LANGUAGE_MOHAWK_CANADA
LANGUAGE_MOLDAVIAN = _Language.LANGUAGE_MOLDAVIAN
LANGUAGE_MONGOLIAN = _Language.LANGUAGE_MONGOLIAN
LANGUAGE_MONGOLIAN_CYRILLIC = _Language.LANGUAGE_MONGOLIAN_CYRILLIC
LANGUAGE_MONGOLIAN_MONGOLIA = _Language.LANGUAGE_MONGOLIAN_MONGOLIA
LANGUAGE_MONGOLIAN_TRADITIONAL = _Language.LANGUAGE_MONGOLIAN_TRADITIONAL
LANGUAGE_MONGOLIAN_TRADITIONAL_CHINA = _Language.LANGUAGE_MONGOLIAN_TRADITIONAL_CHINA
LANGUAGE_MONGOLIAN_TRADITIONAL_MONGOLIA = _Language.LANGUAGE_MONGOLIAN_TRADITIONAL_MONGOLIA
LANGUAGE_MORISYEN = _Language.LANGUAGE_MORISYEN
LANGUAGE_MORISYEN_MAURITIUS = _Language.LANGUAGE_MORISYEN_MAURITIUS
LANGUAGE_MUNDANG = _Language.LANGUAGE_MUNDANG
LANGUAGE_MUNDANG_CAMEROON = _Language.LANGUAGE_MUNDANG_CAMEROON
LANGUAGE_NAMA = _Language.LANGUAGE_NAMA
LANGUAGE_NAMA_NAMIBIA = _Language.LANGUAGE_NAMA_NAMIBIA
LANGUAGE_NAURU = _Language.LANGUAGE_NAURU
LANGUAGE_NEPALI = _Language.LANGUAGE_NEPALI
LANGUAGE_NEPALI_INDIA = _Language.LANGUAGE_NEPALI_INDIA
LANGUAGE_NEPALI_NEPAL = _Language.LANGUAGE_NEPALI_NEPAL
LANGUAGE_NGIEMBOON = _Language.LANGUAGE_NGIEMBOON
LANGUAGE_NGIEMBOON_CAMEROON = _Language.LANGUAGE_NGIEMBOON_CAMEROON
LANGUAGE_NGOMBA = _Language.LANGUAGE_NGOMBA
LANGUAGE_NGOMBA_CAMEROON = _Language.LANGUAGE_NGOMBA_CAMEROON
LANGUAGE_NKO = _Language.LANGUAGE_NKO
LANGUAGE_NKO_GUINEA = _Language.LANGUAGE_NKO_GUINEA
LANGUAGE_NORTHERN_LURI = _Language.LANGUAGE_NORTHERN_LURI
LANGUAGE_NORTHERN_LURI_IRAN = _Language.LANGUAGE_NORTHERN_LURI_IRAN
LANGUAGE_NORTHERN_LURI_IRAQ = _Language.LANGUAGE_NORTHERN_LURI_IRAQ
LANGUAGE_NORTH_NDEBELE = _Language.LANGUAGE_NORTH_NDEBELE
LANGUAGE_NORTH_NDEBELE_ZIMBABWE = _Language.LANGUAGE_NORTH_NDEBELE_ZIMBABWE
LANGUAGE_NORWEGIAN = _Language.LANGUAGE_NORWEGIAN
LANGUAGE_NORWEGIAN_BOKMAL = _Language.LANGUAGE_NORWEGIAN_BOKMAL
LANGUAGE_NORWEGIAN_BOKMAL_NORWAY = _Language.LANGUAGE_NORWEGIAN_BOKMAL_NORWAY
LANGUAGE_NORWEGIAN_BOKMAL_SVALBARD_AND_JAN_MAYEN = _Language.LANGUAGE_NORWEGIAN_BOKMAL_SVALBARD_AND_JAN_MAYEN
LANGUAGE_NORWEGIAN_NYNORSK = _Language.LANGUAGE_NORWEGIAN_NYNORSK
LANGUAGE_NORWEGIAN_NYNORSK_NORWAY = _Language.LANGUAGE_NORWEGIAN_NYNORSK_NORWAY
LANGUAGE_NUER = _Language.LANGUAGE_NUER
LANGUAGE_NUER_SOUTH_SUDAN = _Language.LANGUAGE_NUER_SOUTH_SUDAN
LANGUAGE_NYANKOLE = _Language.LANGUAGE_NYANKOLE
LANGUAGE_NYANKOLE_UGANDA = _Language.LANGUAGE_NYANKOLE_UGANDA
LANGUAGE_OCCITAN = _Language.LANGUAGE_OCCITAN
LANGUAGE_OCCITAN_FRANCE = _Language.LANGUAGE_OCCITAN_FRANCE
LANGUAGE_ODIA = _Language.LANGUAGE_ODIA
LANGUAGE_ODIA_INDIA = _Language.LANGUAGE_ODIA_INDIA
LANGUAGE_OROMO = _Language.LANGUAGE_OROMO
LANGUAGE_OROMO_ETHIOPIA = _Language.LANGUAGE_OROMO_ETHIOPIA
LANGUAGE_OROMO_KENYA = _Language.LANGUAGE_OROMO_KENYA
LANGUAGE_OSSETIC = _Language.LANGUAGE_OSSETIC
LANGUAGE_OSSETIC_GEORGIA = _Language.LANGUAGE_OSSETIC_GEORGIA
LANGUAGE_OSSETIC_RUSSIA = _Language.LANGUAGE_OSSETIC_RUSSIA
LANGUAGE_PAPIAMENTO = _Language.LANGUAGE_PAPIAMENTO
LANGUAGE_PAPIAMENTO_CARIBBEAN = _Language.LANGUAGE_PAPIAMENTO_CARIBBEAN
LANGUAGE_PASHTO = _Language.LANGUAGE_PASHTO
LANGUAGE_PASHTO_AFGHANISTAN = _Language.LANGUAGE_PASHTO_AFGHANISTAN
LANGUAGE_PASHTO_PAKISTAN = _Language.LANGUAGE_PASHTO_PAKISTAN
LANGUAGE_PERSIAN_IRAN = _Language.LANGUAGE_PERSIAN_IRAN
LANGUAGE_POLISH = _Language.LANGUAGE_POLISH
LANGUAGE_POLISH_POLAND = _Language.LANGUAGE_POLISH_POLAND
LANGUAGE_PORTUGUESE = _Language.LANGUAGE_PORTUGUESE
LANGUAGE_PORTUGUESE_ANGOLA = _Language.LANGUAGE_PORTUGUESE_ANGOLA
LANGUAGE_PORTUGUESE_BRAZILIAN = _Language.LANGUAGE_PORTUGUESE_BRAZILIAN
LANGUAGE_PORTUGUESE_CABO_VERDE = _Language.LANGUAGE_PORTUGUESE_CABO_VERDE
LANGUAGE_PORTUGUESE_EQUATORIAL_GUINEA = _Language.LANGUAGE_PORTUGUESE_EQUATORIAL_GUINEA
LANGUAGE_PORTUGUESE_GUINEA_BISSAU = _Language.LANGUAGE_PORTUGUESE_GUINEA_BISSAU
LANGUAGE_PORTUGUESE_LUXEMBOURG = _Language.LANGUAGE_PORTUGUESE_LUXEMBOURG
LANGUAGE_PORTUGUESE_MACAO_SAR = _Language.LANGUAGE_PORTUGUESE_MACAO_SAR
LANGUAGE_PORTUGUESE_MOZAMBIQUE = _Language.LANGUAGE_PORTUGUESE_MOZAMBIQUE
LANGUAGE_PORTUGUESE_PORTUGAL = _Language.LANGUAGE_PORTUGUESE_PORTUGAL
LANGUAGE_PORTUGUESE_SAO_TOME_AND_PRINCIPE = _Language.LANGUAGE_PORTUGUESE_SAO_TOME_AND_PRINCIPE
LANGUAGE_PORTUGUESE_SWITZERLAND = _Language.LANGUAGE_PORTUGUESE_SWITZERLAND
LANGUAGE_PORTUGUESE_TIMOR_LESTE = _Language.LANGUAGE_PORTUGUESE_TIMOR_LESTE
LANGUAGE_PRUSSIAN = _Language.LANGUAGE_PRUSSIAN
LANGUAGE_PRUSSIAN_WORLD = _Language.LANGUAGE_PRUSSIAN_WORLD
LANGUAGE_PUNJABI = _Language.LANGUAGE_PUNJABI
LANGUAGE_PUNJABI_ARABIC = _Language.LANGUAGE_PUNJABI_ARABIC
LANGUAGE_PUNJABI_GURMUKHI = _Language.LANGUAGE_PUNJABI_GURMUKHI
LANGUAGE_PUNJABI_INDIA = _Language.LANGUAGE_PUNJABI_INDIA
LANGUAGE_PUNJABI_PAKISTAN = _Language.LANGUAGE_PUNJABI_PAKISTAN
LANGUAGE_QUECHUA = _Language.LANGUAGE_QUECHUA
LANGUAGE_QUECHUA_BOLIVIA = _Language.LANGUAGE_QUECHUA_BOLIVIA
LANGUAGE_QUECHUA_ECUADOR = _Language.LANGUAGE_QUECHUA_ECUADOR
LANGUAGE_QUECHUA_MACRO = _Language.LANGUAGE_QUECHUA_MACRO
LANGUAGE_QUECHUA_PERU = _Language.LANGUAGE_QUECHUA_PERU
LANGUAGE_RHAETO_ROMANCE = _Language.LANGUAGE_RHAETO_ROMANCE
LANGUAGE_RHAETO_ROMANCE_SWITZERLAND = _Language.LANGUAGE_RHAETO_ROMANCE_SWITZERLAND
LANGUAGE_ROMANIAN = _Language.LANGUAGE_ROMANIAN
LANGUAGE_ROMANIAN_MOLDOVA = _Language.LANGUAGE_ROMANIAN_MOLDOVA
LANGUAGE_ROMANIAN_ROMANIA = _Language.LANGUAGE_ROMANIAN_ROMANIA
LANGUAGE_ROMBO = _Language.LANGUAGE_ROMBO
LANGUAGE_ROMBO_TANZANIA = _Language.LANGUAGE_ROMBO_TANZANIA
LANGUAGE_RUSSIAN = _Language.LANGUAGE_RUSSIAN
LANGUAGE_RUSSIAN_BELARUS = _Language.LANGUAGE_RUSSIAN_BELARUS
LANGUAGE_RUSSIAN_KAZAKHSTAN = _Language.LANGUAGE_RUSSIAN_KAZAKHSTAN
LANGUAGE_RUSSIAN_KYRGYZSTAN = _Language.LANGUAGE_RUSSIAN_KYRGYZSTAN
LANGUAGE_RUSSIAN_MOLDOVA = _Language.LANGUAGE_RUSSIAN_MOLDOVA
LANGUAGE_RUSSIAN_RUSSIA = _Language.LANGUAGE_RUSSIAN_RUSSIA
LANGUAGE_RUSSIAN_UKRAINE = _Language.LANGUAGE_RUSSIAN_UKRAINE
LANGUAGE_RWA = _Language.LANGUAGE_RWA
LANGUAGE_RWA_TANZANIA = _Language.LANGUAGE_RWA_TANZANIA
LANGUAGE_SAHO = _Language.LANGUAGE_SAHO
LANGUAGE_SAHO_ERITREA = _Language.LANGUAGE_SAHO_ERITREA
LANGUAGE_SAKHA = _Language.LANGUAGE_SAKHA
LANGUAGE_SAKHA_RUSSIA = _Language.LANGUAGE_SAKHA_RUSSIA
LANGUAGE_SAMBURU = _Language.LANGUAGE_SAMBURU
LANGUAGE_SAMBURU_KENYA = _Language.LANGUAGE_SAMBURU_KENYA
LANGUAGE_SAMI = _Language.LANGUAGE_SAMI
LANGUAGE_SAMI_FINLAND = _Language.LANGUAGE_SAMI_FINLAND
LANGUAGE_SAMI_INARI = _Language.LANGUAGE_SAMI_INARI
LANGUAGE_SAMI_INARI_FINLAND = _Language.LANGUAGE_SAMI_INARI_FINLAND
LANGUAGE_SAMI_LULE = _Language.LANGUAGE_SAMI_LULE
LANGUAGE_SAMI_LULE_NORWAY = _Language.LANGUAGE_SAMI_LULE_NORWAY
LANGUAGE_SAMI_LULE_SWEDEN = _Language.LANGUAGE_SAMI_LULE_SWEDEN
LANGUAGE_SAMI_NORWAY = _Language.LANGUAGE_SAMI_NORWAY
LANGUAGE_SAMI_SKOLT = _Language.LANGUAGE_SAMI_SKOLT
LANGUAGE_SAMI_SKOLT_FINLAND = _Language.LANGUAGE_SAMI_SKOLT_FINLAND
LANGUAGE_SAMI_SOUTHERN = _Language.LANGUAGE_SAMI_SOUTHERN
LANGUAGE_SAMI_SOUTHERN_NORWAY = _Language.LANGUAGE_SAMI_SOUTHERN_NORWAY
LANGUAGE_SAMI_SOUTHERN_SWEDEN = _Language.LANGUAGE_SAMI_SOUTHERN_SWEDEN
LANGUAGE_SAMI_SWEDEN = _Language.LANGUAGE_SAMI_SWEDEN
LANGUAGE_SAMOAN = _Language.LANGUAGE_SAMOAN
LANGUAGE_SANGHO = _Language.LANGUAGE_SANGHO
LANGUAGE_SANGHO_CENTRAL_AFRICAN_REPUBLIC = _Language.LANGUAGE_SANGHO_CENTRAL_AFRICAN_REPUBLIC
LANGUAGE_SANGU = _Language.LANGUAGE_SANGU
LANGUAGE_SANGU_TANZANIA = _Language.LANGUAGE_SANGU_TANZANIA
LANGUAGE_SANSKRIT = _Language.LANGUAGE_SANSKRIT
LANGUAGE_SANSKRIT_INDIA = _Language.LANGUAGE_SANSKRIT_INDIA
LANGUAGE_SCOTS_GAELIC = _Language.LANGUAGE_SCOTS_GAELIC
LANGUAGE_SCOTS_GAELIC_UK = _Language.LANGUAGE_SCOTS_GAELIC_UK
LANGUAGE_SENA = _Language.LANGUAGE_SENA
LANGUAGE_SENA_MOZAMBIQUE = _Language.LANGUAGE_SENA_MOZAMBIQUE
LANGUAGE_SERBIAN = _Language.LANGUAGE_SERBIAN
LANGUAGE_SERBIAN_CYRILLIC = _Language.LANGUAGE_SERBIAN_CYRILLIC
LANGUAGE_SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA = _Language.LANGUAGE_SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA
LANGUAGE_SERBIAN_CYRILLIC_KOSOVO = _Language.LANGUAGE_SERBIAN_CYRILLIC_KOSOVO
LANGUAGE_SERBIAN_CYRILLIC_MONTENEGRO = _Language.LANGUAGE_SERBIAN_CYRILLIC_MONTENEGRO
LANGUAGE_SERBIAN_CYRILLIC_SERBIA = _Language.LANGUAGE_SERBIAN_CYRILLIC_SERBIA
LANGUAGE_SERBIAN_CYRILLIC_YU = _Language.LANGUAGE_SERBIAN_CYRILLIC_YU
LANGUAGE_SERBIAN_LATIN = _Language.LANGUAGE_SERBIAN_LATIN
LANGUAGE_SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA = _Language.LANGUAGE_SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA
LANGUAGE_SERBIAN_LATIN_KOSOVO = _Language.LANGUAGE_SERBIAN_LATIN_KOSOVO
LANGUAGE_SERBIAN_LATIN_MONTENEGRO = _Language.LANGUAGE_SERBIAN_LATIN_MONTENEGRO
LANGUAGE_SERBIAN_LATIN_SERBIA = _Language.LANGUAGE_SERBIAN_LATIN_SERBIA
LANGUAGE_SERBIAN_LATIN_YU = _Language.LANGUAGE_SERBIAN_LATIN_YU
LANGUAGE_SERBIAN_SERBIA = _Language.LANGUAGE_SERBIAN_SERBIA
LANGUAGE_SERBIAN_YU = _Language.LANGUAGE_SERBIAN_YU
LANGUAGE_SERBO_CROATIAN = _Language.LANGUAGE_SERBO_CROATIAN
LANGUAGE_SESOTHO = _Language.LANGUAGE_SESOTHO
LANGUAGE_SESOTHO_LESOTHO = _Language.LANGUAGE_SESOTHO_LESOTHO
LANGUAGE_SESOTHO_SA_LEBOA = _Language.LANGUAGE_SESOTHO_SA_LEBOA
LANGUAGE_SESOTHO_SA_LEBOA_SOUTH_AFRICA = _Language.LANGUAGE_SESOTHO_SA_LEBOA_SOUTH_AFRICA
LANGUAGE_SESOTHO_SOUTH_AFRICA = _Language.LANGUAGE_SESOTHO_SOUTH_AFRICA
LANGUAGE_SETSWANA = _Language.LANGUAGE_SETSWANA
LANGUAGE_SETSWANA_BOTSWANA = _Language.LANGUAGE_SETSWANA_BOTSWANA
LANGUAGE_SETSWANA_SOUTH_AFRICA = _Language.LANGUAGE_SETSWANA_SOUTH_AFRICA
LANGUAGE_SHAMBALA = _Language.LANGUAGE_SHAMBALA
LANGUAGE_SHAMBALA_TANZANIA = _Language.LANGUAGE_SHAMBALA_TANZANIA
LANGUAGE_SHONA = _Language.LANGUAGE_SHONA
LANGUAGE_SHONA_LATIN = _Language.LANGUAGE_SHONA_LATIN
LANGUAGE_SHONA_LATIN_ZIMBABWE = _Language.LANGUAGE_SHONA_LATIN_ZIMBABWE
LANGUAGE_SINDHI = _Language.LANGUAGE_SINDHI
LANGUAGE_SINDHI_ARABIC = _Language.LANGUAGE_SINDHI_ARABIC
LANGUAGE_SINDHI_DEVANAGARI = _Language.LANGUAGE_SINDHI_DEVANAGARI
LANGUAGE_SINDHI_DEVANAGARI_INDIA = _Language.LANGUAGE_SINDHI_DEVANAGARI_INDIA
LANGUAGE_SINDHI_PAKISTAN = _Language.LANGUAGE_SINDHI_PAKISTAN
LANGUAGE_SINHALESE = _Language.LANGUAGE_SINHALESE
LANGUAGE_SINHALESE_SRI_LANKA = _Language.LANGUAGE_SINHALESE_SRI_LANKA
LANGUAGE_SISWATI = _Language.LANGUAGE_SISWATI
LANGUAGE_SISWATI_ESWATINI = _Language.LANGUAGE_SISWATI_ESWATINI
LANGUAGE_SISWATI_SOUTH_AFRICA = _Language.LANGUAGE_SISWATI_SOUTH_AFRICA
LANGUAGE_SLOVAK = _Language.LANGUAGE_SLOVAK
LANGUAGE_SLOVAK_SLOVAKIA = _Language.LANGUAGE_SLOVAK_SLOVAKIA
LANGUAGE_SLOVENIAN = _Language.LANGUAGE_SLOVENIAN
LANGUAGE_SLOVENIAN_SLOVENIA = _Language.LANGUAGE_SLOVENIAN_SLOVENIA
LANGUAGE_SOGA = _Language.LANGUAGE_SOGA
LANGUAGE_SOGA_UGANDA = _Language.LANGUAGE_SOGA_UGANDA
LANGUAGE_SOMALI = _Language.LANGUAGE_SOMALI
LANGUAGE_SOMALI_DJIBOUTI = _Language.LANGUAGE_SOMALI_DJIBOUTI
LANGUAGE_SOMALI_ETHIOPIA = _Language.LANGUAGE_SOMALI_ETHIOPIA
LANGUAGE_SOMALI_KENYA = _Language.LANGUAGE_SOMALI_KENYA
LANGUAGE_SOMALI_SOMALIA = _Language.LANGUAGE_SOMALI_SOMALIA
LANGUAGE_SOUTH_NDEBELE = _Language.LANGUAGE_SOUTH_NDEBELE
LANGUAGE_SOUTH_NDEBELE_SOUTH_AFRICA = _Language.LANGUAGE_SOUTH_NDEBELE_SOUTH_AFRICA
LANGUAGE_SPANISH = _Language.LANGUAGE_SPANISH
LANGUAGE_SPANISH_ARGENTINA = _Language.LANGUAGE_SPANISH_ARGENTINA
LANGUAGE_SPANISH_BELIZE = _Language.LANGUAGE_SPANISH_BELIZE
LANGUAGE_SPANISH_BOLIVIA = _Language.LANGUAGE_SPANISH_BOLIVIA
LANGUAGE_SPANISH_BRAZIL = _Language.LANGUAGE_SPANISH_BRAZIL
LANGUAGE_SPANISH_CHILE = _Language.LANGUAGE_SPANISH_CHILE
LANGUAGE_SPANISH_COLOMBIA = _Language.LANGUAGE_SPANISH_COLOMBIA
LANGUAGE_SPANISH_COSTA_RICA = _Language.LANGUAGE_SPANISH_COSTA_RICA
LANGUAGE_SPANISH_CUBA = _Language.LANGUAGE_SPANISH_CUBA
LANGUAGE_SPANISH_DOMINICAN_REPUBLIC = _Language.LANGUAGE_SPANISH_DOMINICAN_REPUBLIC
LANGUAGE_SPANISH_ECUADOR = _Language.LANGUAGE_SPANISH_ECUADOR
LANGUAGE_SPANISH_EL_SALVADOR = _Language.LANGUAGE_SPANISH_EL_SALVADOR
LANGUAGE_SPANISH_EQUATORIAL_GUINEA = _Language.LANGUAGE_SPANISH_EQUATORIAL_GUINEA
LANGUAGE_SPANISH_GUATEMALA = _Language.LANGUAGE_SPANISH_GUATEMALA
LANGUAGE_SPANISH_HONDURAS = _Language.LANGUAGE_SPANISH_HONDURAS
LANGUAGE_SPANISH_LATIN_AMERICA = _Language.LANGUAGE_SPANISH_LATIN_AMERICA
LANGUAGE_SPANISH_MEXICAN = _Language.LANGUAGE_SPANISH_MEXICAN
LANGUAGE_SPANISH_NICARAGUA = _Language.LANGUAGE_SPANISH_NICARAGUA
LANGUAGE_SPANISH_PANAMA = _Language.LANGUAGE_SPANISH_PANAMA
LANGUAGE_SPANISH_PARAGUAY = _Language.LANGUAGE_SPANISH_PARAGUAY
LANGUAGE_SPANISH_PERU = _Language.LANGUAGE_SPANISH_PERU
LANGUAGE_SPANISH_PHILIPPINES = _Language.LANGUAGE_SPANISH_PHILIPPINES
LANGUAGE_SPANISH_PUERTO_RICO = _Language.LANGUAGE_SPANISH_PUERTO_RICO
LANGUAGE_SPANISH_SPAIN = _Language.LANGUAGE_SPANISH_SPAIN
LANGUAGE_SPANISH_URUGUAY = _Language.LANGUAGE_SPANISH_URUGUAY
LANGUAGE_SPANISH_US = _Language.LANGUAGE_SPANISH_US
LANGUAGE_SPANISH_VENEZUELA = _Language.LANGUAGE_SPANISH_VENEZUELA
LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT = _Language.LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT
LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH = _Language.LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH
LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH_MOROCCO = _Language.LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH_MOROCCO
LANGUAGE_SUNDANESE = _Language.LANGUAGE_SUNDANESE
LANGUAGE_SWAHILI = _Language.LANGUAGE_SWAHILI
LANGUAGE_SWAHILI_CONGO_DRC = _Language.LANGUAGE_SWAHILI_CONGO_DRC
LANGUAGE_SWAHILI_KENYA = _Language.LANGUAGE_SWAHILI_KENYA
LANGUAGE_SWAHILI_TANZANIA = _Language.LANGUAGE_SWAHILI_TANZANIA
LANGUAGE_SWAHILI_UGANDA = _Language.LANGUAGE_SWAHILI_UGANDA
LANGUAGE_SWEDISH = _Language.LANGUAGE_SWEDISH
LANGUAGE_SWEDISH_ALAND_ISLANDS = _Language.LANGUAGE_SWEDISH_ALAND_ISLANDS
LANGUAGE_SWEDISH_FINLAND = _Language.LANGUAGE_SWEDISH_FINLAND
LANGUAGE_SWEDISH_SWEDEN = _Language.LANGUAGE_SWEDISH_SWEDEN
LANGUAGE_SWISS_GERMAN = _Language.LANGUAGE_SWISS_GERMAN
LANGUAGE_SWISS_GERMAN_LIECHTENSTEIN = _Language.LANGUAGE_SWISS_GERMAN_LIECHTENSTEIN
LANGUAGE_SWISS_GERMAN_SWITZERLAND = _Language.LANGUAGE_SWISS_GERMAN_SWITZERLAND
LANGUAGE_SYRIAC = _Language.LANGUAGE_SYRIAC
LANGUAGE_SYRIAC_SYRIA = _Language.LANGUAGE_SYRIAC_SYRIA
LANGUAGE_TACHELHIT = _Language.LANGUAGE_TACHELHIT
LANGUAGE_TACHELHIT_LATIN = _Language.LANGUAGE_TACHELHIT_LATIN
LANGUAGE_TACHELHIT_LATIN_MOROCCO = _Language.LANGUAGE_TACHELHIT_LATIN_MOROCCO
LANGUAGE_TACHELHIT_TIFINAGH = _Language.LANGUAGE_TACHELHIT_TIFINAGH
LANGUAGE_TACHELHIT_TIFINAGH_MOROCCO = _Language.LANGUAGE_TACHELHIT_TIFINAGH_MOROCCO
LANGUAGE_TAGALOG = _Language.LANGUAGE_TAGALOG
LANGUAGE_TAITA = _Language.LANGUAGE_TAITA
LANGUAGE_TAITA_KENYA = _Language.LANGUAGE_TAITA_KENYA
LANGUAGE_TAJIK = _Language.LANGUAGE_TAJIK
LANGUAGE_TAJIK_CYRILLIC = _Language.LANGUAGE_TAJIK_CYRILLIC
LANGUAGE_TAJIK_CYRILLIC_TAJIKISTAN = _Language.LANGUAGE_TAJIK_CYRILLIC_TAJIKISTAN
LANGUAGE_TAMIL = _Language.LANGUAGE_TAMIL
LANGUAGE_TAMIL_INDIA = _Language.LANGUAGE_TAMIL_INDIA
LANGUAGE_TAMIL_MALAYSIA = _Language.LANGUAGE_TAMIL_MALAYSIA
LANGUAGE_TAMIL_SINGAPORE = _Language.LANGUAGE_TAMIL_SINGAPORE
LANGUAGE_TAMIL_SRI_LANKA = _Language.LANGUAGE_TAMIL_SRI_LANKA
LANGUAGE_TASAWAQ = _Language.LANGUAGE_TASAWAQ
LANGUAGE_TASAWAQ_NIGER = _Language.LANGUAGE_TASAWAQ_NIGER
LANGUAGE_TATAR = _Language.LANGUAGE_TATAR
LANGUAGE_TATAR_RUSSIA = _Language.LANGUAGE_TATAR_RUSSIA
LANGUAGE_TELUGU = _Language.LANGUAGE_TELUGU
LANGUAGE_TELUGU_INDIA = _Language.LANGUAGE_TELUGU_INDIA
LANGUAGE_TESO = _Language.LANGUAGE_TESO
LANGUAGE_TESO_KENYA = _Language.LANGUAGE_TESO_KENYA
LANGUAGE_TESO_UGANDA = _Language.LANGUAGE_TESO_UGANDA
LANGUAGE_THAI = _Language.LANGUAGE_THAI
LANGUAGE_THAI_THAILAND = _Language.LANGUAGE_THAI_THAILAND
LANGUAGE_TIBETAN = _Language.LANGUAGE_TIBETAN
LANGUAGE_TIBETAN_CHINA = _Language.LANGUAGE_TIBETAN_CHINA
LANGUAGE_TIBETAN_INDIA = _Language.LANGUAGE_TIBETAN_INDIA
LANGUAGE_TIGRE = _Language.LANGUAGE_TIGRE
LANGUAGE_TIGRE_ERITREA = _Language.LANGUAGE_TIGRE_ERITREA
LANGUAGE_TIGRINYA = _Language.LANGUAGE_TIGRINYA
LANGUAGE_TIGRINYA_ERITREA = _Language.LANGUAGE_TIGRINYA_ERITREA
LANGUAGE_TIGRINYA_ETHIOPIA = _Language.LANGUAGE_TIGRINYA_ETHIOPIA
LANGUAGE_TONGA = _Language.LANGUAGE_TONGA
LANGUAGE_TONGA_TONGA = _Language.LANGUAGE_TONGA_TONGA
LANGUAGE_TSONGA = _Language.LANGUAGE_TSONGA
LANGUAGE_TSONGA_SOUTH_AFRICA = _Language.LANGUAGE_TSONGA_SOUTH_AFRICA
LANGUAGE_TURKISH = _Language.LANGUAGE_TURKISH
LANGUAGE_TURKISH_CYPRUS = _Language.LANGUAGE_TURKISH_CYPRUS
LANGUAGE_TURKISH_TURKEY = _Language.LANGUAGE_TURKISH_TURKEY
LANGUAGE_TURKMEN = _Language.LANGUAGE_TURKMEN
LANGUAGE_TURKMEN_TURKMENISTAN = _Language.LANGUAGE_TURKMEN_TURKMENISTAN
LANGUAGE_TWI = _Language.LANGUAGE_TWI
LANGUAGE_UIGHUR = _Language.LANGUAGE_UIGHUR
LANGUAGE_UIGHUR_CHINA = _Language.LANGUAGE_UIGHUR_CHINA
LANGUAGE_UKRAINIAN = _Language.LANGUAGE_UKRAINIAN
LANGUAGE_UKRAINIAN_UKRAINE = _Language.LANGUAGE_UKRAINIAN_UKRAINE
LANGUAGE_UPPER_SORBIAN = _Language.LANGUAGE_UPPER_SORBIAN
LANGUAGE_UPPER_SORBIAN_GERMANY = _Language.LANGUAGE_UPPER_SORBIAN_GERMANY
LANGUAGE_URDU = _Language.LANGUAGE_URDU
LANGUAGE_URDU_INDIA = _Language.LANGUAGE_URDU_INDIA
LANGUAGE_URDU_PAKISTAN = _Language.LANGUAGE_URDU_PAKISTAN
LANGUAGE_UZBEK = _Language.LANGUAGE_UZBEK
LANGUAGE_UZBEK_CYRILLIC = _Language.LANGUAGE_UZBEK_CYRILLIC
LANGUAGE_UZBEK_CYRILLIC_UZBEKISTAN = _Language.LANGUAGE_UZBEK_CYRILLIC_UZBEKISTAN
LANGUAGE_UZBEK_LATIN = _Language.LANGUAGE_UZBEK_LATIN
LANGUAGE_UZBEK_LATIN_UZBEKISTAN = _Language.LANGUAGE_UZBEK_LATIN_UZBEKISTAN
LANGUAGE_UZBEK_PERSO_ARABIC = _Language.LANGUAGE_UZBEK_PERSO_ARABIC
LANGUAGE_UZBEK_PERSO_ARABIC_AFGHANISTAN = _Language.LANGUAGE_UZBEK_PERSO_ARABIC_AFGHANISTAN
LANGUAGE_VAI = _Language.LANGUAGE_VAI
LANGUAGE_VAI_LATIN = _Language.LANGUAGE_VAI_LATIN
LANGUAGE_VAI_LATIN_LIBERIA = _Language.LANGUAGE_VAI_LATIN_LIBERIA
LANGUAGE_VAI_VAI = _Language.LANGUAGE_VAI_VAI
LANGUAGE_VAI_VAI_LIBERIA = _Language.LANGUAGE_VAI_VAI_LIBERIA
LANGUAGE_VALENCIAN = _Language.LANGUAGE_VALENCIAN
LANGUAGE_VENDA = _Language.LANGUAGE_VENDA
LANGUAGE_VENDA_SOUTH_AFRICA = _Language.LANGUAGE_VENDA_SOUTH_AFRICA
LANGUAGE_VIETNAMESE = _Language.LANGUAGE_VIETNAMESE
LANGUAGE_VIETNAMESE_VIETNAM = _Language.LANGUAGE_VIETNAMESE_VIETNAM
LANGUAGE_VOLAPUK = _Language.LANGUAGE_VOLAPUK
LANGUAGE_VOLAPUK_WORLD = _Language.LANGUAGE_VOLAPUK_WORLD
LANGUAGE_VUNJO = _Language.LANGUAGE_VUNJO
LANGUAGE_VUNJO_TANZANIA = _Language.LANGUAGE_VUNJO_TANZANIA
LANGUAGE_WALSER = _Language.LANGUAGE_WALSER
LANGUAGE_WALSER_SWITZERLAND = _Language.LANGUAGE_WALSER_SWITZERLAND
LANGUAGE_WELSH = _Language.LANGUAGE_WELSH
LANGUAGE_WELSH_UK = _Language.LANGUAGE_WELSH_UK
LANGUAGE_WOLAYTTA = _Language.LANGUAGE_WOLAYTTA
LANGUAGE_WOLAYTTA_ETHIOPIA = _Language.LANGUAGE_WOLAYTTA_ETHIOPIA
LANGUAGE_WOLOF = _Language.LANGUAGE_WOLOF
LANGUAGE_WOLOF_SENEGAL = _Language.LANGUAGE_WOLOF_SENEGAL
LANGUAGE_XHOSA = _Language.LANGUAGE_XHOSA
LANGUAGE_XHOSA_SOUTH_AFRICA = _Language.LANGUAGE_XHOSA_SOUTH_AFRICA
LANGUAGE_YANGBEN = _Language.LANGUAGE_YANGBEN
LANGUAGE_YANGBEN_CAMEROON = _Language.LANGUAGE_YANGBEN_CAMEROON
LANGUAGE_YI = _Language.LANGUAGE_YI
LANGUAGE_YIDDISH = _Language.LANGUAGE_YIDDISH
LANGUAGE_YIDDISH_WORLD = _Language.LANGUAGE_YIDDISH_WORLD
LANGUAGE_YI_CHINA = _Language.LANGUAGE_YI_CHINA
LANGUAGE_YORUBA = _Language.LANGUAGE_YORUBA
LANGUAGE_YORUBA_BENIN = _Language.LANGUAGE_YORUBA_BENIN
LANGUAGE_YORUBA_NIGERIA = _Language.LANGUAGE_YORUBA_NIGERIA
LANGUAGE_ZARMA = _Language.LANGUAGE_ZARMA
LANGUAGE_ZARMA_NIGER = _Language.LANGUAGE_ZARMA_NIGER
LANGUAGE_ZHUANG = _Language.LANGUAGE_ZHUANG
LANGUAGE_ZULU = _Language.LANGUAGE_ZULU
LANGUAGE_ZULU_SOUTH_AFRICA = _Language.LANGUAGE_ZULU_SOUTH_AFRICA
LANGUAGE_USER_DEFINED = _Language.LANGUAGE_USER_DEFINED
LANGUAGE_AZERI = _Language.LANGUAGE_AZERI
LANGUAGE_AZERI_CYRILLIC = _Language.LANGUAGE_AZERI_CYRILLIC
LANGUAGE_AZERI_LATIN = _Language.LANGUAGE_AZERI_LATIN
LANGUAGE_BENGALI = _Language.LANGUAGE_BENGALI
LANGUAGE_BENGALI_BANGLADESH = _Language.LANGUAGE_BENGALI_BANGLADESH
LANGUAGE_BENGALI_INDIA = _Language.LANGUAGE_BENGALI_INDIA
LANGUAGE_BHUTANI = _Language.LANGUAGE_BHUTANI
LANGUAGE_CHINESE_SIMPLIFIED = _Language.LANGUAGE_CHINESE_SIMPLIFIED
LANGUAGE_CHINESE_TRADITIONAL = _Language.LANGUAGE_CHINESE_TRADITIONAL
LANGUAGE_CHINESE_MACAU = _Language.LANGUAGE_CHINESE_MACAU
LANGUAGE_KERNEWEK = _Language.LANGUAGE_KERNEWEK
LANGUAGE_MALAY_BRUNEI_DARUSSALAM = _Language.LANGUAGE_MALAY_BRUNEI_DARUSSALAM
LANGUAGE_ORIYA = _Language.LANGUAGE_ORIYA
LANGUAGE_ORIYA_INDIA = _Language.LANGUAGE_ORIYA_INDIA
LANGUAGE_SPANISH_MODERN = _Language.LANGUAGE_SPANISH_MODERN
LANGUAGE_CAMBODIAN = _Language.LANGUAGE_CAMBODIAN

class _LayoutDirection(IntEnum):
    Layout_Default = auto()
    Layout_LeftToRight = auto()
    Layout_RightToLeft = auto()
LayoutDirection: TypeAlias = Union[_LayoutDirection, int]
Layout_Default = _LayoutDirection.Layout_Default
Layout_LeftToRight = _LayoutDirection.Layout_LeftToRight
Layout_RightToLeft = _LayoutDirection.Layout_RightToLeft

class _LocaleTagType(IntEnum):
    LOCALE_TAGTYPE_DEFAULT = auto()
    LOCALE_TAGTYPE_SYSTEM = auto()
    LOCALE_TAGTYPE_BCP47 = auto()
    LOCALE_TAGTYPE_MACOS = auto()
    LOCALE_TAGTYPE_POSIX = auto()
    LOCALE_TAGTYPE_WINDOWS = auto()
LocaleTagType: TypeAlias = Union[_LocaleTagType, int]
LOCALE_TAGTYPE_DEFAULT = _LocaleTagType.LOCALE_TAGTYPE_DEFAULT
LOCALE_TAGTYPE_SYSTEM = _LocaleTagType.LOCALE_TAGTYPE_SYSTEM
LOCALE_TAGTYPE_BCP47 = _LocaleTagType.LOCALE_TAGTYPE_BCP47
LOCALE_TAGTYPE_MACOS = _LocaleTagType.LOCALE_TAGTYPE_MACOS
LOCALE_TAGTYPE_POSIX = _LocaleTagType.LOCALE_TAGTYPE_POSIX
LOCALE_TAGTYPE_WINDOWS = _LocaleTagType.LOCALE_TAGTYPE_WINDOWS

class _LocaleCategory(IntEnum):
    LOCALE_CAT_NUMBER = auto()
    LOCALE_CAT_DATE = auto()
    LOCALE_CAT_MONEY = auto()
    LOCALE_CAT_DEFAULT = auto()
LocaleCategory: TypeAlias = Union[_LocaleCategory, int]
LOCALE_CAT_NUMBER = _LocaleCategory.LOCALE_CAT_NUMBER
LOCALE_CAT_DATE = _LocaleCategory.LOCALE_CAT_DATE
LOCALE_CAT_MONEY = _LocaleCategory.LOCALE_CAT_MONEY
LOCALE_CAT_DEFAULT = _LocaleCategory.LOCALE_CAT_DEFAULT

class _LocaleInfo(IntEnum):
    LOCALE_THOUSANDS_SEP = auto()
    LOCALE_DECIMAL_POINT = auto()
    LOCALE_SHORT_DATE_FMT = auto()
    LOCALE_LONG_DATE_FMT = auto()
    LOCALE_DATE_TIME_FMT = auto()
    LOCALE_TIME_FMT = auto()
LocaleInfo: TypeAlias = Union[_LocaleInfo, int]
LOCALE_THOUSANDS_SEP = _LocaleInfo.LOCALE_THOUSANDS_SEP
LOCALE_DECIMAL_POINT = _LocaleInfo.LOCALE_DECIMAL_POINT
LOCALE_SHORT_DATE_FMT = _LocaleInfo.LOCALE_SHORT_DATE_FMT
LOCALE_LONG_DATE_FMT = _LocaleInfo.LOCALE_LONG_DATE_FMT
LOCALE_DATE_TIME_FMT = _LocaleInfo.LOCALE_DATE_TIME_FMT
LOCALE_TIME_FMT = _LocaleInfo.LOCALE_TIME_FMT

class _LocaleName(IntEnum):
    LOCALE_NAME_LOCALE = auto()
    LOCALE_NAME_LANGUAGE = auto()
    LOCALE_NAME_COUNTRY = auto()
LocaleName: TypeAlias = Union[_LocaleName, int]
LOCALE_NAME_LOCALE = _LocaleName.LOCALE_NAME_LOCALE
LOCALE_NAME_LANGUAGE = _LocaleName.LOCALE_NAME_LANGUAGE
LOCALE_NAME_COUNTRY = _LocaleName.LOCALE_NAME_COUNTRY

class _LocaleForm(IntEnum):
    LOCALE_FORM_NATIVE = auto()
    LOCALE_FORM_ENGLISH = auto()
LocaleForm: TypeAlias = Union[_LocaleForm, int]
LOCALE_FORM_NATIVE = _LocaleForm.LOCALE_FORM_NATIVE
LOCALE_FORM_ENGLISH = _LocaleForm.LOCALE_FORM_ENGLISH

class _LocaleInitFlags(IntFlag):
    LOCALE_DONT_LOAD_DEFAULT = auto()
    LOCALE_LOAD_DEFAULT = auto()
LocaleInitFlags: TypeAlias = Union[_LocaleInitFlags, int]
LOCALE_DONT_LOAD_DEFAULT = _LocaleInitFlags.LOCALE_DONT_LOAD_DEFAULT
LOCALE_LOAD_DEFAULT = _LocaleInitFlags.LOCALE_LOAD_DEFAULT

class LanguageInfo:
    """
    Encapsulates a wxLanguage identifier together with OS-specific
    information related to that language.
    """
    Language: int
    LocaleTag: str
    CanonicalName: str
    CanonicalRef: str
    Description: str
    DescriptionNative: str
    LayoutDirection: LayoutDirection

    def GetLocaleName(self) -> str:
        """
        GetLocaleName() -> str
        
        Return the locale name corresponding to this language usable with
        setlocale() on the current system.
        """

    def GetCanonicalWithRegion(self) -> str:
        """
        GetCanonicalWithRegion() -> str
        
        Return the canonical locale name including the region, if known.
        """
    @property
    def CanonicalWithRegion(self) -> str: ...
    @property
    def LocaleName(self) -> str: ...
# end of class LanguageInfo


class Locale:
    """
    Locale() -> None
    Locale(language, flags=LOCALE_LOAD_DEFAULT) -> None
    Locale(name, shortName='', locale='', bLoadDefault=True) -> None
    
    wxLocale class encapsulates all language-dependent settings and is a
    generalization of the C locale concept.
    """

    @overload
    def __init__(self, language: int, flags: int=LOCALE_LOAD_DEFAULT) -> None:
        ...

    @overload
    def __init__(self, name: str, shortName: str='', locale: str='', bLoadDefault: bool=True) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Locale() -> None
        Locale(language, flags=LOCALE_LOAD_DEFAULT) -> None
        Locale(name, shortName='', locale='', bLoadDefault=True) -> None
        
        wxLocale class encapsulates all language-dependent settings and is a
        generalization of the C locale concept.
        """

    @overload
    def AddCatalog(self, domain: str, msgIdLanguage: Language) -> bool:
        ...

    @overload
    def AddCatalog(self, domain: str, msgIdLanguage: Language, msgIdCharset: str) -> bool:
        ...

    @overload
    def AddCatalog(self, domain: str) -> bool:
        """
        AddCatalog(domain) -> bool
        AddCatalog(domain, msgIdLanguage) -> bool
        AddCatalog(domain, msgIdLanguage, msgIdCharset) -> bool
        
        Calls wxTranslations::AddCatalog(const wxString&).
        """

    def GetCanonicalName(self) -> str:
        """
        GetCanonicalName() -> str
        
        Returns the canonical form of current locale name.
        """

    def GetHeaderValue(self, header: str, domain: str='') -> str:
        """
        GetHeaderValue(header, domain='') -> str
        
        Calls wxTranslations::GetHeaderValue().
        """

    def GetLanguage(self) -> int:
        """
        GetLanguage() -> int
        
        Returns the wxLanguage constant of current language.
        """

    def GetLocale(self) -> str:
        """
        GetLocale() -> str
        
        Returns the locale name as passed to the constructor or Init().
        """

    def GetName(self) -> str:
        """
        GetName() -> str
        
        Returns the current short name for the locale (as given to the
        constructor or the Init() function).
        """

    @overload
    def GetString(self, origString: str, origString2: str, n: int, domain: str='') -> str:
        ...

    @overload
    def GetString(self, origString: str, domain: str='') -> str:
        """
        GetString(origString, domain='') -> str
        GetString(origString, origString2, n, domain='') -> str
        
        Calls wxGetTranslation(const wxString&, const wxString&).
        """

    def GetSysName(self) -> str:
        """
        GetSysName() -> str
        
        Returns current platform-specific locale name as passed to
        setlocale().
        """

    @overload
    def Init(self, name: str, shortName: str='', locale: str='', bLoadDefault: bool=True) -> bool:
        ...

    @overload
    def Init(self, language: int=LANGUAGE_DEFAULT, flags: int=LOCALE_LOAD_DEFAULT) -> bool:
        """
        Init(language=LANGUAGE_DEFAULT, flags=LOCALE_LOAD_DEFAULT) -> bool
        Init(name, shortName='', locale='', bLoadDefault=True) -> bool
        
        Initializes the wxLocale instance.
        """

    def IsLoaded(self, domain: str) -> bool:
        """
        IsLoaded(domain) -> bool
        
        Calls wxTranslations::IsLoaded().
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the locale could be set successfully.
        """

    @staticmethod
    def AddCatalogLookupPathPrefix(prefix: str) -> None:
        """
        AddCatalogLookupPathPrefix(prefix) -> None
        
        Calls wxFileTranslationsLoader::AddCatalogLookupPathPrefix().
        """

    @staticmethod
    def AddLanguage(info: LanguageInfo) -> None:
        """
        AddLanguage(info) -> None
        
        Adds custom, user-defined language to the database of known languages.
        """

    @staticmethod
    def FindLanguageInfo(locale: str) -> LanguageInfo:
        """
        FindLanguageInfo(locale) -> LanguageInfo
        
        This function may be used to find the language description structure
        for the given locale, specified either as a two letter ISO language
        code (for example, "pt"), a language code followed by the country code
        ("pt_BR") or a full, human readable, language description
        ("Portuguese_Brazil").
        """

    @staticmethod
    def GetLanguageInfo(lang: int) -> LanguageInfo:
        """
        GetLanguageInfo(lang) -> LanguageInfo
        
        Returns a pointer to wxLanguageInfo structure containing information
        about the given language or NULL if this language is unknown.
        """

    @staticmethod
    def GetLanguageName(lang: int) -> str:
        """
        GetLanguageName(lang) -> str
        
        Returns English name of the given language or empty string if this
        language is unknown.
        """

    @staticmethod
    def GetLanguageCanonicalName(lang: int) -> str:
        """
        GetLanguageCanonicalName(lang) -> str
        
        Returns canonical name (see GetCanonicalName()) of the given language
        or empty string if this language is unknown.
        """

    @staticmethod
    def GetSystemEncoding() -> FontEncoding:
        """
        GetSystemEncoding() -> FontEncoding
        
        Tries to detect the user's default font encoding.
        """

    @staticmethod
    def GetSystemEncodingName() -> str:
        """
        GetSystemEncodingName() -> str
        
        Tries to detect the name of the user's default font encoding.
        """

    @staticmethod
    def GetSystemLanguage() -> int:
        """
        GetSystemLanguage() -> int
        
        Tries to detect the user's default locale setting.
        """

    @staticmethod
    def GetInfo(index: LocaleInfo, cat: LocaleCategory=LOCALE_CAT_DEFAULT) -> str:
        """
        GetInfo(index, cat=LOCALE_CAT_DEFAULT) -> str
        
        Get the values of the given locale-dependent datum.
        """

    @staticmethod
    def GetOSInfo(index: LocaleInfo, cat: LocaleCategory=LOCALE_CAT_DEFAULT) -> str:
        """
        GetOSInfo(index, cat=LOCALE_CAT_DEFAULT) -> str
        
        Get the values of a locale datum in the OS locale.
        """

    @staticmethod
    def IsAvailable(lang: int) -> bool:
        """
        IsAvailable(lang) -> bool
        
        Check whether the operating system and/or C run time environment
        supports this locale.
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """
    @property
    def CanonicalName(self) -> str: ...
    @property
    def Language(self) -> int: ...
    @property
    def Locale(self) -> str: ...
    @property
    def Name(self) -> str: ...
    @property
    def SysName(self) -> str: ...
# end of class Locale


def GetLocale() -> Locale:    """
    GetLocale() -> Locale
    
    Get the current locale object (note that it may be NULL!)
    """

#----------------------------------------------------------------------------
# Add the directory where the wxWidgets catalogs were installed
# to the default catalog path, if they were put in the package dir.
import os
_localedir = os.path.join(os.path.dirname(__file__), "locale")
if os.path.exists(_localedir):
    if isinstance(_localedir, (bytes, bytearray)):
        _localedir = _localedir.decode(_sys.getfilesystemencoding())
    Locale.AddCatalogLookupPathPrefix(_localedir)
del os
#----------------------------------------------------------------------------
#-- end-intl --#
#-- begin-translation --#

class Translations:
    """
    Translations() -> None
    
    This class allows getting translations for strings.
    """

    def __init__(self) -> None:
        """
        Translations() -> None
        
        This class allows getting translations for strings.
        """

    def SetLoader(self, loader: TranslationsLoader) -> None:
        """
        SetLoader(loader) -> None
        
        Changes loader use to read catalogs to a non-default one.
        """

    @overload
    def SetLanguage(self, lang: str) -> None:
        ...

    @overload
    def SetLanguage(self, lang: Language) -> None:
        """
        SetLanguage(lang) -> None
        SetLanguage(lang) -> None
        
        Sets translations language to use.
        """

    def GetAvailableTranslations(self, domain: str) -> List[str]:
        """
        GetAvailableTranslations(domain) -> List[str]
        
        Returns list of all translations of domain that were found.
        """

    def GetBestAvailableTranslation(self, domain: str) -> str:
        """
        GetBestAvailableTranslation(domain) -> str
        
        Returns the best available translation for the required language.
        """

    @overload
    def GetBestTranslation(self, domain: str, msgIdLanguage: str="en") -> str:
        ...

    @overload
    def GetBestTranslation(self, domain: str, msgIdLanguage: Language) -> str:
        """
        GetBestTranslation(domain, msgIdLanguage) -> str
        GetBestTranslation(domain, msgIdLanguage="en") -> str
        
        Returns the best UI language for the domain.
        """

    def AddStdCatalog(self) -> bool:
        """
        AddStdCatalog() -> bool
        
        Add standard wxWidgets catalogs ("wxstd" and possible port-specific
        catalogs).
        """

    def AddAvailableCatalog(self, domain: str, msgIdLanguage: Language=LANGUAGE_ENGLISH_US) -> bool:
        """
        AddAvailableCatalog(domain, msgIdLanguage=LANGUAGE_ENGLISH_US) -> bool
        
        Add a catalog for use with the current locale.
        """

    def AddCatalog(self, domain: str, msgIdLanguage: Language=LANGUAGE_ENGLISH_US) -> bool:
        """
        AddCatalog(domain, msgIdLanguage=LANGUAGE_ENGLISH_US) -> bool
        
        Add a catalog for use with the current locale or fall back to the
        original messages language.
        """

    def IsLoaded(self, domain: str) -> bool:
        """
        IsLoaded(domain) -> bool
        
        Check if the given catalog is loaded, and returns true if it is.
        """

    @overload
    def GetTranslatedString(self, origString: str, n: int, domain: str='') -> str:
        ...

    @overload
    def GetTranslatedString(self, origString: str, domain: str='') -> str:
        """
        GetTranslatedString(origString, domain='') -> str
        GetTranslatedString(origString, n, domain='') -> str
        
        Retrieves the translation for a string in all loaded domains unless
        the domain parameter is specified (and then only this catalog/domain
        is searched).
        """

    def GetHeaderValue(self, header: str, domain: str='') -> str:
        """
        GetHeaderValue(header, domain='') -> str
        
        Returns the header value for header header.
        """

    @staticmethod
    def Get() -> Translations:
        """
        Get() -> Translations
        
        Returns current translations object, may return NULL.
        """

    @staticmethod
    def Set(t: Translations) -> None:
        """
        Set(t) -> None
        
        Sets current translations object.
        """
# end of class Translations


class TranslationsLoader:
    """
    TranslationsLoader() -> None
    
    Abstraction of translations discovery and loading.
    """

    def __init__(self) -> None:
        """
        TranslationsLoader() -> None
        
        Abstraction of translations discovery and loading.
        """

    def LoadCatalog(self, domain: str, lang: str) -> MsgCatalog:
        """
        LoadCatalog(domain, lang) -> MsgCatalog
        
        Called to load requested catalog.
        """

    def GetAvailableTranslations(self, domain: str) -> List[str]:
        """
        GetAvailableTranslations(domain) -> List[str]
        
        Implements wxTranslations::GetAvailableTranslations().
        """
# end of class TranslationsLoader


class FileTranslationsLoader(TranslationsLoader):
    """
    Standard wxTranslationsLoader implementation.
    """

    @staticmethod
    def AddCatalogLookupPathPrefix(prefix: str) -> None:
        """
        AddCatalogLookupPathPrefix(prefix) -> None
        
        Add a prefix to the catalog lookup path: the message catalog files
        will be looked up under prefix/lang/LC_MESSAGES and prefix/lang
        directories (in this order).
        """
# end of class FileTranslationsLoader


@overload
def GetTranslation(string: str, plural: str, n: int, domain: str='', context: str='') -> str:    ...

@overload
def GetTranslation(string: str, domain: str='', context: str='') -> str:    """
    GetTranslation(string, domain='', context='') -> str
    GetTranslation(string, plural, n, domain='', context='') -> str
    
    This function returns the translation of string in the current
    locale().
    """
#-- end-translation --#
#-- begin-cmndata --#

class _PrintBin(IntEnum):
    PRINTBIN_DEFAULT = auto()
    PRINTBIN_ONLYONE = auto()
    PRINTBIN_LOWER = auto()
    PRINTBIN_MIDDLE = auto()
    PRINTBIN_MANUAL = auto()
    PRINTBIN_ENVELOPE = auto()
    PRINTBIN_ENVMANUAL = auto()
    PRINTBIN_AUTO = auto()
    PRINTBIN_TRACTOR = auto()
    PRINTBIN_SMALLFMT = auto()
    PRINTBIN_LARGEFMT = auto()
    PRINTBIN_LARGECAPACITY = auto()
    PRINTBIN_CASSETTE = auto()
    PRINTBIN_FORMSOURCE = auto()
    PRINTBIN_USER = auto()
PrintBin: TypeAlias = Union[_PrintBin, int]
PRINTBIN_DEFAULT = _PrintBin.PRINTBIN_DEFAULT
PRINTBIN_ONLYONE = _PrintBin.PRINTBIN_ONLYONE
PRINTBIN_LOWER = _PrintBin.PRINTBIN_LOWER
PRINTBIN_MIDDLE = _PrintBin.PRINTBIN_MIDDLE
PRINTBIN_MANUAL = _PrintBin.PRINTBIN_MANUAL
PRINTBIN_ENVELOPE = _PrintBin.PRINTBIN_ENVELOPE
PRINTBIN_ENVMANUAL = _PrintBin.PRINTBIN_ENVMANUAL
PRINTBIN_AUTO = _PrintBin.PRINTBIN_AUTO
PRINTBIN_TRACTOR = _PrintBin.PRINTBIN_TRACTOR
PRINTBIN_SMALLFMT = _PrintBin.PRINTBIN_SMALLFMT
PRINTBIN_LARGEFMT = _PrintBin.PRINTBIN_LARGEFMT
PRINTBIN_LARGECAPACITY = _PrintBin.PRINTBIN_LARGECAPACITY
PRINTBIN_CASSETTE = _PrintBin.PRINTBIN_CASSETTE
PRINTBIN_FORMSOURCE = _PrintBin.PRINTBIN_FORMSOURCE
PRINTBIN_USER = _PrintBin.PRINTBIN_USER

class PageSetupDialogData(Object):
    """
    PageSetupDialogData() -> None
    PageSetupDialogData(data) -> None
    PageSetupDialogData(printData) -> None
    
    This class holds a variety of information related to
    wxPageSetupDialog.
    """

    @overload
    def __init__(self, data: PageSetupDialogData) -> None:
        ...

    @overload
    def __init__(self, printData: PrintData) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        PageSetupDialogData() -> None
        PageSetupDialogData(data) -> None
        PageSetupDialogData(printData) -> None
        
        This class holds a variety of information related to
        wxPageSetupDialog.
        """

    def EnableHelp(self, flag: bool) -> None:
        """
        EnableHelp(flag) -> None
        
        Enables or disables the "Help" button (Windows only).
        """

    def EnableMargins(self, flag: bool) -> None:
        """
        EnableMargins(flag) -> None
        
        Enables or disables the margin controls (Windows only).
        """

    def EnableOrientation(self, flag: bool) -> None:
        """
        EnableOrientation(flag) -> None
        
        Enables or disables the orientation control (Windows only).
        """

    def EnablePaper(self, flag: bool) -> None:
        """
        EnablePaper(flag) -> None
        
        Enables or disables the paper size control (Windows only).
        """

    def EnablePrinter(self, flag: bool) -> None:
        """
        EnablePrinter(flag) -> None
        
        Enables or disables the "Printer" button, which invokes a printer
        setup dialog.
        """

    def GetDefaultInfo(self) -> bool:
        """
        GetDefaultInfo() -> bool
        
        Returns true if the dialog will simply return default printer
        information (such as orientation) instead of showing a dialog (Windows
        only).
        """

    def GetDefaultMinMargins(self) -> bool:
        """
        GetDefaultMinMargins() -> bool
        
        Returns true if the page setup dialog will take its minimum margin
        values from the currently selected printer properties (Windows only).
        """

    def GetEnableHelp(self) -> bool:
        """
        GetEnableHelp() -> bool
        
        Returns true if the printer setup button is enabled.
        """

    def GetEnableMargins(self) -> bool:
        """
        GetEnableMargins() -> bool
        
        Returns true if the margin controls are enabled (Windows only).
        """

    def GetEnableOrientation(self) -> bool:
        """
        GetEnableOrientation() -> bool
        
        Returns true if the orientation control is enabled (Windows only).
        """

    def GetEnablePaper(self) -> bool:
        """
        GetEnablePaper() -> bool
        
        Returns true if the paper size control is enabled (Windows only).
        """

    def GetEnablePrinter(self) -> bool:
        """
        GetEnablePrinter() -> bool
        
        Returns true if the printer setup button is enabled.
        """

    def GetMarginBottomRight(self) -> Point:
        """
        GetMarginBottomRight() -> Point
        
        Returns the right (x) and bottom (y) margins in millimetres.
        """

    def GetMarginTopLeft(self) -> Point:
        """
        GetMarginTopLeft() -> Point
        
        Returns the left (x) and top (y) margins in millimetres.
        """

    def GetMinMarginBottomRight(self) -> Point:
        """
        GetMinMarginBottomRight() -> Point
        
        Returns the right (x) and bottom (y) minimum margins the user can
        enter (Windows only).
        """

    def GetMinMarginTopLeft(self) -> Point:
        """
        GetMinMarginTopLeft() -> Point
        
        Returns the left (x) and top (y) minimum margins the user can enter
        (Windows only).
        """

    def GetPaperId(self) -> PaperSize:
        """
        GetPaperId() -> PaperSize
        
        Returns the paper id (stored in the internal wxPrintData object).
        """

    def GetPaperSize(self) -> Size:
        """
        GetPaperSize() -> Size
        
        Returns the paper size in millimetres.
        """

    def GetPrintData(self) -> PrintData:
        """
        GetPrintData() -> PrintData
        
        Returns a reference to the print data associated with this object.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the print data associated with the dialog data is
        valid.
        """

    def SetDefaultInfo(self, flag: bool) -> None:
        """
        SetDefaultInfo(flag) -> None
        
        Pass true if the dialog will simply return default printer information
        (such as orientation) instead of showing a dialog (Windows only).
        """

    def SetDefaultMinMargins(self, flag: bool) -> None:
        """
        SetDefaultMinMargins(flag) -> None
        
        Pass true if the page setup dialog will take its minimum margin values
        from the currently selected printer properties (Windows only).
        """

    def SetMarginBottomRight(self, pt: Point) -> None:
        """
        SetMarginBottomRight(pt) -> None
        
        Sets the right (x) and bottom (y) margins in millimetres.
        """

    def SetMarginTopLeft(self, pt: Point) -> None:
        """
        SetMarginTopLeft(pt) -> None
        
        Sets the left (x) and top (y) margins in millimetres.
        """

    def SetMinMarginBottomRight(self, pt: Point) -> None:
        """
        SetMinMarginBottomRight(pt) -> None
        
        Sets the right (x) and bottom (y) minimum margins the user can enter
        (Windows only).
        """

    def SetMinMarginTopLeft(self, pt: Point) -> None:
        """
        SetMinMarginTopLeft(pt) -> None
        
        Sets the left (x) and top (y) minimum margins the user can enter
        (Windows only).
        """

    def SetPaperId(self, id: PaperSize) -> None:
        """
        SetPaperId(id) -> None
        
        Sets the paper size id.
        """

    def SetPaperSize(self, size: Size) -> None:
        """
        SetPaperSize(size) -> None
        
        Sets the paper size in millimetres.
        """

    def SetPrintData(self, printData: PrintData) -> None:
        """
        SetPrintData(printData) -> None
        
        Sets the print data associated with this object.
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """
    @property
    def MarginBottomRight(self) -> Point: ...
    @MarginBottomRight.setter
    def MarginBottomRight(self, value: Point, /) -> None: ...
    @property
    def MarginTopLeft(self) -> Point: ...
    @MarginTopLeft.setter
    def MarginTopLeft(self, value: Point, /) -> None: ...
    @property
    def MinMarginBottomRight(self) -> Point: ...
    @MinMarginBottomRight.setter
    def MinMarginBottomRight(self, value: Point, /) -> None: ...
    @property
    def MinMarginTopLeft(self) -> Point: ...
    @MinMarginTopLeft.setter
    def MinMarginTopLeft(self, value: Point, /) -> None: ...
    @property
    def PaperId(self) -> PaperSize: ...
    @PaperId.setter
    def PaperId(self, value: PaperSize, /) -> None: ...
    @property
    def PaperSize(self) -> Size: ...
    @PaperSize.setter
    def PaperSize(self, value: Size, /) -> None: ...
    @property
    def PrintData(self) -> PrintData: ...
    @PrintData.setter
    def PrintData(self, value: PrintData, /) -> None: ...
# end of class PageSetupDialogData


class PrintData(Object):
    """
    PrintData() -> None
    PrintData(data) -> None
    
    This class holds a variety of information related to printers and
    printer device contexts.
    """

    @overload
    def __init__(self, data: PrintData) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        PrintData() -> None
        PrintData(data) -> None
        
        This class holds a variety of information related to printers and
        printer device contexts.
        """

    def GetBin(self) -> PrintBin:
        """
        GetBin() -> PrintBin
        
        Returns the current bin (papersource).
        """

    def GetCollate(self) -> bool:
        """
        GetCollate() -> bool
        
        Returns true if collation is on.
        """

    def GetColour(self) -> bool:
        """
        GetColour() -> bool
        
        Returns true if colour printing is on.
        """

    def GetDuplex(self) -> DuplexMode:
        """
        GetDuplex() -> DuplexMode
        
        Returns the duplex mode.
        """

    def GetNoCopies(self) -> int:
        """
        GetNoCopies() -> int
        
        Returns the number of copies requested by the user.
        """

    def GetOrientation(self) -> PrintOrientation:
        """
        GetOrientation() -> PrintOrientation
        
        Gets the orientation.
        """

    def GetPaperId(self) -> PaperSize:
        """
        GetPaperId() -> PaperSize
        
        Returns the paper size id.
        """

    def GetPrinterName(self) -> str:
        """
        GetPrinterName() -> str
        
        Returns the printer name.
        """

    def GetQuality(self) -> PrintQuality:
        """
        GetQuality() -> PrintQuality
        
        Returns the current print quality.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the print data is valid for using in print dialogs.
        """

    def SetBin(self, flag: PrintBin) -> None:
        """
        SetBin(flag) -> None
        
        Sets the current bin.
        """

    def SetCollate(self, flag: bool) -> None:
        """
        SetCollate(flag) -> None
        
        Sets collation to on or off.
        """

    def SetColour(self, flag: bool) -> None:
        """
        SetColour(flag) -> None
        
        Sets colour printing on or off.
        """

    def SetDuplex(self, mode: DuplexMode) -> None:
        """
        SetDuplex(mode) -> None
        
        Returns the duplex mode.
        """

    def SetNoCopies(self, n: int) -> None:
        """
        SetNoCopies(n) -> None
        
        Sets the default number of copies to be printed out.
        """

    def SetOrientation(self, orientation: PrintOrientation) -> None:
        """
        SetOrientation(orientation) -> None
        
        Sets the orientation.
        """

    def SetPaperId(self, paperId: PaperSize) -> None:
        """
        SetPaperId(paperId) -> None
        
        Sets the paper id.
        """

    @overload
    def SetPaperSize(self, sz: Size) -> None:
        ...

    @overload
    def SetPaperSize(self, size: Size) -> None:
        """
        SetPaperSize(size) -> None
        SetPaperSize(sz) -> None
        
        Sets custom paper size.
        """

    def SetPrinterName(self, printerName: str) -> None:
        """
        SetPrinterName(printerName) -> None
        
        Sets the printer name.
        """

    def SetQuality(self, quality: PrintQuality) -> None:
        """
        SetQuality(quality) -> None
        
        Sets the desired print quality.
        """

    def GetFilename(self) -> str:
        """
        GetFilename() -> str
        """

    def SetFilename(self, filename: str) -> None:
        """
        SetFilename(filename) -> None
        """

    def GetPrintMode(self) -> PrintMode:
        """
        GetPrintMode() -> PrintMode
        """

    def SetPrintMode(self, printMode: PrintMode) -> None:
        """
        SetPrintMode(printMode) -> None
        """

    def GetPaperSize(self) -> Size:
        """
        GetPaperSize() -> Size
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def GetPrivData(self) -> Any:
        """
        GetPrivData() -> Any
        """

    def SetPrivData(self, data: Any) -> None:
        """
        SetPrivData(data) -> None
        """
    @property
    def Bin(self) -> PrintBin: ...
    @Bin.setter
    def Bin(self, value: PrintBin, /) -> None: ...
    @property
    def Collate(self) -> bool: ...
    @Collate.setter
    def Collate(self, value: bool, /) -> None: ...
    @property
    def Colour(self) -> bool: ...
    @Colour.setter
    def Colour(self, value: bool, /) -> None: ...
    @property
    def Duplex(self) -> DuplexMode: ...
    @Duplex.setter
    def Duplex(self, value: DuplexMode, /) -> None: ...
    @property
    def Filename(self) -> str: ...
    @Filename.setter
    def Filename(self, value: str, /) -> None: ...
    @property
    def NoCopies(self) -> int: ...
    @NoCopies.setter
    def NoCopies(self, value: int, /) -> None: ...
    @property
    def Orientation(self) -> PrintOrientation: ...
    @Orientation.setter
    def Orientation(self, value: PrintOrientation, /) -> None: ...
    @property
    def PaperId(self) -> PaperSize: ...
    @PaperId.setter
    def PaperId(self, value: PaperSize, /) -> None: ...
    @property
    def PaperSize(self) -> Size: ...
    @PaperSize.setter
    def PaperSize(self, value: Size, /) -> None: ...
    @property
    def PrintMode(self) -> PrintMode: ...
    @PrintMode.setter
    def PrintMode(self, value: PrintMode, /) -> None: ...
    @property
    def PrinterName(self) -> str: ...
    @PrinterName.setter
    def PrinterName(self, value: str, /) -> None: ...
    @property
    def PrivData(self) -> Any: ...
    @PrivData.setter
    def PrivData(self, value: Any, /) -> None: ...
    @property
    def Quality(self) -> PrintQuality: ...
    @Quality.setter
    def Quality(self, value: PrintQuality, /) -> None: ...
# end of class PrintData


class PrintDialogData(Object):
    """
    PrintDialogData() -> None
    PrintDialogData(dialogData) -> None
    PrintDialogData(printData) -> None
    
    This class holds information related to the visual characteristics of
    wxPrintDialog.
    """

    @overload
    def __init__(self, dialogData: PrintDialogData) -> None:
        ...

    @overload
    def __init__(self, printData: PrintData) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        PrintDialogData() -> None
        PrintDialogData(dialogData) -> None
        PrintDialogData(printData) -> None
        
        This class holds information related to the visual characteristics of
        wxPrintDialog.
        """

    def EnableHelp(self, flag: bool) -> None:
        """
        EnableHelp(flag) -> None
        
        Enables or disables the "Help" button.
        """

    def EnablePageNumbers(self, flag: bool) -> None:
        """
        EnablePageNumbers(flag) -> None
        
        Enables or disables the "Page numbers" controls.
        """

    def EnablePrintToFile(self, flag: bool) -> None:
        """
        EnablePrintToFile(flag) -> None
        
        Enables or disables the "Print to file" checkbox.
        """

    def EnableSelection(self, flag: bool) -> None:
        """
        EnableSelection(flag) -> None
        
        Enables or disables the "Selection" radio button.
        """

    def GetAllPages(self) -> bool:
        """
        GetAllPages() -> bool
        
        Returns true if the user requested that all pages be printed.
        """

    def GetCollate(self) -> bool:
        """
        GetCollate() -> bool
        
        Returns true if the user requested that the document(s) be collated.
        """

    def GetFromPage(self) -> int:
        """
        GetFromPage() -> int
        
        Returns the from page number, as entered by the user.
        """

    def GetMaxPage(self) -> int:
        """
        GetMaxPage() -> int
        
        Returns the maximum page number.
        """

    def GetMinPage(self) -> int:
        """
        GetMinPage() -> int
        
        Returns the minimum page number.
        """

    def GetNoCopies(self) -> int:
        """
        GetNoCopies() -> int
        
        Returns the number of copies requested by the user.
        """

    def GetPrintData(self) -> PrintData:
        """
        GetPrintData() -> PrintData
        
        Returns a reference to the internal wxPrintData object.
        """

    def GetPrintToFile(self) -> bool:
        """
        GetPrintToFile() -> bool
        
        Returns true if the user has selected printing to a file.
        """

    def GetSelection(self) -> bool:
        """
        GetSelection() -> bool
        
        Returns true if the user requested that the selection be printed
        (where "selection" is a concept specific to the application).
        """

    def GetToPage(self) -> int:
        """
        GetToPage() -> int
        
        Returns the "print to" page number, as entered by the user.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the print data is valid for using in print dialogs.
        """

    def SetCollate(self, flag: bool) -> None:
        """
        SetCollate(flag) -> None
        
        Sets the "Collate" checkbox to true or false.
        """

    def SetFromPage(self, page: int) -> None:
        """
        SetFromPage(page) -> None
        
        Sets the from page number.
        """

    def SetMaxPage(self, page: int) -> None:
        """
        SetMaxPage(page) -> None
        
        Sets the maximum page number.
        """

    def SetMinPage(self, page: int) -> None:
        """
        SetMinPage(page) -> None
        
        Sets the minimum page number.
        """

    def SetNoCopies(self, n: int) -> None:
        """
        SetNoCopies(n) -> None
        
        Sets the default number of copies the user has requested to be printed
        out.
        """

    def SetPrintData(self, printData: PrintData) -> None:
        """
        SetPrintData(printData) -> None
        
        Sets the internal wxPrintData.
        """

    def SetPrintToFile(self, flag: bool) -> None:
        """
        SetPrintToFile(flag) -> None
        
        Sets the "Print to file" checkbox to true or false.
        """

    def SetSelection(self, flag: bool) -> None:
        """
        SetSelection(flag) -> None
        
        Selects the "Selection" radio button.
        """

    def SetToPage(self, page: int) -> None:
        """
        SetToPage(page) -> None
        
        Sets the "print to" page number.
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """
    @property
    def AllPages(self) -> bool: ...
    @property
    def Collate(self) -> bool: ...
    @Collate.setter
    def Collate(self, value: bool, /) -> None: ...
    @property
    def FromPage(self) -> int: ...
    @FromPage.setter
    def FromPage(self, value: int, /) -> None: ...
    @property
    def MaxPage(self) -> int: ...
    @MaxPage.setter
    def MaxPage(self, value: int, /) -> None: ...
    @property
    def MinPage(self) -> int: ...
    @MinPage.setter
    def MinPage(self, value: int, /) -> None: ...
    @property
    def NoCopies(self) -> int: ...
    @NoCopies.setter
    def NoCopies(self, value: int, /) -> None: ...
    @property
    def PrintData(self) -> PrintData: ...
    @PrintData.setter
    def PrintData(self, value: PrintData, /) -> None: ...
    @property
    def PrintToFile(self) -> bool: ...
    @PrintToFile.setter
    def PrintToFile(self, value: bool, /) -> None: ...
    @property
    def Selection(self) -> bool: ...
    @Selection.setter
    def Selection(self, value: bool, /) -> None: ...
    @property
    def ToPage(self) -> int: ...
    @ToPage.setter
    def ToPage(self, value: int, /) -> None: ...
# end of class PrintDialogData

#-- end-cmndata --#
#-- begin-gdicmn --#

class _BitmapType(IntEnum):
    BITMAP_TYPE_INVALID = auto()
    BITMAP_TYPE_BMP = auto()
    BITMAP_TYPE_ICO = auto()
    BITMAP_TYPE_CUR = auto()
    BITMAP_TYPE_XBM = auto()
    BITMAP_TYPE_XBM_DATA = auto()
    BITMAP_TYPE_XPM = auto()
    BITMAP_TYPE_XPM_DATA = auto()
    BITMAP_TYPE_TIFF = auto()
    BITMAP_TYPE_TIF = auto()
    BITMAP_TYPE_GIF = auto()
    BITMAP_TYPE_PNG = auto()
    BITMAP_TYPE_JPEG = auto()
    BITMAP_TYPE_PNM = auto()
    BITMAP_TYPE_PCX = auto()
    BITMAP_TYPE_PICT = auto()
    BITMAP_TYPE_ICON = auto()
    BITMAP_TYPE_ANI = auto()
    BITMAP_TYPE_IFF = auto()
    BITMAP_TYPE_TGA = auto()
    BITMAP_TYPE_MACCURSOR = auto()
    BITMAP_TYPE_ANY = auto()
BitmapType: TypeAlias = Union[_BitmapType, int]
BITMAP_TYPE_INVALID = _BitmapType.BITMAP_TYPE_INVALID
BITMAP_TYPE_BMP = _BitmapType.BITMAP_TYPE_BMP
BITMAP_TYPE_ICO = _BitmapType.BITMAP_TYPE_ICO
BITMAP_TYPE_CUR = _BitmapType.BITMAP_TYPE_CUR
BITMAP_TYPE_XBM = _BitmapType.BITMAP_TYPE_XBM
BITMAP_TYPE_XBM_DATA = _BitmapType.BITMAP_TYPE_XBM_DATA
BITMAP_TYPE_XPM = _BitmapType.BITMAP_TYPE_XPM
BITMAP_TYPE_XPM_DATA = _BitmapType.BITMAP_TYPE_XPM_DATA
BITMAP_TYPE_TIFF = _BitmapType.BITMAP_TYPE_TIFF
BITMAP_TYPE_TIF = _BitmapType.BITMAP_TYPE_TIF
BITMAP_TYPE_GIF = _BitmapType.BITMAP_TYPE_GIF
BITMAP_TYPE_PNG = _BitmapType.BITMAP_TYPE_PNG
BITMAP_TYPE_JPEG = _BitmapType.BITMAP_TYPE_JPEG
BITMAP_TYPE_PNM = _BitmapType.BITMAP_TYPE_PNM
BITMAP_TYPE_PCX = _BitmapType.BITMAP_TYPE_PCX
BITMAP_TYPE_PICT = _BitmapType.BITMAP_TYPE_PICT
BITMAP_TYPE_ICON = _BitmapType.BITMAP_TYPE_ICON
BITMAP_TYPE_ANI = _BitmapType.BITMAP_TYPE_ANI
BITMAP_TYPE_IFF = _BitmapType.BITMAP_TYPE_IFF
BITMAP_TYPE_TGA = _BitmapType.BITMAP_TYPE_TGA
BITMAP_TYPE_MACCURSOR = _BitmapType.BITMAP_TYPE_MACCURSOR
BITMAP_TYPE_ANY = _BitmapType.BITMAP_TYPE_ANY

class _PolygonFillMode(IntEnum):
    ODDEVEN_RULE = auto()
    WINDING_RULE = auto()
PolygonFillMode: TypeAlias = Union[_PolygonFillMode, int]
ODDEVEN_RULE = _PolygonFillMode.ODDEVEN_RULE
WINDING_RULE = _PolygonFillMode.WINDING_RULE

class _StockCursor(IntEnum):
    CURSOR_NONE = auto()
    CURSOR_ARROW = auto()
    CURSOR_RIGHT_ARROW = auto()
    CURSOR_BULLSEYE = auto()
    CURSOR_CHAR = auto()
    CURSOR_CROSS = auto()
    CURSOR_HAND = auto()
    CURSOR_IBEAM = auto()
    CURSOR_LEFT_BUTTON = auto()
    CURSOR_MAGNIFIER = auto()
    CURSOR_MIDDLE_BUTTON = auto()
    CURSOR_NO_ENTRY = auto()
    CURSOR_PAINT_BRUSH = auto()
    CURSOR_PENCIL = auto()
    CURSOR_POINT_LEFT = auto()
    CURSOR_POINT_RIGHT = auto()
    CURSOR_QUESTION_ARROW = auto()
    CURSOR_RIGHT_BUTTON = auto()
    CURSOR_SIZENESW = auto()
    CURSOR_SIZENS = auto()
    CURSOR_SIZENWSE = auto()
    CURSOR_SIZEWE = auto()
    CURSOR_SIZING = auto()
    CURSOR_SPRAYCAN = auto()
    CURSOR_WAIT = auto()
    CURSOR_WATCH = auto()
    CURSOR_BLANK = auto()
    CURSOR_DEFAULT = auto()
    CURSOR_COPY_ARROW = auto()
    CURSOR_ARROWWAIT = auto()
    CURSOR_MAX = auto()
StockCursor: TypeAlias = Union[_StockCursor, int]
CURSOR_NONE = _StockCursor.CURSOR_NONE
CURSOR_ARROW = _StockCursor.CURSOR_ARROW
CURSOR_RIGHT_ARROW = _StockCursor.CURSOR_RIGHT_ARROW
CURSOR_BULLSEYE = _StockCursor.CURSOR_BULLSEYE
CURSOR_CHAR = _StockCursor.CURSOR_CHAR
CURSOR_CROSS = _StockCursor.CURSOR_CROSS
CURSOR_HAND = _StockCursor.CURSOR_HAND
CURSOR_IBEAM = _StockCursor.CURSOR_IBEAM
CURSOR_LEFT_BUTTON = _StockCursor.CURSOR_LEFT_BUTTON
CURSOR_MAGNIFIER = _StockCursor.CURSOR_MAGNIFIER
CURSOR_MIDDLE_BUTTON = _StockCursor.CURSOR_MIDDLE_BUTTON
CURSOR_NO_ENTRY = _StockCursor.CURSOR_NO_ENTRY
CURSOR_PAINT_BRUSH = _StockCursor.CURSOR_PAINT_BRUSH
CURSOR_PENCIL = _StockCursor.CURSOR_PENCIL
CURSOR_POINT_LEFT = _StockCursor.CURSOR_POINT_LEFT
CURSOR_POINT_RIGHT = _StockCursor.CURSOR_POINT_RIGHT
CURSOR_QUESTION_ARROW = _StockCursor.CURSOR_QUESTION_ARROW
CURSOR_RIGHT_BUTTON = _StockCursor.CURSOR_RIGHT_BUTTON
CURSOR_SIZENESW = _StockCursor.CURSOR_SIZENESW
CURSOR_SIZENS = _StockCursor.CURSOR_SIZENS
CURSOR_SIZENWSE = _StockCursor.CURSOR_SIZENWSE
CURSOR_SIZEWE = _StockCursor.CURSOR_SIZEWE
CURSOR_SIZING = _StockCursor.CURSOR_SIZING
CURSOR_SPRAYCAN = _StockCursor.CURSOR_SPRAYCAN
CURSOR_WAIT = _StockCursor.CURSOR_WAIT
CURSOR_WATCH = _StockCursor.CURSOR_WATCH
CURSOR_BLANK = _StockCursor.CURSOR_BLANK
CURSOR_DEFAULT = _StockCursor.CURSOR_DEFAULT
CURSOR_COPY_ARROW = _StockCursor.CURSOR_COPY_ARROW
CURSOR_ARROWWAIT = _StockCursor.CURSOR_ARROWWAIT
CURSOR_MAX = _StockCursor.CURSOR_MAX

class _EllipsizeFlags(IntFlag):
    ELLIPSIZE_FLAGS_NONE = auto()
    ELLIPSIZE_FLAGS_PROCESS_MNEMONICS = auto()
    ELLIPSIZE_FLAGS_EXPAND_TABS = auto()
    ELLIPSIZE_FLAGS_DEFAULT = auto()
EllipsizeFlags: TypeAlias = Union[_EllipsizeFlags, int]
ELLIPSIZE_FLAGS_NONE = _EllipsizeFlags.ELLIPSIZE_FLAGS_NONE
ELLIPSIZE_FLAGS_PROCESS_MNEMONICS = _EllipsizeFlags.ELLIPSIZE_FLAGS_PROCESS_MNEMONICS
ELLIPSIZE_FLAGS_EXPAND_TABS = _EllipsizeFlags.ELLIPSIZE_FLAGS_EXPAND_TABS
ELLIPSIZE_FLAGS_DEFAULT = _EllipsizeFlags.ELLIPSIZE_FLAGS_DEFAULT

class _EllipsizeMode(IntEnum):
    ELLIPSIZE_NONE = auto()
    ELLIPSIZE_START = auto()
    ELLIPSIZE_MIDDLE = auto()
    ELLIPSIZE_END = auto()
EllipsizeMode: TypeAlias = Union[_EllipsizeMode, int]
ELLIPSIZE_NONE = _EllipsizeMode.ELLIPSIZE_NONE
ELLIPSIZE_START = _EllipsizeMode.ELLIPSIZE_START
ELLIPSIZE_MIDDLE = _EllipsizeMode.ELLIPSIZE_MIDDLE
ELLIPSIZE_END = _EllipsizeMode.ELLIPSIZE_END

class Point:
    """
    Point() -> None
    Point(x, y) -> None
    Point(pt) -> None
    
    A wxPoint is a useful data structure for graphics operations.
    """

    @overload
    def __init__(self, x: int, y: int) -> None:
        ...

    @overload
    def __init__(self, pt: Union[RealPoint, _TwoFloats]) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Point() -> None
        Point(x, y) -> None
        Point(pt) -> None
        
        A wxPoint is a useful data structure for graphics operations.
        """

    @overload
    def __iadd__(self, pt: Union[Point, _TwoInts]) -> Point:
        ...

    @overload
    def __iadd__(self, sz: Union[Size, _TwoInts]) -> Point:
        """
        """

    @overload
    def __isub__(self, pt: Union[Point, _TwoInts]) -> Point:
        ...

    @overload
    def __isub__(self, sz: Union[Size, _TwoInts]) -> Point:
        """
        """

    def IsFullySpecified(self) -> bool:
        """
        IsFullySpecified() -> bool
        
        Returns true if neither of the point components is equal to
        wxDefaultCoord.
        """

    def SetDefaults(self, pt: Union[Point, _TwoInts]) -> None:
        """
        SetDefaults(pt) -> None
        
        Combine this object with another one replacing the uninitialized
        values.
        """
    x: int
    y: int

    def __eq__(self, other: Union[Point, _TwoInts]) -> bool:
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other: Union[Point, _TwoInts]) -> bool:
        """
        __ne__(other) -> bool
        """

    def Get(self) -> Any:
        """
        Get() -> (x,y)
        
        Return the x and y properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Point`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Point``
        with a simple statement like this: ``obj = wx.Point(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    IM = property(GetIM)
# end of class Point


class Size:
    """
    Size() -> None
    Size(width, height) -> None
    
    A wxSize is a useful data structure for graphics operations.
    """

    @overload
    def __init__(self, width: int, height: int) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Size() -> None
        Size(width, height) -> None
        
        A wxSize is a useful data structure for graphics operations.
        """

    @overload
    def DecBy(self, size: Union[Size, _TwoInts]) -> None:
        ...

    @overload
    def DecBy(self, dx: int, dy: int) -> None:
        ...

    @overload
    def DecBy(self, d: int) -> None:
        ...

    @overload
    def DecBy(self, pt: Union[Point, _TwoInts]) -> None:
        """
        DecBy(pt) -> None
        DecBy(size) -> None
        DecBy(dx, dy) -> None
        DecBy(d) -> None
        
        Decreases the size in both x and y directions.
        """

    @overload
    def IncBy(self, size: Union[Size, _TwoInts]) -> None:
        ...

    @overload
    def IncBy(self, dx: int, dy: int) -> None:
        ...

    @overload
    def IncBy(self, d: int) -> None:
        ...

    @overload
    def IncBy(self, pt: Union[Point, _TwoInts]) -> None:
        """
        IncBy(pt) -> None
        IncBy(size) -> None
        IncBy(dx, dy) -> None
        IncBy(d) -> None
        
        Increases the size in both x and y directions.
        """

    def __iadd__(self, sz: Union[Size, _TwoInts]) -> Size:
        """
        """

    def __isub__(self, sz: Union[Size, _TwoInts]) -> Size:
        """
        """

    def __idiv__(self, factor: int) -> Size:
        """
        """

    def __imul__(self, factor: int) -> Size:
        """
        """

    def DecTo(self, size: Union[Size, _TwoInts]) -> None:
        """
        DecTo(size) -> None
        
        Decrements this object so that both of its dimensions are not greater
        than the corresponding dimensions of the size.
        """

    def DecToIfSpecified(self, size: Union[Size, _TwoInts]) -> None:
        """
        DecToIfSpecified(size) -> None
        
        Decrements this object to be not bigger than the given size ignoring
        non-specified components.
        """

    def GetHeight(self) -> int:
        """
        GetHeight() -> int
        
        Gets the height member.
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Gets the width member.
        """

    def IncTo(self, size: Union[Size, _TwoInts]) -> None:
        """
        IncTo(size) -> None
        
        Increments this object so that both of its dimensions are not less
        than the corresponding dimensions of the size.
        """

    def IsFullySpecified(self) -> bool:
        """
        IsFullySpecified() -> bool
        
        Returns true if neither of the size object components is equal to -1,
        which is used as default for the size values in wxWidgets (hence the
        predefined wxDefaultSize has both of its components equal to -1).
        """

    def Scale(self, xscale: float, yscale: float) -> Size:
        """
        Scale(xscale, yscale) -> Size
        
        Scales the dimensions of this object by the given factors.
        """

    def Set(self, width: int, height: int) -> None:
        """
        Set(width, height) -> None
        
        Sets the width and height members.
        """

    def SetDefaults(self, sizeDefault: Union[Size, _TwoInts]) -> None:
        """
        SetDefaults(sizeDefault) -> None
        
        Combine this size object with another one replacing the default (i.e.
        equal to -1) components of this object with those of the other.
        """

    def SetHeight(self, height: int) -> None:
        """
        SetHeight(height) -> None
        
        Sets the height.
        """

    def SetWidth(self, width: int) -> None:
        """
        SetWidth(width) -> None
        
        Sets the width.
        """
    @property
    def Height(self) -> int: ...
    @Height.setter
    def Height(self, value: int, /) -> None: ...
    @property
    def Width(self) -> int: ...
    @Width.setter
    def Width(self, value: int, /) -> None: ...
    @property
    def width(self) -> int: ...
    @width.setter
    def width(self, value: int, /) -> None: ...
    @property
    def height(self) -> int: ...
    @height.setter
    def height(self, value: int, /) -> None: ...
    @property
    def x(self) -> int: ...
    @x.setter
    def x(self, value: int, /) -> None: ...
    @property
    def y(self) -> int: ...
    @y.setter
    def y(self, value: int, /) -> None: ...

    def __eq__(self, other: Union[Size, _TwoInts]) -> bool:
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other: Union[Size, _TwoInts]) -> bool:
        """
        __ne__(other) -> bool
        """

    def Get(self) -> Any:
        """
        Get() -> (width, height)
        
        Return the width and height properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Size`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Size``
        with a simple statement like this: ``obj = wx.Size(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
# end of class Size


class Rect:
    """
    Rect() -> None
    Rect(x, y, width, height) -> None
    Rect(pos, size) -> None
    Rect(size) -> None
    Rect(topLeft, bottomRight) -> None
    
    Represents a rectangle with integer coordinates.
    """

    @overload
    def __init__(self, x: int, y: int, width: int, height: int) -> None:
        ...

    @overload
    def __init__(self, pos: Union[Point, _TwoInts], size: Union[Size, _TwoInts]) -> None:
        ...

    @overload
    def __init__(self, size: Union[Size, _TwoInts]) -> None:
        ...

    @overload
    def __init__(self, topLeft: Union[Point, _TwoInts], bottomRight: Union[Point, _TwoInts]) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Rect() -> None
        Rect(x, y, width, height) -> None
        Rect(pos, size) -> None
        Rect(size) -> None
        Rect(topLeft, bottomRight) -> None
        
        Represents a rectangle with integer coordinates.
        """

    def CentreIn(self, r: Union[Rect, _FourInts], dir: int=BOTH) -> Rect:
        """
        CentreIn(r, dir=BOTH) -> Rect
        
        Returns the rectangle having the same size as this one but centered
        relatively to the given rectangle r.
        """

    def CenterIn(self, r: Union[Rect, _FourInts], dir: int=BOTH) -> Rect:
        """
        CenterIn(r, dir=BOTH) -> Rect
        
        Returns the rectangle having the same size as this one but centered
        relatively to the given rectangle r.
        """

    @overload
    def Deflate(self, diff: Union[Size, _TwoInts]) -> Rect:
        ...

    @overload
    def Deflate(self, diff: int) -> Rect:
        ...

    @overload
    def Deflate(self, dx: int, dy: int) -> Rect:
        """
        Deflate(dx, dy) -> Rect
        Deflate(diff) -> Rect
        Deflate(diff) -> Rect
        
        Decrease the rectangle size.
        """

    @overload
    def Inflate(self, diff: Union[Size, _TwoInts]) -> Rect:
        ...

    @overload
    def Inflate(self, diff: int) -> Rect:
        ...

    @overload
    def Inflate(self, dx: int, dy: int) -> Rect:
        """
        Inflate(dx, dy) -> Rect
        Inflate(diff) -> Rect
        Inflate(diff) -> Rect
        
        Increases the size of the rectangle.
        """

    @overload
    def Offset(self, pt: Union[Point, _TwoInts]) -> None:
        ...

    @overload
    def Offset(self, dx: int, dy: int) -> None:
        """
        Offset(dx, dy) -> None
        Offset(pt) -> None
        
        Moves the rectangle by the specified offset.
        """

    def Union(self, rect: Union[Rect, _FourInts]) -> Rect:
        """
        Union(rect) -> Rect
        
        Modifies the rectangle to contain the bounding box of this rectangle
        and the one passed in as parameter.
        """

    def __iadd__(self, r: Union[Rect, _FourInts]) -> Rect:
        """
        """

    def __imul__(self, r: Union[Rect, _FourInts]) -> Rect:
        """
        """
    height: int
    width: int
    x: int
    y: int

    @overload
    def Contains(self, pt: Union[Point, _TwoInts]) -> bool:
        ...

    @overload
    def Contains(self, rect: Union[Rect, _FourInts]) -> bool:
        ...

    @overload
    def Contains(self, x: int, y: int) -> bool:
        """
        Contains(x, y) -> bool
        Contains(pt) -> bool
        Contains(rect) -> bool
        
        Returns true if the given point is inside the rectangle (or on its
        boundary) and false otherwise.
        """

    def GetBottom(self) -> int:
        """
        GetBottom() -> int
        
        Gets the bottom point of the rectangle.
        """

    def GetBottomLeft(self) -> Point:
        """
        GetBottomLeft() -> Point
        
        Gets the position of the bottom left corner.
        """

    def GetBottomRight(self) -> Point:
        """
        GetBottomRight() -> Point
        
        Gets the position of the bottom right corner.
        """

    def GetHeight(self) -> int:
        """
        GetHeight() -> int
        
        Gets the height member.
        """

    def GetLeft(self) -> int:
        """
        GetLeft() -> int
        
        Gets the left point of the rectangle (the same as GetX()).
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Gets the position.
        """

    def GetRight(self) -> int:
        """
        GetRight() -> int
        
        Gets the right point of the rectangle.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Gets the size.
        """

    def GetTop(self) -> int:
        """
        GetTop() -> int
        
        Gets the top point of the rectangle (the same as GetY()).
        """

    def GetTopLeft(self) -> Point:
        """
        GetTopLeft() -> Point
        
        Gets the position of the top left corner of the rectangle, same as
        GetPosition().
        """

    def GetTopRight(self) -> Point:
        """
        GetTopRight() -> Point
        
        Gets the position of the top right corner.
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Gets the width member.
        """

    def GetX(self) -> int:
        """
        GetX() -> int
        
        Gets the x member.
        """

    def GetY(self) -> int:
        """
        GetY() -> int
        
        Gets the y member.
        """

    def Intersect(self, rect: Union[Rect, _FourInts]) -> Rect:
        """
        Intersect(rect) -> Rect
        
        Modifies this rectangle to contain the overlapping portion of this
        rectangle and the one passed in as parameter.
        """

    def Intersects(self, rect: Union[Rect, _FourInts]) -> bool:
        """
        Intersects(rect) -> bool
        
        Returns true if this rectangle has a non-empty intersection with the
        rectangle rect and false otherwise.
        """

    def IsEmpty(self) -> bool:
        """
        IsEmpty() -> bool
        
        Returns true if this rectangle has a width or height less than or
        equal to 0 and false otherwise.
        """

    def SetHeight(self, height: int) -> None:
        """
        SetHeight(height) -> None
        
        Sets the height.
        """

    def SetPosition(self, pos: Union[Point, _TwoInts]) -> None:
        """
        SetPosition(pos) -> None
        
        Sets the position.
        """

    def SetSize(self, s: Union[Size, _TwoInts]) -> None:
        """
        SetSize(s) -> None
        
        Sets the size.
        """

    def SetWidth(self, width: int) -> None:
        """
        SetWidth(width) -> None
        
        Sets the width.
        """

    def SetX(self, x: int) -> None:
        """
        SetX(x) -> None
        
        Sets the x position.
        """

    def SetY(self, y: int) -> None:
        """
        SetY(y) -> None
        
        Sets the y position.
        """

    def SetLeft(self, left: int) -> None:
        """
        SetLeft(left) -> None
        
        Set the left side of the rectangle.
        """

    def SetRight(self, right: int) -> None:
        """
        SetRight(right) -> None
        
        Set the right side of the rectangle.
        """

    def SetTop(self, top: int) -> None:
        """
        SetTop(top) -> None
        
        Set the top edge of the rectangle.
        """

    def SetBottom(self, bottom: int) -> None:
        """
        SetBottom(bottom) -> None
        
        Set the bottom edge of the rectangle.
        """

    def SetTopLeft(self, p: Union[Point, _TwoInts]) -> None:
        """
        SetTopLeft(p) -> None
        
        Set the top-left point of the rectangle.
        """

    def SetBottomRight(self, p: Union[Point, _TwoInts]) -> None:
        """
        SetBottomRight(p) -> None
        
        Set the bottom-right point of the rectangle.
        """

    def SetTopRight(self, p: Union[Point, _TwoInts]) -> None:
        """
        SetTopRight(p) -> None
        
        Set the top-right point of the rectangle.
        """

    def SetBottomLeft(self, p: Union[Point, _TwoInts]) -> None:
        """
        SetBottomLeft(p) -> None
        
        Set the bottom-left point of the rectangle.
        """
    @property
    def Bottom(self) -> int: ...
    @Bottom.setter
    def Bottom(self, value: int, /) -> None: ...
    @property
    def BottomLeft(self) -> Union[Point, _TwoInts]: ...
    @BottomLeft.setter
    def BottomLeft(self, value: Union[Point, _TwoInts], /) -> None: ...
    @property
    def BottomRight(self) -> Union[Point, _TwoInts]: ...
    @BottomRight.setter
    def BottomRight(self, value: Union[Point, _TwoInts], /) -> None: ...
    @property
    def Height(self) -> int: ...
    @Height.setter
    def Height(self, value: int, /) -> None: ...
    @property
    def Left(self) -> int: ...
    @Left.setter
    def Left(self, value: int, /) -> None: ...
    @property
    def Position(self) -> Union[Point, _TwoInts]: ...
    @Position.setter
    def Position(self, value: Union[Point, _TwoInts], /) -> None: ...
    @property
    def Right(self) -> int: ...
    @Right.setter
    def Right(self, value: int, /) -> None: ...
    @property
    def Size(self) -> Union[Size, _TwoInts]: ...
    @Size.setter
    def Size(self, value: Union[Size, _TwoInts], /) -> None: ...
    @property
    def Top(self) -> int: ...
    @Top.setter
    def Top(self, value: int, /) -> None: ...
    @property
    def TopLeft(self) -> Union[Point, _TwoInts]: ...
    @TopLeft.setter
    def TopLeft(self, value: Union[Point, _TwoInts], /) -> None: ...
    @property
    def TopRight(self) -> Union[Point, _TwoInts]: ...
    @TopRight.setter
    def TopRight(self, value: Union[Point, _TwoInts], /) -> None: ...
    @property
    def Width(self) -> int: ...
    @Width.setter
    def Width(self, value: int, /) -> None: ...
    @property
    def X(self) -> int: ...
    @X.setter
    def X(self, value: int, /) -> None: ...
    @property
    def Y(self) -> int: ...
    @Y.setter
    def Y(self, value: int, /) -> None: ...
    @property
    def left(self) -> int: ...
    @left.setter
    def left(self, value: int, /) -> None: ...
    @property
    def top(self) -> int: ...
    @top.setter
    def top(self, value: int, /) -> None: ...
    @property
    def right(self) -> int: ...
    @right.setter
    def right(self, value: int, /) -> None: ...
    @property
    def bottom(self) -> int: ...
    @bottom.setter
    def bottom(self, value: int, /) -> None: ...
    @property
    def bottomLeft(self) -> Union[Point, _TwoInts]: ...
    @bottomLeft.setter
    def bottomLeft(self, value: Union[Point, _TwoInts], /) -> None: ...
    @property
    def bottomRight(self) -> Union[Point, _TwoInts]: ...
    @bottomRight.setter
    def bottomRight(self, value: Union[Point, _TwoInts], /) -> None: ...
    @property
    def topLeft(self) -> Union[Point, _TwoInts]: ...
    @topLeft.setter
    def topLeft(self, value: Union[Point, _TwoInts], /) -> None: ...
    @property
    def topRight(self) -> Union[Point, _TwoInts]: ...
    @topRight.setter
    def topRight(self, value: Union[Point, _TwoInts], /) -> None: ...

    def __eq__(self, other: Union[Rect, _FourInts]) -> bool:
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other: Union[Rect, _FourInts]) -> bool:
        """
        __ne__(other) -> bool
        """

    def Get(self) -> Any:
        """
        Get() -> (x, y, width, height)
        
        Return the rectangle's properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Rect`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Rect``
        with a simple statement like this: ``obj = wx.Rect(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
# end of class Rect


class RealPoint:
    """
    RealPoint() -> None
    RealPoint(x, y) -> None
    RealPoint(pt) -> None
    
    A wxRealPoint is a useful data structure for graphics operations.
    """

    @overload
    def __init__(self, x: float, y: float) -> None:
        ...

    @overload
    def __init__(self, pt: Union[Point, _TwoInts]) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        RealPoint() -> None
        RealPoint(x, y) -> None
        RealPoint(pt) -> None
        
        A wxRealPoint is a useful data structure for graphics operations.
        """

    @overload
    def __iadd__(self, pt: Union[RealPoint, _TwoFloats]) -> RealPoint:
        ...

    @overload
    def __iadd__(self, sz: Union[Size, _TwoInts]) -> RealPoint:
        """
        """

    @overload
    def __isub__(self, pt: Union[RealPoint, _TwoFloats]) -> RealPoint:
        ...

    @overload
    def __isub__(self, sz: Union[Size, _TwoInts]) -> RealPoint:
        """
        """
    x: float
    y: float

    def __eq__(self, other: Union[RealPoint, _TwoFloats]) -> bool:
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other: Union[RealPoint, _TwoFloats]) -> bool:
        """
        __ne__(other) -> bool
        """

    def __mul__(self, d: float) -> RealPoint:
        """
        __mul__(d) -> RealPoint
        """

    def Get(self) -> Any:
        """
        Get() -> (x, y)
        
        Return the point's properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.RealPoint`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.RealPoint``
        with a simple statement like this: ``obj = wx.RealPoint(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    IM = property(GetIM)
# end of class RealPoint


class ColourDatabase:
    """
    ColourDatabase() -> None
    
    wxWidgets maintains a database of standard RGB colours for a
    predefined set of named colours.
    """

    def __init__(self) -> None:
        """
        ColourDatabase() -> None
        
        wxWidgets maintains a database of standard RGB colours for a
        predefined set of named colours.
        """

    def AddColour(self, colourName: str, colour: Colour) -> None:
        """
        AddColour(colourName, colour) -> None
        
        Adds a colour to the database.
        """

    def Find(self, colourName: str) -> Colour:
        """
        Find(colourName) -> Colour
        
        Finds a colour given the name.
        """

    def FindName(self, colour: Colour) -> str:
        """
        FindName(colour) -> str
        
        Finds a colour name given the colour.
        """

    def FindColour(self, colour):
        """
        
        """
# end of class ColourDatabase


def ColourDisplay() -> bool:    """
    ColourDisplay() -> bool
    
    Returns true if the display is colour, false otherwise.
    """

def DisplayDepth() -> int:    """
    DisplayDepth() -> int
    
    Returns the depth of the display (a value of 1 denotes a monochrome
    display).
    """

def SetCursor(cursor: Cursor) -> None:    """
    SetCursor(cursor) -> None
    
    Globally sets the cursor; only has an effect on Windows, Mac and GTK+.
    """

def ClientDisplayRect() -> Tuple[int, int, int, int]:    """
    ClientDisplayRect() -> Tuple[int, int, int, int]
    
    Returns the dimensions of the work area on the display.
    """

def GetClientDisplayRect() -> Rect:    """
    GetClientDisplayRect() -> Rect
    
    Returns the dimensions of the work area on the display.
    """

def GetDisplayPPI() -> Size:    """
    GetDisplayPPI() -> Size
    
    Returns the display resolution in pixels per inch.
    """

def DisplaySize() -> Tuple[int, int]:    """
    DisplaySize() -> Tuple[int, int]
    
    Returns the display size in pixels.
    """

def GetDisplaySize() -> Size:    """
    GetDisplaySize() -> Size
    
    Returns the display size in pixels.
    """

def DisplaySizeMM() -> Tuple[int, int]:    """
    DisplaySizeMM() -> Tuple[int, int]
    
    Returns the display size in millimeters.
    """

def GetDisplaySizeMM() -> Size:    """
    GetDisplaySizeMM() -> Size
    
    Returns the display size in millimeters.
    """
DefaultPosition: Point
DefaultSize: Size

from collections import namedtuple
_im_Point = namedtuple('_im_Point', ['x', 'y'])
del namedtuple

from collections import namedtuple
_im_Size = namedtuple('_im_Size', ['width', 'height'])
del namedtuple

from collections import namedtuple
_im_Rect = namedtuple('_im_Rect', ['x', 'y', 'width', 'height'])
del namedtuple

from collections import namedtuple
_im_RealPoint = namedtuple('_im_RealPoint', ['x', 'y'])
del namedtuple

def IntersectRect(self, r1: Union[Rect, _FourInts], r2: Union[Rect, _FourInts]) -> Any:
    """
    IntersectRect(r1, r2) -> Any
    
    Calculate and return the intersection of r1 and r2.  Returns None if
    there
    is no intersection.
    """
#-- end-gdicmn --#
#-- begin-geometry --#

class _OutCode(IntEnum):
    Inside = auto()
    OutLeft = auto()
    OutRight = auto()
    OutTop = auto()
    OutBottom = auto()
OutCode: TypeAlias = Union[_OutCode, int]
Inside = _OutCode.Inside
OutLeft = _OutCode.OutLeft
OutRight = _OutCode.OutRight
OutTop = _OutCode.OutTop
OutBottom = _OutCode.OutBottom

class Point2D:
    """
    Point2DDouble() -> None
    Point2DDouble(x, y) -> None
    Point2DDouble(pt) -> None
    Point2DDouble(pt) -> None
    """

    @overload
    def __init__(self, x: float, y: float) -> None:
        ...

    @overload
    def __init__(self, pt: Point2DDouble) -> None:
        ...

    @overload
    def __init__(self, pt: Point) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Point2DDouble() -> None
        Point2DDouble(x, y) -> None
        Point2DDouble(pt) -> None
        Point2DDouble(pt) -> None
        """
    m_x: float
    m_y: float

    def GetFloor(self) -> Tuple[int, int]:
        """
        GetFloor() -> Tuple[int, int]
        """

    def GetRounded(self) -> Tuple[int, int]:
        """
        GetRounded() -> Tuple[int, int]
        """

    def GetVectorLength(self) -> float:
        """
        GetVectorLength() -> float
        """

    def GetVectorAngle(self) -> float:
        """
        GetVectorAngle() -> float
        """

    def SetVectorLength(self, length: float) -> None:
        """
        SetVectorLength(length) -> None
        """

    def SetVectorAngle(self, degrees: float) -> None:
        """
        SetVectorAngle(degrees) -> None
        """

    def Normalize(self) -> None:
        """
        Normalize() -> None
        """

    def GetDistance(self, pt: Point2DDouble) -> float:
        """
        GetDistance(pt) -> float
        """

    def GetDistanceSquare(self, pt: Point2DDouble) -> float:
        """
        GetDistanceSquare(pt) -> float
        """

    def GetDotProduct(self, vec: Point2DDouble) -> float:
        """
        GetDotProduct(vec) -> float
        """

    def GetCrossProduct(self, vec: Point2DDouble) -> float:
        """
        GetCrossProduct(vec) -> float
        """

    def __sub__(self) -> Point2DDouble:
        """
        """

    def __iadd__(self, pt: Point2DDouble) -> Point2DDouble:
        """
        """

    def __isub__(self, pt: Point2DDouble) -> Point2DDouble:
        """
        """

    def __imul__(self, pt: Point2DDouble) -> Point2DDouble:
        """
        """

    def __idiv__(self, pt: Point2DDouble) -> Point2DDouble:
        """
        """

    def __eq__(self, pt: Point2DDouble) -> bool:
        """
        """

    def __ne__(self, pt: Point2DDouble) -> bool:
        """
        """

    def Get(self) -> Any:
        """
        Get() -> Any
        
        Get() -> (x,y)
        
        Return the x and y properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Point2D`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Point2D``
        with a simple statement like this: ``obj = wx.Point2D(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    IM = property(GetIM)
    @property
    def VectorAngle(self) -> float: ...
    @VectorAngle.setter
    def VectorAngle(self, value: float, /) -> None: ...
    @property
    def VectorLength(self) -> float: ...
    @VectorLength.setter
    def VectorLength(self, value: float, /) -> None: ...
# end of class Point2D


class Rect2D:
    """
    Rect2DDouble() -> None
    Rect2DDouble(x, y, w, h) -> None
    """

    @overload
    def __init__(self, x: float, y: float, w: float, h: float) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Rect2DDouble() -> None
        Rect2DDouble(x, y, w, h) -> None
        """
    m_x: float
    m_y: float
    m_width: float
    m_height: float

    def GetPosition(self) -> Point2DDouble:
        """
        GetPosition() -> Point2DDouble
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        """

    def GetLeft(self) -> float:
        """
        GetLeft() -> float
        """

    def SetLeft(self, n: float) -> None:
        """
        SetLeft(n) -> None
        """

    def MoveLeftTo(self, n: float) -> None:
        """
        MoveLeftTo(n) -> None
        """

    def GetTop(self) -> float:
        """
        GetTop() -> float
        """

    def SetTop(self, n: float) -> None:
        """
        SetTop(n) -> None
        """

    def MoveTopTo(self, n: float) -> None:
        """
        MoveTopTo(n) -> None
        """

    def GetBottom(self) -> float:
        """
        GetBottom() -> float
        """

    def SetBottom(self, n: float) -> None:
        """
        SetBottom(n) -> None
        """

    def MoveBottomTo(self, n: float) -> None:
        """
        MoveBottomTo(n) -> None
        """

    def GetRight(self) -> float:
        """
        GetRight() -> float
        """

    def SetRight(self, n: float) -> None:
        """
        SetRight(n) -> None
        """

    def MoveRightTo(self, n: float) -> None:
        """
        MoveRightTo(n) -> None
        """

    def GetLeftTop(self) -> Point2DDouble:
        """
        GetLeftTop() -> Point2DDouble
        """

    def SetLeftTop(self, pt: Point2DDouble) -> None:
        """
        SetLeftTop(pt) -> None
        """

    def MoveLeftTopTo(self, pt: Point2DDouble) -> None:
        """
        MoveLeftTopTo(pt) -> None
        """

    def GetLeftBottom(self) -> Point2DDouble:
        """
        GetLeftBottom() -> Point2DDouble
        """

    def SetLeftBottom(self, pt: Point2DDouble) -> None:
        """
        SetLeftBottom(pt) -> None
        """

    def MoveLeftBottomTo(self, pt: Point2DDouble) -> None:
        """
        MoveLeftBottomTo(pt) -> None
        """

    def GetRightTop(self) -> Point2DDouble:
        """
        GetRightTop() -> Point2DDouble
        """

    def SetRightTop(self, pt: Point2DDouble) -> None:
        """
        SetRightTop(pt) -> None
        """

    def MoveRightTopTo(self, pt: Point2DDouble) -> None:
        """
        MoveRightTopTo(pt) -> None
        """

    def GetRightBottom(self) -> Point2DDouble:
        """
        GetRightBottom() -> Point2DDouble
        """

    def SetRightBottom(self, pt: Point2DDouble) -> None:
        """
        SetRightBottom(pt) -> None
        """

    def MoveRightBottomTo(self, pt: Point2DDouble) -> None:
        """
        MoveRightBottomTo(pt) -> None
        """

    def GetCentre(self) -> Point2DDouble:
        """
        GetCentre() -> Point2DDouble
        """

    def SetCentre(self, pt: Point2DDouble) -> None:
        """
        SetCentre(pt) -> None
        """

    def MoveCentreTo(self, pt: Point2DDouble) -> None:
        """
        MoveCentreTo(pt) -> None
        """

    def GetOutCode(self, pt: Point2DDouble) -> OutCode:
        """
        GetOutCode(pt) -> OutCode
        """

    def GetOutcode(self, pt: Point2DDouble) -> OutCode:
        """
        GetOutcode(pt) -> OutCode
        """

    @overload
    def Contains(self, rect: Rect2DDouble) -> bool:
        ...

    @overload
    def Contains(self, pt: Point2DDouble) -> bool:
        """
        Contains(pt) -> bool
        Contains(rect) -> bool
        """

    def IsEmpty(self) -> bool:
        """
        IsEmpty() -> bool
        """

    def HaveEqualSize(self, rect: Rect2DDouble) -> bool:
        """
        HaveEqualSize(rect) -> bool
        """

    @overload
    def Inset(self, left: float, top: float, right: float, bottom: float) -> None:
        ...

    @overload
    def Inset(self, x: float, y: float) -> None:
        """
        Inset(x, y) -> None
        Inset(left, top, right, bottom) -> None
        """

    def Offset(self, pt: Point2DDouble) -> None:
        """
        Offset(pt) -> None
        """

    def ConstrainTo(self, rect: Rect2DDouble) -> None:
        """
        ConstrainTo(rect) -> None
        """

    def Interpolate(self, widthfactor: int, heightfactor: int) -> Point2DDouble:
        """
        Interpolate(widthfactor, heightfactor) -> Point2DDouble
        """

    @overload
    @staticmethod
    def Intersect(src1: Rect2DDouble, src2: Rect2DDouble, dest: Rect2DDouble) -> None:
        ...

    @overload
    def Intersect(self, otherRect: Rect2DDouble) -> None:
        """
        Intersect(otherRect) -> None
        Intersect(src1, src2, dest) -> None
        """

    def CreateIntersection(self, otherRect: Rect2DDouble) -> Rect2DDouble:
        """
        CreateIntersection(otherRect) -> Rect2DDouble
        """

    def Intersects(self, rect: Rect2DDouble) -> bool:
        """
        Intersects(rect) -> bool
        """

    @overload
    def Union(self, pt: Point2DDouble) -> None:
        ...

    @overload
    @staticmethod
    def Union(src1: Rect2DDouble, src2: Rect2DDouble, dest: Rect2DDouble) -> None:
        ...

    @overload
    def Union(self, otherRect: Rect2DDouble) -> None:
        """
        Union(otherRect) -> None
        Union(pt) -> None
        Union(src1, src2, dest) -> None
        """

    def CreateUnion(self, otherRect: Rect2DDouble) -> Rect2DDouble:
        """
        CreateUnion(otherRect) -> Rect2DDouble
        """

    @overload
    def Scale(self, num: int, denum: int) -> None:
        ...

    @overload
    def Scale(self, f: float) -> None:
        """
        Scale(f) -> None
        Scale(num, denum) -> None
        """

    def __eq__(self, rect: Rect2DDouble) -> bool:
        """
        """

    def __ne__(self, rect: Rect2DDouble) -> bool:
        """
        """

    def Get(self) -> Any:
        """
        Get() -> Any
        
        Get() -> (x, y, width, height)
        
        Return the rectangle's properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Rect2D`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Rect2D``
        with a simple statement like this: ``obj = wx.Rect2D(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    @property
    def Bottom(self) -> float: ...
    @Bottom.setter
    def Bottom(self, value: float, /) -> None: ...
    @property
    def Centre(self) -> Point2DDouble: ...
    @Centre.setter
    def Centre(self, value: Point2DDouble, /) -> None: ...
    IM = property(GetIM)
    @property
    def Left(self) -> float: ...
    @Left.setter
    def Left(self, value: float, /) -> None: ...
    @property
    def LeftBottom(self) -> Point2DDouble: ...
    @LeftBottom.setter
    def LeftBottom(self, value: Point2DDouble, /) -> None: ...
    @property
    def LeftTop(self) -> Point2DDouble: ...
    @LeftTop.setter
    def LeftTop(self, value: Point2DDouble, /) -> None: ...
    @property
    def Position(self) -> Point2DDouble: ...
    @property
    def Right(self) -> float: ...
    @Right.setter
    def Right(self, value: float, /) -> None: ...
    @property
    def RightBottom(self) -> Point2DDouble: ...
    @RightBottom.setter
    def RightBottom(self, value: Point2DDouble, /) -> None: ...
    @property
    def RightTop(self) -> Point2DDouble: ...
    @RightTop.setter
    def RightTop(self, value: Point2DDouble, /) -> None: ...
    @property
    def Size(self) -> Size: ...
    @property
    def Top(self) -> float: ...
    @Top.setter
    def Top(self, value: float, /) -> None: ...
# end of class Rect2D


from collections import namedtuple
_im_Point2D = namedtuple('_im_Point2D', ['x', 'y'])
del namedtuple

from collections import namedtuple
_im_Rect2D = namedtuple('_im_Rect2D', ['x', 'y', 'width', 'height'])
del namedtuple
#-- end-geometry --#
#-- begin-affinematrix2d --#

class Matrix2D:
    """
    Matrix2D(v11=1, v12=0, v21=0, v22=1) -> None
    
    A simple container for 2x2 matrix.
    """

    def __init__(self, v11: float=1, v12: float=0, v21: float=0, v22: float=1) -> None:
        """
        Matrix2D(v11=1, v12=0, v21=0, v22=1) -> None
        
        A simple container for 2x2 matrix.
        """
    m_11: float
    m_12: float
    m_21: float
    m_22: float
# end of class Matrix2D


class AffineMatrix2DBase:
    """
    AffineMatrix2DBase() -> None
    
    A 2x3 matrix representing an affine 2D transformation.
    """

    def __init__(self) -> None:
        """
        AffineMatrix2DBase() -> None
        
        A 2x3 matrix representing an affine 2D transformation.
        """

    def IsEqual(self, t: AffineMatrix2DBase) -> bool:
        """
        IsEqual(t) -> bool
        
        Check that this matrix is identical with t.
        """

    def __eq__(self, t: AffineMatrix2DBase) -> bool:
        """
        """

    def Set(self, mat2D: Matrix2D, tr: Point2DDouble) -> None:
        """
        Set(mat2D, tr) -> None
        
        Set all elements of this matrix.
        """

    def Get(self) -> Tuple[Matrix2D, Point2DDouble]:
        """
        Get() -> Tuple[Matrix2D, Point2DDouble]
        
        Get the component values of the matrix.
        """

    def Concat(self, t: AffineMatrix2DBase) -> None:
        """
        Concat(t) -> None
        
        Concatenate this matrix with another one.
        """

    def Invert(self) -> bool:
        """
        Invert() -> bool
        
        Invert this matrix.
        """

    def IsIdentity(self) -> bool:
        """
        IsIdentity() -> bool
        
        Check if this is the identity matrix.
        """

    def __ne__(self, t: AffineMatrix2DBase) -> bool:
        """
        """

    def Translate(self, dx: float, dy: float) -> None:
        """
        Translate(dx, dy) -> None
        
        Add the translation to this matrix.
        """

    def Scale(self, xScale: float, yScale: float) -> None:
        """
        Scale(xScale, yScale) -> None
        
        Add scaling to this matrix.
        """

    def Rotate(self, cRadians: float) -> None:
        """
        Rotate(cRadians) -> None
        
        Add clockwise rotation to this matrix.
        """

    def Mirror(self, direction: int=HORIZONTAL) -> None:
        """
        Mirror(direction=HORIZONTAL) -> None
        
        Add mirroring to this matrix.
        """

    @overload
    def TransformPoint(self, x: float, y: float) -> Tuple[float, float]:
        ...

    @overload
    def TransformPoint(self, p: Point2DDouble) -> Point2DDouble:
        """
        TransformPoint(p) -> Point2DDouble
        TransformPoint(x, y) -> Tuple[float, float]
        
        Applies this matrix to the point.
        """

    @overload
    def TransformDistance(self, dx: float, dy: float) -> Tuple[float, float]:
        ...

    @overload
    def TransformDistance(self, p: Point2DDouble) -> Point2DDouble:
        """
        TransformDistance(p) -> Point2DDouble
        TransformDistance(dx, dy) -> Tuple[float, float]
        
        Applies the linear part of this matrix, i.e. without translation.
        """
# end of class AffineMatrix2DBase


class AffineMatrix2D(AffineMatrix2DBase):
    """
    AffineMatrix2D() -> None
    
    A 3x2 matrix representing an affine 2D transformation.
    """

    def __init__(self) -> None:
        """
        AffineMatrix2D() -> None
        
        A 3x2 matrix representing an affine 2D transformation.
        """

    def IsEqual(self, t: AffineMatrix2DBase) -> None:
        """
        IsEqual(t) -> None
        
        Check that this matrix is identical with t.
        """

    def __eq__(self, t: AffineMatrix2DBase) -> bool:
        """
        """

    def Get(self) -> Tuple[Matrix2D, Point2DDouble]:
        """
        Get() -> Tuple[Matrix2D, Point2DDouble]
        
        Get the component values of the matrix.
        """

    def Set(self, mat2D: Matrix2D, tr: Point2DDouble) -> None:
        """
        Set(mat2D, tr) -> None
        
        Set all elements of this matrix.
        """

    def Concat(self, t: AffineMatrix2DBase) -> None:
        """
        Concat(t) -> None
        
        Concatenate this matrix with another one.
        """

    def Invert(self) -> bool:
        """
        Invert() -> bool
        
        Invert this matrix.
        """

    def IsIdentity(self) -> bool:
        """
        IsIdentity() -> bool
        
        Check if this is the identity matrix.
        """

    def __ne__(self, t: AffineMatrix2DBase) -> bool:
        """
        """

    def Translate(self, dx: float, dy: float) -> None:
        """
        Translate(dx, dy) -> None
        
        Add the translation to this matrix.
        """

    def Scale(self, xScale: float, yScale: float) -> None:
        """
        Scale(xScale, yScale) -> None
        
        Add scaling to this matrix.
        """

    def Mirror(self, direction: int=HORIZONTAL) -> None:
        """
        Mirror(direction=HORIZONTAL) -> None
        
        Add mirroring to this matrix.
        """

    def Rotate(self, cRadians: float) -> None:
        """
        Rotate(cRadians) -> None
        
        Add clockwise rotation to this matrix.
        """

    @overload
    def TransformPoint(self, x: float, y: float) -> Tuple[float, float]:
        ...

    @overload
    def TransformPoint(self, p: Point2DDouble) -> Point2DDouble:
        """
        TransformPoint(p) -> Point2DDouble
        TransformPoint(x, y) -> Tuple[float, float]
        
        Applies this matrix to the point.
        """

    @overload
    def TransformDistance(self, dx: float, dy: float) -> Tuple[float, float]:
        ...

    @overload
    def TransformDistance(self, p: Point2DDouble) -> Point2DDouble:
        """
        TransformDistance(p) -> Point2DDouble
        TransformDistance(dx, dy) -> Tuple[float, float]
        
        Applies the linear part of this matrix, i.e. without translation.
        """
# end of class AffineMatrix2D

#-- end-affinematrix2d --#
#-- begin-position --#

class Position:
    """
    Position() -> None
    Position(row, col) -> None
    
    This class represents the position of an item in any kind of grid of
    rows and columns such as wxGridBagSizer, or wxHVScrolledWindow.
    """

    @overload
    def __init__(self, row: int, col: int) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Position() -> None
        Position(row, col) -> None
        
        This class represents the position of an item in any kind of grid of
        rows and columns such as wxGridBagSizer, or wxHVScrolledWindow.
        """

    def __eq__(self, pos: Union[Position, _TwoInts]) -> bool:
        """
        """

    def __ne__(self, pos: Union[Position, _TwoInts]) -> bool:
        """
        """

    @overload
    def __iadd__(self, size: Size) -> Position:
        ...

    @overload
    def __iadd__(self, pos: Union[Position, _TwoInts]) -> Position:
        """
        """

    @overload
    def __isub__(self, size: Size) -> Position:
        ...

    @overload
    def __isub__(self, pos: Union[Position, _TwoInts]) -> Position:
        """
        """

    @overload
    def __add__(self, size: Size) -> Position:
        ...

    @overload
    def __add__(self, pos: Union[Position, _TwoInts]) -> Position:
        """
        """

    @overload
    def __sub__(self, size: Size) -> Position:
        ...

    @overload
    def __sub__(self, pos: Union[Position, _TwoInts]) -> Position:
        """
        """

    def GetCol(self) -> int:
        """
        GetCol() -> int
        
        A synonym for GetColumn().
        """

    def GetColumn(self) -> int:
        """
        GetColumn() -> int
        
        Get the current row value.
        """

    def GetRow(self) -> int:
        """
        GetRow() -> int
        
        Get the current row value.
        """

    def SetCol(self, column: int) -> None:
        """
        SetCol(column) -> None
        
        A synonym for SetColumn().
        """

    def SetColumn(self, column: int) -> None:
        """
        SetColumn(column) -> None
        
        Set a new column value.
        """

    def SetRow(self, row: int) -> None:
        """
        SetRow(row) -> None
        
        Set a new row value.
        """

    def Get(self) -> Any:
        """
        Get() -> (row,col)
        
        Return the row and col properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Position`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Position``
        with a simple statement like this: ``obj = wx.Position(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    @property
    def Col(self) -> int: ...
    @Col.setter
    def Col(self, value: int, /) -> None: ...
    @property
    def Column(self) -> int: ...
    @Column.setter
    def Column(self, value: int, /) -> None: ...
    IM = property(GetIM)
    @property
    def Row(self) -> int: ...
    @Row.setter
    def Row(self, value: int, /) -> None: ...
# end of class Position


from collections import namedtuple
_im_Position = namedtuple('_im_Position', ['Row', 'Col'])
del namedtuple
#-- end-position --#
#-- begin-colour --#

class _enum_(IntEnum):
    C2S_NAME = auto()
    C2S_CSS_SYNTAX = auto()
    C2S_HTML_SYNTAX = auto()
C2S_NAME = _enum_.C2S_NAME
C2S_CSS_SYNTAX = _enum_.C2S_CSS_SYNTAX
C2S_HTML_SYNTAX = _enum_.C2S_HTML_SYNTAX
ALPHA_TRANSPARENT: int
ALPHA_OPAQUE: int

class Colour(Object):
    """
    Colour() -> None
    Colour(red, green, blue, alpha=ALPHA_OPAQUE) -> None
    Colour(colRGB) -> None
    Colour(colour) -> None
    
    A colour is an object representing a combination of Red, Green, and
    Blue (RGB) intensity values and an Alpha value, and is used to
    determine drawing colours.
    """

    @overload
    def __init__(self, red: int, green: int, blue: int, alpha: int=ALPHA_OPAQUE) -> None:
        ...

    @overload
    def __init__(self, colRGB: int) -> None:
        ...

    @overload
    def __init__(self, colour: Union[Colour, wx.Colour, _ThreeInts, _FourInts, str, _None]) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Colour() -> None
        Colour(red, green, blue, alpha=ALPHA_OPAQUE) -> None
        Colour(colRGB) -> None
        Colour(colour) -> None
        
        A colour is an object representing a combination of Red, Green, and
        Blue (RGB) intensity values and an Alpha value, and is used to
        determine drawing colours.
        """

    def SetRGB(self, colRGB: Uint32) -> None:
        """
        SetRGB(colRGB) -> None
        
        Sets the RGB or RGBA colour values from a single 32 bit value.
        """

    def SetRGBA(self, colRGBA: Uint32) -> None:
        """
        SetRGBA(colRGBA) -> None
        
        Sets the RGB or RGBA colour values from a single 32 bit value.
        """

    def GetRGB(self) -> Uint32:
        """
        GetRGB() -> Uint32
        
        Gets the RGB or RGBA colour values as a single 32 bit value.
        """

    def GetRGBA(self) -> Uint32:
        """
        GetRGBA() -> Uint32
        
        Gets the RGB or RGBA colour values as a single 32 bit value.
        """

    @overload
    def Set(self, RGB: int) -> None:
        ...

    @overload
    def Set(self, str: str) -> bool:
        ...

    @overload
    def Set(self, red: int, green: int, blue: int, alpha: int=ALPHA_OPAQUE) -> None:
        """
        Set(red, green, blue, alpha=ALPHA_OPAQUE) -> None
        Set(RGB) -> None
        Set(str) -> bool
        
        Sets the RGB intensity values using the given values (first overload), extracting them from the packed long (second overload), using the given string (third overload).
        """

    def Alpha(self) -> int:
        """
        Alpha() -> int
        
        Returns the alpha value, on platforms where alpha is not yet
        supported, this always returns wxALPHA_OPAQUE.
        """

    def Blue(self) -> int:
        """
        Blue() -> int
        
        Returns the blue intensity.
        """

    def GetAlpha(self) -> int:
        """
        GetAlpha() -> int
        
        Returns the alpha value, on platforms where alpha is not yet
        supported, this always returns wxALPHA_OPAQUE.
        """

    def GetBlue(self) -> int:
        """
        GetBlue() -> int
        
        Returns the blue intensity as unsigned int.
        """

    def GetGreen(self) -> int:
        """
        GetGreen() -> int
        
        Returns the green intensity as unsigned int.
        """

    def GetRed(self) -> int:
        """
        GetRed() -> int
        
        Returns the red intensity as unsigned int.
        """

    def GetAsString(self, flags: int=C2S_NAME|C2S_CSS_SYNTAX) -> str:
        """
        GetAsString(flags=C2S_NAME|C2S_CSS_SYNTAX) -> str
        
        Converts this colour to a wxString using the given flags.
        """

    def GetLuminance(self) -> float:
        """
        GetLuminance() -> float
        
        Return the perceived brightness of the colour.
        """

    def GetPixel(self) -> IntPtr:
        """
        GetPixel() -> IntPtr
        """

    def Green(self) -> int:
        """
        Green() -> int
        
        Returns the green intensity.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the colour object is valid (the colour has been
        initialised with RGB values).
        """

    def Red(self) -> int:
        """
        Red() -> int
        
        Returns the red intensity.
        """

    def IsSolid(self) -> bool:
        """
        IsSolid() -> bool
        
        Returns true if the color can be described using RGB values, i.e.
        """

    def __ne__(self, colour: Union[Colour, wx.Colour, _ThreeInts, _FourInts, str, _None]) -> bool:
        """
        """

    def __eq__(self, colour: Union[Colour, wx.Colour, _ThreeInts, _FourInts, str, _None]) -> bool:
        """
        """

    @overload
    @staticmethod
    def MakeDisabled(r: int, g: int, b: int, brightness: int=255) -> Tuple[int, int, int]:
        ...

    @overload
    def MakeDisabled(self, brightness: int=255) -> Colour:
        """
        MakeDisabled(brightness=255) -> Colour
        MakeDisabled(r, g, b, brightness=255) -> Tuple[int, int, int]
        
        Make a disabled version of this colour.
        """

    @overload
    @staticmethod
    def ChangeLightness(r: int, g: int, b: int, ialpha: int) -> Tuple[int, int, int]:
        ...

    @overload
    def ChangeLightness(self, ialpha: int) -> Colour:
        """
        ChangeLightness(ialpha) -> Colour
        ChangeLightness(r, g, b, ialpha) -> Tuple[int, int, int]
        
        wxColour wrapper for ChangeLightness(r,g,b,ialpha).
        """

    @staticmethod
    def MakeMono(on: bool) -> Tuple[int, int, int]:
        """
        MakeMono(on) -> Tuple[int, int, int]
        
        Assigns the same value to r, g, b: 0 if on is false, 255 otherwise.
        """

    @overload
    @staticmethod
    def MakeGrey(r: int, g: int, b: int, weight_r: float, weight_g: float, weight_b: float) -> Tuple[int, int, int]:
        ...

    @overload
    @staticmethod
    def MakeGrey(r: int, g: int, b: int) -> Tuple[int, int, int]:
        """
        MakeGrey(r, g, b) -> Tuple[int, int, int]
        MakeGrey(r, g, b, weight_r, weight_g, weight_b) -> Tuple[int, int, int]
        
        Create a grey colour from (in/out) rgb parameters using integer
        arithmetic.
        """

    @staticmethod
    def AlphaBlend(fg: int, bg: int, alpha: float) -> int:
        """
        AlphaBlend(fg, bg, alpha) -> int
        
        Blend colour, taking alpha into account.
        """
    @property
    def Pixel(self) -> IntPtr: ...
    @property
    def RGB(self) -> Uint32: ...
    @RGB.setter
    def RGB(self, value: Uint32, /) -> None: ...
    @property
    def RGBA(self) -> Uint32: ...
    @RGBA.setter
    def RGBA(self, value: Uint32, /) -> None: ...
    @property
    def red(self) -> int: ...
    @property
    def green(self) -> int: ...
    @property
    def blue(self) -> int: ...
    @property
    def alpha(self) -> int: ...

    def _copyFrom(self, other: Union[Colour, wx.Colour, _ThreeInts, _FourInts, str, _None]) -> None:
        """
        _copyFrom(other) -> None
        
        For internal use only.
        """

    def Get(self, includeAlpha: bool=True) -> Any:
        """
        Get(includeAlpha=True) -> (r,g,b) or (r,g,b,a)
        
        Returns the RGB intensity values as a tuple, optionally the alpha
        value as well.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Colour`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Colour``
        with a simple statement like this: ``obj = wx.Colour(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """
# end of class Colour

NullColour: Colour
TransparentColour: Colour

def MacThemeColour(self, themeBrushID: int) -> Colour:
    """
    MacThemeColour(themeBrushID) -> Colour
    """

# These stock colours will be initialized when the wx.App object is created.
BLACK = Colour()
BLUE = Colour()
CYAN = Colour()
GREEN = Colour()
YELLOW = Colour()
LIGHT_GREY = Colour()
RED = Colour()
WHITE = Colour()

from collections import namedtuple
_im_Colour = namedtuple('_im_Colour', ['red', 'green', 'blue', 'alpha'])
del namedtuple

NamedColour = wx.deprecated(Colour, "Use Colour instead.")
#-- end-colour --#
#-- begin-stream --#

class _StreamError(IntEnum):
    STREAM_NO_ERROR = auto()
    STREAM_EOF = auto()
    STREAM_WRITE_ERROR = auto()
    STREAM_READ_ERROR = auto()
StreamError: TypeAlias = Union[_StreamError, int]
STREAM_NO_ERROR = _StreamError.STREAM_NO_ERROR
STREAM_EOF = _StreamError.STREAM_EOF
STREAM_WRITE_ERROR = _StreamError.STREAM_WRITE_ERROR
STREAM_READ_ERROR = _StreamError.STREAM_READ_ERROR

class _SeekMode(IntEnum):
    FromStart = auto()
    FromCurrent = auto()
    FromEnd = auto()
SeekMode: TypeAlias = Union[_SeekMode, int]
FromStart = _SeekMode.FromStart
FromCurrent = _SeekMode.FromCurrent
FromEnd = _SeekMode.FromEnd

class StreamBase:
    """
    StreamBase() -> None
    
    This class is the base class of most stream related classes in
    wxWidgets.
    """

    def __init__(self) -> None:
        """
        StreamBase() -> None
        
        This class is the base class of most stream related classes in
        wxWidgets.
        """

    def GetLastError(self) -> StreamError:
        """
        GetLastError() -> StreamError
        
        This function returns the last error.
        """

    def GetLength(self) -> FileOffset:
        """
        GetLength() -> FileOffset
        
        Returns the length of the stream in bytes.
        """

    def GetSize(self) -> int:
        """
        GetSize() -> int
        
        This function returns the size of the stream.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if no error occurred on the stream.
        """

    def IsSeekable(self) -> bool:
        """
        IsSeekable() -> bool
        
        Returns true if the stream supports seeking to arbitrary offsets.
        """

    def Reset(self, error: StreamError=STREAM_NO_ERROR) -> None:
        """
        Reset(error=STREAM_NO_ERROR) -> None
        
        Resets the stream state.
        """
    @property
    def LastError(self) -> StreamError: ...
    @property
    def Length(self) -> FileOffset: ...
    @property
    def Size(self) -> int: ...
# end of class StreamBase


class InputStream(StreamBase):
    """
    InputStream() -> None
    
    wxInputStream is an abstract base class which may not be used
    directly.
    """

    def __init__(self) -> None:
        """
        InputStream() -> None
        
        wxInputStream is an abstract base class which may not be used
        directly.
        """

    def CanRead(self) -> bool:
        """
        CanRead() -> bool
        
        Returns true if some data is available in the stream right now, so
        that calling Read() wouldn't block.
        """

    def Eof(self) -> bool:
        """
        Eof() -> bool
        
        Returns true after an attempt has been made to read past the end of
        the stream.
        """

    def GetC(self) -> int:
        """
        GetC() -> int
        
        Returns the first character in the input queue and removes it,
        blocking until it appears if necessary.
        """

    def LastRead(self) -> int:
        """
        LastRead() -> int
        
        Returns the last number of bytes read.
        """

    def Peek(self) -> str:
        """
        Peek() -> str
        
        Returns the first character in the input queue without removing it.
        """

    @overload
    def Read(self, stream_out: OutputStream) -> InputStream:
        ...

    @overload
    def Read(self, buffer: Any, size: int) -> InputStream:
        """
        Read(buffer, size) -> InputStream
        Read(stream_out) -> InputStream
        
        Reads the specified amount of bytes and stores the data in buffer.
        """

    def ReadAll(self, buffer: Any, size: int) -> bool:
        """
        ReadAll(buffer, size) -> bool
        
        Reads exactly the specified number of bytes into the buffer.
        """

    def SeekI(self, pos: FileOffset, mode: SeekMode=FromStart) -> FileOffset:
        """
        SeekI(pos, mode=FromStart) -> FileOffset
        
        Changes the stream current position.
        """

    def TellI(self) -> FileOffset:
        """
        TellI() -> FileOffset
        
        Returns the current stream position or wxInvalidOffset if it's not
        available (e.g.
        """

    @overload
    def Ungetch(self, c: str) -> bool:
        ...

    @overload
    def Ungetch(self, buffer: Any, size: int) -> int:
        """
        Ungetch(buffer, size) -> int
        Ungetch(c) -> bool
        
        This function is only useful in read mode.
        """

    def seek(self, offset: FileOffset, whence: int=0) -> None:
        """
        seek(offset, whence=0) -> None
        """

    def tell(self) -> FileOffset:
        """
        tell() -> FileOffset
        """

    def close(self) -> None:
        """
        close() -> None
        """

    def flush(self) -> None:
        """
        flush() -> None
        """

    def eof(self) -> bool:
        """
        eof() -> bool
        """

    @overload
    def read(self, size: int) -> Any:
        ...

    @overload
    def read(self) -> Any:
        """
        read() -> Any
        read(size) -> Any
        """

    @overload
    def readline(self, size: int) -> Any:
        ...

    @overload
    def readline(self) -> Any:
        """
        readline() -> Any
        readline(size) -> Any
        """

    @overload
    def readlines(self, sizehint: int) -> Any:
        ...

    @overload
    def readlines(self) -> Any:
        """
        readlines() -> Any
        readlines(sizehint) -> Any
        """
    @property
    def C(self) -> int: ...
# end of class InputStream


class OutputStream(StreamBase):
    """
    OutputStream() -> None
    
    wxOutputStream is an abstract base class which may not be used
    directly.
    """

    def __init__(self) -> None:
        """
        OutputStream() -> None
        
        wxOutputStream is an abstract base class which may not be used
        directly.
        """

    def Close(self) -> bool:
        """
        Close() -> bool
        
        Closes the stream, returning false if an error occurs.
        """

    def LastWrite(self) -> int:
        """
        LastWrite() -> int
        
        Returns the number of bytes written during the last Write().
        """

    def PutC(self, c: str) -> None:
        """
        PutC(c) -> None
        
        Puts the specified character in the output queue and increments the
        stream position.
        """

    def SeekO(self, pos: FileOffset, mode: SeekMode=FromStart) -> FileOffset:
        """
        SeekO(pos, mode=FromStart) -> FileOffset
        
        Changes the stream current position.
        """

    def TellO(self) -> FileOffset:
        """
        TellO() -> FileOffset
        
        Returns the current stream position.
        """

    @overload
    def Write(self, stream_in: InputStream) -> OutputStream:
        ...

    @overload
    def Write(self, buffer: Any, size: int) -> OutputStream:
        """
        Write(buffer, size) -> OutputStream
        Write(stream_in) -> OutputStream
        
        Writes up to the specified amount of bytes using the data of buffer.
        """

    def WriteAll(self, buffer: Any, size: int) -> bool:
        """
        WriteAll(buffer, size) -> bool
        
        Writes exactly the specified number of bytes from the buffer.
        """

    def seek(self, offset: FileOffset, whence: int=0) -> None:
        """
        seek(offset, whence=0) -> None
        """

    def tell(self) -> FileOffset:
        """
        tell() -> FileOffset
        """

    def close(self) -> None:
        """
        close() -> None
        """

    def flush(self) -> None:
        """
        flush() -> None
        """

    def eof(self) -> bool:
        """
        eof() -> bool
        """

    def write(self, data: Any) -> Any:
        """
        write(data) -> Any
        """
# end of class OutputStream

#-- end-stream --#
#-- begin-filesys --#

class _FileSystemOpenFlags(IntFlag):
    FS_READ = auto()
    FS_SEEKABLE = auto()
FileSystemOpenFlags: TypeAlias = Union[_FileSystemOpenFlags, int]
FS_READ = _FileSystemOpenFlags.FS_READ
FS_SEEKABLE = _FileSystemOpenFlags.FS_SEEKABLE

class FileSystem(Object):
    """
    FileSystem() -> None
    
    This class provides an interface for opening files on different file
    systems.
    """

    def __init__(self) -> None:
        """
        FileSystem() -> None
        
        This class provides an interface for opening files on different file
        systems.
        """

    def ChangePathTo(self, location: str, is_dir: bool=False) -> None:
        """
        ChangePathTo(location, is_dir=False) -> None
        
        Sets the current location.
        """

    def FindFileInPath(self, pStr: str, path: str, file: str) -> bool:
        """
        FindFileInPath(pStr, path, file) -> bool
        
        Looks for the file with the given name file in a colon or semi-colon
        (depending on the current platform) separated list of directories in
        path.
        """

    def FindFirst(self, wildcard: str, flags: int=0) -> str:
        """
        FindFirst(wildcard, flags=0) -> str
        
        Works like wxFindFirstFile().
        """

    def FindNext(self) -> str:
        """
        FindNext() -> str
        
        Returns the next filename that matches the parameters passed to
        FindFirst().
        """

    def GetPath(self) -> str:
        """
        GetPath() -> str
        
        Returns the actual path (set by wxFileSystem::ChangePathTo).
        """

    def OpenFile(self, location: str, flags: int=FS_READ) -> FSFile:
        """
        OpenFile(location, flags=FS_READ) -> FSFile
        
        Opens the file and returns a pointer to a wxFSFile object or NULL if
        failed.
        """

    @staticmethod
    def AddHandler(handler: FileSystemHandler) -> None:
        """
        AddHandler(handler) -> None
        
        This static function adds a new handler into the list of handlers
        which provide access to virtual FS.
        """

    @staticmethod
    def RemoveHandler(handler: FileSystemHandler) -> FileSystemHandler:
        """
        RemoveHandler(handler) -> FileSystemHandler
        
        Remove a filesystem handler from the list of handlers.
        """

    @staticmethod
    def FileNameToURL(filename: str) -> str:
        """
        FileNameToURL(filename) -> str
        
        Converts a wxFileName into an URL.
        """

    @staticmethod
    def HasHandlerForPath(location: str) -> bool:
        """
        HasHandlerForPath(location) -> bool
        
        This static function returns true if there is a registered handler
        which can open the given location.
        """

    @staticmethod
    def URLToFileName(url: str) -> str:
        """
        URLToFileName(url) -> str
        
        Converts URL into a well-formed filename.
        """
    @property
    def Path(self) -> str: ...
# end of class FileSystem


class FSFile(Object):
    """
    FSFile(stream, location, mimetype, anchor, modif) -> None
    
    This class represents a single file opened by wxFileSystem.
    """

    def __init__(self, stream: InputStream, location: str, mimetype: str, anchor: str, modif: DateTime) -> None:
        """
        FSFile(stream, location, mimetype, anchor, modif) -> None
        
        This class represents a single file opened by wxFileSystem.
        """

    def DetachStream(self) -> InputStream:
        """
        DetachStream() -> InputStream
        
        Detaches the stream from the wxFSFile object.
        """

    def GetAnchor(self) -> str:
        """
        GetAnchor() -> str
        
        Returns anchor (if present).
        """

    def GetLocation(self) -> str:
        """
        GetLocation() -> str
        
        Returns full location of the file, including path and protocol.
        """

    def GetMimeType(self) -> str:
        """
        GetMimeType() -> str
        
        Returns the MIME type of the content of this file.
        """

    def GetModificationTime(self) -> DateTime:
        """
        GetModificationTime() -> DateTime
        
        Returns time when this file was modified.
        """

    def GetStream(self) -> InputStream:
        """
        GetStream() -> InputStream
        
        Returns pointer to the stream.
        """
    @property
    def Anchor(self) -> str: ...
    @property
    def Location(self) -> str: ...
    @property
    def MimeType(self) -> str: ...
    @property
    def ModificationTime(self) -> DateTime: ...
    @property
    def Stream(self) -> InputStream: ...
# end of class FSFile


class FileSystemHandler(Object):
    """
    FileSystemHandler() -> None
    
    Classes derived from wxFileSystemHandler are used to access virtual
    file systems.
    """

    def __init__(self) -> None:
        """
        FileSystemHandler() -> None
        
        Classes derived from wxFileSystemHandler are used to access virtual
        file systems.
        """

    def CanOpen(self, location: str) -> bool:
        """
        CanOpen(location) -> bool
        
        Returns true if the handler is able to open this file.
        """

    def FindFirst(self, wildcard: str, flags: int=0) -> str:
        """
        FindFirst(wildcard, flags=0) -> str
        
        Works like wxFindFirstFile().
        """

    def FindNext(self) -> str:
        """
        FindNext() -> str
        
        Returns next filename that matches parameters passed to
        wxFileSystem::FindFirst.
        """

    def OpenFile(self, fs: FileSystem, location: str) -> FSFile:
        """
        OpenFile(fs, location) -> FSFile
        
        Opens the file and returns wxFSFile pointer or NULL if failed.
        """

    @staticmethod
    def GetMimeTypeFromExt(location: str) -> str:
        """
        GetMimeTypeFromExt(location) -> str
        
        Returns the MIME type based on extension of location.
        """

    @staticmethod
    def GetAnchor(location: str) -> str:
        """
        GetAnchor(location) -> str
        
        Returns the anchor if present in the location.
        """

    @staticmethod
    def GetLeftLocation(location: str) -> str:
        """
        GetLeftLocation(location) -> str
        
        Returns the left location string extracted from location.
        """

    @staticmethod
    def GetProtocol(location: str) -> str:
        """
        GetProtocol(location) -> str
        
        Returns the protocol string extracted from location.
        """

    @staticmethod
    def GetRightLocation(location: str) -> str:
        """
        GetRightLocation(location) -> str
        
        Returns the right location string extracted from location.
        """
# end of class FileSystemHandler


class MemoryFSHandler(FileSystemHandler):
    """
    MemoryFSHandler() -> None
    
    This wxFileSystem handler can store arbitrary data in memory stream
    and make them accessible via an URL.
    """

    def __init__(self) -> None:
        """
        MemoryFSHandler() -> None
        
        This wxFileSystem handler can store arbitrary data in memory stream
        and make them accessible via an URL.
        """

    @overload
    @staticmethod
    def AddFile(filename: str, bitmap: Bitmap, type: BitmapType) -> None:
        ...

    @overload
    @staticmethod
    def AddFile(filename: str, textdata: str) -> None:
        ...

    @overload
    @staticmethod
    def AddFile(filename: str, binarydata: PyBuffer) -> None:
        ...

    @overload
    @staticmethod
    def AddFile(filename: str, image: Image, type: BitmapType) -> None:
        """
        AddFile(filename, image, type) -> None
        AddFile(filename, bitmap, type) -> None
        AddFile(filename, textdata) -> None
        AddFile(filename, binarydata) -> None
        
        Adds a file to the list of the files stored in memory.
        """

    @overload
    @staticmethod
    def AddFileWithMimeType(filename: str, binarydata: PyBuffer, mimetype: str) -> None:
        ...

    @overload
    @staticmethod
    def AddFileWithMimeType(filename: str, textdata: str, mimetype: str) -> None:
        """
        AddFileWithMimeType(filename, textdata, mimetype) -> None
        AddFileWithMimeType(filename, binarydata, mimetype) -> None
        
        Add a file from text data, which will first be converted to utf-8
        encoded bytes.
        """

    @staticmethod
    def RemoveFile(filename: str) -> None:
        """
        RemoveFile(filename) -> None
        
        Removes a file from memory FS and frees the occupied memory.
        """
# end of class MemoryFSHandler


class ArchiveFSHandler(FileSystemHandler):
    """
    ArchiveFSHandler() -> None
    
    A file system handler for accessing files inside of archives.
    """

    def __init__(self) -> None:
        """
        ArchiveFSHandler() -> None
        
        A file system handler for accessing files inside of archives.
        """

    def Cleanup(self) -> None:
        """
        Cleanup() -> None
        """
# end of class ArchiveFSHandler


class FilterFSHandler(FileSystemHandler):
    """
    FilterFSHandler() -> None
    
    Filter file system handler.
    """

    def __init__(self) -> None:
        """
        FilterFSHandler() -> None
        
        Filter file system handler.
        """
# end of class FilterFSHandler


class InternetFSHandler(FileSystemHandler):
    """
    InternetFSHandler() -> None
    
    A file system handler for accessing files from internet servers.
    """

    def __init__(self) -> None:
        """
        InternetFSHandler() -> None
        
        A file system handler for accessing files from internet servers.
        """
# end of class InternetFSHandler


ZipFSHandler = wx.deprecated(ArchiveFSHandler, "Use ArchiveFSHandler instead.")
#-- end-filesys --#
#-- begin-image --#

class _ImageResolution(IntEnum):
    IMAGE_RESOLUTION_NONE = auto()
    IMAGE_RESOLUTION_INCHES = auto()
    IMAGE_RESOLUTION_CM = auto()
ImageResolution: TypeAlias = Union[_ImageResolution, int]
IMAGE_RESOLUTION_NONE = _ImageResolution.IMAGE_RESOLUTION_NONE
IMAGE_RESOLUTION_INCHES = _ImageResolution.IMAGE_RESOLUTION_INCHES
IMAGE_RESOLUTION_CM = _ImageResolution.IMAGE_RESOLUTION_CM

class _ImageResizeQuality(IntEnum):
    IMAGE_QUALITY_NEAREST = auto()
    IMAGE_QUALITY_BILINEAR = auto()
    IMAGE_QUALITY_BICUBIC = auto()
    IMAGE_QUALITY_BOX_AVERAGE = auto()
    IMAGE_QUALITY_NORMAL = auto()
    IMAGE_QUALITY_HIGH = auto()
ImageResizeQuality: TypeAlias = Union[_ImageResizeQuality, int]
IMAGE_QUALITY_NEAREST = _ImageResizeQuality.IMAGE_QUALITY_NEAREST
IMAGE_QUALITY_BILINEAR = _ImageResizeQuality.IMAGE_QUALITY_BILINEAR
IMAGE_QUALITY_BICUBIC = _ImageResizeQuality.IMAGE_QUALITY_BICUBIC
IMAGE_QUALITY_BOX_AVERAGE = _ImageResizeQuality.IMAGE_QUALITY_BOX_AVERAGE
IMAGE_QUALITY_NORMAL = _ImageResizeQuality.IMAGE_QUALITY_NORMAL
IMAGE_QUALITY_HIGH = _ImageResizeQuality.IMAGE_QUALITY_HIGH

class _ImageAlphaBlendMode(IntEnum):
    IMAGE_ALPHA_BLEND_OVER = auto()
    IMAGE_ALPHA_BLEND_COMPOSE = auto()
ImageAlphaBlendMode: TypeAlias = Union[_ImageAlphaBlendMode, int]
IMAGE_ALPHA_BLEND_OVER = _ImageAlphaBlendMode.IMAGE_ALPHA_BLEND_OVER
IMAGE_ALPHA_BLEND_COMPOSE = _ImageAlphaBlendMode.IMAGE_ALPHA_BLEND_COMPOSE

class _ImagePNGType(IntEnum):
    PNG_TYPE_COLOUR = auto()
    PNG_TYPE_GREY = auto()
    PNG_TYPE_GREY_RED = auto()
    PNG_TYPE_PALETTE = auto()
ImagePNGType: TypeAlias = Union[_ImagePNGType, int]
PNG_TYPE_COLOUR = _ImagePNGType.PNG_TYPE_COLOUR
PNG_TYPE_GREY = _ImagePNGType.PNG_TYPE_GREY
PNG_TYPE_GREY_RED = _ImagePNGType.PNG_TYPE_GREY_RED
PNG_TYPE_PALETTE = _ImagePNGType.PNG_TYPE_PALETTE

class _enum_(IntEnum):
    BMP_24BPP = auto()
    BMP_8BPP = auto()
    BMP_8BPP_GREY = auto()
    BMP_8BPP_GRAY = auto()
    BMP_8BPP_RED = auto()
    BMP_8BPP_PALETTE = auto()
    BMP_4BPP = auto()
    BMP_1BPP = auto()
    BMP_1BPP_BW = auto()
BMP_24BPP = _enum_.BMP_24BPP
BMP_8BPP = _enum_.BMP_8BPP
BMP_8BPP_GREY = _enum_.BMP_8BPP_GREY
BMP_8BPP_GRAY = _enum_.BMP_8BPP_GRAY
BMP_8BPP_RED = _enum_.BMP_8BPP_RED
BMP_8BPP_PALETTE = _enum_.BMP_8BPP_PALETTE
BMP_4BPP = _enum_.BMP_4BPP
BMP_1BPP = _enum_.BMP_1BPP
BMP_1BPP_BW = _enum_.BMP_1BPP_BW
IMAGE_ALPHA_TRANSPARENT: int
IMAGE_ALPHA_OPAQUE: int
IMAGE_ALPHA_THRESHOLD: int

class Image(Object):
    """
    Image() -> None
    Image(width, height, clear=True) -> None
    Image(sz, clear=True) -> None
    Image(name, type=BITMAP_TYPE_ANY, index=-1) -> None
    Image(name, mimetype, index=-1) -> None
    Image(stream, type=BITMAP_TYPE_ANY, index=-1) -> None
    Image(stream, mimetype, index=-1) -> None
    Image(width, height, data) -> None
    Image(width, height, data, alpha) -> None
    Image(size, data) -> None
    Image(size, data, alpha) -> None
    
    This class encapsulates a platform-independent image.
    """

    class HSVValue:
        """
        HSVValue(h=0.0, s=0.0, v=0.0) -> None
        
        A simple class which stores hue, saturation and value as doubles in
        the range 0.0-1.0.
        """

        def __init__(self, h: float=0.0, s: float=0.0, v: float=0.0) -> None:
            """
            HSVValue(h=0.0, s=0.0, v=0.0) -> None
            
            A simple class which stores hue, saturation and value as doubles in
            the range 0.0-1.0.
            """
        hue: float
        saturation: float
        value: float
    # end of class HSVValue


    class RGBValue:
        """
        RGBValue(r=0, g=0, b=0) -> None
        
        A simple class which stores red, green and blue values as 8 bit
        unsigned integers in the range of 0-255.
        """

        def __init__(self, r: int=0, g: int=0, b: int=0) -> None:
            """
            RGBValue(r=0, g=0, b=0) -> None
            
            A simple class which stores red, green and blue values as 8 bit
            unsigned integers in the range of 0-255.
            """
        red: int
        green: int
        blue: int
    # end of class RGBValue


    @overload
    def __init__(self, width: int, height: int, clear: bool=True) -> None:
        ...

    @overload
    def __init__(self, sz: Size, clear: bool=True) -> None:
        ...

    @overload
    def __init__(self, name: str, type: BitmapType=BITMAP_TYPE_ANY, index: int=-1) -> None:
        ...

    @overload
    def __init__(self, name: str, mimetype: str, index: int=-1) -> None:
        ...

    @overload
    def __init__(self, stream: InputStream, type: BitmapType=BITMAP_TYPE_ANY, index: int=-1) -> None:
        ...

    @overload
    def __init__(self, stream: InputStream, mimetype: str, index: int=-1) -> None:
        ...

    @overload
    def __init__(self, width: int, height: int, data: PyBuffer) -> None:
        ...

    @overload
    def __init__(self, width: int, height: int, data: PyBuffer, alpha: PyBuffer) -> None:
        ...

    @overload
    def __init__(self, size: Size, data: PyBuffer) -> None:
        ...

    @overload
    def __init__(self, size: Size, data: PyBuffer, alpha: PyBuffer) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Image() -> None
        Image(width, height, clear=True) -> None
        Image(sz, clear=True) -> None
        Image(name, type=BITMAP_TYPE_ANY, index=-1) -> None
        Image(name, mimetype, index=-1) -> None
        Image(stream, type=BITMAP_TYPE_ANY, index=-1) -> None
        Image(stream, mimetype, index=-1) -> None
        Image(width, height, data) -> None
        Image(width, height, data, alpha) -> None
        Image(size, data) -> None
        Image(size, data, alpha) -> None
        
        This class encapsulates a platform-independent image.
        """

    def Copy(self) -> Image:
        """
        Copy() -> Image
        
        Returns an identical copy of this image.
        """

    @overload
    def Create(self, sz: Size, clear: bool=True) -> bool:
        ...

    @overload
    def Create(self, width: int, height: int, data: PyBuffer) -> bool:
        ...

    @overload
    def Create(self, width: int, height: int, data: PyBuffer, alpha: PyBuffer) -> bool:
        ...

    @overload
    def Create(self, size: Size, data: PyBuffer) -> bool:
        ...

    @overload
    def Create(self, size: Size, data: PyBuffer, alpha: PyBuffer) -> bool:
        ...

    @overload
    def Create(self, width: int, height: int, clear: bool=True) -> bool:
        """
        Create(width, height, clear=True) -> bool
        Create(sz, clear=True) -> bool
        Create(width, height, data) -> bool
        Create(width, height, data, alpha) -> bool
        Create(size, data) -> bool
        Create(size, data, alpha) -> bool
        
        Creates a fresh image.
        """

    def Clear(self, value: int=0) -> None:
        """
        Clear(value=0) -> None
        
        Initialize the image data with zeroes (the default) or with the byte
        value given as value.
        """

    def Destroy(self) -> None:
        """
        Destroy() -> None
        
        Destroys the image data.
        """

    def InitAlpha(self) -> None:
        """
        InitAlpha() -> None
        
        Initializes the image alpha channel data.
        """

    def Blur(self, blurRadius: int) -> Image:
        """
        Blur(blurRadius) -> Image
        
        Blurs the image in both horizontal and vertical directions by the specified pixel blurRadius.
        """

    def BlurHorizontal(self, blurRadius: int) -> Image:
        """
        BlurHorizontal(blurRadius) -> Image
        
        Blurs the image in the horizontal direction only.
        """

    def BlurVertical(self, blurRadius: int) -> Image:
        """
        BlurVertical(blurRadius) -> Image
        
        Blurs the image in the vertical direction only.
        """

    def Mirror(self, horizontally: bool=True) -> Image:
        """
        Mirror(horizontally=True) -> Image
        
        Returns a mirrored copy of the image.
        """

    def Paste(self, image: Image, x: int, y: int, alphaBlend: ImageAlphaBlendMode=IMAGE_ALPHA_BLEND_OVER) -> None:
        """
        Paste(image, x, y, alphaBlend=IMAGE_ALPHA_BLEND_OVER) -> None
        
        Copy the data of the given image to the specified position in this
        image.
        """

    def Replace(self, r1: int, g1: int, b1: int, r2: int, g2: int, b2: int) -> None:
        """
        Replace(r1, g1, b1, r2, g2, b2) -> None
        
        Replaces the colour specified by r1,g1,b1 by the colour r2,g2,b2.
        """

    def Rescale(self, width: int, height: int, quality: ImageResizeQuality=IMAGE_QUALITY_NORMAL) -> Image:
        """
        Rescale(width, height, quality=IMAGE_QUALITY_NORMAL) -> Image
        
        Changes the size of the image in-place by scaling it: after a call to
        this function,the image will have the given width and height.
        """

    def Resize(self, size: Size, pos: Point, red: int=-1, green: int=-1, blue: int=-1) -> Image:
        """
        Resize(size, pos, red=-1, green=-1, blue=-1) -> Image
        
        Changes the size of the image in-place without scaling it by adding
        either a border with the given colour or cropping as necessary.
        """

    def Rotate(self, angle: float, rotationCentre: Point, interpolating: bool=True, offsetAfterRotation: Optional[Point]=None) -> Image:
        """
        Rotate(angle, rotationCentre, interpolating=True, offsetAfterRotation=None) -> Image
        
        Rotates the image about the given point, by angle radians.
        """

    def Rotate90(self, clockwise: bool=True) -> Image:
        """
        Rotate90(clockwise=True) -> Image
        
        Returns a copy of the image rotated 90 degrees in the direction
        indicated by clockwise.
        """

    def Rotate180(self) -> Image:
        """
        Rotate180() -> Image
        
        Returns a copy of the image rotated by 180 degrees.
        """

    def RotateHue(self, angle: float) -> None:
        """
        RotateHue(angle) -> None
        
        Rotates the hue of each pixel in the image by angle, which is a double
        in the range [-1.0..+1.0], where -1.0 corresponds to -360 degrees and
        +1.0 corresponds to +360 degrees.
        """

    def ChangeSaturation(self, factor: float) -> None:
        """
        ChangeSaturation(factor) -> None
        
        Changes the saturation of each pixel in the image.
        """

    def ChangeBrightness(self, factor: float) -> None:
        """
        ChangeBrightness(factor) -> None
        
        Changes the brightness (value) of each pixel in the image.
        """

    def ChangeHSV(self, angleH: float, factorS: float, factorV: float) -> None:
        """
        ChangeHSV(angleH, factorS, factorV) -> None
        
        Changes the hue, the saturation and the brightness (value) of each
        pixel in the image.
        """

    def Scale(self, width: int, height: int, quality: ImageResizeQuality=IMAGE_QUALITY_NORMAL) -> Image:
        """
        Scale(width, height, quality=IMAGE_QUALITY_NORMAL) -> Image
        
        Returns a scaled version of the image.
        """

    def Size(self, size: Size, pos: Point, red: int=-1, green: int=-1, blue: int=-1) -> Image:
        """
        Size(size, pos, red=-1, green=-1, blue=-1) -> Image
        
        Returns a resized version of this image without scaling it by adding
        either a border with the given colour or cropping as necessary.
        """

    @overload
    def ConvertAlphaToMask(self, mr: int, mg: int, mb: int, threshold: int=IMAGE_ALPHA_THRESHOLD) -> bool:
        ...

    @overload
    def ConvertAlphaToMask(self, threshold: int=IMAGE_ALPHA_THRESHOLD) -> bool:
        """
        ConvertAlphaToMask(threshold=IMAGE_ALPHA_THRESHOLD) -> bool
        ConvertAlphaToMask(mr, mg, mb, threshold=IMAGE_ALPHA_THRESHOLD) -> bool
        
        If the image has alpha channel, this method converts it to mask.
        """

    @overload
    def ConvertToGreyscale(self) -> Image:
        ...

    @overload
    def ConvertToGreyscale(self, weight_r: float, weight_g: float, weight_b: float) -> Image:
        """
        ConvertToGreyscale(weight_r, weight_g, weight_b) -> Image
        ConvertToGreyscale() -> Image
        
        Returns a greyscale version of the image.
        """

    def ConvertToMono(self, r: int, g: int, b: int) -> Image:
        """
        ConvertToMono(r, g, b) -> Image
        
        Returns monochromatic version of the image.
        """

    def ConvertToDisabled(self, brightness: int=255) -> Image:
        """
        ConvertToDisabled(brightness=255) -> Image
        
        Returns disabled (dimmed) version of the image.
        """

    def ChangeLightness(self, alpha: int) -> Image:
        """
        ChangeLightness(alpha) -> Image
        
        Returns a changed version of the image based on the given lightness.
        """

    def ComputeHistogram(self, histogram: ImageHistogram) -> int:
        """
        ComputeHistogram(histogram) -> int
        
        Computes the histogram of the image.
        """

    def FindFirstUnusedColour(self, startR: int=1, startG: int=0, startB: int=0) -> Tuple[int, int, int]:
        """
        FindFirstUnusedColour(startR=1, startG=0, startB=0) -> Tuple[int, int, int]
        
        Finds the first colour that is never used in the image.
        """

    @overload
    def GetAlpha(self) -> Any:
        ...

    @overload
    def GetAlpha(self, x: int, y: int) -> int:
        """
        GetAlpha(x, y) -> int
        GetAlpha() -> Any
        
        Return alpha value at given pixel location.
        """

    def GetData(self) -> Any:
        """
        GetData() -> Any
        
        Returns a copy of the RGB bytes of the image.
        """

    def GetRed(self, x: int, y: int) -> int:
        """
        GetRed(x, y) -> int
        
        Returns the red intensity at the given coordinate.
        """

    def GetGreen(self, x: int, y: int) -> int:
        """
        GetGreen(x, y) -> int
        
        Returns the green intensity at the given coordinate.
        """

    def GetBlue(self, x: int, y: int) -> int:
        """
        GetBlue(x, y) -> int
        
        Returns the blue intensity at the given coordinate.
        """

    def GetMaskRed(self) -> int:
        """
        GetMaskRed() -> int
        
        Gets the red value of the mask colour.
        """

    def GetMaskGreen(self) -> int:
        """
        GetMaskGreen() -> int
        
        Gets the green value of the mask colour.
        """

    def GetMaskBlue(self) -> int:
        """
        GetMaskBlue() -> int
        
        Gets the blue value of the mask colour.
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Gets the width of the image in pixels.
        """

    def GetHeight(self) -> int:
        """
        GetHeight() -> int
        
        Gets the height of the image in pixels.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Returns the size of the image in pixels.
        """

    def GetOption(self, name: str) -> str:
        """
        GetOption(name) -> str
        
        Gets a user-defined string-valued option.
        """

    def GetOptionInt(self, name: str) -> int:
        """
        GetOptionInt(name) -> int
        
        Gets a user-defined integer-valued option.
        """

    def GetOrFindMaskColour(self) -> Tuple[int, int, int]:
        """
        GetOrFindMaskColour() -> Tuple[int, int, int]
        
        Get the current mask colour or find a suitable unused colour that
        could be used as a mask colour.
        """

    def GetPalette(self) -> Palette:
        """
        GetPalette() -> Palette
        
        Returns the palette associated with the image.
        """

    def GetSubImage(self, rect: Rect) -> Image:
        """
        GetSubImage(rect) -> Image
        
        Returns a sub image of the current one as long as the rect belongs
        entirely to the image.
        """

    def GetType(self) -> BitmapType:
        """
        GetType() -> BitmapType
        
        Gets the type of image found by LoadFile() or specified with
        SaveFile().
        """

    def HasAlpha(self) -> bool:
        """
        HasAlpha() -> bool
        
        Returns true if this image has alpha channel, false otherwise.
        """

    def HasMask(self) -> bool:
        """
        HasMask() -> bool
        
        Returns true if there is a mask active, false otherwise.
        """

    def HasOption(self, name: str) -> bool:
        """
        HasOption(name) -> bool
        
        Returns true if the given option is present.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if image data is present.
        """

    def IsTransparent(self, x: int, y: int, threshold: int=IMAGE_ALPHA_THRESHOLD) -> bool:
        """
        IsTransparent(x, y, threshold=IMAGE_ALPHA_THRESHOLD) -> bool
        
        Returns true if the given pixel is transparent, i.e. either has the
        mask colour if this image has a mask or if this image has alpha
        channel and alpha value of this pixel is strictly less than threshold.
        """

    @overload
    def LoadFile(self, name: str, type: BitmapType=BITMAP_TYPE_ANY, index: int=-1) -> bool:
        ...

    @overload
    def LoadFile(self, name: str, mimetype: str, index: int=-1) -> bool:
        ...

    @overload
    def LoadFile(self, stream: InputStream, mimetype: str, index: int=-1) -> bool:
        ...

    @overload
    def LoadFile(self, stream: InputStream, type: BitmapType=BITMAP_TYPE_ANY, index: int=-1) -> bool:
        """
        LoadFile(stream, type=BITMAP_TYPE_ANY, index=-1) -> bool
        LoadFile(name, type=BITMAP_TYPE_ANY, index=-1) -> bool
        LoadFile(name, mimetype, index=-1) -> bool
        LoadFile(stream, mimetype, index=-1) -> bool
        
        Loads an image from an input stream.
        """

    @overload
    def SaveFile(self, name: str, type: BitmapType) -> bool:
        ...

    @overload
    def SaveFile(self, name: str, mimetype: str) -> bool:
        ...

    @overload
    def SaveFile(self, name: str) -> bool:
        ...

    @overload
    def SaveFile(self, stream: OutputStream, type: BitmapType) -> bool:
        ...

    @overload
    def SaveFile(self, stream: OutputStream, mimetype: str) -> bool:
        """
        SaveFile(stream, mimetype) -> bool
        SaveFile(name, type) -> bool
        SaveFile(name, mimetype) -> bool
        SaveFile(name) -> bool
        SaveFile(stream, type) -> bool
        
        Saves an image in the given stream.
        """

    @overload
    def SetAlpha(self, alpha: PyBuffer) -> None:
        ...

    @overload
    def SetAlpha(self, x: int, y: int, alpha: int) -> None:
        """
        SetAlpha(x, y, alpha) -> None
        SetAlpha(alpha) -> None
        
        Sets the alpha value for the given pixel.
        """

    def ClearAlpha(self) -> None:
        """
        ClearAlpha() -> None
        
        Removes the alpha channel from the image.
        """

    @overload
    def SetData(self, data: PyBuffer, new_width: int, new_height: int) -> None:
        ...

    @overload
    def SetData(self, data: PyBuffer) -> None:
        """
        SetData(data) -> None
        SetData(data, new_width, new_height) -> None
        
        Sets the image data without performing checks.
        """

    def SetLoadFlags(self, flags: int) -> None:
        """
        SetLoadFlags(flags) -> None
        
        Sets the flags used for loading image files by this object.
        """

    def SetMask(self, hasMask: bool=True) -> None:
        """
        SetMask(hasMask=True) -> None
        
        Specifies whether there is a mask or not.
        """

    def SetMaskColour(self, red: int, green: int, blue: int) -> None:
        """
        SetMaskColour(red, green, blue) -> None
        
        Sets the mask colour for this image (and tells the image to use the
        mask).
        """

    def SetMaskFromImage(self, mask: Image, mr: int, mg: int, mb: int) -> bool:
        """
        SetMaskFromImage(mask, mr, mg, mb) -> bool
        
        Sets image's mask so that the pixels that have RGB value of mr,mg,mb
        in mask will be masked in the image.
        """

    @overload
    def SetOption(self, name: str, value: int) -> None:
        ...

    @overload
    def SetOption(self, name: str, value: str) -> None:
        """
        SetOption(name, value) -> None
        SetOption(name, value) -> None
        
        Sets a user-defined option.
        """

    def SetPalette(self, palette: Palette) -> None:
        """
        SetPalette(palette) -> None
        
        Associates a palette with the image.
        """

    @overload
    def SetRGB(self, rect: Rect, red: int, green: int, blue: int) -> None:
        ...

    @overload
    def SetRGB(self, x: int, y: int, r: int, g: int, b: int) -> None:
        """
        SetRGB(x, y, r, g, b) -> None
        SetRGB(rect, red, green, blue) -> None
        
        Set the color of the pixel at the given x and y coordinate.
        """

    def SetType(self, type: BitmapType) -> None:
        """
        SetType(type) -> None
        
        Set the type of image returned by GetType().
        """

    @staticmethod
    def SetDefaultLoadFlags(flags: int) -> None:
        """
        SetDefaultLoadFlags(flags) -> None
        
        Sets the default value for the flags used for loading image files.
        """

    @staticmethod
    def AddHandler(handler: ImageHandler) -> None:
        """
        AddHandler(handler) -> None
        
        Register an image handler.
        """

    @staticmethod
    def CleanUpHandlers() -> None:
        """
        CleanUpHandlers() -> None
        
        Deletes all image handlers.
        """

    @overload
    @staticmethod
    def FindHandler(extension: str, imageType: BitmapType) -> ImageHandler:
        ...

    @overload
    @staticmethod
    def FindHandler(imageType: BitmapType) -> ImageHandler:
        ...

    @overload
    @staticmethod
    def FindHandler(name: str) -> ImageHandler:
        """
        FindHandler(name) -> ImageHandler
        FindHandler(extension, imageType) -> ImageHandler
        FindHandler(imageType) -> ImageHandler
        
        Finds the handler with the given name.
        """

    @staticmethod
    def FindHandlerMime(mimetype: str) -> ImageHandler:
        """
        FindHandlerMime(mimetype) -> ImageHandler
        
        Finds the handler associated with the given MIME type.
        """

    @staticmethod
    def InitStandardHandlers() -> None:
        """
        InitStandardHandlers() -> None
        
        Internal use only.
        """

    @staticmethod
    def InsertHandler(handler: ImageHandler) -> None:
        """
        InsertHandler(handler) -> None
        
        Adds a handler at the start of the static list of format handlers.
        """

    @staticmethod
    def RemoveHandler(name: str) -> bool:
        """
        RemoveHandler(name) -> bool
        
        Finds the handler with the given name, and removes it.
        """

    @overload
    @staticmethod
    def GetImageCount(stream: InputStream, type: BitmapType=BITMAP_TYPE_ANY) -> int:
        ...

    @overload
    @staticmethod
    def GetImageCount(filename: str, type: BitmapType=BITMAP_TYPE_ANY) -> int:
        """
        GetImageCount(filename, type=BITMAP_TYPE_ANY) -> int
        GetImageCount(stream, type=BITMAP_TYPE_ANY) -> int
        
        If the image file contains more than one image and the image handler
        is capable of retrieving these individually, this function will return
        the number of available images.
        """

    def GetLoadFlags(self) -> int:
        """
        GetLoadFlags() -> int
        
        Returns the file load flags used for this object.
        """

    @overload
    @staticmethod
    def CanRead(stream: InputStream) -> bool:
        ...

    @overload
    @staticmethod
    def CanRead(filename: str) -> bool:
        """
        CanRead(filename) -> bool
        CanRead(stream) -> bool
        
        Returns true if at least one of the available image handlers can read
        the file with the given name.
        """

    @staticmethod
    def GetDefaultLoadFlags() -> int:
        """
        GetDefaultLoadFlags() -> int
        
        Returns the currently used default file load flags.
        """

    @staticmethod
    def GetImageExtWildcard() -> str:
        """
        GetImageExtWildcard() -> str
        
        Iterates all registered wxImageHandler objects, and returns a string
        containing file extension masks suitable for passing to file open/save
        dialog boxes.
        """

    @staticmethod
    def RGBtoHSV(rgb: Image.RGBValue) -> Image.HSVValue:
        """
        RGBtoHSV(rgb) -> Image.HSVValue
        
        Converts a color in RGB color space to HSV color space.
        """

    @staticmethod
    def HSVtoRGB(hsv: Image.HSVValue) -> Image.RGBValue:
        """
        HSVtoRGB(hsv) -> Image.RGBValue
        
        Converts a color in HSV color space to RGB color space.
        """

    def GetDataBuffer(self) -> Any:
        """
        GetDataBuffer() -> Any
        
        Returns a writable Python buffer object that is pointing at the RGB
        image data buffer inside the :class:`Image`. You need to ensure that
        you do
        not use this buffer object after the image has been destroyed.
        """

    def GetAlphaBuffer(self) -> Any:
        """
        GetAlphaBuffer() -> Any
        
        Returns a writable Python buffer object that is pointing at the Alpha
        data buffer inside the :class:`Image`. You need to ensure that you do
        not use this buffer object after the image has been destroyed.
        """

    @overload
    def SetDataBuffer(self, data: PyBuffer, new_width: int, new_height: int) -> None:
        ...

    @overload
    def SetDataBuffer(self, data: PyBuffer) -> None:
        """
        SetDataBuffer(data) -> None
        SetDataBuffer(data, new_width, new_height) -> None
        
        Sets the internal image data pointer to point at a Python buffer
        object.  This can save making an extra copy of the data but you must
        ensure that the buffer object lives lives at least as long as the
        :class:`Image` does.
        """

    def SetAlphaBuffer(self, alpha: PyBuffer) -> None:
        """
        SetAlphaBuffer(alpha) -> None
        
        Sets the internal image alpha pointer to point at a Python buffer
        object.  This can save making an extra copy of the data but you must
        ensure that the buffer object lives lives at least as long as the
        :class:`Image` does.
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def ConvertToBitmap(self, depth=-1):
        """
        ConvertToBitmap(depth=-1) -> Bitmap
        
        Convert the image to a :class:`wx.Bitmap`.
        """

    def ConvertToMonoBitmap(self, red, green, blue):
        """
        ConvertToMonoBitmap(red, green, blue) -> Bitmap
        
        Creates a monochrome version of the image and returns it as a :class:`wx.Bitmap`.
        """

    def AdjustChannels(self, factor_red: float, factor_green: float, factor_blue: float, factor_alpha: float=1.0) -> Image:
        """
        AdjustChannels(factor_red, factor_green, factor_blue, factor_alpha=1.0) -> Image
        
        This function muliplies all 4 channels (red, green, blue, alpha) with
        a factor (around 1.0). Useful for gamma correction, colour correction
        and to add a certain amount of transparency to a image (fade in fade
        out effects). If factor_alpha is given but the original image has no
        alpha channel then a alpha channel will be added.
        """
    @property
    def Width(self) -> int: ...
    @property
    def Height(self) -> int: ...
    @property
    def MaskBlue(self) -> int: ...
    @property
    def MaskGreen(self) -> int: ...
    @property
    def MaskRed(self) -> int: ...
    @property
    def Type(self) -> BitmapType: ...
    @Type.setter
    def Type(self, value: BitmapType, /) -> None: ...

    def ConvertToRegion(self, R: int=-1, G: int=-1, B: int=-1, tolerance: int=0) -> Region:
        """
        ConvertToRegion(R=-1, G=-1, B=-1, tolerance=0) -> Region
        
        Create a :class:`wx.Region` where the transparent areas match the
        given RGB values.
        """
# end of class Image


class ImageHistogram:
    """
    ImageHistogram() -> None
    """

    def __init__(self) -> None:
        """
        ImageHistogram() -> None
        """

    def FindFirstUnusedColour(self, startR: int=1, startG: int=0, startB: int=0) -> Tuple[int, int, int]:
        """
        FindFirstUnusedColour(startR=1, startG=0, startB=0) -> Tuple[int, int, int]
        """

    @staticmethod
    def MakeKey(r: int, g: int, b: int) -> int:
        """
        MakeKey(r, g, b) -> int
        """
# end of class ImageHistogram


class ImageHandler(Object):
    """
    ImageHandler() -> None
    
    This is the base class for implementing image file loading/saving, and
    image creation from data.
    """

    def __init__(self) -> None:
        """
        ImageHandler() -> None
        
        This is the base class for implementing image file loading/saving, and
        image creation from data.
        """

    @overload
    def CanRead(self, filename: str) -> bool:
        ...

    @overload
    def CanRead(self, stream: InputStream) -> bool:
        """
        CanRead(stream) -> bool
        CanRead(filename) -> bool
        
        Returns true if this handler supports the image format contained in
        the given stream.
        """

    def GetExtension(self) -> str:
        """
        GetExtension() -> str
        
        Gets the preferred file extension associated with this handler.
        """

    def GetAltExtensions(self) -> List[str]:
        """
        GetAltExtensions() -> List[str]
        
        Returns the other file extensions associated with this handler.
        """

    def GetImageCount(self, stream: InputStream) -> int:
        """
        GetImageCount(stream) -> int
        
        If the image file contains more than one image and the image handler
        is capable of retrieving these individually, this function will return
        the number of available images.
        """

    def GetMimeType(self) -> str:
        """
        GetMimeType() -> str
        
        Gets the MIME type associated with this handler.
        """

    def GetName(self) -> str:
        """
        GetName() -> str
        
        Gets the name of this handler.
        """

    def GetType(self) -> BitmapType:
        """
        GetType() -> BitmapType
        
        Gets the image type associated with this handler.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    def SetExtension(self, extension: str) -> None:
        """
        SetExtension(extension) -> None
        
        Sets the preferred file extension associated with this handler.
        """

    def SetAltExtensions(self, extensions: List[str]) -> None:
        """
        SetAltExtensions(extensions) -> None
        
        Sets the alternative file extensions associated with this handler.
        """

    def SetMimeType(self, mimetype: str) -> None:
        """
        SetMimeType(mimetype) -> None
        
        Sets the handler MIME type.
        """

    def SetName(self, name: str) -> None:
        """
        SetName(name) -> None
        
        Sets the handler name.
        """

    def SetType(self, type: BitmapType) -> None:
        """
        SetType(type) -> None
        
        Sets the bitmap type for the handler.
        """
    @property
    def AltExtensions(self) -> List[str]: ...
    @AltExtensions.setter
    def AltExtensions(self, value: List[str], /) -> None: ...
    @property
    def Extension(self) -> str: ...
    @Extension.setter
    def Extension(self, value: str, /) -> None: ...
    @property
    def MimeType(self) -> str: ...
    @MimeType.setter
    def MimeType(self, value: str, /) -> None: ...
    @property
    def Name(self) -> str: ...
    @Name.setter
    def Name(self, value: str, /) -> None: ...
    @property
    def Type(self) -> BitmapType: ...
    @Type.setter
    def Type(self, value: BitmapType, /) -> None: ...

    def DoGetImageCount(self, stream: InputStream) -> int:
        """
        DoGetImageCount(stream) -> int
        
        Called to get the number of images available in a multi-image file
        type, if supported.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class ImageHandler


class TIFFHandler(ImageHandler):
    """
    TIFFHandler() -> None
    
    This is the image handler for the TIFF format.
    """

    def __init__(self) -> None:
        """
        TIFFHandler() -> None
        
        This is the image handler for the TIFF format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class TIFFHandler


class GIFHandler(ImageHandler):
    """
    GIFHandler() -> None
    
    This is the image handler for the GIF format.
    """

    def __init__(self) -> None:
        """
        GIFHandler() -> None
        
        This is the image handler for the GIF format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    def SaveAnimation(self, images: ImageArray, stream: OutputStream, verbose: bool=True, delayMilliSecs: int=1000) -> bool:
        """
        SaveAnimation(images, stream, verbose=True, delayMilliSecs=1000) -> bool
        
        Save the animated gif.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class GIFHandler


class IFFHandler(ImageHandler):
    """
    IFFHandler() -> None
    
    This is the image handler for the IFF format.
    """

    def __init__(self) -> None:
        """
        IFFHandler() -> None
        
        This is the image handler for the IFF format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class IFFHandler


class JPEGHandler(ImageHandler):
    """
    JPEGHandler() -> None
    
    This is the image handler for the JPEG format.
    """

    def __init__(self) -> None:
        """
        JPEGHandler() -> None
        
        This is the image handler for the JPEG format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    @staticmethod
    def GetLibraryVersionInfo() -> VersionInfo:
        """
        GetLibraryVersionInfo() -> VersionInfo
        
        Retrieve the version information about the JPEG library used by this
        handler.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class JPEGHandler


class PCXHandler(ImageHandler):
    """
    PCXHandler() -> None
    
    This is the image handler for the PCX format.
    """

    def __init__(self) -> None:
        """
        PCXHandler() -> None
        
        This is the image handler for the PCX format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class PCXHandler


class PNGHandler(ImageHandler):
    """
    PNGHandler() -> None
    
    This is the image handler for the PNG format.
    """

    def __init__(self) -> None:
        """
        PNGHandler() -> None
        
        This is the image handler for the PNG format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class PNGHandler


class PNMHandler(ImageHandler):
    """
    PNMHandler() -> None
    
    This is the image handler for the PNM format.
    """

    def __init__(self) -> None:
        """
        PNMHandler() -> None
        
        This is the image handler for the PNM format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class PNMHandler


class TGAHandler(ImageHandler):
    """
    TGAHandler() -> None
    
    This is the image handler for the TGA format.
    """

    def __init__(self) -> None:
        """
        TGAHandler() -> None
        
        This is the image handler for the TGA format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class TGAHandler


class XPMHandler(ImageHandler):
    """
    XPMHandler() -> None
    
    This is the image handler for the XPM format.
    """

    def __init__(self) -> None:
        """
        XPMHandler() -> None
        
        This is the image handler for the XPM format.
        """

    def LoadFile(self, image: Image, stream: InputStream, verbose: bool=True, index: int=-1) -> bool:
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads an image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image: Image, stream: OutputStream, verbose: bool=True) -> bool:
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves an image in the output stream.
        """

    def DoCanRead(self, stream: InputStream) -> bool:
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class XPMHandler


def InitAllImageHandlers() -> None:    """
    InitAllImageHandlers() -> None
    
    Initializes all available image handlers.
    """
NullImage: Image

@wx.deprecated
def EmptyImage(width=0, height=0, clear=True):
    """
    A compatibility wrapper for the wx.Image(width, height) constructor
    """
    pass

@wx.deprecated
def ImageFromBitmap(bitmap):
    """
    Create a :class:`Image` from a :class:`wx.Bitmap`
    """
    pass

@wx.deprecated
def ImageFromStream(stream, type=BITMAP_TYPE_ANY, index=-1):
    """
    Load an image from a stream (file-like object)
    """
    pass

@wx.deprecated
def ImageFromData(width, height, data):
    """
    Compatibility wrapper for creating an image from RGB data
    """
    pass

@wx.deprecated
def ImageFromDataWithAlpha(width, height, data, alpha):
    """
    Compatibility wrapper for creating an image from RGB and Alpha data
    """
    pass

def ImageFromBuffer(width, height, dataBuffer, alphaBuffer=None):
    """
    Creates a :class:`Image` from the data in `dataBuffer`.  The `dataBuffer`
    parameter must be a Python object that implements the buffer interface,
    such as a string, array, etc.  The `dataBuffer` object is expected to
    contain a series of RGB bytes and be width*height*3 bytes long.  A buffer
    object can optionally be supplied for the image's alpha channel data, and
    it is expected to be width*height bytes long.
    
    The :class:`Image` will be created with its data and alpha pointers initialized
    to the memory address pointed to by the buffer objects, thus saving the
    time needed to copy the image data from the buffer object to the :class:`Image`.
    While this has advantages, it also has the shoot-yourself-in-the-foot
    risks associated with sharing a C pointer between two objects.
    
    To help alleviate the risk a reference to the data and alpha buffer
    objects are kept with the :class:`Image`, so that they won't get deleted until
    after the wx.Image is deleted.  However please be aware that it is not
    guaranteed that an object won't move its memory buffer to a new location
    when it needs to resize its contents.  If that happens then the :class:`Image`
    will end up referring to an invalid memory location and could cause the
    application to crash.  Therefore care should be taken to not manipulate
    the objects used for the data and alpha buffers in a way that would cause
    them to change size.
    """
    pass

IMAGE_OPTION_QUALITY = "quality"
IMAGE_OPTION_FILENAME = "FileName"
IMAGE_OPTION_RESOLUTION = "Resolution"
IMAGE_OPTION_RESOLUTIONX = "ResolutionX"
IMAGE_OPTION_RESOLUTIONY = "ResolutionY"
IMAGE_OPTION_RESOLUTIONUNIT = "ResolutionUnit"
IMAGE_OPTION_MAX_WIDTH = "MaxWidth"
IMAGE_OPTION_MAX_HEIGHT = "MaxHeight"
IMAGE_OPTION_ORIGINAL_WIDTH = "OriginalWidth"
IMAGE_OPTION_ORIGINAL_HEIGHT = "OriginalHeight"
IMAGE_OPTION_BMP_FORMAT = "wxBMP_FORMAT"
IMAGE_OPTION_CUR_HOTSPOT_X = "HotSpotX"
IMAGE_OPTION_CUR_HOTSPOT_Y = "HotSpotY"
IMAGE_OPTION_GIF_COMMENT = "GifComment"
IMAGE_OPTION_GIF_TRANSPARENCY = "Transparency"
IMAGE_OPTION_GIF_TRANSPARENCY_HIGHLIGHT = "Highlight"
IMAGE_OPTION_GIF_TRANSPARENCY_UNCHANGED = "Unchanged"
IMAGE_OPTION_PNG_FORMAT = "PngFormat"
IMAGE_OPTION_PNG_BITDEPTH = "PngBitDepth"
IMAGE_OPTION_PNG_FILTER = "PngF"
IMAGE_OPTION_PNG_COMPRESSION_LEVEL = "PngZL"
IMAGE_OPTION_PNG_COMPRESSION_MEM_LEVEL = "PngZM"
IMAGE_OPTION_PNG_COMPRESSION_STRATEGY = "PngZS"
IMAGE_OPTION_PNG_COMPRESSION_BUFFER_SIZE = "PngZB"
IMAGE_OPTION_TIFF_BITSPERSAMPLE = "BitsPerSample"
IMAGE_OPTION_TIFF_SAMPLESPERPIXEL = "SamplesPerPixel"
IMAGE_OPTION_TIFF_COMPRESSION = "Compression"
IMAGE_OPTION_TIFF_PHOTOMETRIC = "Photometric"
IMAGE_OPTION_TIFF_IMAGEDESCRIPTOR = "ImageDescriptor"
IMAGE_OPTION_TIFF_BITSPERSAMPLE = "BitsPerSample"
IMAGE_OPTION_TIFF_SAMPLESPERPIXEL = "SamplesPerPixel"
IMAGE_OPTION_TIFF_COMPRESSION = "Compression"
IMAGE_OPTION_TIFF_PHOTOMETRIC = "Photometric"
IMAGE_OPTION_TIFF_IMAGEDESCRIPTOR = "ImageDescriptor"
IMAGE_OPTION_GIF_COMMENT = "GifComment"
IMAGE_OPTION_PNG_FORMAT = "PngFormat"
IMAGE_OPTION_PNG_BITDEPTH = "PngBitDepth"
IMAGE_OPTION_PNG_FILTER = "PngF"
IMAGE_OPTION_PNG_COMPRESSION_LEVEL = "PngZL"
IMAGE_OPTION_PNG_COMPRESSION_MEM_LEVEL = "PngZM"
IMAGE_OPTION_PNG_COMPRESSION_STRATEGY = "PngZS"
IMAGE_OPTION_PNG_COMPRESSION_BUFFER_SIZE = "PngZB"
#-- end-image --#
#-- begin-gdiobj --#

class GDIObject(Object):
    """
    GDIObject() -> None
    
    This class allows platforms to implement functionality to optimise GDI
    objects, such as wxPen, wxBrush and wxFont.
    """

    def __init__(self) -> None:
        """
        GDIObject() -> None
        
        This class allows platforms to implement functionality to optimise GDI
        objects, such as wxPen, wxBrush and wxFont.
        """
# end of class GDIObject

#-- end-gdiobj --#
#-- begin-bitmap --#

class _BitmapBufferFormat(IntEnum):
    BitmapBufferFormat_RGB = auto()
    BitmapBufferFormat_RGBA = auto()
    BitmapBufferFormat_RGB32 = auto()
    BitmapBufferFormat_ARGB32 = auto()
BitmapBufferFormat: TypeAlias = Union[_BitmapBufferFormat, int]
BitmapBufferFormat_RGB = _BitmapBufferFormat.BitmapBufferFormat_RGB
BitmapBufferFormat_RGBA = _BitmapBufferFormat.BitmapBufferFormat_RGBA
BitmapBufferFormat_RGB32 = _BitmapBufferFormat.BitmapBufferFormat_RGB32
BitmapBufferFormat_ARGB32 = _BitmapBufferFormat.BitmapBufferFormat_ARGB32
BITMAP_SCREEN_DEPTH: int

class Bitmap(GDIObject):
    """
    Bitmap() -> None
    Bitmap(bitmap) -> None
    Bitmap(bits, width, height, depth=1) -> None
    Bitmap(width, height, depth=BITMAP_SCREEN_DEPTH) -> None
    Bitmap(sz, depth=BITMAP_SCREEN_DEPTH) -> None
    Bitmap(width, height, dc) -> None
    Bitmap(name, type=BITMAP_TYPE_ANY) -> None
    Bitmap(img, depth=BITMAP_SCREEN_DEPTH) -> None
    Bitmap(img, dc) -> None
    Bitmap(listOfBytes) -> None
    
    This class encapsulates the concept of a platform-dependent bitmap,
    either monochrome or colour or colour with alpha channel support.
    """

    @overload
    def __init__(self, bitmap: Bitmap) -> None:
        ...

    @overload
    def __init__(self, bits: str, width: int, height: int, depth: int=1) -> None:
        ...

    @overload
    def __init__(self, width: int, height: int, depth: int=BITMAP_SCREEN_DEPTH) -> None:
        ...

    @overload
    def __init__(self, sz: Size, depth: int=BITMAP_SCREEN_DEPTH) -> None:
        ...

    @overload
    def __init__(self, width: int, height: int, dc: DC) -> None:
        ...

    @overload
    def __init__(self, name: str, type: BitmapType=BITMAP_TYPE_ANY) -> None:
        ...

    @overload
    def __init__(self, img: Image, depth: int=BITMAP_SCREEN_DEPTH) -> None:
        ...

    @overload
    def __init__(self, img: Image, dc: DC) -> None:
        ...

    @overload
    def __init__(self, listOfBytes: Any) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Bitmap() -> None
        Bitmap(bitmap) -> None
        Bitmap(bits, width, height, depth=1) -> None
        Bitmap(width, height, depth=BITMAP_SCREEN_DEPTH) -> None
        Bitmap(sz, depth=BITMAP_SCREEN_DEPTH) -> None
        Bitmap(width, height, dc) -> None
        Bitmap(name, type=BITMAP_TYPE_ANY) -> None
        Bitmap(img, depth=BITMAP_SCREEN_DEPTH) -> None
        Bitmap(img, dc) -> None
        Bitmap(listOfBytes) -> None
        
        This class encapsulates the concept of a platform-dependent bitmap,
        either monochrome or colour or colour with alpha channel support.
        """

    def ConvertToDisabled(self, brightness: int=255) -> Bitmap:
        """
        ConvertToDisabled(brightness=255) -> Bitmap
        
        Returns disabled (dimmed) version of the bitmap.
        """

    def ConvertToImage(self) -> Image:
        """
        ConvertToImage() -> Image
        
        Creates an image from a platform-dependent bitmap.
        """

    def CopyFromIcon(self, icon: Icon) -> bool:
        """
        CopyFromIcon(icon) -> bool
        
        Creates the bitmap from an icon.
        """

    @overload
    def Create(self, sz: Size, depth: int=BITMAP_SCREEN_DEPTH) -> bool:
        ...

    @overload
    def Create(self, width: int, height: int, dc: DC) -> bool:
        ...

    @overload
    def Create(self, width: int, height: int, depth: int=BITMAP_SCREEN_DEPTH) -> bool:
        """
        Create(width, height, depth=BITMAP_SCREEN_DEPTH) -> bool
        Create(sz, depth=BITMAP_SCREEN_DEPTH) -> bool
        Create(width, height, dc) -> bool
        
        Creates a fresh bitmap.
        """

    @overload
    def CreateWithDIPSize(self, width: int, height: int, scale: float, depth: int=BITMAP_SCREEN_DEPTH) -> bool:
        ...

    @overload
    def CreateWithDIPSize(self, size: Size, scale: float, depth: int=BITMAP_SCREEN_DEPTH) -> bool:
        """
        CreateWithDIPSize(size, scale, depth=BITMAP_SCREEN_DEPTH) -> bool
        CreateWithDIPSize(width, height, scale, depth=BITMAP_SCREEN_DEPTH) -> bool
        
        Create a bitmap specifying its size in DPI-independent pixels and the
        scale factor to use.
        """

    def CreateScaled(self, width: int, height: int, depth: int, logicalScale: float) -> bool:
        """
        CreateScaled(width, height, depth, logicalScale) -> bool
        
        Create a bitmap with a scale factor.
        """

    def GetDepth(self) -> int:
        """
        GetDepth() -> int
        
        Gets the colour depth of the bitmap.
        """

    def GetDIPSize(self) -> Size:
        """
        GetDIPSize() -> Size
        
        Returns the size of bitmap in DPI-independent units.
        """

    def GetHeight(self) -> int:
        """
        GetHeight() -> int
        
        Returns the height of the bitmap in physical pixels.
        """

    def GetLogicalHeight(self) -> float:
        """
        GetLogicalHeight() -> float
        
        Returns the height of the bitmap in logical pixels.
        """

    def GetLogicalSize(self) -> Size:
        """
        GetLogicalSize() -> Size
        
        Returns the size of the bitmap in logical pixels.
        """

    def GetLogicalWidth(self) -> float:
        """
        GetLogicalWidth() -> float
        
        Returns the width of the bitmap in logical pixels.
        """

    def GetMask(self) -> Mask:
        """
        GetMask() -> Mask
        
        Gets the associated mask (if any) which may have been loaded from a
        file or set for the bitmap.
        """

    def GetPalette(self) -> Palette:
        """
        GetPalette() -> Palette
        
        Gets the associated palette (if any) which may have been loaded from a
        file or set for the bitmap.
        """

    def GetSubBitmap(self, rect: Rect) -> Bitmap:
        """
        GetSubBitmap(rect) -> Bitmap
        
        Returns a sub bitmap of the current one as long as the rect belongs
        entirely to the bitmap.
        """

    def GetScaleFactor(self) -> float:
        """
        GetScaleFactor() -> float
        
        Returns the scale factor of this bitmap.
        """

    def GetScaledHeight(self) -> float:
        """
        GetScaledHeight() -> float
        
        Returns the height of the bitmap in logical pixels.
        """

    def GetScaledSize(self) -> Size:
        """
        GetScaledSize() -> Size
        
        Returns the size of the bitmap in logical pixels.
        """

    def GetScaledWidth(self) -> float:
        """
        GetScaledWidth() -> float
        
        Returns the width of the bitmap in logical pixels.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Returns the size of the bitmap in physical pixels.
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Returns the width of the bitmap in physical pixels.
        """

    def HasAlpha(self) -> bool:
        """
        HasAlpha() -> bool
        
        Returns true if the bitmap has an alpha channel.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if bitmap data is present.
        """

    def LoadFile(self, name: str, type: BitmapType=BITMAP_TYPE_ANY) -> bool:
        """
        LoadFile(name, type=BITMAP_TYPE_ANY) -> bool
        
        Loads a bitmap from a file or resource.
        """

    def ResetAlpha(self) -> None:
        """
        ResetAlpha() -> None
        
        Remove alpha channel from the bitmap.
        """

    def SaveFile(self, name: str, type: BitmapType, palette: Optional[Palette]=None) -> bool:
        """
        SaveFile(name, type, palette=None) -> bool
        
        Saves a bitmap in the named file.
        """

    def SetDepth(self, depth: int) -> None:
        """
        SetDepth(depth) -> None
        """

    def SetHeight(self, height: int) -> None:
        """
        SetHeight(height) -> None
        """

    def SetScaleFactor(self, scale: float) -> None:
        """
        SetScaleFactor(scale) -> None
        
        Sets the bitmap scale factor.
        """

    def SetMask(self, mask: Mask) -> None:
        """
        SetMask(mask) -> None
        
        Sets the mask for this bitmap.
        """

    def SetPalette(self, palette: Palette) -> None:
        """
        SetPalette(palette) -> None
        
        Sets the associated palette.
        """

    def SetWidth(self, width: int) -> None:
        """
        SetWidth(width) -> None
        """

    def UseAlpha(self, use: bool=True) -> None:
        """
        UseAlpha(use=True) -> None
        
        Enable or disable use of alpha channel in this bitmap.
        """

    @staticmethod
    def NewFromPNGData(data: Any, size: int) -> Bitmap:
        """
        NewFromPNGData(data, size) -> Bitmap
        
        Loads a bitmap from the memory containing image data in PNG format.
        """

    @staticmethod
    def Rescale(bmp: Bitmap, sizeNeeded: Size) -> None:
        """
        Rescale(bmp, sizeNeeded) -> None
        
        Rescale the given bitmap to the requested size.
        """

    def SetMaskColour(self, colour: Colour) -> None:
        """
        SetMaskColour(colour) -> None
        
        Create a mask for this bitmap based on the pixels with the given
        colour.
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def GetHandle(self) -> int:
        """
        GetHandle() -> int
        
        MSW-only method to fetch the windows handle for the bitmap.
        """

    def SetHandle(self, handle: int) -> None:
        """
        SetHandle(handle) -> None
        
        MSW-only method to set the windows handle for the bitmap.
        """

    def SetSize(self, size: Size) -> None:
        """
        SetSize(size) -> None
        
        Set the bitmap size (does not alter the existing native bitmap data or
        image size).
        """

    def CopyFromBuffer(self, data: PyBuffer, format: BitmapBufferFormat=BitmapBufferFormat_RGB, stride: int=-1) -> None:
        """
        CopyFromBuffer(data, format=BitmapBufferFormat_RGB, stride=-1) -> None
        
        Copy data from a buffer object to replace the bitmap pixel data.
        Default format is plain RGB, but other formats are now supported as
        well.  The following symbols are used to specify the format of the
        bytes in the buffer:
        
            =============================  ================================
            wx.BitmapBufferFormat_RGB      A simple sequence of RGB bytes
            wx.BitmapBufferFormat_RGBA     A simple sequence of RGBA bytes
            wx.BitmapBufferFormat_ARGB32   A sequence of 32-bit values in
        native endian order, with alpha in the upper 8 bits, followed by red,
        green, and blue.
            wx.BitmapBufferFormat_RGB32    Same as above but the alpha byte is
        ignored.
            =============================  ================================
        """

    def CopyToBuffer(self, data: PyBuffer, format: BitmapBufferFormat=BitmapBufferFormat_RGB, stride: int=-1) -> None:
        """
        CopyToBuffer(data, format=BitmapBufferFormat_RGB, stride=-1) -> None
        
        Copy pixel data to a buffer object.  See :meth:`CopyFromBuffer` for
        buffer
        format details.
        """

    @staticmethod
    def FromBufferAndAlpha(width: int, height: int, data: PyBuffer, alpha: PyBuffer) -> Bitmap:
        """
        FromBufferAndAlpha(width, height, data, alpha) -> Bitmap
        
        Creates a :class:`wx.Bitmap` from in-memory data.  The data and alpha
        parameters must be a Python object that implements the buffer
        interface, such as a string, bytearray, etc.  The data object
        is expected to contain a series of RGB bytes and be at least
        ``(width * height * 3)`` bytes long, while the alpha object is
        expected
        to be ``(width * height)`` bytes long and represents the image's alpha
        channel.  On Windows and Mac the RGB values will be
        'premultiplied' by the alpha values.  (The other platforms do
        the multiplication themselves.)
        
        Unlike :func:`wx.ImageFromBuffer` the bitmap created with this
        function
        does not share the memory block with the buffer object.  This is
        because the native pixel buffer format varies on different
        platforms, and so instead an efficient as possible copy of the
        data is made from the buffer object to the bitmap's native pixel
        buffer.
        """

    @staticmethod
    def FromBuffer(width: int, height: int, data: PyBuffer) -> Bitmap:
        """
        FromBuffer(width, height, data) -> Bitmap
        
        Creates a :class:`wx.Bitmap` from in-memory data.  The data parameter
        must be a Python object that implements the buffer interface, such
        as a string, bytearray, etc.  The data object is expected to contain
        a series of RGB bytes and be at least ``(width * height * 3)`` bytes
        long.
        
        Unlike :func:`wx.ImageFromBuffer` the bitmap created with this
        function
        does not share the memory block with the buffer object.  This is
        because the native pixel buffer format varies on different
        platforms, and so instead an efficient as possible copy of the
        data is made from the buffer object to the bitmap's native pixel
        buffer.
        """

    @staticmethod
    def FromBufferRGBA(width: int, height: int, data: PyBuffer) -> Bitmap:
        """
        FromBufferRGBA(width, height, data) -> Bitmap
        
        Creates a :class:`wx.Bitmap` from in-memory data.  The data parameter
        must be a Python object that implements the buffer interface, such
        as a string, bytearray, etc.  The data object is expected to contain
        a series of RGBA bytes and be at least ``(width * height * 4)`` bytes
        long.
        On Windows and Mac the RGB values will be 'premultiplied' by the
        alpha values.  (The other platforms do the multiplication themselves.)
        
        Unlike :func:`wx.ImageFromBuffer` the bitmap created with this
        function
        does not share the memory block with the buffer object.  This is
        because the native pixel buffer format varies on different
        platforms, and so instead an efficient as possible copy of the
        data is made from the buffer object to the bitmap's native pixel
        buffer.
        """

    @staticmethod
    def FromRGBA(width: int, height: int, red: int=0, green: int=0, blue: int=0, alpha: int=0) -> Bitmap:
        """
        FromRGBA(width, height, red=0, green=0, blue=0, alpha=0) -> Bitmap
        
        Creates a new empty 32-bit :class:`wx.Bitmap` where every pixel has
        been
        initialized with the given RGBA values.
        """

    @staticmethod
    def FromPNGData(data: PyBuffer) -> Bitmap:
        """
        FromPNGData(data) -> Bitmap
        
        Like :meth:`NewFromPNGData`, but with a simpler API accepting a Python
        buffer-compatible object.
        """
    @property
    def DIPSize(self) -> Size: ...
    @property
    def Depth(self) -> int: ...
    @Depth.setter
    def Depth(self, value: int, /) -> None: ...
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int, /) -> None: ...
    @property
    def Height(self) -> int: ...
    @Height.setter
    def Height(self, value: int, /) -> None: ...
    @property
    def LogicalHeight(self) -> float: ...
    @property
    def LogicalSize(self) -> Size: ...
    @property
    def LogicalWidth(self) -> float: ...
    @property
    def Mask(self) -> Mask: ...
    @Mask.setter
    def Mask(self, value: Mask, /) -> None: ...
    @property
    def Palette(self) -> Palette: ...
    @Palette.setter
    def Palette(self, value: Palette, /) -> None: ...
    @property
    def ScaleFactor(self) -> float: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float, /) -> None: ...
    @property
    def ScaledHeight(self) -> float: ...
    @property
    def ScaledSize(self) -> Size: ...
    @property
    def ScaledWidth(self) -> float: ...
    @property
    def Size(self) -> Size: ...
    @Size.setter
    def Size(self, value: Size, /) -> None: ...
    @property
    def Width(self) -> int: ...
    @Width.setter
    def Width(self, value: int, /) -> None: ...
# end of class Bitmap


class Mask(Object):
    """
    Mask() -> None
    Mask(bitmap, index) -> None
    Mask(bitmap) -> None
    Mask(bitmap, colour) -> None
    
    This class encapsulates a monochrome mask bitmap, where the masked
    area is black and the unmasked area is white.
    """

    @overload
    def __init__(self, bitmap: Bitmap, index: int) -> None:
        ...

    @overload
    def __init__(self, bitmap: Bitmap) -> None:
        ...

    @overload
    def __init__(self, bitmap: Bitmap, colour: Colour) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Mask() -> None
        Mask(bitmap, index) -> None
        Mask(bitmap) -> None
        Mask(bitmap, colour) -> None
        
        This class encapsulates a monochrome mask bitmap, where the masked
        area is black and the unmasked area is white.
        """

    def GetBitmap(self) -> Bitmap:
        """
        GetBitmap() -> Bitmap
        
        Returns the mask as a monochrome bitmap.
        """
    @property
    def Bitmap(self) -> Bitmap: ...
# end of class Mask

NullBitmap: Bitmap

@wx.deprecated
def BitmapFromBuffer(width, height, dataBuffer, alphaBuffer=None):
    """
    A compatibility wrapper for :meth:`wx.Bitmap.FromBuffer` and :meth:`wx.Bitmap.FromBufferAndAlpha`
    """
    pass

@wx.deprecated
def BitmapFromBufferRGBA(width, height, dataBuffer):
    """
    A compatibility wrapper for :meth:`wx.Bitmap.FromBufferRGBA`
    """
    pass

@wx.deprecated
def EmptyBitmapRGBA(width, height, red=0, green=0, blue=0, alpha=0):
    """
    A compatibility wrapper for :meth:`wx.Bitmap.FromRGBA`
    """
    pass

@wx.deprecated
def EmptyBitmap(width, height, depth=BITMAP_SCREEN_DEPTH):
    """
    A compatibility wrapper for the wx.Bitmap(width, height, depth) constructor
    """
    pass

@wx.deprecated
def BitmapFromImage(image):
    """
    A compatibility wrapper for the wx.Bitmap(wx.Image) constructor
    """
    pass
#-- end-bitmap --#
#-- begin-bmpbndl --#

class BitmapBundle:
    """
    BitmapBundle() -> None
    BitmapBundle(bitmap) -> None
    BitmapBundle(icon) -> None
    BitmapBundle(image) -> None
    BitmapBundle(other) -> None
    
    Contains representations of the same bitmap in different resolutions.
    """

    @overload
    def __init__(self, bitmap: Bitmap) -> None:
        ...

    @overload
    def __init__(self, icon: Icon) -> None:
        ...

    @overload
    def __init__(self, image: Image) -> None:
        ...

    @overload
    def __init__(self, other: Union[BitmapBundle, wx.Bitmap, wx.Icon]) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        BitmapBundle() -> None
        BitmapBundle(bitmap) -> None
        BitmapBundle(icon) -> None
        BitmapBundle(image) -> None
        BitmapBundle(other) -> None
        
        Contains representations of the same bitmap in different resolutions.
        """

    def Clear(self) -> None:
        """
        Clear() -> None
        
        Clear the existing bundle contents.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Check if bitmap bundle is non-empty.
        """

    def GetDefaultSize(self) -> Size:
        """
        GetDefaultSize() -> Size
        
        Get the size of the bitmap represented by this bundle in default
        resolution or, equivalently, at 100% scaling.
        """

    def GetPreferredBitmapSizeAtScale(self, scale: float) -> Size:
        """
        GetPreferredBitmapSizeAtScale(scale) -> Size
        
        Get the size that would be best to use for this bundle at the given
        DPI scaling factor.
        """

    def GetPreferredBitmapSizeFor(self, window: Window) -> Size:
        """
        GetPreferredBitmapSizeFor(window) -> Size
        
        Get the size that would be best to use for this bundle at the DPI
        scaling factor used by the given window.
        """

    def GetPreferredLogicalSizeFor(self, window: Window) -> Size:
        """
        GetPreferredLogicalSizeFor(window) -> Size
        
        Get the size that would be best to use for this bundle at the DPI
        scaling factor used by the given window in logical size.
        """

    def GetBitmap(self, size: Size) -> Bitmap:
        """
        GetBitmap(size) -> Bitmap
        
        Get bitmap of the specified size, creating a new bitmap from the
        closest available size by rescaling it if necessary.
        """

    def GetBitmapFor(self, window: Window) -> Bitmap:
        """
        GetBitmapFor(window) -> Bitmap
        
        Get bitmap of the size appropriate for the DPI scaling used by the
        given window.
        """

    def GetIcon(self, size: Size) -> Icon:
        """
        GetIcon(size) -> Icon
        
        Get icon of the specified size.
        """

    def GetIconFor(self, window: Window) -> Icon:
        """
        GetIconFor(window) -> Icon
        
        Get icon of the size appropriate for the DPI scaling used by the given
        window.
        """

    def IsSameAs(self, other: Union[BitmapBundle, wx.Bitmap, wx.Icon]) -> bool:
        """
        IsSameAs(other) -> bool
        
        Check if the two bundles refer to the same object.
        """

    @overload
    @staticmethod
    def FromBitmaps(bitmap1: Bitmap, bitmap2: Bitmap) -> BitmapBundle:
        ...

    @overload
    @staticmethod
    def FromBitmaps(bitmaps: VectorwxBitmap) -> BitmapBundle:
        """
        FromBitmaps(bitmaps) -> BitmapBundle
        FromBitmaps(bitmap1, bitmap2) -> BitmapBundle
        
        Create a bundle from the given collection of bitmaps.
        """

    @staticmethod
    def FromBitmap(bitmap: Bitmap) -> BitmapBundle:
        """
        FromBitmap(bitmap) -> BitmapBundle
        
        Create a bundle from a single bitmap.
        """

    @staticmethod
    def FromIconBundle(iconBundle: IconBundle) -> BitmapBundle:
        """
        FromIconBundle(iconBundle) -> BitmapBundle
        
        Create a bundle from an icon bundle.
        """

    @staticmethod
    def FromImage(image: Image) -> BitmapBundle:
        """
        FromImage(image) -> BitmapBundle
        
        Create a bundle from a single image.
        """

    @staticmethod
    def FromImpl(impl: BitmapBundleImpl) -> BitmapBundle:
        """
        FromImpl(impl) -> BitmapBundle
        
        Create a bundle from a custom bitmap bundle implementation.
        """

    @staticmethod
    def FromResources(name: str) -> BitmapBundle:
        """
        FromResources(name) -> BitmapBundle
        
        Create a bundle from the bitmaps in the application resources.
        """

    @overload
    @staticmethod
    def FromFiles(fullpathname: str) -> BitmapBundle:
        ...

    @overload
    @staticmethod
    def FromFiles(path: str, filename: str, extension: str="png") -> BitmapBundle:
        """
        FromFiles(path, filename, extension="png") -> BitmapBundle
        FromFiles(fullpathname) -> BitmapBundle
        
        Create a bundle from bitmaps stored as files.
        """

    @overload
    @staticmethod
    def FromSVG(data: Byte, len: int, sizeDef: Size) -> BitmapBundle:
        ...

    @overload
    @staticmethod
    def FromSVG(data: str, sizeDef: Size) -> BitmapBundle:
        """
        FromSVG(data, sizeDef) -> BitmapBundle
        FromSVG(data, len, sizeDef) -> BitmapBundle
        
        This is an overloaded member function, provided for convenience. It
        differs from the above function only in what argument(s) it accepts.
        """

    @staticmethod
    def FromSVGFile(path: str, sizeDef: Size) -> BitmapBundle:
        """
        FromSVGFile(path, sizeDef) -> BitmapBundle
        
        Create a bundle from the SVG image loaded from the given file.
        """

    @staticmethod
    def FromSVGResource(name: str, sizeDef: Size) -> BitmapBundle:
        """
        FromSVGResource(name, sizeDef) -> BitmapBundle
        
        Create a bundle from the SVG image loaded from an application
        resource.
        """
    @property
    def DefaultSize(self) -> Size: ...
# end of class BitmapBundle


class BitmapBundleImpl(RefCounter):
    """
    Base class for custom implementations of wxBitmapBundle.
    """

    def GetDefaultSize(self) -> Size:
        """
        GetDefaultSize() -> Size
        
        Return the size of the bitmaps represented by this bundle in the
        default DPI.
        """

    def GetPreferredBitmapSizeAtScale(self, scale: float) -> Size:
        """
        GetPreferredBitmapSizeAtScale(scale) -> Size
        
        Return the preferred size that should be used at the given scale.
        """

    def GetBitmap(self, size: Size) -> Bitmap:
        """
        GetBitmap(size) -> Bitmap
        
        Retrieve the bitmap of exactly the given size.
        """
    @property
    def DefaultSize(self) -> Size: ...

    def DoGetPreferredSize(self, scale: float) -> Size:
        """
        DoGetPreferredSize(scale) -> Size
        
        Helper for implementing GetPreferredBitmapSizeAtScale() in the derived
        classes.
        """

    def GetIndexToUpscale(self, size: Size) -> int:
        """
        GetIndexToUpscale(size) -> int
        
        Return the index of the available scale most suitable to be upscaled
        to the given size.
        """

    def GetNextAvailableScale(self, idx: int) -> Tuple[float, int]:
        """
        GetNextAvailableScale(idx) -> Tuple[float, int]
        
        Return information about the available bitmaps.
        """
# end of class BitmapBundleImpl

#-- end-bmpbndl --#
#-- begin-icon --#
ICON_SCREEN_DEPTH: int

class Icon(GDIObject):
    """
    Icon() -> None
    Icon(icon) -> None
    Icon(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1) -> None
    Icon(loc) -> None
    Icon(bmp) -> None
    
    An icon is a small rectangular bitmap usually used for denoting a
    minimized application.
    """

    @overload
    def __init__(self, icon: Icon) -> None:
        ...

    @overload
    def __init__(self, name: str, type: BitmapType=BITMAP_TYPE_ANY, desiredWidth: int=-1, desiredHeight: int=-1) -> None:
        ...

    @overload
    def __init__(self, loc: IconLocation) -> None:
        ...

    @overload
    def __init__(self, bmp: Bitmap) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Icon() -> None
        Icon(icon) -> None
        Icon(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1) -> None
        Icon(loc) -> None
        Icon(bmp) -> None
        
        An icon is a small rectangular bitmap usually used for denoting a
        minimized application.
        """

    def CreateFromHICON(self, hicon: int) -> bool:
        """
        CreateFromHICON(hicon) -> bool
        
        MSW-only method to create a wx.Icon from a native icon handle.
        """

    def CopyFromBitmap(self, bmp: Bitmap) -> None:
        """
        CopyFromBitmap(bmp) -> None
        
        Copies bmp bitmap to this icon.
        """

    def GetDepth(self) -> int:
        """
        GetDepth() -> int
        
        Gets the colour depth of the icon.
        """

    def GetHeight(self) -> int:
        """
        GetHeight() -> int
        
        Gets the height of the icon in physical pixels.
        """

    def GetLogicalHeight(self) -> float:
        """
        GetLogicalHeight() -> float
        
        Gets the height of the icon in logical pixels.
        """

    def GetLogicalSize(self) -> Size:
        """
        GetLogicalSize() -> Size
        
        Gets the size of the icon in logical pixels.
        """

    def GetLogicalWidth(self) -> float:
        """
        GetLogicalWidth() -> float
        
        Gets the width of the icon in logical pixels.
        """

    def GetScaleFactor(self) -> float:
        """
        GetScaleFactor() -> float
        
        Gets the scale factor of this icon.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Gets the size of the icon in physical pixels.
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Gets the width of the icon in physical pixels.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if icon data is present.
        """

    def LoadFile(self, name: str, type: BitmapType=BITMAP_TYPE_ANY, desiredWidth: int=-1, desiredHeight: int=-1) -> bool:
        """
        LoadFile(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1) -> bool
        
        Loads an icon from a file or resource.
        """

    def SetDepth(self, depth: int) -> None:
        """
        SetDepth(depth) -> None
        """

    def SetHeight(self, height: int) -> None:
        """
        SetHeight(height) -> None
        """

    def SetWidth(self, width: int) -> None:
        """
        SetWidth(width) -> None
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def GetHandle(self) -> int:
        """
        GetHandle() -> int
        """

    def SetHandle(self, handle: int) -> None:
        """
        SetHandle(handle) -> None
        """
    @property
    def Depth(self) -> int: ...
    @Depth.setter
    def Depth(self, value: int, /) -> None: ...
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int, /) -> None: ...
    @property
    def Height(self) -> int: ...
    @Height.setter
    def Height(self, value: int, /) -> None: ...
    @property
    def LogicalHeight(self) -> float: ...
    @property
    def LogicalSize(self) -> Size: ...
    @property
    def LogicalWidth(self) -> float: ...
    @property
    def ScaleFactor(self) -> float: ...
    @property
    def Size(self) -> Size: ...
    @property
    def Width(self) -> int: ...
    @Width.setter
    def Width(self, value: int, /) -> None: ...
# end of class Icon

NullIcon: Icon

@wx.deprecated
def EmptyIcon():
    """
    A compatibility wrapper for the :class:`Icon` constructor
    """
    pass
#-- end-icon --#
#-- begin-iconloc --#

class IconLocation:
    """
    IconLocation() -> None
    IconLocation(filename, num=0) -> None
    
    wxIconLocation is a tiny class describing the location of an
    (external, i.e.
    """

    @overload
    def __init__(self, filename: str, num: int=0) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        IconLocation() -> None
        IconLocation(filename, num=0) -> None
        
        wxIconLocation is a tiny class describing the location of an
        (external, i.e.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the object is valid, i.e. was properly initialized,
        and false otherwise.
        """

    def SetFileName(self, filename: str) -> None:
        """
        SetFileName(filename) -> None
        """

    def GetFileName(self) -> str:
        """
        GetFileName() -> str
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def GetIndex(self) -> int:
        """
        GetIndex() -> int
        """

    def SetIndex(self, num: int) -> None:
        """
        SetIndex(num) -> None
        """
    @property
    def FileName(self) -> str: ...
    @FileName.setter
    def FileName(self, value: str, /) -> None: ...
    @property
    def Index(self) -> int: ...
    @Index.setter
    def Index(self, value: int, /) -> None: ...
# end of class IconLocation

#-- end-iconloc --#
#-- begin-iconbndl --#

class IconBundle(GDIObject):
    """
    IconBundle() -> None
    IconBundle(file, type=BITMAP_TYPE_ANY) -> None
    IconBundle(stream, type=BITMAP_TYPE_ANY) -> None
    IconBundle(icon) -> None
    IconBundle(ic) -> None
    
    This class contains multiple copies of an icon in different sizes.
    """

    class _enum_(IntEnum):
        FALLBACK_NONE = auto()
        FALLBACK_SYSTEM = auto()
        FALLBACK_NEAREST_LARGER = auto()
    FALLBACK_NONE = _enum_.FALLBACK_NONE
    FALLBACK_SYSTEM = _enum_.FALLBACK_SYSTEM
    FALLBACK_NEAREST_LARGER = _enum_.FALLBACK_NEAREST_LARGER

    @overload
    def __init__(self, file: str, type: BitmapType=BITMAP_TYPE_ANY) -> None:
        ...

    @overload
    def __init__(self, stream: InputStream, type: BitmapType=BITMAP_TYPE_ANY) -> None:
        ...

    @overload
    def __init__(self, icon: Icon) -> None:
        ...

    @overload
    def __init__(self, ic: IconBundle) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        IconBundle() -> None
        IconBundle(file, type=BITMAP_TYPE_ANY) -> None
        IconBundle(stream, type=BITMAP_TYPE_ANY) -> None
        IconBundle(icon) -> None
        IconBundle(ic) -> None
        
        This class contains multiple copies of an icon in different sizes.
        """

    @overload
    def AddIcon(self, stream: InputStream, type: BitmapType=BITMAP_TYPE_ANY) -> None:
        ...

    @overload
    def AddIcon(self, icon: Icon) -> None:
        ...

    @overload
    def AddIcon(self, file: str, type: BitmapType=BITMAP_TYPE_ANY) -> None:
        """
        AddIcon(file, type=BITMAP_TYPE_ANY) -> None
        AddIcon(stream, type=BITMAP_TYPE_ANY) -> None
        AddIcon(icon) -> None
        
        Adds all the icons contained in the file to the bundle; if the
        collection already contains icons with the same width and height, they
        are replaced by the new ones.
        """

    @overload
    def GetIcon(self, size: int=DefaultCoord, flags: int=FALLBACK_SYSTEM) -> Icon:
        ...

    @overload
    def GetIcon(self, size: Size, flags: int=FALLBACK_SYSTEM) -> Icon:
        """
        GetIcon(size, flags=FALLBACK_SYSTEM) -> Icon
        GetIcon(size=DefaultCoord, flags=FALLBACK_SYSTEM) -> Icon
        
        Returns the icon with the given size.
        """

    def GetIconOfExactSize(self, size: Size) -> Icon:
        """
        GetIconOfExactSize(size) -> Icon
        
        Returns the icon with exactly the given size or wxNullIcon if this
        size is not available.
        """

    def GetIconCount(self) -> int:
        """
        GetIconCount() -> int
        
        return the number of available icons
        """

    def GetIconByIndex(self, n: int) -> Icon:
        """
        GetIconByIndex(n) -> Icon
        
        return the icon at index (must be < GetIconCount())
        """

    def IsEmpty(self) -> bool:
        """
        IsEmpty() -> bool
        
        Returns true if the bundle doesn't contain any icons, false otherwise
        (in which case a call to GetIcon() with default parameter should
        return a valid icon).
        """
    @property
    def Icon(self) -> Icon: ...
    @property
    def IconCount(self) -> int: ...
# end of class IconBundle

NullIconBundle: IconBundle
#-- end-iconbndl --#
#-- begin-font --#

class _FontFamily(IntEnum):
    FONTFAMILY_DEFAULT = auto()
    FONTFAMILY_DECORATIVE = auto()
    FONTFAMILY_ROMAN = auto()
    FONTFAMILY_SCRIPT = auto()
    FONTFAMILY_SWISS = auto()
    FONTFAMILY_MODERN = auto()
    FONTFAMILY_TELETYPE = auto()
    FONTFAMILY_MAX = auto()
    FONTFAMILY_UNKNOWN = auto()
FontFamily: TypeAlias = Union[_FontFamily, int]
FONTFAMILY_DEFAULT = _FontFamily.FONTFAMILY_DEFAULT
FONTFAMILY_DECORATIVE = _FontFamily.FONTFAMILY_DECORATIVE
FONTFAMILY_ROMAN = _FontFamily.FONTFAMILY_ROMAN
FONTFAMILY_SCRIPT = _FontFamily.FONTFAMILY_SCRIPT
FONTFAMILY_SWISS = _FontFamily.FONTFAMILY_SWISS
FONTFAMILY_MODERN = _FontFamily.FONTFAMILY_MODERN
FONTFAMILY_TELETYPE = _FontFamily.FONTFAMILY_TELETYPE
FONTFAMILY_MAX = _FontFamily.FONTFAMILY_MAX
FONTFAMILY_UNKNOWN = _FontFamily.FONTFAMILY_UNKNOWN

class _FontStyle(IntEnum):
    FONTSTYLE_NORMAL = auto()
    FONTSTYLE_ITALIC = auto()
    FONTSTYLE_SLANT = auto()
    FONTSTYLE_MAX = auto()
FontStyle: TypeAlias = Union[_FontStyle, int]
FONTSTYLE_NORMAL = _FontStyle.FONTSTYLE_NORMAL
FONTSTYLE_ITALIC = _FontStyle.FONTSTYLE_ITALIC
FONTSTYLE_SLANT = _FontStyle.FONTSTYLE_SLANT
FONTSTYLE_MAX = _FontStyle.FONTSTYLE_MAX

class _FontWeight(IntEnum):
    FONTWEIGHT_INVALID = auto()
    FONTWEIGHT_THIN = auto()
    FONTWEIGHT_EXTRALIGHT = auto()
    FONTWEIGHT_LIGHT = auto()
    FONTWEIGHT_NORMAL = auto()
    FONTWEIGHT_MEDIUM = auto()
    FONTWEIGHT_SEMIBOLD = auto()
    FONTWEIGHT_BOLD = auto()
    FONTWEIGHT_EXTRABOLD = auto()
    FONTWEIGHT_HEAVY = auto()
    FONTWEIGHT_EXTRAHEAVY = auto()
    FONTWEIGHT_MAX = auto()
FontWeight: TypeAlias = Union[_FontWeight, int]
FONTWEIGHT_INVALID = _FontWeight.FONTWEIGHT_INVALID
FONTWEIGHT_THIN = _FontWeight.FONTWEIGHT_THIN
FONTWEIGHT_EXTRALIGHT = _FontWeight.FONTWEIGHT_EXTRALIGHT
FONTWEIGHT_LIGHT = _FontWeight.FONTWEIGHT_LIGHT
FONTWEIGHT_NORMAL = _FontWeight.FONTWEIGHT_NORMAL
FONTWEIGHT_MEDIUM = _FontWeight.FONTWEIGHT_MEDIUM
FONTWEIGHT_SEMIBOLD = _FontWeight.FONTWEIGHT_SEMIBOLD
FONTWEIGHT_BOLD = _FontWeight.FONTWEIGHT_BOLD
FONTWEIGHT_EXTRABOLD = _FontWeight.FONTWEIGHT_EXTRABOLD
FONTWEIGHT_HEAVY = _FontWeight.FONTWEIGHT_HEAVY
FONTWEIGHT_EXTRAHEAVY = _FontWeight.FONTWEIGHT_EXTRAHEAVY
FONTWEIGHT_MAX = _FontWeight.FONTWEIGHT_MAX

class _FontSymbolicSize(IntEnum):
    FONTSIZE_XX_SMALL = auto()
    FONTSIZE_X_SMALL = auto()
    FONTSIZE_SMALL = auto()
    FONTSIZE_MEDIUM = auto()
    FONTSIZE_LARGE = auto()
    FONTSIZE_X_LARGE = auto()
    FONTSIZE_XX_LARGE = auto()
FontSymbolicSize: TypeAlias = Union[_FontSymbolicSize, int]
FONTSIZE_XX_SMALL = _FontSymbolicSize.FONTSIZE_XX_SMALL
FONTSIZE_X_SMALL = _FontSymbolicSize.FONTSIZE_X_SMALL
FONTSIZE_SMALL = _FontSymbolicSize.FONTSIZE_SMALL
FONTSIZE_MEDIUM = _FontSymbolicSize.FONTSIZE_MEDIUM
FONTSIZE_LARGE = _FontSymbolicSize.FONTSIZE_LARGE
FONTSIZE_X_LARGE = _FontSymbolicSize.FONTSIZE_X_LARGE
FONTSIZE_XX_LARGE = _FontSymbolicSize.FONTSIZE_XX_LARGE

class _FontFlag(IntEnum):
    FONTFLAG_DEFAULT = auto()
    FONTFLAG_ITALIC = auto()
    FONTFLAG_SLANT = auto()
    FONTFLAG_LIGHT = auto()
    FONTFLAG_BOLD = auto()
    FONTFLAG_ANTIALIASED = auto()
    FONTFLAG_NOT_ANTIALIASED = auto()
    FONTFLAG_UNDERLINED = auto()
    FONTFLAG_STRIKETHROUGH = auto()
    FONTFLAG_MASK = auto()
FontFlag: TypeAlias = Union[_FontFlag, int]
FONTFLAG_DEFAULT = _FontFlag.FONTFLAG_DEFAULT
FONTFLAG_ITALIC = _FontFlag.FONTFLAG_ITALIC
FONTFLAG_SLANT = _FontFlag.FONTFLAG_SLANT
FONTFLAG_LIGHT = _FontFlag.FONTFLAG_LIGHT
FONTFLAG_BOLD = _FontFlag.FONTFLAG_BOLD
FONTFLAG_ANTIALIASED = _FontFlag.FONTFLAG_ANTIALIASED
FONTFLAG_NOT_ANTIALIASED = _FontFlag.FONTFLAG_NOT_ANTIALIASED
FONTFLAG_UNDERLINED = _FontFlag.FONTFLAG_UNDERLINED
FONTFLAG_STRIKETHROUGH = _FontFlag.FONTFLAG_STRIKETHROUGH
FONTFLAG_MASK = _FontFlag.FONTFLAG_MASK

class _FontEncoding(IntEnum):
    FONTENCODING_SYSTEM = auto()
    FONTENCODING_DEFAULT = auto()
    FONTENCODING_ISO8859_1 = auto()
    FONTENCODING_ISO8859_2 = auto()
    FONTENCODING_ISO8859_3 = auto()
    FONTENCODING_ISO8859_4 = auto()
    FONTENCODING_ISO8859_5 = auto()
    FONTENCODING_ISO8859_6 = auto()
    FONTENCODING_ISO8859_7 = auto()
    FONTENCODING_ISO8859_8 = auto()
    FONTENCODING_ISO8859_9 = auto()
    FONTENCODING_ISO8859_10 = auto()
    FONTENCODING_ISO8859_11 = auto()
    FONTENCODING_ISO8859_12 = auto()
    FONTENCODING_ISO8859_13 = auto()
    FONTENCODING_ISO8859_14 = auto()
    FONTENCODING_ISO8859_15 = auto()
    FONTENCODING_ISO8859_MAX = auto()
    FONTENCODING_KOI8 = auto()
    FONTENCODING_KOI8_U = auto()
    FONTENCODING_ALTERNATIVE = auto()
    FONTENCODING_BULGARIAN = auto()
    FONTENCODING_CP437 = auto()
    FONTENCODING_CP850 = auto()
    FONTENCODING_CP852 = auto()
    FONTENCODING_CP855 = auto()
    FONTENCODING_CP866 = auto()
    FONTENCODING_CP874 = auto()
    FONTENCODING_CP932 = auto()
    FONTENCODING_CP936 = auto()
    FONTENCODING_CP949 = auto()
    FONTENCODING_CP950 = auto()
    FONTENCODING_CP1250 = auto()
    FONTENCODING_CP1251 = auto()
    FONTENCODING_CP1252 = auto()
    FONTENCODING_CP1253 = auto()
    FONTENCODING_CP1254 = auto()
    FONTENCODING_CP1255 = auto()
    FONTENCODING_CP1256 = auto()
    FONTENCODING_CP1257 = auto()
    FONTENCODING_CP1258 = auto()
    FONTENCODING_CP1361 = auto()
    FONTENCODING_CP12_MAX = auto()
    FONTENCODING_UTF7 = auto()
    FONTENCODING_UTF8 = auto()
    FONTENCODING_EUC_JP = auto()
    FONTENCODING_UTF16BE = auto()
    FONTENCODING_UTF16LE = auto()
    FONTENCODING_UTF32BE = auto()
    FONTENCODING_UTF32LE = auto()
    FONTENCODING_MACROMAN = auto()
    FONTENCODING_MACJAPANESE = auto()
    FONTENCODING_MACCHINESETRAD = auto()
    FONTENCODING_MACKOREAN = auto()
    FONTENCODING_MACARABIC = auto()
    FONTENCODING_MACHEBREW = auto()
    FONTENCODING_MACGREEK = auto()
    FONTENCODING_MACCYRILLIC = auto()
    FONTENCODING_MACDEVANAGARI = auto()
    FONTENCODING_MACGURMUKHI = auto()
    FONTENCODING_MACGUJARATI = auto()
    FONTENCODING_MACORIYA = auto()
    FONTENCODING_MACBENGALI = auto()
    FONTENCODING_MACTAMIL = auto()
    FONTENCODING_MACTELUGU = auto()
    FONTENCODING_MACKANNADA = auto()
    FONTENCODING_MACMALAJALAM = auto()
    FONTENCODING_MACSINHALESE = auto()
    FONTENCODING_MACBURMESE = auto()
    FONTENCODING_MACKHMER = auto()
    FONTENCODING_MACTHAI = auto()
    FONTENCODING_MACLAOTIAN = auto()
    FONTENCODING_MACGEORGIAN = auto()
    FONTENCODING_MACARMENIAN = auto()
    FONTENCODING_MACCHINESESIMP = auto()
    FONTENCODING_MACTIBETAN = auto()
    FONTENCODING_MACMONGOLIAN = auto()
    FONTENCODING_MACETHIOPIC = auto()
    FONTENCODING_MACCENTRALEUR = auto()
    FONTENCODING_MACVIATNAMESE = auto()
    FONTENCODING_MACARABICEXT = auto()
    FONTENCODING_MACSYMBOL = auto()
    FONTENCODING_MACDINGBATS = auto()
    FONTENCODING_MACTURKISH = auto()
    FONTENCODING_MACCROATIAN = auto()
    FONTENCODING_MACICELANDIC = auto()
    FONTENCODING_MACROMANIAN = auto()
    FONTENCODING_MACCELTIC = auto()
    FONTENCODING_MACGAELIC = auto()
    FONTENCODING_MACKEYBOARD = auto()
    FONTENCODING_ISO2022_JP = auto()
    FONTENCODING_MAX = auto()
    FONTENCODING_MACMIN = auto()
    FONTENCODING_MACMAX = auto()
    FONTENCODING_UTF16 = auto()
    FONTENCODING_UTF32 = auto()
    FONTENCODING_UNICODE = auto()
    FONTENCODING_GB2312 = auto()
    FONTENCODING_BIG5 = auto()
    FONTENCODING_SHIFT_JIS = auto()
    FONTENCODING_EUC_KR = auto()
    FONTENCODING_JOHAB = auto()
    FONTENCODING_VIETNAMESE = auto()
FontEncoding: TypeAlias = Union[_FontEncoding, int]
FONTENCODING_SYSTEM = _FontEncoding.FONTENCODING_SYSTEM
FONTENCODING_DEFAULT = _FontEncoding.FONTENCODING_DEFAULT
FONTENCODING_ISO8859_1 = _FontEncoding.FONTENCODING_ISO8859_1
FONTENCODING_ISO8859_2 = _FontEncoding.FONTENCODING_ISO8859_2
FONTENCODING_ISO8859_3 = _FontEncoding.FONTENCODING_ISO8859_3
FONTENCODING_ISO8859_4 = _FontEncoding.FONTENCODING_ISO8859_4
FONTENCODING_ISO8859_5 = _FontEncoding.FONTENCODING_ISO8859_5
FONTENCODING_ISO8859_6 = _FontEncoding.FONTENCODING_ISO8859_6
FONTENCODING_ISO8859_7 = _FontEncoding.FONTENCODING_ISO8859_7
FONTENCODING_ISO8859_8 = _FontEncoding.FONTENCODING_ISO8859_8
FONTENCODING_ISO8859_9 = _FontEncoding.FONTENCODING_ISO8859_9
FONTENCODING_ISO8859_10 = _FontEncoding.FONTENCODING_ISO8859_10
FONTENCODING_ISO8859_11 = _FontEncoding.FONTENCODING_ISO8859_11
FONTENCODING_ISO8859_12 = _FontEncoding.FONTENCODING_ISO8859_12
FONTENCODING_ISO8859_13 = _FontEncoding.FONTENCODING_ISO8859_13
FONTENCODING_ISO8859_14 = _FontEncoding.FONTENCODING_ISO8859_14
FONTENCODING_ISO8859_15 = _FontEncoding.FONTENCODING_ISO8859_15
FONTENCODING_ISO8859_MAX = _FontEncoding.FONTENCODING_ISO8859_MAX
FONTENCODING_KOI8 = _FontEncoding.FONTENCODING_KOI8
FONTENCODING_KOI8_U = _FontEncoding.FONTENCODING_KOI8_U
FONTENCODING_ALTERNATIVE = _FontEncoding.FONTENCODING_ALTERNATIVE
FONTENCODING_BULGARIAN = _FontEncoding.FONTENCODING_BULGARIAN
FONTENCODING_CP437 = _FontEncoding.FONTENCODING_CP437
FONTENCODING_CP850 = _FontEncoding.FONTENCODING_CP850
FONTENCODING_CP852 = _FontEncoding.FONTENCODING_CP852
FONTENCODING_CP855 = _FontEncoding.FONTENCODING_CP855
FONTENCODING_CP866 = _FontEncoding.FONTENCODING_CP866
FONTENCODING_CP874 = _FontEncoding.FONTENCODING_CP874
FONTENCODING_CP932 = _FontEncoding.FONTENCODING_CP932
FONTENCODING_CP936 = _FontEncoding.FONTENCODING_CP936
FONTENCODING_CP949 = _FontEncoding.FONTENCODING_CP949
FONTENCODING_CP950 = _FontEncoding.FONTENCODING_CP950
FONTENCODING_CP1250 = _FontEncoding.FONTENCODING_CP1250
FONTENCODING_CP1251 = _FontEncoding.FONTENCODING_CP1251
FONTENCODING_CP1252 = _FontEncoding.FONTENCODING_CP1252
FONTENCODING_CP1253 = _FontEncoding.FONTENCODING_CP1253
FONTENCODING_CP1254 = _FontEncoding.FONTENCODING_CP1254
FONTENCODING_CP1255 = _FontEncoding.FONTENCODING_CP1255
FONTENCODING_CP1256 = _FontEncoding.FONTENCODING_CP1256
FONTENCODING_CP1257 = _FontEncoding.FONTENCODING_CP1257
FONTENCODING_CP1258 = _FontEncoding.FONTENCODING_CP1258
FONTENCODING_CP1361 = _FontEncoding.FONTENCODING_CP1361
FONTENCODING_CP12_MAX = _FontEncoding.FONTENCODING_CP12_MAX
FONTENCODING_UTF7 = _FontEncoding.FONTENCODING_UTF7
FONTENCODING_UTF8 = _FontEncoding.FONTENCODING_UTF8
FONTENCODING_EUC_JP = _FontEncoding.FONTENCODING_EUC_JP
FONTENCODING_UTF16BE = _FontEncoding.FONTENCODING_UTF16BE
FONTENCODING_UTF16LE = _FontEncoding.FONTENCODING_UTF16LE
FONTENCODING_UTF32BE = _FontEncoding.FONTENCODING_UTF32BE
FONTENCODING_UTF32LE = _FontEncoding.FONTENCODING_UTF32LE
FONTENCODING_MACROMAN = _FontEncoding.FONTENCODING_MACROMAN
FONTENCODING_MACJAPANESE = _FontEncoding.FONTENCODING_MACJAPANESE
FONTENCODING_MACCHINESETRAD = _FontEncoding.FONTENCODING_MACCHINESETRAD
FONTENCODING_MACKOREAN = _FontEncoding.FONTENCODING_MACKOREAN
FONTENCODING_MACARABIC = _FontEncoding.FONTENCODING_MACARABIC
FONTENCODING_MACHEBREW = _FontEncoding.FONTENCODING_MACHEBREW
FONTENCODING_MACGREEK = _FontEncoding.FONTENCODING_MACGREEK
FONTENCODING_MACCYRILLIC = _FontEncoding.FONTENCODING_MACCYRILLIC
FONTENCODING_MACDEVANAGARI = _FontEncoding.FONTENCODING_MACDEVANAGARI
FONTENCODING_MACGURMUKHI = _FontEncoding.FONTENCODING_MACGURMUKHI
FONTENCODING_MACGUJARATI = _FontEncoding.FONTENCODING_MACGUJARATI
FONTENCODING_MACORIYA = _FontEncoding.FONTENCODING_MACORIYA
FONTENCODING_MACBENGALI = _FontEncoding.FONTENCODING_MACBENGALI
FONTENCODING_MACTAMIL = _FontEncoding.FONTENCODING_MACTAMIL
FONTENCODING_MACTELUGU = _FontEncoding.FONTENCODING_MACTELUGU
FONTENCODING_MACKANNADA = _FontEncoding.FONTENCODING_MACKANNADA
FONTENCODING_MACMALAJALAM = _FontEncoding.FONTENCODING_MACMALAJALAM
FONTENCODING_MACSINHALESE = _FontEncoding.FONTENCODING_MACSINHALESE
FONTENCODING_MACBURMESE = _FontEncoding.FONTENCODING_MACBURMESE
FONTENCODING_MACKHMER = _FontEncoding.FONTENCODING_MACKHMER
FONTENCODING_MACTHAI = _FontEncoding.FONTENCODING_MACTHAI
FONTENCODING_MACLAOTIAN = _FontEncoding.FONTENCODING_MACLAOTIAN
FONTENCODING_MACGEORGIAN = _FontEncoding.FONTENCODING_MACGEORGIAN
FONTENCODING_MACARMENIAN = _FontEncoding.FONTENCODING_MACARMENIAN
FONTENCODING_MACCHINESESIMP = _FontEncoding.FONTENCODING_MACCHINESESIMP
FONTENCODING_MACTIBETAN = _FontEncoding.FONTENCODING_MACTIBETAN
FONTENCODING_MACMONGOLIAN = _FontEncoding.FONTENCODING_MACMONGOLIAN
FONTENCODING_MACETHIOPIC = _FontEncoding.FONTENCODING_MACETHIOPIC
FONTENCODING_MACCENTRALEUR = _FontEncoding.FONTENCODING_MACCENTRALEUR
FONTENCODING_MACVIATNAMESE = _FontEncoding.FONTENCODING_MACVIATNAMESE
FONTENCODING_MACARABICEXT = _FontEncoding.FONTENCODING_MACARABICEXT
FONTENCODING_MACSYMBOL = _FontEncoding.FONTENCODING_MACSYMBOL
FONTENCODING_MACDINGBATS = _FontEncoding.FONTENCODING_MACDINGBATS
FONTENCODING_MACTURKISH = _FontEncoding.FONTENCODING_MACTURKISH
FONTENCODING_MACCROATIAN = _FontEncoding.FONTENCODING_MACCROATIAN
FONTENCODING_MACICELANDIC = _FontEncoding.FONTENCODING_MACICELANDIC
FONTENCODING_MACROMANIAN = _FontEncoding.FONTENCODING_MACROMANIAN
FONTENCODING_MACCELTIC = _FontEncoding.FONTENCODING_MACCELTIC
FONTENCODING_MACGAELIC = _FontEncoding.FONTENCODING_MACGAELIC
FONTENCODING_MACKEYBOARD = _FontEncoding.FONTENCODING_MACKEYBOARD
FONTENCODING_ISO2022_JP = _FontEncoding.FONTENCODING_ISO2022_JP
FONTENCODING_MAX = _FontEncoding.FONTENCODING_MAX
FONTENCODING_MACMIN = _FontEncoding.FONTENCODING_MACMIN
FONTENCODING_MACMAX = _FontEncoding.FONTENCODING_MACMAX
FONTENCODING_UTF16 = _FontEncoding.FONTENCODING_UTF16
FONTENCODING_UTF32 = _FontEncoding.FONTENCODING_UTF32
FONTENCODING_UNICODE = _FontEncoding.FONTENCODING_UNICODE
FONTENCODING_GB2312 = _FontEncoding.FONTENCODING_GB2312
FONTENCODING_BIG5 = _FontEncoding.FONTENCODING_BIG5
FONTENCODING_SHIFT_JIS = _FontEncoding.FONTENCODING_SHIFT_JIS
FONTENCODING_EUC_KR = _FontEncoding.FONTENCODING_EUC_KR
FONTENCODING_JOHAB = _FontEncoding.FONTENCODING_JOHAB
FONTENCODING_VIETNAMESE = _FontEncoding.FONTENCODING_VIETNAMESE

class FontInfo:
    """
    FontInfo() -> None
    FontInfo(pointSize) -> None
    FontInfo(pixelSize) -> None
    
    This class is a helper used for wxFont creation using named parameter
    idiom: it allows specifying various wxFont attributes using the
    chained calls to its clearly named methods instead of passing them in
    the fixed order to wxFont constructors.
    """

    @overload
    def __init__(self, pointSize: float) -> None:
        ...

    @overload
    def __init__(self, pixelSize: Size) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        FontInfo() -> None
        FontInfo(pointSize) -> None
        FontInfo(pixelSize) -> None
        
        This class is a helper used for wxFont creation using named parameter
        idiom: it allows specifying various wxFont attributes using the
        chained calls to its clearly named methods instead of passing them in
        the fixed order to wxFont constructors.
        """

    def Family(self, family: FontFamily) -> FontInfo:
        """
        Family(family) -> FontInfo
        
        Set the font family.
        """

    def FaceName(self, faceName: str) -> FontInfo:
        """
        FaceName(faceName) -> FontInfo
        
        Set the font face name to use.
        """

    def Weight(self, weight: int) -> FontInfo:
        """
        Weight(weight) -> FontInfo
        
        Specify the weight of the font.
        """

    def Bold(self, bold: bool=True) -> FontInfo:
        """
        Bold(bold=True) -> FontInfo
        
        Use a bold version of the font.
        """

    def Light(self, light: bool=True) -> FontInfo:
        """
        Light(light=True) -> FontInfo
        
        Use a lighter version of the font.
        """

    def Italic(self, italic: bool=True) -> FontInfo:
        """
        Italic(italic=True) -> FontInfo
        
        Use an italic version of the font.
        """

    def Slant(self, slant: bool=True) -> FontInfo:
        """
        Slant(slant=True) -> FontInfo
        
        Use a slanted version of the font.
        """

    def Style(self, style: FontStyle) -> FontInfo:
        """
        Style(style) -> FontInfo
        
        Specify the style of the font using one of wxFontStyle constants.
        """

    def AntiAliased(self, antiAliased: bool=True) -> FontInfo:
        """
        AntiAliased(antiAliased=True) -> FontInfo
        
        Set anti-aliasing flag.
        """

    def Underlined(self, underlined: bool=True) -> FontInfo:
        """
        Underlined(underlined=True) -> FontInfo
        
        Use an underlined version of the font.
        """

    def Strikethrough(self, strikethrough: bool=True) -> FontInfo:
        """
        Strikethrough(strikethrough=True) -> FontInfo
        
        Use a strike-through version of the font.
        """

    def Encoding(self, encoding: FontEncoding) -> FontInfo:
        """
        Encoding(encoding) -> FontInfo
        
        Set the font encoding to use.
        """

    def AllFlags(self, flags: int) -> FontInfo:
        """
        AllFlags(flags) -> FontInfo
        
        Set all the font attributes at once.
        """

    @staticmethod
    def GetWeightClosestToNumericValue(numWeight: int) -> FontWeight:
        """
        GetWeightClosestToNumericValue(numWeight) -> FontWeight
        
        Get the symbolic weight closest to the given raw weight value.
        """
# end of class FontInfo


class Font(GDIObject):
    """
    Font() -> None
    Font(font) -> None
    Font(fontInfo) -> None
    Font(pointSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> None
    Font(pixelSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> None
    Font(nativeInfoString) -> None
    Font(nativeInfo) -> None
    
    A font is an object which determines the appearance of text.
    """

    @overload
    def __init__(self, font: Font) -> None:
        ...

    @overload
    def __init__(self, fontInfo: FontInfo) -> None:
        ...

    @overload
    def __init__(self, pointSize: int, family: FontFamily, style: FontStyle, weight: FontWeight, underline: bool=False, faceName: str='', encoding: FontEncoding=FONTENCODING_DEFAULT) -> None:
        ...

    @overload
    def __init__(self, pixelSize: Size, family: FontFamily, style: FontStyle, weight: FontWeight, underline: bool=False, faceName: str='', encoding: FontEncoding=FONTENCODING_DEFAULT) -> None:
        ...

    @overload
    def __init__(self, nativeInfoString: str) -> None:
        ...

    @overload
    def __init__(self, nativeInfo: NativeFontInfo) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Font() -> None
        Font(font) -> None
        Font(fontInfo) -> None
        Font(pointSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> None
        Font(pixelSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> None
        Font(nativeInfoString) -> None
        Font(nativeInfo) -> None
        
        A font is an object which determines the appearance of text.
        """

    def GetBaseFont(self) -> Font:
        """
        GetBaseFont() -> Font
        
        Returns a font with the same face/size as the given one but with
        normal weight and style and not underlined nor stricken through.
        """

    def GetEncoding(self) -> FontEncoding:
        """
        GetEncoding() -> FontEncoding
        
        Returns the encoding of this font.
        """

    def GetFaceName(self) -> str:
        """
        GetFaceName() -> str
        
        Returns the face name associated with the font, or the empty string if
        there is no face information.
        """

    def GetFamily(self) -> FontFamily:
        """
        GetFamily() -> FontFamily
        
        Gets the font family if possible.
        """

    def GetNativeFontInfoDesc(self) -> str:
        """
        GetNativeFontInfoDesc() -> str
        
        Returns the platform-dependent string completely describing this font.
        """

    def GetNativeFontInfoUserDesc(self) -> str:
        """
        GetNativeFontInfoUserDesc() -> str
        
        Returns a user-friendly string for this font object.
        """

    def GetNativeFontInfo(self) -> NativeFontInfo:
        """
        GetNativeFontInfo() -> NativeFontInfo
        
        Returns a font with the same face/size as the given one but with
        normal weight and style and not underlined nor stricken through.
        """

    def GetPointSize(self) -> int:
        """
        GetPointSize() -> int
        
        Gets the point size as an integer number.
        """

    def GetFractionalPointSize(self) -> float:
        """
        GetFractionalPointSize() -> float
        
        Gets the point size as a floating number.
        """

    def GetPixelSize(self) -> Size:
        """
        GetPixelSize() -> Size
        
        Gets the pixel size.
        """

    def GetStyle(self) -> FontStyle:
        """
        GetStyle() -> FontStyle
        
        Gets the font style.
        """

    def GetUnderlined(self) -> bool:
        """
        GetUnderlined() -> bool
        
        Returns true if the font is underlined, false otherwise.
        """

    def GetStrikethrough(self) -> bool:
        """
        GetStrikethrough() -> bool
        
        Returns true if the font is stricken-through, false otherwise.
        """

    def GetWeight(self) -> FontWeight:
        """
        GetWeight() -> FontWeight
        
        Gets the font weight.
        """

    def GetNumericWeight(self) -> int:
        """
        GetNumericWeight() -> int
        
        Gets the font weight as an integer value.
        """

    def IsFixedWidth(self) -> bool:
        """
        IsFixedWidth() -> bool
        
        Returns true if the font is a fixed width (or monospaced) font, false
        if it is a proportional one or font is invalid.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if this object is a valid font, false otherwise.
        """

    @staticmethod
    def AddPrivateFont(filename: str) -> bool:
        """
        AddPrivateFont(filename) -> bool
        
        Specify the name of a file containing a TrueType font to be made
        available to the current application.
        """

    def Bold(self) -> Font:
        """
        Bold() -> Font
        
        Returns a bold version of this font.
        """

    def Italic(self) -> Font:
        """
        Italic() -> Font
        
        Returns an italic version of this font.
        """

    def Larger(self) -> Font:
        """
        Larger() -> Font
        
        Returns a larger version of this font.
        """

    def Smaller(self) -> Font:
        """
        Smaller() -> Font
        
        Returns a smaller version of this font.
        """

    def Underlined(self) -> Font:
        """
        Underlined() -> Font
        
        Returns underlined version of this font.
        """

    def Strikethrough(self) -> Font:
        """
        Strikethrough() -> Font
        
        Returns stricken-through version of this font.
        """

    def MakeBold(self) -> Font:
        """
        MakeBold() -> Font
        
        Changes this font to be bold.
        """

    def MakeItalic(self) -> Font:
        """
        MakeItalic() -> Font
        
        Changes this font to be italic.
        """

    def MakeLarger(self) -> Font:
        """
        MakeLarger() -> Font
        
        Changes this font to be larger.
        """

    def MakeSmaller(self) -> Font:
        """
        MakeSmaller() -> Font
        
        Changes this font to be smaller.
        """

    def MakeUnderlined(self) -> Font:
        """
        MakeUnderlined() -> Font
        
        Changes this font to be underlined.
        """

    def MakeStrikethrough(self) -> Font:
        """
        MakeStrikethrough() -> Font
        
        Changes this font to be stricken-through.
        """

    def Scale(self, x: float) -> Font:
        """
        Scale(x) -> Font
        
        Changes the size of this font.
        """

    def Scaled(self, x: float) -> Font:
        """
        Scaled(x) -> Font
        
        Returns a scaled version of this font.
        """

    def SetEncoding(self, encoding: FontEncoding) -> None:
        """
        SetEncoding(encoding) -> None
        
        Sets the encoding for this font.
        """

    def SetFaceName(self, faceName: str) -> bool:
        """
        SetFaceName(faceName) -> bool
        
        Sets the facename for the font.
        """

    def SetFamily(self, family: FontFamily) -> None:
        """
        SetFamily(family) -> None
        
        Sets the font family.
        """

    @overload
    def SetNativeFontInfo(self, info: NativeFontInfo) -> None:
        ...

    @overload
    def SetNativeFontInfo(self, info: str) -> bool:
        """
        SetNativeFontInfo(info) -> bool
        SetNativeFontInfo(info) -> None
        
        Creates the font corresponding to the given native font description
        string which must have been previously returned by
        GetNativeFontInfoDesc().
        """

    def SetNativeFontInfoUserDesc(self, info: str) -> bool:
        """
        SetNativeFontInfoUserDesc(info) -> bool
        
        Creates the font corresponding to the given native font description
        string and returns true if the creation was successful.
        """

    def SetPointSize(self, pointSize: int) -> None:
        """
        SetPointSize(pointSize) -> None
        
        Sets the font size in points to an integer value.
        """

    def SetFractionalPointSize(self, pointSize: float) -> None:
        """
        SetFractionalPointSize(pointSize) -> None
        
        Sets the font size in points.
        """

    def SetPixelSize(self, pixelSize: Size) -> None:
        """
        SetPixelSize(pixelSize) -> None
        
        Sets the pixel size.
        """

    def SetStyle(self, style: FontStyle) -> None:
        """
        SetStyle(style) -> None
        
        Sets the font style.
        """

    def SetSymbolicSize(self, size: FontSymbolicSize) -> None:
        """
        SetSymbolicSize(size) -> None
        
        Sets the font size using a predefined symbolic size name.
        """

    def SetSymbolicSizeRelativeTo(self, size: FontSymbolicSize, base: int) -> None:
        """
        SetSymbolicSizeRelativeTo(size, base) -> None
        
        Sets the font size compared to the base font size.
        """

    def SetUnderlined(self, underlined: bool) -> None:
        """
        SetUnderlined(underlined) -> None
        
        Sets underlining.
        """

    def SetStrikethrough(self, strikethrough: bool) -> None:
        """
        SetStrikethrough(strikethrough) -> None
        
        Sets strike-through attribute of the font.
        """

    def SetWeight(self, weight: FontWeight) -> None:
        """
        SetWeight(weight) -> None
        
        Sets the font weight.
        """

    def SetNumericWeight(self, weight: int) -> None:
        """
        SetNumericWeight(weight) -> None
        
        Sets the font weight using an integer value.
        """

    @overload
    @staticmethod
    def New(pointSize: int, family: FontFamily, flags: int=FONTFLAG_DEFAULT, faceName: str='', encoding: FontEncoding=FONTENCODING_DEFAULT) -> Font:
        ...

    @overload
    @staticmethod
    def New(pixelSize: Size, family: FontFamily, style: FontStyle, weight: FontWeight, underline: bool=False, faceName: str='', encoding: FontEncoding=FONTENCODING_DEFAULT) -> Font:
        ...

    @overload
    @staticmethod
    def New(pixelSize: Size, family: FontFamily, flags: int=FONTFLAG_DEFAULT, faceName: str='', encoding: FontEncoding=FONTENCODING_DEFAULT) -> Font:
        ...

    @overload
    @staticmethod
    def New(nativeInfo: NativeFontInfo) -> Font:
        ...

    @overload
    @staticmethod
    def New(nativeInfoString: str) -> Font:
        ...

    @overload
    @staticmethod
    def New(pointSize: int, family: FontFamily, style: FontStyle, weight: FontWeight, underline: bool=False, faceName: str='', encoding: FontEncoding=FONTENCODING_DEFAULT) -> Font:
        """
        New(pointSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> Font
        New(pointSize, family, flags=FONTFLAG_DEFAULT, faceName='', encoding=FONTENCODING_DEFAULT) -> Font
        New(pixelSize, family, style, weight, underline=False, faceName='', encoding=FONTENCODING_DEFAULT) -> Font
        New(pixelSize, family, flags=FONTFLAG_DEFAULT, faceName='', encoding=FONTENCODING_DEFAULT) -> Font
        New(nativeInfo) -> Font
        New(nativeInfoString) -> Font
        
        This function takes the same parameters as the relative wxFont
        constructor and returns a new font object allocated on the heap.
        """

    def __ne__(self, font: Font) -> bool:
        """
        """

    def __eq__(self, font: Font) -> bool:
        """
        """

    @staticmethod
    def GetDefaultEncoding() -> FontEncoding:
        """
        GetDefaultEncoding() -> FontEncoding
        
        Returns the current application's default encoding.
        """

    @staticmethod
    def SetDefaultEncoding(encoding: FontEncoding) -> None:
        """
        SetDefaultEncoding(encoding) -> None
        
        Sets the default font encoding.
        """

    @staticmethod
    def GetNumericWeightOf(weight: FontWeight) -> int:
        """
        GetNumericWeightOf(weight) -> int
        
        Get the raw weight value corresponding to the given symbolic constant.
        """
    @property
    def Encoding(self) -> FontEncoding: ...
    @Encoding.setter
    def Encoding(self, value: FontEncoding, /) -> None: ...
    @property
    def FaceName(self) -> str: ...
    @FaceName.setter
    def FaceName(self, value: str, /) -> None: ...
    @property
    def Family(self) -> FontFamily: ...
    @Family.setter
    def Family(self, value: FontFamily, /) -> None: ...
    @property
    def NativeFontInfoDesc(self) -> str: ...
    @NativeFontInfoDesc.setter
    def NativeFontInfoDesc(self, value: str, /) -> None: ...
    @property
    def NativeFontInfoUserDesc(self) -> str: ...
    @NativeFontInfoUserDesc.setter
    def NativeFontInfoUserDesc(self, value: str, /) -> None: ...
    @property
    def PointSize(self) -> int: ...
    @PointSize.setter
    def PointSize(self, value: int, /) -> None: ...
    @property
    def PixelSize(self) -> Size: ...
    @PixelSize.setter
    def PixelSize(self, value: Size, /) -> None: ...
    @property
    def Style(self) -> FontStyle: ...
    @Style.setter
    def Style(self, value: FontStyle, /) -> None: ...
    @property
    def Weight(self) -> FontWeight: ...
    @Weight.setter
    def Weight(self, value: FontWeight, /) -> None: ...

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def GetHFONT(self) -> Any:
        """
        GetHFONT() -> Any
        
        Returns the font's native handle.
        """

    def OSXGetCGFont(self) -> Any:
        """
        OSXGetCGFont() -> Any
        
        Returns the font's native handle.
        """

    def GetPangoFontDescription(self) -> Any:
        """
        GetPangoFontDescription() -> Any
        
        Returns the font's native handle.
        """

    @staticmethod
    def CanUsePrivateFont() -> bool:
        """
        CanUsePrivateFont() -> bool
        
        Returns ``True`` if this build of wxPython supports using
        :meth:`AddPrivateFont`.
        """

    def _copyFrom(self, other: Font) -> None:
        """
        _copyFrom(other) -> None
        
        For internal use only.
        """

    def SetNoAntiAliasing(self, no=True):
        """
        
        """

    def GetNoAntiAliasing(self):
        """
        
        """
# end of class Font


class FontList:
    """
    FontList() -> None
    
    A font list is a list containing all fonts which have been created.
    """

    def __init__(self) -> None:
        """
        FontList() -> None
        
        A font list is a list containing all fonts which have been created.
        """

    @overload
    def FindOrCreateFont(self, fontInfo: FontInfo) -> Font:
        ...

    @overload
    def FindOrCreateFont(self, point_size: int, family: FontFamily, style: FontStyle, weight: FontWeight, underline: bool=False, facename: str='', encoding: FontEncoding=FONTENCODING_DEFAULT) -> Font:
        """
        FindOrCreateFont(point_size, family, style, weight, underline=False, facename='', encoding=FONTENCODING_DEFAULT) -> Font
        FindOrCreateFont(fontInfo) -> Font
        
        Finds a font of the given specification, or creates one and adds it to
        the list.
        """
# end of class FontList

NullFont: Font

def FFont(self, pointSize: int, family: FontFamily, flags: int=FONTFLAG_DEFAULT, faceName: str='', encoding: FontEncoding=FONTENCODING_DEFAULT) -> Font:
    """
    FFont(pointSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)
    """

# These stock fonts will be initialized when the wx.App object is created.
NORMAL_FONT = Font()
SMALL_FONT = Font()
ITALIC_FONT = Font()
SWISS_FONT = Font()

wx.DEFAULT    = int(wx.FONTFAMILY_DEFAULT)
wx.DECORATIVE = int(wx.FONTFAMILY_DECORATIVE)
wx.ROMAN      = int(wx.FONTFAMILY_ROMAN)
wx.SCRIPT     = int(wx.FONTFAMILY_SCRIPT)
wx.SWISS      = int(wx.FONTFAMILY_SWISS)
wx.MODERN     = int(wx.FONTFAMILY_MODERN)
wx.TELETYPE   = int(wx.FONTFAMILY_TELETYPE)

wx.NORMAL = int(wx.FONTWEIGHT_NORMAL)
wx.LIGHT  = int(wx.FONTWEIGHT_LIGHT)
wx.BOLD   = int(wx.FONTWEIGHT_BOLD)

wx.NORMAL = int(wx.FONTSTYLE_NORMAL)
wx.ITALIC = int(wx.FONTSTYLE_ITALIC)
wx.SLANT  = int(wx.FONTSTYLE_SLANT)
#-- end-font --#
#-- begin-fontutil --#

class NativeFontInfo:
    """
    NativeFontInfo() -> None
    NativeFontInfo(info) -> None
    
    wxNativeFontInfo is platform-specific font representation: this class
    should be considered as an opaque font description only used by the
    native functions, the user code can only get the objects of this type
    from somewhere and pass it somewhere else (possibly save them
    somewhere using ToString() and restore them using FromString())
    """

    @overload
    def __init__(self, info: NativeFontInfo) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        NativeFontInfo() -> None
        NativeFontInfo(info) -> None
        
        wxNativeFontInfo is platform-specific font representation: this class
        should be considered as an opaque font description only used by the
        native functions, the user code can only get the objects of this type
        from somewhere and pass it somewhere else (possibly save them
        somewhere using ToString() and restore them using FromString())
        """

    def Init(self) -> None:
        """
        Init() -> None
        """

    def InitFromFont(self, font: Font) -> None:
        """
        InitFromFont(font) -> None
        """

    def GetPointSize(self) -> int:
        """
        GetPointSize() -> int
        """

    def GetFractionalPointSize(self) -> float:
        """
        GetFractionalPointSize() -> float
        """

    def GetStyle(self) -> FontStyle:
        """
        GetStyle() -> FontStyle
        """

    def GetNumericWeight(self) -> int:
        """
        GetNumericWeight() -> int
        """

    def GetWeight(self) -> FontWeight:
        """
        GetWeight() -> FontWeight
        """

    def GetUnderlined(self) -> bool:
        """
        GetUnderlined() -> bool
        """

    def GetFaceName(self) -> str:
        """
        GetFaceName() -> str
        """

    def GetFamily(self) -> FontFamily:
        """
        GetFamily() -> FontFamily
        """

    def GetEncoding(self) -> FontEncoding:
        """
        GetEncoding() -> FontEncoding
        """

    def SetPointSize(self, pointsize: int) -> None:
        """
        SetPointSize(pointsize) -> None
        """

    def SetFractionalPointSize(self, pointsize: float) -> None:
        """
        SetFractionalPointSize(pointsize) -> None
        """

    def SetStyle(self, style: FontStyle) -> None:
        """
        SetStyle(style) -> None
        """

    def SetNumericWeight(self, weight: int) -> None:
        """
        SetNumericWeight(weight) -> None
        """

    def SetWeight(self, weight: FontWeight) -> None:
        """
        SetWeight(weight) -> None
        """

    def SetUnderlined(self, underlined: bool) -> None:
        """
        SetUnderlined(underlined) -> None
        """

    @overload
    def SetFaceName(self, facenames: List[str]) -> None:
        ...

    @overload
    def SetFaceName(self, facename: str) -> bool:
        """
        SetFaceName(facename) -> bool
        SetFaceName(facenames) -> None
        """

    def SetFamily(self, family: FontFamily) -> None:
        """
        SetFamily(family) -> None
        """

    def SetEncoding(self, encoding: FontEncoding) -> None:
        """
        SetEncoding(encoding) -> None
        """

    def FromString(self, s: str) -> bool:
        """
        FromString(s) -> bool
        """

    def ToString(self) -> str:
        """
        ToString() -> str
        """

    def FromUserString(self, s: str) -> bool:
        """
        FromUserString(s) -> bool
        """

    def ToUserString(self) -> str:
        """
        ToUserString() -> str
        """

    def __str__(self) -> str:
        """
        __str__() -> str
        """
    @property
    def Encoding(self) -> FontEncoding: ...
    @Encoding.setter
    def Encoding(self, value: FontEncoding, /) -> None: ...
    @property
    def FaceName(self) -> str: ...
    @FaceName.setter
    def FaceName(self, value: str, /) -> None: ...
    @property
    def Family(self) -> FontFamily: ...
    @Family.setter
    def Family(self, value: FontFamily, /) -> None: ...
    @property
    def FractionalPointSize(self) -> float: ...
    @FractionalPointSize.setter
    def FractionalPointSize(self, value: float, /) -> None: ...
    @property
    def NumericWeight(self) -> int: ...
    @NumericWeight.setter
    def NumericWeight(self, value: int, /) -> None: ...
    @property
    def PointSize(self) -> int: ...
    @PointSize.setter
    def PointSize(self, value: int, /) -> None: ...
    @property
    def Style(self) -> FontStyle: ...
    @Style.setter
    def Style(self, value: FontStyle, /) -> None: ...
    @property
    def Underlined(self) -> bool: ...
    @Underlined.setter
    def Underlined(self, value: bool, /) -> None: ...
    @property
    def Weight(self) -> FontWeight: ...
    @Weight.setter
    def Weight(self, value: FontWeight, /) -> None: ...
# end of class NativeFontInfo

#-- end-fontutil --#
#-- begin-pen --#

class _PenStyle(IntEnum):
    PENSTYLE_INVALID = auto()
    PENSTYLE_SOLID = auto()
    PENSTYLE_DOT = auto()
    PENSTYLE_LONG_DASH = auto()
    PENSTYLE_SHORT_DASH = auto()
    PENSTYLE_DOT_DASH = auto()
    PENSTYLE_USER_DASH = auto()
    PENSTYLE_TRANSPARENT = auto()
    PENSTYLE_STIPPLE_MASK_OPAQUE = auto()
    PENSTYLE_STIPPLE_MASK = auto()
    PENSTYLE_STIPPLE = auto()
    PENSTYLE_BDIAGONAL_HATCH = auto()
    PENSTYLE_CROSSDIAG_HATCH = auto()
    PENSTYLE_FDIAGONAL_HATCH = auto()
    PENSTYLE_CROSS_HATCH = auto()
    PENSTYLE_HORIZONTAL_HATCH = auto()
    PENSTYLE_VERTICAL_HATCH = auto()
    PENSTYLE_FIRST_HATCH = auto()
    PENSTYLE_LAST_HATCH = auto()
PenStyle: TypeAlias = Union[_PenStyle, int]
PENSTYLE_INVALID = _PenStyle.PENSTYLE_INVALID
PENSTYLE_SOLID = _PenStyle.PENSTYLE_SOLID
PENSTYLE_DOT = _PenStyle.PENSTYLE_DOT
PENSTYLE_LONG_DASH = _PenStyle.PENSTYLE_LONG_DASH
PENSTYLE_SHORT_DASH = _PenStyle.PENSTYLE_SHORT_DASH
PENSTYLE_DOT_DASH = _PenStyle.PENSTYLE_DOT_DASH
PENSTYLE_USER_DASH = _PenStyle.PENSTYLE_USER_DASH
PENSTYLE_TRANSPARENT = _PenStyle.PENSTYLE_TRANSPARENT
PENSTYLE_STIPPLE_MASK_OPAQUE = _PenStyle.PENSTYLE_STIPPLE_MASK_OPAQUE
PENSTYLE_STIPPLE_MASK = _PenStyle.PENSTYLE_STIPPLE_MASK
PENSTYLE_STIPPLE = _PenStyle.PENSTYLE_STIPPLE
PENSTYLE_BDIAGONAL_HATCH = _PenStyle.PENSTYLE_BDIAGONAL_HATCH
PENSTYLE_CROSSDIAG_HATCH = _PenStyle.PENSTYLE_CROSSDIAG_HATCH
PENSTYLE_FDIAGONAL_HATCH = _PenStyle.PENSTYLE_FDIAGONAL_HATCH
PENSTYLE_CROSS_HATCH = _PenStyle.PENSTYLE_CROSS_HATCH
PENSTYLE_HORIZONTAL_HATCH = _PenStyle.PENSTYLE_HORIZONTAL_HATCH
PENSTYLE_VERTICAL_HATCH = _PenStyle.PENSTYLE_VERTICAL_HATCH
PENSTYLE_FIRST_HATCH = _PenStyle.PENSTYLE_FIRST_HATCH
PENSTYLE_LAST_HATCH = _PenStyle.PENSTYLE_LAST_HATCH

class _PenQuality(IntEnum):
    PEN_QUALITY_DEFAULT = auto()
    PEN_QUALITY_LOW = auto()
    PEN_QUALITY_HIGH = auto()
PenQuality: TypeAlias = Union[_PenQuality, int]
PEN_QUALITY_DEFAULT = _PenQuality.PEN_QUALITY_DEFAULT
PEN_QUALITY_LOW = _PenQuality.PEN_QUALITY_LOW
PEN_QUALITY_HIGH = _PenQuality.PEN_QUALITY_HIGH

class _PenJoin(IntEnum):
    JOIN_INVALID = auto()
    JOIN_BEVEL = auto()
    JOIN_MITER = auto()
    JOIN_ROUND = auto()
PenJoin: TypeAlias = Union[_PenJoin, int]
JOIN_INVALID = _PenJoin.JOIN_INVALID
JOIN_BEVEL = _PenJoin.JOIN_BEVEL
JOIN_MITER = _PenJoin.JOIN_MITER
JOIN_ROUND = _PenJoin.JOIN_ROUND

class _PenCap(IntEnum):
    CAP_INVALID = auto()
    CAP_ROUND = auto()
    CAP_PROJECTING = auto()
    CAP_BUTT = auto()
PenCap: TypeAlias = Union[_PenCap, int]
CAP_INVALID = _PenCap.CAP_INVALID
CAP_ROUND = _PenCap.CAP_ROUND
CAP_PROJECTING = _PenCap.CAP_PROJECTING
CAP_BUTT = _PenCap.CAP_BUTT

class PenInfo:
    """
    PenInfo(colour=Colour(), width=1, style=PENSTYLE_SOLID) -> None
    
    This class is a helper used for wxPen creation using named parameter
    idiom: it allows specifying various wxPen attributes using the chained
    calls to its clearly named methods instead of passing them in the
    fixed order to wxPen constructors.
    """

    def __init__(self, colour: Colour=Colour(), width: int=1, style: PenStyle=PENSTYLE_SOLID) -> None:
        """
        PenInfo(colour=Colour(), width=1, style=PENSTYLE_SOLID) -> None
        
        This class is a helper used for wxPen creation using named parameter
        idiom: it allows specifying various wxPen attributes using the chained
        calls to its clearly named methods instead of passing them in the
        fixed order to wxPen constructors.
        """

    def Colour(self, col: Colour) -> PenInfo:
        """
        Colour(col) -> PenInfo
        """

    def Width(self, width: int) -> PenInfo:
        """
        Width(width) -> PenInfo
        """

    def Style(self, style: PenStyle) -> PenInfo:
        """
        Style(style) -> PenInfo
        """

    def Stipple(self, stipple: Bitmap) -> PenInfo:
        """
        Stipple(stipple) -> PenInfo
        """

    def Join(self, join: PenJoin) -> PenInfo:
        """
        Join(join) -> PenInfo
        """

    def Cap(self, cap: PenCap) -> PenInfo:
        """
        Cap(cap) -> PenInfo
        """

    def Quality(self, quality: PenQuality) -> PenInfo:
        """
        Quality(quality) -> PenInfo
        
        Set the pen quality.
        """

    def LowQuality(self) -> PenInfo:
        """
        LowQuality() -> PenInfo
        
        Set low pen quality.
        """

    def HighQuality(self) -> PenInfo:
        """
        HighQuality() -> PenInfo
        
        Set high pen quality.
        """

    def GetColour(self) -> Colour:
        """
        GetColour() -> Colour
        """

    def GetStipple(self) -> Bitmap:
        """
        GetStipple() -> Bitmap
        """

    def GetStyle(self) -> PenStyle:
        """
        GetStyle() -> PenStyle
        """

    def GetJoin(self) -> PenJoin:
        """
        GetJoin() -> PenJoin
        """

    def GetCap(self) -> PenCap:
        """
        GetCap() -> PenCap
        """

    def GetQuality(self) -> PenQuality:
        """
        GetQuality() -> PenQuality
        """

    def IsTransparent(self) -> bool:
        """
        IsTransparent() -> bool
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        """
# end of class PenInfo


class Pen(GDIObject):
    """
    Pen() -> None
    Pen(info) -> None
    Pen(colour, width=1, style=PENSTYLE_SOLID) -> None
    Pen(pen) -> None
    
    A pen is a drawing tool for drawing outlines.
    """

    @overload
    def __init__(self, info: PenInfo) -> None:
        ...

    @overload
    def __init__(self, colour: Colour, width: int=1, style: PenStyle=PENSTYLE_SOLID) -> None:
        ...

    @overload
    def __init__(self, pen: Pen) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Pen() -> None
        Pen(info) -> None
        Pen(colour, width=1, style=PENSTYLE_SOLID) -> None
        Pen(pen) -> None
        
        A pen is a drawing tool for drawing outlines.
        """

    @overload
    def SetColour(self, red: int, green: int, blue: int) -> None:
        ...

    @overload
    def SetColour(self, colour: Colour) -> None:
        """
        SetColour(colour) -> None
        SetColour(red, green, blue) -> None
        
        The pen's colour is changed to the given colour.
        """

    def GetCap(self) -> PenCap:
        """
        GetCap() -> PenCap
        
        Returns the pen cap style, which may be one of wxCAP_ROUND,
        wxCAP_PROJECTING and wxCAP_BUTT.
        """

    def GetQuality(self) -> PenQuality:
        """
        GetQuality() -> PenQuality
        
        Returns the pen quality.
        """

    def GetColour(self) -> Colour:
        """
        GetColour() -> Colour
        
        Returns a reference to the pen colour.
        """

    def GetDashes(self) -> List[int]:
        """
        GetDashes() -> List[int]
        
        Gets an array of dashes (defined as char in X, DWORD under Windows).
        """

    def GetJoin(self) -> PenJoin:
        """
        GetJoin() -> PenJoin
        
        Returns the pen join style, which may be one of wxJOIN_BEVEL,
        wxJOIN_ROUND and wxJOIN_MITER.
        """

    def GetStipple(self) -> Bitmap:
        """
        GetStipple() -> Bitmap
        
        Gets a pointer to the stipple bitmap.
        """

    def GetStyle(self) -> PenStyle:
        """
        GetStyle() -> PenStyle
        
        Returns the pen style.
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Returns the pen width.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the pen is initialised.
        """

    def IsNonTransparent(self) -> bool:
        """
        IsNonTransparent() -> bool
        
        Returns true if the pen is a valid non-transparent pen.
        """

    def IsTransparent(self) -> bool:
        """
        IsTransparent() -> bool
        
        Returns true if the pen is transparent.
        """

    def SetCap(self, capStyle: PenCap) -> None:
        """
        SetCap(capStyle) -> None
        
        Sets the pen cap style, which may be one of wxCAP_ROUND,
        wxCAP_PROJECTING and wxCAP_BUTT.
        """

    def SetQuality(self, quality: PenQuality) -> None:
        """
        SetQuality(quality) -> None
        
        Sets the pen quality.
        """

    def SetDashes(self, dashes: List[int]) -> None:
        """
        SetDashes(dashes) -> None
        
        Associates an array of dash values (defined as char in X, DWORD under
        Windows) with the pen.
        """

    def SetJoin(self, join_style: PenJoin) -> None:
        """
        SetJoin(join_style) -> None
        
        Sets the pen join style, which may be one of wxJOIN_BEVEL,
        wxJOIN_ROUND and wxJOIN_MITER.
        """

    def SetStipple(self, stipple: Bitmap) -> None:
        """
        SetStipple(stipple) -> None
        
        Sets the bitmap for stippling.
        """

    def SetStyle(self, style: PenStyle) -> None:
        """
        SetStyle(style) -> None
        
        Set the pen style.
        """

    def SetWidth(self, width: int) -> None:
        """
        SetWidth(width) -> None
        
        Sets the pen width.
        """

    def __ne__(self, pen: Pen) -> bool:
        """
        """

    def __eq__(self, pen: Pen) -> bool:
        """
        """
    @property
    def Cap(self) -> PenCap: ...
    @Cap.setter
    def Cap(self, value: PenCap, /) -> None: ...
    @property
    def Colour(self) -> Colour: ...
    @Colour.setter
    def Colour(self, value: Colour, /) -> None: ...
    @property
    def Dashes(self) -> List[int]: ...
    @Dashes.setter
    def Dashes(self, value: List[int], /) -> None: ...
    @property
    def Join(self) -> PenJoin: ...
    @Join.setter
    def Join(self, value: PenJoin, /) -> None: ...
    @property
    def Quality(self) -> PenQuality: ...
    @Quality.setter
    def Quality(self, value: PenQuality, /) -> None: ...
    @property
    def Stipple(self) -> Bitmap: ...
    @Stipple.setter
    def Stipple(self, value: Bitmap, /) -> None: ...
    @property
    def Style(self) -> PenStyle: ...
    @Style.setter
    def Style(self, value: PenStyle, /) -> None: ...
    @property
    def Width(self) -> int: ...
    @Width.setter
    def Width(self, value: int, /) -> None: ...

    def _copyFrom(self, other: Pen) -> None:
        """
        _copyFrom(other) -> None
        
        For internal use only.
        """
# end of class Pen


class PenList:
    """
    PenList() -> None
    
    There is only one instance of this class: wxThePenList.
    """

    def __init__(self) -> None:
        """
        PenList() -> None
        
        There is only one instance of this class: wxThePenList.
        """

    def FindOrCreatePen(self, colour: Colour, width: int=1, style: PenStyle=PENSTYLE_SOLID) -> Pen:
        """
        FindOrCreatePen(colour, width=1, style=PENSTYLE_SOLID) -> Pen
        
        Finds a pen with the specified attributes and returns it, else creates
        a new pen, adds it to the pen list, and returns it.
        """
# end of class PenList

NullPen: Pen

# These stock pens will be initialized when the wx.App object is created.
RED_PEN = Pen()
BLUE_PEN = Pen()
CYAN_PEN = Pen()
GREEN_PEN = Pen()
YELLOW_PEN = Pen()
BLACK_PEN = Pen()
WHITE_PEN = Pen()
TRANSPARENT_PEN = Pen()
BLACK_DASHED_PEN = Pen()
GREY_PEN = Pen()
MEDIUM_GREY_PEN = Pen()
LIGHT_GREY_PEN = Pen()

wx.SOLID       = int(wx.PENSTYLE_SOLID)
wx.DOT         = int(wx.PENSTYLE_DOT)
wx.LONG_DASH   = int(wx.PENSTYLE_LONG_DASH)
wx.SHORT_DASH  = int(wx.PENSTYLE_SHORT_DASH)
wx.DOT_DASH    = int(wx.PENSTYLE_DOT_DASH)
wx.USER_DASH   = int(wx.PENSTYLE_USER_DASH)
wx.TRANSPARENT = int(wx.PENSTYLE_TRANSPARENT)
#-- end-pen --#
#-- begin-brush --#

class _BrushStyle(IntEnum):
    BRUSHSTYLE_INVALID = auto()
    BRUSHSTYLE_SOLID = auto()
    BRUSHSTYLE_TRANSPARENT = auto()
    BRUSHSTYLE_STIPPLE_MASK_OPAQUE = auto()
    BRUSHSTYLE_STIPPLE_MASK = auto()
    BRUSHSTYLE_STIPPLE = auto()
    BRUSHSTYLE_BDIAGONAL_HATCH = auto()
    BRUSHSTYLE_CROSSDIAG_HATCH = auto()
    BRUSHSTYLE_FDIAGONAL_HATCH = auto()
    BRUSHSTYLE_CROSS_HATCH = auto()
    BRUSHSTYLE_HORIZONTAL_HATCH = auto()
    BRUSHSTYLE_VERTICAL_HATCH = auto()
    BRUSHSTYLE_FIRST_HATCH = auto()
    BRUSHSTYLE_LAST_HATCH = auto()
BrushStyle: TypeAlias = Union[_BrushStyle, int]
BRUSHSTYLE_INVALID = _BrushStyle.BRUSHSTYLE_INVALID
BRUSHSTYLE_SOLID = _BrushStyle.BRUSHSTYLE_SOLID
BRUSHSTYLE_TRANSPARENT = _BrushStyle.BRUSHSTYLE_TRANSPARENT
BRUSHSTYLE_STIPPLE_MASK_OPAQUE = _BrushStyle.BRUSHSTYLE_STIPPLE_MASK_OPAQUE
BRUSHSTYLE_STIPPLE_MASK = _BrushStyle.BRUSHSTYLE_STIPPLE_MASK
BRUSHSTYLE_STIPPLE = _BrushStyle.BRUSHSTYLE_STIPPLE
BRUSHSTYLE_BDIAGONAL_HATCH = _BrushStyle.BRUSHSTYLE_BDIAGONAL_HATCH
BRUSHSTYLE_CROSSDIAG_HATCH = _BrushStyle.BRUSHSTYLE_CROSSDIAG_HATCH
BRUSHSTYLE_FDIAGONAL_HATCH = _BrushStyle.BRUSHSTYLE_FDIAGONAL_HATCH
BRUSHSTYLE_CROSS_HATCH = _BrushStyle.BRUSHSTYLE_CROSS_HATCH
BRUSHSTYLE_HORIZONTAL_HATCH = _BrushStyle.BRUSHSTYLE_HORIZONTAL_HATCH
BRUSHSTYLE_VERTICAL_HATCH = _BrushStyle.BRUSHSTYLE_VERTICAL_HATCH
BRUSHSTYLE_FIRST_HATCH = _BrushStyle.BRUSHSTYLE_FIRST_HATCH
BRUSHSTYLE_LAST_HATCH = _BrushStyle.BRUSHSTYLE_LAST_HATCH

class Brush(GDIObject):
    """
    Brush() -> None
    Brush(colour, style=BRUSHSTYLE_SOLID) -> None
    Brush(stippleBitmap) -> None
    Brush(brush) -> None
    
    A brush is a drawing tool for filling in areas.
    """

    @overload
    def __init__(self, colour: Colour, style: BrushStyle=BRUSHSTYLE_SOLID) -> None:
        ...

    @overload
    def __init__(self, stippleBitmap: Bitmap) -> None:
        ...

    @overload
    def __init__(self, brush: Brush) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Brush() -> None
        Brush(colour, style=BRUSHSTYLE_SOLID) -> None
        Brush(stippleBitmap) -> None
        Brush(brush) -> None
        
        A brush is a drawing tool for filling in areas.
        """

    @overload
    def SetColour(self, red: int, green: int, blue: int) -> None:
        ...

    @overload
    def SetColour(self, colour: Colour) -> None:
        """
        SetColour(colour) -> None
        SetColour(red, green, blue) -> None
        
        Sets the brush colour using red, green and blue values.
        """

    def GetColour(self) -> Colour:
        """
        GetColour() -> Colour
        
        Returns a reference to the brush colour.
        """

    def GetStipple(self) -> Bitmap:
        """
        GetStipple() -> Bitmap
        
        Gets a pointer to the stipple bitmap.
        """

    def GetStyle(self) -> BrushStyle:
        """
        GetStyle() -> BrushStyle
        
        Returns the brush style, one of the wxBrushStyle values.
        """

    def IsHatch(self) -> bool:
        """
        IsHatch() -> bool
        
        Returns true if the style of the brush is any of hatched fills.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the brush is initialised.
        """

    def IsNonTransparent(self) -> bool:
        """
        IsNonTransparent() -> bool
        
        Returns true if the brush is a valid non-transparent brush.
        """

    def IsTransparent(self) -> bool:
        """
        IsTransparent() -> bool
        
        Returns true if the brush is transparent.
        """

    def SetStipple(self, bitmap: Bitmap) -> None:
        """
        SetStipple(bitmap) -> None
        
        Sets the stipple bitmap.
        """

    def SetStyle(self, style: BrushStyle) -> None:
        """
        SetStyle(style) -> None
        
        Sets the brush style.
        """

    def __ne__(self, brush: Brush) -> bool:
        """
        """

    def __eq__(self, brush: Brush) -> bool:
        """
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def MacSetTheme(self, macThemeBrushID: int) -> None:
        """
        MacSetTheme(macThemeBrushID) -> None
        """
    @property
    def Colour(self) -> Colour: ...
    @Colour.setter
    def Colour(self, value: Colour, /) -> None: ...
    @property
    def Stipple(self) -> Bitmap: ...
    @Stipple.setter
    def Stipple(self, value: Bitmap, /) -> None: ...
    @property
    def Style(self) -> BrushStyle: ...
    @Style.setter
    def Style(self, value: BrushStyle, /) -> None: ...

    def _copyFrom(self, other: Brush) -> None:
        """
        _copyFrom(other) -> None
        
        For internal use only.
        """
# end of class Brush


class BrushList:
    """
    A brush list is a list containing all brushes which have been created.
    """

    def FindOrCreateBrush(self, colour: Colour, style: BrushStyle=BRUSHSTYLE_SOLID) -> Brush:
        """
        FindOrCreateBrush(colour, style=BRUSHSTYLE_SOLID) -> Brush
        
        Finds a brush with the specified attributes and returns it, else
        creates a new brush, adds it to the brush list, and returns it.
        """
# end of class BrushList

NullBrush: Brush

# These stock brushes will be initialized when the wx.App object is created.
BLUE_BRUSH = Brush()
GREEN_BRUSH = Brush()
YELLOW_BRUSH = Brush()
WHITE_BRUSH = Brush()
BLACK_BRUSH = Brush()
GREY_BRUSH = Brush()
MEDIUM_GREY_BRUSH = Brush()
LIGHT_GREY_BRUSH = Brush()
TRANSPARENT_BRUSH = Brush()
CYAN_BRUSH = Brush()
RED_BRUSH = Brush()

wx.STIPPLE_MASK_OPAQUE = int(wx.BRUSHSTYLE_STIPPLE_MASK_OPAQUE)
wx.STIPPLE_MASK        = int(wx.BRUSHSTYLE_STIPPLE_MASK)
wx.STIPPLE             = int(wx.BRUSHSTYLE_STIPPLE)
wx.BDIAGONAL_HATCH     = int(wx.BRUSHSTYLE_BDIAGONAL_HATCH)
wx.CROSSDIAG_HATCH     = int(wx.BRUSHSTYLE_CROSSDIAG_HATCH)
wx.FDIAGONAL_HATCH     = int(wx.BRUSHSTYLE_FDIAGONAL_HATCH)
wx.CROSS_HATCH         = int(wx.BRUSHSTYLE_CROSS_HATCH)
wx.HORIZONTAL_HATCH    = int(wx.BRUSHSTYLE_HORIZONTAL_HATCH)
wx.VERTICAL_HATCH      = int(wx.BRUSHSTYLE_VERTICAL_HATCH)
#-- end-brush --#
#-- begin-cursor --#

class Cursor(GDIObject):
    """
    Cursor() -> None
    Cursor(cursorName, type=BITMAP_TYPE_ANY, hotSpotX=0, hotSpotY=0) -> None
    Cursor(cursorId) -> None
    Cursor(image) -> None
    Cursor(cursor) -> None
    
    A cursor is a small bitmap usually used for denoting where the mouse
    pointer is, with a picture that might indicate the interpretation of a
    mouse click.
    """

    @overload
    def __init__(self, cursorName: str, type: BitmapType=BITMAP_TYPE_ANY, hotSpotX: int=0, hotSpotY: int=0) -> None:
        ...

    @overload
    def __init__(self, cursorId: StockCursor) -> None:
        ...

    @overload
    def __init__(self, image: Image) -> None:
        ...

    @overload
    def __init__(self, cursor: Cursor) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Cursor() -> None
        Cursor(cursorName, type=BITMAP_TYPE_ANY, hotSpotX=0, hotSpotY=0) -> None
        Cursor(cursorId) -> None
        Cursor(image) -> None
        Cursor(cursor) -> None
        
        A cursor is a small bitmap usually used for denoting where the mouse
        pointer is, with a picture that might indicate the interpretation of a
        mouse click.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if cursor data is present.
        """

    def GetHotSpot(self) -> Point:
        """
        GetHotSpot() -> Point
        
        Returns the coordinates of the cursor hot spot.
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def GetHandle(self) -> int:
        """
        GetHandle() -> int
        
        Get the handle for the Cursor.  Windows only.
        """

    def SetHandle(self, handle: int) -> None:
        """
        SetHandle(handle) -> None
        
        Set the handle to use for this Cursor.  Windows only.
        """

    def _copyFrom(self, other: Cursor) -> None:
        """
        _copyFrom(other) -> None
        
        For internal use only.
        """
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int, /) -> None: ...
    @property
    def HotSpot(self) -> Point: ...
# end of class Cursor

NullCursor: Cursor

# These stock cursors will be initialized when the wx.App object is created.
STANDARD_CURSOR = Cursor()
HOURGLASS_CURSOR = Cursor()
CROSS_CURSOR = Cursor()

StockCursor = wx.deprecated(Cursor, "Use Cursor instead.")

CursorFromImage = wx.deprecated(Cursor, "Use Cursor instead.")
#-- end-cursor --#
#-- begin-region --#

class _RegionContain(IntEnum):
    OutRegion = auto()
    PartRegion = auto()
    InRegion = auto()
RegionContain: TypeAlias = Union[_RegionContain, int]
OutRegion = _RegionContain.OutRegion
PartRegion = _RegionContain.PartRegion
InRegion = _RegionContain.InRegion

class RegionIterator(Object):
    """
    RegionIterator() -> None
    RegionIterator(region) -> None
    
    This class is used to iterate through the rectangles in a region,
    typically when examining the damaged regions of a window within an
    OnPaint call.
    """

    @overload
    def __init__(self, region: Region) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        RegionIterator() -> None
        RegionIterator(region) -> None
        
        This class is used to iterate through the rectangles in a region,
        typically when examining the damaged regions of a window within an
        OnPaint call.
        """

    def GetH(self) -> int:
        """
        GetH() -> int
        
        An alias for GetHeight().
        """

    def GetHeight(self) -> int:
        """
        GetHeight() -> int
        
        Returns the height value for the current region.
        """

    def GetRect(self) -> Rect:
        """
        GetRect() -> Rect
        
        Returns the current rectangle.
        """

    def GetW(self) -> int:
        """
        GetW() -> int
        
        An alias for GetWidth().
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Returns the width value for the current region.
        """

    def GetX(self) -> int:
        """
        GetX() -> int
        
        Returns the x value for the current region.
        """

    def GetY(self) -> int:
        """
        GetY() -> int
        
        Returns the y value for the current region.
        """

    def HaveRects(self) -> bool:
        """
        HaveRects() -> bool
        
        Returns true if there are still some rectangles; otherwise returns
        false.
        """

    @overload
    def Reset(self, region: Region) -> None:
        ...

    @overload
    def Reset(self) -> None:
        """
        Reset() -> None
        Reset(region) -> None
        
        Resets the iterator to the beginning of the rectangles.
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        
        Returns true while there are still rectangles available in the
        iteration.
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        
        Returns true while there are still rectangles available in the
        iteration.
        """

    def Next(self) -> None:
        """
        Next() -> None
        
        Move the iterator to the next rectangle in the region.
        """
    @property
    def H(self) -> int: ...
    @property
    def Height(self) -> int: ...
    @property
    def Rect(self) -> Rect: ...
    @property
    def W(self) -> int: ...
    @property
    def Width(self) -> int: ...
    @property
    def X(self) -> int: ...
    @property
    def Y(self) -> int: ...
# end of class RegionIterator


class Region(GDIObject):
    """
    Region() -> None
    Region(x, y, width, height) -> None
    Region(topLeft, bottomRight) -> None
    Region(rect) -> None
    Region(region) -> None
    Region(bmp) -> None
    Region(bmp, transColour, tolerance=0) -> None
    Region(points, fillStyle=ODDEVEN_RULE) -> None
    
    A wxRegion represents a simple or complex region on a device context
    or window.
    """

    @overload
    def __init__(self, x: int, y: int, width: int, height: int) -> None:
        ...

    @overload
    def __init__(self, topLeft: Point, bottomRight: Point) -> None:
        ...

    @overload
    def __init__(self, rect: Rect) -> None:
        ...

    @overload
    def __init__(self, region: Region) -> None:
        ...

    @overload
    def __init__(self, bmp: Bitmap) -> None:
        ...

    @overload
    def __init__(self, bmp: Bitmap, transColour: Colour, tolerance: int=0) -> None:
        ...

    @overload
    def __init__(self, points: Any, fillStyle: PolygonFillMode=ODDEVEN_RULE) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Region() -> None
        Region(x, y, width, height) -> None
        Region(topLeft, bottomRight) -> None
        Region(rect) -> None
        Region(region) -> None
        Region(bmp) -> None
        Region(bmp, transColour, tolerance=0) -> None
        Region(points, fillStyle=ODDEVEN_RULE) -> None
        
        A wxRegion represents a simple or complex region on a device context
        or window.
        """

    def GetBox(self) -> Rect:
        """
        GetBox() -> Rect
        
        Returns the outer bounds of the region.
        """

    @overload
    def Offset(self, pt: Point) -> bool:
        ...

    @overload
    def Offset(self, x: int, y: int) -> bool:
        """
        Offset(x, y) -> bool
        Offset(pt) -> bool
        
        Moves the region by the specified offsets in horizontal and vertical
        directions.
        """

    def Clear(self) -> None:
        """
        Clear() -> None
        
        Clears the current region.
        """

    @overload
    def Contains(self, pt: Point) -> RegionContain:
        ...

    @overload
    def Contains(self, x: int, y: int, width: int, height: int) -> RegionContain:
        ...

    @overload
    def Contains(self, rect: Rect) -> RegionContain:
        ...

    @overload
    def Contains(self, x: int, y: int) -> RegionContain:
        """
        Contains(x, y) -> RegionContain
        Contains(pt) -> RegionContain
        Contains(x, y, width, height) -> RegionContain
        Contains(rect) -> RegionContain
        
        Returns a value indicating whether the given point is contained within
        the region.
        """

    def ConvertToBitmap(self) -> Bitmap:
        """
        ConvertToBitmap() -> Bitmap
        
        Convert the region to a black and white bitmap with the white pixels
        being inside the region.
        """

    @overload
    def Intersect(self, rect: Rect) -> bool:
        ...

    @overload
    def Intersect(self, region: Region) -> bool:
        ...

    @overload
    def Intersect(self, x: int, y: int, width: int, height: int) -> bool:
        """
        Intersect(x, y, width, height) -> bool
        Intersect(rect) -> bool
        Intersect(region) -> bool
        
        Finds the intersection of this region and another, rectangular region,
        specified using position and size.
        """

    def IsEmpty(self) -> bool:
        """
        IsEmpty() -> bool
        
        Returns true if the region is empty, false otherwise.
        """

    def IsEqual(self, region: Region) -> bool:
        """
        IsEqual(region) -> bool
        
        Returns true if the region is equal to, i.e. covers the same area as,
        another one.
        """

    @overload
    def Subtract(self, region: Region) -> bool:
        ...

    @overload
    def Subtract(self, rect: Rect) -> bool:
        """
        Subtract(rect) -> bool
        Subtract(region) -> bool
        
        Subtracts a rectangular region from this region.
        """

    @overload
    def Union(self, rect: Rect) -> bool:
        ...

    @overload
    def Union(self, region: Region) -> bool:
        ...

    @overload
    def Union(self, bmp: Bitmap) -> bool:
        ...

    @overload
    def Union(self, bmp: Bitmap, transColour: Colour, tolerance: int=0) -> bool:
        ...

    @overload
    def Union(self, x: int, y: int, width: int, height: int) -> bool:
        """
        Union(x, y, width, height) -> bool
        Union(rect) -> bool
        Union(region) -> bool
        Union(bmp) -> bool
        Union(bmp, transColour, tolerance=0) -> bool
        
        Finds the union of this region and another, rectangular region,
        specified using position and size.
        """

    @overload
    def Xor(self, rect: Rect) -> bool:
        ...

    @overload
    def Xor(self, region: Region) -> bool:
        ...

    @overload
    def Xor(self, x: int, y: int, width: int, height: int) -> bool:
        """
        Xor(x, y, width, height) -> bool
        Xor(rect) -> bool
        Xor(region) -> bool
        
        Finds the Xor of this region and another, rectangular region,
        specified using position and size.
        """

    def __iter__(self):
        """
        Returns a rectangle iterator conforming to the Python iterator
        protocol.
        """

    class PyRegionIterator(object):
        "A Python iterator for wx.Region objects"
        def __init__(self, region):
            self._region = region
            self._iterator = wx.RegionIterator(region)
        def next(self):
            if not self._iterator:
                raise StopIteration
            rect = self._iterator.GetRect()
            if self._iterator.HaveRects():
                self._iterator.Next()
            return rect
        __next__ = next  # for Python 3
    @property
    def Box(self) -> Rect: ...
# end of class Region

#-- end-region --#
#-- begin-dc --#

class _RasterOperationMode(IntEnum):
    CLEAR = auto()
    XOR = auto()
    INVERT = auto()
    OR_REVERSE = auto()
    AND_REVERSE = auto()
    COPY = auto()
    AND = auto()
    AND_INVERT = auto()
    NO_OP = auto()
    NOR = auto()
    EQUIV = auto()
    SRC_INVERT = auto()
    OR_INVERT = auto()
    NAND = auto()
    OR = auto()
    SET = auto()
RasterOperationMode: TypeAlias = Union[_RasterOperationMode, int]
CLEAR = _RasterOperationMode.CLEAR
XOR = _RasterOperationMode.XOR
INVERT = _RasterOperationMode.INVERT
OR_REVERSE = _RasterOperationMode.OR_REVERSE
AND_REVERSE = _RasterOperationMode.AND_REVERSE
COPY = _RasterOperationMode.COPY
AND = _RasterOperationMode.AND
AND_INVERT = _RasterOperationMode.AND_INVERT
NO_OP = _RasterOperationMode.NO_OP
NOR = _RasterOperationMode.NOR
EQUIV = _RasterOperationMode.EQUIV
SRC_INVERT = _RasterOperationMode.SRC_INVERT
OR_INVERT = _RasterOperationMode.OR_INVERT
NAND = _RasterOperationMode.NAND
OR = _RasterOperationMode.OR
SET = _RasterOperationMode.SET

class _FloodFillStyle(IntEnum):
    FLOOD_SURFACE = auto()
    FLOOD_BORDER = auto()
FloodFillStyle: TypeAlias = Union[_FloodFillStyle, int]
FLOOD_SURFACE = _FloodFillStyle.FLOOD_SURFACE
FLOOD_BORDER = _FloodFillStyle.FLOOD_BORDER

class _MappingMode(IntEnum):
    MM_TEXT = auto()
    MM_METRIC = auto()
    MM_LOMETRIC = auto()
    MM_TWIPS = auto()
    MM_POINTS = auto()
MappingMode: TypeAlias = Union[_MappingMode, int]
MM_TEXT = _MappingMode.MM_TEXT
MM_METRIC = _MappingMode.MM_METRIC
MM_LOMETRIC = _MappingMode.MM_LOMETRIC
MM_TWIPS = _MappingMode.MM_TWIPS
MM_POINTS = _MappingMode.MM_POINTS

class FontMetrics:
    """
    FontMetrics() -> None
    
    Simple collection of various font metrics.
    """

    def __init__(self) -> None:
        """
        FontMetrics() -> None
        
        Simple collection of various font metrics.
        """
    height: int
    ascent: int
    descent: int
    internalLeading: int
    externalLeading: int
    averageWidth: int
# end of class FontMetrics


class DC(Object):
    """
    A wxDC is a "device context" onto which graphics and text can be
    drawn.
    """

    def DeviceToLogicalX(self, x: int) -> int:
        """
        DeviceToLogicalX(x) -> int
        
        Convert device X coordinate to logical coordinate, using the current
        mapping mode, user scale factor, device origin and axis orientation.
        """

    def DeviceToLogicalXRel(self, x: int) -> int:
        """
        DeviceToLogicalXRel(x) -> int
        
        Convert device X coordinate to relative logical coordinate, using the
        current mapping mode and user scale factor but ignoring the axis
        orientation.
        """

    def DeviceToLogicalY(self, y: int) -> int:
        """
        DeviceToLogicalY(y) -> int
        
        Converts device Y coordinate to logical coordinate, using the current
        mapping mode, user scale factor, device origin and axis orientation.
        """

    def DeviceToLogicalYRel(self, y: int) -> int:
        """
        DeviceToLogicalYRel(y) -> int
        
        Convert device Y coordinate to relative logical coordinate, using the
        current mapping mode and user scale factor but ignoring the axis
        orientation.
        """

    def LogicalToDeviceX(self, x: int) -> int:
        """
        LogicalToDeviceX(x) -> int
        
        Converts logical X coordinate to device coordinate, using the current
        mapping mode, user scale factor, device origin and axis orientation.
        """

    def LogicalToDeviceXRel(self, x: int) -> int:
        """
        LogicalToDeviceXRel(x) -> int
        
        Converts logical X coordinate to relative device coordinate, using the
        current mapping mode and user scale factor but ignoring the axis
        orientation.
        """

    def LogicalToDeviceY(self, y: int) -> int:
        """
        LogicalToDeviceY(y) -> int
        
        Converts logical Y coordinate to device coordinate, using the current
        mapping mode, user scale factor, device origin and axis orientation.
        """

    def LogicalToDeviceYRel(self, y: int) -> int:
        """
        LogicalToDeviceYRel(y) -> int
        
        Converts logical Y coordinate to relative device coordinate, using the
        current mapping mode and user scale factor but ignoring the axis
        orientation.
        """

    @overload
    def DeviceToLogical(self, pt: Point) -> Point:
        ...

    @overload
    def DeviceToLogical(self, x: int, y: int) -> Point:
        """
        DeviceToLogical(x, y) -> Point
        DeviceToLogical(pt) -> Point
        
        Converts device (x, y) coordinates to logical coordinates taking into
        account all applied transformations like the current mapping mode,
        scale factors, device origin, axes orientation, affine transformation.
        """

    @overload
    def DeviceToLogicalRel(self, dim: Size) -> Size:
        ...

    @overload
    def DeviceToLogicalRel(self, x: int, y: int) -> Size:
        """
        DeviceToLogicalRel(x, y) -> Size
        DeviceToLogicalRel(dim) -> Size
        
        Converts device x, y coordinates to relative logical coordinates
        taking into account all applied transformations like the current
        mapping mode, scale factors, affine transformation.
        """

    @overload
    def LogicalToDevice(self, pt: Point) -> Point:
        ...

    @overload
    def LogicalToDevice(self, x: int, y: int) -> Point:
        """
        LogicalToDevice(x, y) -> Point
        LogicalToDevice(pt) -> Point
        
        Converts logical (x, y) coordinates to device coordinates taking into
        account all applied transformations like the current mapping mode,
        scale factors, device origin, axes orientation, affine transformation.
        """

    @overload
    def LogicalToDeviceRel(self, dim: Size) -> Size:
        ...

    @overload
    def LogicalToDeviceRel(self, x: int, y: int) -> Size:
        """
        LogicalToDeviceRel(x, y) -> Size
        LogicalToDeviceRel(dim) -> Size
        
        Converts logical x, y coordinates to relative device coordinates
        taking into account all applied transformations like the current
        mapping mode, scale factors, affine transformation.
        """

    def Clear(self) -> None:
        """
        Clear() -> None
        
        Clears the device context using the current background brush.
        """

    @overload
    def DrawArc(self, ptStart: Point, ptEnd: Point, centre: Point) -> None:
        ...

    @overload
    def DrawArc(self, xStart: int, yStart: int, xEnd: int, yEnd: int, xc: int, yc: int) -> None:
        """
        DrawArc(xStart, yStart, xEnd, yEnd, xc, yc) -> None
        DrawArc(ptStart, ptEnd, centre) -> None
        
        Draws an arc from the given start to the given end point.
        """

    @overload
    def DrawBitmap(self, bmp: Bitmap, pt: Point, useMask: bool=False) -> None:
        ...

    @overload
    def DrawBitmap(self, bitmap: Bitmap, x: int, y: int, useMask: bool=False) -> None:
        """
        DrawBitmap(bitmap, x, y, useMask=False) -> None
        DrawBitmap(bmp, pt, useMask=False) -> None
        
        Draw a bitmap on the device context at the specified point.
        """

    @overload
    def DrawCheckMark(self, rect: Rect) -> None:
        ...

    @overload
    def DrawCheckMark(self, x: int, y: int, width: int, height: int) -> None:
        """
        DrawCheckMark(x, y, width, height) -> None
        DrawCheckMark(rect) -> None
        
        Draws a check mark inside the given rectangle.
        """

    @overload
    def DrawCircle(self, pt: Point, radius: int) -> None:
        ...

    @overload
    def DrawCircle(self, x: int, y: int, radius: int) -> None:
        """
        DrawCircle(x, y, radius) -> None
        DrawCircle(pt, radius) -> None
        
        Draws a circle with the given centre and radius.
        """

    @overload
    def DrawEllipse(self, pt: Point, size: Size) -> None:
        ...

    @overload
    def DrawEllipse(self, rect: Rect) -> None:
        ...

    @overload
    def DrawEllipse(self, x: int, y: int, width: int, height: int) -> None:
        """
        DrawEllipse(x, y, width, height) -> None
        DrawEllipse(pt, size) -> None
        DrawEllipse(rect) -> None
        
        Draws an ellipse contained in the rectangle specified either with the
        given top left corner and the given size or directly.
        """

    @overload
    def DrawEllipticArc(self, pt: Point, sz: Size, sa: float, ea: float) -> None:
        ...

    @overload
    def DrawEllipticArc(self, x: int, y: int, width: int, height: int, start: float, end: float) -> None:
        """
        DrawEllipticArc(x, y, width, height, start, end) -> None
        DrawEllipticArc(pt, sz, sa, ea) -> None
        
        Draws an arc of an ellipse.
        """

    @overload
    def DrawIcon(self, icon: Icon, pt: Point) -> None:
        ...

    @overload
    def DrawIcon(self, icon: Icon, x: int, y: int) -> None:
        """
        DrawIcon(icon, x, y) -> None
        DrawIcon(icon, pt) -> None
        
        Draw an icon on the display (does nothing if the device context is
        PostScript).
        """

    @overload
    def DrawLabel(self, text: str, rect: Rect, alignment: int=ALIGN_LEFT|ALIGN_TOP, indexAccel: int=-1) -> None:
        ...

    @overload
    def DrawLabel(self, text: str, bitmap: Bitmap, rect: Rect, alignment: int=ALIGN_LEFT|ALIGN_TOP, indexAccel: int=-1) -> Rect:
        """
        DrawLabel(text, bitmap, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1) -> Rect
        DrawLabel(text, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1) -> None
        
        Draw optional bitmap and the text into the given rectangle and aligns
        it as specified by alignment parameter; it also will emphasize the
        character with the given index if it is != -1 and return the bounding
        rectangle if required.
        """

    @overload
    def DrawLine(self, pt1: Point, pt2: Point) -> None:
        ...

    @overload
    def DrawLine(self, x1: int, y1: int, x2: int, y2: int) -> None:
        """
        DrawLine(x1, y1, x2, y2) -> None
        DrawLine(pt1, pt2) -> None
        
        Draws a line from the first point to the second.
        """

    def DrawLines(self, points: PointList, xoffset: int=0, yoffset: int=0) -> None:
        """
        DrawLines(points, xoffset=0, yoffset=0) -> None
        
        This method uses a list of wxPoints, adding the optional offset
        coordinate.
        """

    @overload
    def DrawPoint(self, pt: Point) -> None:
        ...

    @overload
    def DrawPoint(self, x: int, y: int) -> None:
        """
        DrawPoint(x, y) -> None
        DrawPoint(pt) -> None
        
        Draws a point using the color of the current pen.
        """

    def DrawPolygon(self, points: PointList, xoffset: int=0, yoffset: int=0, fill_style: PolygonFillMode=ODDEVEN_RULE) -> None:
        """
        DrawPolygon(points, xoffset=0, yoffset=0, fill_style=ODDEVEN_RULE) -> None
        
        This method draws a filled polygon using a list of wxPoints, adding
        the optional offset coordinate.
        """

    @overload
    def DrawRectangle(self, pt: Point, sz: Size) -> None:
        ...

    @overload
    def DrawRectangle(self, rect: Rect) -> None:
        ...

    @overload
    def DrawRectangle(self, x: int, y: int, width: int, height: int) -> None:
        """
        DrawRectangle(x, y, width, height) -> None
        DrawRectangle(pt, sz) -> None
        DrawRectangle(rect) -> None
        
        Draws a rectangle with the given corner coordinate and size.
        """

    @overload
    def DrawRotatedText(self, text: str, point: Point, angle: float) -> None:
        ...

    @overload
    def DrawRotatedText(self, text: str, x: int, y: int, angle: float) -> None:
        """
        DrawRotatedText(text, x, y, angle) -> None
        DrawRotatedText(text, point, angle) -> None
        
        Draws the text rotated by angle degrees (positive angles are
        counterclockwise; the full angle is 360 degrees).
        """

    @overload
    def DrawRoundedRectangle(self, pt: Point, sz: Size, radius: float) -> None:
        ...

    @overload
    def DrawRoundedRectangle(self, rect: Rect, radius: float) -> None:
        ...

    @overload
    def DrawRoundedRectangle(self, x: int, y: int, width: int, height: int, radius: float) -> None:
        """
        DrawRoundedRectangle(x, y, width, height, radius) -> None
        DrawRoundedRectangle(pt, sz, radius) -> None
        DrawRoundedRectangle(rect, radius) -> None
        
        Draws a rectangle with the given top left corner, and with the given
        size.
        """

    @overload
    def DrawSpline(self, x1: int, y1: int, x2: int, y2: int, x3: int, y3: int) -> None:
        ...

    @overload
    def DrawSpline(self, points: PointList) -> None:
        """
        DrawSpline(points) -> None
        DrawSpline(x1, y1, x2, y2, x3, y3) -> None
        
        This is an overloaded member function, provided for convenience. It
        differs from the above function only in what argument(s) it accepts.
        """

    @overload
    def DrawText(self, text: str, pt: Point) -> None:
        ...

    @overload
    def DrawText(self, text: str, x: int, y: int) -> None:
        """
        DrawText(text, x, y) -> None
        DrawText(text, pt) -> None
        
        Draws a text string at the specified point, using the current text
        font, and the current text foreground and background colours.
        """

    @overload
    def GradientFillConcentric(self, rect: Rect, initialColour: Colour, destColour: Colour, circleCenter: Point) -> None:
        ...

    @overload
    def GradientFillConcentric(self, rect: Rect, initialColour: Colour, destColour: Colour) -> None:
        """
        GradientFillConcentric(rect, initialColour, destColour) -> None
        GradientFillConcentric(rect, initialColour, destColour, circleCenter) -> None
        
        Fill the area specified by rect with a radial gradient, starting from
        initialColour at the centre of the circle and fading to destColour on
        the circle outside.
        """

    def GradientFillLinear(self, rect: Rect, initialColour: Colour, destColour: Colour, nDirection: Direction=RIGHT) -> None:
        """
        GradientFillLinear(rect, initialColour, destColour, nDirection=RIGHT) -> None
        
        Fill the area specified by rect with a linear gradient, starting from
        initialColour and eventually fading to destColour.
        """

    @overload
    def FloodFill(self, pt: Point, col: Colour, style: FloodFillStyle=FLOOD_SURFACE) -> bool:
        ...

    @overload
    def FloodFill(self, x: int, y: int, colour: Colour, style: FloodFillStyle=FLOOD_SURFACE) -> bool:
        """
        FloodFill(x, y, colour, style=FLOOD_SURFACE) -> bool
        FloodFill(pt, col, style=FLOOD_SURFACE) -> bool
        
        Flood fills the device context starting from the given point, using
        the current brush colour, and using a style:
        """

    @overload
    def CrossHair(self, pt: Point) -> None:
        ...

    @overload
    def CrossHair(self, x: int, y: int) -> None:
        """
        CrossHair(x, y) -> None
        CrossHair(pt) -> None
        
        Displays a cross hair using the current pen.
        """

    def DestroyClippingRegion(self) -> None:
        """
        DestroyClippingRegion() -> None
        
        Destroys the current clipping region so that none of the DC is
        clipped.
        """

    def GetClippingBox(self) -> Tuple[bool, int, int, int, int]:
        """
        GetClippingBox() -> Tuple[bool, int, int, int, int]
        
        Gets the rectangle surrounding the current clipping region.
        """

    @overload
    def SetClippingRegion(self, pt: Point, sz: Size) -> None:
        ...

    @overload
    def SetClippingRegion(self, rect: Rect) -> None:
        ...

    @overload
    def SetClippingRegion(self, x: int, y: int, width: int, height: int) -> None:
        """
        SetClippingRegion(x, y, width, height) -> None
        SetClippingRegion(pt, sz) -> None
        SetClippingRegion(rect) -> None
        
        Sets the clipping region for this device context to the intersection
        of the given region described by the parameters of this method and the
        previously set clipping region.
        """

    def SetDeviceClippingRegion(self, region: Region) -> None:
        """
        SetDeviceClippingRegion(region) -> None
        
        Sets the clipping region for this device context.
        """

    def GetCharHeight(self) -> int:
        """
        GetCharHeight() -> int
        
        Gets the character height of the currently set font.
        """

    def GetCharWidth(self) -> int:
        """
        GetCharWidth() -> int
        
        Gets the average character width of the currently set font.
        """

    def GetFontMetrics(self) -> FontMetrics:
        """
        GetFontMetrics() -> FontMetrics
        
        Returns the various font characteristics.
        """

    def GetFullMultiLineTextExtent(self, string: str, font: Optional[Font]=None) -> Tuple[int, int, int]:
        """
        GetFullMultiLineTextExtent(string, font=None) -> Tuple[int, int, int]
        
        Gets the dimensions of the string as it would be drawn.
        """

    def GetPartialTextExtents(self, text: str) -> List[int]:
        """
        GetPartialTextExtents(text) -> List[int]
        
        Fills the widths array with the widths from the beginning of text to
        the corresponding character of text.
        """

    def GetFullTextExtent(self, string: str, font: Optional[Font]=None) -> Tuple[int, int, int, int]:
        """
        GetFullTextExtent(string, font=None) -> Tuple[int, int, int, int]
        
        Gets the dimensions of the string as it would be drawn.
        """

    def GetBackgroundMode(self) -> int:
        """
        GetBackgroundMode() -> int
        
        Returns the current background mode: wxBRUSHSTYLE_SOLID or
        wxBRUSHSTYLE_TRANSPARENT.
        """

    def GetFont(self) -> Font:
        """
        GetFont() -> Font
        
        Gets the current font.
        """

    def GetLayoutDirection(self) -> LayoutDirection:
        """
        GetLayoutDirection() -> LayoutDirection
        
        Gets the current layout direction of the device context.
        """

    def GetTextBackground(self) -> Colour:
        """
        GetTextBackground() -> Colour
        
        Gets the current text background colour.
        """

    def GetTextForeground(self) -> Colour:
        """
        GetTextForeground() -> Colour
        
        Gets the current text foreground colour.
        """

    def SetBackgroundMode(self, mode: int) -> None:
        """
        SetBackgroundMode(mode) -> None
        
        Change the current background mode.
        """

    def SetFont(self, font: Font) -> None:
        """
        SetFont(font) -> None
        
        Sets the current font for the DC.
        """

    def SetTextBackground(self, colour: Colour) -> None:
        """
        SetTextBackground(colour) -> None
        
        Sets the current text background colour for the DC.
        """

    def SetTextForeground(self, colour: Colour) -> None:
        """
        SetTextForeground(colour) -> None
        
        Sets the current text foreground colour for the DC.
        """

    def SetLayoutDirection(self, dir: LayoutDirection) -> None:
        """
        SetLayoutDirection(dir) -> None
        
        Sets the current layout direction for the device context.
        """

    def CalcBoundingBox(self, x: int, y: int) -> None:
        """
        CalcBoundingBox(x, y) -> None
        
        Adds the specified point to the bounding box which can be retrieved
        with MinX(), MaxX() and MinY(), MaxY() functions.
        """

    def MaxX(self) -> int:
        """
        MaxX() -> int
        
        Gets the maximum horizontal extent used in drawing commands so far.
        """

    def MaxY(self) -> int:
        """
        MaxY() -> int
        
        Gets the maximum vertical extent used in drawing commands so far.
        """

    def MinX(self) -> int:
        """
        MinX() -> int
        
        Gets the minimum horizontal extent used in drawing commands so far.
        """

    def MinY(self) -> int:
        """
        MinY() -> int
        
        Gets the minimum vertical extent used in drawing commands so far.
        """

    def ResetBoundingBox(self) -> None:
        """
        ResetBoundingBox() -> None
        
        Resets the bounding box: after a call to this function, the bounding
        box doesn't contain anything.
        """

    def StartDoc(self, message: str) -> bool:
        """
        StartDoc(message) -> bool
        
        Starts a document (only relevant when outputting to a printer).
        """

    def StartPage(self) -> None:
        """
        StartPage() -> None
        
        Starts a document page (only relevant when outputting to a printer).
        """

    def EndDoc(self) -> None:
        """
        EndDoc() -> None
        
        Ends a document (only relevant when outputting to a printer).
        """

    def EndPage(self) -> None:
        """
        EndPage() -> None
        
        Ends a document page (only relevant when outputting to a printer).
        """

    def Blit(self, xdest: int, ydest: int, width: int, height: int, source: DC, xsrc: int, ysrc: int, logicalFunc: RasterOperationMode=COPY, useMask: bool=False, xsrcMask: int=DefaultCoord, ysrcMask: int=DefaultCoord) -> bool:
        """
        Blit(xdest, ydest, width, height, source, xsrc, ysrc, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool
        
        Copy from a source DC to this DC.
        """

    def StretchBlit(self, xdest: int, ydest: int, dstWidth: int, dstHeight: int, source: DC, xsrc: int, ysrc: int, srcWidth: int, srcHeight: int, logicalFunc: RasterOperationMode=COPY, useMask: bool=False, xsrcMask: int=DefaultCoord, ysrcMask: int=DefaultCoord) -> bool:
        """
        StretchBlit(xdest, ydest, dstWidth, dstHeight, source, xsrc, ysrc, srcWidth, srcHeight, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool
        
        Copy from a source DC to this DC possibly changing the scale.
        """

    def GetBackground(self) -> Brush:
        """
        GetBackground() -> Brush
        
        Gets the brush used for painting the background.
        """

    def GetBrush(self) -> Brush:
        """
        GetBrush() -> Brush
        
        Gets the current brush.
        """

    def GetPen(self) -> Pen:
        """
        GetPen() -> Pen
        
        Gets the current pen.
        """

    def SetBackground(self, brush: Brush) -> None:
        """
        SetBackground(brush) -> None
        
        Sets the current background brush for the DC.
        """

    def SetBrush(self, brush: Brush) -> None:
        """
        SetBrush(brush) -> None
        
        Sets the current brush for the DC.
        """

    def SetPen(self, pen: Pen) -> None:
        """
        SetPen(pen) -> None
        
        Sets the current pen for the DC.
        """

    def CanUseTransformMatrix(self) -> bool:
        """
        CanUseTransformMatrix() -> bool
        
        Check if the use of transformation matrix is supported by the current
        system.
        """

    def SetTransformMatrix(self, matrix: AffineMatrix2D) -> bool:
        """
        SetTransformMatrix(matrix) -> bool
        
        Set the transformation matrix.
        """

    def GetTransformMatrix(self) -> AffineMatrix2D:
        """
        GetTransformMatrix() -> AffineMatrix2D
        
        Return the transformation matrix used by this device context.
        """

    def ResetTransformMatrix(self) -> None:
        """
        ResetTransformMatrix() -> None
        
        Revert the transformation matrix to identity matrix.
        """

    def CanDrawBitmap(self) -> bool:
        """
        CanDrawBitmap() -> bool
        
        Does the DC support drawing bitmaps?
        """

    def CanGetTextExtent(self) -> bool:
        """
        CanGetTextExtent() -> bool
        
        Does the DC support calculating the size required to draw text?
        """

    def GetLogicalOrigin(self) -> Tuple[int, int]:
        """
        GetLogicalOrigin() -> Tuple[int, int]
        
        Return the coordinates of the logical point (0, 0).
        """

    def CopyAttributes(self, dc: DC) -> None:
        """
        CopyAttributes(dc) -> None
        
        Copy attributes from another DC.
        """

    def GetContentScaleFactor(self) -> float:
        """
        GetContentScaleFactor() -> float
        
        Returns the factor used for converting logical pixels to physical
        ones.
        """

    def GetDepth(self) -> int:
        """
        GetDepth() -> int
        
        Returns the depth (number of bits/pixel) of this DC.
        """

    def GetDeviceOrigin(self) -> Point:
        """
        GetDeviceOrigin() -> Point
        
        Returns the current device origin.
        """

    def GetLogicalFunction(self) -> RasterOperationMode:
        """
        GetLogicalFunction() -> RasterOperationMode
        
        Gets the current logical function.
        """

    def GetMapMode(self) -> MappingMode:
        """
        GetMapMode() -> MappingMode
        
        Gets the current mapping mode for the device context.
        """

    def GetPixel(self, x: int, y: int) -> Colour:
        """
        GetPixel(x, y) -> Colour
        
        Gets the colour at the specified location on the DC.
        
        This method isn't available for ``wx.PostScriptDC`` or
        ``wx.MetafileDC`` nor
        for any DC in wxOSX port, and simply returns ``wx.NullColour`` there.
        
        .. note:: Setting a pixel can be done using DrawPoint().
        
        .. note:: This method shouldn't be used with ``wx.PaintDC`` as
        accessing the
                  DC while drawing can result in unexpected results, notably
        in wxGTK.
        """

    def GetPPI(self) -> Size:
        """
        GetPPI() -> Size
        
        Returns the resolution of the device in pixels per inch.
        """

    @overload
    def FromDIP(self, pt: Point) -> Point:
        ...

    @overload
    def FromDIP(self, d: int) -> int:
        ...

    @overload
    def FromDIP(self, sz: Size) -> Size:
        """
        FromDIP(sz) -> Size
        FromDIP(pt) -> Point
        FromDIP(d) -> int
        
        Convert DPI-independent pixel values to the value in pixels
        appropriate for the DC.
        """

    @overload
    def ToDIP(self, pt: Point) -> Point:
        ...

    @overload
    def ToDIP(self, d: int) -> int:
        ...

    @overload
    def ToDIP(self, sz: Size) -> Size:
        """
        ToDIP(sz) -> Size
        ToDIP(pt) -> Point
        ToDIP(d) -> int
        
        Convert pixel values of the current DC to DPI-independent pixel
        values.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        This is an overloaded member function, provided for convenience. It
        differs from the above function only in what argument(s) it accepts.
        """

    def GetSizeMM(self) -> Size:
        """
        GetSizeMM() -> Size
        
        This is an overloaded member function, provided for convenience. It
        differs from the above function only in what argument(s) it accepts.
        """

    def GetUserScale(self) -> Tuple[float, float]:
        """
        GetUserScale() -> Tuple[float, float]
        
        Gets the current user scale factor.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the DC is ok to use.
        """

    def SetAxisOrientation(self, xLeftRight: bool, yBottomUp: bool) -> None:
        """
        SetAxisOrientation(xLeftRight, yBottomUp) -> None
        
        Sets the x and y axis orientation (i.e. the direction from lowest to
        highest values on the axis).
        """

    def SetDeviceOrigin(self, x: int, y: int) -> None:
        """
        SetDeviceOrigin(x, y) -> None
        
        Sets the device origin (i.e. the origin in pixels after scaling has
        been applied).
        """

    def SetLogicalFunction(self, function: RasterOperationMode) -> None:
        """
        SetLogicalFunction(function) -> None
        
        Sets the current logical function for the device context.
        """

    def SetMapMode(self, mode: MappingMode) -> None:
        """
        SetMapMode(mode) -> None
        
        The mapping mode of the device context defines the unit of measurement
        used to convert logical units to device units.
        """

    def SetPalette(self, palette: Palette) -> None:
        """
        SetPalette(palette) -> None
        
        If this is a window DC or memory DC, assigns the given palette to the
        window or bitmap associated with the DC.
        """

    def SetUserScale(self, xScale: float, yScale: float) -> None:
        """
        SetUserScale(xScale, yScale) -> None
        
        Sets the user scaling factor, useful for applications which require
        'zooming'.
        """

    def GetHandle(self) -> UIntPtr:
        """
        GetHandle() -> UIntPtr
        
        Returns a value that can be used as a handle to the native drawing
        context, if this wxDC has something that could be thought of in that
        way.
        """

    def GetAsBitmap(self, subrect: Optional[Rect]=None) -> Bitmap:
        """
        GetAsBitmap(subrect=None) -> Bitmap
        
        If supported by the platform and the type of DC, fetch the contents of
        the DC, or a subset of it, as a bitmap.
        """

    def SetLogicalScale(self, x: float, y: float) -> None:
        """
        SetLogicalScale(x, y) -> None
        
        Set the scale to use for translating wxDC coordinates to the physical
        pixels.
        """

    def GetLogicalScale(self) -> Tuple[float, float]:
        """
        GetLogicalScale() -> Tuple[float, float]
        
        Return the scale set by the last call to SetLogicalScale().
        """

    def SetLogicalOrigin(self, x: int, y: int) -> None:
        """
        SetLogicalOrigin(x, y) -> None
        
        Change the offset used for translating wxDC coordinates.
        """

    def GetGraphicsContext(self) -> GraphicsContext:
        """
        GetGraphicsContext() -> GraphicsContext
        
        If supported by the platform and the wxDC implementation, this method
        will return the wxGraphicsContext associated with the DC.
        """

    def SetGraphicsContext(self, ctx: GraphicsContext) -> None:
        """
        SetGraphicsContext(ctx) -> None
        
        Associate a wxGraphicsContext with the DC.
        """

    def GetClippingRect(self):
        """
        Returns the rectangle surrounding the current clipping region as a wx.Rect.
        """

    def GetTextExtent(self, st: str) -> Size:
        """
        GetTextExtent(st) -> Size
        
        Return the dimensions of the given string's text extent using the
        currently selected font.
        
        :param st: The string to be measured
        
        .. seealso:: :meth:`~wx.DC.GetFullTextExtent`
        """

    def GetMultiLineTextExtent(self, st: str) -> Size:
        """
        GetMultiLineTextExtent(st) -> Size
        
        Return the dimensions of the given string's text extent using the
        currently selected font, taking into account multiple lines if
        present in the string.
        
        :param st: The string to be measured
        
        .. seealso:: :meth:`~wx.DC.GetFullMultiLineTextExtent`
        """

    DrawImageLabel = wx.deprecated(DrawLabel, "Use DrawLabel instead.")

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def GetBoundingBox(self):
        """
        GetBoundingBox() -> (x1,y1, x2,y2)
        
        Returns the min and max points used in drawing commands so far.
        """

    def GetHDC(self) -> int:
        """
        GetHDC() -> int
        """

    def GetCGContext(self) -> UIntPtr:
        """
        GetCGContext() -> UIntPtr
        """

    def GetGdkDrawable(self) -> UIntPtr:
        """
        GetGdkDrawable() -> UIntPtr
        """

    GetHDC = wx.deprecated(GetHDC, "Use GetHandle instead.")

    GetCGContext = wx.deprecated(GetCGContext, "Use GetHandle instead.")

    GetGdkDrawable = wx.deprecated(GetGdkDrawable, "Use GetHandle instead.")

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """

    def _DrawPointList(self, pyCoords: Any, pyPens: Any, pyBrushes: Any) -> Any:
        """
        _DrawPointList(pyCoords, pyPens, pyBrushes) -> Any
        """

    def _DrawLineList(self, pyCoords: Any, pyPens: Any, pyBrushes: Any) -> Any:
        """
        _DrawLineList(pyCoords, pyPens, pyBrushes) -> Any
        """

    def _DrawRectangleList(self, pyCoords: Any, pyPens: Any, pyBrushes: Any) -> Any:
        """
        _DrawRectangleList(pyCoords, pyPens, pyBrushes) -> Any
        """

    def _DrawEllipseList(self, pyCoords: Any, pyPens: Any, pyBrushes: Any) -> Any:
        """
        _DrawEllipseList(pyCoords, pyPens, pyBrushes) -> Any
        """

    def _DrawPolygonList(self, pyCoords: Any, pyPens: Any, pyBrushes: Any) -> Any:
        """
        _DrawPolygonList(pyCoords, pyPens, pyBrushes) -> Any
        """

    def _DrawTextList(self, textList: Any, pyPoints: Any, foregroundList: Any, backgroundList: Any) -> Any:
        """
        _DrawTextList(textList, pyPoints, foregroundList, backgroundList) -> Any
        """

    def _DrawLinesFromBuffer(self, pyBuff: Any) -> Any:
        """
        _DrawLinesFromBuffer(pyBuff) -> Any
        """

    def DrawPointList(self, points, pens=None):
        """
        Draw a list of points as quickly as possible.
        
        :param points: A sequence of 2-element sequences representing
                       each point to draw, (x,y).
        :param pens:   If None, then the current pen is used.  If a single
                       pen then it will be used for all points.  If a list of
                       pens then there should be one for each point in points.
        """

    def DrawLineList(self, lines, pens=None):
        """
        Draw a list of lines as quickly as possible.
        
        :param lines: A sequence of 4-element sequences representing
                      each line to draw, (x1,y1, x2,y2).
        :param pens:  If None, then the current pen is used.  If a
                      single pen then it will be used for all lines.  If
                      a list of pens then there should be one for each line
                      in lines.
        """

    def DrawRectangleList(self, rectangles, pens=None, brushes=None):
        """
        Draw a list of rectangles as quickly as possible.
        
        :param rectangles: A sequence of 4-element sequences representing
                           each rectangle to draw, (x,y, w,h).
        :param pens:       If None, then the current pen is used.  If a
                           single pen then it will be used for all rectangles.
                           If a list of pens then there should be one for each
                           rectangle in rectangles.
        :param brushes:    A brush or brushes to be used to fill the rectagles,
                           with similar semantics as the pens parameter.
        """

    def DrawEllipseList(self, ellipses, pens=None, brushes=None):
        """
        Draw a list of ellipses as quickly as possible.
        
        :param ellipses: A sequence of 4-element sequences representing
                         each ellipse to draw, (x,y, w,h).
        :param pens:     If None, then the current pen is used.  If a
                         single pen then it will be used for all ellipses.
                         If a list of pens then there should be one for each
                         ellipse in ellipses.
        :param brushes:  A brush or brushes to be used to fill the ellipses,
                         with similar semantics as the pens parameter.
        """

    def DrawPolygonList(self, polygons, pens=None, brushes=None):
        """
        Draw a list of polygons, each of which is a list of points.
        
        :param polygons: A sequence of sequences of sequences.
                         [[(x1,y1),(x2,y2),(x3,y3)...], [(x1,y1),(x2,y2),(x3,y3)...]]
        
        :param pens:     If None, then the current pen is used.  If a
                         single pen then it will be used for all polygons.
                         If a list of pens then there should be one for each
                         polygon.
        :param brushes:  A brush or brushes to be used to fill the polygons,
                         with similar semantics as the pens parameter.
        """

    def DrawTextList(self, textList, coords, foregrounds=None, backgrounds=None):
        """
        Draw a list of strings using a list of coordinants for positioning each string.
        
        :param textList:    A list of strings
        :param coords:      A list of (x,y) positions
        :param foregrounds: A list of `wx.Colour` objects to use for the
                            foregrounds of the strings.
        :param backgrounds: A list of `wx.Colour` objects to use for the
                            backgrounds of the strings.
        
        NOTE: Make sure you set background mode to wx.Solid (DC.SetBackgroundMode)
              If you want backgrounds to do anything.
        """

    def DrawLinesFromBuffer(self, pyBuff):
        """
        Implementation of DrawLines that can use numpy arrays, or anything else that uses the
        python buffer protocol directly without any element conversion.  This provides a 
        significant performance increase over the standard DrawLines function.
        
        The pyBuff argument needs to provide an array of C integers organized as 
        x, y point pairs.  The size of a C integer is platform dependent.
        With numpy, the intc data type will provide the appropriate element size.
        
        If called with an object that doesn't support
        the python buffer protocol, or if the underlying element size does not
        match the size of a C integer, a TypeError exception is raised.  If 
        the buffer provided has float data with the same element size as a 
        C integer, no error will be raised, but the lines will not be drawn
        in the appropriate places.
        
        :param pyBuff:    A python buffer containing integer pairs
        """
    @property
    def AsBitmap(self) -> Bitmap: ...
    @property
    def Background(self) -> Brush: ...
    @Background.setter
    def Background(self, value: Brush, /) -> None: ...
    @property
    def BackgroundMode(self) -> int: ...
    @BackgroundMode.setter
    def BackgroundMode(self, value: int, /) -> None: ...
    BoundingBox = property(GetBoundingBox)
    @property
    def Brush(self) -> Brush: ...
    @Brush.setter
    def Brush(self, value: Brush, /) -> None: ...
    @property
    def CGContext(self) -> UIntPtr: ...
    @property
    def CharHeight(self) -> int: ...
    @property
    def CharWidth(self) -> int: ...
    ClippingRect = property(GetClippingRect)
    @property
    def ContentScaleFactor(self) -> float: ...
    @property
    def Depth(self) -> int: ...
    @property
    def DeviceOrigin(self) -> int: ...
    @DeviceOrigin.setter
    def DeviceOrigin(self, value: int, /) -> None: ...
    @property
    def Font(self) -> Font: ...
    @Font.setter
    def Font(self, value: Font, /) -> None: ...
    @property
    def FontMetrics(self) -> FontMetrics: ...
    @property
    def GdkDrawable(self) -> UIntPtr: ...
    @property
    def GraphicsContext(self) -> GraphicsContext: ...
    @GraphicsContext.setter
    def GraphicsContext(self, value: GraphicsContext, /) -> None: ...
    @property
    def HDC(self) -> int: ...
    @property
    def Handle(self) -> UIntPtr: ...
    @property
    def LayoutDirection(self) -> LayoutDirection: ...
    @LayoutDirection.setter
    def LayoutDirection(self, value: LayoutDirection, /) -> None: ...
    @property
    def LogicalFunction(self) -> RasterOperationMode: ...
    @LogicalFunction.setter
    def LogicalFunction(self, value: RasterOperationMode, /) -> None: ...
    @property
    def MapMode(self) -> MappingMode: ...
    @MapMode.setter
    def MapMode(self, value: MappingMode, /) -> None: ...
    @property
    def MultiLineTextExtent(self) -> Tuple[int, int, int]: ...
    @property
    def PPI(self) -> Size: ...
    @property
    def Pen(self) -> Pen: ...
    @Pen.setter
    def Pen(self, value: Pen, /) -> None: ...
    @property
    def Pixel(self) -> Colour: ...
    @property
    def Size(self) -> Size: ...
    @property
    def SizeMM(self) -> Size: ...
    @property
    def TextBackground(self) -> Colour: ...
    @TextBackground.setter
    def TextBackground(self, value: Colour, /) -> None: ...
    @property
    def TextExtent(self) -> Tuple[int, int, int, int]: ...
    @property
    def TextForeground(self) -> Colour: ...
    @TextForeground.setter
    def TextForeground(self, value: Colour, /) -> None: ...
    @property
    def TransformMatrix(self) -> AffineMatrix2D: ...
    @TransformMatrix.setter
    def TransformMatrix(self, value: AffineMatrix2D, /) -> None: ...
# end of class DC


class DCClipper:
    """
    DCClipper(dc, region) -> None
    DCClipper(dc, rect) -> None
    DCClipper(dc, x, y, w, h) -> None
    
    wxDCClipper is a helper class for setting a clipping region on a wxDC
    during its lifetime.
    """

    @overload
    def __init__(self, dc: DC, rect: Rect) -> None:
        ...

    @overload
    def __init__(self, dc: DC, x: int, y: int, w: int, h: int) -> None:
        ...

    @overload
    def __init__(self, dc: DC, region: Region) -> None:
        """
        DCClipper(dc, region) -> None
        DCClipper(dc, rect) -> None
        DCClipper(dc, x, y, w, h) -> None
        
        wxDCClipper is a helper class for setting a clipping region on a wxDC
        during its lifetime.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCClipper


class DCBrushChanger:
    """
    DCBrushChanger(dc, brush) -> None
    
    wxDCBrushChanger is a small helper class for setting a brush on a wxDC
    and unsetting it automatically in the destructor, restoring the
    previous one.
    """

    def __init__(self, dc: DC, brush: Brush) -> None:
        """
        DCBrushChanger(dc, brush) -> None
        
        wxDCBrushChanger is a small helper class for setting a brush on a wxDC
        and unsetting it automatically in the destructor, restoring the
        previous one.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCBrushChanger


class DCPenChanger:
    """
    DCPenChanger(dc, pen) -> None
    
    wxDCPenChanger is a small helper class for setting a pen on a wxDC and
    unsetting it automatically in the destructor, restoring the previous
    one.
    """

    def __init__(self, dc: DC, pen: Pen) -> None:
        """
        DCPenChanger(dc, pen) -> None
        
        wxDCPenChanger is a small helper class for setting a pen on a wxDC and
        unsetting it automatically in the destructor, restoring the previous
        one.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCPenChanger


class DCTextColourChanger:
    """
    DCTextColourChanger(dc) -> None
    DCTextColourChanger(dc, col) -> None
    
    wxDCTextColourChanger is a small helper class for setting a foreground
    text colour on a wxDC and unsetting it automatically in the
    destructor, restoring the previous one.
    """

    @overload
    def __init__(self, dc: DC, col: Colour) -> None:
        ...

    @overload
    def __init__(self, dc: DC) -> None:
        """
        DCTextColourChanger(dc) -> None
        DCTextColourChanger(dc, col) -> None
        
        wxDCTextColourChanger is a small helper class for setting a foreground
        text colour on a wxDC and unsetting it automatically in the
        destructor, restoring the previous one.
        """

    def Set(self, col: Colour) -> None:
        """
        Set(col) -> None
        
        Set the colour to use.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCTextColourChanger


class DCFontChanger:
    """
    DCFontChanger(dc) -> None
    DCFontChanger(dc, font) -> None
    
    wxDCFontChanger is a small helper class for setting a font on a wxDC
    and unsetting it automatically in the destructor, restoring the
    previous one.
    """

    @overload
    def __init__(self, dc: DC, font: Font) -> None:
        ...

    @overload
    def __init__(self, dc: DC) -> None:
        """
        DCFontChanger(dc) -> None
        DCFontChanger(dc, font) -> None
        
        wxDCFontChanger is a small helper class for setting a font on a wxDC
        and unsetting it automatically in the destructor, restoring the
        previous one.
        """

    def Set(self, font: Font) -> None:
        """
        Set(font) -> None
        
        Set the font to use.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCFontChanger


class DCTextBgColourChanger:
    """
    DCTextBgColourChanger(dc) -> None
    DCTextBgColourChanger(dc, col) -> None
    
    wxDCTextBgColourChanger is a small helper class for setting a
    background text colour on a wxDC and unsetting it automatically in the
    destructor, restoring the previous one.
    """

    @overload
    def __init__(self, dc: DC, col: Colour) -> None:
        ...

    @overload
    def __init__(self, dc: DC) -> None:
        """
        DCTextBgColourChanger(dc) -> None
        DCTextBgColourChanger(dc, col) -> None
        
        wxDCTextBgColourChanger is a small helper class for setting a
        background text colour on a wxDC and unsetting it automatically in the
        destructor, restoring the previous one.
        """

    def Set(self, col: Colour) -> None:
        """
        Set(col) -> None
        
        Set the background colour to use.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCTextBgColourChanger


class DCTextBgModeChanger:
    """
    wxDCTextBgModeChanger is a small helper class for setting a background
    text mode on a wxDC and unsetting it automatically in the destructor,
    restoring the previous one.
    """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCTextBgModeChanger

#-- end-dc --#
#-- begin-dcclient --#

class WindowDC(DC):
    """
    WindowDC(window) -> None
    
    A wxWindowDC must be constructed if an application wishes to paint on
    the whole area of a window (client and decorations).
    """

    def __init__(self, window: Window) -> None:
        """
        WindowDC(window) -> None
        
        A wxWindowDC must be constructed if an application wishes to paint on
        the whole area of a window (client and decorations).
        """
# end of class WindowDC


class ClientDC(WindowDC):
    """
    ClientDC(window) -> None
    
    wxClientDC is primarily useful for obtaining information about the
    window from outside EVT_PAINT() handler.
    """

    def __init__(self, window: Window) -> None:
        """
        ClientDC(window) -> None
        
        wxClientDC is primarily useful for obtaining information about the
        window from outside EVT_PAINT() handler.
        """
# end of class ClientDC


class PaintDC(ClientDC):
    """
    PaintDC(window) -> None
    
    A wxPaintDC must be constructed if an application wishes to paint on
    the client area of a window from within an EVT_PAINT() event handler.
    """

    def __init__(self, window: Window) -> None:
        """
        PaintDC(window) -> None
        
        A wxPaintDC must be constructed if an application wishes to paint on
        the client area of a window from within an EVT_PAINT() event handler.
        """
# end of class PaintDC

#-- end-dcclient --#
#-- begin-dcmemory --#

class MemoryDC(DC):
    """
    MemoryDC() -> None
    MemoryDC(dc) -> None
    MemoryDC(bitmap) -> None
    
    A memory device context provides a means to draw graphics onto a
    bitmap.
    """

    @overload
    def __init__(self, dc: DC) -> None:
        ...

    @overload
    def __init__(self, bitmap: Bitmap) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        MemoryDC() -> None
        MemoryDC(dc) -> None
        MemoryDC(bitmap) -> None
        
        A memory device context provides a means to draw graphics onto a
        bitmap.
        """

    def SelectObject(self, bitmap: Bitmap) -> None:
        """
        SelectObject(bitmap) -> None
        
        Allow using this device context object to modify the given bitmap
        contents.
        """

    def SelectObjectAsSource(self, bitmap: Bitmap) -> None:
        """
        SelectObjectAsSource(bitmap) -> None
        
        Selects the given bitmap into the device context, to use as the memory
        bitmap.
        """

    def GetSelectedBitmap(self) -> Bitmap:
        """
        GetSelectedBitmap() -> Bitmap
        """
    @property
    def SelectedBitmap(self) -> Bitmap: ...
# end of class MemoryDC

#-- end-dcmemory --#
#-- begin-dcbuffer --#
BUFFER_VIRTUAL_AREA: int
BUFFER_CLIENT_AREA: int
BUFFER_USES_SHARED_BUFFER: int

class BufferedDC(MemoryDC):
    """
    BufferedDC() -> None
    BufferedDC(dc, area, style=BUFFER_CLIENT_AREA) -> None
    BufferedDC(dc, buffer=NullBitmap, style=BUFFER_CLIENT_AREA) -> None
    
    This class provides a simple way to avoid flicker: when drawing on it,
    everything is in fact first drawn on an in-memory buffer (a wxBitmap)
    and then copied to the screen, using the associated wxDC, only once,
    when this object is destroyed.
    """

    @overload
    def __init__(self, dc: DC, area: Size, style: int=BUFFER_CLIENT_AREA) -> None:
        ...

    @overload
    def __init__(self, dc: DC, buffer: Bitmap=NullBitmap, style: int=BUFFER_CLIENT_AREA) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        BufferedDC() -> None
        BufferedDC(dc, area, style=BUFFER_CLIENT_AREA) -> None
        BufferedDC(dc, buffer=NullBitmap, style=BUFFER_CLIENT_AREA) -> None
        
        This class provides a simple way to avoid flicker: when drawing on it,
        everything is in fact first drawn on an in-memory buffer (a wxBitmap)
        and then copied to the screen, using the associated wxDC, only once,
        when this object is destroyed.
        """

    @overload
    def Init(self, dc: DC, buffer: Bitmap=NullBitmap, style: int=BUFFER_CLIENT_AREA) -> None:
        ...

    @overload
    def Init(self, dc: DC, area: Size, style: int=BUFFER_CLIENT_AREA) -> None:
        """
        Init(dc, area, style=BUFFER_CLIENT_AREA) -> None
        Init(dc, buffer=NullBitmap, style=BUFFER_CLIENT_AREA) -> None
        
        Initializes the object created using the default constructor.
        """

    def UnMask(self) -> None:
        """
        UnMask() -> None
        
        Blits the buffer to the dc, and detaches the dc from the buffer (so it
        can be effectively used once only).
        """

    def SetStyle(self, style: int) -> None:
        """
        SetStyle(style) -> None
        
        Set the style.
        """

    def GetStyle(self) -> int:
        """
        GetStyle() -> int
        
        Get the style.
        """
    @property
    def Style(self) -> int: ...
    @Style.setter
    def Style(self, value: int, /) -> None: ...
# end of class BufferedDC


class BufferedPaintDC(BufferedDC):
    """
    BufferedPaintDC(window, buffer, style=BUFFER_CLIENT_AREA) -> None
    BufferedPaintDC(window, style=BUFFER_CLIENT_AREA) -> None
    
    This is a subclass of wxBufferedDC which can be used inside of an
    EVT_PAINT() event handler to achieve double-buffered drawing.
    """

    @overload
    def __init__(self, window: Window, style: int=BUFFER_CLIENT_AREA) -> None:
        ...

    @overload
    def __init__(self, window: Window, buffer: Bitmap, style: int=BUFFER_CLIENT_AREA) -> None:
        """
        BufferedPaintDC(window, buffer, style=BUFFER_CLIENT_AREA) -> None
        BufferedPaintDC(window, style=BUFFER_CLIENT_AREA) -> None
        
        This is a subclass of wxBufferedDC which can be used inside of an
        EVT_PAINT() event handler to achieve double-buffered drawing.
        """
# end of class BufferedPaintDC


class AutoBufferedPaintDC(DC):
    """
    AutoBufferedPaintDC(window) -> None
    
    This wxDC derivative can be used inside of an EVT_PAINT() event
    handler to achieve double-buffered drawing.
    """

    def __init__(self, window: Window) -> None:
        """
        AutoBufferedPaintDC(window) -> None
        
        This wxDC derivative can be used inside of an EVT_PAINT() event
        handler to achieve double-buffered drawing.
        """
# end of class AutoBufferedPaintDC


def AutoBufferedPaintDCFactory(window: Window) -> DC:    """
    AutoBufferedPaintDCFactory(window) -> DC
    
    Check if the window is natively double buffered and will return a
    wxPaintDC if it is, a wxBufferedPaintDC otherwise.
    """
#-- end-dcbuffer --#
#-- begin-dcscreen --#

class ScreenDC(DC):
    """
    ScreenDC() -> None
    
    A wxScreenDC can be used to paint on the screen.
    """

    def __init__(self) -> None:
        """
        ScreenDC() -> None
        
        A wxScreenDC can be used to paint on the screen.
        """

    @staticmethod
    def EndDrawingOnTop() -> bool:
        """
        EndDrawingOnTop() -> bool
        
        Use this in conjunction with StartDrawingOnTop().
        """

    @overload
    @staticmethod
    def StartDrawingOnTop(rect: Optional[Rect]=None) -> bool:
        ...

    @overload
    @staticmethod
    def StartDrawingOnTop(window: Window) -> bool:
        """
        StartDrawingOnTop(window) -> bool
        StartDrawingOnTop(rect=None) -> bool
        
        Use this in conjunction with EndDrawingOnTop() to ensure that drawing
        to the screen occurs on top of existing windows.
        """
# end of class ScreenDC

#-- end-dcscreen --#
#-- begin-dcgraph --#

class GCDC(DC):
    """
    GCDC(windowDC) -> None
    GCDC(memoryDC) -> None
    GCDC(printerDC) -> None
    GCDC(context) -> None
    GCDC() -> None
    
    wxGCDC is a device context that draws on a wxGraphicsContext.
    """

    @overload
    def __init__(self, memoryDC: MemoryDC) -> None:
        ...

    @overload
    def __init__(self, printerDC: PrinterDC) -> None:
        ...

    @overload
    def __init__(self, context: GraphicsContext) -> None:
        ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, windowDC: WindowDC) -> None:
        """
        GCDC(windowDC) -> None
        GCDC(memoryDC) -> None
        GCDC(printerDC) -> None
        GCDC(context) -> None
        GCDC() -> None
        
        wxGCDC is a device context that draws on a wxGraphicsContext.
        """

    def GetGraphicsContext(self) -> GraphicsContext:
        """
        GetGraphicsContext() -> GraphicsContext
        
        Retrieves associated wxGraphicsContext.
        """

    def SetGraphicsContext(self, context: GraphicsContext) -> None:
        """
        SetGraphicsContext(context) -> None
        
        Set the graphics context to be used for this wxGCDC.
        """
    @property
    def GraphicsContext(self) -> GraphicsContext: ...
    @GraphicsContext.setter
    def GraphicsContext(self, value: GraphicsContext, /) -> None: ...
# end of class GCDC

#-- end-dcgraph --#
#-- begin-dcmirror --#

class MirrorDC(DC):
    """
    MirrorDC(dc, mirror) -> None
    
    wxMirrorDC is a simple wrapper class which is always associated with a
    real wxDC object and either forwards all of its operations to it
    without changes (no mirroring takes place) or exchanges x and y
    coordinates which makes it possible to reuse the same code to draw a
    figure and its mirror  i.e.
    """

    def __init__(self, dc: DC, mirror: bool) -> None:
        """
        MirrorDC(dc, mirror) -> None
        
        wxMirrorDC is a simple wrapper class which is always associated with a
        real wxDC object and either forwards all of its operations to it
        without changes (no mirroring takes place) or exchanges x and y
        coordinates which makes it possible to reuse the same code to draw a
        figure and its mirror  i.e.
        """
# end of class MirrorDC

#-- end-dcmirror --#
#-- begin-dcprint --#

class PrinterDC(DC):
    """
    PrinterDC(printData) -> None
    
    A printer device context is specific to MSW and Mac, and allows access
    to any printer with a Windows or Macintosh driver.
    """

    def __init__(self, printData: PrintData) -> None:
        """
        PrinterDC(printData) -> None
        
        A printer device context is specific to MSW and Mac, and allows access
        to any printer with a Windows or Macintosh driver.
        """

    def GetPaperRect(self) -> Rect:
        """
        GetPaperRect() -> Rect
        
        Return the rectangle in device coordinates that corresponds to the
        full paper area, including the nonprinting regions of the paper.
        """
    @property
    def PaperRect(self) -> Rect: ...
# end of class PrinterDC

#-- end-dcprint --#
#-- begin-dcps --#

class PostScriptDC(DC):
    """
    PostScriptDC() -> None
    PostScriptDC(printData) -> None
    
    This defines the wxWidgets Encapsulated PostScript device context,
    which can write PostScript files on any platform.
    """

    @overload
    def __init__(self, printData: PrintData) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        PostScriptDC() -> None
        PostScriptDC(printData) -> None
        
        This defines the wxWidgets Encapsulated PostScript device context,
        which can write PostScript files on any platform.
        """
# end of class PostScriptDC

#-- end-dcps --#
#-- begin-dcsvg --#

class _SVGShapeRenderingMode(IntEnum):
    SVG_SHAPE_RENDERING_AUTO = auto()
    SVG_SHAPE_RENDERING_OPTIMIZE_SPEED = auto()
    SVG_SHAPE_RENDERING_CRISP_EDGES = auto()
    SVG_SHAPE_RENDERING_GEOMETRIC_PRECISION = auto()
    SVG_SHAPE_RENDERING_OPTIMISE_SPEED = auto()
SVGShapeRenderingMode: TypeAlias = Union[_SVGShapeRenderingMode, int]
SVG_SHAPE_RENDERING_AUTO = _SVGShapeRenderingMode.SVG_SHAPE_RENDERING_AUTO
SVG_SHAPE_RENDERING_OPTIMIZE_SPEED = _SVGShapeRenderingMode.SVG_SHAPE_RENDERING_OPTIMIZE_SPEED
SVG_SHAPE_RENDERING_CRISP_EDGES = _SVGShapeRenderingMode.SVG_SHAPE_RENDERING_CRISP_EDGES
SVG_SHAPE_RENDERING_GEOMETRIC_PRECISION = _SVGShapeRenderingMode.SVG_SHAPE_RENDERING_GEOMETRIC_PRECISION
SVG_SHAPE_RENDERING_OPTIMISE_SPEED = _SVGShapeRenderingMode.SVG_SHAPE_RENDERING_OPTIMISE_SPEED

class SVGFileDC(DC):
    """
    SVGFileDC(filename, width=320, height=240, dpi=72, title="") -> None
    
    A wxSVGFileDC is a device context onto which graphics and text can be
    drawn, and the output produced as a vector file, in SVG format.
    """

    def __init__(self, filename: str, width: int=320, height: int=240, dpi: float=72, title: str="") -> None:
        """
        SVGFileDC(filename, width=320, height=240, dpi=72, title="") -> None
        
        A wxSVGFileDC is a device context onto which graphics and text can be
        drawn, and the output produced as a vector file, in SVG format.
        """

    def CrossHair(self, x: int, y: int) -> None:
        """
        CrossHair(x, y) -> None
        
        Function not implemented in this DC class.
        """

    def FloodFill(self, x: int, y: int, colour: Colour, style: FloodFillStyle=FLOOD_SURFACE) -> bool:
        """
        FloodFill(x, y, colour, style=FLOOD_SURFACE) -> bool
        
        Function not implemented in this DC class.
        """

    def GetPixel(self, x: int, y: int, colour: Colour) -> bool:
        """
        GetPixel(x, y, colour) -> bool
        
        Function not implemented in this DC class.
        """

    def SetPalette(self, palette: Palette) -> None:
        """
        SetPalette(palette) -> None
        
        Function not implemented in this DC class.
        """

    def GetDepth(self) -> int:
        """
        GetDepth() -> int
        
        Function not implemented in this DC class.
        """

    def SetLogicalFunction(self, function: RasterOperationMode) -> None:
        """
        SetLogicalFunction(function) -> None
        
        Function not implemented in this DC class.
        """

    def GetLogicalFunction(self) -> RasterOperationMode:
        """
        GetLogicalFunction() -> RasterOperationMode
        
        Function not implemented in this DC class.
        """

    def StartDoc(self, message: str) -> bool:
        """
        StartDoc(message) -> bool
        
        Function not implemented in this DC class.
        """

    def EndDoc(self) -> None:
        """
        EndDoc() -> None
        
        Function not implemented in this DC class.
        """

    def StartPage(self) -> None:
        """
        StartPage() -> None
        
        Function not implemented in this DC class.
        """

    def EndPage(self) -> None:
        """
        EndPage() -> None
        
        Function not implemented in this DC class.
        """

    def Clear(self) -> None:
        """
        Clear() -> None
        
        Draws a rectangle the size of the SVG using the wxDC::SetBackground()
        brush.
        """

    def SetBitmapHandler(self, handler: SVGBitmapHandler) -> None:
        """
        SetBitmapHandler(handler) -> None
        
        Replaces the default bitmap handler with handler.
        """

    def SetShapeRenderingMode(self, renderingMode: SVGShapeRenderingMode) -> None:
        """
        SetShapeRenderingMode(renderingMode) -> None
        
        Set the shape rendering mode of the generated SVG.
        """

    def DestroyClippingRegion(self) -> None:
        """
        DestroyClippingRegion() -> None
        
        Destroys the current clipping region so that none of the DC is
        clipped.
        """
    @property
    def Depth(self) -> int: ...
    @property
    def LogicalFunction(self) -> RasterOperationMode: ...
    @LogicalFunction.setter
    def LogicalFunction(self, value: RasterOperationMode, /) -> None: ...
# end of class SVGFileDC


class SVGBitmapHandler:
    """
    Abstract base class for handling bitmaps inside a wxSVGFileDC.
    """

    def ProcessBitmap(self, bitmap: Bitmap, x: int, y: int, stream: OutputStream) -> bool:
        """
        ProcessBitmap(bitmap, x, y, stream) -> bool
        
        Writes the bitmap representation as SVG to the given stream.
        """
# end of class SVGBitmapHandler


class SVGBitmapEmbedHandler(SVGBitmapHandler):
    """
    Handler embedding bitmaps as base64-encoded PNGs into the SVG.
    """

    def ProcessBitmap(self, bitmap: Bitmap, x: int, y: int, stream: OutputStream) -> bool:
        """
        ProcessBitmap(bitmap, x, y, stream) -> bool
        
        Writes the bitmap representation as SVG to the given stream.
        """
# end of class SVGBitmapEmbedHandler


class SVGBitmapFileHandler(SVGBitmapHandler):
    """
    SVGBitmapFileHandler(path) -> None
    
    Handler saving bitmaps to external PNG files and linking to it from
    the SVG.
    """

    def __init__(self, path: str) -> None:
        """
        SVGBitmapFileHandler(path) -> None
        
        Handler saving bitmaps to external PNG files and linking to it from
        the SVG.
        """

    def ProcessBitmap(self, bitmap: Bitmap, x: int, y: int, stream: OutputStream) -> bool:
        """
        ProcessBitmap(bitmap, x, y, stream) -> bool
        
        Writes the bitmap representation as SVG to the given stream.
        """
# end of class SVGBitmapFileHandler

#-- end-dcsvg --#
#-- begin-metafile --#

class Metafile(Object):
    """
    Metafile(filename='') -> None
    
    A wxMetafile represents the MS Windows metafile object, so metafile
    operations have no effect in X.
    """

    def __init__(self, filename: str='') -> None:
        """
        Metafile(filename='') -> None
        
        A wxMetafile represents the MS Windows metafile object, so metafile
        operations have no effect in X.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the metafile is valid.
        """

    def Play(self, dc: DC) -> bool:
        """
        Play(dc) -> bool
        
        Plays the metafile into the given device context, returning true if successful.
        """

    def SetClipboard(self, width: int=0, height: int=0) -> bool:
        """
        SetClipboard(width=0, height=0) -> bool
        
        Passes the metafile data to the clipboard.
        """
# end of class Metafile


class MetafileDC(DC):
    """
    MetafileDC(filename='') -> None
    
    This is a type of device context that allows a metafile object to be
    created (Windows only), and has most of the characteristics of a
    normal wxDC.
    """

    def __init__(self, filename: str='') -> None:
        """
        MetafileDC(filename='') -> None
        
        This is a type of device context that allows a metafile object to be
        created (Windows only), and has most of the characteristics of a
        normal wxDC.
        """

    def Close(self) -> Metafile:
        """
        Close() -> Metafile
        
        This must be called after the device context is finished with.
        """
# end of class MetafileDC

#-- end-metafile --#
#-- begin-graphics --#

class _AntialiasMode(IntEnum):
    ANTIALIAS_NONE = auto()
    ANTIALIAS_DEFAULT = auto()
AntialiasMode: TypeAlias = Union[_AntialiasMode, int]
ANTIALIAS_NONE = _AntialiasMode.ANTIALIAS_NONE
ANTIALIAS_DEFAULT = _AntialiasMode.ANTIALIAS_DEFAULT

class _InterpolationQuality(IntEnum):
    INTERPOLATION_DEFAULT = auto()
    INTERPOLATION_NONE = auto()
    INTERPOLATION_FAST = auto()
    INTERPOLATION_GOOD = auto()
    INTERPOLATION_BEST = auto()
InterpolationQuality: TypeAlias = Union[_InterpolationQuality, int]
INTERPOLATION_DEFAULT = _InterpolationQuality.INTERPOLATION_DEFAULT
INTERPOLATION_NONE = _InterpolationQuality.INTERPOLATION_NONE
INTERPOLATION_FAST = _InterpolationQuality.INTERPOLATION_FAST
INTERPOLATION_GOOD = _InterpolationQuality.INTERPOLATION_GOOD
INTERPOLATION_BEST = _InterpolationQuality.INTERPOLATION_BEST

class _CompositionMode(IntEnum):
    COMPOSITION_INVALID = auto()
    COMPOSITION_CLEAR = auto()
    COMPOSITION_SOURCE = auto()
    COMPOSITION_OVER = auto()
    COMPOSITION_IN = auto()
    COMPOSITION_OUT = auto()
    COMPOSITION_ATOP = auto()
    COMPOSITION_DEST = auto()
    COMPOSITION_DEST_OVER = auto()
    COMPOSITION_DEST_IN = auto()
    COMPOSITION_DEST_OUT = auto()
    COMPOSITION_DEST_ATOP = auto()
    COMPOSITION_XOR = auto()
    COMPOSITION_ADD = auto()
    COMPOSITION_DIFF = auto()
CompositionMode: TypeAlias = Union[_CompositionMode, int]
COMPOSITION_INVALID = _CompositionMode.COMPOSITION_INVALID
COMPOSITION_CLEAR = _CompositionMode.COMPOSITION_CLEAR
COMPOSITION_SOURCE = _CompositionMode.COMPOSITION_SOURCE
COMPOSITION_OVER = _CompositionMode.COMPOSITION_OVER
COMPOSITION_IN = _CompositionMode.COMPOSITION_IN
COMPOSITION_OUT = _CompositionMode.COMPOSITION_OUT
COMPOSITION_ATOP = _CompositionMode.COMPOSITION_ATOP
COMPOSITION_DEST = _CompositionMode.COMPOSITION_DEST
COMPOSITION_DEST_OVER = _CompositionMode.COMPOSITION_DEST_OVER
COMPOSITION_DEST_IN = _CompositionMode.COMPOSITION_DEST_IN
COMPOSITION_DEST_OUT = _CompositionMode.COMPOSITION_DEST_OUT
COMPOSITION_DEST_ATOP = _CompositionMode.COMPOSITION_DEST_ATOP
COMPOSITION_XOR = _CompositionMode.COMPOSITION_XOR
COMPOSITION_ADD = _CompositionMode.COMPOSITION_ADD
COMPOSITION_DIFF = _CompositionMode.COMPOSITION_DIFF

class _GradientType(IntEnum):
    GRADIENT_NONE = auto()
    GRADIENT_LINEAR = auto()
    GRADIENT_RADIAL = auto()
GradientType: TypeAlias = Union[_GradientType, int]
GRADIENT_NONE = _GradientType.GRADIENT_NONE
GRADIENT_LINEAR = _GradientType.GRADIENT_LINEAR
GRADIENT_RADIAL = _GradientType.GRADIENT_RADIAL

class GraphicsObject(Object):
    """
    This class is the superclass of native graphics objects like pens etc.
    """

    def GetRenderer(self) -> GraphicsRenderer:
        """
        GetRenderer() -> GraphicsRenderer
        
        Returns the renderer that was used to create this instance, or NULL if
        it has not been initialized yet.
        """

    def IsNull(self) -> bool:
        """
        IsNull() -> bool
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """
    @property
    def Renderer(self) -> GraphicsRenderer: ...
# end of class GraphicsObject


class GraphicsBitmap(GraphicsObject):
    """
    GraphicsBitmap() -> None
    
    Represents a bitmap.
    """

    def __init__(self) -> None:
        """
        GraphicsBitmap() -> None
        
        Represents a bitmap.
        """

    def ConvertToImage(self) -> Image:
        """
        ConvertToImage() -> Image
        
        Return the contents of this bitmap as wxImage.
        """

    def GetNativeBitmap(self) -> Any:
        """
        GetNativeBitmap() -> Any
        
        Return the pointer to the native bitmap data.
        """
    @property
    def NativeBitmap(self) -> Any: ...
# end of class GraphicsBitmap


class GraphicsBrush(GraphicsObject):
    """
    A wxGraphicsBrush is a native representation of a brush.
    """
# end of class GraphicsBrush


class GraphicsFont(GraphicsObject):
    """
    A wxGraphicsFont is a native representation of a font.
    """
# end of class GraphicsFont


class GraphicsPenInfo:
    """
    GraphicsPenInfo(colour=Colour(), width=1.0, style=PENSTYLE_SOLID) -> None
    
    This class is a helper used for wxGraphicsPen creation using named
    parameter idiom: it allows specifying various wxGraphicsPen attributes
    using the chained calls to its clearly named methods instead of
    passing them in the fixed order to wxGraphicsPen constructors.
    """

    def __init__(self, colour: Colour=Colour(), width: float=1.0, style: PenStyle=PENSTYLE_SOLID) -> None:
        """
        GraphicsPenInfo(colour=Colour(), width=1.0, style=PENSTYLE_SOLID) -> None
        
        This class is a helper used for wxGraphicsPen creation using named
        parameter idiom: it allows specifying various wxGraphicsPen attributes
        using the chained calls to its clearly named methods instead of
        passing them in the fixed order to wxGraphicsPen constructors.
        """

    def Colour(self, col: Colour) -> GraphicsPenInfo:
        """
        Colour(col) -> GraphicsPenInfo
        """

    def Width(self, width: float) -> GraphicsPenInfo:
        """
        Width(width) -> GraphicsPenInfo
        """

    def Style(self, style: PenStyle) -> GraphicsPenInfo:
        """
        Style(style) -> GraphicsPenInfo
        """

    def Stipple(self, stipple: Bitmap) -> GraphicsPenInfo:
        """
        Stipple(stipple) -> GraphicsPenInfo
        """

    def Join(self, join: PenJoin) -> GraphicsPenInfo:
        """
        Join(join) -> GraphicsPenInfo
        """

    def Cap(self, cap: PenCap) -> GraphicsPenInfo:
        """
        Cap(cap) -> GraphicsPenInfo
        """

    @overload
    def LinearGradient(self, x1: float, y1: float, x2: float, y2: float, stops: GraphicsGradientStops, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsPenInfo:
        ...

    @overload
    def LinearGradient(self, x1: float, y1: float, x2: float, y2: float, c1: Colour, c2: Colour, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsPenInfo:
        """
        LinearGradient(x1, y1, x2, y2, c1, c2, matrix=NullGraphicsMatrix) -> GraphicsPenInfo
        LinearGradient(x1, y1, x2, y2, stops, matrix=NullGraphicsMatrix) -> GraphicsPenInfo
        """

    @overload
    def RadialGradient(self, startX: float, startY: float, endX: float, endY: float, radius: float, stops: GraphicsGradientStops, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsPenInfo:
        ...

    @overload
    def RadialGradient(self, startX: float, startY: float, endX: float, endY: float, radius: float, oColor: Colour, cColor: Colour, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsPenInfo:
        """
        RadialGradient(startX, startY, endX, endY, radius, oColor, cColor, matrix=NullGraphicsMatrix) -> GraphicsPenInfo
        RadialGradient(startX, startY, endX, endY, radius, stops, matrix=NullGraphicsMatrix) -> GraphicsPenInfo
        """

    def GetColour(self) -> Colour:
        """
        GetColour() -> Colour
        """

    def GetStipple(self) -> Bitmap:
        """
        GetStipple() -> Bitmap
        """

    def GetStyle(self) -> PenStyle:
        """
        GetStyle() -> PenStyle
        """

    def GetJoin(self) -> PenJoin:
        """
        GetJoin() -> PenJoin
        """

    def GetCap(self) -> PenCap:
        """
        GetCap() -> PenCap
        """

    def IsTransparent(self) -> bool:
        """
        IsTransparent() -> bool
        """

    def GetWidth(self) -> float:
        """
        GetWidth() -> float
        """

    def GetGradientType(self) -> GradientType:
        """
        GetGradientType() -> GradientType
        """

    def GetX1(self) -> float:
        """
        GetX1() -> float
        """

    def GetY1(self) -> float:
        """
        GetY1() -> float
        """

    def GetX2(self) -> float:
        """
        GetX2() -> float
        """

    def GetY2(self) -> float:
        """
        GetY2() -> float
        """

    def GetStartX(self) -> float:
        """
        GetStartX() -> float
        """

    def GetStartY(self) -> float:
        """
        GetStartY() -> float
        """

    def GetEndX(self) -> float:
        """
        GetEndX() -> float
        """

    def GetEndY(self) -> float:
        """
        GetEndY() -> float
        """

    def GetRadius(self) -> float:
        """
        GetRadius() -> float
        """

    def GetStops(self) -> GraphicsGradientStops:
        """
        GetStops() -> GraphicsGradientStops
        """
    @property
    def EndX(self) -> float: ...
    @property
    def EndY(self) -> float: ...
    @property
    def GradientType(self) -> GradientType: ...
    @property
    def Radius(self) -> float: ...
    @property
    def StartX(self) -> float: ...
    @property
    def StartY(self) -> float: ...
    @property
    def Stops(self) -> GraphicsGradientStops: ...
    @property
    def X1(self) -> float: ...
    @property
    def X2(self) -> float: ...
    @property
    def Y1(self) -> float: ...
    @property
    def Y2(self) -> float: ...
# end of class GraphicsPenInfo


class GraphicsPen(GraphicsObject):
    """
    A wxGraphicsPen is a native representation of a pen.
    """
# end of class GraphicsPen


class GraphicsContext(GraphicsObject):
    """
    A wxGraphicsContext instance is the object that is drawn upon.
    """

    @overload
    @staticmethod
    def Create(windowDC: WindowDC) -> GraphicsContext:
        ...

    @overload
    @staticmethod
    def Create(memoryDC: MemoryDC) -> GraphicsContext:
        ...

    @overload
    @staticmethod
    def Create(printerDC: PrinterDC) -> GraphicsContext:
        ...

    @overload
    @staticmethod
    def Create(metaFileDC: MetafileDC) -> GraphicsContext:
        ...

    @overload
    @staticmethod
    def Create(image: Image) -> GraphicsContext:
        ...

    @overload
    @staticmethod
    def Create() -> GraphicsContext:
        ...

    @overload
    @staticmethod
    def Create(KeepReference: AutoBufferedPaintDCautoPaintDC) -> GraphicsContext:
        ...

    @overload
    @staticmethod
    def Create(window: Window) -> GraphicsContext:
        """
        Create(window) -> GraphicsContext
        Create(windowDC) -> GraphicsContext
        Create(memoryDC) -> GraphicsContext
        Create(printerDC) -> GraphicsContext
        Create(metaFileDC) -> GraphicsContext
        Create(image) -> GraphicsContext
        Create() -> GraphicsContext
        Create(autoPaintDC) -> GraphicsContext
        
        Creates a wxGraphicsContext from a wxWindow.
        """

    @staticmethod
    def CreateFromUnknownDC(dc: DC) -> GraphicsContext:
        """
        CreateFromUnknownDC(dc) -> GraphicsContext
        
        Creates a wxGraphicsContext from a DC of unknown specific type.
        """

    @staticmethod
    def CreateFromNative(context: Any) -> GraphicsContext:
        """
        CreateFromNative(context) -> GraphicsContext
        
        Creates a wxGraphicsContext from a native context.
        """

    @staticmethod
    def CreateFromNativeWindow(window: Any) -> GraphicsContext:
        """
        CreateFromNativeWindow(window) -> GraphicsContext
        
        Creates a wxGraphicsContext from a native window.
        """

    def ResetClip(self) -> None:
        """
        ResetClip() -> None
        
        Resets the clipping to original shape.
        """

    @overload
    def Clip(self, x: float, y: float, w: float, h: float) -> None:
        ...

    @overload
    def Clip(self, region: Region) -> None:
        """
        Clip(region) -> None
        Clip(x, y, w, h) -> None
        
        Sets the clipping region to the intersection of the given region and
        the previously set clipping region.
        """

    def GetClipBox(self, x: float, y: float, w: float, h: float) -> None:
        """
        GetClipBox(x, y, w, h) -> None
        
        Returns bounding box of the current clipping region.
        """

    @overload
    def CreateMatrix(self, mat: AffineMatrix2DBase) -> GraphicsMatrix:
        ...

    @overload
    def CreateMatrix(self, a: float=1.0, b: float=0.0, c: float=0.0, d: float=1.0, tx: float=0.0, ty: float=0.0) -> GraphicsMatrix:
        """
        CreateMatrix(a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0) -> GraphicsMatrix
        CreateMatrix(mat) -> GraphicsMatrix
        
        Creates a native affine transformation matrix from the passed in
        values.
        """

    def ConcatTransform(self, matrix: GraphicsMatrix) -> None:
        """
        ConcatTransform(matrix) -> None
        
        Concatenates the passed in transform with the current transform of
        this context.
        """

    def GetTransform(self) -> GraphicsMatrix:
        """
        GetTransform() -> GraphicsMatrix
        
        Gets the current transformation matrix of this context.
        """

    def Rotate(self, angle: float) -> None:
        """
        Rotate(angle) -> None
        
        Rotates the current transformation matrix (in radians).
        """

    def Scale(self, xScale: float, yScale: float) -> None:
        """
        Scale(xScale, yScale) -> None
        
        Scales the current transformation matrix.
        """

    def SetTransform(self, matrix: GraphicsMatrix) -> None:
        """
        SetTransform(matrix) -> None
        
        Sets the current transformation matrix of this context.
        """

    def Translate(self, dx: float, dy: float) -> None:
        """
        Translate(dx, dy) -> None
        
        Translates the current transformation matrix.
        """

    def CreateBrush(self, brush: Brush) -> GraphicsBrush:
        """
        CreateBrush(brush) -> GraphicsBrush
        
        Creates a native brush from a wxBrush.
        """

    @overload
    def CreateLinearGradientBrush(self, x1: float, y1: float, x2: float, y2: float, stops: GraphicsGradientStops, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsBrush:
        ...

    @overload
    def CreateLinearGradientBrush(self, x1: float, y1: float, x2: float, y2: float, c1: Colour, c2: Colour, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsBrush:
        """
        CreateLinearGradientBrush(x1, y1, x2, y2, c1, c2, matrix=NullGraphicsMatrix) -> GraphicsBrush
        CreateLinearGradientBrush(x1, y1, x2, y2, stops, matrix=NullGraphicsMatrix) -> GraphicsBrush
        
        Creates a native brush with a linear gradient.
        """

    @overload
    def CreateRadialGradientBrush(self, startX: float, startY: float, endX: float, endY: float, radius: float, stops: GraphicsGradientStops, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsBrush:
        ...

    @overload
    def CreateRadialGradientBrush(self, startX: float, startY: float, endX: float, endY: float, radius: float, oColor: Colour, cColor: Colour, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsBrush:
        """
        CreateRadialGradientBrush(startX, startY, endX, endY, radius, oColor, cColor, matrix=NullGraphicsMatrix) -> GraphicsBrush
        CreateRadialGradientBrush(startX, startY, endX, endY, radius, stops, matrix=NullGraphicsMatrix) -> GraphicsBrush
        
        Creates a native brush with a radial gradient.
        """

    @overload
    def SetBrush(self, brush: GraphicsBrush) -> None:
        ...

    @overload
    def SetBrush(self, brush: Brush) -> None:
        """
        SetBrush(brush) -> None
        SetBrush(brush) -> None
        
        Sets the brush for filling paths.
        """

    @overload
    def CreatePen(self, info: GraphicsPenInfo) -> GraphicsPen:
        ...

    @overload
    def CreatePen(self, pen: Pen) -> GraphicsPen:
        """
        CreatePen(pen) -> GraphicsPen
        CreatePen(info) -> GraphicsPen
        
        Creates a native pen from a wxPen.
        """

    @overload
    def SetPen(self, pen: GraphicsPen) -> None:
        ...

    @overload
    def SetPen(self, pen: Pen) -> None:
        """
        SetPen(pen) -> None
        SetPen(pen) -> None
        
        Sets the pen used for stroking.
        """

    @overload
    def DrawBitmap(self, bmp: Bitmap, x: float, y: float, w: float, h: float) -> None:
        ...

    @overload
    def DrawBitmap(self, bmp: GraphicsBitmap, x: float, y: float, w: float, h: float) -> None:
        """
        DrawBitmap(bmp, x, y, w, h) -> None
        DrawBitmap(bmp, x, y, w, h) -> None
        
        Draws the bitmap.
        """

    def DrawEllipse(self, x: float, y: float, w: float, h: float) -> None:
        """
        DrawEllipse(x, y, w, h) -> None
        
        Draws an ellipse.
        """

    def DrawIcon(self, icon: Icon, x: float, y: float, w: float, h: float) -> None:
        """
        DrawIcon(icon, x, y, w, h) -> None
        
        Draws the icon.
        """

    def DrawLines(self, points: Any, fillStyle: PolygonFillMode=ODDEVEN_RULE) -> None:
        """
        DrawLines(point2Ds, fillStyle=ODDEVEN_RULE)
        
        Draws a polygon.
        """

    def DrawPath(self, path: GraphicsPath, fillStyle: PolygonFillMode=ODDEVEN_RULE) -> None:
        """
        DrawPath(path, fillStyle=ODDEVEN_RULE) -> None
        
        Draws the path by first filling and then stroking.
        """

    def DrawRectangle(self, x: float, y: float, w: float, h: float) -> None:
        """
        DrawRectangle(x, y, w, h) -> None
        
        Draws a rectangle.
        """

    def DrawRoundedRectangle(self, x: float, y: float, w: float, h: float, radius: float) -> None:
        """
        DrawRoundedRectangle(x, y, w, h, radius) -> None
        
        Draws a rounded rectangle.
        """

    @overload
    def DrawText(self, str: str, x: float, y: float, angle: float) -> None:
        ...

    @overload
    def DrawText(self, str: str, x: float, y: float, backgroundBrush: GraphicsBrush) -> None:
        ...

    @overload
    def DrawText(self, str: str, x: float, y: float, angle: float, backgroundBrush: GraphicsBrush) -> None:
        ...

    @overload
    def DrawText(self, str: str, x: float, y: float) -> None:
        """
        DrawText(str, x, y) -> None
        DrawText(str, x, y, angle) -> None
        DrawText(str, x, y, backgroundBrush) -> None
        DrawText(str, x, y, angle, backgroundBrush) -> None
        
        Draws text at the defined position.
        """

    def CreatePath(self) -> GraphicsPath:
        """
        CreatePath() -> GraphicsPath
        
        Creates a native graphics path which is initially empty.
        """

    def FillPath(self, path: GraphicsPath, fillStyle: PolygonFillMode=ODDEVEN_RULE) -> None:
        """
        FillPath(path, fillStyle=ODDEVEN_RULE) -> None
        
        Fills the path with the current brush.
        """

    def StrokeLine(self, x1: float, y1: float, x2: float, y2: float) -> None:
        """
        StrokeLine(x1, y1, x2, y2) -> None
        
        Strokes a single line.
        """

    def StrokeLines(self, points: Any) -> None:
        """
        StrokeLines(point2Ds)
        
        Stroke lines connecting all the points.
        """

    def StrokePath(self, path: GraphicsPath) -> None:
        """
        StrokePath(path) -> None
        
        Strokes along a path with the current pen.
        """

    @overload
    def CreateFont(self, sizeInPixels: float, facename: str, flags: int=FONTFLAG_DEFAULT, col: Colour=BLACK) -> GraphicsFont:
        ...

    @overload
    def CreateFont(self, font: Font, col: Colour=BLACK) -> GraphicsFont:
        """
        CreateFont(font, col=BLACK) -> GraphicsFont
        CreateFont(sizeInPixels, facename, flags=FONTFLAG_DEFAULT, col=BLACK) -> GraphicsFont
        
        Creates a native graphics font from a wxFont and a text colour.
        """

    @overload
    def SetFont(self, font: GraphicsFont) -> None:
        ...

    @overload
    def SetFont(self, font: Font, colour: Colour) -> None:
        """
        SetFont(font, colour) -> None
        SetFont(font) -> None
        
        Sets the font for drawing text.
        """

    def GetPartialTextExtents(self, text: str) -> List[float]:
        """
        GetPartialTextExtents(text) -> List[float]
        
        Fills the widths array with the widths from the beginning of text to
        the corresponding character of text.
        """

    @overload
    def GetTextExtent(self, text: str) -> Any:
        ...

    @overload
    def GetFullTextExtent(self, text: str) -> Tuple[float, float, float, float]:
        """
        GetFullTextExtent(text) -> Tuple[float, float, float, float]
        GetTextExtent(text) -> (width, height)
        
        Gets the dimensions of the string using the currently selected font.
        """

    def StartDoc(self, message: str) -> bool:
        """
        StartDoc(message) -> bool
        
        Begin a new document (relevant only for printing / pdf etc.) If there
        is a progress dialog, message will be shown.
        """

    def EndDoc(self) -> None:
        """
        EndDoc() -> None
        
        Done with that document (relevant only for printing / pdf etc.)
        """

    def StartPage(self, width: float=0, height: float=0) -> None:
        """
        StartPage(width=0, height=0) -> None
        
        Opens a new page (relevant only for printing / pdf etc.) with the
        given size in points.
        """

    def EndPage(self) -> None:
        """
        EndPage() -> None
        
        Ends the current page (relevant only for printing / pdf etc.)
        """

    def CreateBitmap(self, bitmap: Bitmap) -> GraphicsBitmap:
        """
        CreateBitmap(bitmap) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from an existing wxBitmap.
        """

    def CreateBitmapFromImage(self, image: Image) -> GraphicsBitmap:
        """
        CreateBitmapFromImage(image) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from an existing wxImage.
        """

    def CreateSubBitmap(self, bitmap: GraphicsBitmap, x: float, y: float, w: float, h: float) -> GraphicsBitmap:
        """
        CreateSubBitmap(bitmap, x, y, w, h) -> GraphicsBitmap
        
        Extracts a sub-bitmap from an existing bitmap.
        """

    def BeginLayer(self, opacity: float) -> None:
        """
        BeginLayer(opacity) -> None
        
        All rendering will be done into a fully transparent temporary context.
        """

    def EndLayer(self) -> None:
        """
        EndLayer() -> None
        
        Composites back the drawings into the context with the opacity given
        at the BeginLayer() call.
        """

    def PushState(self) -> None:
        """
        PushState() -> None
        
        Push the current state (like transformations, clipping region and
        quality settings) of the context on a stack.
        """

    def PopState(self) -> None:
        """
        PopState() -> None
        
        Sets current state of the context to the state saved by a preceding
        call to PushState() and removes that state from the stack of saved
        states.
        """

    def Flush(self) -> None:
        """
        Flush() -> None
        
        Make sure that the current content of this context is immediately
        visible.
        """

    def GetNativeContext(self) -> Any:
        """
        GetNativeContext() -> Any
        
        Returns the native context (CGContextRef for Core Graphics, Graphics
        pointer for GDIPlus and cairo_t pointer for cairo).
        """

    def SetAntialiasMode(self, antialias: AntialiasMode) -> bool:
        """
        SetAntialiasMode(antialias) -> bool
        
        Sets the antialiasing mode, returns true if it supported.
        """

    def GetAntialiasMode(self) -> AntialiasMode:
        """
        GetAntialiasMode() -> AntialiasMode
        
        Returns the current shape antialiasing mode.
        """

    def SetInterpolationQuality(self, interpolation: InterpolationQuality) -> bool:
        """
        SetInterpolationQuality(interpolation) -> bool
        
        Sets the interpolation quality, returns true if it is supported.
        """

    def GetInterpolationQuality(self) -> InterpolationQuality:
        """
        GetInterpolationQuality() -> InterpolationQuality
        
        Returns the current interpolation quality.
        """

    def SetCompositionMode(self, op: CompositionMode) -> bool:
        """
        SetCompositionMode(op) -> bool
        
        Sets the compositing operator, returns true if it supported.
        """

    def GetCompositionMode(self) -> CompositionMode:
        """
        GetCompositionMode() -> CompositionMode
        
        Returns the current compositing operator.
        """

    def GetSize(self) -> Tuple[float, float]:
        """
        GetSize() -> Tuple[float, float]
        
        Returns the size of the graphics context in device coordinates.
        """

    def GetDPI(self) -> Tuple[float, float]:
        """
        GetDPI() -> Tuple[float, float]
        
        Returns the resolution of the graphics context in device points per
        inch.
        """

    def GetWindow(self) -> Window:
        """
        GetWindow() -> Window
        
        Returns the associated window if any.
        """

    def ShouldOffset(self) -> bool:
        """
        ShouldOffset() -> bool
        
        Helper to determine if a 0.5 offset should be applied for the drawing
        operation.
        """

    def EnableOffset(self, enable: bool=True) -> None:
        """
        EnableOffset(enable=True) -> None
        
        Indicates whether the context should try to offset for pixel
        boundaries.
        """

    def DisableOffset(self) -> None:
        """
        DisableOffset() -> None
        
        Helper to determine if a 0.5 offset should be applied for the drawing
        operation.
        """

    def OffsetEnabled(self) -> bool:
        """
        OffsetEnabled() -> bool
        
        Helper to determine if a 0.5 offset should be applied for the drawing
        operation.
        """

    @overload
    def FromDIP(self, pt: Point) -> Point:
        ...

    @overload
    def FromDIP(self, d: int) -> int:
        ...

    @overload
    def FromDIP(self, sz: Size) -> Size:
        """
        FromDIP(sz) -> Size
        FromDIP(pt) -> Point
        FromDIP(d) -> int
        
        Convert DPI-independent pixel values to the value in pixels
        appropriate for the graphics context.
        """

    @overload
    def ToDIP(self, pt: Point) -> Point:
        ...

    @overload
    def ToDIP(self, d: int) -> int:
        ...

    @overload
    def ToDIP(self, sz: Size) -> Size:
        """
        ToDIP(sz) -> Size
        ToDIP(pt) -> Point
        ToDIP(d) -> int
        
        Convert pixel values of the current graphics context to DPI-
        independent pixel values.
        """

    DrawRotatedText = wx.deprecated(DrawText, 'Use DrawText instead.')

    def StrokeLineSegments(self, beginPoints: Any, endPoints: Any) -> None:
        """
        StrokeLineSegments(beginPoint2Ds, endPoint2Ds)
        
        Stroke disconnected lines from begin to end points.
        """
    @property
    def AntialiasMode(self) -> AntialiasMode: ...
    @AntialiasMode.setter
    def AntialiasMode(self, value: AntialiasMode, /) -> None: ...
    @property
    def CompositionMode(self) -> CompositionMode: ...
    @CompositionMode.setter
    def CompositionMode(self, value: CompositionMode, /) -> None: ...
    @property
    def InterpolationQuality(self) -> InterpolationQuality: ...
    @InterpolationQuality.setter
    def InterpolationQuality(self, value: InterpolationQuality, /) -> None: ...
    @property
    def NativeContext(self) -> Any: ...
    @property
    def TextExtent(self) -> Tuple[float, float, float, float]: ...
    @property
    def Transform(self) -> GraphicsMatrix: ...
    @Transform.setter
    def Transform(self, value: GraphicsMatrix, /) -> None: ...
    @property
    def Window(self) -> Window: ...
# end of class GraphicsContext


class GraphicsGradientStop:
    """
    GraphicsGradientStop(col=TransparentColour, pos=0.) -> None
    
    Represents a single gradient stop in a collection of gradient stops as
    represented by wxGraphicsGradientStops.
    """

    def __init__(self, col: Colour=TransparentColour, pos: float=0.) -> None:
        """
        GraphicsGradientStop(col=TransparentColour, pos=0.) -> None
        
        Represents a single gradient stop in a collection of gradient stops as
        represented by wxGraphicsGradientStops.
        """

    def GetColour(self) -> Colour:
        """
        GetColour() -> Colour
        
        Return the stop colour.
        """

    def SetColour(self, col: Colour) -> None:
        """
        SetColour(col) -> None
        
        Change the stop colour.
        """

    def GetPosition(self) -> float:
        """
        GetPosition() -> float
        
        Return the stop position.
        """

    def SetPosition(self, pos: float) -> None:
        """
        SetPosition(pos) -> None
        
        Change the stop position.
        """
    @property
    def Colour(self) -> Colour: ...
    @Colour.setter
    def Colour(self, value: Colour, /) -> None: ...
    @property
    def Position(self) -> float: ...
    @Position.setter
    def Position(self, value: float, /) -> None: ...
# end of class GraphicsGradientStop


class GraphicsGradientStops:
    """
    GraphicsGradientStops(startCol=TransparentColour, endCol=TransparentColour) -> None
    
    Represents a collection of wxGraphicGradientStop values for use with
    CreateLinearGradientBrush and CreateRadialGradientBrush.
    """

    def __init__(self, startCol: Colour=TransparentColour, endCol: Colour=TransparentColour) -> None:
        """
        GraphicsGradientStops(startCol=TransparentColour, endCol=TransparentColour) -> None
        
        Represents a collection of wxGraphicGradientStop values for use with
        CreateLinearGradientBrush and CreateRadialGradientBrush.
        """

    @overload
    def Add(self, col: Colour, pos: float) -> None:
        ...

    @overload
    def Add(self, stop: GraphicsGradientStop) -> None:
        """
        Add(stop) -> None
        Add(col, pos) -> None
        
        Add a new stop.
        """

    def Item(self, n: int) -> GraphicsGradientStop:
        """
        Item(n) -> GraphicsGradientStop
        
        Returns the stop at the given index.
        """

    def GetCount(self) -> int:
        """
        GetCount() -> int
        
        Returns the number of stops.
        """

    def SetStartColour(self, col: Colour) -> None:
        """
        SetStartColour(col) -> None
        
        Set the start colour to col.
        """

    def GetStartColour(self) -> Colour:
        """
        GetStartColour() -> Colour
        
        Returns the start colour.
        """

    def SetEndColour(self, col: Colour) -> None:
        """
        SetEndColour(col) -> None
        
        Set the end colour to col.
        """

    def GetEndColour(self) -> Colour:
        """
        GetEndColour() -> Colour
        
        Returns the end colour.
        """

    def __len__(self) -> Py_ssize_t:
        """
        __len__() -> Py_ssize_t
        """

    def __getitem__(self, n: int) -> GraphicsGradientStop:
        """
        __getitem__(n)
        """
    @property
    def Count(self) -> int: ...
    @property
    def EndColour(self) -> Colour: ...
    @EndColour.setter
    def EndColour(self, value: Colour, /) -> None: ...
    @property
    def StartColour(self) -> Colour: ...
    @StartColour.setter
    def StartColour(self, value: Colour, /) -> None: ...
# end of class GraphicsGradientStops


class GraphicsMatrix(GraphicsObject):
    """
    A wxGraphicsMatrix is a native representation of an affine matrix.
    """

    def Concat(self, t: GraphicsMatrix) -> None:
        """
        Concat(t) -> None
        
        Concatenates the matrix passed with the current matrix.
        """

    def Get(self) -> Tuple[float, float, float, float, float, float]:
        """
        Get() -> Tuple[float, float, float, float, float, float]
        
        Returns the component values of the matrix via the argument pointers.
        """

    def GetNativeMatrix(self) -> Any:
        """
        GetNativeMatrix() -> Any
        
        Returns the native representation of the matrix.
        """

    def Invert(self) -> None:
        """
        Invert() -> None
        
        Inverts the matrix.
        """

    def IsEqual(self, t: GraphicsMatrix) -> bool:
        """
        IsEqual(t) -> bool
        
        Returns true if the elements of the transformation matrix are equal.
        """

    def IsIdentity(self) -> bool:
        """
        IsIdentity() -> bool
        
        Return true if this is the identity matrix.
        """

    def Rotate(self, angle: float) -> None:
        """
        Rotate(angle) -> None
        
        Rotates this matrix clockwise (in radians).
        """

    def Scale(self, xScale: float, yScale: float) -> None:
        """
        Scale(xScale, yScale) -> None
        
        Scales this matrix.
        """

    def Set(self, a: float=1.0, b: float=0.0, c: float=0.0, d: float=1.0, tx: float=0.0, ty: float=0.0) -> None:
        """
        Set(a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0) -> None
        
        Sets the matrix to the respective values (default values are the identity matrix).
        """

    def TransformDistance(self, dx: float, dy: float) -> Tuple[float, float]:
        """
        TransformDistance(dx, dy) -> Tuple[float, float]
        
        Applies this matrix to a distance (ie.
        """

    def TransformPoint(self, x: float, y: float) -> Tuple[float, float]:
        """
        TransformPoint(x, y) -> Tuple[float, float]
        
        Applies this matrix to a point.
        """

    def Translate(self, dx: float, dy: float) -> None:
        """
        Translate(dx, dy) -> None
        
        Translates this matrix.
        """
    @property
    def NativeMatrix(self) -> Any: ...
# end of class GraphicsMatrix


class GraphicsPath(GraphicsObject):
    """
    A wxGraphicsPath is a native representation of a geometric path.
    """

    @overload
    def AddArc(self, c: Point2D, r: float, startAngle: float, endAngle: float, clockwise: bool) -> None:
        ...

    @overload
    def AddArc(self, x: float, y: float, r: float, startAngle: float, endAngle: float, clockwise: bool) -> None:
        """
        AddArc(x, y, r, startAngle, endAngle, clockwise) -> None
        AddArc(c, r, startAngle, endAngle, clockwise) -> None
        
        Adds an arc of a circle.
        """

    def AddArcToPoint(self, x1: float, y1: float, x2: float, y2: float, r: float) -> None:
        """
        AddArcToPoint(x1, y1, x2, y2, r) -> None
        
        Adds an arc (of a circle with radius r) that is tangent to the line
        connecting current point and (x1, y1) and to the line connecting (x1,
        y1) and (x2, y2).
        """

    def AddCircle(self, x: float, y: float, r: float) -> None:
        """
        AddCircle(x, y, r) -> None
        
        Appends a circle around (x,y) with radius r as a new closed subpath.
        """

    @overload
    def AddCurveToPoint(self, c1: Point2D, c2: Point2D, e: Point2D) -> None:
        ...

    @overload
    def AddCurveToPoint(self, cx1: float, cy1: float, cx2: float, cy2: float, x: float, y: float) -> None:
        """
        AddCurveToPoint(cx1, cy1, cx2, cy2, x, y) -> None
        AddCurveToPoint(c1, c2, e) -> None
        
        Adds a cubic bezier curve from the current point, using two control
        points and an end point.
        """

    def AddEllipse(self, x: float, y: float, w: float, h: float) -> None:
        """
        AddEllipse(x, y, w, h) -> None
        
        Appends an ellipse fitting into the passed in rectangle as a new
        closed subpath.
        """

    @overload
    def AddLineToPoint(self, p: Point2D) -> None:
        ...

    @overload
    def AddLineToPoint(self, x: float, y: float) -> None:
        """
        AddLineToPoint(x, y) -> None
        AddLineToPoint(p) -> None
        
        Adds a straight line from the current point to (x,y).
        """

    def AddPath(self, path: GraphicsPath) -> None:
        """
        AddPath(path) -> None
        
        Adds another path onto the current path.
        """

    def AddQuadCurveToPoint(self, cx: float, cy: float, x: float, y: float) -> None:
        """
        AddQuadCurveToPoint(cx, cy, x, y) -> None
        
        Adds a quadratic bezier curve from the current point, using a control
        point and an end point.
        """

    def AddRectangle(self, x: float, y: float, w: float, h: float) -> None:
        """
        AddRectangle(x, y, w, h) -> None
        
        Appends a rectangle as a new closed subpath.
        """

    def AddRoundedRectangle(self, x: float, y: float, w: float, h: float, radius: float) -> None:
        """
        AddRoundedRectangle(x, y, w, h, radius) -> None
        
        Appends a rounded rectangle as a new closed subpath.
        """

    def CloseSubpath(self) -> None:
        """
        CloseSubpath() -> None
        
        Closes the current sub-path.
        """

    @overload
    def Contains(self, x: float, y: float, fillStyle: PolygonFillMode=ODDEVEN_RULE) -> bool:
        ...

    @overload
    def Contains(self, c: Point2D, fillStyle: PolygonFillMode=ODDEVEN_RULE) -> bool:
        """
        Contains(c, fillStyle=ODDEVEN_RULE) -> bool
        Contains(x, y, fillStyle=ODDEVEN_RULE) -> bool
        """

    def GetBox(self) -> Rect2D:
        """
        GetBox() -> Rect2D
        
        Gets the bounding box enclosing all points (possibly including control
        points).
        """

    def GetCurrentPoint(self) -> Point2D:
        """
        GetCurrentPoint() -> Point2D
        
        Gets the last point of the current path, (0,0) if not yet set.
        """

    def GetNativePath(self) -> Any:
        """
        GetNativePath() -> Any
        
        Returns the native path (CGPathRef for Core Graphics, Path pointer for
        GDIPlus and a cairo_path_t pointer for cairo).
        """

    @overload
    def MoveToPoint(self, p: Point2D) -> None:
        ...

    @overload
    def MoveToPoint(self, x: float, y: float) -> None:
        """
        MoveToPoint(x, y) -> None
        MoveToPoint(p) -> None
        
        Begins a new subpath at (x,y).
        """

    def Transform(self, matrix: GraphicsMatrix) -> None:
        """
        Transform(matrix) -> None
        
        Transforms each point of this path by the matrix.
        """

    def UnGetNativePath(self, p: Any) -> None:
        """
        UnGetNativePath(p) -> None
        
        Gives back the native path returned by GetNativePath() because there
        might be some deallocations necessary (e.g.
        """
    @property
    def Box(self) -> Rect2D: ...
    @property
    def CurrentPoint(self) -> Point2D: ...
    @property
    def NativePath(self) -> Any: ...
# end of class GraphicsPath


class GraphicsRenderer(Object):
    """
    A wxGraphicsRenderer is the instance corresponding to the rendering
    engine used.
    """

    def CreateBitmap(self, bitmap: Bitmap) -> GraphicsBitmap:
        """
        CreateBitmap(bitmap) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from an existing wxBitmap.
        """

    def CreateBitmapFromImage(self, image: Image) -> GraphicsBitmap:
        """
        CreateBitmapFromImage(image) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from an existing wxImage.
        """

    def CreateImageFromBitmap(self, bmp: GraphicsBitmap) -> Image:
        """
        CreateImageFromBitmap(bmp) -> Image
        
        Creates a wxImage from a wxGraphicsBitmap.
        """

    def CreateBitmapFromNativeBitmap(self, bitmap: Any) -> GraphicsBitmap:
        """
        CreateBitmapFromNativeBitmap(bitmap) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from a native bitmap handle.
        """

    @overload
    def CreateContext(self, windowDC: WindowDC) -> GraphicsContext:
        ...

    @overload
    def CreateContext(self, memoryDC: MemoryDC) -> GraphicsContext:
        ...

    @overload
    def CreateContext(self, printerDC: PrinterDC) -> GraphicsContext:
        ...

    @overload
    def CreateContext(self, window: Window) -> GraphicsContext:
        """
        CreateContext(window) -> GraphicsContext
        CreateContext(windowDC) -> GraphicsContext
        CreateContext(memoryDC) -> GraphicsContext
        CreateContext(printerDC) -> GraphicsContext
        
        Creates a wxGraphicsContext from a wxWindow.
        """

    def CreateContextFromUnknownDC(self, dc: DC) -> GraphicsContext:
        """
        CreateContextFromUnknownDC(dc) -> GraphicsContext
        
        Creates a wxGraphicsContext from a DC of unknown specific type.
        """

    def CreateContextFromImage(self, image: Image) -> GraphicsContext:
        """
        CreateContextFromImage(image) -> GraphicsContext
        
        Creates a wxGraphicsContext associated with a wxImage.
        """

    def CreateBrush(self, brush: Brush) -> GraphicsBrush:
        """
        CreateBrush(brush) -> GraphicsBrush
        
        Creates a native brush from a wxBrush.
        """

    def CreateContextFromNativeContext(self, context: Any) -> GraphicsContext:
        """
        CreateContextFromNativeContext(context) -> GraphicsContext
        
        Creates a wxGraphicsContext from a native context.
        """

    def CreateContextFromNativeWindow(self, window: Any) -> GraphicsContext:
        """
        CreateContextFromNativeWindow(window) -> GraphicsContext
        
        Creates a wxGraphicsContext from a native window.
        """

    def CreateMeasuringContext(self) -> GraphicsContext:
        """
        CreateMeasuringContext() -> GraphicsContext
        
        Creates a wxGraphicsContext that can be used for measuring texts only.
        """

    @overload
    def CreateFont(self, sizeInPixels: float, facename: str, flags: int=FONTFLAG_DEFAULT, col: Colour=BLACK) -> GraphicsFont:
        ...

    @overload
    def CreateFont(self, font: Font, col: Colour=BLACK) -> GraphicsFont:
        """
        CreateFont(font, col=BLACK) -> GraphicsFont
        CreateFont(sizeInPixels, facename, flags=FONTFLAG_DEFAULT, col=BLACK) -> GraphicsFont
        
        Creates a native graphics font from a wxFont and a text colour.
        """

    def CreateFontAtDPI(self, font: Font, dpi: RealPoint, col: Colour=BLACK) -> GraphicsFont:
        """
        CreateFontAtDPI(font, dpi, col=BLACK) -> GraphicsFont
        
        Creates a native graphics font from a wxFont and a text colour.
        """

    def CreateLinearGradientBrush(self, x1: float, y1: float, x2: float, y2: float, stops: GraphicsGradientStops, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsBrush:
        """
        CreateLinearGradientBrush(x1, y1, x2, y2, stops, matrix=NullGraphicsMatrix) -> GraphicsBrush
        
        Creates a native brush with a linear gradient.
        """

    def CreateMatrix(self, a: float=1.0, b: float=0.0, c: float=0.0, d: float=1.0, tx: float=0.0, ty: float=0.0) -> GraphicsMatrix:
        """
        CreateMatrix(a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0) -> GraphicsMatrix
        
        Creates a native affine transformation matrix from the passed in
        values.
        """

    def CreatePath(self) -> GraphicsPath:
        """
        CreatePath() -> GraphicsPath
        
        Creates a native graphics path which is initially empty.
        """

    def CreatePen(self, info: GraphicsPenInfo) -> GraphicsPen:
        """
        CreatePen(info) -> GraphicsPen
        
        Creates a native pen from its description.
        """

    def CreateRadialGradientBrush(self, startX: float, startY: float, endX: float, endY: float, radius: float, stops: GraphicsGradientStops, matrix: GraphicsMatrix=NullGraphicsMatrix) -> GraphicsBrush:
        """
        CreateRadialGradientBrush(startX, startY, endX, endY, radius, stops, matrix=NullGraphicsMatrix) -> GraphicsBrush
        
        Creates a native brush with a radial gradient.
        """

    def CreateSubBitmap(self, bitmap: GraphicsBitmap, x: float, y: float, w: float, h: float) -> GraphicsBitmap:
        """
        CreateSubBitmap(bitmap, x, y, w, h) -> GraphicsBitmap
        
        Extracts a sub-bitmap from an existing bitmap.
        """

    def GetName(self) -> str:
        """
        GetName() -> str
        
        Returns the name of the technology used by the renderer.
        """

    def GetVersion(self, major: int, minor: Optional[int]=None, micro: Optional[int]=None) -> None:
        """
        GetVersion(major, minor=None, micro=None) -> None
        
        Returns the version major, minor and micro/build of the technology
        used by the renderer.
        """

    @staticmethod
    def GetDefaultRenderer() -> GraphicsRenderer:
        """
        GetDefaultRenderer() -> GraphicsRenderer
        
        Returns the default renderer on this platform.
        """

    @staticmethod
    def GetCairoRenderer() -> GraphicsRenderer:
        """
        GetCairoRenderer() -> GraphicsRenderer
        
        Returns Cairo renderer.
        """

    @staticmethod
    def GetGDIPlusRenderer() -> GraphicsRenderer:
        """
        GetGDIPlusRenderer() -> GraphicsRenderer
        
        Returns GDI+ renderer (MSW only).
        """

    @staticmethod
    def GetDirect2DRenderer() -> GraphicsRenderer:
        """
        GetDirect2DRenderer() -> GraphicsRenderer
        
        Returns Direct2D renderer (MSW and Python3 only).
        """

    def _ctx_hold_ref(f):
        from functools import wraps
        @wraps(f)
        def wrapper(self, obj):
            ctx = f(self, obj)
            if ctx is not None:
                ctx._obj = obj
            return ctx
        return wrapper
    CreateContext = _ctx_hold_ref(CreateContext)
    CreateContextFromImage = _ctx_hold_ref(CreateContextFromImage)
    CreateContextFromUnknownDC = _ctx_hold_ref(CreateContextFromUnknownDC)

    def GetType(self):
        """
        Returns the name of the GraphicsRenderer class.
        """
    @property
    def Name(self) -> str: ...
    Type = property(GetType)
# end of class GraphicsRenderer

NullGraphicsPen: GraphicsPen
NullGraphicsBrush: GraphicsBrush
NullGraphicsFont: GraphicsFont
NullGraphicsBitmap: GraphicsBitmap
NullGraphicsMatrix: GraphicsMatrix
NullGraphicsPath: GraphicsPath
#-- end-graphics --#
#-- begin-imaglist --#
IMAGELIST_DRAW_NORMAL: int
IMAGELIST_DRAW_TRANSPARENT: int
IMAGELIST_DRAW_SELECTED: int
IMAGELIST_DRAW_FOCUSED: int

class _enum_(IntEnum):
    IMAGE_LIST_NORMAL = auto()
    IMAGE_LIST_SMALL = auto()
    IMAGE_LIST_STATE = auto()
IMAGE_LIST_NORMAL = _enum_.IMAGE_LIST_NORMAL
IMAGE_LIST_SMALL = _enum_.IMAGE_LIST_SMALL
IMAGE_LIST_STATE = _enum_.IMAGE_LIST_STATE

class ImageList(Object):
    """
    ImageList() -> None
    ImageList(width, height, mask=True, initialCount=1) -> None
    
    A wxImageList contains a list of images, which are stored in an
    unspecified form.
    """

    @overload
    def __init__(self, width: int, height: int, mask: bool=True, initialCount: int=1) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        ImageList() -> None
        ImageList(width, height, mask=True, initialCount=1) -> None
        
        A wxImageList contains a list of images, which are stored in an
        unspecified form.
        """

    @overload
    def Add(self, bitmap: Bitmap, maskColour: Colour) -> int:
        ...

    @overload
    def Add(self, icon: Icon) -> int:
        ...

    @overload
    def Add(self, bitmap: Bitmap, mask: Bitmap=NullBitmap) -> int:
        """
        Add(bitmap, mask=NullBitmap) -> int
        Add(bitmap, maskColour) -> int
        Add(icon) -> int
        
        Adds a new image or images using a bitmap and optional mask bitmap.
        """

    def Create(self, width: int, height: int, mask: bool=True, initialCount: int=1) -> bool:
        """
        Create(width, height, mask=True, initialCount=1) -> bool
        
        Initializes the list.
        """

    def Destroy(self) -> None:
        """
        Destroy() -> None
        
        Destroys the current list.
        """

    def Draw(self, index: int, dc: DC, x: int, y: int, flags: int=IMAGELIST_DRAW_NORMAL, solidBackground: bool=False) -> bool:
        """
        Draw(index, dc, x, y, flags=IMAGELIST_DRAW_NORMAL, solidBackground=False) -> bool
        
        Draws a specified image onto a device context.
        """

    def GetBitmap(self, index: int) -> Bitmap:
        """
        GetBitmap(index) -> Bitmap
        
        Returns the bitmap corresponding to the given index.
        """

    def GetIcon(self, index: int) -> Icon:
        """
        GetIcon(index) -> Icon
        
        Returns the icon corresponding to the given index.
        """

    def GetImageCount(self) -> int:
        """
        GetImageCount() -> int
        
        Returns the number of images in the list.
        """

    @overload
    def GetSize(self) -> Size:
        ...

    @overload
    def GetSize(self, index: int) -> Tuple[int, int]:
        """
        GetSize(index) -> Tuple[int, int]
        GetSize() -> Size
        
        Retrieves the size of the images in the list.
        """

    def Remove(self, index: int) -> bool:
        """
        Remove(index) -> bool
        
        Removes the image at the given position.
        """

    def RemoveAll(self) -> bool:
        """
        RemoveAll() -> bool
        
        Removes all the images in the list.
        """

    @overload
    def Replace(self, index: int, icon: Icon) -> bool:
        ...

    @overload
    def Replace(self, index: int, bitmap: Bitmap, mask: Bitmap=NullBitmap) -> bool:
        """
        Replace(index, bitmap, mask=NullBitmap) -> bool
        Replace(index, icon) -> bool
        
        Replaces the existing image with the new image.
        """
    @property
    def ImageCount(self) -> int: ...
    @property
    def Size(self) -> Tuple[int, int]: ...
# end of class ImageList

#-- end-imaglist --#
#-- begin-overlay --#

class Overlay:
    """
    Overlay() -> None
    
    Creates an overlay over an existing window, allowing for manipulations
    like rubberbanding, etc.
    """

    def __init__(self) -> None:
        """
        Overlay() -> None
        
        Creates an overlay over an existing window, allowing for manipulations
        like rubberbanding, etc.
        """

    def Reset(self) -> None:
        """
        Reset() -> None
        
        Clears the overlay without restoring the former state.
        """
# end of class Overlay


class DCOverlay:
    """
    DCOverlay(overlay, dc, x, y, width, height) -> None
    DCOverlay(overlay, dc) -> None
    
    Connects an overlay with a drawing DC.
    """

    @overload
    def __init__(self, overlay: Overlay, dc: DC) -> None:
        ...

    @overload
    def __init__(self, overlay: Overlay, dc: DC, x: int, y: int, width: int, height: int) -> None:
        """
        DCOverlay(overlay, dc, x, y, width, height) -> None
        DCOverlay(overlay, dc) -> None
        
        Connects an overlay with a drawing DC.
        """

    def Clear(self) -> None:
        """
        Clear() -> None
        
        Clears the layer, restoring the state at the last init.
        """
# end of class DCOverlay

#-- end-overlay --#
#-- begin-palette --#

class Palette(GDIObject):
    """
    Palette() -> None
    Palette(palette) -> None
    Palette(red, green, blue) -> None
    
    A palette is a table that maps pixel values to RGB colours.
    """

    @overload
    def __init__(self, palette: Palette) -> None:
        ...

    @overload
    def __init__(self, red: Any, green: Any, blue: Any) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Palette() -> None
        Palette(palette) -> None
        Palette(red, green, blue) -> None
        
        A palette is a table that maps pixel values to RGB colours.
        """

    def Create(self, red: Any, green: Any, blue: Any) -> Any:
        """
        Create(red, green, blue) -> bool
        
        Creates a palette from 3 sequences of integers, one for each red, blue or green component.
        
        :param red: A sequence of integer values in the range 0..255
        inclusive.
        :param green: A sequence of integer values in the range 0..255
        inclusive.
        :param blue: A sequence of integer values in the range 0..255
        inclusive.
        
        .. note:: All sequences must be the same length.
        """

    def GetColoursCount(self) -> int:
        """
        GetColoursCount() -> int
        
        Returns number of entries in palette.
        """

    def GetPixel(self, red: int, green: int, blue: int) -> int:
        """
        GetPixel(red, green, blue) -> int
        
        Returns a pixel value (index into the palette) for the given RGB
        values.
        """

    def GetRGB(self, pixel: int) -> Any:
        """
        GetRGB(pixel) -> (red, green, blue)
        
        Returns RGB values for a given palette index.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if palette data is present.
        """
    @property
    def ColoursCount(self) -> int: ...
    @property
    def RGB(self) -> Any: ...
# end of class Palette

NullPalette: Palette
#-- end-palette --#
#-- begin-renderer --#

class _enum_(IntEnum):
    CONTROL_NONE = auto()
    CONTROL_DISABLED = auto()
    CONTROL_FOCUSED = auto()
    CONTROL_PRESSED = auto()
    CONTROL_SPECIAL = auto()
    CONTROL_ISDEFAULT = auto()
    CONTROL_ISSUBMENU = auto()
    CONTROL_EXPANDED = auto()
    CONTROL_SIZEGRIP = auto()
    CONTROL_FLAT = auto()
    CONTROL_CELL = auto()
    CONTROL_CURRENT = auto()
    CONTROL_SELECTED = auto()
    CONTROL_CHECKED = auto()
    CONTROL_CHECKABLE = auto()
    CONTROL_UNDETERMINED = auto()
CONTROL_NONE = _enum_.CONTROL_NONE
CONTROL_DISABLED = _enum_.CONTROL_DISABLED
CONTROL_FOCUSED = _enum_.CONTROL_FOCUSED
CONTROL_PRESSED = _enum_.CONTROL_PRESSED
CONTROL_SPECIAL = _enum_.CONTROL_SPECIAL
CONTROL_ISDEFAULT = _enum_.CONTROL_ISDEFAULT
CONTROL_ISSUBMENU = _enum_.CONTROL_ISSUBMENU
CONTROL_EXPANDED = _enum_.CONTROL_EXPANDED
CONTROL_SIZEGRIP = _enum_.CONTROL_SIZEGRIP
CONTROL_FLAT = _enum_.CONTROL_FLAT
CONTROL_CELL = _enum_.CONTROL_CELL
CONTROL_CURRENT = _enum_.CONTROL_CURRENT
CONTROL_SELECTED = _enum_.CONTROL_SELECTED
CONTROL_CHECKED = _enum_.CONTROL_CHECKED
CONTROL_CHECKABLE = _enum_.CONTROL_CHECKABLE
CONTROL_UNDETERMINED = _enum_.CONTROL_UNDETERMINED

class _TitleBarButton(IntEnum):
    TITLEBAR_BUTTON_CLOSE = auto()
    TITLEBAR_BUTTON_MAXIMIZE = auto()
    TITLEBAR_BUTTON_ICONIZE = auto()
    TITLEBAR_BUTTON_RESTORE = auto()
    TITLEBAR_BUTTON_HELP = auto()
TitleBarButton: TypeAlias = Union[_TitleBarButton, int]
TITLEBAR_BUTTON_CLOSE = _TitleBarButton.TITLEBAR_BUTTON_CLOSE
TITLEBAR_BUTTON_MAXIMIZE = _TitleBarButton.TITLEBAR_BUTTON_MAXIMIZE
TITLEBAR_BUTTON_ICONIZE = _TitleBarButton.TITLEBAR_BUTTON_ICONIZE
TITLEBAR_BUTTON_RESTORE = _TitleBarButton.TITLEBAR_BUTTON_RESTORE
TITLEBAR_BUTTON_HELP = _TitleBarButton.TITLEBAR_BUTTON_HELP

class _HeaderSortIconType(IntEnum):
    HDR_SORT_ICON_NONE = auto()
    HDR_SORT_ICON_UP = auto()
    HDR_SORT_ICON_DOWN = auto()
HeaderSortIconType: TypeAlias = Union[_HeaderSortIconType, int]
HDR_SORT_ICON_NONE = _HeaderSortIconType.HDR_SORT_ICON_NONE
HDR_SORT_ICON_UP = _HeaderSortIconType.HDR_SORT_ICON_UP
HDR_SORT_ICON_DOWN = _HeaderSortIconType.HDR_SORT_ICON_DOWN

class SplitterRenderParams:
    """
    SplitterRenderParams(widthSash_, border_, isSens_) -> None
    
    This is just a simple struct used as a return value of
    wxRendererNative::GetSplitterParams().
    """

    def __init__(self, widthSash_: int, border_: int, isSens_: bool) -> None:
        """
        SplitterRenderParams(widthSash_, border_, isSens_) -> None
        
        This is just a simple struct used as a return value of
        wxRendererNative::GetSplitterParams().
        """
    border: int
    isHotSensitive: bool
    widthSash: int
# end of class SplitterRenderParams


class HeaderButtonParams:
    """
    HeaderButtonParams() -> None
    
    This struct can optionally be used with
    wxRendererNative::DrawHeaderButton() to specify custom values used to
    draw the text or bitmap label.
    """

    def __init__(self) -> None:
        """
        HeaderButtonParams() -> None
        
        This struct can optionally be used with
        wxRendererNative::DrawHeaderButton() to specify custom values used to
        draw the text or bitmap label.
        """
    m_arrowColour: Colour
    m_selectionColour: Colour
    m_labelText: str
    m_labelFont: Font
    m_labelColour: Colour
    m_labelBitmap: Bitmap
    m_labelAlignment: int
# end of class HeaderButtonParams


class RendererNative:
    """
    First, a brief introduction to wxRendererNative and why it is needed.
    """

    def DrawCheckBox(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawCheckBox(win, dc, rect, flags=0) -> None
        
        Draw a check box.
        """

    def DrawComboBoxDropButton(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawComboBoxDropButton(win, dc, rect, flags=0) -> None
        
        Draw a button like the one used by wxComboBox to show a drop down
        window.
        """

    def DrawDropArrow(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawDropArrow(win, dc, rect, flags=0) -> None
        
        Draw a drop down arrow that is suitable for use outside a combo box.
        """

    def DrawFocusRect(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawFocusRect(win, dc, rect, flags=0) -> None
        
        Draw a focus rectangle using the specified rectangle.
        """

    def DrawGauge(self, win: Window, dc: DC, rect: Rect, value: int, max: int, flags: int=0) -> None:
        """
        DrawGauge(win, dc, rect, value, max, flags=0) -> None
        
        Draw a progress bar in the specified rectangle.
        """

    def DrawHeaderButton(self, win: Window, dc: DC, rect: Rect, flags: int=0, sortArrow: HeaderSortIconType=HDR_SORT_ICON_NONE, params: Optional[HeaderButtonParams]=None) -> int:
        """
        DrawHeaderButton(win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int
        
        Draw the header control button (used, for example, by wxListCtrl).
        """

    def DrawHeaderButtonContents(self, win: Window, dc: DC, rect: Rect, flags: int=0, sortArrow: HeaderSortIconType=HDR_SORT_ICON_NONE, params: Optional[HeaderButtonParams]=None) -> int:
        """
        DrawHeaderButtonContents(win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int
        
        Draw the contents of a header control button (label, sort arrows,
        etc.).
        """

    def DrawItemSelectionRect(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawItemSelectionRect(win, dc, rect, flags=0) -> None
        
        Draw a selection rectangle underneath the text as used e.g.
        """

    def DrawItemText(self, win: Window, dc: DC, text: str, rect: Rect, align: int=ALIGN_LEFT|ALIGN_TOP, flags: int=0, ellipsizeMode: EllipsizeMode=ELLIPSIZE_END) -> None:
        """
        DrawItemText(win, dc, text, rect, align=ALIGN_LEFT|ALIGN_TOP, flags=0, ellipsizeMode=ELLIPSIZE_END) -> None
        
        Draw item text in the correct color based on selection status.
        """

    def DrawPushButton(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawPushButton(win, dc, rect, flags=0) -> None
        
        Draw a blank push button that looks very similar to wxButton.
        """

    def DrawCollapseButton(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawCollapseButton(win, dc, rect, flags=0) -> None
        
        Draw a collapse button.
        """

    def GetCollapseButtonSize(self, win: Window, dc: DC) -> Size:
        """
        GetCollapseButtonSize(win, dc) -> Size
        
        Returns the size of a collapse button.
        """

    def DrawSplitterBorder(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawSplitterBorder(win, dc, rect, flags=0) -> None
        
        Draw the border for sash window: this border must be such that the
        sash drawn by DrawSplitterSash() blends into it well.
        """

    def DrawSplitterSash(self, win: Window, dc: DC, size: Size, position: int, orient: Orientation, flags: int=0) -> None:
        """
        DrawSplitterSash(win, dc, size, position, orient, flags=0) -> None
        
        Draw a sash.
        """

    def DrawTreeItemButton(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawTreeItemButton(win, dc, rect, flags=0) -> None
        
        Draw the expanded/collapsed icon for a tree control item.
        """

    def DrawChoice(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawChoice(win, dc, rect, flags=0) -> None
        
        Draw a native wxChoice.
        """

    def DrawComboBox(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawComboBox(win, dc, rect, flags=0) -> None
        
        Draw a native wxComboBox.
        """

    def DrawTextCtrl(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawTextCtrl(win, dc, rect, flags=0) -> None
        
        Draw a native wxTextCtrl frame.
        """

    def DrawRadioBitmap(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawRadioBitmap(win, dc, rect, flags=0) -> None
        
        Draw a native wxRadioButton bitmap.
        """

    def DrawTitleBarBitmap(self, win: Window, dc: DC, rect: Rect, button: TitleBarButton, flags: int=0) -> None:
        """
        DrawTitleBarBitmap(win, dc, rect, button, flags=0) -> None
        
        Draw a title bar button in the given state.
        """

    def DrawCheckMark(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawCheckMark(win, dc, rect, flags=0) -> None
        
        Draw a check mark.
        """

    def GetCheckBoxSize(self, win: Window, flags: int=0) -> Size:
        """
        GetCheckBoxSize(win, flags=0) -> Size
        
        Returns the size of a check box.
        """

    def GetCheckMarkSize(self, win: Window) -> Size:
        """
        GetCheckMarkSize(win) -> Size
        
        Returns the size of a check mark.
        """

    def GetExpanderSize(self, win: Window) -> Size:
        """
        GetExpanderSize(win) -> Size
        
        Returns the size of the expander used in tree-like controls.
        """

    def GetHeaderButtonHeight(self, win: Window) -> int:
        """
        GetHeaderButtonHeight(win) -> int
        
        Returns the height of a header button, either a fixed platform height
        if available, or a generic height based on the win window's font.
        """

    def GetHeaderButtonMargin(self, win: Window) -> int:
        """
        GetHeaderButtonMargin(win) -> int
        
        Returns the horizontal margin on the left and right sides of header
        button's label.
        """

    def GetSplitterParams(self, win: Window) -> SplitterRenderParams:
        """
        GetSplitterParams(win) -> SplitterRenderParams
        
        Get the splitter parameters, see wxSplitterRenderParams.
        """

    def GetVersion(self) -> RendererVersion:
        """
        GetVersion() -> RendererVersion
        
        This function is used for version checking: Load() refuses to load any
        shared libraries implementing an older or incompatible version.
        """

    @staticmethod
    def Get() -> RendererNative:
        """
        Get() -> RendererNative
        
        Return the currently used renderer.
        """

    @staticmethod
    def GetDefault() -> RendererNative:
        """
        GetDefault() -> RendererNative
        
        Return the default (native) implementation for this platform  this is
        also the one used by default but this may be changed by calling Set()
        in which case the return value of this method may be different from
        the return value of Get().
        """

    @staticmethod
    def GetGeneric() -> RendererNative:
        """
        GetGeneric() -> RendererNative
        
        Return the generic implementation of the renderer.
        """

    @staticmethod
    def Load(name: str) -> RendererNative:
        """
        Load(name) -> RendererNative
        
        Load the renderer from the specified DLL, the returned pointer must be deleted by caller if not NULL when it is not used any more.
        """

    @staticmethod
    def Set(renderer: RendererNative) -> RendererNative:
        """
        Set(renderer) -> RendererNative
        
        Set the renderer to use, passing NULL reverts to using the default renderer (the global renderer must always exist).
        """
    @property
    def Version(self) -> RendererVersion: ...
# end of class RendererNative


class DelegateRendererNative(RendererNative):
    """
    DelegateRendererNative() -> None
    DelegateRendererNative(rendererNative) -> None
    
    wxDelegateRendererNative allows reuse of renderers code by forwarding
    all the wxRendererNative methods to the given object and thus allowing
    you to only modify some of its methods  without having to reimplement
    all of them.
    """

    @overload
    def __init__(self, rendererNative: RendererNative) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        DelegateRendererNative() -> None
        DelegateRendererNative(rendererNative) -> None
        
        wxDelegateRendererNative allows reuse of renderers code by forwarding
        all the wxRendererNative methods to the given object and thus allowing
        you to only modify some of its methods  without having to reimplement
        all of them.
        """

    def DrawHeaderButton(self, win: Window, dc: DC, rect: Rect, flags: int=0, sortArrow: HeaderSortIconType=HDR_SORT_ICON_NONE, params: Optional[HeaderButtonParams]=None) -> int:
        """
        DrawHeaderButton(win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int
        
        Draw the header control button (used, for example, by wxListCtrl).
        """

    def DrawHeaderButtonContents(self, win: Window, dc: DC, rect: Rect, flags: int=0, sortArrow: HeaderSortIconType=HDR_SORT_ICON_NONE, params: Optional[HeaderButtonParams]=None) -> int:
        """
        DrawHeaderButtonContents(win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int
        
        Draw the contents of a header control button (label, sort arrows,
        etc.).
        """

    def GetHeaderButtonHeight(self, win: Window) -> int:
        """
        GetHeaderButtonHeight(win) -> int
        
        Returns the height of a header button, either a fixed platform height
        if available, or a generic height based on the win window's font.
        """

    def GetHeaderButtonMargin(self, win: Window) -> int:
        """
        GetHeaderButtonMargin(win) -> int
        
        Returns the horizontal margin on the left and right sides of header
        button's label.
        """

    def DrawTreeItemButton(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawTreeItemButton(win, dc, rect, flags=0) -> None
        
        Draw the expanded/collapsed icon for a tree control item.
        """

    def DrawSplitterBorder(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawSplitterBorder(win, dc, rect, flags=0) -> None
        
        Draw the border for sash window: this border must be such that the
        sash drawn by DrawSplitterSash() blends into it well.
        """

    def DrawSplitterSash(self, win: Window, dc: DC, size: Size, position: int, orient: Orientation, flags: int=0) -> None:
        """
        DrawSplitterSash(win, dc, size, position, orient, flags=0) -> None
        
        Draw a sash.
        """

    def DrawComboBoxDropButton(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawComboBoxDropButton(win, dc, rect, flags=0) -> None
        
        Draw a button like the one used by wxComboBox to show a drop down
        window.
        """

    def DrawDropArrow(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawDropArrow(win, dc, rect, flags=0) -> None
        
        Draw a drop down arrow that is suitable for use outside a combo box.
        """

    def DrawCheckBox(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawCheckBox(win, dc, rect, flags=0) -> None
        
        Draw a check box.
        """

    def DrawCheckMark(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawCheckMark(win, dc, rect, flags=0) -> None
        
        Draw a check mark.
        """

    def GetCheckBoxSize(self, win: Window, flags: int=0) -> Size:
        """
        GetCheckBoxSize(win, flags=0) -> Size
        
        Returns the size of a check box.
        """

    def GetCheckMarkSize(self, win: Window) -> Size:
        """
        GetCheckMarkSize(win) -> Size
        
        Returns the size of a check mark.
        """

    def GetExpanderSize(self, win: Window) -> Size:
        """
        GetExpanderSize(win) -> Size
        
        Returns the size of the expander used in tree-like controls.
        """

    def DrawPushButton(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawPushButton(win, dc, rect, flags=0) -> None
        
        Draw a blank push button that looks very similar to wxButton.
        """

    def DrawItemSelectionRect(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawItemSelectionRect(win, dc, rect, flags=0) -> None
        
        Draw a selection rectangle underneath the text as used e.g.
        """

    def DrawFocusRect(self, win: Window, dc: DC, rect: Rect, flags: int=0) -> None:
        """
        DrawFocusRect(win, dc, rect, flags=0) -> None
        
        Draw a focus rectangle using the specified rectangle.
        """

    def GetSplitterParams(self, win: Window) -> SplitterRenderParams:
        """
        GetSplitterParams(win) -> SplitterRenderParams
        
        Get the splitter parameters, see wxSplitterRenderParams.
        """

    def GetVersion(self) -> RendererVersion:
        """
        GetVersion() -> RendererVersion
        
        This function is used for version checking: Load() refuses to load any
        shared libraries implementing an older or incompatible version.
        """

    def DrawTitleBarBitmap(self, win: Window, dc: DC, rect: Rect, button: TitleBarButton, flags: int=0) -> None:
        """
        DrawTitleBarBitmap(win, dc, rect, button, flags=0) -> None
        
        Draw a title bar button in the given state.
        """
    @property
    def Version(self) -> RendererVersion: ...
# end of class DelegateRendererNative


class RendererVersion:
    """
    RendererVersion(version_, age_) -> None
    
    This simple struct represents the wxRendererNative interface version
    and is only used as the return value of
    wxRendererNative::GetVersion().
    """

    def __init__(self, version_: int, age_: int) -> None:
        """
        RendererVersion(version_, age_) -> None
        
        This simple struct represents the wxRendererNative interface version
        and is only used as the return value of
        wxRendererNative::GetVersion().
        """
    age: int
    version: int

    @staticmethod
    def IsCompatible(ver: RendererVersion) -> bool:
        """
        IsCompatible(ver) -> bool
        
        Checks if the main program is compatible with the renderer having the
        version ver, returns true if it is and false otherwise.
        """
# end of class RendererVersion

#-- end-renderer --#
#-- begin-rawbmp --#

class PixelDataBase:
    """
    PixelDataBase() -> None
    """

    def GetOrigin(self) -> Point:
        """
        GetOrigin() -> Point
        
        Return the origin of the area this pixel data represents.
        """

    def GetWidth(self) -> int:
        """
        GetWidth() -> int
        
        Return the width of the area this pixel data represents.
        """

    def GetHeight(self) -> int:
        """
        GetHeight() -> int
        
        Return the height of the area this pixel data represents.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Return the size of the area this pixel data represents.
        """

    def GetRowStride(self) -> int:
        """
        GetRowStride() -> int
        
        Returns the distance between the start of one row to the start of the
        next row.
        """

    def __iter__(self):
        """
        Create and return an iterator/generator object for traversing
        this pixel data object.
        """
    @property
    def Height(self) -> int: ...
    @property
    def Origin(self) -> Point: ...
    @property
    def RowStride(self) -> int: ...
    @property
    def Size(self) -> Size: ...
    @property
    def Width(self) -> int: ...

    def __init__(self) -> None:
        """
        """
# end of class PixelDataBase


class NativePixelData(PixelDataBase):
    """
    NativePixelData(bmp) -> None
    NativePixelData(bmp, rect) -> None
    NativePixelData(bmp, pt, sz) -> None
    
    A class providing direct access to a :class:`wx.Bitmap`'s
    internal data without alpha channel (RGB).
    """

    @overload
    def __init__(self, bmp: Bitmap, rect: Rect) -> None:
        ...

    @overload
    def __init__(self, bmp: Bitmap, pt: Point, sz: Size) -> None:
        ...

    @overload
    def __init__(self, bmp: Bitmap) -> None:
        """
        NativePixelData(bmp) -> None
        NativePixelData(bmp, rect) -> None
        NativePixelData(bmp, pt, sz) -> None
        
        A class providing direct access to a :class:`wx.Bitmap`'s
        internal data without alpha channel (RGB).
        """

    def GetPixels(self) -> NativePixelData_Accessor:
        """
        GetPixels() -> NativePixelData_Accessor
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """
    @property
    def Pixels(self) -> NativePixelData_Accessor: ...
# end of class NativePixelData


class NativePixelData_Accessor:
    """
    NativePixelData_Accessor(data) -> None
    NativePixelData_Accessor(bmp, data) -> None
    NativePixelData_Accessor() -> None
    """

    @overload
    def __init__(self, bmp: Bitmap, data: NativePixelData) -> None:
        ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, data: NativePixelData) -> None:
        """
        NativePixelData_Accessor(data) -> None
        NativePixelData_Accessor(bmp, data) -> None
        NativePixelData_Accessor() -> None
        """

    def Reset(self, data: NativePixelData) -> None:
        """
        Reset(data) -> None
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def Offset(self, data: NativePixelData, x: int, y: int) -> None:
        """
        Offset(data, x, y) -> None
        """

    def OffsetX(self, data: NativePixelData, x: int) -> None:
        """
        OffsetX(data, x) -> None
        """

    def OffsetY(self, data: NativePixelData, y: int) -> None:
        """
        OffsetY(data, y) -> None
        """

    def MoveTo(self, data: NativePixelData, x: int, y: int) -> None:
        """
        MoveTo(data, x, y) -> None
        """

    def nextPixel(self) -> None:
        """
        nextPixel() -> None
        """

    def Set(self, red: int, green: int, blue: int) -> None:
        """
        Set(red, green, blue) -> None
        """

    def Get(self) -> Any:
        """
        Get() -> Any
        """
# end of class NativePixelData_Accessor


class AlphaPixelData(PixelDataBase):
    """
    AlphaPixelData(bmp) -> None
    AlphaPixelData(bmp, rect) -> None
    AlphaPixelData(bmp, pt, sz) -> None
    
    A class providing direct access to a :class:`wx.Bitmap`'s
    internal data including the alpha channel (RGBA).
    """

    @overload
    def __init__(self, bmp: Bitmap, rect: Rect) -> None:
        ...

    @overload
    def __init__(self, bmp: Bitmap, pt: Point, sz: Size) -> None:
        ...

    @overload
    def __init__(self, bmp: Bitmap) -> None:
        """
        AlphaPixelData(bmp) -> None
        AlphaPixelData(bmp, rect) -> None
        AlphaPixelData(bmp, pt, sz) -> None
        
        A class providing direct access to a :class:`wx.Bitmap`'s
        internal data including the alpha channel (RGBA).
        """

    def GetPixels(self) -> AlphaPixelData_Accessor:
        """
        GetPixels() -> AlphaPixelData_Accessor
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """
    @property
    def Pixels(self) -> AlphaPixelData_Accessor: ...
# end of class AlphaPixelData


class AlphaPixelData_Accessor:
    """
    AlphaPixelData_Accessor(data) -> None
    AlphaPixelData_Accessor(bmp, data) -> None
    AlphaPixelData_Accessor() -> None
    """

    @overload
    def __init__(self, bmp: Bitmap, data: AlphaPixelData) -> None:
        ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, data: AlphaPixelData) -> None:
        """
        AlphaPixelData_Accessor(data) -> None
        AlphaPixelData_Accessor(bmp, data) -> None
        AlphaPixelData_Accessor() -> None
        """

    def Reset(self, data: AlphaPixelData) -> None:
        """
        Reset(data) -> None
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        """

    def __nonzero__(self) -> bool:
        """
        __nonzero__() -> bool
        """

    def __bool__(self) -> bool:
        """
        __bool__() -> bool
        """

    def Offset(self, data: AlphaPixelData, x: int, y: int) -> None:
        """
        Offset(data, x, y) -> None
        """

    def OffsetX(self, data: AlphaPixelData, x: int) -> None:
        """
        OffsetX(data, x) -> None
        """

    def OffsetY(self, data: AlphaPixelData, y: int) -> None:
        """
        OffsetY(data, y) -> None
        """

    def MoveTo(self, data: AlphaPixelData, x: int, y: int) -> None:
        """
        MoveTo(data, x, y) -> None
        """

    def nextPixel(self) -> None:
        """
        nextPixel() -> None
        """

    def Set(self, red: int, green: int, blue: int, alpha: int) -> None:
        """
        Set(red, green, blue, alpha) -> None
        """

    def Get(self) -> Any:
        """
        Get() -> Any
        """
# end of class AlphaPixelData_Accessor

#-- end-rawbmp --#
#-- begin-access --#
ACC_STATE_SYSTEM_ALERT_HIGH: int
ACC_STATE_SYSTEM_ALERT_MEDIUM: int
ACC_STATE_SYSTEM_ALERT_LOW: int
ACC_STATE_SYSTEM_ANIMATED: int
ACC_STATE_SYSTEM_BUSY: int
ACC_STATE_SYSTEM_CHECKED: int
ACC_STATE_SYSTEM_COLLAPSED: int
ACC_STATE_SYSTEM_DEFAULT: int
ACC_STATE_SYSTEM_EXPANDED: int
ACC_STATE_SYSTEM_EXTSELECTABLE: int
ACC_STATE_SYSTEM_FLOATING: int
ACC_STATE_SYSTEM_FOCUSABLE: int
ACC_STATE_SYSTEM_FOCUSED: int
ACC_STATE_SYSTEM_HOTTRACKED: int
ACC_STATE_SYSTEM_INVISIBLE: int
ACC_STATE_SYSTEM_MARQUEED: int
ACC_STATE_SYSTEM_MIXED: int
ACC_STATE_SYSTEM_MULTISELECTABLE: int
ACC_STATE_SYSTEM_OFFSCREEN: int
ACC_STATE_SYSTEM_PRESSED: int
ACC_STATE_SYSTEM_PROTECTED: int
ACC_STATE_SYSTEM_READONLY: int
ACC_STATE_SYSTEM_SELECTABLE: int
ACC_STATE_SYSTEM_SELECTED: int
ACC_STATE_SYSTEM_SELFVOICING: int
ACC_STATE_SYSTEM_UNAVAILABLE: int
ACC_EVENT_SYSTEM_SOUND: int
ACC_EVENT_SYSTEM_ALERT: int
ACC_EVENT_SYSTEM_FOREGROUND: int
ACC_EVENT_SYSTEM_MENUSTART: int
ACC_EVENT_SYSTEM_MENUEND: int
ACC_EVENT_SYSTEM_MENUPOPUPSTART: int
ACC_EVENT_SYSTEM_MENUPOPUPEND: int
ACC_EVENT_SYSTEM_CAPTURESTART: int
ACC_EVENT_SYSTEM_CAPTUREEND: int
ACC_EVENT_SYSTEM_MOVESIZESTART: int
ACC_EVENT_SYSTEM_MOVESIZEEND: int
ACC_EVENT_SYSTEM_CONTEXTHELPSTART: int
ACC_EVENT_SYSTEM_CONTEXTHELPEND: int
ACC_EVENT_SYSTEM_DRAGDROPSTART: int
ACC_EVENT_SYSTEM_DRAGDROPEND: int
ACC_EVENT_SYSTEM_DIALOGSTART: int
ACC_EVENT_SYSTEM_DIALOGEND: int
ACC_EVENT_SYSTEM_SCROLLINGSTART: int
ACC_EVENT_SYSTEM_SCROLLINGEND: int
ACC_EVENT_SYSTEM_SWITCHSTART: int
ACC_EVENT_SYSTEM_SWITCHEND: int
ACC_EVENT_SYSTEM_MINIMIZESTART: int
ACC_EVENT_SYSTEM_MINIMIZEEND: int
ACC_EVENT_OBJECT_CREATE: int
ACC_EVENT_OBJECT_DESTROY: int
ACC_EVENT_OBJECT_SHOW: int
ACC_EVENT_OBJECT_HIDE: int
ACC_EVENT_OBJECT_REORDER: int
ACC_EVENT_OBJECT_FOCUS: int
ACC_EVENT_OBJECT_SELECTION: int
ACC_EVENT_OBJECT_SELECTIONADD: int
ACC_EVENT_OBJECT_SELECTIONREMOVE: int
ACC_EVENT_OBJECT_SELECTIONWITHIN: int
ACC_EVENT_OBJECT_STATECHANGE: int
ACC_EVENT_OBJECT_LOCATIONCHANGE: int
ACC_EVENT_OBJECT_NAMECHANGE: int
ACC_EVENT_OBJECT_DESCRIPTIONCHANGE: int
ACC_EVENT_OBJECT_VALUECHANGE: int
ACC_EVENT_OBJECT_PARENTCHANGE: int
ACC_EVENT_OBJECT_HELPCHANGE: int
ACC_EVENT_OBJECT_DEFACTIONCHANGE: int
ACC_EVENT_OBJECT_ACCELERATORCHANGE: int
ACC_SELF: int

class _AccStatus(IntEnum):
    ACC_FAIL = auto()
    ACC_FALSE = auto()
    ACC_OK = auto()
    ACC_NOT_IMPLEMENTED = auto()
    ACC_NOT_SUPPORTED = auto()
    ACC_INVALID_ARG = auto()
AccStatus: TypeAlias = Union[_AccStatus, int]
ACC_FAIL = _AccStatus.ACC_FAIL
ACC_FALSE = _AccStatus.ACC_FALSE
ACC_OK = _AccStatus.ACC_OK
ACC_NOT_IMPLEMENTED = _AccStatus.ACC_NOT_IMPLEMENTED
ACC_NOT_SUPPORTED = _AccStatus.ACC_NOT_SUPPORTED
ACC_INVALID_ARG = _AccStatus.ACC_INVALID_ARG

class _NavDir(IntEnum):
    NAVDIR_FIRSTCHILD = auto()
    NAVDIR_LASTCHILD = auto()
    NAVDIR_DOWN = auto()
    NAVDIR_LEFT = auto()
    NAVDIR_NEXT = auto()
    NAVDIR_PREVIOUS = auto()
    NAVDIR_RIGHT = auto()
    NAVDIR_UP = auto()
NavDir: TypeAlias = Union[_NavDir, int]
NAVDIR_FIRSTCHILD = _NavDir.NAVDIR_FIRSTCHILD
NAVDIR_LASTCHILD = _NavDir.NAVDIR_LASTCHILD
NAVDIR_DOWN = _NavDir.NAVDIR_DOWN
NAVDIR_LEFT = _NavDir.NAVDIR_LEFT
NAVDIR_NEXT = _NavDir.NAVDIR_NEXT
NAVDIR_PREVIOUS = _NavDir.NAVDIR_PREVIOUS
NAVDIR_RIGHT = _NavDir.NAVDIR_RIGHT
NAVDIR_UP = _NavDir.NAVDIR_UP

class _AccRole(IntEnum):
    ROLE_NONE = auto()
    ROLE_SYSTEM_ALERT = auto()
    ROLE_SYSTEM_ANIMATION = auto()
    ROLE_SYSTEM_APPLICATION = auto()
    ROLE_SYSTEM_BORDER = auto()
    ROLE_SYSTEM_BUTTONDROPDOWN = auto()
    ROLE_SYSTEM_BUTTONDROPDOWNGRID = auto()
    ROLE_SYSTEM_BUTTONMENU = auto()
    ROLE_SYSTEM_CARET = auto()
    ROLE_SYSTEM_CELL = auto()
    ROLE_SYSTEM_CHARACTER = auto()
    ROLE_SYSTEM_CHART = auto()
    ROLE_SYSTEM_CHECKBUTTON = auto()
    ROLE_SYSTEM_CLIENT = auto()
    ROLE_SYSTEM_CLOCK = auto()
    ROLE_SYSTEM_COLUMN = auto()
    ROLE_SYSTEM_COLUMNHEADER = auto()
    ROLE_SYSTEM_COMBOBOX = auto()
    ROLE_SYSTEM_CURSOR = auto()
    ROLE_SYSTEM_DIAGRAM = auto()
    ROLE_SYSTEM_DIAL = auto()
    ROLE_SYSTEM_DIALOG = auto()
    ROLE_SYSTEM_DOCUMENT = auto()
    ROLE_SYSTEM_DROPLIST = auto()
    ROLE_SYSTEM_EQUATION = auto()
    ROLE_SYSTEM_GRAPHIC = auto()
    ROLE_SYSTEM_GRIP = auto()
    ROLE_SYSTEM_GROUPING = auto()
    ROLE_SYSTEM_HELPBALLOON = auto()
    ROLE_SYSTEM_HOTKEYFIELD = auto()
    ROLE_SYSTEM_INDICATOR = auto()
    ROLE_SYSTEM_LINK = auto()
    ROLE_SYSTEM_LIST = auto()
    ROLE_SYSTEM_LISTITEM = auto()
    ROLE_SYSTEM_MENUBAR = auto()
    ROLE_SYSTEM_MENUITEM = auto()
    ROLE_SYSTEM_MENUPOPUP = auto()
    ROLE_SYSTEM_OUTLINE = auto()
    ROLE_SYSTEM_OUTLINEITEM = auto()
    ROLE_SYSTEM_PAGETAB = auto()
    ROLE_SYSTEM_PAGETABLIST = auto()
    ROLE_SYSTEM_PANE = auto()
    ROLE_SYSTEM_PROGRESSBAR = auto()
    ROLE_SYSTEM_PROPERTYPAGE = auto()
    ROLE_SYSTEM_PUSHBUTTON = auto()
    ROLE_SYSTEM_RADIOBUTTON = auto()
    ROLE_SYSTEM_ROW = auto()
    ROLE_SYSTEM_ROWHEADER = auto()
    ROLE_SYSTEM_SCROLLBAR = auto()
    ROLE_SYSTEM_SEPARATOR = auto()
    ROLE_SYSTEM_SLIDER = auto()
    ROLE_SYSTEM_SOUND = auto()
    ROLE_SYSTEM_SPINBUTTON = auto()
    ROLE_SYSTEM_STATICTEXT = auto()
    ROLE_SYSTEM_STATUSBAR = auto()
    ROLE_SYSTEM_TABLE = auto()
    ROLE_SYSTEM_TEXT = auto()
    ROLE_SYSTEM_TITLEBAR = auto()
    ROLE_SYSTEM_TOOLBAR = auto()
    ROLE_SYSTEM_TOOLTIP = auto()
    ROLE_SYSTEM_WHITESPACE = auto()
    ROLE_SYSTEM_WINDOW = auto()
AccRole: TypeAlias = Union[_AccRole, int]
ROLE_NONE = _AccRole.ROLE_NONE
ROLE_SYSTEM_ALERT = _AccRole.ROLE_SYSTEM_ALERT
ROLE_SYSTEM_ANIMATION = _AccRole.ROLE_SYSTEM_ANIMATION
ROLE_SYSTEM_APPLICATION = _AccRole.ROLE_SYSTEM_APPLICATION
ROLE_SYSTEM_BORDER = _AccRole.ROLE_SYSTEM_BORDER
ROLE_SYSTEM_BUTTONDROPDOWN = _AccRole.ROLE_SYSTEM_BUTTONDROPDOWN
ROLE_SYSTEM_BUTTONDROPDOWNGRID = _AccRole.ROLE_SYSTEM_BUTTONDROPDOWNGRID
ROLE_SYSTEM_BUTTONMENU = _AccRole.ROLE_SYSTEM_BUTTONMENU
ROLE_SYSTEM_CARET = _AccRole.ROLE_SYSTEM_CARET
ROLE_SYSTEM_CELL = _AccRole.ROLE_SYSTEM_CELL
ROLE_SYSTEM_CHARACTER = _AccRole.ROLE_SYSTEM_CHARACTER
ROLE_SYSTEM_CHART = _AccRole.ROLE_SYSTEM_CHART
ROLE_SYSTEM_CHECKBUTTON = _AccRole.ROLE_SYSTEM_CHECKBUTTON
ROLE_SYSTEM_CLIENT = _AccRole.ROLE_SYSTEM_CLIENT
ROLE_SYSTEM_CLOCK = _AccRole.ROLE_SYSTEM_CLOCK
ROLE_SYSTEM_COLUMN = _AccRole.ROLE_SYSTEM_COLUMN
ROLE_SYSTEM_COLUMNHEADER = _AccRole.ROLE_SYSTEM_COLUMNHEADER
ROLE_SYSTEM_COMBOBOX = _AccRole.ROLE_SYSTEM_COMBOBOX
ROLE_SYSTEM_CURSOR = _AccRole.ROLE_SYSTEM_CURSOR
ROLE_SYSTEM_DIAGRAM = _AccRole.ROLE_SYSTEM_DIAGRAM
ROLE_SYSTEM_DIAL = _AccRole.ROLE_SYSTEM_DIAL
ROLE_SYSTEM_DIALOG = _AccRole.ROLE_SYSTEM_DIALOG
ROLE_SYSTEM_DOCUMENT = _AccRole.ROLE_SYSTEM_DOCUMENT
ROLE_SYSTEM_DROPLIST = _AccRole.ROLE_SYSTEM_DROPLIST
ROLE_SYSTEM_EQUATION = _AccRole.ROLE_SYSTEM_EQUATION
ROLE_SYSTEM_GRAPHIC = _AccRole.ROLE_SYSTEM_GRAPHIC
ROLE_SYSTEM_GRIP = _AccRole.ROLE_SYSTEM_GRIP
ROLE_SYSTEM_GROUPING = _AccRole.ROLE_SYSTEM_GROUPING
ROLE_SYSTEM_HELPBALLOON = _AccRole.ROLE_SYSTEM_HELPBALLOON
ROLE_SYSTEM_HOTKEYFIELD = _AccRole.ROLE_SYSTEM_HOTKEYFIELD
ROLE_SYSTEM_INDICATOR = _AccRole.ROLE_SYSTEM_INDICATOR
ROLE_SYSTEM_LINK = _AccRole.ROLE_SYSTEM_LINK
ROLE_SYSTEM_LIST = _AccRole.ROLE_SYSTEM_LIST
ROLE_SYSTEM_LISTITEM = _AccRole.ROLE_SYSTEM_LISTITEM
ROLE_SYSTEM_MENUBAR = _AccRole.ROLE_SYSTEM_MENUBAR
ROLE_SYSTEM_MENUITEM = _AccRole.ROLE_SYSTEM_MENUITEM
ROLE_SYSTEM_MENUPOPUP = _AccRole.ROLE_SYSTEM_MENUPOPUP
ROLE_SYSTEM_OUTLINE = _AccRole.ROLE_SYSTEM_OUTLINE
ROLE_SYSTEM_OUTLINEITEM = _AccRole.ROLE_SYSTEM_OUTLINEITEM
ROLE_SYSTEM_PAGETAB = _AccRole.ROLE_SYSTEM_PAGETAB
ROLE_SYSTEM_PAGETABLIST = _AccRole.ROLE_SYSTEM_PAGETABLIST
ROLE_SYSTEM_PANE = _AccRole.ROLE_SYSTEM_PANE
ROLE_SYSTEM_PROGRESSBAR = _AccRole.ROLE_SYSTEM_PROGRESSBAR
ROLE_SYSTEM_PROPERTYPAGE = _AccRole.ROLE_SYSTEM_PROPERTYPAGE
ROLE_SYSTEM_PUSHBUTTON = _AccRole.ROLE_SYSTEM_PUSHBUTTON
ROLE_SYSTEM_RADIOBUTTON = _AccRole.ROLE_SYSTEM_RADIOBUTTON
ROLE_SYSTEM_ROW = _AccRole.ROLE_SYSTEM_ROW
ROLE_SYSTEM_ROWHEADER = _AccRole.ROLE_SYSTEM_ROWHEADER
ROLE_SYSTEM_SCROLLBAR = _AccRole.ROLE_SYSTEM_SCROLLBAR
ROLE_SYSTEM_SEPARATOR = _AccRole.ROLE_SYSTEM_SEPARATOR
ROLE_SYSTEM_SLIDER = _AccRole.ROLE_SYSTEM_SLIDER
ROLE_SYSTEM_SOUND = _AccRole.ROLE_SYSTEM_SOUND
ROLE_SYSTEM_SPINBUTTON = _AccRole.ROLE_SYSTEM_SPINBUTTON
ROLE_SYSTEM_STATICTEXT = _AccRole.ROLE_SYSTEM_STATICTEXT
ROLE_SYSTEM_STATUSBAR = _AccRole.ROLE_SYSTEM_STATUSBAR
ROLE_SYSTEM_TABLE = _AccRole.ROLE_SYSTEM_TABLE
ROLE_SYSTEM_TEXT = _AccRole.ROLE_SYSTEM_TEXT
ROLE_SYSTEM_TITLEBAR = _AccRole.ROLE_SYSTEM_TITLEBAR
ROLE_SYSTEM_TOOLBAR = _AccRole.ROLE_SYSTEM_TOOLBAR
ROLE_SYSTEM_TOOLTIP = _AccRole.ROLE_SYSTEM_TOOLTIP
ROLE_SYSTEM_WHITESPACE = _AccRole.ROLE_SYSTEM_WHITESPACE
ROLE_SYSTEM_WINDOW = _AccRole.ROLE_SYSTEM_WINDOW

class _AccObject(IntEnum):
    OBJID_WINDOW = auto()
    OBJID_SYSMENU = auto()
    OBJID_TITLEBAR = auto()
    OBJID_MENU = auto()
    OBJID_CLIENT = auto()
    OBJID_VSCROLL = auto()
    OBJID_HSCROLL = auto()
    OBJID_SIZEGRIP = auto()
    OBJID_CARET = auto()
    OBJID_CURSOR = auto()
    OBJID_ALERT = auto()
    OBJID_SOUND = auto()
AccObject: TypeAlias = Union[_AccObject, int]
OBJID_WINDOW = _AccObject.OBJID_WINDOW
OBJID_SYSMENU = _AccObject.OBJID_SYSMENU
OBJID_TITLEBAR = _AccObject.OBJID_TITLEBAR
OBJID_MENU = _AccObject.OBJID_MENU
OBJID_CLIENT = _AccObject.OBJID_CLIENT
OBJID_VSCROLL = _AccObject.OBJID_VSCROLL
OBJID_HSCROLL = _AccObject.OBJID_HSCROLL
OBJID_SIZEGRIP = _AccObject.OBJID_SIZEGRIP
OBJID_CARET = _AccObject.OBJID_CARET
OBJID_CURSOR = _AccObject.OBJID_CURSOR
OBJID_ALERT = _AccObject.OBJID_ALERT
OBJID_SOUND = _AccObject.OBJID_SOUND

class _AccSelectionFlags(IntFlag):
    ACC_SEL_NONE = auto()
    ACC_SEL_TAKEFOCUS = auto()
    ACC_SEL_TAKESELECTION = auto()
    ACC_SEL_EXTENDSELECTION = auto()
    ACC_SEL_ADDSELECTION = auto()
    ACC_SEL_REMOVESELECTION = auto()
AccSelectionFlags: TypeAlias = Union[_AccSelectionFlags, int]
ACC_SEL_NONE = _AccSelectionFlags.ACC_SEL_NONE
ACC_SEL_TAKEFOCUS = _AccSelectionFlags.ACC_SEL_TAKEFOCUS
ACC_SEL_TAKESELECTION = _AccSelectionFlags.ACC_SEL_TAKESELECTION
ACC_SEL_EXTENDSELECTION = _AccSelectionFlags.ACC_SEL_EXTENDSELECTION
ACC_SEL_ADDSELECTION = _AccSelectionFlags.ACC_SEL_ADDSELECTION
ACC_SEL_REMOVESELECTION = _AccSelectionFlags.ACC_SEL_REMOVESELECTION

class Accessible(Object):
    """
    Accessible(win=None) -> None
    
    The wxAccessible class allows wxWidgets applications, and wxWidgets
    itself, to return extended information about user interface elements
    to client applications such as screen readers.
    """

    def __init__(self, win: Optional[Window]=None) -> None:
        """
        Accessible(win=None) -> None
        
        The wxAccessible class allows wxWidgets applications, and wxWidgets
        itself, to return extended information about user interface elements
        to client applications such as screen readers.
        """

    def DoDefaultAction(self, childId: int) -> AccStatus:
        """
        DoDefaultAction(childId) -> AccStatus
        
        Performs the default action for the object.
        """

    def GetChild(self, childId: int) -> Tuple[AccStatus, Accessible]:
        """
        GetChild(childId) -> Tuple[AccStatus, Accessible]
        
        Gets the specified child (starting from 1).
        """

    def GetChildCount(self) -> Tuple[AccStatus, int]:
        """
        GetChildCount() -> Tuple[AccStatus, int]
        
        Returns the number of children in childCount.
        """

    def GetDefaultAction(self, childId: int) -> Tuple[AccStatus, str]:
        """
        GetDefaultAction(childId) -> Tuple[AccStatus, str]
        
        Gets the default action for this object (0) or a child (greater than
        0).
        """

    def GetDescription(self, childId: int) -> Tuple[AccStatus, str]:
        """
        GetDescription(childId) -> Tuple[AccStatus, str]
        
        Returns the description for this object or a child.
        """

    def GetFocus(self, childId: int) -> Tuple[AccStatus, Accessible]:
        """
        GetFocus(childId) -> Tuple[AccStatus, Accessible]
        
        Gets the window with the keyboard focus.
        """

    def GetHelpText(self, childId: int) -> Tuple[AccStatus, str]:
        """
        GetHelpText(childId) -> Tuple[AccStatus, str]
        
        Returns help text for this object or a child, similar to tooltip text.
        """

    def GetKeyboardShortcut(self, childId: int) -> Tuple[AccStatus, str]:
        """
        GetKeyboardShortcut(childId) -> Tuple[AccStatus, str]
        
        Returns the keyboard shortcut for this object or child.
        """

    def GetLocation(self, elementId: int) -> Tuple[AccStatus, Rect]:
        """
        GetLocation(elementId) -> Tuple[AccStatus, Rect]
        
        Returns the rectangle for this object (id is 0) or a child element (id
        is greater than 0).
        """

    def GetName(self, childId: int) -> Tuple[AccStatus, str]:
        """
        GetName(childId) -> Tuple[AccStatus, str]
        
        Gets the name of the specified object.
        """

    def GetParent(self) -> Tuple[AccStatus, Accessible]:
        """
        GetParent() -> Tuple[AccStatus, Accessible]
        
        Returns the parent of this object, or NULL.
        """

    def GetRole(self, childId: int) -> Tuple[AccStatus, AccRole]:
        """
        GetRole(childId) -> Tuple[AccStatus, AccRole]
        
        Returns a role constant describing this object.
        """

    def GetSelections(self) -> Tuple[AccStatus, Variant]:
        """
        GetSelections() -> Tuple[AccStatus, Variant]
        
        Gets a variant representing the selected children of this object.
        """

    def GetState(self, childId: int) -> Tuple[AccStatus, int]:
        """
        GetState(childId) -> Tuple[AccStatus, int]
        
        Returns a state constant.
        """

    def GetValue(self, childId: int) -> Tuple[AccStatus, str]:
        """
        GetValue(childId) -> Tuple[AccStatus, str]
        
        Returns a localized string representing the value for the object or
        child.
        """

    def GetWindow(self) -> Window:
        """
        GetWindow() -> Window
        
        Returns the window associated with this object.
        """

    def HitTest(self, pt: Point, childId: int, childObject: Accessible) -> AccStatus:
        """
        HitTest(pt, childId, childObject) -> AccStatus
        
        Returns a status value and object id to indicate whether the given
        point was on this or a child object.
        """

    def Navigate(self, navDir: NavDir, fromId: int, toId: int, toObject: Accessible) -> AccStatus:
        """
        Navigate(navDir, fromId, toId, toObject) -> AccStatus
        
        Navigates from fromId to toId or to toObject.
        """

    def Select(self, childId: int, selectFlags: AccSelectionFlags) -> AccStatus:
        """
        Select(childId, selectFlags) -> AccStatus
        
        Selects the object or child.
        """

    def SetWindow(self, window: Window) -> None:
        """
        SetWindow(window) -> None
        
        Sets the window associated with this object.
        """

    @staticmethod
    def NotifyEvent(eventType: int, window: Window, objectType: AccObject, objectId: int) -> None:
        """
        NotifyEvent(eventType, window, objectType, objectId) -> None
        
        Allows the application to send an event when something changes in an
        accessible object.
        """
    @property
    def Window(self) -> Window: ...
    @Window.setter
    def Window(self, value: Window, /) -> None: ...
# end of class Accessible

USE_ACCESSIBILITY: int
#-- end-access --#
#-- begin-accel --#

class _AcceleratorEntryFlags(IntFlag):
    ACCEL_NORMAL = auto()
    ACCEL_ALT = auto()
    ACCEL_CTRL = auto()
    ACCEL_SHIFT = auto()
    ACCEL_RAW_CTRL = auto()
    ACCEL_CMD = auto()
AcceleratorEntryFlags: TypeAlias = Union[_AcceleratorEntryFlags, int]
ACCEL_NORMAL = _AcceleratorEntryFlags.ACCEL_NORMAL
ACCEL_ALT = _AcceleratorEntryFlags.ACCEL_ALT
ACCEL_CTRL = _AcceleratorEntryFlags.ACCEL_CTRL
ACCEL_SHIFT = _AcceleratorEntryFlags.ACCEL_SHIFT
ACCEL_RAW_CTRL = _AcceleratorEntryFlags.ACCEL_RAW_CTRL
ACCEL_CMD = _AcceleratorEntryFlags.ACCEL_CMD

class AcceleratorEntry:
    """
    AcceleratorEntry(flags=0, keyCode=0, cmd=0, item=None) -> None
    AcceleratorEntry(entry) -> None
    
    An object used by an application wishing to create an accelerator
    table (see wxAcceleratorTable).
    """

    @overload
    def __init__(self, entry: AcceleratorEntry) -> None:
        ...

    @overload
    def __init__(self, flags: int=0, keyCode: int=0, cmd: int=0, item: Optional[MenuItem]=None) -> None:
        """
        AcceleratorEntry(flags=0, keyCode=0, cmd=0, item=None) -> None
        AcceleratorEntry(entry) -> None
        
        An object used by an application wishing to create an accelerator
        table (see wxAcceleratorTable).
        """

    def GetCommand(self) -> int:
        """
        GetCommand() -> int
        
        Returns the command identifier for the accelerator table entry.
        """

    def GetFlags(self) -> int:
        """
        GetFlags() -> int
        
        Returns the flags for the accelerator table entry.
        """

    def GetKeyCode(self) -> int:
        """
        GetKeyCode() -> int
        
        Returns the keycode for the accelerator table entry.
        """

    def GetMenuItem(self) -> MenuItem:
        """
        GetMenuItem() -> MenuItem
        
        Returns the menu item associated with this accelerator entry.
        """

    def Set(self, flags: int, keyCode: int, cmd: int, item: Optional[MenuItem]=None) -> None:
        """
        Set(flags, keyCode, cmd, item=None) -> None
        
        Sets the accelerator entry parameters.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if this object is correctly initialized.
        """

    def ToString(self) -> str:
        """
        ToString() -> str
        
        Returns a textual representation of this accelerator.
        """

    def ToRawString(self) -> str:
        """
        ToRawString() -> str
        
        Returns a textual representation of this accelerator which is
        appropriate for saving in configuration files.
        """

    def FromString(self, str: str) -> bool:
        """
        FromString(str) -> bool
        
        Parses the given string and sets the accelerator accordingly.
        """

    def __eq__(self, entry: AcceleratorEntry) -> bool:
        """
        """

    def __ne__(self, entry: AcceleratorEntry) -> bool:
        """
        """
    @property
    def Command(self) -> int: ...
    @property
    def Flags(self) -> int: ...
    @property
    def KeyCode(self) -> int: ...
    @property
    def MenuItem(self) -> MenuItem: ...
# end of class AcceleratorEntry


class AcceleratorTable(Object):
    """
    AcceleratorTable() -> None
    AcceleratorTable(entries) -> None
    
    An accelerator table allows the application to specify a table of
    keyboard shortcuts for menu or button commands.
    """

    @overload
    def __init__(self, entries: Any) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        AcceleratorTable() -> None
        AcceleratorTable(entries) -> None
        
        An accelerator table allows the application to specify a table of
        keyboard shortcuts for menu or button commands.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Returns true if the accelerator table is valid.
        """
# end of class AcceleratorTable

NullAcceleratorTable: AcceleratorTable

@wx.deprecated
def GetAccelFromString(label):
    pass
#-- end-accel --#
#-- begin-log --#

class _LogLevelValues(IntEnum):
    LOG_FatalError = auto()
    LOG_Error = auto()
    LOG_Warning = auto()
    LOG_Message = auto()
    LOG_Status = auto()
    LOG_Info = auto()
    LOG_Debug = auto()
    LOG_Trace = auto()
    LOG_Progress = auto()
    LOG_User = auto()
    LOG_Max = auto()
LogLevelValues: TypeAlias = Union[_LogLevelValues, int]
LOG_FatalError = _LogLevelValues.LOG_FatalError
LOG_Error = _LogLevelValues.LOG_Error
LOG_Warning = _LogLevelValues.LOG_Warning
LOG_Message = _LogLevelValues.LOG_Message
LOG_Status = _LogLevelValues.LOG_Status
LOG_Info = _LogLevelValues.LOG_Info
LOG_Debug = _LogLevelValues.LOG_Debug
LOG_Trace = _LogLevelValues.LOG_Trace
LOG_Progress = _LogLevelValues.LOG_Progress
LOG_User = _LogLevelValues.LOG_User
LOG_Max = _LogLevelValues.LOG_Max

class Log:
    """
    wxLog class defines the interface for the log targets used by
    wxWidgets logging functions as explained in the Logging Overview.
    """

    @staticmethod
    def AddTraceMask(mask: str) -> None:
        """
        AddTraceMask(mask) -> None
        
        Add the mask to the list of allowed masks for wxLogTrace().
        """

    @staticmethod
    def ClearTraceMasks() -> None:
        """
        ClearTraceMasks() -> None
        
        Removes all trace masks previously set with AddTraceMask().
        """

    @staticmethod
    def GetTraceMasks() -> List[str]:
        """
        GetTraceMasks() -> List[str]
        
        Returns the currently allowed list of string trace masks.
        """

    @staticmethod
    def IsAllowedTraceMask(mask: str) -> bool:
        """
        IsAllowedTraceMask(mask) -> bool
        
        Returns true if the mask is one of allowed masks for wxLogTrace().
        """

    @staticmethod
    def RemoveTraceMask(mask: str) -> None:
        """
        RemoveTraceMask(mask) -> None
        
        Remove the mask from the list of allowed masks for wxLogTrace().
        """

    @staticmethod
    def DontCreateOnDemand() -> None:
        """
        DontCreateOnDemand() -> None
        
        Instructs wxLog to not create new log targets on the fly if there is
        none currently (see GetActiveTarget()).
        """

    @staticmethod
    def GetActiveTarget() -> Log:
        """
        GetActiveTarget() -> Log
        
        Returns the pointer to the active log target (may be NULL).
        """

    @staticmethod
    def SetActiveTarget(logtarget: Log) -> Log:
        """
        SetActiveTarget(logtarget) -> Log
        
        Sets the specified log target as the active one.
        """

    @staticmethod
    def SetThreadActiveTarget(logger: Log) -> Log:
        """
        SetThreadActiveTarget(logger) -> Log
        
        Sets a thread-specific log target.
        """

    @staticmethod
    def FlushActive() -> None:
        """
        FlushActive() -> None
        
        Flushes the current log target if any, does nothing if there is none.
        """

    @staticmethod
    def Resume() -> None:
        """
        Resume() -> None
        
        Resumes logging previously suspended by a call to Suspend().
        """

    @staticmethod
    def Suspend() -> None:
        """
        Suspend() -> None
        
        Suspends the logging until Resume() is called.
        """

    @staticmethod
    def GetLogLevel() -> LogLevel:
        """
        GetLogLevel() -> LogLevel
        
        Returns the current log level limit.
        """

    @staticmethod
    def IsLevelEnabled(level: LogLevel, component: str) -> bool:
        """
        IsLevelEnabled(level, component) -> bool
        
        Returns true if logging at this level is enabled for the current
        thread.
        """

    @staticmethod
    def SetComponentLevel(component: str, level: LogLevel) -> None:
        """
        SetComponentLevel(component, level) -> None
        
        Sets the log level for the given component.
        """

    @staticmethod
    def SetLogLevel(logLevel: LogLevel) -> None:
        """
        SetLogLevel(logLevel) -> None
        
        Specifies that log messages with level greater (numerically) than
        logLevel should be ignored and not sent to the active log target.
        """

    @staticmethod
    def EnableLogging(enable: bool=True) -> bool:
        """
        EnableLogging(enable=True) -> bool
        
        Globally enable or disable logging.
        """

    @staticmethod
    def IsEnabled() -> bool:
        """
        IsEnabled() -> bool
        
        Returns true if logging is enabled at all now.
        """

    @staticmethod
    def GetRepetitionCounting() -> bool:
        """
        GetRepetitionCounting() -> bool
        
        Returns whether the repetition counting mode is enabled.
        """

    @staticmethod
    def SetRepetitionCounting(repetCounting: bool=True) -> None:
        """
        SetRepetitionCounting(repetCounting=True) -> None
        
        Enables logging mode in which a log message is logged once, and in
        case exactly the same message successively repeats one or more times,
        only the number of repetitions is logged.
        """

    @staticmethod
    def GetTimestamp() -> str:
        """
        GetTimestamp() -> str
        
        Returns the current timestamp format string.
        """

    @staticmethod
    def SetTimestamp(format: str) -> None:
        """
        SetTimestamp(format) -> None
        
        Sets the timestamp format prepended by the default log targets to all
        messages.
        """

    @staticmethod
    def DisableTimestamp() -> None:
        """
        DisableTimestamp() -> None
        
        Disables time stamping of the log messages.
        """

    @staticmethod
    def GetVerbose() -> bool:
        """
        GetVerbose() -> bool
        
        Returns whether the verbose mode is currently active.
        """

    @staticmethod
    def SetVerbose(verbose: bool=True) -> None:
        """
        SetVerbose(verbose=True) -> None
        
        Activates or deactivates verbose mode in which the verbose messages
        are logged as the normal ones instead of being silently dropped.
        """

    def SetFormatter(self, formatter: LogFormatter) -> LogFormatter:
        """
        SetFormatter(formatter) -> LogFormatter
        
        Sets the specified formatter as the active one.
        """

    def Flush(self) -> None:
        """
        Flush() -> None
        
        Show all pending output and clear the buffer.
        """

    def LogRecord(self, level: LogLevel, msg: str, info: LogRecordInfo) -> None:
        """
        LogRecord(level, msg, info) -> None
        
        Log the given record.
        """

    def DoLogRecord(self, level: LogLevel, msg: str, info: LogRecordInfo) -> None:
        """
        DoLogRecord(level, msg, info) -> None
        
        Called to log a new record.
        """

    def DoLogTextAtLevel(self, level: LogLevel, msg: str) -> None:
        """
        DoLogTextAtLevel(level, msg) -> None
        
        Called to log the specified string at given level.
        """

    def DoLogText(self, msg: str) -> None:
        """
        DoLogText(msg) -> None
        
        Called to log the specified string.
        """
# end of class Log


class LogGui(Log):
    """
    LogGui() -> None
    
    This is the default log target for the GUI wxWidgets applications.
    """

    def __init__(self) -> None:
        """
        LogGui() -> None
        
        This is the default log target for the GUI wxWidgets applications.
        """

    def Flush(self) -> None:
        """
        Flush() -> None
        
        Presents the accumulated log messages, if any, to the user.
        """
# end of class LogGui


class LogNull:
    """
    LogNull() -> None
    
    This class allows you to temporarily suspend logging.
    """

    def __init__(self) -> None:
        """
        LogNull() -> None
        
        This class allows you to temporarily suspend logging.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class LogNull


class LogRecordInfo:
    """
    Information about a log record (unit of the log output).
    """
    filename: str
    line: int
    func: str
    timestampMS: LongLong_t
    timestamp: int
# end of class LogRecordInfo


class LogChain(Log):
    """
    LogChain(logger) -> None
    
    This simple class allows you to chain log sinks, that is to install a
    new sink but keep passing log messages to the old one instead of
    replacing it completely as wxLog::SetActiveTarget does.
    """

    def __init__(self, logger: Log) -> None:
        """
        LogChain(logger) -> None
        
        This simple class allows you to chain log sinks, that is to install a
        new sink but keep passing log messages to the old one instead of
        replacing it completely as wxLog::SetActiveTarget does.
        """

    def DetachOldLog(self) -> None:
        """
        DetachOldLog() -> None
        
        Detaches the old log target so it won't be destroyed when the
        wxLogChain object is destroyed.
        """

    def GetOldLog(self) -> Log:
        """
        GetOldLog() -> Log
        
        Returns the pointer to the previously active log target (which may be
        NULL).
        """

    def IsPassingMessages(self) -> bool:
        """
        IsPassingMessages() -> bool
        
        Returns true if the messages are passed to the previously active log
        target (default) or false if PassMessages() had been called.
        """

    def PassMessages(self, passMessages: bool) -> None:
        """
        PassMessages(passMessages) -> None
        
        By default, the log messages are passed to the previously active log
        target.
        """

    def SetLog(self, logger: Log) -> None:
        """
        SetLog(logger) -> None
        
        Sets another log target to use (may be NULL).
        """
    @property
    def OldLog(self) -> Log: ...
# end of class LogChain


class LogInterposer(LogChain):
    """
    LogInterposer() -> None
    
    A special version of wxLogChain which uses itself as the new log
    target.
    """

    def __init__(self) -> None:
        """
        LogInterposer() -> None
        
        A special version of wxLogChain which uses itself as the new log
        target.
        """
# end of class LogInterposer


class LogInterposerTemp(LogChain):
    """
    LogInterposerTemp() -> None
    
    Legacy class which should not be used any longer.
    """

    def __init__(self) -> None:
        """
        LogInterposerTemp() -> None
        
        Legacy class which should not be used any longer.
        """
# end of class LogInterposerTemp


class LogWindow(LogInterposer):
    """
    LogWindow(pParent, szTitle, show=True, passToOld=True) -> None
    
    This class represents a background log window: to be precise, it
    collects all log messages in the log frame which it manages but also
    passes them on to the log target which was active at the moment of its
    creation.
    """

    def __init__(self, pParent: Window, szTitle: str, show: bool=True, passToOld: bool=True) -> None:
        """
        LogWindow(pParent, szTitle, show=True, passToOld=True) -> None
        
        This class represents a background log window: to be precise, it
        collects all log messages in the log frame which it manages but also
        passes them on to the log target which was active at the moment of its
        creation.
        """

    def GetFrame(self) -> Frame:
        """
        GetFrame() -> Frame
        
        Returns the associated log frame window.
        """

    def OnFrameClose(self, frame: Frame) -> bool:
        """
        OnFrameClose(frame) -> bool
        
        Called if the user closes the window interactively, will not be called
        if it is destroyed for another reason (such as when program exits).
        """

    def OnFrameDelete(self, frame: Frame) -> None:
        """
        OnFrameDelete(frame) -> None
        
        Called right before the log frame is going to be deleted: will always
        be called unlike OnFrameClose().
        """

    def Show(self, show: bool=True) -> None:
        """
        Show(show=True) -> None
        
        Shows or hides the frame.
        """
    @property
    def Frame(self) -> Frame: ...
# end of class LogWindow


class LogStderr(Log):
    """
    LogStderr() -> None
    
    This class can be used to redirect the log messages to a C file stream
    (not to be confused with C++ streams).
    """

    def __init__(self) -> None:
        """
        LogStderr() -> None
        
        This class can be used to redirect the log messages to a C file stream
        (not to be confused with C++ streams).
        """
# end of class LogStderr


class LogBuffer(Log):
    """
    LogBuffer() -> None
    
    wxLogBuffer is a very simple implementation of log sink which simply
    collects all the logged messages in a string (except the debug
    messages which are output in the usual way immediately as we're
    presumably not interested in collecting them for later).
    """

    def __init__(self) -> None:
        """
        LogBuffer() -> None
        
        wxLogBuffer is a very simple implementation of log sink which simply
        collects all the logged messages in a string (except the debug
        messages which are output in the usual way immediately as we're
        presumably not interested in collecting them for later).
        """

    def Flush(self) -> None:
        """
        Flush() -> None
        
        Shows all the messages collected so far to the user (using a message
        box in the GUI applications or by printing them out to the console in
        text mode) and clears the internal buffer.
        """

    def GetBuffer(self) -> str:
        """
        GetBuffer() -> str
        
        Returns the current buffer contains.
        """
    @property
    def Buffer(self) -> str: ...
# end of class LogBuffer


class LogTextCtrl(Log):
    """
    LogTextCtrl(pTextCtrl) -> None
    
    Using these target all the log messages can be redirected to a text
    control.
    """

    def __init__(self, pTextCtrl: TextCtrl) -> None:
        """
        LogTextCtrl(pTextCtrl) -> None
        
        Using these target all the log messages can be redirected to a text
        control.
        """
# end of class LogTextCtrl


class LogFormatter:
    """
    LogFormatter() -> None
    
    wxLogFormatter class is used to format the log messages.
    """

    def __init__(self) -> None:
        """
        LogFormatter() -> None
        
        wxLogFormatter class is used to format the log messages.
        """

    def Format(self, level: LogLevel, msg: str, info: LogRecordInfo) -> str:
        """
        Format(level, msg, info) -> str
        
        This function creates the full log message string.
        """

    def FormatTime(self, time: int) -> str:
        """
        FormatTime(time) -> str
        
        This function formats the time stamp part of the log message.
        """
# end of class LogFormatter


def SafeShowMessage(title: str, text: str) -> bool:    """
    SafeShowMessage(title, text) -> bool
    
    This function shows a message to the user in a safe way and should be
    safe to call even before the application has been initialized or if it
    is currently in some other strange state (for example, about to
    crash).
    """

def SysErrorCode() -> int:    """
    SysErrorCode() -> int
    
    Returns the error code from the last system call.
    """

def SysErrorMsgStr(errCode: int=0) -> str:    """
    SysErrorMsgStr(errCode=0) -> str
    
    Returns the error message corresponding to the given system error
    code.
    """

def SysErrorMsg(errCode: int=0) -> str:    """
    SysErrorMsg(errCode=0) -> str
    
    Returns the error message corresponding to the given system error
    code.
    """

def LogGeneric(level: LogLevel, message: str) -> None:    """
    LogGeneric(level, message) -> None
    
    Logs a message with the given wxLogLevel.
    """

def LogMessage(message: str) -> None:    """
    LogMessage(message) -> None
    
    For all normal, informational messages.
    """

def LogInfo(formatString: str, *args) -> None:    """
    LogInfo(formatString, *args) -> None
    
    For low priority messages.
    """

def LogVerbose(message: str) -> None:    """
    LogVerbose(message) -> None
    
    For verbose output.
    """

def LogWarning(message: str) -> None:    """
    LogWarning(message) -> None
    
    For warnings - they are also normally shown to the user, but don't
    interrupt the program work.
    """

def LogFatalError(message: str) -> None:    """
    LogFatalError(message) -> None
    
    Like wxLogError(), but also terminates the program with the exit code
    3.
    """

def LogError(message: str) -> None:    """
    LogError(message) -> None
    
    The functions to use for error messages, i.e.
    """

def LogDebug(message: str) -> None:    """
    LogDebug(message) -> None
    
    The right functions for debug output.
    """

@overload
def LogStatus(message: str) -> None:    ...

@overload
def LogStatus(frame: Frame, message: str) -> None:    """
    LogStatus(frame, message) -> None
    LogStatus(message) -> None
    
    Messages logged by this function will appear in the statusbar of the
    frame or of the top level application window by default (i.e.
    """

def LogSysError(message: str) -> None:    """
    LogSysError(message) -> None
    
    Mostly used by wxWidgets itself, but might be handy for logging errors
    after system call (API function) failure.
    """
#-- end-log --#
#-- begin-dataobj --#

class DataFormat:
    """
    DataFormat(format=DF_INVALID) -> None
    DataFormat(format) -> None
    
    A wxDataFormat is an encapsulation of a platform-specific format
    handle which is used by the system for the clipboard and drag and drop
    operations.
    """

    @overload
    def __init__(self, format: str) -> None:
        ...

    @overload
    def __init__(self, format: DataFormatId=DF_INVALID) -> None:
        """
        DataFormat(format=DF_INVALID) -> None
        DataFormat(format) -> None
        
        A wxDataFormat is an encapsulation of a platform-specific format
        handle which is used by the system for the clipboard and drag and drop
        operations.
        """

    def GetId(self) -> str:
        """
        GetId() -> str
        
        Returns the name of a custom format (this function will fail for a
        standard format).
        """

    def GetType(self) -> DataFormatId:
        """
        GetType() -> DataFormatId
        
        Returns the platform-specific number identifying the format.
        """

    def SetId(self, format: str) -> None:
        """
        SetId(format) -> None
        
        Sets the format to be the custom format identified by the given name.
        """

    def SetType(self, type: DataFormatId) -> None:
        """
        SetType(type) -> None
        
        Sets the format to the given value, which should be one of wxDF_XXX
        constants.
        """

    @overload
    def __ne__(self, format: DataFormatId) -> bool:
        ...

    @overload
    def __ne__(self, format: DataFormat) -> bool:
        """
        """

    @overload
    def __eq__(self, format: DataFormatId) -> bool:
        ...

    @overload
    def __eq__(self, format: DataFormat) -> bool:
        """
        """
    @property
    def Id(self) -> str: ...
    @Id.setter
    def Id(self, value: str, /) -> None: ...
    @property
    def Type(self) -> DataFormatId: ...
    @Type.setter
    def Type(self, value: DataFormatId, /) -> None: ...
# end of class DataFormat

FormatInvalid: DataFormat

class DataObject:
    """
    DataObject() -> None
    
    A wxDataObject represents data that can be copied to or from the
    clipboard, or dragged and dropped.
    """

    class _Direction(IntEnum):
        Get = auto()
        Set = auto()
        Both = auto()
    Direction: TypeAlias = Union[_Direction, int]
    Get = _Direction.Get
    Set = _Direction.Set
    Both = _Direction.Both

    def __init__(self) -> None:
        """
        DataObject() -> None
        
        A wxDataObject represents data that can be copied to or from the
        clipboard, or dragged and dropped.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """

    def GetDataHere(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        GetDataHere(format, buf) -> bool
        
        Copies this data object's data in the requested format to the buffer
        provided.
        """

    def GetDataSize(self, format: DataFormat) -> int:
        """
        GetDataSize(format) -> int
        
        Returns the data size of the given format format.
        """

    def GetFormatCount(self, dir: Direction=Get) -> int:
        """
        GetFormatCount(dir=Get) -> int
        
        Returns the number of available formats for rendering or setting the
        data.
        """

    def GetPreferredFormat(self, dir: Direction=Get) -> DataFormat:
        """
        GetPreferredFormat(dir=Get) -> DataFormat
        
        Returns the preferred format for either rendering the data (if dir is
        Get, its default value) or for setting it.
        """

    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        SetData(format, buf) -> bool
        
        Copies data from the provided buffer to this data object for the
        specified format.
        """

    def IsSupported(self, format: DataFormat, dir: Direction=Get) -> bool:
        """
        IsSupported(format, dir=Get) -> bool
        
        Returns true if this format is supported.
        """

    def _testGetAllFormats(self) -> None:
        """
        _testGetAllFormats() -> None
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def DataHere(self) -> bool: ...
    @property
    def FormatCount(self) -> int: ...
    @property
    def PreferredFormat(self) -> DataFormat: ...
# end of class DataObject


class DataObjectSimple(DataObject):
    """
    DataObjectSimple(format=FormatInvalid) -> None
    DataObjectSimple(formatName) -> None
    
    This is the simplest possible implementation of the wxDataObject
    class.
    """

    @overload
    def __init__(self, formatName: str) -> None:
        ...

    @overload
    def __init__(self, format: DataFormat=FormatInvalid) -> None:
        """
        DataObjectSimple(format=FormatInvalid) -> None
        DataObjectSimple(formatName) -> None
        
        This is the simplest possible implementation of the wxDataObject
        class.
        """

    def GetDataHere(self, buf: PyBuffer) -> bool:
        """
        GetDataHere(buf) -> bool
        
        Copies this data object's data bytes to the given buffer
        """

    def GetDataSize(self) -> int:
        """
        GetDataSize() -> int
        
        Gets the size of our data.
        """

    def GetFormat(self) -> DataFormat:
        """
        GetFormat() -> DataFormat
        
        Returns the (one and only one) format supported by this object.
        """

    @overload
    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        ...

    @overload
    def SetData(self, buf: PyBuffer) -> bool:
        """
        SetData(buf) -> bool
        SetData(format, buf) -> bool
        
        Copies data from the provided buffer to this data object.
        """

    def SetFormat(self, format: DataFormat) -> None:
        """
        SetFormat(format) -> None
        
        Sets the supported format.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def DataHere(self) -> bool: ...
    @property
    def DataSize(self) -> int: ...
    @property
    def Format(self) -> DataFormat: ...
    @Format.setter
    def Format(self, value: DataFormat, /) -> None: ...
# end of class DataObjectSimple


class CustomDataObject(DataObjectSimple):
    """
    CustomDataObject(format=FormatInvalid) -> None
    CustomDataObject(formatName) -> None
    
    wxCustomDataObject is a specialization of wxDataObjectSimple for some
    application-specific data in arbitrary (either custom or one of the
    standard ones).
    """

    @overload
    def __init__(self, formatName: str) -> None:
        ...

    @overload
    def __init__(self, format: DataFormat=FormatInvalid) -> None:
        """
        CustomDataObject(format=FormatInvalid) -> None
        CustomDataObject(formatName) -> None
        
        wxCustomDataObject is a specialization of wxDataObjectSimple for some
        application-specific data in arbitrary (either custom or one of the
        standard ones).
        """

    def GetData(self) -> Any:
        """
        GetData() -> Any
        
        Returns a reference to the data buffer.
        """

    def GetSize(self) -> int:
        """
        GetSize() -> int
        
        Returns the data size in bytes.
        """

    @overload
    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        ...

    @overload
    def SetData(self, buf: PyBuffer) -> bool:
        """
        SetData(buf) -> bool
        SetData(format, buf) -> bool
        
        Copies data from the provided buffer to this data object's buffer
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def Data(self) -> PyBuffer: ...
    @Data.setter
    def Data(self, value: PyBuffer, /) -> None: ...
    @property
    def Size(self) -> int: ...
# end of class CustomDataObject


class DataObjectComposite(DataObject):
    """
    DataObjectComposite() -> None
    
    wxDataObjectComposite is the simplest wxDataObject derivation which
    may be used to support multiple formats.
    """

    def __init__(self) -> None:
        """
        DataObjectComposite() -> None
        
        wxDataObjectComposite is the simplest wxDataObject derivation which
        may be used to support multiple formats.
        """

    def Add(self, dataObject: DataObjectSimple, preferred: bool=False) -> None:
        """
        Add(dataObject, preferred=False) -> None
        
        Adds the dataObject to the list of supported objects and it becomes the preferred object if preferred is true.
        """

    def GetReceivedFormat(self) -> DataFormat:
        """
        GetReceivedFormat() -> DataFormat
        
        Report the format passed to the SetData() method.
        """

    def GetObject(self, format: DataFormat, dir: DataObject.Direction=DataObject.Get) -> DataObjectSimple:
        """
        GetObject(format, dir=DataObject.Get) -> DataObjectSimple
        
        Returns the pointer to the object which supports the passed format for
        the specified direction.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """

    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        SetData(format, buf) -> bool
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def ReceivedFormat(self) -> DataFormat: ...
# end of class DataObjectComposite


class BitmapDataObject(DataObjectSimple):
    """
    BitmapDataObject(bitmap=NullBitmap) -> None
    
    wxBitmapDataObject is a specialization of wxDataObject for bitmap
    data.
    """

    def __init__(self, bitmap: Bitmap=NullBitmap) -> None:
        """
        BitmapDataObject(bitmap=NullBitmap) -> None
        
        wxBitmapDataObject is a specialization of wxDataObject for bitmap
        data.
        """

    def GetBitmap(self) -> Bitmap:
        """
        GetBitmap() -> Bitmap
        
        Returns the bitmap associated with the data object.
        """

    def SetBitmap(self, bitmap: Bitmap) -> None:
        """
        SetBitmap(bitmap) -> None
        
        Sets the bitmap associated with the data object.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """

    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        SetData(format, buf) -> bool
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def Bitmap(self) -> Bitmap: ...
    @Bitmap.setter
    def Bitmap(self, value: Bitmap, /) -> None: ...
# end of class BitmapDataObject


class TextDataObject(DataObjectSimple):
    """
    TextDataObject(text='') -> None
    
    wxTextDataObject is a specialization of wxDataObjectSimple for text
    data.
    """

    def __init__(self, text: str='') -> None:
        """
        TextDataObject(text='') -> None
        
        wxTextDataObject is a specialization of wxDataObjectSimple for text
        data.
        """

    def GetText(self) -> str:
        """
        GetText() -> str
        
        Returns the text associated with the data object.
        """

    def GetTextLength(self) -> int:
        """
        GetTextLength() -> int
        
        Returns the data size.
        """

    def GetFormatCount(self, dir: DataObject.Direction=DataObject.Get) -> int:
        """
        GetFormatCount(dir=DataObject.Get) -> int
        
        Returns 2 under wxMac and wxGTK, where text data coming from the
        clipboard may be provided as ANSI (wxDF_TEXT) or as Unicode text
        (wxDF_UNICODETEXT, but only when wxUSE_UNICODE==1).
        """

    def GetFormat(self) -> DataFormat:
        """
        GetFormat() -> DataFormat
        
        Returns the preferred format supported by this object.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """

    def SetText(self, strText: str) -> None:
        """
        SetText(strText) -> None
        
        Sets the text associated with the data object.
        """

    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        SetData(format, buf) -> bool
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def Format(self) -> DataFormat: ...
    @property
    def FormatCount(self) -> int: ...
    @property
    def Text(self) -> str: ...
    @Text.setter
    def Text(self, value: str, /) -> None: ...
    @property
    def TextLength(self) -> int: ...
# end of class TextDataObject


class URLDataObject(DataObject):
    """
    URLDataObject(url='') -> None
    
    wxURLDataObject is a wxDataObject containing an URL and can be used
    e.g.
    """

    def __init__(self, url: str='') -> None:
        """
        URLDataObject(url='') -> None
        
        wxURLDataObject is a wxDataObject containing an URL and can be used
        e.g.
        """

    def GetURL(self) -> str:
        """
        GetURL() -> str
        
        Returns the URL stored by this object, as a string.
        """

    def SetURL(self, url: str) -> None:
        """
        SetURL(url) -> None
        
        Sets the URL stored by this object.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """

    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        SetData(format, buf) -> bool
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def URL(self) -> str: ...
    @URL.setter
    def URL(self, value: str, /) -> None: ...
# end of class URLDataObject


class FileDataObject(DataObjectSimple):
    """
    FileDataObject() -> None
    
    wxFileDataObject is a specialization of wxDataObject for file names.
    """

    def __init__(self) -> None:
        """
        FileDataObject() -> None
        
        wxFileDataObject is a specialization of wxDataObject for file names.
        """

    def AddFile(self, file: str) -> None:
        """
        AddFile(file) -> None
        
        Adds a file to the file list represented by this data object (Windows
        only).
        """

    def GetFilenames(self) -> List[str]:
        """
        GetFilenames() -> List[str]
        
        Returns the array of file names.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """

    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        SetData(format, buf) -> bool
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def Filenames(self) -> List[str]: ...
# end of class FileDataObject


class HTMLDataObject(DataObjectSimple):
    """
    HTMLDataObject(html='') -> None
    
    wxHTMLDataObject is used for working with HTML-formatted text.
    """

    def __init__(self, html: str='') -> None:
        """
        HTMLDataObject(html='') -> None
        
        wxHTMLDataObject is used for working with HTML-formatted text.
        """

    def GetHTML(self) -> str:
        """
        GetHTML() -> str
        
        Returns the HTML string.
        """

    def SetHTML(self, html: str) -> None:
        """
        SetHTML(html) -> None
        
        Sets the HTML string.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """

    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        SetData(format, buf) -> bool
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def HTML(self) -> str: ...
    @HTML.setter
    def HTML(self, value: str, /) -> None: ...
# end of class HTMLDataObject


class ImageDataObject(CustomDataObject):
    """
    ImageDataObject(image=NullImage) -> None
    
    wxImageDataObject is a specialization of wxDataObject for image data.
    """

    def __init__(self, image: Image=NullImage) -> None:
        """
        ImageDataObject(image=NullImage) -> None
        
        wxImageDataObject is a specialization of wxDataObject for image data.
        """

    def GetImage(self) -> Image:
        """
        GetImage() -> Image
        
        Returns the image associated with the data object.
        """

    def SetImage(self, image: Image) -> None:
        """
        SetImage(image) -> None
        
        Sets the image stored by the data object.
        """

    def GetAllFormats(self, dir: DataObject.Direction=DataObject.Get) -> Any:
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transferring in the given direction.
        """

    def SetData(self, format: DataFormat, buf: PyBuffer) -> bool:
        """
        SetData(format, buf) -> bool
        """
    @property
    def AllFormats(self) -> Any: ...
    @property
    def Image(self) -> Image: ...
    @Image.setter
    def Image(self, value: Image, /) -> None: ...
# end of class ImageDataObject


def CustomDataFormat(format):
    return wx.DataFormat(format)
CustomDataFormat = wx.deprecated(CustomDataFormat, "Use wx.DataFormat instead.")

PyDataObjectSimple = wx.deprecated(DataObjectSimple), 'Use DataObjectSimple instead.'

PyTextDataObject = wx.deprecated(TextDataObject, 'Use TextDataObject instead.')

PyBitmapDataObject = wx.deprecated(BitmapDataObject, 'Use TextDataObject instead.')
#-- end-dataobj --#
#-- begin-dnd --#

class _enum_(IntEnum):
    Drag_CopyOnly = auto()
    Drag_AllowMove = auto()
    Drag_DefaultMove = auto()
Drag_CopyOnly = _enum_.Drag_CopyOnly
Drag_AllowMove = _enum_.Drag_AllowMove
Drag_DefaultMove = _enum_.Drag_DefaultMove

class _DragResult(IntEnum):
    DragError = auto()
    DragNone = auto()
    DragCopy = auto()
    DragMove = auto()
    DragLink = auto()
    DragCancel = auto()
DragResult: TypeAlias = Union[_DragResult, int]
DragError = _DragResult.DragError
DragNone = _DragResult.DragNone
DragCopy = _DragResult.DragCopy
DragMove = _DragResult.DragMove
DragLink = _DragResult.DragLink
DragCancel = _DragResult.DragCancel

def IsDragResultOk(res: DragResult) -> bool:    """
    IsDragResultOk(res) -> bool
    
    Returns true if res indicates that something was done during a DnD
    operation, i.e.
    """

class DropSource:
    """
    DropSource(win=None) -> None
    DropSource(data, win=None) -> None
    
    This class represents a source for a drag and drop operation.
    """

    @overload
    def __init__(self, data: DataObject, win: Optional[Window]=None) -> None:
        ...

    @overload
    def __init__(self, win: Optional[Window]=None) -> None:
        """
        DropSource(win=None) -> None
        DropSource(data, win=None) -> None
        
        This class represents a source for a drag and drop operation.
        """

    def DoDragDrop(self, flags: int=Drag_CopyOnly) -> DragResult:
        """
        DoDragDrop(flags=Drag_CopyOnly) -> DragResult
        
        Starts the drag-and-drop operation which will terminate when the user
        releases the mouse.
        """

    def GetDataObject(self) -> DataObject:
        """
        GetDataObject() -> DataObject
        
        Returns the wxDataObject object that has been assigned previously.
        """

    def GiveFeedback(self, effect: DragResult) -> bool:
        """
        GiveFeedback(effect) -> bool
        
        You may give some custom UI feedback during the drag and drop
        operation by overriding this function.
        """

    def SetCursor(self, res: DragResult, cursor: Cursor) -> None:
        """
        SetCursor(res, cursor) -> None
        
        Set the icon to use for a certain drag result.
        """

    def SetIcon(self, res: DragResult, icon: Icon) -> None:
        """
        SetIcon(res, icon) -> None
        
        Set the icon to use for a certain drag result.
        """

    def SetData(self, data: DataObject) -> None:
        """
        SetData(data) -> None
        
        Sets the data wxDataObject associated with the drop source.
        """
    @property
    def DataObject(self) -> DataObject: ...
# end of class DropSource


class DropTarget:
    """
    DropTarget(data=None) -> None
    
    This class represents a target for a drag and drop operation.
    """

    def __init__(self, data: Optional[DataObject]=None) -> None:
        """
        DropTarget(data=None) -> None
        
        This class represents a target for a drag and drop operation.
        """

    def GetData(self) -> bool:
        """
        GetData() -> bool
        
        This method may only be called from within OnData().
        """

    def OnData(self, x: int, y: int, defResult: DragResult) -> DragResult:
        """
        OnData(x, y, defResult) -> DragResult
        
        Called after OnDrop() returns true.
        """

    def OnDragOver(self, x: int, y: int, defResult: DragResult) -> DragResult:
        """
        OnDragOver(x, y, defResult) -> DragResult
        
        Called when the mouse is being dragged over the drop target.
        """

    def OnDrop(self, x: int, y: int) -> bool:
        """
        OnDrop(x, y) -> bool
        
        Called when the user drops a data object on the target.
        """

    def OnEnter(self, x: int, y: int, defResult: DragResult) -> DragResult:
        """
        OnEnter(x, y, defResult) -> DragResult
        
        Called when the mouse enters the drop target.
        """

    def OnLeave(self) -> None:
        """
        OnLeave() -> None
        
        Called when the mouse leaves the drop target.
        """

    def GetDataObject(self) -> DataObject:
        """
        GetDataObject() -> DataObject
        
        Returns the data wxDataObject associated with the drop target.
        """

    def SetDataObject(self, data: DataObject) -> None:
        """
        SetDataObject(data) -> None
        
        Sets the data wxDataObject associated with the drop target and deletes
        any previously associated data object.
        """

    def SetDefaultAction(self, action: DragResult) -> None:
        """
        SetDefaultAction(action) -> None
        
        Sets the default action for drag and drop.
        """

    def GetDefaultAction(self) -> DragResult:
        """
        GetDefaultAction() -> DragResult
        
        Returns default action for drag and drop or wxDragNone if this not
        specified.
        """
    @property
    def Data(self) -> bool: ...
    @property
    def DataObject(self) -> DataObject: ...
    @DataObject.setter
    def DataObject(self, value: DataObject, /) -> None: ...
    @property
    def DefaultAction(self) -> DragResult: ...
    @DefaultAction.setter
    def DefaultAction(self, value: DragResult, /) -> None: ...
# end of class DropTarget


class TextDropTarget(DropTarget):
    """
    TextDropTarget() -> None
    
    A predefined drop target for dealing with text data.
    """

    def __init__(self) -> None:
        """
        TextDropTarget() -> None
        
        A predefined drop target for dealing with text data.
        """

    def OnDrop(self, x: int, y: int) -> bool:
        """
        OnDrop(x, y) -> bool
        
        See wxDropTarget::OnDrop().
        """

    def OnDropText(self, x: int, y: int, data: str) -> bool:
        """
        OnDropText(x, y, data) -> bool
        
        Override this function to receive dropped text.
        """
# end of class TextDropTarget


class FileDropTarget(DropTarget):
    """
    FileDropTarget() -> None
    
    This is a drop target which accepts files (dragged from File Manager
    or Explorer).
    """

    def __init__(self) -> None:
        """
        FileDropTarget() -> None
        
        This is a drop target which accepts files (dragged from File Manager
        or Explorer).
        """

    def OnDrop(self, x: int, y: int) -> bool:
        """
        OnDrop(x, y) -> bool
        
        See wxDropTarget::OnDrop().
        """

    def OnDropFiles(self, x: int, y: int, filenames: List[str]) -> bool:
        """
        OnDropFiles(x, y, filenames) -> bool
        
        Override this function to receive dropped files.
        """
# end of class FileDropTarget


PyDropTarget = wx.deprecated(DropTarget, 'Use DropTarget instead.')
#-- end-dnd --#
#-- begin-clipbrd --#

class Clipboard(Object):
    """
    Clipboard() -> None
    
    A class for manipulating the clipboard.
    """

    def __init__(self) -> None:
        """
        Clipboard() -> None
        
        A class for manipulating the clipboard.
        """

    def AddData(self, data: DataObject) -> bool:
        """
        AddData(data) -> bool
        
        Call this function to add the data object to the clipboard.
        """

    def Clear(self) -> None:
        """
        Clear() -> None
        
        Clears the global clipboard object and the system's clipboard if possible.
        """

    def Close(self) -> None:
        """
        Close() -> None
        
        Call this function to close the clipboard, having opened it with
        Open().
        """

    def Flush(self) -> bool:
        """
        Flush() -> bool
        
        Flushes the clipboard: this means that the data which is currently on clipboard will stay available even after the application exits (possibly eating memory), otherwise the clipboard will be emptied on exit.
        """

    def GetData(self, data: DataObject) -> bool:
        """
        GetData(data) -> bool
        
        Call this function to fill data with data on the clipboard, if
        available in the required format.
        """

    def IsOpened(self) -> bool:
        """
        IsOpened() -> bool
        
        Returns true if the clipboard has been opened.
        """

    def IsSupported(self, format: DataFormat) -> bool:
        """
        IsSupported(format) -> bool
        
        Returns true if there is data which matches the data format of the
        given data object currently available on the clipboard.
        """

    def IsUsingPrimarySelection(self) -> bool:
        """
        IsUsingPrimarySelection() -> bool
        
        Returns true if we are using the primary selection, false if clipboard
        one.
        """

    def Open(self) -> bool:
        """
        Open() -> bool
        
        Call this function to open the clipboard before calling SetData() and
        GetData().
        """

    def SetData(self, data: DataObject) -> bool:
        """
        SetData(data) -> bool
        
        Call this function to set the data object to the clipboard.
        """

    def UsePrimarySelection(self, primary: bool=False) -> None:
        """
        UsePrimarySelection(primary=False) -> None
        
        On platforms supporting it (all X11-based ports), wxClipboard uses the
        CLIPBOARD X11 selection by default.
        """

    @staticmethod
    def Get() -> Clipboard:
        """
        Get() -> Clipboard
        
        Returns the global instance (wxTheClipboard) of the clipboard object.
        """
# end of class Clipboard


# Since wxTheClipboard is not really a global variable (it is a macro
# that calls the Get static method) we can't declare it as a global
# variable for the wrapper generator, otherwise it will try to run the
# function at module import and the wxApp object won't exist yet.  So
# we'll use a class that will allow us to delay calling the Get until
# wx.TheClipboard is actually being used for the first time.
class _wxPyDelayedInitWrapper(object):
    def __init__(self, initfunc, *args, **kwargs):
        self._initfunc = initfunc
        self._args = args
        self._kwargs = kwargs
        self._instance = None
    def _checkInstance(self):
        if self._instance is None:
            if wx.GetApp():
                self._instance = self._initfunc(*self._args, **self._kwargs)
    def __getattr__(self, name):
        self._checkInstance()
        return getattr(self._instance, name)
    def __repr__(self):
        self._checkInstance()
        return repr(self._instance)

    # context manager methods
    def __enter__(self):
        self._checkInstance()
        if not self.Open():
            raise RuntimeError('Unable to open clipboard.')
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.Close()

TheClipboard = _wxPyDelayedInitWrapper(Clipboard.Get)
#-- end-clipbrd --#
#-- begin-config --#

class _enum_(IntEnum):
    CONFIG_USE_LOCAL_FILE = auto()
    CONFIG_USE_GLOBAL_FILE = auto()
    CONFIG_USE_RELATIVE_PATH = auto()
    CONFIG_USE_NO_ESCAPE_CHARACTERS = auto()
    CONFIG_USE_SUBDIR = auto()
CONFIG_USE_LOCAL_FILE = _enum_.CONFIG_USE_LOCAL_FILE
CONFIG_USE_GLOBAL_FILE = _enum_.CONFIG_USE_GLOBAL_FILE
CONFIG_USE_RELATIVE_PATH = _enum_.CONFIG_USE_RELATIVE_PATH
CONFIG_USE_NO_ESCAPE_CHARACTERS = _enum_.CONFIG_USE_NO_ESCAPE_CHARACTERS
CONFIG_USE_SUBDIR = _enum_.CONFIG_USE_SUBDIR

class ConfigBase(Object):
    """
    ConfigBase(appName='', vendorName='', localFilename='', globalFilename='', style=0) -> None
    
    wxConfigBase defines the basic interface of all config classes.
    """

    class _EntryType(IntEnum):
        Type_Unknown = auto()
        Type_String = auto()
        Type_Boolean = auto()
        Type_Integer = auto()
        Type_Float = auto()
    EntryType: TypeAlias = Union[_EntryType, int]
    Type_Unknown = _EntryType.Type_Unknown
    Type_String = _EntryType.Type_String
    Type_Boolean = _EntryType.Type_Boolean
    Type_Integer = _EntryType.Type_Integer
    Type_Float = _EntryType.Type_Float

    def __init__(self, appName: str='', vendorName: str='', localFilename: str='', globalFilename: str='', style: int=0) -> None:
        """
        ConfigBase(appName='', vendorName='', localFilename='', globalFilename='', style=0) -> None
        
        wxConfigBase defines the basic interface of all config classes.
        """

    def GetPath(self) -> str:
        """
        GetPath() -> str
        
        Retrieve the current path (always as absolute path).
        """

    def SetPath(self, strPath: str) -> None:
        """
        SetPath(strPath) -> None
        
        Set current path: if the first character is '/', it is the absolute
        path, otherwise it is a relative path.
        """

    def GetFirstEntry(self) -> Any:
        """
        GetFirstEntry() -> Any
        
        GetFirstEntry() -> (more, value, index)
        
        Allows enumerating the entries in the current group in a config
        object.  Returns a tuple containing a flag indicating if there are
        more
        items, the name of the current item, and an index to pass to
        GetNextEntry to fetch the next item.
        """

    def GetFirstGroup(self) -> Any:
        """
        GetFirstGroup() -> Any
        
        GetFirstGroup() -> (more, value, index)
        
        Allows enumerating the subgroups in a config object.  Returns a tuple
        containing a flag indicating if there are more items, the name of the
        current item, and an index to pass to GetNextGroup to fetch the next
        item.
        """

    def GetNextEntry(self, index: int) -> Any:
        """
        GetNextEntry(index) -> Any
        
        GetNextEntry() -> (more, value, index)
        
        Allows enumerating the entries in the current group in a config
        object.  Returns a tuple containing a flag indicating if there are
        more
        items, the name of the current item, and an index to pass to
        GetNextEntry to fetch the next item.
        """

    def GetNextGroup(self, index: int) -> Any:
        """
        GetNextGroup(index) -> Any
        
        GetNextGroup(long index) -> (more, value, index)
        
        Allows enumerating the subgroups in a config object.  Returns a tuple
        containing a flag indicating if there are more items, the name of the
        current item, and an index to pass to GetNextGroup to fetch the next
        item.
        """

    def GetNumberOfEntries(self, bRecursive: bool=False) -> int:
        """
        GetNumberOfEntries(bRecursive=False) -> int
        
        Get number of entries in the current group.
        """

    def GetNumberOfGroups(self, bRecursive: bool=False) -> int:
        """
        GetNumberOfGroups(bRecursive=False) -> int
        
        Get number of entries/subgroups in the current group, with or without
        its subgroups.
        """

    def Exists(self, strName: str) -> bool:
        """
        Exists(strName) -> bool
        """

    def GetEntryType(self, name: str) -> ConfigBase.EntryType:
        """
        GetEntryType(name) -> ConfigBase.EntryType
        
        Returns the type of the given entry or Unknown if the entry doesn't
        exist.
        """

    def HasEntry(self, strName: str) -> bool:
        """
        HasEntry(strName) -> bool
        """

    def HasGroup(self, strName: str) -> bool:
        """
        HasGroup(strName) -> bool
        """

    def GetAppName(self) -> str:
        """
        GetAppName() -> str
        
        Returns the application name.
        """

    def GetVendorName(self) -> str:
        """
        GetVendorName() -> str
        
        Returns the vendor name.
        """

    def Flush(self, bCurrentOnly: bool=False) -> bool:
        """
        Flush(bCurrentOnly=False) -> bool
        
        Permanently writes all changes (otherwise, they're only written from
        object's destructor).
        """

    def Read(self, key: str, defaultVal: str='') -> str:
        """
        Read(key, defaultVal='') -> str
        
        Another version of Read(), returning the string value directly.
        """

    def ReadBool(self, key: str, defaultVal: bool=False) -> bool:
        """
        ReadBool(key, defaultVal=False) -> bool
        """

    def ReadDouble(self, key: str, defaultVal: float) -> float:
        """
        ReadDouble(key, defaultVal) -> float
        
        Reads a double value from the key and returns it.
        """

    def ReadLong(self, key: str, defaultVal: int) -> int:
        """
        ReadLong(key, defaultVal) -> int
        
        Reads a long value from the key and returns it.
        """

    def ReadLongLong(self, key: str, defaultVal: LongLong_t) -> LongLong_t:
        """
        ReadLongLong(key, defaultVal) -> LongLong_t
        
        Reads a 64-bit long long value from the key and returns it.
        """

    def Write(self, key: str, value: str) -> bool:
        """
        Write(key, value) -> bool
        
        Writes the wxString value to the config file and returns true on success.
        """

    def RenameEntry(self, oldName: str, newName: str) -> bool:
        """
        RenameEntry(oldName, newName) -> bool
        
        Renames an entry in the current group.
        """

    def RenameGroup(self, oldName: str, newName: str) -> bool:
        """
        RenameGroup(oldName, newName) -> bool
        
        Renames a subgroup of the current group.
        """

    def DeleteAll(self) -> bool:
        """
        DeleteAll() -> bool
        
        Delete the whole underlying object (disk file, registry key, ...).
        """

    def DeleteEntry(self, key: str, bDeleteGroupIfEmpty: bool=True) -> bool:
        """
        DeleteEntry(key, bDeleteGroupIfEmpty=True) -> bool
        
        Deletes the specified entry and the group it belongs to if it was the
        last key in it and the second parameter is true.
        """

    def DeleteGroup(self, key: str) -> bool:
        """
        DeleteGroup(key) -> bool
        
        Delete the group (with all subgroups).
        """

    def IsExpandingEnvVars(self) -> bool:
        """
        IsExpandingEnvVars() -> bool
        
        Returns true if we are expanding environment variables in key values.
        """

    def IsRecordingDefaults(self) -> bool:
        """
        IsRecordingDefaults() -> bool
        
        Returns true if we are writing defaults back to the config file.
        """

    def SetExpandEnvVars(self, bDoIt: bool=True) -> None:
        """
        SetExpandEnvVars(bDoIt=True) -> None
        
        Determine whether we wish to expand environment variables in key
        values.
        """

    def SetRecordDefaults(self, bDoIt: bool=True) -> None:
        """
        SetRecordDefaults(bDoIt=True) -> None
        
        Sets whether defaults are recorded to the config file whenever an
        attempt to read the value which is not present in it is done.
        """

    @staticmethod
    def Create() -> ConfigBase:
        """
        Create() -> ConfigBase
        
        Create a new config object and sets it as the current one.
        """

    @staticmethod
    def DontCreateOnDemand() -> None:
        """
        DontCreateOnDemand() -> None
        
        Calling this function will prevent Get() from automatically creating a
        new config object if the current one is NULL.
        """

    @staticmethod
    def Get(CreateOnDemand: bool=True) -> ConfigBase:
        """
        Get(CreateOnDemand=True) -> ConfigBase
        
        Get the current config object.
        """

    @staticmethod
    def Set(pConfig: ConfigBase) -> ConfigBase:
        """
        Set(pConfig) -> ConfigBase
        
        Sets the config object as the current one, returns the pointer to the previous current object (both the parameter and returned value may be NULL).
        """

    def _cpp_ReadInt(self, key: str, defaultVal: int=0) -> int:
        """
        _cpp_ReadInt(key, defaultVal=0) -> int
        """

    def ReadInt(self, key, defaultVal=0):
        """
        
        """

    def ReadFloat(self, key: str, defaultVal: float=0.0) -> float:
        """
        ReadFloat(key, defaultVal=0.0) -> float
        """

    def WriteInt(self, key: str, value: int) -> bool:
        """
        WriteInt(key, value) -> bool
        """

    def WriteFloat(self, key: str, value: float) -> bool:
        """
        WriteFloat(key, value) -> bool
        """

    def WriteBool(self, key: str, value: bool) -> bool:
        """
        WriteBool(key, value) -> bool
        """
    @property
    def AppName(self) -> str: ...
    @property
    def FirstEntry(self) -> Any: ...
    @property
    def FirstGroup(self) -> Any: ...
    @property
    def NextEntry(self) -> Any: ...
    @property
    def NextGroup(self) -> Any: ...
    @property
    def NumberOfEntries(self) -> int: ...
    @property
    def NumberOfGroups(self) -> int: ...
    @property
    def Path(self) -> str: ...
    @Path.setter
    def Path(self, value: str, /) -> None: ...
    @property
    def VendorName(self) -> str: ...
# end of class ConfigBase


class FileConfig(ConfigBase):
    """
    FileConfig(appName='', vendorName='', localFilename='', globalFilename='', style=CONFIG_USE_LOCAL_FILE|CONFIG_USE_GLOBAL_FILE) -> None
    FileConfig(_is) -> None
    
    wxFileConfig implements wxConfigBase interface for storing and
    retrieving configuration information using plain text files.
    """

    @overload
    def __init__(self, _is: InputStream) -> None:
        ...

    @overload
    def __init__(self, appName: str='', vendorName: str='', localFilename: str='', globalFilename: str='', style: int=CONFIG_USE_LOCAL_FILE|CONFIG_USE_GLOBAL_FILE) -> None:
        """
        FileConfig(appName='', vendorName='', localFilename='', globalFilename='', style=CONFIG_USE_LOCAL_FILE|CONFIG_USE_GLOBAL_FILE) -> None
        FileConfig(_is) -> None
        
        wxFileConfig implements wxConfigBase interface for storing and
        retrieving configuration information using plain text files.
        """

    def Save(self, os: OutputStream) -> bool:
        """
        Save(os) -> bool
        
        Saves all config data to the given stream, returns true if data was saved successfully or false on error.
        """

    def EnableAutoSave(self) -> None:
        """
        EnableAutoSave() -> None
        
        Enables saving data to the disk file when this object is destroyed.
        """

    def DisableAutoSave(self) -> None:
        """
        DisableAutoSave() -> None
        
        Prevent this object from saving data to the disk file when it is
        destroyed.
        """

    def SetUmask(self, mode: int) -> None:
        """
        SetUmask(mode) -> None
        
        Allows setting the mode to be used for the config file creation.
        """

    def SetPath(self, strPath: str) -> None:
        """
        SetPath(strPath) -> None
        
        Set current path: if the first character is '/', it is the absolute
        path, otherwise it is a relative path.
        """

    def GetPath(self) -> str:
        """
        GetPath() -> str
        
        Retrieve the current path (always as absolute path).
        """

    def GetNumberOfEntries(self, bRecursive: bool=False) -> int:
        """
        GetNumberOfEntries(bRecursive=False) -> int
        
        Get number of entries in the current group.
        """

    def GetNumberOfGroups(self, bRecursive: bool=False) -> int:
        """
        GetNumberOfGroups(bRecursive=False) -> int
        
        Get number of entries/subgroups in the current group, with or without
        its subgroups.
        """

    def HasGroup(self, strName: str) -> bool:
        """
        HasGroup(strName) -> bool
        """

    def HasEntry(self, strName: str) -> bool:
        """
        HasEntry(strName) -> bool
        """

    def Flush(self, bCurrentOnly: bool=False) -> bool:
        """
        Flush(bCurrentOnly=False) -> bool
        
        Permanently writes all changes (otherwise, they're only written from
        object's destructor).
        """

    def RenameEntry(self, oldName: str, newName: str) -> bool:
        """
        RenameEntry(oldName, newName) -> bool
        
        Renames an entry in the current group.
        """

    def RenameGroup(self, oldName: str, newName: str) -> bool:
        """
        RenameGroup(oldName, newName) -> bool
        
        Renames a subgroup of the current group.
        """

    def DeleteEntry(self, key: str, bDeleteGroupIfEmpty: bool=True) -> bool:
        """
        DeleteEntry(key, bDeleteGroupIfEmpty=True) -> bool
        
        Deletes the specified entry and the group it belongs to if it was the
        last key in it and the second parameter is true.
        """

    def DeleteGroup(self, key: str) -> bool:
        """
        DeleteGroup(key) -> bool
        
        Delete the group (with all subgroups).
        """

    def DeleteAll(self) -> bool:
        """
        DeleteAll() -> bool
        
        Delete the whole underlying object (disk file, registry key, ...).
        """

    @staticmethod
    def GetGlobalFileName(szFile: str) -> str:
        """
        GetGlobalFileName(szFile) -> str
        """

    @staticmethod
    def GetLocalFileName(szFile: str, style: int=0) -> str:
        """
        GetLocalFileName(szFile, style=0) -> str
        """
    @property
    def NumberOfEntries(self) -> int: ...
    @property
    def NumberOfGroups(self) -> int: ...
    @property
    def Path(self) -> str: ...
    @Path.setter
    def Path(self, value: str, /) -> None: ...
# end of class FileConfig


class ConfigPathChanger:
    """
    ConfigPathChanger(pContainer, strEntry) -> None
    
    A handy little class which changes the current path in a wxConfig
    object and restores it in dtor.
    """

    def __init__(self, pContainer: ConfigBase, strEntry: str) -> None:
        """
        ConfigPathChanger(pContainer, strEntry) -> None
        
        A handy little class which changes the current path in a wxConfig
        object and restores it in dtor.
        """

    def Name(self) -> str:
        """
        Name() -> str
        
        Returns the name of the key which was passed to the ctor.
        """

    def UpdateIfDeleted(self) -> None:
        """
        UpdateIfDeleted() -> None
        
        This method must be called if the original path inside the wxConfig
        object (i.e.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class ConfigPathChanger

#-- end-config --#
#-- begin-tracker --#

class Trackable:
    """
    Add-on base class for a trackable object.
    """
# end of class Trackable

#-- end-tracker --#
#-- begin-kbdstate --#

class KeyboardState:
    """
    KeyboardState(controlDown=False, shiftDown=False, altDown=False, metaDown=False) -> None
    
    Provides methods for testing the state of the keyboard modifier keys.
    """

    def __init__(self, controlDown: bool=False, shiftDown: bool=False, altDown: bool=False, metaDown: bool=False) -> None:
        """
        KeyboardState(controlDown=False, shiftDown=False, altDown=False, metaDown=False) -> None
        
        Provides methods for testing the state of the keyboard modifier keys.
        """

    def GetModifiers(self) -> int:
        """
        GetModifiers() -> int
        
        Return the bit mask of all pressed modifier keys.
        """

    def HasAnyModifiers(self) -> bool:
        """
        HasAnyModifiers() -> bool
        
        Returns true if any modifiers at all are pressed.
        """

    def HasModifiers(self) -> bool:
        """
        HasModifiers() -> bool
        
        Returns true if Control or Alt are pressed.
        """

    def ControlDown(self) -> bool:
        """
        ControlDown() -> bool
        
        Returns true if the Control key or Apple/Command key under macOS is
        pressed.
        """

    def RawControlDown(self) -> bool:
        """
        RawControlDown() -> bool
        
        Returns true if the Control key (also under macOS).
        """

    def ShiftDown(self) -> bool:
        """
        ShiftDown() -> bool
        
        Returns true if the Shift key is pressed.
        """

    def MetaDown(self) -> bool:
        """
        MetaDown() -> bool
        
        Returns true if the Meta/Windows/Apple key is pressed.
        """

    def AltDown(self) -> bool:
        """
        AltDown() -> bool
        
        Returns true if the Alt key is pressed.
        """

    def CmdDown(self) -> bool:
        """
        CmdDown() -> bool
        
        Returns true if the key used for command accelerators is pressed.
        """

    def SetControlDown(self, down: bool) -> None:
        """
        SetControlDown(down) -> None
        """

    def SetRawControlDown(self, down: bool) -> None:
        """
        SetRawControlDown(down) -> None
        """

    def SetShiftDown(self, down: bool) -> None:
        """
        SetShiftDown(down) -> None
        """

    def SetAltDown(self, down: bool) -> None:
        """
        SetAltDown(down) -> None
        """

    def SetMetaDown(self, down: bool) -> None:
        """
        SetMetaDown(down) -> None
        """
    @property
    def controlDown(self) -> bool: ...
    @controlDown.setter
    def controlDown(self, value: bool, /) -> None: ...
    @property
    def rawControlDown(self) -> bool: ...
    @rawControlDown.setter
    def rawControlDown(self, value: bool, /) -> None: ...
    @property
    def shiftDown(self) -> bool: ...
    @shiftDown.setter
    def shiftDown(self, value: bool, /) -> None: ...
    @property
    def altDown(self) -> bool: ...
    @altDown.setter
    def altDown(self, value: bool, /) -> None: ...
    @property
    def metaDown(self) -> bool: ...
    @metaDown.setter
    def metaDown(self, value: bool, /) -> None: ...
    @property
    def cmdDown(self) -> bool: ...

    # For 2.8 compatibility
    m_controlDown = wx.deprecated(controlDown, "Use controlDown instead.")
    m_shiftDown   = wx.deprecated(shiftDown, "Use shiftDown instead.")
    m_altDown     = wx.deprecated(altDown, "Use altDown instead.")
    m_metaDown    = wx.deprecated(metaDown, "Use metaDown instead.")
# end of class KeyboardState

#-- end-kbdstate --#
#-- begin-mousestate --#

class _MouseButton(IntEnum):
    MOUSE_BTN_ANY = auto()
    MOUSE_BTN_NONE = auto()
    MOUSE_BTN_LEFT = auto()
    MOUSE_BTN_MIDDLE = auto()
    MOUSE_BTN_RIGHT = auto()
    MOUSE_BTN_AUX1 = auto()
    MOUSE_BTN_AUX2 = auto()
    MOUSE_BTN_MAX = auto()
MouseButton: TypeAlias = Union[_MouseButton, int]
MOUSE_BTN_ANY = _MouseButton.MOUSE_BTN_ANY
MOUSE_BTN_NONE = _MouseButton.MOUSE_BTN_NONE
MOUSE_BTN_LEFT = _MouseButton.MOUSE_BTN_LEFT
MOUSE_BTN_MIDDLE = _MouseButton.MOUSE_BTN_MIDDLE
MOUSE_BTN_RIGHT = _MouseButton.MOUSE_BTN_RIGHT
MOUSE_BTN_AUX1 = _MouseButton.MOUSE_BTN_AUX1
MOUSE_BTN_AUX2 = _MouseButton.MOUSE_BTN_AUX2
MOUSE_BTN_MAX = _MouseButton.MOUSE_BTN_MAX

class MouseState(KeyboardState):
    """
    MouseState() -> None
    
    Represents the mouse state.
    """

    def __init__(self) -> None:
        """
        MouseState() -> None
        
        Represents the mouse state.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Returns the physical mouse position.
        """

    def GetX(self) -> int:
        """
        GetX() -> int
        
        Returns X coordinate of the physical mouse event position.
        """

    def GetY(self) -> int:
        """
        GetY() -> int
        
        Returns Y coordinate of the physical mouse event position.
        """

    def LeftIsDown(self) -> bool:
        """
        LeftIsDown() -> bool
        
        Returns true if the left mouse button is currently down.
        """

    def MiddleIsDown(self) -> bool:
        """
        MiddleIsDown() -> bool
        
        Returns true if the middle mouse button is currently down.
        """

    def RightIsDown(self) -> bool:
        """
        RightIsDown() -> bool
        
        Returns true if the right mouse button is currently down.
        """

    def Aux1IsDown(self) -> bool:
        """
        Aux1IsDown() -> bool
        
        Returns true if the first extra button mouse button is currently down.
        """

    def Aux2IsDown(self) -> bool:
        """
        Aux2IsDown() -> bool
        
        Returns true if the second extra button mouse button is currently
        down.
        """

    def SetX(self, x: int) -> None:
        """
        SetX(x) -> None
        """

    def SetY(self, y: int) -> None:
        """
        SetY(y) -> None
        """

    def SetPosition(self, pos: Point) -> None:
        """
        SetPosition(pos) -> None
        """

    def SetLeftDown(self, down: bool) -> None:
        """
        SetLeftDown(down) -> None
        """

    def SetMiddleDown(self, down: bool) -> None:
        """
        SetMiddleDown(down) -> None
        """

    def SetRightDown(self, down: bool) -> None:
        """
        SetRightDown(down) -> None
        """

    def SetAux1Down(self, down: bool) -> None:
        """
        SetAux1Down(down) -> None
        """

    def SetAux2Down(self, down: bool) -> None:
        """
        SetAux2Down(down) -> None
        """

    def SetState(self, state: MouseState) -> None:
        """
        SetState(state) -> None
        """
    @property
    def x(self) -> int: ...
    @x.setter
    def x(self, value: int, /) -> None: ...
    @property
    def y(self) -> int: ...
    @y.setter
    def y(self, value: int, /) -> None: ...
    @property
    def X(self) -> int: ...
    @X.setter
    def X(self, value: int, /) -> None: ...
    @property
    def Y(self) -> int: ...
    @Y.setter
    def Y(self, value: int, /) -> None: ...
    @property
    def leftIsDown(self) -> bool: ...
    @leftIsDown.setter
    def leftIsDown(self, value: bool, /) -> None: ...
    @property
    def middleIsDown(self) -> bool: ...
    @middleIsDown.setter
    def middleIsDown(self, value: bool, /) -> None: ...
    @property
    def rightIsDown(self) -> bool: ...
    @rightIsDown.setter
    def rightIsDown(self, value: bool, /) -> None: ...
    @property
    def aux1IsDown(self) -> bool: ...
    @aux1IsDown.setter
    def aux1IsDown(self, value: bool, /) -> None: ...
    @property
    def aux2IsDown(self) -> bool: ...
    @aux2IsDown.setter
    def aux2IsDown(self, value: bool, /) -> None: ...
    @property
    def Position(self) -> Point: ...
    @Position.setter
    def Position(self, value: Point, /) -> None: ...
# end of class MouseState

#-- end-mousestate --#
#-- begin-tooltip --#

class ToolTip(Object):
    """
    ToolTip(tip) -> None
    
    This class holds information about a tooltip associated with a window
    (see wxWindow::SetToolTip()).
    """

    def __init__(self, tip: str) -> None:
        """
        ToolTip(tip) -> None
        
        This class holds information about a tooltip associated with a window
        (see wxWindow::SetToolTip()).
        """

    def GetTip(self) -> str:
        """
        GetTip() -> str
        
        Get the tooltip text.
        """

    def GetWindow(self) -> Window:
        """
        GetWindow() -> Window
        
        Get the associated window.
        """

    def SetTip(self, tip: str) -> None:
        """
        SetTip(tip) -> None
        
        Set the tooltip text.
        """

    @staticmethod
    def Enable(flag: bool) -> None:
        """
        Enable(flag) -> None
        
        Enable or disable tooltips globally.
        """

    @staticmethod
    def SetAutoPop(msecs: int) -> None:
        """
        SetAutoPop(msecs) -> None
        
        Set the delay after which the tooltip disappears or how long a tooltip
        remains visible.
        """

    @staticmethod
    def SetDelay(msecs: int) -> None:
        """
        SetDelay(msecs) -> None
        
        Set the delay after which the tooltip appears.
        """

    @staticmethod
    def SetMaxWidth(width: int) -> None:
        """
        SetMaxWidth(width) -> None
        
        Set tooltip maximal width in pixels.
        """

    @staticmethod
    def SetReshow(msecs: int) -> None:
        """
        SetReshow(msecs) -> None
        
        Set the delay between subsequent tooltips to appear.
        """
    @property
    def Tip(self) -> str: ...
    @Tip.setter
    def Tip(self, value: str, /) -> None: ...
    @property
    def Window(self) -> Window: ...
# end of class ToolTip

#-- end-tooltip --#
#-- begin-layout --#

class _Edge(IntEnum):
    Left = auto()
    Top = auto()
    Right = auto()
    Bottom = auto()
    Width = auto()
    Height = auto()
    Centre = auto()
    Center = auto()
    CentreX = auto()
    CentreY = auto()
Edge: TypeAlias = Union[_Edge, int]
Left = _Edge.Left
Top = _Edge.Top
Right = _Edge.Right
Bottom = _Edge.Bottom
Width = _Edge.Width
Height = _Edge.Height
Centre = _Edge.Centre
Center = _Edge.Center
CentreX = _Edge.CentreX
CentreY = _Edge.CentreY

class _Relationship(IntEnum):
    Unconstrained = auto()
    AsIs = auto()
    PercentOf = auto()
    Above = auto()
    Below = auto()
    LeftOf = auto()
    RightOf = auto()
    SameAs = auto()
    Absolute = auto()
Relationship: TypeAlias = Union[_Relationship, int]
Unconstrained = _Relationship.Unconstrained
AsIs = _Relationship.AsIs
PercentOf = _Relationship.PercentOf
Above = _Relationship.Above
Below = _Relationship.Below
LeftOf = _Relationship.LeftOf
RightOf = _Relationship.RightOf
SameAs = _Relationship.SameAs
Absolute = _Relationship.Absolute
LAYOUT_DEFAULT_MARGIN: int

class IndividualLayoutConstraint(Object):
    """
    IndividualLayoutConstraint() -> None
    """

    def __init__(self) -> None:
        """
        IndividualLayoutConstraint() -> None
        """

    def Set(self, rel: Relationship, otherW: Window, otherE: Edge, val: int=0, margin: int=LAYOUT_DEFAULT_MARGIN) -> None:
        """
        Set(rel, otherW, otherE, val=0, margin=LAYOUT_DEFAULT_MARGIN) -> None
        """

    def LeftOf(self, sibling: Window, margin: int=LAYOUT_DEFAULT_MARGIN) -> None:
        """
        LeftOf(sibling, margin=LAYOUT_DEFAULT_MARGIN) -> None
        """

    def RightOf(self, sibling: Window, margin: int=LAYOUT_DEFAULT_MARGIN) -> None:
        """
        RightOf(sibling, margin=LAYOUT_DEFAULT_MARGIN) -> None
        """

    def Above(self, sibling: Window, margin: int=LAYOUT_DEFAULT_MARGIN) -> None:
        """
        Above(sibling, margin=LAYOUT_DEFAULT_MARGIN) -> None
        """

    def Below(self, sibling: Window, margin: int=LAYOUT_DEFAULT_MARGIN) -> None:
        """
        Below(sibling, margin=LAYOUT_DEFAULT_MARGIN) -> None
        """

    def SameAs(self, otherW: Window, edge: Edge, margin: int=LAYOUT_DEFAULT_MARGIN) -> None:
        """
        SameAs(otherW, edge, margin=LAYOUT_DEFAULT_MARGIN) -> None
        """

    def PercentOf(self, otherW: Window, wh: Edge, per: int) -> None:
        """
        PercentOf(otherW, wh, per) -> None
        """

    def Absolute(self, val: int) -> None:
        """
        Absolute(val) -> None
        """

    def Unconstrained(self) -> None:
        """
        Unconstrained() -> None
        """

    def AsIs(self) -> None:
        """
        AsIs() -> None
        """

    def GetOtherWindow(self) -> Window:
        """
        GetOtherWindow() -> Window
        """

    def GetMyEdge(self) -> Edge:
        """
        GetMyEdge() -> Edge
        """

    def SetEdge(self, which: Edge) -> None:
        """
        SetEdge(which) -> None
        """

    def SetValue(self, v: int) -> None:
        """
        SetValue(v) -> None
        """

    def GetMargin(self) -> int:
        """
        GetMargin() -> int
        """

    def SetMargin(self, m: int) -> None:
        """
        SetMargin(m) -> None
        """

    def GetValue(self) -> int:
        """
        GetValue() -> int
        """

    def GetPercent(self) -> int:
        """
        GetPercent() -> int
        """

    def GetOtherEdge(self) -> int:
        """
        GetOtherEdge() -> int
        """

    def GetDone(self) -> bool:
        """
        GetDone() -> bool
        """

    def SetDone(self, d: bool) -> None:
        """
        SetDone(d) -> None
        """

    def GetRelationship(self) -> Relationship:
        """
        GetRelationship() -> Relationship
        """

    def SetRelationship(self, r: Relationship) -> None:
        """
        SetRelationship(r) -> None
        """

    def ResetIfWin(self, otherW: Window) -> bool:
        """
        ResetIfWin(otherW) -> bool
        """

    def SatisfyConstraint(self, constraints: LayoutConstraints, win: Window) -> bool:
        """
        SatisfyConstraint(constraints, win) -> bool
        """

    def GetEdge(self, which: Edge, thisWin: Window, other: Window) -> int:
        """
        GetEdge(which, thisWin, other) -> int
        """
    @property
    def Done(self) -> bool: ...
    @Done.setter
    def Done(self, value: bool, /) -> None: ...
    @property
    def Margin(self) -> int: ...
    @Margin.setter
    def Margin(self, value: int, /) -> None: ...
    @property
    def MyEdge(self) -> Edge: ...
    @property
    def OtherEdge(self) -> int: ...
    @property
    def OtherWindow(self) -> Window: ...
    @property
    def Percent(self) -> int: ...
    @property
    def Relationship(self) -> Relationship: ...
    @Relationship.setter
    def Relationship(self, value: Relationship, /) -> None: ...
    @property
    def Value(self) -> int: ...
    @Value.setter
    def Value(self, value: int, /) -> None: ...
# end of class IndividualLayoutConstraint


class LayoutConstraints(Object):
    """
    LayoutConstraints() -> None
    """

    def __init__(self) -> None:
        """
        LayoutConstraints() -> None
        """
    left: IndividualLayoutConstraint
    top: IndividualLayoutConstraint
    right: IndividualLayoutConstraint
    bottom: IndividualLayoutConstraint
    width: IndividualLayoutConstraint
    height: IndividualLayoutConstraint
    centreX: IndividualLayoutConstraint
    centreY: IndividualLayoutConstraint

    def SatisfyConstraints(self, win: Window, noChanges: int) -> bool:
        """
        SatisfyConstraints(win, noChanges) -> bool
        """

    def AreSatisfied(self) -> bool:
        """
        AreSatisfied() -> bool
        """
# end of class LayoutConstraints

#-- end-layout --#
#-- begin-event --#

class _EventPropagation(IntEnum):
    EVENT_PROPAGATE_NONE = auto()
    EVENT_PROPAGATE_MAX = auto()
EventPropagation: TypeAlias = Union[_EventPropagation, int]
EVENT_PROPAGATE_NONE = _EventPropagation.EVENT_PROPAGATE_NONE
EVENT_PROPAGATE_MAX = _EventPropagation.EVENT_PROPAGATE_MAX

class _EventCategory(IntEnum):
    wxEVT_CATEGORY_UI = auto()
    wxEVT_CATEGORY_USER_INPUT = auto()
    wxEVT_CATEGORY_SOCKET = auto()
    wxEVT_CATEGORY_TIMER = auto()
    wxEVT_CATEGORY_THREAD = auto()
    wxEVT_CATEGORY_ALL = auto()
EventCategory: TypeAlias = Union[_EventCategory, int]
wxEVT_CATEGORY_UI = _EventCategory.wxEVT_CATEGORY_UI
wxEVT_CATEGORY_USER_INPUT = _EventCategory.wxEVT_CATEGORY_USER_INPUT
wxEVT_CATEGORY_SOCKET = _EventCategory.wxEVT_CATEGORY_SOCKET
wxEVT_CATEGORY_TIMER = _EventCategory.wxEVT_CATEGORY_TIMER
wxEVT_CATEGORY_THREAD = _EventCategory.wxEVT_CATEGORY_THREAD
wxEVT_CATEGORY_ALL = _EventCategory.wxEVT_CATEGORY_ALL

class _KeyCategoryFlags(IntFlag):
    WXK_CATEGORY_ARROW = auto()
    WXK_CATEGORY_PAGING = auto()
    WXK_CATEGORY_JUMP = auto()
    WXK_CATEGORY_TAB = auto()
    WXK_CATEGORY_CUT = auto()
    WXK_CATEGORY_NAVIGATION = auto()
KeyCategoryFlags: TypeAlias = Union[_KeyCategoryFlags, int]
WXK_CATEGORY_ARROW = _KeyCategoryFlags.WXK_CATEGORY_ARROW
WXK_CATEGORY_PAGING = _KeyCategoryFlags.WXK_CATEGORY_PAGING
WXK_CATEGORY_JUMP = _KeyCategoryFlags.WXK_CATEGORY_JUMP
WXK_CATEGORY_TAB = _KeyCategoryFlags.WXK_CATEGORY_TAB
WXK_CATEGORY_CUT = _KeyCategoryFlags.WXK_CATEGORY_CUT
WXK_CATEGORY_NAVIGATION = _KeyCategoryFlags.WXK_CATEGORY_NAVIGATION

class _enum_(IntEnum):
    JOYSTICK1 = auto()
    JOYSTICK2 = auto()
JOYSTICK1 = _enum_.JOYSTICK1
JOYSTICK2 = _enum_.JOYSTICK2

class _enum_(IntEnum):
    JOY_BUTTON_ANY = auto()
    JOY_BUTTON1 = auto()
    JOY_BUTTON2 = auto()
    JOY_BUTTON3 = auto()
    JOY_BUTTON4 = auto()
JOY_BUTTON_ANY = _enum_.JOY_BUTTON_ANY
JOY_BUTTON1 = _enum_.JOY_BUTTON1
JOY_BUTTON2 = _enum_.JOY_BUTTON2
JOY_BUTTON3 = _enum_.JOY_BUTTON3
JOY_BUTTON4 = _enum_.JOY_BUTTON4

class _UpdateUIMode(IntEnum):
    UPDATE_UI_PROCESS_ALL = auto()
    UPDATE_UI_PROCESS_SPECIFIED = auto()
UpdateUIMode: TypeAlias = Union[_UpdateUIMode, int]
UPDATE_UI_PROCESS_ALL = _UpdateUIMode.UPDATE_UI_PROCESS_ALL
UPDATE_UI_PROCESS_SPECIFIED = _UpdateUIMode.UPDATE_UI_PROCESS_SPECIFIED

class _MouseWheelAxis(IntEnum):
    MOUSE_WHEEL_VERTICAL = auto()
    MOUSE_WHEEL_HORIZONTAL = auto()
MouseWheelAxis: TypeAlias = Union[_MouseWheelAxis, int]
MOUSE_WHEEL_VERTICAL = _MouseWheelAxis.MOUSE_WHEEL_VERTICAL
MOUSE_WHEEL_HORIZONTAL = _MouseWheelAxis.MOUSE_WHEEL_HORIZONTAL

class _IdleMode(IntEnum):
    IDLE_PROCESS_ALL = auto()
    IDLE_PROCESS_SPECIFIED = auto()
IdleMode: TypeAlias = Union[_IdleMode, int]
IDLE_PROCESS_ALL = _IdleMode.IDLE_PROCESS_ALL
IDLE_PROCESS_SPECIFIED = _IdleMode.IDLE_PROCESS_SPECIFIED
wxEVT_NULL: int
wxEVT_ANY: int
wxEVT_BUTTON: int
wxEVT_CHECKBOX: int
wxEVT_CHOICE: int
wxEVT_LISTBOX: int
wxEVT_LISTBOX_DCLICK: int
wxEVT_CHECKLISTBOX: int
wxEVT_MENU: int
wxEVT_SLIDER: int
wxEVT_RADIOBOX: int
wxEVT_RADIOBUTTON: int
wxEVT_SCROLLBAR: int
wxEVT_VLBOX: int
wxEVT_COMBOBOX: int
wxEVT_TOOL_RCLICKED: int
wxEVT_TOOL_DROPDOWN: int
wxEVT_TOOL_ENTER: int
wxEVT_COMBOBOX_DROPDOWN: int
wxEVT_COMBOBOX_CLOSEUP: int
wxEVT_THREAD: int
wxEVT_LEFT_DOWN: int
wxEVT_LEFT_UP: int
wxEVT_MIDDLE_DOWN: int
wxEVT_MIDDLE_UP: int
wxEVT_RIGHT_DOWN: int
wxEVT_RIGHT_UP: int
wxEVT_MOTION: int
wxEVT_ENTER_WINDOW: int
wxEVT_LEAVE_WINDOW: int
wxEVT_LEFT_DCLICK: int
wxEVT_MIDDLE_DCLICK: int
wxEVT_RIGHT_DCLICK: int
wxEVT_SET_FOCUS: int
wxEVT_KILL_FOCUS: int
wxEVT_CHILD_FOCUS: int
wxEVT_MOUSEWHEEL: int
wxEVT_MAGNIFY: int
wxEVT_AUX1_DOWN: int
wxEVT_AUX1_UP: int
wxEVT_AUX1_DCLICK: int
wxEVT_AUX2_DOWN: int
wxEVT_AUX2_UP: int
wxEVT_AUX2_DCLICK: int
wxEVT_CHAR: int
wxEVT_CHAR_HOOK: int
wxEVT_NAVIGATION_KEY: int
wxEVT_KEY_DOWN: int
wxEVT_KEY_UP: int
wxEVT_HOTKEY: int
wxEVT_SET_CURSOR: int
wxEVT_SCROLL_TOP: int
wxEVT_SCROLL_BOTTOM: int
wxEVT_SCROLL_LINEUP: int
wxEVT_SCROLL_LINEDOWN: int
wxEVT_SCROLL_PAGEUP: int
wxEVT_SCROLL_PAGEDOWN: int
wxEVT_SCROLL_THUMBTRACK: int
wxEVT_SCROLL_THUMBRELEASE: int
wxEVT_SCROLL_CHANGED: int
wxEVT_SPIN_UP: int
wxEVT_SPIN_DOWN: int
wxEVT_SPIN: int
wxEVT_SCROLLWIN_TOP: int
wxEVT_SCROLLWIN_BOTTOM: int
wxEVT_SCROLLWIN_LINEUP: int
wxEVT_SCROLLWIN_LINEDOWN: int
wxEVT_SCROLLWIN_PAGEUP: int
wxEVT_SCROLLWIN_PAGEDOWN: int
wxEVT_SCROLLWIN_THUMBTRACK: int
wxEVT_SCROLLWIN_THUMBRELEASE: int
wxEVT_GESTURE_PAN: int
wxEVT_GESTURE_ZOOM: int
wxEVT_GESTURE_ROTATE: int
wxEVT_TWO_FINGER_TAP: int
wxEVT_LONG_PRESS: int
wxEVT_PRESS_AND_TAP: int
wxEVT_SIZE: int
wxEVT_MOVE: int
wxEVT_CLOSE_WINDOW: int
wxEVT_END_SESSION: int
wxEVT_QUERY_END_SESSION: int
wxEVT_ACTIVATE_APP: int
wxEVT_ACTIVATE: int
wxEVT_CREATE: int
wxEVT_DESTROY: int
wxEVT_SHOW: int
wxEVT_ICONIZE: int
wxEVT_MAXIMIZE: int
wxEVT_FULLSCREEN: int
wxEVT_MOUSE_CAPTURE_CHANGED: int
wxEVT_MOUSE_CAPTURE_LOST: int
wxEVT_PAINT: int
wxEVT_ERASE_BACKGROUND: int
wxEVT_NC_PAINT: int
wxEVT_MENU_OPEN: int
wxEVT_MENU_CLOSE: int
wxEVT_MENU_HIGHLIGHT: int
wxEVT_CONTEXT_MENU: int
wxEVT_SYS_COLOUR_CHANGED: int
wxEVT_DISPLAY_CHANGED: int
wxEVT_DPI_CHANGED: int
wxEVT_QUERY_NEW_PALETTE: int
wxEVT_PALETTE_CHANGED: int
wxEVT_JOY_BUTTON_DOWN: int
wxEVT_JOY_BUTTON_UP: int
wxEVT_JOY_MOVE: int
wxEVT_JOY_ZMOVE: int
wxEVT_DROP_FILES: int
wxEVT_INIT_DIALOG: int
wxEVT_IDLE: int
wxEVT_UPDATE_UI: int
wxEVT_SIZING: int
wxEVT_MOVING: int
wxEVT_MOVE_START: int
wxEVT_MOVE_END: int
wxEVT_HIBERNATE: int
wxEVT_TEXT_COPY: int
wxEVT_TEXT_CUT: int
wxEVT_TEXT_PASTE: int
wxEVT_COMMAND_LEFT_CLICK: int
wxEVT_COMMAND_LEFT_DCLICK: int
wxEVT_COMMAND_RIGHT_CLICK: int
wxEVT_COMMAND_RIGHT_DCLICK: int
wxEVT_COMMAND_SET_FOCUS: int
wxEVT_COMMAND_KILL_FOCUS: int
wxEVT_COMMAND_ENTER: int
wxEVT_HELP: int
wxEVT_DETAILED_HELP: int
wxEVT_TOOL: int
wxEVT_WINDOW_MODAL_DIALOG_CLOSED: int

class EvtHandler(Object, Trackable):
    """
    EvtHandler() -> None
    
    A class that can handle events from the windowing system.
    """

    def __init__(self) -> None:
        """
        EvtHandler() -> None
        
        A class that can handle events from the windowing system.
        """

    def QueueEvent(self, event: Event) -> None:
        """
        QueueEvent(event) -> None
        
        Queue event for a later processing.
        """

    def AddPendingEvent(self, event: Event) -> None:
        """
        AddPendingEvent(event) -> None
        
        Post an event to be processed later.
        """

    def ProcessEvent(self, event: Event) -> bool:
        """
        ProcessEvent(event) -> bool
        
        Processes an event, searching event tables and calling zero or more
        suitable event handler function(s).
        """

    def ProcessEventLocally(self, event: Event) -> bool:
        """
        ProcessEventLocally(event) -> bool
        
        Try to process the event in this handler and all those chained to it.
        """

    def SafelyProcessEvent(self, event: Event) -> bool:
        """
        SafelyProcessEvent(event) -> bool
        
        Processes an event by calling ProcessEvent() and handles any
        exceptions that occur in the process.
        """

    def ProcessPendingEvents(self) -> None:
        """
        ProcessPendingEvents() -> None
        
        Processes the pending events previously queued using QueueEvent() or
        AddPendingEvent(); you must call this function only if you are sure
        there are pending events for this handler, otherwise a wxCHECK will
        fail.
        """

    def DeletePendingEvents(self) -> None:
        """
        DeletePendingEvents() -> None
        
        Deletes all events queued on this event handler using QueueEvent() or
        AddPendingEvent().
        """

    def Connect(self, id: int, lastId: int, eventType: EventType, func: Any) -> None:
        """
        Connect(id, lastId, eventType, func) -> None
        
        Make an entry in the dynamic event table for an event binding.
        """

    def Disconnect(self, id: int, lastId: int=-1, eventType: EventType=wxEVT_NULL, func: Optional[Any]=None) -> bool:
        """
        Disconnect(id, lastId=-1, eventType=wxEVT_NULL, func=None) -> bool
        
        Remove an event binding by removing its entry in the dynamic event
        table.
        """

    def GetEvtHandlerEnabled(self) -> bool:
        """
        GetEvtHandlerEnabled() -> bool
        
        Returns true if the event handler is enabled, false otherwise.
        """

    def GetNextHandler(self) -> EvtHandler:
        """
        GetNextHandler() -> EvtHandler
        
        Returns the pointer to the next handler in the chain.
        """

    def GetPreviousHandler(self) -> EvtHandler:
        """
        GetPreviousHandler() -> EvtHandler
        
        Returns the pointer to the previous handler in the chain.
        """

    def SetEvtHandlerEnabled(self, enabled: bool) -> None:
        """
        SetEvtHandlerEnabled(enabled) -> None
        
        Enables or disables the event handler.
        """

    def SetNextHandler(self, handler: EvtHandler) -> None:
        """
        SetNextHandler(handler) -> None
        
        Sets the pointer to the next handler.
        """

    def SetPreviousHandler(self, handler: EvtHandler) -> None:
        """
        SetPreviousHandler(handler) -> None
        
        Sets the pointer to the previous handler.
        """

    def Unlink(self) -> None:
        """
        Unlink() -> None
        
        Unlinks this event handler from the chain it's part of (if any); then links the "previous" event handler to the "next" one (so that the chain won't be interrupted).
        """

    def IsUnlinked(self) -> bool:
        """
        IsUnlinked() -> bool
        
        Returns true if the next and the previous handler pointers of this
        event handler instance are NULL.
        """

    @staticmethod
    def AddFilter(filter: EventFilter) -> None:
        """
        AddFilter(filter) -> None
        
        Add an event filter whose FilterEvent() method will be called for each
        and every event processed by wxWidgets.
        """

    @staticmethod
    def RemoveFilter(filter: EventFilter) -> None:
        """
        RemoveFilter(filter) -> None
        
        Remove a filter previously installed with AddFilter().
        """

    def Bind(self, event, handler, source=None, id=wx.ID_ANY, id2=wx.ID_ANY):
        """
        Bind an event to an event handler.
        
        :param event: One of the ``EVT_*`` event binder objects that
                      specifies the type of event to bind.
        
        :param handler: A callable object to be invoked when the
                        event is delivered to self.  Pass ``None`` to
                        disconnect an event handler.
        
        :param source: Sometimes the event originates from a
                       different window than self, but you still
                       want to catch it in self.  (For example, a
                       button event delivered to a frame.)  By
                       passing the source of the event, the event
                       handling system is able to differentiate
                       between the same event type from different
                       controls.
        
        :param id: Used to spcify the event source by ID instead
                   of instance.
        
        :param id2: Used when it is desirable to bind a handler
                    to a range of IDs, such as with EVT_MENU_RANGE.
        """

    def Unbind(self, event, source=None, id=wx.ID_ANY, id2=wx.ID_ANY, handler=None):
        """
        Disconnects the event handler binding for event from `self`.
        Returns ``True`` if successful.
        """
    @property
    def EvtHandlerEnabled(self) -> bool: ...
    @EvtHandlerEnabled.setter
    def EvtHandlerEnabled(self, value: bool, /) -> None: ...
    @property
    def NextHandler(self) -> EvtHandler: ...
    @NextHandler.setter
    def NextHandler(self, value: EvtHandler, /) -> None: ...
    @property
    def PreviousHandler(self) -> EvtHandler: ...
    @PreviousHandler.setter
    def PreviousHandler(self, value: EvtHandler, /) -> None: ...

    def TryBefore(self, event: Event) -> bool:
        """
        TryBefore(event) -> bool
        
        Method called by ProcessEvent() before examining this object event
        tables.
        """

    def TryAfter(self, event: Event) -> bool:
        """
        TryAfter(event) -> bool
        
        Method called by ProcessEvent() as last resort.
        """
# end of class EvtHandler


class EventBlocker(EvtHandler):
    """
    EventBlocker(win, type=-1) -> None
    
    This class is a special event handler which allows discarding any
    event (or a set of event types) directed to a specific window.
    """

    def __init__(self, win: Window, type: EventType=-1) -> None:
        """
        EventBlocker(win, type=-1) -> None
        
        This class is a special event handler which allows discarding any
        event (or a set of event types) directed to a specific window.
        """

    def Block(self, eventType: EventType) -> None:
        """
        Block(eventType) -> None
        
        Adds to the list of event types which should be blocked the given
        eventType.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class EventBlocker


class PropagationDisabler:
    """
    PropagationDisabler(event) -> None
    
    Helper class to temporarily change an event to not propagate.
    """

    def __init__(self, event: Event) -> None:
        """
        PropagationDisabler(event) -> None
        
        Helper class to temporarily change an event to not propagate.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class PropagationDisabler


class PropagateOnce:
    """
    PropagateOnce(event) -> None
    
    Helper class to temporarily lower propagation level.
    """

    def __init__(self, event: Event) -> None:
        """
        PropagateOnce(event) -> None
        
        Helper class to temporarily lower propagation level.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class PropagateOnce


class Event(Object):
    """
    Event(id=0, eventType=wxEVT_NULL) -> None
    
    An event is a structure holding information about an event passed to a
    callback or member function.
    """

    def __init__(self, id: int=0, eventType: EventType=wxEVT_NULL) -> None:
        """
        Event(id=0, eventType=wxEVT_NULL) -> None
        
        An event is a structure holding information about an event passed to a
        callback or member function.
        """

    def Clone(self) -> Event:
        """
        Clone() -> Event
        
        Returns a copy of the event.
        """

    def GetEventObject(self) -> Object:
        """
        GetEventObject() -> Object
        
        Returns the object (usually a window) associated with the event, if
        any.
        """

    def GetEventType(self) -> EventType:
        """
        GetEventType() -> EventType
        
        Returns the identifier of the given event type, such as wxEVT_BUTTON.
        """

    def GetEventCategory(self) -> EventCategory:
        """
        GetEventCategory() -> EventCategory
        
        Returns a generic category for this event.
        """

    def GetId(self) -> int:
        """
        GetId() -> int
        
        Returns the identifier associated with this event, such as a button
        command id.
        """

    def GetSkipped(self) -> bool:
        """
        GetSkipped() -> bool
        
        Returns true if the event handler should be skipped, false otherwise.
        """

    def GetTimestamp(self) -> int:
        """
        GetTimestamp() -> int
        
        Gets the timestamp for the event.
        """

    def IsCommandEvent(self) -> bool:
        """
        IsCommandEvent() -> bool
        
        Returns true if the event is or is derived from wxCommandEvent else it
        returns false.
        """

    def ResumePropagation(self, propagationLevel: int) -> None:
        """
        ResumePropagation(propagationLevel) -> None
        
        Sets the propagation level to the given value (for example returned
        from an earlier call to wxEvent::StopPropagation).
        """

    def SetEventObject(self, object: Object) -> None:
        """
        SetEventObject(object) -> None
        
        Sets the originating object.
        """

    def SetEventType(self, type: EventType) -> None:
        """
        SetEventType(type) -> None
        
        Sets the event type.
        """

    def SetId(self, id: int) -> None:
        """
        SetId(id) -> None
        
        Sets the identifier associated with this event, such as a button
        command id.
        """

    def SetTimestamp(self, timeStamp: int=0) -> None:
        """
        SetTimestamp(timeStamp=0) -> None
        
        Sets the timestamp for the event.
        """

    def ShouldPropagate(self) -> bool:
        """
        ShouldPropagate() -> bool
        
        Test if this event should be propagated or not, i.e. if the
        propagation level is currently greater than 0.
        """

    def Skip(self, skip: bool=True) -> None:
        """
        Skip(skip=True) -> None
        
        This method can be used inside an event handler to control whether
        further event handlers bound to this event will be called after the
        current one returns.
        """

    def StopPropagation(self) -> int:
        """
        StopPropagation() -> int
        
        Stop the event from propagating to its parent window.
        """
    @property
    def EventObject(self) -> Object: ...
    @EventObject.setter
    def EventObject(self, value: Object, /) -> None: ...
    @property
    def EventType(self) -> EventType: ...
    @EventType.setter
    def EventType(self, value: EventType, /) -> None: ...
    @property
    def Id(self) -> int: ...
    @Id.setter
    def Id(self, value: int, /) -> None: ...
    @property
    def Skipped(self) -> bool: ...
    @property
    def Timestamp(self) -> int: ...
    @Timestamp.setter
    def Timestamp(self, value: int, /) -> None: ...
# end of class Event


class CommandEvent(Event):
    """
    CommandEvent(commandEventType=wxEVT_NULL, id=0) -> None
    
    This event class contains information about command events, which
    originate from a variety of simple controls.
    """

    def __init__(self, commandEventType: EventType=wxEVT_NULL, id: int=0) -> None:
        """
        CommandEvent(commandEventType=wxEVT_NULL, id=0) -> None
        
        This event class contains information about command events, which
        originate from a variety of simple controls.
        """

    def GetClientData(self) -> ClientData:
        """
        GetClientData() -> ClientData
        
        Returns client object pointer for a listbox or choice selection event
        (not valid for a deselection).
        """

    def GetExtraLong(self) -> int:
        """
        GetExtraLong() -> int
        
        Returns extra information dependent on the event objects type.
        """

    def GetInt(self) -> int:
        """
        GetInt() -> int
        
        Returns the integer identifier corresponding to a listbox, choice or
        radiobox selection (only if the event was a selection, not a
        deselection), or a boolean value representing the value of a checkbox.
        """

    def GetSelection(self) -> int:
        """
        GetSelection() -> int
        
        Returns item index for a listbox or choice selection event (not valid
        for a deselection).
        """

    def GetString(self) -> str:
        """
        GetString() -> str
        
        Returns item string for a listbox or choice selection event.
        """

    def IsChecked(self) -> bool:
        """
        IsChecked() -> bool
        
        This method can be used with checkbox and menu events: for the
        checkboxes, the method returns true for a selection event and false
        for a deselection one.
        """

    def IsSelection(self) -> bool:
        """
        IsSelection() -> bool
        
        For a listbox or similar event, returns true if it is a selection,
        false if it is a deselection.
        """

    def SetClientData(self, data: ClientData) -> None:
        """
        SetClientData(data) -> None
        
        Sets the client object for this event.
        """

    def SetExtraLong(self, extraLong: int) -> None:
        """
        SetExtraLong(extraLong) -> None
        
        Sets the m_extraLong member.
        """

    def SetInt(self, intCommand: int) -> None:
        """
        SetInt(intCommand) -> None
        
        Sets the m_commandInt member.
        """

    def SetString(self, string: str) -> None:
        """
        SetString(string) -> None
        
        Sets the m_commandString member.
        """

    def GetClientObject(self):
        """
        Alias for :meth:`GetClientData`
        """

    def SetClientObject(self, data):
        """
        Alias for :meth:`SetClientData`
        """
    ClientData = property(GetClientData, SetClientData)
    @property
    def ExtraLong(self) -> int: ...
    @ExtraLong.setter
    def ExtraLong(self, value: int, /) -> None: ...
    @property
    def Int(self) -> int: ...
    @Int.setter
    def Int(self, value: int, /) -> None: ...
    @property
    def Selection(self) -> int: ...
    @property
    def String(self) -> str: ...
    @String.setter
    def String(self, value: str, /) -> None: ...
# end of class CommandEvent


class ActivateEvent(Event):
    """
    ActivateEvent(eventType=wxEVT_NULL, active=True, id=0, ActivationReason=Reason_Unknown) -> None
    
    An activate event is sent when a window or application is being
    activated or deactivated.
    """

    class _Reason(IntEnum):
        Reason_Mouse = auto()
        Reason_Unknown = auto()
    Reason: TypeAlias = Union[_Reason, int]
    Reason_Mouse = _Reason.Reason_Mouse
    Reason_Unknown = _Reason.Reason_Unknown

    def __init__(self, eventType: EventType=wxEVT_NULL, active: bool=True, id: int=0, ActivationReason: Reason=Reason_Unknown) -> None:
        """
        ActivateEvent(eventType=wxEVT_NULL, active=True, id=0, ActivationReason=Reason_Unknown) -> None
        
        An activate event is sent when a window or application is being
        activated or deactivated.
        """

    def GetActive(self) -> bool:
        """
        GetActive() -> bool
        
        Returns true if the application or window is being activated, false
        otherwise.
        """

    def GetActivationReason(self) -> Reason:
        """
        GetActivationReason() -> Reason
        
        Allows checking if the window was activated by clicking it with the
        mouse or in some other way.
        """
    @property
    def Active(self) -> bool: ...
# end of class ActivateEvent


class ChildFocusEvent(CommandEvent):
    """
    ChildFocusEvent(win=None) -> None
    
    A child focus event is sent to a (parent-)window when one of its child
    windows gains focus, so that the window could restore the focus back
    to its corresponding child if it loses it now and regains later.
    """

    def __init__(self, win: Optional[Window]=None) -> None:
        """
        ChildFocusEvent(win=None) -> None
        
        A child focus event is sent to a (parent-)window when one of its child
        windows gains focus, so that the window could restore the focus back
        to its corresponding child if it loses it now and regains later.
        """

    def GetWindow(self) -> Window:
        """
        GetWindow() -> Window
        
        Returns the direct child which receives the focus, or a (grand-)parent
        of the control receiving the focus.
        """
    @property
    def Window(self) -> Window: ...
# end of class ChildFocusEvent


class ClipboardTextEvent(CommandEvent):
    """
    ClipboardTextEvent(commandType=wxEVT_NULL, id=0) -> None
    
    This class represents the events generated by a control (typically a
    wxTextCtrl but other windows can generate these events as well) when
    its content gets copied or cut to, or pasted from the clipboard.
    """

    def __init__(self, commandType: EventType=wxEVT_NULL, id: int=0) -> None:
        """
        ClipboardTextEvent(commandType=wxEVT_NULL, id=0) -> None
        
        This class represents the events generated by a control (typically a
        wxTextCtrl but other windows can generate these events as well) when
        its content gets copied or cut to, or pasted from the clipboard.
        """
# end of class ClipboardTextEvent


class CloseEvent(Event):
    """
    CloseEvent(commandEventType=wxEVT_NULL, id=0) -> None
    
    This event class contains information about window and session close
    events.
    """

    def __init__(self, commandEventType: EventType=wxEVT_NULL, id: int=0) -> None:
        """
        CloseEvent(commandEventType=wxEVT_NULL, id=0) -> None
        
        This event class contains information about window and session close
        events.
        """

    def CanVeto(self) -> bool:
        """
        CanVeto() -> bool
        
        Returns true if you can veto a system shutdown or a window close
        event.
        """

    def GetLoggingOff(self) -> bool:
        """
        GetLoggingOff() -> bool
        
        Returns true if the user is just logging off or false if the system is
        shutting down.
        """

    def SetCanVeto(self, canVeto: bool) -> None:
        """
        SetCanVeto(canVeto) -> None
        
        Sets the 'can veto' flag.
        """

    def SetLoggingOff(self, loggingOff: bool) -> None:
        """
        SetLoggingOff(loggingOff) -> None
        
        Sets the 'logging off' flag.
        """

    def Veto(self, veto: bool=True) -> None:
        """
        Veto(veto=True) -> None
        
        Call this from your event handler to veto a system shutdown or to
        signal to the calling application that a window close did not happen.
        """

    def GetVeto(self) -> bool:
        """
        GetVeto() -> bool
        
        Returns whether the Veto flag was set.
        """
    @property
    def LoggingOff(self) -> bool: ...
    @LoggingOff.setter
    def LoggingOff(self, value: bool, /) -> None: ...
# end of class CloseEvent


class ContextMenuEvent(CommandEvent):
    """
    ContextMenuEvent(type=wxEVT_NULL, id=0, pos=DefaultPosition) -> None
    
    This class is used for context menu events, sent to give the
    application a chance to show a context (popup) menu for a wxWindow.
    """

    def __init__(self, type: EventType=wxEVT_NULL, id: int=0, pos: Point=DefaultPosition) -> None:
        """
        ContextMenuEvent(type=wxEVT_NULL, id=0, pos=DefaultPosition) -> None
        
        This class is used for context menu events, sent to give the
        application a chance to show a context (popup) menu for a wxWindow.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Returns the position in screen coordinates at which the menu should be
        shown.
        """

    def SetPosition(self, point: Point) -> None:
        """
        SetPosition(point) -> None
        
        Sets the position at which the menu should be shown.
        """
    @property
    def Position(self) -> Point: ...
    @Position.setter
    def Position(self, value: Point, /) -> None: ...
# end of class ContextMenuEvent


class DisplayChangedEvent(Event):
    """
    DisplayChangedEvent() -> None
    
    A display changed event is sent to top-level windows when the display
    resolution has changed.
    """

    def __init__(self) -> None:
        """
        DisplayChangedEvent() -> None
        
        A display changed event is sent to top-level windows when the display
        resolution has changed.
        """
# end of class DisplayChangedEvent


class DPIChangedEvent(Event):
    """
    Event sent when the display scale factor or pixel density (measured in
    dots-per-inch, or DPI) of the monitor a window is on changes.
    """

    def GetOldDPI(self) -> Size:
        """
        GetOldDPI() -> Size
        
        Returns the old DPI.
        """

    def GetNewDPI(self) -> Size:
        """
        GetNewDPI() -> Size
        
        Returns the new DPI.
        """

    def Scale(self, sz: Size) -> Size:
        """
        Scale(sz) -> Size
        
        Rescale a value in pixels to match the new DPI.
        """

    def ScaleX(self, x: int) -> int:
        """
        ScaleX(x) -> int
        
        Rescale horizontal component to match the new DPI.
        """

    def ScaleY(self, y: int) -> int:
        """
        ScaleY(y) -> int
        
        Rescale vertical component to match the new DPI.
        """
    @property
    def NewDPI(self) -> Size: ...
    @property
    def OldDPI(self) -> Size: ...
# end of class DPIChangedEvent


class DropFilesEvent(Event):
    """
    DropFilesEvent(id=0, files=None) -> None
    
    This class is used for drop files events, that is, when files have
    been dropped onto the window.
    """

    def __init__(self, id: EventType=0, files: Optional[str]=None) -> None:
        """
        DropFilesEvent(id=0, files=None) -> None
        
        This class is used for drop files events, that is, when files have
        been dropped onto the window.
        """

    def GetFiles(self) -> Any:
        """
        GetFiles() -> Any
        
        Returns an array of filenames.
        """

    def GetNumberOfFiles(self) -> int:
        """
        GetNumberOfFiles() -> int
        
        Returns the number of files dropped.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Returns the position at which the files were dropped.
        """
    @property
    def Files(self) -> Any: ...
    @property
    def NumberOfFiles(self) -> int: ...
    @property
    def Position(self) -> Point: ...
# end of class DropFilesEvent


class EraseEvent(Event):
    """
    EraseEvent(id=0, dc=None) -> None
    
    An erase event is sent when a window's background needs to be
    repainted.
    """

    def __init__(self, id: int=0, dc: Optional[DC]=None) -> None:
        """
        EraseEvent(id=0, dc=None) -> None
        
        An erase event is sent when a window's background needs to be
        repainted.
        """

    def GetDC(self) -> DC:
        """
        GetDC() -> DC
        
        Returns the device context associated with the erase event to draw on.
        """
    @property
    def DC(self) -> DC: ...
# end of class EraseEvent


class FocusEvent(Event):
    """
    FocusEvent(eventType=wxEVT_NULL, id=0) -> None
    
    A focus event is sent when a window's focus changes.
    """

    def __init__(self, eventType: EventType=wxEVT_NULL, id: int=0) -> None:
        """
        FocusEvent(eventType=wxEVT_NULL, id=0) -> None
        
        A focus event is sent when a window's focus changes.
        """

    def GetWindow(self) -> Window:
        """
        GetWindow() -> Window
        
        Returns the window associated with this event, that is the window
        which had the focus before for the wxEVT_SET_FOCUS event and the
        window which is going to receive focus for the wxEVT_KILL_FOCUS one.
        """

    def SetWindow(self, win: Window) -> None:
        """
        SetWindow(win) -> None
        """
    @property
    def Window(self) -> Window: ...
    @Window.setter
    def Window(self, value: Window, /) -> None: ...
# end of class FocusEvent


class HelpEvent(CommandEvent):
    """
    HelpEvent(type=wxEVT_NULL, winid=0, pt=DefaultPosition, origin=Origin_Unknown) -> None
    
    A help event is sent when the user has requested context-sensitive
    help.
    """

    class _Origin(IntEnum):
        Origin_Unknown = auto()
        Origin_Keyboard = auto()
        Origin_HelpButton = auto()
    Origin: TypeAlias = Union[_Origin, int]
    Origin_Unknown = _Origin.Origin_Unknown
    Origin_Keyboard = _Origin.Origin_Keyboard
    Origin_HelpButton = _Origin.Origin_HelpButton

    def __init__(self, type: EventType=wxEVT_NULL, winid: int=0, pt: Point=DefaultPosition, origin: HelpEvent.Origin=Origin_Unknown) -> None:
        """
        HelpEvent(type=wxEVT_NULL, winid=0, pt=DefaultPosition, origin=Origin_Unknown) -> None
        
        A help event is sent when the user has requested context-sensitive
        help.
        """

    def GetOrigin(self) -> HelpEvent.Origin:
        """
        GetOrigin() -> HelpEvent.Origin
        
        Returns the origin of the help event which is one of the
        wxHelpEvent::Origin values.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Returns the left-click position of the mouse, in screen coordinates.
        """

    def SetOrigin(self, origin: HelpEvent.Origin) -> None:
        """
        SetOrigin(origin) -> None
        
        Set the help event origin, only used internally by wxWidgets normally.
        """

    def SetPosition(self, pt: Point) -> None:
        """
        SetPosition(pt) -> None
        
        Sets the left-click position of the mouse, in screen coordinates.
        """
    @property
    def Position(self) -> Point: ...
    @Position.setter
    def Position(self, value: Point, /) -> None: ...
# end of class HelpEvent


class IconizeEvent(Event):
    """
    IconizeEvent(id=0, iconized=True) -> None
    
    An event being sent when the frame is iconized (minimized) or
    restored.
    """

    def __init__(self, id: int=0, iconized: bool=True) -> None:
        """
        IconizeEvent(id=0, iconized=True) -> None
        
        An event being sent when the frame is iconized (minimized) or
        restored.
        """

    def IsIconized(self) -> bool:
        """
        IsIconized() -> bool
        
        Returns true if the frame has been iconized, false if it has been
        restored.
        """
# end of class IconizeEvent


class IdleEvent(Event):
    """
    IdleEvent() -> None
    
    This class is used for idle events, which are generated when the
    system becomes idle.
    """

    def __init__(self) -> None:
        """
        IdleEvent() -> None
        
        This class is used for idle events, which are generated when the
        system becomes idle.
        """

    def MoreRequested(self) -> bool:
        """
        MoreRequested() -> bool
        
        Returns true if the OnIdle function processing this event requested
        more processing time.
        """

    def RequestMore(self, needMore: bool=True) -> None:
        """
        RequestMore(needMore=True) -> None
        
        Tells wxWidgets that more processing is required.
        """

    @staticmethod
    def GetMode() -> IdleMode:
        """
        GetMode() -> IdleMode
        
        Static function returning a value specifying how wxWidgets will send
        idle events: to all windows, or only to those which specify that they
        will process the events.
        """

    @staticmethod
    def SetMode(mode: IdleMode) -> None:
        """
        SetMode(mode) -> None
        
        Static function for specifying how wxWidgets will send idle events: to
        all windows, or only to those which specify that they will process the
        events.
        """
# end of class IdleEvent


class InitDialogEvent(Event):
    """
    InitDialogEvent(id=0) -> None
    
    A wxInitDialogEvent is sent as a dialog or panel is being initialised.
    """

    def __init__(self, id: int=0) -> None:
        """
        InitDialogEvent(id=0) -> None
        
        A wxInitDialogEvent is sent as a dialog or panel is being initialised.
        """
# end of class InitDialogEvent


class JoystickEvent(Event):
    """
    JoystickEvent(eventType=wxEVT_NULL, state=0, joystick=JOYSTICK1, change=0) -> None
    
    This event class contains information about joystick events,
    particularly events received by windows.
    """

    def __init__(self, eventType: EventType=wxEVT_NULL, state: int=0, joystick: int=JOYSTICK1, change: int=0) -> None:
        """
        JoystickEvent(eventType=wxEVT_NULL, state=0, joystick=JOYSTICK1, change=0) -> None
        
        This event class contains information about joystick events,
        particularly events received by windows.
        """

    def ButtonDown(self, button: int=JOY_BUTTON_ANY) -> bool:
        """
        ButtonDown(button=JOY_BUTTON_ANY) -> bool
        
        Returns true if the event was a down event from the specified button
        (or any button).
        """

    def ButtonIsDown(self, button: int=JOY_BUTTON_ANY) -> bool:
        """
        ButtonIsDown(button=JOY_BUTTON_ANY) -> bool
        
        Returns true if the specified button (or any button) was in a down
        state.
        """

    def ButtonUp(self, button: int=JOY_BUTTON_ANY) -> bool:
        """
        ButtonUp(button=JOY_BUTTON_ANY) -> bool
        
        Returns true if the event was an up event from the specified button
        (or any button).
        """

    def GetButtonChange(self) -> int:
        """
        GetButtonChange() -> int
        
        Returns the identifier of the button changing state.
        """

    def GetButtonOrdinal(self) -> int:
        """
        GetButtonOrdinal() -> int
        
        Returns the 0-indexed ordinal of the button changing state.
        """

    def GetButtonState(self) -> int:
        """
        GetButtonState() -> int
        
        Returns the down state of the buttons.
        """

    def GetJoystick(self) -> int:
        """
        GetJoystick() -> int
        
        Returns the identifier of the joystick generating the event - one of
        wxJOYSTICK1 and wxJOYSTICK2.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Returns the x, y position of the joystick event.
        """

    def GetZPosition(self) -> int:
        """
        GetZPosition() -> int
        
        Returns the z position of the joystick event.
        """

    def IsButton(self) -> bool:
        """
        IsButton() -> bool
        
        Returns true if this was a button up or down event (not 'is any button
        down?
        """

    def IsMove(self) -> bool:
        """
        IsMove() -> bool
        
        Returns true if this was an x, y move event.
        """

    def IsZMove(self) -> bool:
        """
        IsZMove() -> bool
        
        Returns true if this was a z move event.
        """
    @property
    def ButtonChange(self) -> int: ...
    @property
    def ButtonOrdinal(self) -> int: ...
    @property
    def ButtonState(self) -> int: ...
    @property
    def Joystick(self) -> int: ...
    @property
    def Position(self) -> Point: ...
    @property
    def ZPosition(self) -> int: ...
# end of class JoystickEvent


class KeyEvent(Event, KeyboardState):
    """
    KeyEvent(keyEventType=wxEVT_NULL) -> None
    
    This event class contains information about key press and release
    events.
    """

    def __init__(self, keyEventType: EventType=wxEVT_NULL) -> None:
        """
        KeyEvent(keyEventType=wxEVT_NULL) -> None
        
        This event class contains information about key press and release
        events.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Obtains the position (in client coordinates) at which the key was
        pressed.
        """

    def GetKeyCode(self) -> int:
        """
        GetKeyCode() -> int
        
        Returns the key code of the key that generated this event.
        """

    def IsKeyInCategory(self, category: int) -> bool:
        """
        IsKeyInCategory(category) -> bool
        
        Returns true if the key is in the given key category.
        """

    def IsAutoRepeat(self) -> bool:
        """
        IsAutoRepeat() -> bool
        
        Returns true if this event is an auto-repeat of the key, false if this
        is the initial key press.
        """

    def GetRawKeyCode(self) -> Uint32:
        """
        GetRawKeyCode() -> Uint32
        
        Returns the raw key code for this event.
        """

    def GetRawKeyFlags(self) -> Uint32:
        """
        GetRawKeyFlags() -> Uint32
        
        Returns the low level key flags for this event.
        """

    def GetUnicodeKey(self) -> int:
        """
        GetUnicodeKey() -> int
        
        Returns the Unicode character corresponding to this key event.
        """

    def GetX(self) -> int:
        """
        GetX() -> int
        
        Returns the X position (in client coordinates) of the event.
        """

    def GetY(self) -> int:
        """
        GetY() -> int
        
        Returns the Y position (in client coordinates) of the event.
        """

    def DoAllowNextEvent(self) -> None:
        """
        DoAllowNextEvent() -> None
        
        Allow normal key events generation.
        """

    def IsNextEventAllowed(self) -> bool:
        """
        IsNextEventAllowed() -> bool
        
        Returns true if DoAllowNextEvent() had been called, false by default.
        """

    def SetKeyCode(self, keyCode: int) -> None:
        """
        SetKeyCode(keyCode) -> None
        """

    def SetRawKeyCode(self, rawKeyCode: int) -> None:
        """
        SetRawKeyCode(rawKeyCode) -> None
        """

    def SetRawKeyFlags(self, rawFlags: int) -> None:
        """
        SetRawKeyFlags(rawFlags) -> None
        """

    def SetUnicodeKey(self, uniChar: int) -> None:
        """
        SetUnicodeKey(uniChar) -> None
        """
    @property
    def X(self) -> int: ...
    @property
    def Y(self) -> int: ...
    @property
    def KeyCode(self) -> int: ...
    @KeyCode.setter
    def KeyCode(self, value: int, /) -> None: ...
    @property
    def Position(self) -> Point: ...
    @property
    def RawKeyCode(self) -> int: ...
    @RawKeyCode.setter
    def RawKeyCode(self, value: int, /) -> None: ...
    @property
    def RawKeyFlags(self) -> int: ...
    @RawKeyFlags.setter
    def RawKeyFlags(self, value: int, /) -> None: ...
    @property
    def UnicodeKey(self) -> int: ...
    @UnicodeKey.setter
    def UnicodeKey(self, value: int, /) -> None: ...
# end of class KeyEvent


class MaximizeEvent(Event):
    """
    MaximizeEvent(id=0) -> None
    
    An event being sent when a top level window is maximized.
    """

    def __init__(self, id: int=0) -> None:
        """
        MaximizeEvent(id=0) -> None
        
        An event being sent when a top level window is maximized.
        """
# end of class MaximizeEvent


class FullScreenEvent(Event):
    """
    FullScreenEvent(id=0, fullscreen=True) -> None
    
    An event being sent when the user enters or exits full screen mode.
    """

    def __init__(self, id: int=0, fullscreen: bool=True) -> None:
        """
        FullScreenEvent(id=0, fullscreen=True) -> None
        
        An event being sent when the user enters or exits full screen mode.
        """

    def IsFullScreen(self) -> bool:
        """
        IsFullScreen() -> bool
        
        Returns true if the frame entered full screen, false if exited full
        screen.
        """
# end of class FullScreenEvent


class MenuEvent(Event):
    """
    MenuEvent(type=wxEVT_NULL, id=0, menu=None) -> None
    
    This class is used for a variety of menu-related events.
    """

    def __init__(self, type: EventType=wxEVT_NULL, id: int=0, menu: Optional[Menu]=None) -> None:
        """
        MenuEvent(type=wxEVT_NULL, id=0, menu=None) -> None
        
        This class is used for a variety of menu-related events.
        """

    def GetMenu(self) -> Menu:
        """
        GetMenu() -> Menu
        
        Returns the menu which is being opened or closed, or the menu
        containing the highlighted item.
        """

    def GetMenuId(self) -> int:
        """
        GetMenuId() -> int
        
        Returns the menu identifier associated with the event.
        """

    def IsPopup(self) -> bool:
        """
        IsPopup() -> bool
        
        Returns true if the menu which is being opened or closed is a popup
        menu, false if it is a normal one.
        """
    @property
    def Menu(self) -> Menu: ...
    @property
    def MenuId(self) -> int: ...
# end of class MenuEvent


class MouseCaptureChangedEvent(Event):
    """
    MouseCaptureChangedEvent(windowId=0, gainedCapture=None) -> None
    
    A mouse capture changed event is sent to a window that loses its mouse
    capture.
    """

    def __init__(self, windowId: int=0, gainedCapture: Optional[Window]=None) -> None:
        """
        MouseCaptureChangedEvent(windowId=0, gainedCapture=None) -> None
        
        A mouse capture changed event is sent to a window that loses its mouse
        capture.
        """

    def GetCapturedWindow(self) -> Window:
        """
        GetCapturedWindow() -> Window
        
        Returns the window that gained the capture, or NULL if it was a non-
        wxWidgets window.
        """
    @property
    def CapturedWindow(self) -> Window: ...
# end of class MouseCaptureChangedEvent


class MouseCaptureLostEvent(Event):
    """
    MouseCaptureLostEvent(windowId=0) -> None
    
    A mouse capture lost event is sent to a window that had obtained mouse
    capture, which was subsequently lost due to an "external" event (for
    example, when a dialog box is shown or if another application captures
    the mouse).
    """

    def __init__(self, windowId: int=0) -> None:
        """
        MouseCaptureLostEvent(windowId=0) -> None
        
        A mouse capture lost event is sent to a window that had obtained mouse
        capture, which was subsequently lost due to an "external" event (for
        example, when a dialog box is shown or if another application captures
        the mouse).
        """
# end of class MouseCaptureLostEvent


class MouseEvent(Event, MouseState):
    """
    MouseEvent(mouseEventType=wxEVT_NULL) -> None
    
    This event class contains information about the events generated by
    the mouse: they include mouse buttons press and release events and
    mouse move events.
    """

    def __init__(self, mouseEventType: EventType=wxEVT_NULL) -> None:
        """
        MouseEvent(mouseEventType=wxEVT_NULL) -> None
        
        This event class contains information about the events generated by
        the mouse: they include mouse buttons press and release events and
        mouse move events.
        """

    def Aux1DClick(self) -> bool:
        """
        Aux1DClick() -> bool
        
        Returns true if the event was a first extra button double click.
        """

    def Aux1Down(self) -> bool:
        """
        Aux1Down() -> bool
        
        Returns true if the first extra button mouse button changed to down.
        """

    def Aux1Up(self) -> bool:
        """
        Aux1Up() -> bool
        
        Returns true if the first extra button mouse button changed to up.
        """

    def Aux2DClick(self) -> bool:
        """
        Aux2DClick() -> bool
        
        Returns true if the event was a second extra button double click.
        """

    def Aux2Down(self) -> bool:
        """
        Aux2Down() -> bool
        
        Returns true if the second extra button mouse button changed to down.
        """

    def Aux2Up(self) -> bool:
        """
        Aux2Up() -> bool
        
        Returns true if the second extra button mouse button changed to up.
        """

    def Button(self, but: MouseButton) -> bool:
        """
        Button(but) -> bool
        
        Returns true if the event was generated by the specified button.
        """

    def ButtonDClick(self, but: MouseButton=MOUSE_BTN_ANY) -> bool:
        """
        ButtonDClick(but=MOUSE_BTN_ANY) -> bool
        
        If the argument is omitted, this returns true if the event was a mouse
        double click event.
        """

    def ButtonDown(self, but: MouseButton=MOUSE_BTN_ANY) -> bool:
        """
        ButtonDown(but=MOUSE_BTN_ANY) -> bool
        
        If the argument is omitted, this returns true if the event was a mouse
        button down event.
        """

    def ButtonUp(self, but: MouseButton=MOUSE_BTN_ANY) -> bool:
        """
        ButtonUp(but=MOUSE_BTN_ANY) -> bool
        
        If the argument is omitted, this returns true if the event was a mouse
        button up event.
        """

    def Dragging(self) -> bool:
        """
        Dragging() -> bool
        
        Returns true if this was a dragging event (motion while a button is
        depressed).
        """

    def Entering(self) -> bool:
        """
        Entering() -> bool
        
        Returns true if the mouse was entering the window.
        """

    def GetButton(self) -> int:
        """
        GetButton() -> int
        
        Returns the mouse button which generated this event or
        wxMOUSE_BTN_NONE if no button is involved (for mouse move, enter or
        leave event, for example).
        """

    def GetClickCount(self) -> int:
        """
        GetClickCount() -> int
        
        Returns the number of mouse clicks for this event: 1 for a simple
        click, 2 for a double-click, 3 for a triple-click and so on.
        """

    def GetLinesPerAction(self) -> int:
        """
        GetLinesPerAction() -> int
        
        Returns the configured number of lines (or whatever) to be scrolled
        per wheel action.
        """

    def GetColumnsPerAction(self) -> int:
        """
        GetColumnsPerAction() -> int
        
        Returns the configured number of columns (or whatever) to be scrolled
        per wheel action.
        """

    def GetLogicalPosition(self, dc: DC) -> Point:
        """
        GetLogicalPosition(dc) -> Point
        
        Returns the logical mouse position in pixels (i.e. translated
        according to the translation set for the DC, which usually indicates
        that the window has been scrolled).
        """

    def GetMagnification(self) -> float:
        """
        GetMagnification() -> float
        
        For magnify (pinch to zoom) events: returns the change in
        magnification.
        """

    def GetWheelDelta(self) -> int:
        """
        GetWheelDelta() -> int
        
        Get wheel delta, normally 120.
        """

    def IsWheelInverted(self) -> bool:
        """
        IsWheelInverted() -> bool
        
        On Mac, has the user selected "Natural" scrolling in their System
        Preferences?
        """

    def GetWheelRotation(self) -> int:
        """
        GetWheelRotation() -> int
        
        Get wheel rotation, positive or negative indicates direction of
        rotation.
        """

    def GetWheelAxis(self) -> MouseWheelAxis:
        """
        GetWheelAxis() -> MouseWheelAxis
        
        Gets the axis the wheel operation concerns.
        """

    def IsButton(self) -> bool:
        """
        IsButton() -> bool
        
        Returns true if the event was a mouse button event (not necessarily a
        button down event - that may be tested using ButtonDown()).
        """

    def IsPageScroll(self) -> bool:
        """
        IsPageScroll() -> bool
        
        Returns true if the system has been setup to do page scrolling with
        the mouse wheel instead of line scrolling.
        """

    def Leaving(self) -> bool:
        """
        Leaving() -> bool
        
        Returns true if the mouse was leaving the window.
        """

    def LeftDClick(self) -> bool:
        """
        LeftDClick() -> bool
        
        Returns true if the event was a left double click.
        """

    def LeftDown(self) -> bool:
        """
        LeftDown() -> bool
        
        Returns true if the left mouse button changed to down.
        """

    def LeftUp(self) -> bool:
        """
        LeftUp() -> bool
        
        Returns true if the left mouse button changed to up.
        """

    def Magnify(self) -> bool:
        """
        Magnify() -> bool
        
        Returns true if the event is a magnify (i.e. pinch to zoom) event.
        """

    def MetaDown(self) -> bool:
        """
        MetaDown() -> bool
        
        Returns true if the Meta key was down at the time of the event.
        """

    def MiddleDClick(self) -> bool:
        """
        MiddleDClick() -> bool
        
        Returns true if the event was a middle double click.
        """

    def MiddleDown(self) -> bool:
        """
        MiddleDown() -> bool
        
        Returns true if the middle mouse button changed to down.
        """

    def MiddleUp(self) -> bool:
        """
        MiddleUp() -> bool
        
        Returns true if the middle mouse button changed to up.
        """

    def Moving(self) -> bool:
        """
        Moving() -> bool
        
        Returns true if this was a motion event and no mouse buttons were
        pressed.
        """

    def RightDClick(self) -> bool:
        """
        RightDClick() -> bool
        
        Returns true if the event was a right double click.
        """

    def RightDown(self) -> bool:
        """
        RightDown() -> bool
        
        Returns true if the right mouse button changed to down.
        """

    def RightUp(self) -> bool:
        """
        RightUp() -> bool
        
        Returns true if the right mouse button changed to up.
        """

    def SetWheelAxis(self, wheelAxis: MouseWheelAxis) -> None:
        """
        SetWheelAxis(wheelAxis) -> None
        """

    def SetWheelRotation(self, wheelRotation: int) -> None:
        """
        SetWheelRotation(wheelRotation) -> None
        """

    def SetWheelDelta(self, wheelDelta: int) -> None:
        """
        SetWheelDelta(wheelDelta) -> None
        """

    def SetLinesPerAction(self, linesPerAction: int) -> None:
        """
        SetLinesPerAction(linesPerAction) -> None
        """

    def SetColumnsPerAction(self, columnsPerAction: int) -> None:
        """
        SetColumnsPerAction(columnsPerAction) -> None
        """
    @property
    def WheelAxis(self) -> MouseWheelAxis: ...
    @WheelAxis.setter
    def WheelAxis(self, value: MouseWheelAxis, /) -> None: ...
    @property
    def WheelRotation(self) -> int: ...
    @WheelRotation.setter
    def WheelRotation(self, value: int, /) -> None: ...
    @property
    def WheelDelta(self) -> int: ...
    @WheelDelta.setter
    def WheelDelta(self, value: int, /) -> None: ...
    @property
    def LinesPerAction(self) -> int: ...
    @LinesPerAction.setter
    def LinesPerAction(self, value: int, /) -> None: ...
    @property
    def ColumnsPerAction(self) -> int: ...
    @ColumnsPerAction.setter
    def ColumnsPerAction(self, value: int, /) -> None: ...
# end of class MouseEvent


class MoveEvent(Event):
    """
    MoveEvent(pt, id=0) -> None
    
    A move event holds information about window position change.
    """

    def __init__(self, pt: Point, id: int=0) -> None:
        """
        MoveEvent(pt, id=0) -> None
        
        A move event holds information about window position change.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Returns the position of the window generating the move change event.
        """

    def GetRect(self) -> Rect:
        """
        GetRect() -> Rect
        """

    def SetRect(self, rect: Rect) -> None:
        """
        SetRect(rect) -> None
        """

    def SetPosition(self, pos: Point) -> None:
        """
        SetPosition(pos) -> None
        """
    @property
    def Rect(self) -> Rect: ...
    @Rect.setter
    def Rect(self, value: Rect, /) -> None: ...
    @property
    def Position(self) -> Point: ...
    @Position.setter
    def Position(self, value: Point, /) -> None: ...
# end of class MoveEvent


class NavigationKeyEvent(Event):
    """
    NavigationKeyEvent() -> None
    NavigationKeyEvent(event) -> None
    
    This event class contains information about navigation events,
    generated by navigation keys such as tab and page down.
    """

    class _NavigationKeyEventFlags(IntFlag):
        IsBackward = auto()
        IsForward = auto()
        WinChange = auto()
        FromTab = auto()
    NavigationKeyEventFlags: TypeAlias = Union[_NavigationKeyEventFlags, int]
    IsBackward = _NavigationKeyEventFlags.IsBackward
    IsForward = _NavigationKeyEventFlags.IsForward
    WinChange = _NavigationKeyEventFlags.WinChange
    FromTab = _NavigationKeyEventFlags.FromTab

    @overload
    def __init__(self, event: NavigationKeyEvent) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        NavigationKeyEvent() -> None
        NavigationKeyEvent(event) -> None
        
        This event class contains information about navigation events,
        generated by navigation keys such as tab and page down.
        """

    def GetCurrentFocus(self) -> Window:
        """
        GetCurrentFocus() -> Window
        
        Returns the child that has the focus, or NULL.
        """

    def GetDirection(self) -> bool:
        """
        GetDirection() -> bool
        
        Returns true if the navigation was in the forward direction.
        """

    def IsFromTab(self) -> bool:
        """
        IsFromTab() -> bool
        
        Returns true if the navigation event was from a tab key.
        """

    def IsWindowChange(self) -> bool:
        """
        IsWindowChange() -> bool
        
        Returns true if the navigation event represents a window change (for
        example, from Ctrl-Page Down in a notebook).
        """

    def SetCurrentFocus(self, currentFocus: Window) -> None:
        """
        SetCurrentFocus(currentFocus) -> None
        
        Sets the current focus window member.
        """

    def SetDirection(self, direction: bool) -> None:
        """
        SetDirection(direction) -> None
        
        Sets the direction to forward if direction is true, or backward if
        false.
        """

    def SetFlags(self, flags: int) -> None:
        """
        SetFlags(flags) -> None
        
        Sets the flags for this event.
        """

    def SetFromTab(self, fromTab: bool) -> None:
        """
        SetFromTab(fromTab) -> None
        
        Marks the navigation event as from a tab key.
        """

    def SetWindowChange(self, windowChange: bool) -> None:
        """
        SetWindowChange(windowChange) -> None
        
        Marks the event as a window change event.
        """
    @property
    def CurrentFocus(self) -> Window: ...
    @CurrentFocus.setter
    def CurrentFocus(self, value: Window, /) -> None: ...
    @property
    def Direction(self) -> bool: ...
    @Direction.setter
    def Direction(self, value: bool, /) -> None: ...
# end of class NavigationKeyEvent


class NotifyEvent(CommandEvent):
    """
    NotifyEvent(eventType=wxEVT_NULL, id=0) -> None
    
    This class is not used by the event handlers by itself, but is a base
    class for other event classes (such as wxBookCtrlEvent).
    """

    def __init__(self, eventType: EventType=wxEVT_NULL, id: int=0) -> None:
        """
        NotifyEvent(eventType=wxEVT_NULL, id=0) -> None
        
        This class is not used by the event handlers by itself, but is a base
        class for other event classes (such as wxBookCtrlEvent).
        """

    def Allow(self) -> None:
        """
        Allow() -> None
        
        This is the opposite of Veto(): it explicitly allows the event to be
        processed.
        """

    def IsAllowed(self) -> bool:
        """
        IsAllowed() -> bool
        
        Returns true if the change is allowed (Veto() hasn't been called) or
        false otherwise (if it was).
        """

    def Veto(self) -> None:
        """
        Veto() -> None
        
        Prevents the change announced by this event from happening.
        """
# end of class NotifyEvent


class PaintEvent(Event):
    """
    PaintEvent(window) -> None
    
    A paint event is sent when a window's contents needs to be repainted.
    """
# end of class PaintEvent


class PaletteChangedEvent(Event):
    """
    PaletteChangedEvent(winid=0) -> None
    """

    def __init__(self, winid: int=0) -> None:
        """
        PaletteChangedEvent(winid=0) -> None
        """

    def SetChangedWindow(self, win: Window) -> None:
        """
        SetChangedWindow(win) -> None
        """

    def GetChangedWindow(self) -> Window:
        """
        GetChangedWindow() -> Window
        """
    @property
    def ChangedWindow(self) -> Window: ...
    @ChangedWindow.setter
    def ChangedWindow(self, value: Window, /) -> None: ...
# end of class PaletteChangedEvent


class QueryNewPaletteEvent(Event):
    """
    QueryNewPaletteEvent(winid=0) -> None
    """

    def __init__(self, winid: int=0) -> None:
        """
        QueryNewPaletteEvent(winid=0) -> None
        """

    def SetPaletteRealized(self, realized: bool) -> None:
        """
        SetPaletteRealized(realized) -> None
        """

    def GetPaletteRealized(self) -> bool:
        """
        GetPaletteRealized() -> bool
        """
    @property
    def PaletteRealized(self) -> bool: ...
    @PaletteRealized.setter
    def PaletteRealized(self, value: bool, /) -> None: ...
# end of class QueryNewPaletteEvent


class ScrollEvent(CommandEvent):
    """
    ScrollEvent(commandType=wxEVT_NULL, id=0, pos=0, orientation=0) -> None
    
    A scroll event holds information about events sent from stand-alone
    scrollbars (see wxScrollBar) and sliders (see wxSlider).
    """

    def __init__(self, commandType: EventType=wxEVT_NULL, id: int=0, pos: int=0, orientation: int=0) -> None:
        """
        ScrollEvent(commandType=wxEVT_NULL, id=0, pos=0, orientation=0) -> None
        
        A scroll event holds information about events sent from stand-alone
        scrollbars (see wxScrollBar) and sliders (see wxSlider).
        """

    def GetOrientation(self) -> int:
        """
        GetOrientation() -> int
        
        Returns wxHORIZONTAL or wxVERTICAL, depending on the orientation of
        the scrollbar.
        """

    def GetPosition(self) -> int:
        """
        GetPosition() -> int
        
        Returns the position of the scrollbar.
        """

    def SetOrientation(self, orient: int) -> None:
        """
        SetOrientation(orient) -> None
        """

    def SetPosition(self, pos: int) -> None:
        """
        SetPosition(pos) -> None
        """
    @property
    def Orientation(self) -> int: ...
    @Orientation.setter
    def Orientation(self, value: int, /) -> None: ...
    @property
    def Position(self) -> int: ...
    @Position.setter
    def Position(self, value: int, /) -> None: ...
# end of class ScrollEvent


class ScrollWinEvent(Event):
    """
    ScrollWinEvent(commandType=wxEVT_NULL, pos=0, orientation=0) -> None
    
    A scroll event holds information about events sent from scrolling
    windows.
    """

    def __init__(self, commandType: EventType=wxEVT_NULL, pos: int=0, orientation: int=0) -> None:
        """
        ScrollWinEvent(commandType=wxEVT_NULL, pos=0, orientation=0) -> None
        
        A scroll event holds information about events sent from scrolling
        windows.
        """

    def GetOrientation(self) -> int:
        """
        GetOrientation() -> int
        
        Returns wxHORIZONTAL or wxVERTICAL, depending on the orientation of
        the scrollbar.
        """

    def GetPosition(self) -> int:
        """
        GetPosition() -> int
        
        Returns the position of the scrollbar for the thumb track and release
        events.
        """

    def SetOrientation(self, orient: int) -> None:
        """
        SetOrientation(orient) -> None
        """

    def SetPosition(self, pos: int) -> None:
        """
        SetPosition(pos) -> None
        """
    @property
    def Orientation(self) -> int: ...
    @Orientation.setter
    def Orientation(self, value: int, /) -> None: ...
    @property
    def Position(self) -> int: ...
    @Position.setter
    def Position(self, value: int, /) -> None: ...
# end of class ScrollWinEvent


class SetCursorEvent(Event):
    """
    SetCursorEvent(x=0, y=0) -> None
    
    A wxSetCursorEvent is generated from wxWindow when the mouse cursor is
    about to be set as a result of mouse motion.
    """

    def __init__(self, x: int=0, y: int=0) -> None:
        """
        SetCursorEvent(x=0, y=0) -> None
        
        A wxSetCursorEvent is generated from wxWindow when the mouse cursor is
        about to be set as a result of mouse motion.
        """

    def GetCursor(self) -> Cursor:
        """
        GetCursor() -> Cursor
        
        Returns a reference to the cursor specified by this event.
        """

    def GetX(self) -> int:
        """
        GetX() -> int
        
        Returns the X coordinate of the mouse in client coordinates.
        """

    def GetY(self) -> int:
        """
        GetY() -> int
        
        Returns the Y coordinate of the mouse in client coordinates.
        """

    def HasCursor(self) -> bool:
        """
        HasCursor() -> bool
        
        Returns true if the cursor specified by this event is a valid cursor.
        """

    def SetCursor(self, cursor: Cursor) -> None:
        """
        SetCursor(cursor) -> None
        
        Sets the cursor associated with this event.
        """
    @property
    def Cursor(self) -> Cursor: ...
    @Cursor.setter
    def Cursor(self, value: Cursor, /) -> None: ...
    @property
    def X(self) -> int: ...
    @property
    def Y(self) -> int: ...
# end of class SetCursorEvent


class ShowEvent(Event):
    """
    ShowEvent(winid=0, show=False) -> None
    
    An event being sent when the window is shown or hidden.
    """

    def __init__(self, winid: int=0, show: bool=False) -> None:
        """
        ShowEvent(winid=0, show=False) -> None
        
        An event being sent when the window is shown or hidden.
        """

    def SetShow(self, show: bool) -> None:
        """
        SetShow(show) -> None
        
        Set whether the windows was shown or hidden.
        """

    def IsShown(self) -> bool:
        """
        IsShown() -> bool
        
        Return true if the window has been shown, false if it has been hidden.
        """
    @property
    def Show(self) -> bool: ...
    @Show.setter
    def Show(self, value: bool, /) -> None: ...
# end of class ShowEvent


class SizeEvent(Event):
    """
    SizeEvent(sz, id=0) -> None
    
    A size event holds information about size change events of wxWindow.
    """

    def __init__(self, sz: Size, id: int=0) -> None:
        """
        SizeEvent(sz, id=0) -> None
        
        A size event holds information about size change events of wxWindow.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Returns the entire size of the window generating the size change
        event.
        """

    def SetSize(self, size: Size) -> None:
        """
        SetSize(size) -> None
        """

    def GetRect(self) -> Rect:
        """
        GetRect() -> Rect
        """

    def SetRect(self, rect: Rect) -> None:
        """
        SetRect(rect) -> None
        """
    @property
    def Rect(self) -> Rect: ...
    @Rect.setter
    def Rect(self, value: Rect, /) -> None: ...
    @property
    def Size(self) -> Size: ...
    @Size.setter
    def Size(self, value: Size, /) -> None: ...
# end of class SizeEvent


class SysColourChangedEvent(Event):
    """
    SysColourChangedEvent() -> None
    
    This class is used for system colour change events, which are
    generated when the user changes the colour settings or when the system
    theme changes (e.g. automatic dark mode switching on macOS).
    """

    def __init__(self) -> None:
        """
        SysColourChangedEvent() -> None
        
        This class is used for system colour change events, which are
        generated when the user changes the colour settings or when the system
        theme changes (e.g. automatic dark mode switching on macOS).
        """
# end of class SysColourChangedEvent


class UpdateUIEvent(CommandEvent):
    """
    UpdateUIEvent(commandId=0) -> None
    
    This class is used for pseudo-events which are called by wxWidgets to
    give an application the chance to update various user interface
    elements.
    """

    def __init__(self, commandId: int=0) -> None:
        """
        UpdateUIEvent(commandId=0) -> None
        
        This class is used for pseudo-events which are called by wxWidgets to
        give an application the chance to update various user interface
        elements.
        """

    def Check(self, check: bool) -> None:
        """
        Check(check) -> None
        
        Check or uncheck the UI element.
        """

    def Enable(self, enable: bool) -> None:
        """
        Enable(enable) -> None
        
        Enable or disable the UI element.
        """

    def GetChecked(self) -> bool:
        """
        GetChecked() -> bool
        
        Returns true if the UI element should be checked.
        """

    def GetEnabled(self) -> bool:
        """
        GetEnabled() -> bool
        
        Returns true if the UI element should be enabled.
        """

    def IsCheckable(self) -> bool:
        """
        IsCheckable() -> bool
        
        Returns true if the UI element can be checked.
        """

    def GetSetChecked(self) -> bool:
        """
        GetSetChecked() -> bool
        
        Returns true if the application has called Check().
        """

    def GetSetEnabled(self) -> bool:
        """
        GetSetEnabled() -> bool
        
        Returns true if the application has called Enable().
        """

    def GetSetShown(self) -> bool:
        """
        GetSetShown() -> bool
        
        Returns true if the application has called Show().
        """

    def GetSetText(self) -> bool:
        """
        GetSetText() -> bool
        
        Returns true if the application has called SetText().
        """

    def GetShown(self) -> bool:
        """
        GetShown() -> bool
        
        Returns true if the UI element should be shown.
        """

    def GetText(self) -> str:
        """
        GetText() -> str
        
        Returns the text that should be set for the UI element.
        """

    def SetText(self, text: str) -> None:
        """
        SetText(text) -> None
        
        Sets the text for this UI element.
        """

    def Show(self, show: bool) -> None:
        """
        Show(show) -> None
        
        Show or hide the UI element.
        """

    @staticmethod
    def CanUpdate(window: Window) -> bool:
        """
        CanUpdate(window) -> bool
        
        Returns true if it is appropriate to update (send UI update events to)
        this window.
        """

    @staticmethod
    def GetMode() -> UpdateUIMode:
        """
        GetMode() -> UpdateUIMode
        
        Static function returning a value specifying how wxWidgets will send
        update events: to all windows, or only to those which specify that
        they will process the events.
        """

    @staticmethod
    def GetUpdateInterval() -> int:
        """
        GetUpdateInterval() -> int
        
        Returns the current interval between updates in milliseconds.
        """

    @staticmethod
    def ResetUpdateTime() -> None:
        """
        ResetUpdateTime() -> None
        
        Used internally to reset the last-updated time to the current time.
        """

    @staticmethod
    def SetMode(mode: UpdateUIMode) -> None:
        """
        SetMode(mode) -> None
        
        Specify how wxWidgets will send update events: to all windows, or only
        to those which specify that they will process the events.
        """

    @staticmethod
    def SetUpdateInterval(updateInterval: int) -> None:
        """
        SetUpdateInterval(updateInterval) -> None
        
        Sets the interval between updates in milliseconds.
        """
    @property
    def Checked(self) -> bool: ...
    @Checked.setter
    def Checked(self, value: bool, /) -> None: ...
    @property
    def Enabled(self) -> bool: ...
    @Enabled.setter
    def Enabled(self, value: bool, /) -> None: ...
    @property
    def Shown(self) -> bool: ...
    @Shown.setter
    def Shown(self, value: bool, /) -> None: ...
    @property
    def Text(self) -> str: ...
    @Text.setter
    def Text(self, value: str, /) -> None: ...
# end of class UpdateUIEvent


class WindowCreateEvent(CommandEvent):
    """
    WindowCreateEvent(win=None) -> None
    
    This event is sent just after the actual window associated with a
    wxWindow object has been created.
    """

    def __init__(self, win: Optional[Window]=None) -> None:
        """
        WindowCreateEvent(win=None) -> None
        
        This event is sent just after the actual window associated with a
        wxWindow object has been created.
        """

    def GetWindow(self) -> Window:
        """
        GetWindow() -> Window
        
        Return the window being created.
        """
    @property
    def Window(self) -> Window: ...
# end of class WindowCreateEvent


class WindowDestroyEvent(CommandEvent):
    """
    WindowDestroyEvent(win=None) -> None
    
    This event is sent as early as possible during the window destruction
    process.
    """

    def __init__(self, win: Optional[Window]=None) -> None:
        """
        WindowDestroyEvent(win=None) -> None
        
        This event is sent as early as possible during the window destruction
        process.
        """

    def GetWindow(self) -> Window:
        """
        GetWindow() -> Window
        
        Return the window being destroyed.
        """
    @property
    def Window(self) -> Window: ...
# end of class WindowDestroyEvent


class GestureEvent(Event):
    """
    GestureEvent(winid=0, type=wxEVT_NULL) -> None
    
    This is the base class for all supported gesture events.
    """

    def __init__(self, winid: int=0, type: EventType=wxEVT_NULL) -> None:
        """
        GestureEvent(winid=0, type=wxEVT_NULL) -> None
        
        This is the base class for all supported gesture events.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Returns the position where the event took effect, in client
        coordinates: position of Pan event, center of zoom for Zoom event,
        center of rotation for Rotate event, center of box formed by 2 fingers
        for Two Finger Tap event and position of the pressed finger for Press
        and Tap Event.
        """

    def IsGestureStart(self) -> bool:
        """
        IsGestureStart() -> bool
        
        Returns true if the event was the first in a gesture sequence.
        """

    def IsGestureEnd(self) -> bool:
        """
        IsGestureEnd() -> bool
        
        Returns true if the event was the last in a gesture sequence.
        """

    def SetPosition(self, pos: Point) -> None:
        """
        SetPosition(pos) -> None
        
        Sets the position where the event took effect, in client coordinates:
        position of Pan event, center of zoom for Zoom event, center of
        rotation for Rotate event.
        """

    def SetGestureStart(self, isStart: bool=True) -> None:
        """
        SetGestureStart(isStart=True) -> None
        
        Sets the event to be the first in a gesture sequence.
        """

    def SetGestureEnd(self, isEnd: bool=True) -> None:
        """
        SetGestureEnd(isEnd=True) -> None
        
        Sets the event to be the last in a gesture sequence.
        """
    @property
    def Position(self) -> Point: ...
    @Position.setter
    def Position(self, value: Point, /) -> None: ...
# end of class GestureEvent


class PanGestureEvent(GestureEvent):
    """
    PanGestureEvent(winid=0) -> None
    
    This event is generated when the user moves a finger on the surface.
    """

    def __init__(self, winid: int=0) -> None:
        """
        PanGestureEvent(winid=0) -> None
        
        This event is generated when the user moves a finger on the surface.
        """

    def GetDelta(self) -> Point:
        """
        GetDelta() -> Point
        
        Returns the distance covered since the previous panning event.
        """

    def SetDelta(self, delta: Point) -> None:
        """
        SetDelta(delta) -> None
        
        Sets the distance covered since the previous panning event.
        """
    @property
    def Delta(self) -> Point: ...
    @Delta.setter
    def Delta(self, value: Point, /) -> None: ...
# end of class PanGestureEvent


class ZoomGestureEvent(GestureEvent):
    """
    ZoomGestureEvent(windid=0) -> None
    
    This event is generated when two fingers pinch the surface to zoom in
    or out.
    """

    def __init__(self, windid: int=0) -> None:
        """
        ZoomGestureEvent(windid=0) -> None
        
        This event is generated when two fingers pinch the surface to zoom in
        or out.
        """

    def GetZoomFactor(self) -> float:
        """
        GetZoomFactor() -> float
        
        Returns the zoom Factor since the gesture started.
        """

    def SetZoomFactor(self, zoomFactor: float) -> None:
        """
        SetZoomFactor(zoomFactor) -> None
        
        Sets the zoom Factor.
        """
    @property
    def ZoomFactor(self) -> float: ...
    @ZoomFactor.setter
    def ZoomFactor(self, value: float, /) -> None: ...
# end of class ZoomGestureEvent


class RotateGestureEvent(GestureEvent):
    """
    RotateGestureEvent(windid=0) -> None
    
    This event is generated when two fingers move in opposite directions
    on the surface.
    """

    def __init__(self, windid: int=0) -> None:
        """
        RotateGestureEvent(windid=0) -> None
        
        This event is generated when two fingers move in opposite directions
        on the surface.
        """

    def GetRotationAngle(self) -> float:
        """
        GetRotationAngle() -> float
        
        Returns the total angle of rotation in radians in clockwise direction
        since the gesture was first started i.e.
        """

    def SetRotationAngle(self, rotationAngle: float) -> None:
        """
        SetRotationAngle(rotationAngle) -> None
        
        Sets the total angle of rotation in radians in clockwise direction
        since the gesture was first started i.e.
        """
    @property
    def RotationAngle(self) -> float: ...
    @RotationAngle.setter
    def RotationAngle(self, value: float, /) -> None: ...
# end of class RotateGestureEvent


class TwoFingerTapEvent(GestureEvent):
    """
    TwoFingerTapEvent(windid=0) -> None
    
    This event is generated when two fingers touch the surface at the same
    time.
    """

    def __init__(self, windid: int=0) -> None:
        """
        TwoFingerTapEvent(windid=0) -> None
        
        This event is generated when two fingers touch the surface at the same
        time.
        """
# end of class TwoFingerTapEvent


class LongPressEvent(GestureEvent):
    """
    LongPressEvent(windid=0) -> None
    
    This event is generated when one finger touches the surface and
    remains stationary.
    """

    def __init__(self, windid: int=0) -> None:
        """
        LongPressEvent(windid=0) -> None
        
        This event is generated when one finger touches the surface and
        remains stationary.
        """
# end of class LongPressEvent


class PressAndTapEvent(GestureEvent):
    """
    PressAndTapEvent(windid=0) -> None
    
    This event is generated when the user press the surface with one
    finger and taps with another.
    """

    def __init__(self, windid: int=0) -> None:
        """
        PressAndTapEvent(windid=0) -> None
        
        This event is generated when the user press the surface with one
        finger and taps with another.
        """
# end of class PressAndTapEvent


class ThreadEvent(Event):
    """
    ThreadEvent(eventType=wxEVT_THREAD, id=ID_ANY) -> None
    
    This class adds some simple functionality to wxEvent to facilitate
    inter-thread communication.
    """

    def __init__(self, eventType: EventType=wxEVT_THREAD, id: int=ID_ANY) -> None:
        """
        ThreadEvent(eventType=wxEVT_THREAD, id=ID_ANY) -> None
        
        This class adds some simple functionality to wxEvent to facilitate
        inter-thread communication.
        """

    def Clone(self) -> Event:
        """
        Clone() -> Event
        
        Clones this event making sure that all internal members which use COW (only m_commandString for now; see Reference Counting) are unshared (see wxObject::UnShare).
        """

    def GetEventCategory(self) -> EventCategory:
        """
        GetEventCategory() -> EventCategory
        
        Returns wxEVT_CATEGORY_THREAD.
        """

    def GetExtraLong(self) -> int:
        """
        GetExtraLong() -> int
        
        Returns extra information integer value.
        """

    def GetInt(self) -> int:
        """
        GetInt() -> int
        
        Returns stored integer value.
        """

    def GetString(self) -> str:
        """
        GetString() -> str
        
        Returns stored string value.
        """

    def SetExtraLong(self, extraLong: int) -> None:
        """
        SetExtraLong(extraLong) -> None
        
        Sets the extra information value.
        """

    def SetInt(self, intCommand: int) -> None:
        """
        SetInt(intCommand) -> None
        
        Sets the integer value.
        """

    def SetString(self, string: str) -> None:
        """
        SetString(string) -> None
        
        Sets the string value.
        """
    @property
    def EventCategory(self) -> EventCategory: ...
    @property
    def ExtraLong(self) -> int: ...
    @ExtraLong.setter
    def ExtraLong(self, value: int, /) -> None: ...
    @property
    def Int(self) -> int: ...
    @Int.setter
    def Int(self, value: int, /) -> None: ...
    @property
    def String(self) -> str: ...
    @String.setter
    def String(self, value: str, /) -> None: ...
# end of class ThreadEvent


def NewEventType() -> EventType:    """
    NewEventType() -> EventType
    
    Generates a new unique event type.
    """

def PostEvent(dest: EvtHandler, event: Event) -> None:    """
    PostEvent(dest, event) -> None
    
    In a GUI application, this function posts event to the specified dest
    object using wxEvtHandler::AddPendingEvent().
    """

def QueueEvent(dest: EvtHandler, event: Event) -> None:    """
    QueueEvent(dest, event) -> None
    
    Queue an event for processing on the given object.
    """
class PyEventBinder(object):
    """
    Instances of this class are used to bind specific events to event handlers.
    """

    def __init__(self, evtType, expectedIDs=0):
        pass

    def Bind(self, target, id1, id2, function):
        """
        Bind this set of event types to target using its Connect() method.
        """
        pass

    def Unbind(self, target, id1, id2, handler=None):
        """
        Remove an event binding.
        """
        pass

    def _getEvtType(self):
        """
        Make it easy to get to the default wxEventType typeID for this
        event binder.
        """
        pass
    typeId = property(_getEvtType)

    @wx.deprecated
    def __call__(self, *args):
        """
        For backwards compatibility with the old ``EVT_*`` functions.
        Should be called with either (window, func), (window, ID,
        func) or (window, ID1, ID2, func) parameters depending on the
        type of the event.
        """
        pass

#-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# This code block was included from src/event_ex.py
# Create some event binders
EVT_SIZE = wx.PyEventBinder( wxEVT_SIZE )
EVT_SIZING = wx.PyEventBinder( wxEVT_SIZING )
EVT_MOVE = wx.PyEventBinder( wxEVT_MOVE )
EVT_MOVING = wx.PyEventBinder( wxEVT_MOVING )
EVT_MOVE_START = wx.PyEventBinder( wxEVT_MOVE_START )
EVT_MOVE_END = wx.PyEventBinder( wxEVT_MOVE_END )
EVT_CLOSE = wx.PyEventBinder( wxEVT_CLOSE_WINDOW )
EVT_END_SESSION = wx.PyEventBinder( wxEVT_END_SESSION )
EVT_QUERY_END_SESSION = wx.PyEventBinder( wxEVT_QUERY_END_SESSION )
EVT_PAINT = wx.PyEventBinder( wxEVT_PAINT )
EVT_NC_PAINT = wx.PyEventBinder( wxEVT_NC_PAINT )
EVT_ERASE_BACKGROUND = wx.PyEventBinder( wxEVT_ERASE_BACKGROUND )
EVT_CHAR = wx.PyEventBinder( wxEVT_CHAR )
EVT_KEY_DOWN = wx.PyEventBinder( wxEVT_KEY_DOWN )
EVT_KEY_UP = wx.PyEventBinder( wxEVT_KEY_UP )
EVT_HOTKEY = wx.PyEventBinder( wxEVT_HOTKEY, 1)
EVT_CHAR_HOOK = wx.PyEventBinder( wxEVT_CHAR_HOOK )
EVT_MENU_OPEN = wx.PyEventBinder( wxEVT_MENU_OPEN )
EVT_MENU_CLOSE = wx.PyEventBinder( wxEVT_MENU_CLOSE )
EVT_MENU_HIGHLIGHT = wx.PyEventBinder( wxEVT_MENU_HIGHLIGHT, 1)
EVT_MENU_HIGHLIGHT_ALL = wx.PyEventBinder( wxEVT_MENU_HIGHLIGHT )
EVT_SET_FOCUS = wx.PyEventBinder( wxEVT_SET_FOCUS )
EVT_KILL_FOCUS = wx.PyEventBinder( wxEVT_KILL_FOCUS )
EVT_CHILD_FOCUS = wx.PyEventBinder( wxEVT_CHILD_FOCUS )
EVT_ACTIVATE = wx.PyEventBinder( wxEVT_ACTIVATE )
EVT_ACTIVATE_APP = wx.PyEventBinder( wxEVT_ACTIVATE_APP )
EVT_HIBERNATE = wx.PyEventBinder( wxEVT_HIBERNATE )
EVT_DROP_FILES = wx.PyEventBinder( wxEVT_DROP_FILES )
EVT_INIT_DIALOG = wx.PyEventBinder( wxEVT_INIT_DIALOG )
EVT_SYS_COLOUR_CHANGED = wx.PyEventBinder( wxEVT_SYS_COLOUR_CHANGED )
EVT_DISPLAY_CHANGED = wx.PyEventBinder( wxEVT_DISPLAY_CHANGED )
EVT_DPI_CHANGED = wx.PyEventBinder( wxEVT_DPI_CHANGED )
EVT_SHOW = wx.PyEventBinder( wxEVT_SHOW )
EVT_MAXIMIZE = wx.PyEventBinder( wxEVT_MAXIMIZE )
EVT_ICONIZE = wx.PyEventBinder( wxEVT_ICONIZE )
EVT_NAVIGATION_KEY = wx.PyEventBinder( wxEVT_NAVIGATION_KEY )
EVT_PALETTE_CHANGED = wx.PyEventBinder( wxEVT_PALETTE_CHANGED )
EVT_QUERY_NEW_PALETTE = wx.PyEventBinder( wxEVT_QUERY_NEW_PALETTE )
EVT_WINDOW_CREATE = wx.PyEventBinder( wxEVT_CREATE )
EVT_WINDOW_DESTROY = wx.PyEventBinder( wxEVT_DESTROY )
EVT_SET_CURSOR = wx.PyEventBinder( wxEVT_SET_CURSOR )
EVT_MOUSE_CAPTURE_CHANGED = wx.PyEventBinder( wxEVT_MOUSE_CAPTURE_CHANGED )
EVT_MOUSE_CAPTURE_LOST = wx.PyEventBinder( wxEVT_MOUSE_CAPTURE_LOST )

EVT_LEFT_DOWN = wx.PyEventBinder( wxEVT_LEFT_DOWN )
EVT_LEFT_UP = wx.PyEventBinder( wxEVT_LEFT_UP )
EVT_MIDDLE_DOWN = wx.PyEventBinder( wxEVT_MIDDLE_DOWN )
EVT_MIDDLE_UP = wx.PyEventBinder( wxEVT_MIDDLE_UP )
EVT_RIGHT_DOWN = wx.PyEventBinder( wxEVT_RIGHT_DOWN )
EVT_RIGHT_UP = wx.PyEventBinder( wxEVT_RIGHT_UP )
EVT_MOTION = wx.PyEventBinder( wxEVT_MOTION )
EVT_LEFT_DCLICK = wx.PyEventBinder( wxEVT_LEFT_DCLICK )
EVT_MIDDLE_DCLICK = wx.PyEventBinder( wxEVT_MIDDLE_DCLICK )
EVT_RIGHT_DCLICK = wx.PyEventBinder( wxEVT_RIGHT_DCLICK )
EVT_LEAVE_WINDOW = wx.PyEventBinder( wxEVT_LEAVE_WINDOW )
EVT_ENTER_WINDOW = wx.PyEventBinder( wxEVT_ENTER_WINDOW )
EVT_MOUSEWHEEL = wx.PyEventBinder( wxEVT_MOUSEWHEEL )
EVT_MOUSE_AUX1_DOWN = wx.PyEventBinder( wxEVT_AUX1_DOWN )
EVT_MOUSE_AUX1_UP = wx.PyEventBinder( wxEVT_AUX1_UP )
EVT_MOUSE_AUX1_DCLICK = wx.PyEventBinder( wxEVT_AUX1_DCLICK )
EVT_MOUSE_AUX2_DOWN = wx.PyEventBinder( wxEVT_AUX2_DOWN )
EVT_MOUSE_AUX2_UP = wx.PyEventBinder( wxEVT_AUX2_UP )
EVT_MOUSE_AUX2_DCLICK = wx.PyEventBinder( wxEVT_AUX2_DCLICK )

EVT_MOUSE_EVENTS = wx.PyEventBinder([ wxEVT_LEFT_DOWN,
                                      wxEVT_LEFT_UP,
                                      wxEVT_MIDDLE_DOWN,
                                      wxEVT_MIDDLE_UP,
                                      wxEVT_RIGHT_DOWN,
                                      wxEVT_RIGHT_UP,
                                      wxEVT_MOTION,
                                      wxEVT_LEFT_DCLICK,
                                      wxEVT_MIDDLE_DCLICK,
                                      wxEVT_RIGHT_DCLICK,
                                      wxEVT_ENTER_WINDOW,
                                      wxEVT_LEAVE_WINDOW,
                                      wxEVT_MOUSEWHEEL,
                                      wxEVT_AUX1_DOWN,
                                      wxEVT_AUX1_UP,
                                      wxEVT_AUX1_DCLICK,
                                      wxEVT_AUX2_DOWN,
                                      wxEVT_AUX2_UP,
                                      wxEVT_AUX2_DCLICK,
                                     ])
EVT_MAGNIFY = wx.PyEventBinder( wxEVT_MAGNIFY )


# Scrolling from wxWindow (sent to wxScrolledWindow)
EVT_SCROLLWIN = wx.PyEventBinder([ wxEVT_SCROLLWIN_TOP,
                                  wxEVT_SCROLLWIN_BOTTOM,
                                  wxEVT_SCROLLWIN_LINEUP,
                                  wxEVT_SCROLLWIN_LINEDOWN,
                                  wxEVT_SCROLLWIN_PAGEUP,
                                  wxEVT_SCROLLWIN_PAGEDOWN,
                                  wxEVT_SCROLLWIN_THUMBTRACK,
                                  wxEVT_SCROLLWIN_THUMBRELEASE,
                                  ])

EVT_SCROLLWIN_TOP = wx.PyEventBinder( wxEVT_SCROLLWIN_TOP )
EVT_SCROLLWIN_BOTTOM = wx.PyEventBinder( wxEVT_SCROLLWIN_BOTTOM )
EVT_SCROLLWIN_LINEUP = wx.PyEventBinder( wxEVT_SCROLLWIN_LINEUP )
EVT_SCROLLWIN_LINEDOWN = wx.PyEventBinder( wxEVT_SCROLLWIN_LINEDOWN )
EVT_SCROLLWIN_PAGEUP = wx.PyEventBinder( wxEVT_SCROLLWIN_PAGEUP )
EVT_SCROLLWIN_PAGEDOWN = wx.PyEventBinder( wxEVT_SCROLLWIN_PAGEDOWN )
EVT_SCROLLWIN_THUMBTRACK = wx.PyEventBinder( wxEVT_SCROLLWIN_THUMBTRACK )
EVT_SCROLLWIN_THUMBRELEASE = wx.PyEventBinder( wxEVT_SCROLLWIN_THUMBRELEASE )

# Scrolling from wx.Slider and wx.ScrollBar
EVT_SCROLL = wx.PyEventBinder([ wxEVT_SCROLL_TOP,
                               wxEVT_SCROLL_BOTTOM,
                               wxEVT_SCROLL_LINEUP,
                               wxEVT_SCROLL_LINEDOWN,
                               wxEVT_SCROLL_PAGEUP,
                               wxEVT_SCROLL_PAGEDOWN,
                               wxEVT_SCROLL_THUMBTRACK,
                               wxEVT_SCROLL_THUMBRELEASE,
                               wxEVT_SCROLL_CHANGED,
                               ])

EVT_SCROLL_TOP = wx.PyEventBinder( wxEVT_SCROLL_TOP )
EVT_SCROLL_BOTTOM = wx.PyEventBinder( wxEVT_SCROLL_BOTTOM )
EVT_SCROLL_LINEUP = wx.PyEventBinder( wxEVT_SCROLL_LINEUP )
EVT_SCROLL_LINEDOWN = wx.PyEventBinder( wxEVT_SCROLL_LINEDOWN )
EVT_SCROLL_PAGEUP = wx.PyEventBinder( wxEVT_SCROLL_PAGEUP )
EVT_SCROLL_PAGEDOWN = wx.PyEventBinder( wxEVT_SCROLL_PAGEDOWN )
EVT_SCROLL_THUMBTRACK = wx.PyEventBinder( wxEVT_SCROLL_THUMBTRACK )
EVT_SCROLL_THUMBRELEASE = wx.PyEventBinder( wxEVT_SCROLL_THUMBRELEASE )
EVT_SCROLL_CHANGED = wx.PyEventBinder( wxEVT_SCROLL_CHANGED )
EVT_SCROLL_ENDSCROLL = EVT_SCROLL_CHANGED

# Scrolling from wx.Slider and wx.ScrollBar, with an id
EVT_COMMAND_SCROLL = wx.PyEventBinder([ wxEVT_SCROLL_TOP,
                                       wxEVT_SCROLL_BOTTOM,
                                       wxEVT_SCROLL_LINEUP,
                                       wxEVT_SCROLL_LINEDOWN,
                                       wxEVT_SCROLL_PAGEUP,
                                       wxEVT_SCROLL_PAGEDOWN,
                                       wxEVT_SCROLL_THUMBTRACK,
                                       wxEVT_SCROLL_THUMBRELEASE,
                                       wxEVT_SCROLL_CHANGED,
                                       ], 1)

EVT_COMMAND_SCROLL_TOP = wx.PyEventBinder( wxEVT_SCROLL_TOP, 1)
EVT_COMMAND_SCROLL_BOTTOM = wx.PyEventBinder( wxEVT_SCROLL_BOTTOM, 1)
EVT_COMMAND_SCROLL_LINEUP = wx.PyEventBinder( wxEVT_SCROLL_LINEUP, 1)
EVT_COMMAND_SCROLL_LINEDOWN = wx.PyEventBinder( wxEVT_SCROLL_LINEDOWN, 1)
EVT_COMMAND_SCROLL_PAGEUP = wx.PyEventBinder( wxEVT_SCROLL_PAGEUP, 1)
EVT_COMMAND_SCROLL_PAGEDOWN = wx.PyEventBinder( wxEVT_SCROLL_PAGEDOWN, 1)
EVT_COMMAND_SCROLL_THUMBTRACK = wx.PyEventBinder( wxEVT_SCROLL_THUMBTRACK, 1)
EVT_COMMAND_SCROLL_THUMBRELEASE = wx.PyEventBinder( wxEVT_SCROLL_THUMBRELEASE, 1)
EVT_COMMAND_SCROLL_CHANGED = wx.PyEventBinder( wxEVT_SCROLL_CHANGED, 1)
EVT_COMMAND_SCROLL_ENDSCROLL = EVT_COMMAND_SCROLL_CHANGED

EVT_BUTTON = wx.PyEventBinder( wxEVT_BUTTON, 1)
EVT_CHECKBOX = wx.PyEventBinder( wxEVT_CHECKBOX, 1)
EVT_CHOICE = wx.PyEventBinder( wxEVT_CHOICE, 1)
EVT_LISTBOX = wx.PyEventBinder( wxEVT_LISTBOX, 1)
EVT_LISTBOX_DCLICK = wx.PyEventBinder( wxEVT_LISTBOX_DCLICK, 1)
EVT_MENU = wx.PyEventBinder( wxEVT_MENU, 1)
EVT_MENU_RANGE = wx.PyEventBinder( wxEVT_MENU, 2)
EVT_SLIDER = wx.PyEventBinder( wxEVT_SLIDER, 1)
EVT_RADIOBOX = wx.PyEventBinder( wxEVT_RADIOBOX, 1)
EVT_RADIOBUTTON = wx.PyEventBinder( wxEVT_RADIOBUTTON, 1)

EVT_SCROLLBAR = wx.PyEventBinder( wxEVT_SCROLLBAR, 1)
EVT_VLBOX = wx.PyEventBinder( wxEVT_VLBOX, 1)
EVT_COMBOBOX = wx.PyEventBinder( wxEVT_COMBOBOX, 1)
EVT_TOOL = wx.PyEventBinder( wxEVT_TOOL, 1)
EVT_TOOL_RANGE = wx.PyEventBinder( wxEVT_TOOL, 2)
EVT_TOOL_RCLICKED = wx.PyEventBinder( wxEVT_TOOL_RCLICKED, 1)
EVT_TOOL_RCLICKED_RANGE = wx.PyEventBinder( wxEVT_TOOL_RCLICKED, 2)
EVT_TOOL_ENTER = wx.PyEventBinder( wxEVT_TOOL_ENTER, 1)
EVT_TOOL_DROPDOWN = wx.PyEventBinder( wxEVT_TOOL_DROPDOWN, 1)
EVT_CHECKLISTBOX = wx.PyEventBinder( wxEVT_CHECKLISTBOX, 1)
EVT_COMBOBOX_DROPDOWN = wx.PyEventBinder( wxEVT_COMBOBOX_DROPDOWN , 1)
EVT_COMBOBOX_CLOSEUP  = wx.PyEventBinder( wxEVT_COMBOBOX_CLOSEUP , 1)

EVT_COMMAND_LEFT_CLICK = wx.PyEventBinder( wxEVT_COMMAND_LEFT_CLICK, 1)
EVT_COMMAND_LEFT_DCLICK = wx.PyEventBinder( wxEVT_COMMAND_LEFT_DCLICK, 1)
EVT_COMMAND_RIGHT_CLICK = wx.PyEventBinder( wxEVT_COMMAND_RIGHT_CLICK, 1)
EVT_COMMAND_RIGHT_DCLICK = wx.PyEventBinder( wxEVT_COMMAND_RIGHT_DCLICK, 1)
EVT_COMMAND_SET_FOCUS = wx.PyEventBinder( wxEVT_COMMAND_SET_FOCUS, 1)
EVT_COMMAND_KILL_FOCUS = wx.PyEventBinder( wxEVT_COMMAND_KILL_FOCUS, 1)
EVT_COMMAND_ENTER = wx.PyEventBinder( wxEVT_COMMAND_ENTER, 1)

EVT_HELP = wx.PyEventBinder( wxEVT_HELP, 1)
EVT_HELP_RANGE = wx.PyEventBinder(  wxEVT_HELP, 2)
EVT_DETAILED_HELP = wx.PyEventBinder( wxEVT_DETAILED_HELP, 1)
EVT_DETAILED_HELP_RANGE = wx.PyEventBinder( wxEVT_DETAILED_HELP, 2)

EVT_IDLE = wx.PyEventBinder( wxEVT_IDLE )

EVT_UPDATE_UI = wx.PyEventBinder( wxEVT_UPDATE_UI, 1)
EVT_UPDATE_UI_RANGE = wx.PyEventBinder( wxEVT_UPDATE_UI, 2)

EVT_CONTEXT_MENU = wx.PyEventBinder( wxEVT_CONTEXT_MENU )

EVT_THREAD = wx.PyEventBinder( wxEVT_THREAD )

EVT_WINDOW_MODAL_DIALOG_CLOSED = wx.PyEventBinder( wxEVT_WINDOW_MODAL_DIALOG_CLOSED )

EVT_JOY_BUTTON_DOWN = wx.PyEventBinder( wxEVT_JOY_BUTTON_DOWN )
EVT_JOY_BUTTON_UP = wx.PyEventBinder( wxEVT_JOY_BUTTON_UP )
EVT_JOY_MOVE = wx.PyEventBinder( wxEVT_JOY_MOVE )
EVT_JOY_ZMOVE = wx.PyEventBinder( wxEVT_JOY_ZMOVE )
EVT_JOYSTICK_EVENTS = wx.PyEventBinder([ wxEVT_JOY_BUTTON_DOWN,
                                        wxEVT_JOY_BUTTON_UP,
                                        wxEVT_JOY_MOVE,
                                        wxEVT_JOY_ZMOVE,
                                        ])

EVT_GESTURE_PAN = wx.PyEventBinder( wxEVT_GESTURE_PAN )
EVT_GESTURE_ZOOM = wx.PyEventBinder( wxEVT_GESTURE_ZOOM )
EVT_GESTURE_ROTATE = wx.PyEventBinder( wxEVT_GESTURE_ROTATE )
EVT_TWO_FINGER_TAP = wx.PyEventBinder( wxEVT_TWO_FINGER_TAP )
EVT_LONG_PRESS = wx.PyEventBinder( wxEVT_LONG_PRESS )
EVT_PRESS_AND_TAP = wx.PyEventBinder( wxEVT_PRESS_AND_TAP )

EVT_CLIPBOARD_CHANGED = wx.PyEventBinder(wxEVT_CLIPBOARD_CHANGED, 1)

EVT_FULLSCREEN = wx.PyEventBinder(wxEVT_FULLSCREEN, 1)

# deprecated wxEVT aliases
wxEVT_COMMAND_BUTTON_CLICKED         = wxEVT_BUTTON
wxEVT_COMMAND_CHECKBOX_CLICKED       = wxEVT_CHECKBOX
wxEVT_COMMAND_CHOICE_SELECTED        = wxEVT_CHOICE
wxEVT_COMMAND_LISTBOX_SELECTED       = wxEVT_LISTBOX
wxEVT_COMMAND_LISTBOX_DOUBLECLICKED  = wxEVT_LISTBOX_DCLICK
wxEVT_COMMAND_CHECKLISTBOX_TOGGLED   = wxEVT_CHECKLISTBOX
wxEVT_COMMAND_MENU_SELECTED          = wxEVT_MENU
wxEVT_COMMAND_TOOL_CLICKED           = wxEVT_TOOL
wxEVT_COMMAND_SLIDER_UPDATED         = wxEVT_SLIDER
wxEVT_COMMAND_RADIOBOX_SELECTED      = wxEVT_RADIOBOX
wxEVT_COMMAND_RADIOBUTTON_SELECTED   = wxEVT_RADIOBUTTON
wxEVT_COMMAND_SCROLLBAR_UPDATED      = wxEVT_SCROLLBAR
wxEVT_COMMAND_VLBOX_SELECTED         = wxEVT_VLBOX
wxEVT_COMMAND_COMBOBOX_SELECTED      = wxEVT_COMBOBOX
wxEVT_COMMAND_TOOL_RCLICKED          = wxEVT_TOOL_RCLICKED
wxEVT_COMMAND_TOOL_DROPDOWN_CLICKED  = wxEVT_TOOL_DROPDOWN
wxEVT_COMMAND_TOOL_ENTER             = wxEVT_TOOL_ENTER
wxEVT_COMMAND_COMBOBOX_DROPDOWN      = wxEVT_COMBOBOX_DROPDOWN
wxEVT_COMMAND_COMBOBOX_CLOSEUP       = wxEVT_COMBOBOX_CLOSEUP

# End of included code block
#-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

PyEvtHandler = wx.deprecated(EvtHandler, "Use :class:`EvtHandler` instead.")
#-- end-event --#
#-- begin-pyevent --#

class PyEvent(Event):
    """
    PyEvent(id=0, eventType=wxEVT_NULL) -> None
    
    :class:`PyEvent` can be used as a base class for implementing custom
    event types in Python. You should derive from this class instead
    of :class:`Event` because this class is Python-aware and is able to
    transport its Python bits safely through the wxWidgets event
    system and have them still be there when the event handler is
    invoked. Note that since :class:`PyEvent` is taking care of preserving
    the extra attributes that have been set then you do not need to
    override the Clone method in your derived classes.
    
    :see: :class:`PyCommandEvent`
    """

    def __init__(self, id: int=0, eventType: EventType=wxEVT_NULL) -> None:
        """
        PyEvent(id=0, eventType=wxEVT_NULL) -> None
        
        :class:`PyEvent` can be used as a base class for implementing custom
        event types in Python. You should derive from this class instead
        of :class:`Event` because this class is Python-aware and is able to
        transport its Python bits safely through the wxWidgets event
        system and have them still be there when the event handler is
        invoked. Note that since :class:`PyEvent` is taking care of preserving
        the extra attributes that have been set then you do not need to
        override the Clone method in your derived classes.
        
        :see: :class:`PyCommandEvent`
        """

    def __getattr__(self, name: Any) -> Any:
        """
        __getattr__(name) -> Any
        """

    def __delattr__(self, name: Any) -> None:
        """
        __delattr__(name) -> None
        """

    def __setattr__(self, name: Any, value: Any) -> None:
        """
        __setattr__(name, value) -> None
        """

    def Clone(self) -> Event:
        """
        Clone() -> Event
        """

    def _getAttrDict(self) -> Any:
        """
        _getAttrDict() -> Any
        
        Gives access to the internal object that is tracking the event's
        python attributes.
        """

    def Clone(self):
        """
        Make a new instance of the event that is a copy of self.
        
        Through the magic of Python this implementation should work for
        this and all derived classes.
        """
# end of class PyEvent


class PyCommandEvent(CommandEvent):
    """
    PyCommandEvent(eventType=wxEVT_NULL, id=0) -> None
    
    :class:`PyCommandEvent` can be used as a base class for implementing
    custom event types in Python. You should derive from this class
    instead of :class:`CommandEvent` because this class is Python-aware
    and is able to transport its Python bits safely through the
    wxWidgets event system and have them still be there when the
    event handler is invoked. Note that since :class:`PyCommandEvent` is
    taking care of preserving the extra attributes that have been set
    then you do not need to override the Clone method in your
    derived classes.
    
    :see: :class:`PyEvent`
    """

    def __init__(self, eventType: EventType=wxEVT_NULL, id: int=0) -> None:
        """
        PyCommandEvent(eventType=wxEVT_NULL, id=0) -> None
        
        :class:`PyCommandEvent` can be used as a base class for implementing
        custom event types in Python. You should derive from this class
        instead of :class:`CommandEvent` because this class is Python-aware
        and is able to transport its Python bits safely through the
        wxWidgets event system and have them still be there when the
        event handler is invoked. Note that since :class:`PyCommandEvent` is
        taking care of preserving the extra attributes that have been set
        then you do not need to override the Clone method in your
        derived classes.
        
        :see: :class:`PyEvent`
        """

    def __getattr__(self, name: Any) -> Any:
        """
        __getattr__(name) -> Any
        """

    def __delattr__(self, name: Any) -> None:
        """
        __delattr__(name) -> None
        """

    def __setattr__(self, name: Any, value: Any) -> None:
        """
        __setattr__(name, value) -> None
        """

    def Clone(self) -> Event:
        """
        Clone() -> Event
        """

    def _getAttrDict(self) -> Any:
        """
        _getAttrDict() -> Any
        
        Gives access to the internal object that is tracking the event's
        python attributes.
        """

    def Clone(self):
        """
        Make a new instance of the event that is a copy of self.
        
        Through the magic of Python this implementation should work for
        this and all derived classes.
        """
# end of class PyCommandEvent

#-- end-pyevent --#
#-- begin-sizer --#

class _FlexSizerGrowMode(IntEnum):
    FLEX_GROWMODE_NONE = auto()
    FLEX_GROWMODE_SPECIFIED = auto()
    FLEX_GROWMODE_ALL = auto()
FlexSizerGrowMode: TypeAlias = Union[_FlexSizerGrowMode, int]
FLEX_GROWMODE_NONE = _FlexSizerGrowMode.FLEX_GROWMODE_NONE
FLEX_GROWMODE_SPECIFIED = _FlexSizerGrowMode.FLEX_GROWMODE_SPECIFIED
FLEX_GROWMODE_ALL = _FlexSizerGrowMode.FLEX_GROWMODE_ALL

class SizerItem(Object):
    """
    SizerItem(window, flags) -> None
    SizerItem(window, proportion=0, flag=0, border=0, userData=None) -> None
    SizerItem(sizer, flags) -> None
    SizerItem(sizer, proportion=0, flag=0, border=0, userData=None) -> None
    SizerItem(width, height, proportion=0, flag=0, border=0, userData=None) -> None
    
    The wxSizerItem class is used to track the position, size and other
    attributes of each item managed by a wxSizer.
    """

    @overload
    def __init__(self, window: Window, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> None:
        ...

    @overload
    def __init__(self, sizer: Sizer, flags: SizerFlags) -> None:
        ...

    @overload
    def __init__(self, sizer: Sizer, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> None:
        ...

    @overload
    def __init__(self, width: int, height: int, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> None:
        ...

    @overload
    def __init__(self, window: Window, flags: SizerFlags) -> None:
        """
        SizerItem(window, flags) -> None
        SizerItem(window, proportion=0, flag=0, border=0, userData=None) -> None
        SizerItem(sizer, flags) -> None
        SizerItem(sizer, proportion=0, flag=0, border=0, userData=None) -> None
        SizerItem(width, height, proportion=0, flag=0, border=0, userData=None) -> None
        
        The wxSizerItem class is used to track the position, size and other
        attributes of each item managed by a wxSizer.
        """

    @overload
    def AssignSpacer(self, w: int, h: int) -> None:
        ...

    @overload
    def AssignSpacer(self, size: Size) -> None:
        """
        AssignSpacer(size) -> None
        AssignSpacer(w, h) -> None
        
        Set the size of the spacer tracked by this item.
        """

    @overload
    def SetRatio(self, size: Size) -> None:
        ...

    @overload
    def SetRatio(self, ratio: float) -> None:
        ...

    @overload
    def SetRatio(self, width: int, height: int) -> None:
        """
        SetRatio(width, height) -> None
        SetRatio(size) -> None
        SetRatio(ratio) -> None
        
        Set the ratio item attribute.
        """

    def AssignWindow(self, window: Window) -> None:
        """
        AssignWindow(window) -> None
        
        Set the window to be tracked by this item.
        """

    def AssignSizer(self, sizer: Sizer) -> None:
        """
        AssignSizer(sizer) -> None
        
        Set the sizer tracked by this item.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        Calculates the minimum desired size for the item, including any space
        needed by borders.
        """

    def DeleteWindows(self) -> None:
        """
        DeleteWindows() -> None
        
        Destroy the window or the windows in a subsizer, depending on the type
        of item.
        """

    def DetachSizer(self) -> None:
        """
        DetachSizer() -> None
        
        Enable deleting the SizerItem without destroying the contained sizer.
        """

    def GetBorder(self) -> int:
        """
        GetBorder() -> int
        
        Return the border attribute.
        """

    def GetFlag(self) -> int:
        """
        GetFlag() -> int
        
        Return the flags attribute.
        """

    def GetId(self) -> int:
        """
        GetId() -> int
        
        Return the numeric id of wxSizerItem, or wxID_NONE if the id has not
        been set.
        """

    def GetMinSize(self) -> Size:
        """
        GetMinSize() -> Size
        
        Get the minimum size needed for the item.
        """

    @overload
    def SetMinSize(self, x: int, y: int) -> None:
        ...

    @overload
    def SetMinSize(self, size: Size) -> None:
        """
        SetMinSize(size) -> None
        SetMinSize(x, y) -> None
        
        Sets the minimum size to be allocated for this item.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        What is the current position of the item, as set in the last Layout.
        """

    def GetProportion(self) -> int:
        """
        GetProportion() -> int
        
        Get the proportion item attribute.
        """

    def GetRatio(self) -> float:
        """
        GetRatio() -> float
        
        Get the ratio item attribute.
        """

    def GetRect(self) -> Rect:
        """
        GetRect() -> Rect
        
        Get the rectangle of the item on the parent window, excluding borders.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Get the current size of the item, as set in the last Layout.
        """

    def GetSizer(self) -> Sizer:
        """
        GetSizer() -> Sizer
        
        If this item is tracking a sizer, return it.
        """

    def GetSpacer(self) -> Size:
        """
        GetSpacer() -> Size
        
        If this item is tracking a spacer, return its size.
        """

    def GetUserData(self) -> PyUserData:
        """
        GetUserData() -> PyUserData
        
        Get the userData item attribute.
        """

    def GetWindow(self) -> Window:
        """
        GetWindow() -> Window
        
        If this item is tracking a window then return it.
        """

    def IsShown(self) -> bool:
        """
        IsShown() -> bool
        
        Returns true if this item is a window or a spacer and it is shown or
        if this item is a sizer and not all of its elements are hidden.
        """

    def IsSizer(self) -> bool:
        """
        IsSizer() -> bool
        
        Is this item a sizer?
        """

    def IsSpacer(self) -> bool:
        """
        IsSpacer() -> bool
        
        Is this item a spacer?
        """

    def IsWindow(self) -> bool:
        """
        IsWindow() -> bool
        
        Is this item a window?
        """

    def SetBorder(self, border: int) -> None:
        """
        SetBorder(border) -> None
        
        Set the border item attribute.
        """

    def SetDimension(self, pos: Point, size: Size) -> None:
        """
        SetDimension(pos, size) -> None
        
        Set the position and size of the space allocated to the sizer, and
        adjust the position and size of the item to be within that space
        taking alignment and borders into account.
        """

    def SetFlag(self, flag: int) -> None:
        """
        SetFlag(flag) -> None
        
        Set the flag item attribute.
        """

    def SetId(self, id: int) -> None:
        """
        SetId(id) -> None
        
        Sets the numeric id of the wxSizerItem to id.
        """

    def SetInitSize(self, x: int, y: int) -> None:
        """
        SetInitSize(x, y) -> None
        
        Sets the minimum size to be allocated for this item.
        """

    def SetProportion(self, proportion: int) -> None:
        """
        SetProportion(proportion) -> None
        
        Set the proportion item attribute.
        """

    def SetUserData(self, userData: PyUserData) -> None:
        """
        SetUserData(userData) -> None
        """

    def Show(self, show: bool) -> None:
        """
        Show(show) -> None
        
        Set the show item attribute, which sizers use to determine if the item
        is to be made part of the layout or not.
        """
    @property
    def Border(self) -> int: ...
    @Border.setter
    def Border(self, value: int, /) -> None: ...
    @property
    def Flag(self) -> int: ...
    @Flag.setter
    def Flag(self, value: int, /) -> None: ...
    @property
    def Id(self) -> int: ...
    @Id.setter
    def Id(self, value: int, /) -> None: ...
    @property
    def MinSize(self) -> Size: ...
    @MinSize.setter
    def MinSize(self, value: Size, /) -> None: ...
    @property
    def Position(self) -> Point: ...
    @property
    def Proportion(self) -> int: ...
    @Proportion.setter
    def Proportion(self, value: int, /) -> None: ...
    @property
    def Ratio(self) -> int: ...
    @Ratio.setter
    def Ratio(self, value: int, /) -> None: ...
    @property
    def Rect(self) -> Rect: ...
    @property
    def Size(self) -> Size: ...
    @property
    def Sizer(self) -> Sizer: ...
    @property
    def Spacer(self) -> Size: ...
    @property
    def UserData(self) -> PyUserData: ...
    @UserData.setter
    def UserData(self, value: PyUserData, /) -> None: ...
    @property
    def Window(self) -> Window: ...
# end of class SizerItem


class SizerFlags:
    """
    SizerFlags(proportion=0) -> None
    
    Container for sizer items flags providing readable names for them.
    """

    def __init__(self, proportion: int=0) -> None:
        """
        SizerFlags(proportion=0) -> None
        
        Container for sizer items flags providing readable names for them.
        """

    def Align(self, alignment: int) -> SizerFlags:
        """
        Align(alignment) -> SizerFlags
        
        Sets the alignment of this wxSizerFlags to align.
        """

    @overload
    def Border(self, direction: int=ALL) -> SizerFlags:
        ...

    @overload
    def Border(self, direction: int, borderinpixels: int) -> SizerFlags:
        """
        Border(direction, borderinpixels) -> SizerFlags
        Border(direction=ALL) -> SizerFlags
        
        Sets the wxSizerFlags to have a border of a number of pixels specified
        by borderinpixels with the directions specified by direction.
        """

    def Bottom(self) -> SizerFlags:
        """
        Bottom() -> SizerFlags
        
        Aligns the object to the bottom, similar for Align(wxALIGN_BOTTOM).
        """

    def Center(self) -> SizerFlags:
        """
        Center() -> SizerFlags
        
        Sets the object of the wxSizerFlags to center itself in the area it is
        given.
        """

    def Centre(self) -> SizerFlags:
        """
        Centre() -> SizerFlags
        
        Center() for people with the other dialect of English.
        """

    def CenterHorizontal(self) -> SizerFlags:
        """
        CenterHorizontal() -> SizerFlags
        
        Same as CentreHorizontal().
        """

    def CenterVertical(self) -> SizerFlags:
        """
        CenterVertical() -> SizerFlags
        
        Same as CentreVertical().
        """

    def CentreHorizontal(self) -> SizerFlags:
        """
        CentreHorizontal() -> SizerFlags
        
        Center an item only in horizontal direction.
        """

    def CentreVertical(self) -> SizerFlags:
        """
        CentreVertical() -> SizerFlags
        
        Center an item only in vertical direction.
        """

    def DoubleBorder(self, direction: int=ALL) -> SizerFlags:
        """
        DoubleBorder(direction=ALL) -> SizerFlags
        
        Sets the border in the given direction having twice the default border
        size.
        """

    def HorzBorder(self) -> SizerFlags:
        """
        HorzBorder() -> SizerFlags
        
        Sets the border in left and right directions having the default border
        size.
        """

    def DoubleHorzBorder(self) -> SizerFlags:
        """
        DoubleHorzBorder() -> SizerFlags
        
        Sets the border in left and right directions having twice the default
        border size.
        """

    def Expand(self) -> SizerFlags:
        """
        Expand() -> SizerFlags
        
        Sets the object of the wxSizerFlags to expand to fill as much area as
        it can.
        """

    def FixedMinSize(self) -> SizerFlags:
        """
        FixedMinSize() -> SizerFlags
        
        Set the wxFIXED_MINSIZE flag which indicates that the initial size of
        the window should be also set as its minimal size.
        """

    def ReserveSpaceEvenIfHidden(self) -> SizerFlags:
        """
        ReserveSpaceEvenIfHidden() -> SizerFlags
        
        Set the wxRESERVE_SPACE_EVEN_IF_HIDDEN flag.
        """

    def Left(self) -> SizerFlags:
        """
        Left() -> SizerFlags
        
        Aligns the object to the left, similar for Align(wxALIGN_LEFT).
        """

    def Proportion(self, proportion: int) -> SizerFlags:
        """
        Proportion(proportion) -> SizerFlags
        
        Sets the proportion of this wxSizerFlags to proportion.
        """

    def Right(self) -> SizerFlags:
        """
        Right() -> SizerFlags
        
        Aligns the object to the right, similar for Align(wxALIGN_RIGHT).
        """

    def Shaped(self) -> SizerFlags:
        """
        Shaped() -> SizerFlags
        
        Sets the wxSHAPED flag which indicates that the elements should always
        keep the fixed width to height ratio equal to its original value.
        """

    def Top(self) -> SizerFlags:
        """
        Top() -> SizerFlags
        
        Aligns the object to the top, similar for Align(wxALIGN_TOP).
        """

    def TripleBorder(self, direction: int=ALL) -> SizerFlags:
        """
        TripleBorder(direction=ALL) -> SizerFlags
        
        Sets the border in the given direction having thrice the default
        border size.
        """

    @staticmethod
    def DisableConsistencyChecks() -> None:
        """
        DisableConsistencyChecks() -> None
        
        Globally disable checks for sizer flag consistency in debug builds.
        """

    @staticmethod
    def GetDefaultBorder() -> int:
        """
        GetDefaultBorder() -> int
        
        Returns the border used by default in Border() method.
        """

    @staticmethod
    def GetDefaultBorderFractional() -> float:
        """
        GetDefaultBorderFractional() -> float
        
        Returns the border used by default, with fractional precision.
        """
# end of class SizerFlags


class Sizer(Object):
    """
    Sizer() -> None
    
    wxSizer is the abstract base class used for laying out subwindows in a
    window.
    """

    def __init__(self) -> None:
        """
        Sizer() -> None
        
        wxSizer is the abstract base class used for laying out subwindows in a
        window.
        """

    def GetChildren(self) -> SizerItemList:
        """
        GetChildren() -> SizerItemList
        
        Returns the list of the items in this sizer.
        """

    @overload
    def SetItemMinSize(self, window: Window, size: Size) -> bool:
        ...

    @overload
    def SetItemMinSize(self, sizer: Sizer, width: int, height: int) -> bool:
        ...

    @overload
    def SetItemMinSize(self, sizer: Sizer, size: Size) -> bool:
        ...

    @overload
    def SetItemMinSize(self, index: int, width: int, height: int) -> bool:
        ...

    @overload
    def SetItemMinSize(self, index: int, size: Size) -> bool:
        ...

    @overload
    def SetItemMinSize(self, window: Window, width: int, height: int) -> bool:
        """
        SetItemMinSize(window, width, height) -> bool
        SetItemMinSize(window, size) -> bool
        SetItemMinSize(sizer, width, height) -> bool
        SetItemMinSize(sizer, size) -> bool
        SetItemMinSize(index, width, height) -> bool
        SetItemMinSize(index, size) -> bool
        
        Set an item's minimum size by window, sizer, or position.
        """

    @overload
    def Add(self, window: Window, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Add(self, sizer: Sizer, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Add(self, sizer: Sizer, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Add(self, width: int, height: int, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Add(self, width: int, height: int, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Add(self, item: SizerItem) -> SizerItem:
        ...

    @overload
    def Add(self, size: Size, proportion: int=0, flag: int=0, border: int=0, Transfer: Optional[PyUserDatauserData]=None) -> SizerItem:
        ...

    @overload
    def Add(self, size: Size, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Add(self, window: Window, flags: SizerFlags) -> SizerItem:
        """
        Add(window, flags) -> SizerItem
        Add(window, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Add(sizer, flags) -> SizerItem
        Add(sizer, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Add(width, height, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Add(width, height, flags) -> SizerItem
        Add(item) -> SizerItem
        Add(size, proportion=0, flag=0, border=0, Transfer=None) -> SizerItem
        Add(size, flags) -> SizerItem
        
        Appends a child to the sizer.
        """

    def AddSpacer(self, size: int) -> SizerItem:
        """
        AddSpacer(size) -> SizerItem
        
        This base function adds non-stretchable space to both the horizontal
        and vertical orientation of the sizer.
        """

    def AddStretchSpacer(self, prop: int=1) -> SizerItem:
        """
        AddStretchSpacer(prop=1) -> SizerItem
        
        Adds stretchable space to the sizer.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        This method is abstract and has to be overwritten by any derived
        class.
        """

    def Clear(self, delete_windows: bool=False) -> None:
        """
        Clear(delete_windows=False) -> None
        
        Detaches all children from the sizer.
        """

    def ComputeFittingClientSize(self, window: Window) -> Size:
        """
        ComputeFittingClientSize(window) -> Size
        
        Computes client area size for window so that it matches the sizer's
        minimal size.
        """

    def ComputeFittingWindowSize(self, window: Window) -> Size:
        """
        ComputeFittingWindowSize(window) -> Size
        
        Like ComputeFittingClientSize(), but converts the result into window
        size.
        """

    @overload
    def Detach(self, sizer: Sizer) -> bool:
        ...

    @overload
    def Detach(self, index: int) -> bool:
        ...

    @overload
    def Detach(self, window: Window) -> bool:
        """
        Detach(window) -> bool
        Detach(sizer) -> bool
        Detach(index) -> bool
        
        Detach the child window from the sizer without destroying it.
        """

    def Fit(self, window: Window) -> Size:
        """
        Fit(window) -> Size
        
        Tell the sizer to resize the window so that its client area matches
        the sizer's minimal size (ComputeFittingClientSize() is called to
        determine it).
        """

    def FitInside(self, window: Window) -> None:
        """
        FitInside(window) -> None
        
        Tell the sizer to resize the virtual size of the window to match the
        sizer's minimal size.
        """

    def InformFirstDirection(self, direction: int, size: int, availableOtherDir: int) -> bool:
        """
        InformFirstDirection(direction, size, availableOtherDir) -> bool
        
        Inform sizer about the first direction that has been decided (by
        parent item).
        """

    def GetContainingWindow(self) -> Window:
        """
        GetContainingWindow() -> Window
        
        Returns the window this sizer is used in or NULL if none.
        """

    def SetContainingWindow(self, window: Window) -> None:
        """
        SetContainingWindow(window) -> None
        
        Set the window this sizer is used in.
        """

    def GetItemCount(self) -> int:
        """
        GetItemCount() -> int
        
        Returns the number of items in the sizer.
        """

    @overload
    def GetItem(self, sizer: Sizer, recursive: bool=False) -> SizerItem:
        ...

    @overload
    def GetItem(self, index: int) -> SizerItem:
        ...

    @overload
    def GetItem(self, window: Window, recursive: bool=False) -> SizerItem:
        """
        GetItem(window, recursive=False) -> SizerItem
        GetItem(sizer, recursive=False) -> SizerItem
        GetItem(index) -> SizerItem
        
        Finds the wxSizerItem which holds the given window.
        """

    def GetItemById(self, id: int, recursive: bool=False) -> SizerItem:
        """
        GetItemById(id, recursive=False) -> SizerItem
        
        Finds the item in the sizer which has the given id.
        """

    def GetMinSize(self) -> Size:
        """
        GetMinSize() -> Size
        
        Returns the minimal size of the sizer.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        Returns the current position of the sizer.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Returns the current size of the sizer.
        """

    @overload
    def Hide(self, sizer: Sizer, recursive: bool=False) -> bool:
        ...

    @overload
    def Hide(self, index: int) -> bool:
        ...

    @overload
    def Hide(self, window: Window, recursive: bool=False) -> bool:
        """
        Hide(window, recursive=False) -> bool
        Hide(sizer, recursive=False) -> bool
        Hide(index) -> bool
        
        Hides the child window.
        """

    @overload
    def Insert(self, index: int, window: Window, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Insert(self, index: int, sizer: Sizer, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Insert(self, index: int, sizer: Sizer, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Insert(self, index: int, width: int, height: int, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Insert(self, index: int, width: int, height: int, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Insert(self, index: int, item: SizerItem) -> SizerItem:
        ...

    @overload
    def Insert(self, index: int, size: Size, proportion: int=0, flag: int=0, border: int=0, Transfer: Optional[PyUserDatauserData]=None) -> SizerItem:
        ...

    @overload
    def Insert(self, index: int, size: Size, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Insert(self, index: int, window: Window, flags: SizerFlags) -> SizerItem:
        """
        Insert(index, window, flags) -> SizerItem
        Insert(index, window, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Insert(index, sizer, flags) -> SizerItem
        Insert(index, sizer, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Insert(index, width, height, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Insert(index, width, height, flags) -> SizerItem
        Insert(index, item) -> SizerItem
        Insert(index, size, proportion=0, flag=0, border=0, Transfer=None) -> SizerItem
        Insert(index, size, flags) -> SizerItem
        
        Insert a child into the sizer before any existing item at index.
        """

    def InsertSpacer(self, index: int, size: int) -> SizerItem:
        """
        InsertSpacer(index, size) -> SizerItem
        
        Inserts non-stretchable space to the sizer.
        """

    def InsertStretchSpacer(self, index: int, prop: int=1) -> SizerItem:
        """
        InsertStretchSpacer(index, prop=1) -> SizerItem
        
        Inserts stretchable space to the sizer.
        """

    def IsEmpty(self) -> bool:
        """
        IsEmpty() -> bool
        
        Return true if the sizer has no elements.
        """

    @overload
    def IsShown(self, sizer: Sizer) -> bool:
        ...

    @overload
    def IsShown(self, index: int) -> bool:
        ...

    @overload
    def IsShown(self, window: Window) -> bool:
        """
        IsShown(window) -> bool
        IsShown(sizer) -> bool
        IsShown(index) -> bool
        
        Returns true if the window is shown.
        """

    def Layout(self) -> None:
        """
        Layout() -> None
        
        Call this to force layout of the children anew, e.g. after having
        added a child to or removed a child (window, other sizer or space)
        from the sizer while keeping the current dimension.
        """

    @overload
    def Prepend(self, window: Window, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Prepend(self, sizer: Sizer, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Prepend(self, sizer: Sizer, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Prepend(self, width: int, height: int, proportion: int=0, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Prepend(self, width: int, height: int, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Prepend(self, item: SizerItem) -> SizerItem:
        ...

    @overload
    def Prepend(self, size: Size, proportion: int=0, flag: int=0, border: int=0, Transfer: Optional[PyUserDatauserData]=None) -> SizerItem:
        ...

    @overload
    def Prepend(self, size: Size, flags: SizerFlags) -> SizerItem:
        ...

    @overload
    def Prepend(self, window: Window, flags: SizerFlags) -> SizerItem:
        """
        Prepend(window, flags) -> SizerItem
        Prepend(window, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Prepend(sizer, flags) -> SizerItem
        Prepend(sizer, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Prepend(width, height, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Prepend(width, height, flags) -> SizerItem
        Prepend(item) -> SizerItem
        Prepend(size, proportion=0, flag=0, border=0, Transfer=None) -> SizerItem
        Prepend(size, flags) -> SizerItem
        
        Same as Add(), but prepends the items to the beginning of the list of
        items (windows, subsizers or spaces) owned by this sizer.
        """

    def PrependSpacer(self, size: int) -> SizerItem:
        """
        PrependSpacer(size) -> SizerItem
        
        Prepends non-stretchable space to the sizer.
        """

    def PrependStretchSpacer(self, prop: int=1) -> SizerItem:
        """
        PrependStretchSpacer(prop=1) -> SizerItem
        
        Prepends stretchable space to the sizer.
        """

    def RepositionChildren(self, minSize: Size) -> None:
        """
        RepositionChildren(minSize) -> None
        
        Method which must be overridden in the derived sizer classes.
        """

    def RecalcSizes(self) -> None:
        """
        RecalcSizes() -> None
        
        This is a deprecated version of RepositionChildren()
        """

    @overload
    def Remove(self, index: int) -> bool:
        ...

    @overload
    def Remove(self, sizer: Sizer) -> bool:
        """
        Remove(sizer) -> bool
        Remove(index) -> bool
        
        Removes a sizer child from the sizer and destroys it.
        """

    @overload
    def Replace(self, oldsz: Sizer, newsz: Sizer, recursive: bool=False) -> bool:
        ...

    @overload
    def Replace(self, index: int, newitem: SizerItem) -> bool:
        ...

    @overload
    def Replace(self, oldwin: Window, newwin: Window, recursive: bool=False) -> bool:
        """
        Replace(oldwin, newwin, recursive=False) -> bool
        Replace(oldsz, newsz, recursive=False) -> bool
        Replace(index, newitem) -> bool
        
        Detaches the given oldwin from the sizer and replaces it with the
        given newwin.
        """

    @overload
    def SetDimension(self, pos: Point, size: Size) -> None:
        ...

    @overload
    def SetDimension(self, x: int, y: int, width: int, height: int) -> None:
        """
        SetDimension(x, y, width, height) -> None
        SetDimension(pos, size) -> None
        
        Call this to force the sizer to take the given dimension and thus
        force the items owned by the sizer to resize themselves according to
        the rules defined by the parameter in the Add() and Prepend() methods.
        """

    @overload
    def SetMinSize(self, width: int, height: int) -> None:
        ...

    @overload
    def SetMinSize(self, size: Size) -> None:
        """
        SetMinSize(size) -> None
        SetMinSize(width, height) -> None
        
        Call this to give the sizer a minimal size.
        """

    def SetSizeHints(self, window: Window) -> None:
        """
        SetSizeHints(window) -> None
        
        This method first calls Fit() and then
        wxTopLevelWindow::SetSizeHints() on the window passed to it.
        """

    @overload
    def Show(self, sizer: Sizer, show: bool=True, recursive: bool=False) -> bool:
        ...

    @overload
    def Show(self, index: int, show: bool=True) -> bool:
        ...

    @overload
    def Show(self, window: Window, show: bool=True, recursive: bool=False) -> bool:
        """
        Show(window, show=True, recursive=False) -> bool
        Show(sizer, show=True, recursive=False) -> bool
        Show(index, show=True) -> bool
        
        Shows or hides the window.
        """

    def ShowItems(self, show: bool) -> None:
        """
        ShowItems(show) -> None
        
        Show or hide all items managed by the sizer.
        """

    def AddMany(self, items):
        """
        :meth:`AddMany` is a convenience method for adding several items to a sizer
        at one time. Simply pass it a list of tuples, where each tuple
        consists of the parameters that you would normally pass to the :meth:`Add`
        method.
        """

    def __nonzero__(self):
        """
        Can be used to test if the C++ part of the sizer still exists, with 
        code like this::
        
            if theSizer:
                doSomething()
        """

    def __iter__(self):
        """
        A Python convenience method that allows Sizers to act as iterables that will yield their wx.SizerItems.
        """

    __bool__ = __nonzero__
    @property
    def Children(self) -> SizerItemList: ...
    @property
    def ContainingWindow(self) -> Window: ...
    @ContainingWindow.setter
    def ContainingWindow(self, value: Window, /) -> None: ...
    @property
    def ItemCount(self) -> int: ...
    @property
    def MinSize(self) -> Size: ...
    @MinSize.setter
    def MinSize(self, value: Size, /) -> None: ...
    @property
    def Position(self) -> Point: ...
    @property
    def Size(self) -> Size: ...
# end of class Sizer


class BoxSizer(Sizer):
    """
    BoxSizer(orient=HORIZONTAL) -> None
    
    The basic idea behind a box sizer is that windows will most often be
    laid out in rather simple basic geometry, typically in a row or a
    column or several hierarchies of either.
    """

    def __init__(self, orient: int=HORIZONTAL) -> None:
        """
        BoxSizer(orient=HORIZONTAL) -> None
        
        The basic idea behind a box sizer is that windows will most often be
        laid out in rather simple basic geometry, typically in a row or a
        column or several hierarchies of either.
        """

    def AddSpacer(self, size: int) -> SizerItem:
        """
        AddSpacer(size) -> SizerItem
        
        Adds non-stretchable space to the main orientation of the sizer only.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        Implements the calculation of a box sizer's minimal.
        """

    def GetOrientation(self) -> int:
        """
        GetOrientation() -> int
        
        Returns the orientation of the box sizer, either wxVERTICAL or
        wxHORIZONTAL.
        """

    def SetOrientation(self, orient: int) -> None:
        """
        SetOrientation(orient) -> None
        
        Sets the orientation of the box sizer, either wxVERTICAL or
        wxHORIZONTAL.
        """

    def RepositionChildren(self, minSize: Size) -> None:
        """
        RepositionChildren(minSize) -> None
        
        Method which must be overridden in the derived sizer classes.
        """

    def InformFirstDirection(self, direction: int, size: int, availableOtherDir: int) -> bool:
        """
        InformFirstDirection(direction, size, availableOtherDir) -> bool
        
        Inform sizer about the first direction that has been decided (by
        parent item).
        """
    @property
    def Orientation(self) -> int: ...
    @Orientation.setter
    def Orientation(self, value: int, /) -> None: ...
# end of class BoxSizer


class StaticBoxSizer(BoxSizer):
    """
    StaticBoxSizer(box, orient=HORIZONTAL) -> None
    StaticBoxSizer(orient, parent, label='') -> None
    
    wxStaticBoxSizer is a sizer derived from wxBoxSizer but adds a static
    box around the sizer.
    """

    @overload
    def __init__(self, orient: int, parent: Window, label: str='') -> None:
        ...

    @overload
    def __init__(self, box: StaticBox, orient: int=HORIZONTAL) -> None:
        """
        StaticBoxSizer(box, orient=HORIZONTAL) -> None
        StaticBoxSizer(orient, parent, label='') -> None
        
        wxStaticBoxSizer is a sizer derived from wxBoxSizer but adds a static
        box around the sizer.
        """

    def GetStaticBox(self) -> StaticBox:
        """
        GetStaticBox() -> StaticBox
        
        Returns the static box associated with the sizer.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        Implements the calculation of a box sizer's minimal.
        """

    def RepositionChildren(self, minSize: Size) -> None:
        """
        RepositionChildren(minSize) -> None
        
        Method which must be overridden in the derived sizer classes.
        """
    @property
    def StaticBox(self) -> StaticBox: ...
# end of class StaticBoxSizer


class GridSizer(Sizer):
    """
    GridSizer(cols, vgap, hgap) -> None
    GridSizer(cols, gap=Size(0,0)) -> None
    GridSizer(rows, cols, vgap, hgap) -> None
    GridSizer(rows, cols, gap) -> None
    
    A grid sizer is a sizer which lays out its children in a two-
    dimensional table with all table fields having the same size, i.e.
    """

    @overload
    def __init__(self, cols: int, gap: Size=Size(0,0)) -> None:
        ...

    @overload
    def __init__(self, rows: int, cols: int, vgap: int, hgap: int) -> None:
        ...

    @overload
    def __init__(self, rows: int, cols: int, gap: Size) -> None:
        ...

    @overload
    def __init__(self, cols: int, vgap: int, hgap: int) -> None:
        """
        GridSizer(cols, vgap, hgap) -> None
        GridSizer(cols, gap=Size(0,0)) -> None
        GridSizer(rows, cols, vgap, hgap) -> None
        GridSizer(rows, cols, gap) -> None
        
        A grid sizer is a sizer which lays out its children in a two-
        dimensional table with all table fields having the same size, i.e.
        """

    def GetCols(self) -> int:
        """
        GetCols() -> int
        
        Returns the number of columns that has been specified for the sizer.
        """

    def GetRows(self) -> int:
        """
        GetRows() -> int
        
        Returns the number of rows that has been specified for the sizer.
        """

    def GetEffectiveColsCount(self) -> int:
        """
        GetEffectiveColsCount() -> int
        
        Returns the number of columns currently used by the sizer.
        """

    def GetEffectiveRowsCount(self) -> int:
        """
        GetEffectiveRowsCount() -> int
        
        Returns the number of rows currently used by the sizer.
        """

    def GetHGap(self) -> int:
        """
        GetHGap() -> int
        
        Returns the horizontal gap (in pixels) between cells in the sizer.
        """

    def GetVGap(self) -> int:
        """
        GetVGap() -> int
        
        Returns the vertical gap (in pixels) between the cells in the sizer.
        """

    def SetCols(self, cols: int) -> None:
        """
        SetCols(cols) -> None
        
        Sets the number of columns in the sizer.
        """

    def SetHGap(self, gap: int) -> None:
        """
        SetHGap(gap) -> None
        
        Sets the horizontal gap (in pixels) between cells in the sizer.
        """

    def SetRows(self, rows: int) -> None:
        """
        SetRows(rows) -> None
        
        Sets the number of rows in the sizer.
        """

    def SetVGap(self, gap: int) -> None:
        """
        SetVGap(gap) -> None
        
        Sets the vertical gap (in pixels) between the cells in the sizer.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        This method is abstract and has to be overwritten by any derived
        class.
        """

    def RepositionChildren(self, minSize: Size) -> None:
        """
        RepositionChildren(minSize) -> None
        
        Method which must be overridden in the derived sizer classes.
        """

    def CalcRowsCols(self):
        """
        CalcRowsCols() -> (rows, cols)
        
        Calculates how many rows and columns will be in the sizer based
        on the current number of items and also the rows, cols specified
        in the constructor.
        """
    @property
    def Cols(self) -> int: ...
    @Cols.setter
    def Cols(self, value: int, /) -> None: ...
    @property
    def EffectiveColsCount(self) -> int: ...
    @property
    def EffectiveRowsCount(self) -> int: ...
    @property
    def HGap(self) -> int: ...
    @HGap.setter
    def HGap(self, value: int, /) -> None: ...
    @property
    def Rows(self) -> int: ...
    @Rows.setter
    def Rows(self, value: int, /) -> None: ...
    @property
    def VGap(self) -> int: ...
    @VGap.setter
    def VGap(self, value: int, /) -> None: ...
# end of class GridSizer


class FlexGridSizer(GridSizer):
    """
    FlexGridSizer(cols, vgap, hgap) -> None
    FlexGridSizer(cols, gap=Size(0,0)) -> None
    FlexGridSizer(rows, cols, vgap, hgap) -> None
    FlexGridSizer(rows, cols, gap) -> None
    
    A flex grid sizer is a sizer which lays out its children in a two-
    dimensional table with all table fields in one row having the same
    height and all fields in one column having the same width, but all
    rows or all columns are not necessarily the same height or width as in
    the wxGridSizer.
    """

    @overload
    def __init__(self, cols: int, gap: Size=Size(0,0)) -> None:
        ...

    @overload
    def __init__(self, rows: int, cols: int, vgap: int, hgap: int) -> None:
        ...

    @overload
    def __init__(self, rows: int, cols: int, gap: Size) -> None:
        ...

    @overload
    def __init__(self, cols: int, vgap: int, hgap: int) -> None:
        """
        FlexGridSizer(cols, vgap, hgap) -> None
        FlexGridSizer(cols, gap=Size(0,0)) -> None
        FlexGridSizer(rows, cols, vgap, hgap) -> None
        FlexGridSizer(rows, cols, gap) -> None
        
        A flex grid sizer is a sizer which lays out its children in a two-
        dimensional table with all table fields in one row having the same
        height and all fields in one column having the same width, but all
        rows or all columns are not necessarily the same height or width as in
        the wxGridSizer.
        """

    def AddGrowableCol(self, idx: int, proportion: int=0) -> None:
        """
        AddGrowableCol(idx, proportion=0) -> None
        
        Specifies that column idx (starting from zero) should be grown if
        there is extra space available to the sizer.
        """

    def AddGrowableRow(self, idx: int, proportion: int=0) -> None:
        """
        AddGrowableRow(idx, proportion=0) -> None
        
        Specifies that row idx (starting from zero) should be grown if there
        is extra space available to the sizer.
        """

    def GetFlexibleDirection(self) -> int:
        """
        GetFlexibleDirection() -> int
        
        Returns a wxOrientation value that specifies whether the sizer
        flexibly resizes its columns, rows, or both (default).
        """

    def GetNonFlexibleGrowMode(self) -> FlexSizerGrowMode:
        """
        GetNonFlexibleGrowMode() -> FlexSizerGrowMode
        
        Returns the value that specifies how the sizer grows in the "non-
        flexible" direction if there is one.
        """

    def IsColGrowable(self, idx: int) -> bool:
        """
        IsColGrowable(idx) -> bool
        
        Returns true if column idx is growable.
        """

    def IsRowGrowable(self, idx: int) -> bool:
        """
        IsRowGrowable(idx) -> bool
        
        Returns true if row idx is growable.
        """

    def RemoveGrowableCol(self, idx: int) -> None:
        """
        RemoveGrowableCol(idx) -> None
        
        Specifies that the idx column index is no longer growable.
        """

    def RemoveGrowableRow(self, idx: int) -> None:
        """
        RemoveGrowableRow(idx) -> None
        
        Specifies that the idx row index is no longer growable.
        """

    def SetFlexibleDirection(self, direction: int) -> None:
        """
        SetFlexibleDirection(direction) -> None
        
        Specifies whether the sizer should flexibly resize its columns, rows,
        or both.
        """

    def SetNonFlexibleGrowMode(self, mode: FlexSizerGrowMode) -> None:
        """
        SetNonFlexibleGrowMode(mode) -> None
        
        Specifies how the sizer should grow in the non-flexible direction if
        there is one (so SetFlexibleDirection() must have been called
        previously).
        """

    def GetRowHeights(self) -> List[int]:
        """
        GetRowHeights() -> List[int]
        
        Returns a read-only array containing the heights of the rows in the
        sizer.
        """

    def GetColWidths(self) -> List[int]:
        """
        GetColWidths() -> List[int]
        
        Returns a read-only array containing the widths of the columns in the
        sizer.
        """

    def RepositionChildren(self, minSize: Size) -> None:
        """
        RepositionChildren(minSize) -> None
        
        Method which must be overridden in the derived sizer classes.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        This method is abstract and has to be overwritten by any derived
        class.
        """
    @property
    def ColWidths(self) -> List[int]: ...
    @property
    def FlexibleDirection(self) -> int: ...
    @FlexibleDirection.setter
    def FlexibleDirection(self, value: int, /) -> None: ...
    @property
    def NonFlexibleGrowMode(self) -> FlexSizerGrowMode: ...
    @NonFlexibleGrowMode.setter
    def NonFlexibleGrowMode(self, value: FlexSizerGrowMode, /) -> None: ...
    @property
    def RowHeights(self) -> List[int]: ...
# end of class FlexGridSizer


class StdDialogButtonSizer(BoxSizer):
    """
    StdDialogButtonSizer() -> None
    
    This class creates button layouts which conform to the standard button
    spacing and ordering defined by the platform or toolkit's user
    interface guidelines (if such things exist).
    """

    def __init__(self) -> None:
        """
        StdDialogButtonSizer() -> None
        
        This class creates button layouts which conform to the standard button
        spacing and ordering defined by the platform or toolkit's user
        interface guidelines (if such things exist).
        """

    def AddButton(self, button: Button) -> None:
        """
        AddButton(button) -> None
        
        Adds a button to the wxStdDialogButtonSizer.
        """

    def Realize(self) -> None:
        """
        Realize() -> None
        
        Rearranges the buttons and applies proper spacing between buttons to
        make them match the platform or toolkit's interface guidelines.
        """

    def SetAffirmativeButton(self, button: Button) -> None:
        """
        SetAffirmativeButton(button) -> None
        
        Sets the affirmative button for the sizer.
        """

    def SetCancelButton(self, button: Button) -> None:
        """
        SetCancelButton(button) -> None
        
        Sets the cancel button for the sizer.
        """

    def SetNegativeButton(self, button: Button) -> None:
        """
        SetNegativeButton(button) -> None
        
        Sets the negative button for the sizer.
        """

    def RepositionChildren(self, minSize: Size) -> None:
        """
        RepositionChildren(minSize) -> None
        
        Method which must be overridden in the derived sizer classes.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        Implements the calculation of a box sizer's minimal.
        """
# end of class StdDialogButtonSizer


PySizer = wx.deprecated(Sizer, 'Use Sizer instead.')
#-- end-sizer --#
#-- begin-gbsizer --#

class GBPosition:
    """
    GBPosition() -> None
    GBPosition(row, col) -> None
    
    This class represents the position of an item in a virtual grid of
    rows and columns managed by a wxGridBagSizer.
    """

    @overload
    def __init__(self, row: int, col: int) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        GBPosition() -> None
        GBPosition(row, col) -> None
        
        This class represents the position of an item in a virtual grid of
        rows and columns managed by a wxGridBagSizer.
        """

    def GetCol(self) -> int:
        """
        GetCol() -> int
        
        Get the current column value.
        """

    def GetRow(self) -> int:
        """
        GetRow() -> int
        
        Get the current row value.
        """

    def SetCol(self, col: int) -> None:
        """
        SetCol(col) -> None
        
        Set a new column value.
        """

    def SetRow(self, row: int) -> None:
        """
        SetRow(row) -> None
        
        Set a new row value.
        """

    def __ne__(self, p: Union[GBPosition, _TwoInts]) -> bool:
        """
        """

    def __eq__(self, p: Union[GBPosition, _TwoInts]) -> bool:
        """
        """

    def Get(self) -> Any:
        """
        Get() -> (row, col)
        
        Return the row and col properties as a tuple.
        """

    def Set(self, row: int=0, col: int=0) -> None:
        """
        Set(row=0, col=0) -> None
        
        Set both the row and column properties.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.GBPosition`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.GBPosition``
        with a simple statement like this: ``obj = wx.GBPosition(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    @property
    def Row(self) -> int: ...
    @Row.setter
    def Row(self, value: int, /) -> None: ...
    @property
    def Col(self) -> int: ...
    @Col.setter
    def Col(self, value: int, /) -> None: ...
    @property
    def row(self) -> int: ...
    @row.setter
    def row(self, value: int, /) -> None: ...
    @property
    def col(self) -> int: ...
    @col.setter
    def col(self, value: int, /) -> None: ...
# end of class GBPosition


class GBSpan:
    """
    GBSpan() -> None
    GBSpan(rowspan, colspan) -> None
    
    This class is used to hold the row and column spanning attributes of
    items in a wxGridBagSizer.
    """

    @overload
    def __init__(self, rowspan: int, colspan: int) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        GBSpan() -> None
        GBSpan(rowspan, colspan) -> None
        
        This class is used to hold the row and column spanning attributes of
        items in a wxGridBagSizer.
        """

    def GetColspan(self) -> int:
        """
        GetColspan() -> int
        
        Get the current colspan value.
        """

    def GetRowspan(self) -> int:
        """
        GetRowspan() -> int
        
        Get the current rowspan value.
        """

    def SetColspan(self, colspan: int) -> None:
        """
        SetColspan(colspan) -> None
        
        Set a new colspan value.
        """

    def SetRowspan(self, rowspan: int) -> None:
        """
        SetRowspan(rowspan) -> None
        
        Set a new rowspan value.
        """

    def __ne__(self, o: Union[GBSpan, _TwoInts]) -> bool:
        """
        """

    def __eq__(self, o: Union[GBSpan, _TwoInts]) -> bool:
        """
        """

    def Get(self) -> Any:
        """
        Get() -> (rowspan, colspan)
        
        Return the rowspan and colspan properties as a tuple.
        """

    def Set(self, rowspan: int=0, colspan: int=0) -> None:
        """
        Set(rowspan=0, colspan=0) -> None
        
        Set both the rowspan and colspan properties.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.GBSpan`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.GBSpan``
        with a simple statement like this: ``obj = wx.GBSpan(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    @property
    def Rowspan(self) -> int: ...
    @Rowspan.setter
    def Rowspan(self, value: int, /) -> None: ...
    @property
    def Colspan(self) -> int: ...
    @Colspan.setter
    def Colspan(self, value: int, /) -> None: ...
    @property
    def rowspan(self) -> int: ...
    @rowspan.setter
    def rowspan(self, value: int, /) -> None: ...
    @property
    def colspan(self) -> int: ...
    @colspan.setter
    def colspan(self, value: int, /) -> None: ...
# end of class GBSpan


class GBSizerItem(SizerItem):
    """
    GBSizerItem(width, height, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> None
    GBSizerItem(window, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> None
    GBSizerItem(sizer, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> None
    
    The wxGBSizerItem class is used by the wxGridBagSizer for tracking the
    items in the sizer.
    """

    @overload
    def __init__(self, window: Window, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts]=DefaultSpan, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> None:
        ...

    @overload
    def __init__(self, sizer: Sizer, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts]=DefaultSpan, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> None:
        ...

    @overload
    def __init__(self, width: int, height: int, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts]=DefaultSpan, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> None:
        """
        GBSizerItem(width, height, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> None
        GBSizerItem(window, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> None
        GBSizerItem(sizer, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> None
        
        The wxGBSizerItem class is used by the wxGridBagSizer for tracking the
        items in the sizer.
        """

    def GetPos(self) -> GBPosition:
        """
        GetPos() -> GBPosition
        
        Get the grid position of the item.
        """

    def GetSpan(self) -> GBSpan:
        """
        GetSpan() -> GBSpan
        
        Get the row and column spanning of the item.
        """

    def GetEndPos(self) -> Tuple[int, int]:
        """
        GetEndPos() -> Tuple[int, int]
        
        Get the row and column of the endpoint of this item.
        """

    @overload
    def Intersects(self, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts]) -> bool:
        ...

    @overload
    def Intersects(self, other: GBSizerItem) -> bool:
        """
        Intersects(other) -> bool
        Intersects(pos, span) -> bool
        
        Returns true if this item and the other item intersect.
        """

    def SetPos(self, pos: Union[GBPosition, _TwoInts]) -> bool:
        """
        SetPos(pos) -> bool
        
        If the item is already a member of a sizer then first ensure that
        there is no other item that would intersect with this one at the new
        position, then set the new position.
        """

    def SetSpan(self, span: Union[GBSpan, _TwoInts]) -> bool:
        """
        SetSpan(span) -> bool
        
        If the item is already a member of a sizer then first ensure that
        there is no other item that would intersect with this one with its new
        spanning size, then set the new spanning.
        """

    def GetGBSizer(self) -> GridBagSizer:
        """
        GetGBSizer() -> GridBagSizer
        """

    def SetGBSizer(self, sizer: GridBagSizer) -> None:
        """
        SetGBSizer(sizer) -> None
        """
    @property
    def GBSizer(self) -> GridBagSizer: ...
    @GBSizer.setter
    def GBSizer(self, value: GridBagSizer, /) -> None: ...
    @property
    def Pos(self) -> Union[GBPosition, _TwoInts]: ...
    @Pos.setter
    def Pos(self, value: Union[GBPosition, _TwoInts], /) -> None: ...
    @property
    def Span(self) -> Union[GBSpan, _TwoInts]: ...
    @Span.setter
    def Span(self, value: Union[GBSpan, _TwoInts], /) -> None: ...
# end of class GBSizerItem


class GridBagSizer(FlexGridSizer):
    """
    GridBagSizer(vgap=0, hgap=0) -> None
    
    A wxSizer that can lay out items in a virtual grid like a
    wxFlexGridSizer but in this case explicit positioning of the items is
    allowed using wxGBPosition, and items can optionally span more than
    one row and/or column using wxGBSpan.
    """

    def __init__(self, vgap: int=0, hgap: int=0) -> None:
        """
        GridBagSizer(vgap=0, hgap=0) -> None
        
        A wxSizer that can lay out items in a virtual grid like a
        wxFlexGridSizer but in this case explicit positioning of the items is
        allowed using wxGBPosition, and items can optionally span more than
        one row and/or column using wxGBSpan.
        """

    @overload
    def Add(self, sizer: Sizer, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts]=DefaultSpan, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Add(self, item: GBSizerItem) -> SizerItem:
        ...

    @overload
    def Add(self, width: int, height: int, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts]=DefaultSpan, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        ...

    @overload
    def Add(self, size: Size, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts]=DefaultSpan, flag: int=0, border: int=0, Transfer: Optional[ObjectuserData]=None) -> SizerItem:
        ...

    @overload
    def Add(self, window: Window, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts]=DefaultSpan, flag: int=0, border: int=0, userData: Optional[PyUserData]=None) -> SizerItem:
        """
        Add(window, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> SizerItem
        Add(sizer, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> SizerItem
        Add(item) -> SizerItem
        Add(width, height, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> SizerItem
        Add(size, pos, span=DefaultSpan, flag=0, border=0, Transfer=None) -> SizerItem
        
        Adds the given item to the given position.
        """

    @overload
    def CheckForIntersection(self, pos: Union[GBPosition, _TwoInts], span: Union[GBSpan, _TwoInts], excludeItem: Optional[GBSizerItem]=None) -> bool:
        ...

    @overload
    def CheckForIntersection(self, item: GBSizerItem, excludeItem: Optional[GBSizerItem]=None) -> bool:
        """
        CheckForIntersection(item, excludeItem=None) -> bool
        CheckForIntersection(pos, span, excludeItem=None) -> bool
        
        Look at all items and see if any intersect (or would overlap) the
        given item.
        """

    @overload
    def FindItem(self, sizer: Sizer) -> GBSizerItem:
        ...

    @overload
    def FindItem(self, window: Window) -> GBSizerItem:
        """
        FindItem(window) -> GBSizerItem
        FindItem(sizer) -> GBSizerItem
        
        Find the sizer item for the given window or subsizer, returns NULL if
        not found.
        """

    @overload
    def GetItemPosition(self, sizer: Sizer) -> GBPosition:
        ...

    @overload
    def GetItemPosition(self, index: int) -> GBPosition:
        ...

    @overload
    def GetItemPosition(self, window: Window) -> GBPosition:
        """
        GetItemPosition(window) -> GBPosition
        GetItemPosition(sizer) -> GBPosition
        GetItemPosition(index) -> GBPosition
        
        Get the grid position of the specified item.
        """

    @overload
    def GetItemSpan(self, sizer: Sizer) -> GBSpan:
        ...

    @overload
    def GetItemSpan(self, index: int) -> GBSpan:
        ...

    @overload
    def GetItemSpan(self, window: Window) -> GBSpan:
        """
        GetItemSpan(window) -> GBSpan
        GetItemSpan(sizer) -> GBSpan
        GetItemSpan(index) -> GBSpan
        
        Get the row/col spanning of the specified item.
        """

    @overload
    def SetItemPosition(self, sizer: Sizer, pos: Union[GBPosition, _TwoInts]) -> bool:
        ...

    @overload
    def SetItemPosition(self, index: int, pos: Union[GBPosition, _TwoInts]) -> bool:
        ...

    @overload
    def SetItemPosition(self, window: Window, pos: Union[GBPosition, _TwoInts]) -> bool:
        """
        SetItemPosition(window, pos) -> bool
        SetItemPosition(sizer, pos) -> bool
        SetItemPosition(index, pos) -> bool
        
        Set the grid position of the specified item.
        """

    @overload
    def SetItemSpan(self, sizer: Sizer, span: Union[GBSpan, _TwoInts]) -> bool:
        ...

    @overload
    def SetItemSpan(self, index: int, span: Union[GBSpan, _TwoInts]) -> bool:
        ...

    @overload
    def SetItemSpan(self, window: Window, span: Union[GBSpan, _TwoInts]) -> bool:
        """
        SetItemSpan(window, span) -> bool
        SetItemSpan(sizer, span) -> bool
        SetItemSpan(index, span) -> bool
        
        Set the row/col spanning of the specified item.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        Called when the managed size of the sizer is needed or when layout
        needs done.
        """

    def FindItemAtPoint(self, pt: Point) -> GBSizerItem:
        """
        FindItemAtPoint(pt) -> GBSizerItem
        
        Return the sizer item located at the point given in pt, or NULL if
        there is no item at that point.
        """

    def FindItemAtPosition(self, pos: Union[GBPosition, _TwoInts]) -> GBSizerItem:
        """
        FindItemAtPosition(pos) -> GBSizerItem
        
        Return the sizer item for the given grid cell, or NULL if there is no
        item at that position.
        """

    def FindItemWithData(self, userData: Object) -> GBSizerItem:
        """
        FindItemWithData(userData) -> GBSizerItem
        
        Return the sizer item that has a matching user data (it only compares
        pointer values) or NULL if not found.
        """

    def GetCellSize(self, row: int, col: int) -> Size:
        """
        GetCellSize(row, col) -> Size
        
        Get the size of the specified cell, including hgap and vgap.
        """

    def GetEmptyCellSize(self) -> Size:
        """
        GetEmptyCellSize() -> Size
        
        Get the size used for cells in the grid with no item.
        """

    def RepositionChildren(self, minSize: Size) -> None:
        """
        RepositionChildren(minSize) -> None
        
        Called when the managed size of the sizer is needed or when layout
        needs done.
        """

    def SetEmptyCellSize(self, sz: Size) -> None:
        """
        SetEmptyCellSize(sz) -> None
        
        Set the size used for cells in the grid with no item.
        """

    CheckForIntersectionPos = wx.deprecated(CheckForIntersection, 'Use CheckForIntersection instead.')
    @property
    def EmptyCellSize(self) -> Size: ...
    @EmptyCellSize.setter
    def EmptyCellSize(self, value: Size, /) -> None: ...
# end of class GridBagSizer

DefaultSpan: GBSpan

from collections import namedtuple
_im_GBPosition = namedtuple('_im_GBPosition', ['row', 'col'])
del namedtuple

from collections import namedtuple
_im_GBSpan = namedtuple('_im_GBSpan', ['rowspan', 'colspan'])
del namedtuple
#-- end-gbsizer --#
#-- begin-wrapsizer --#

class _enum_(IntEnum):
    EXTEND_LAST_ON_EACH_LINE = auto()
    REMOVE_LEADING_SPACES = auto()
    WRAPSIZER_DEFAULT_FLAGS = auto()
EXTEND_LAST_ON_EACH_LINE = _enum_.EXTEND_LAST_ON_EACH_LINE
REMOVE_LEADING_SPACES = _enum_.REMOVE_LEADING_SPACES
WRAPSIZER_DEFAULT_FLAGS = _enum_.WRAPSIZER_DEFAULT_FLAGS

class WrapSizer(BoxSizer):
    """
    WrapSizer(orient=HORIZONTAL, flags=WRAPSIZER_DEFAULT_FLAGS) -> None
    
    A wrap sizer lays out its items in a single line, like a box sizer  as
    long as there is space available in that direction.
    """

    def __init__(self, orient: int=HORIZONTAL, flags: int=WRAPSIZER_DEFAULT_FLAGS) -> None:
        """
        WrapSizer(orient=HORIZONTAL, flags=WRAPSIZER_DEFAULT_FLAGS) -> None
        
        A wrap sizer lays out its items in a single line, like a box sizer  as
        long as there is space available in that direction.
        """

    def InformFirstDirection(self, direction: int, size: int, availableOtherDir: int) -> bool:
        """
        InformFirstDirection(direction, size, availableOtherDir) -> bool
        
        Not used by an application.
        """

    def RepositionChildren(self, minSize: Size) -> None:
        """
        RepositionChildren(minSize) -> None
        
        Method which must be overridden in the derived sizer classes.
        """

    def CalcMin(self) -> Size:
        """
        CalcMin() -> Size
        
        Implements the calculation of a box sizer's minimal.
        """

    def IsSpaceItem(self, item: SizerItem) -> bool:
        """
        IsSpaceItem(item) -> bool
        
        Can be overridden in the derived classes to treat some normal items as
        spacers.
        """
# end of class WrapSizer

#-- end-wrapsizer --#
#-- begin-stdpaths --#

class StandardPaths:
    """
    StandardPaths() -> None
    
    wxStandardPaths returns the standard locations in the file system and
    should be used by applications to find their data files in a portable
    way.
    """

    class _ResourceCat(IntEnum):
        ResourceCat_None = auto()
        ResourceCat_Messages = auto()
    ResourceCat: TypeAlias = Union[_ResourceCat, int]
    ResourceCat_None = _ResourceCat.ResourceCat_None
    ResourceCat_Messages = _ResourceCat.ResourceCat_Messages

    class _Dir(IntEnum):
        Dir_Cache = auto()
        Dir_Documents = auto()
        Dir_Desktop = auto()
        Dir_Downloads = auto()
        Dir_Music = auto()
        Dir_Pictures = auto()
        Dir_Videos = auto()
    Dir: TypeAlias = Union[_Dir, int]
    Dir_Cache = _Dir.Dir_Cache
    Dir_Documents = _Dir.Dir_Documents
    Dir_Desktop = _Dir.Dir_Desktop
    Dir_Downloads = _Dir.Dir_Downloads
    Dir_Music = _Dir.Dir_Music
    Dir_Pictures = _Dir.Dir_Pictures
    Dir_Videos = _Dir.Dir_Videos

    class _FileLayout(IntEnum):
        FileLayout_Classic = auto()
        FileLayout_XDG = auto()
    FileLayout: TypeAlias = Union[_FileLayout, int]
    FileLayout_Classic = _FileLayout.FileLayout_Classic
    FileLayout_XDG = _FileLayout.FileLayout_XDG

    class _ConfigFileConv(IntEnum):
        ConfigFileConv_Dot = auto()
        ConfigFileConv_Ext = auto()
    ConfigFileConv: TypeAlias = Union[_ConfigFileConv, int]
    ConfigFileConv_Dot = _ConfigFileConv.ConfigFileConv_Dot
    ConfigFileConv_Ext = _ConfigFileConv.ConfigFileConv_Ext

    def GetAppDocumentsDir(self) -> str:
        """
        GetAppDocumentsDir() -> str
        
        Return the directory for the document files used by this application.
        """

    def GetConfigDir(self) -> str:
        """
        GetConfigDir() -> str
        
        Return the directory containing the system config files.
        """

    def GetDataDir(self) -> str:
        """
        GetDataDir() -> str
        
        Return the location of the applications global, i.e. not user-
        specific, data files.
        """

    def GetDocumentsDir(self) -> str:
        """
        GetDocumentsDir() -> str
        
        Same as calling GetUserDir() with Dir_Documents parameter.
        """

    def GetExecutablePath(self) -> str:
        """
        GetExecutablePath() -> str
        
        Return the directory and the filename for the current executable.
        """

    def GetInstallPrefix(self) -> str:
        """
        GetInstallPrefix() -> str
        
        Return the program installation prefix, e.g. /usr, /opt or
        /home/zeitlin.
        """

    def GetLocalDataDir(self) -> str:
        """
        GetLocalDataDir() -> str
        
        Return the location for application data files which are host-specific
        and can't, or shouldn't, be shared with the other machines.
        """

    def GetLocalizedResourcesDir(self, lang: str, category: ResourceCat=ResourceCat_None) -> str:
        """
        GetLocalizedResourcesDir(lang, category=ResourceCat_None) -> str
        
        Return the localized resources directory containing the resource files
        of the specified category for the given language.
        """

    def GetPluginsDir(self) -> str:
        """
        GetPluginsDir() -> str
        
        Return the directory where the loadable modules (plugins) live.
        """

    def GetResourcesDir(self) -> str:
        """
        GetResourcesDir() -> str
        
        Return the directory where the application resource files are located.
        """

    def GetTempDir(self) -> str:
        """
        GetTempDir() -> str
        
        Return the directory for storing temporary files, for the current
        user.
        """

    def GetUserConfigDir(self) -> str:
        """
        GetUserConfigDir() -> str
        
        Return the directory for the user config files.
        """

    def GetUserDataDir(self) -> str:
        """
        GetUserDataDir() -> str
        
        Return the directory for the user-dependent application data files:
        """

    def GetUserDir(self, userDir: Dir) -> str:
        """
        GetUserDir(userDir) -> str
        
        Return the path of the specified user data directory.
        """

    def GetUserLocalDataDir(self) -> str:
        """
        GetUserLocalDataDir() -> str
        
        Return the directory for user data files which shouldn't be shared
        with the other machines.
        """

    def SetInstallPrefix(self, prefix: str) -> None:
        """
        SetInstallPrefix(prefix) -> None
        
        Lets wxStandardPaths know about the real program installation prefix
        on a Unix system.
        """

    def UseAppInfo(self, info: int) -> None:
        """
        UseAppInfo(info) -> None
        
        Controls what application information is used when constructing paths
        that should be unique to this program, such as the application data
        directory, the plugins directory on Unix, etc.
        """

    def SetFileLayout(self, layout: FileLayout) -> None:
        """
        SetFileLayout(layout) -> None
        
        Sets the current file layout.
        """

    def GetFileLayout(self) -> FileLayout:
        """
        GetFileLayout() -> FileLayout
        
        Returns the current file layout.
        """

    def MakeConfigFileName(self, basename: str, conv: ConfigFileConv=ConfigFileConv_Ext) -> str:
        """
        MakeConfigFileName(basename, conv=ConfigFileConv_Ext) -> str
        
        Return the file name which would be used by wxFileConfig if it were
        constructed with basename.
        """

    @staticmethod
    def Get() -> StandardPaths:
        """
        Get() -> StandardPaths
        
        Returns reference to the unique global standard paths object.
        """

    @staticmethod
    def MSWGetShellDir(csidl: int) -> str:
        """
        MSWGetShellDir(csidl) -> str
        
        Returns location of Windows shell special folder.
        """
    @property
    def AppDocumentsDir(self) -> str: ...
    @property
    def ConfigDir(self) -> str: ...
    @property
    def DataDir(self) -> str: ...
    @property
    def DocumentsDir(self) -> str: ...
    @property
    def ExecutablePath(self) -> str: ...
    @property
    def InstallPrefix(self) -> str: ...
    @InstallPrefix.setter
    def InstallPrefix(self, value: str, /) -> None: ...
    @property
    def LocalDataDir(self) -> str: ...
    @property
    def PluginsDir(self) -> str: ...
    @property
    def ResourcesDir(self) -> str: ...
    @property
    def TempDir(self) -> str: ...
    @property
    def UserConfigDir(self) -> str: ...
    @property
    def UserDataDir(self) -> str: ...
    @property
    def UserLocalDataDir(self) -> str: ...

    def __init__(self) -> None:
        """
        """
# end of class StandardPaths

#-- end-stdpaths --#
#-- begin-eventfilter --#

class EventFilter:
    """
    EventFilter() -> None
    
    A global event filter for pre-processing all the events generated in
    the program.
    """

    class _enum_(IntEnum):
        Event_Skip = auto()
        Event_Ignore = auto()
        Event_Processed = auto()
    Event_Skip = _enum_.Event_Skip
    Event_Ignore = _enum_.Event_Ignore
    Event_Processed = _enum_.Event_Processed

    def __init__(self) -> None:
        """
        EventFilter() -> None
        
        A global event filter for pre-processing all the events generated in
        the program.
        """

    def FilterEvent(self, event: Event) -> int:
        """
        FilterEvent(event) -> int
        
        Override this method to implement event pre-processing.
        """
# end of class EventFilter

#-- end-eventfilter --#
#-- begin-evtloop --#

class EventLoopBase:
    """
    Base class for all event loop implementations.
    """

    def Run(self) -> int:
        """
        Run() -> int
        
        Start the event loop, return the exit code when it is finished.
        """

    def IsRunning(self) -> bool:
        """
        IsRunning() -> bool
        
        Return true if this event loop is currently running.
        """

    def IsOk(self) -> bool:
        """
        IsOk() -> bool
        
        Use this to check whether the event loop was successfully created
        before using it.
        """

    def Exit(self, rc: int=0) -> None:
        """
        Exit(rc=0) -> None
        
        Exit the currently running loop with the given exit code.
        """

    def ScheduleExit(self, rc: int=0) -> None:
        """
        ScheduleExit(rc=0) -> None
        
        Schedule an exit from the loop with the given exit code.
        """

    def Pending(self) -> bool:
        """
        Pending() -> bool
        
        Return true if any events are available.
        """

    def Dispatch(self) -> bool:
        """
        Dispatch() -> bool
        
        Dispatches the next event in the windowing system event queue.
        """

    def DispatchTimeout(self, timeout: int) -> int:
        """
        DispatchTimeout(timeout) -> int
        
        Dispatch an event but not wait longer than the specified timeout for
        it.
        """

    def WakeUp(self) -> None:
        """
        WakeUp() -> None
        
        Called by wxWidgets to wake up the event loop even if it is currently
        blocked inside Dispatch().
        """

    def WakeUpIdle(self) -> None:
        """
        WakeUpIdle() -> None
        
        Makes sure that idle events are sent again.
        """

    def ProcessIdle(self) -> bool:
        """
        ProcessIdle() -> bool
        
        This virtual function is called when the application becomes idle and
        normally just sends wxIdleEvent to all interested parties.
        """

    def IsYielding(self) -> bool:
        """
        IsYielding() -> bool
        
        Returns true if called from inside Yield() or from inside YieldFor().
        """

    def Yield(self, onlyIfNeeded: bool=False) -> bool:
        """
        Yield(onlyIfNeeded=False) -> bool
        
        Yields control to pending messages in the windowing system.
        """

    def YieldFor(self, eventsToProcess: int) -> bool:
        """
        YieldFor(eventsToProcess) -> bool
        
        Works like Yield() with onlyIfNeeded == true, except that it allows
        the caller to specify a mask of the wxEventCategory values which
        indicates which events should be processed and which should instead be
        "delayed" (i.e.
        """

    def IsEventAllowedInsideYield(self, cat: EventCategory) -> bool:
        """
        IsEventAllowedInsideYield(cat) -> bool
        
        Returns true if the given event category is allowed inside a
        YieldFor() call (i.e.
        """

    @staticmethod
    def GetActive() -> EventLoopBase:
        """
        GetActive() -> EventLoopBase
        
        Return the currently active (running) event loop.
        """

    @staticmethod
    def SetActive(loop: EventLoopBase) -> None:
        """
        SetActive(loop) -> None
        
        Set currently active (running) event loop.
        """

    def IsMain(self) -> bool:
        """
        IsMain() -> bool
        
        Returns true if this is the main loop executed by wxApp::OnRun().
        """

    def OnExit(self) -> None:
        """
        OnExit() -> None
        
        This function is called before the event loop terminates, whether this
        happens normally (because of Exit() call) or abnormally (because of an
        exception thrown from inside the loop).
        """
# end of class EventLoopBase


class EventLoopActivator:
    """
    EventLoopActivator(loop) -> None
    
    Makes an event loop temporarily active.
    """

    def __init__(self, loop: EventLoopBase) -> None:
        """
        EventLoopActivator(loop) -> None
        
        Makes an event loop temporarily active.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class EventLoopActivator


class GUIEventLoop(EventLoopBase):
    """
    GUIEventLoop() -> None
    
    A generic implementation of the GUI event loop.
    """

    def __init__(self) -> None:
        """
        GUIEventLoop() -> None
        
        A generic implementation of the GUI event loop.
        """
# end of class GUIEventLoop


@wx.deprecatedMsg('Use GUIEventLoop instead.')
class EventLoop(GUIEventLoop):
    '''A class using the old name for compatibility.'''
    def __init__(self):
        GUIEventLoop.__init__(self)
#-- end-evtloop --#
#-- begin-apptrait --#

class AppTraits:
    """
    The wxAppTraits class defines various configurable aspects of a wxApp.
    """

    def CreateConfig(self) -> ConfigBase:
        """
        CreateConfig() -> ConfigBase
        
        Called by wxWidgets to create the default configuration object for the
        application.
        """

    def CreateEventLoop(self) -> EventLoopBase:
        """
        CreateEventLoop() -> EventLoopBase
        
        Used by wxWidgets to create the main event loop used by
        wxApp::OnRun().
        """

    def CreateLogTarget(self) -> Log:
        """
        CreateLogTarget() -> Log
        
        Creates a wxLog class for the application to use for logging errors.
        """

    def GetDesktopEnvironment(self) -> str:
        """
        GetDesktopEnvironment() -> str
        
        Returns the name of the desktop environment currently running on a
        Unix desktop.
        """

    def GetStandardPaths(self) -> StandardPaths:
        """
        GetStandardPaths() -> StandardPaths
        
        Returns the wxStandardPaths object for the application.
        """

    def GetToolkitVersion(self) -> Tuple[PortId, int, int, int]:
        """
        GetToolkitVersion() -> Tuple[PortId, int, int, int]
        
        Returns the wxWidgets port ID used by the running program and
        eventually fills the given pointers with the values of the major,
        minor, and micro digits of the native toolkit currently used.
        """

    def HasStderr(self) -> bool:
        """
        HasStderr() -> bool
        
        Returns true if fprintf(stderr) goes somewhere, false otherwise.
        """

    def IsUsingUniversalWidgets(self) -> bool:
        """
        IsUsingUniversalWidgets() -> bool
        
        Returns true if the library was built as wxUniversal.
        """

    def ShowAssertDialog(self, msg: str) -> bool:
        """
        ShowAssertDialog(msg) -> bool
        
        Shows the assert dialog with the specified message in GUI mode or just
        prints the string to stderr in console mode.
        """

    def SafeMessageBox(self, text: str, title: str) -> bool:
        """
        SafeMessageBox(text, title) -> bool
        
        Shows a message box with the given text and title if possible.
        """

    def GetAssertStackTrace(self) -> str:
        """
        GetAssertStackTrace() -> str
        
        Helper function mostly useful for derived classes ShowAssertDialog()
        implementation.
        """
    @property
    def AssertStackTrace(self) -> str: ...
    @property
    def DesktopEnvironment(self) -> str: ...
    @property
    def StandardPaths(self) -> StandardPaths: ...
    @property
    def ToolkitVersion(self) -> Tuple[PortId, int, int, int]: ...
# end of class AppTraits

#-- end-apptrait --#
#-- begin-app --#

class AppConsole(EvtHandler, EventFilter):
    """
    This class is essential for writing console-only or hybrid apps
    without having to define wxUSE_GUI=0.
    """

    def MainLoop(self) -> int:
        """
        MainLoop() -> int
        
        Called by wxWidgets on creation of the application.
        """

    def ExitMainLoop(self) -> None:
        """
        ExitMainLoop() -> None
        
        Call this to explicitly exit the main message (event) loop.
        """

    def FilterEvent(self, event: Event) -> int:
        """
        FilterEvent(event) -> int
        
        Overridden wxEventFilter method.
        """

    def GetMainLoop(self) -> EventLoopBase:
        """
        GetMainLoop() -> EventLoopBase
        
        Returns the main event loop instance, i.e. the event loop which is
        started by OnRun() and which dispatches all events sent from the
        native toolkit to the application (except when new event loops are
        temporarily set-up).
        """

    def UsesEventLoop(self) -> bool:
        """
        UsesEventLoop() -> bool
        
        Returns true if the application is using an event loop.
        """

    def ProcessPendingEvents(self) -> None:
        """
        ProcessPendingEvents() -> None
        
        Process all pending events; it is necessary to call this function to
        process events posted with wxEvtHandler::QueueEvent or
        wxEvtHandler::AddPendingEvent.
        """

    def DeletePendingEvents(self) -> None:
        """
        DeletePendingEvents() -> None
        
        Deletes the pending events of all wxEvtHandlers of this application.
        """

    def HasPendingEvents(self) -> bool:
        """
        HasPendingEvents() -> bool
        
        Returns true if there are pending events on the internal pending event
        list.
        """

    def SuspendProcessingOfPendingEvents(self) -> None:
        """
        SuspendProcessingOfPendingEvents() -> None
        
        Temporary suspends processing of the pending events.
        """

    def ResumeProcessingOfPendingEvents(self) -> None:
        """
        ResumeProcessingOfPendingEvents() -> None
        
        Resume processing of the pending events previously stopped because of
        a call to SuspendProcessingOfPendingEvents().
        """

    def ScheduleForDestruction(self, object: Object) -> None:
        """
        ScheduleForDestruction(object) -> None
        
        Delayed objects destruction.
        """

    def IsScheduledForDestruction(self, object: Object) -> bool:
        """
        IsScheduledForDestruction(object) -> bool
        
        Check if the object had been scheduled for destruction with
        ScheduleForDestruction().
        """

    def OnEventLoopEnter(self, loop: EventLoopBase) -> None:
        """
        OnEventLoopEnter(loop) -> None
        
        Called by wxEventLoopBase::SetActive(): you can override this function
        and put here the code which needs an active event loop.
        """

    def OnEventLoopExit(self, loop: EventLoopBase) -> None:
        """
        OnEventLoopExit(loop) -> None
        
        Called by wxEventLoopBase::OnExit() for each event loop which is
        exited.
        """

    def OnExit(self) -> int:
        """
        OnExit() -> int
        
        Override this member function for any processing which needs to be
        done as the application is about to exit.
        """

    def OnInit(self) -> bool:
        """
        OnInit() -> bool
        
        This must be provided by the application, and will usually create the
        application's main window, optionally calling SetTopWindow().
        """

    def OnRun(self) -> int:
        """
        OnRun() -> int
        
        This virtual function is where the execution of a program written in
        wxWidgets starts.
        """

    def GetAppDisplayName(self) -> str:
        """
        GetAppDisplayName() -> str
        
        Returns the user-readable application name.
        """

    def GetAppName(self) -> str:
        """
        GetAppName() -> str
        
        Returns the application name.
        """

    def GetClassName(self) -> str:
        """
        GetClassName() -> str
        
        Gets the class name of the application.
        """

    def GetTraits(self) -> AppTraits:
        """
        GetTraits() -> AppTraits
        
        Returns a pointer to the wxAppTraits object for the application.
        """

    def GetVendorDisplayName(self) -> str:
        """
        GetVendorDisplayName() -> str
        
        Returns the user-readable vendor name.
        """

    def GetVendorName(self) -> str:
        """
        GetVendorName() -> str
        
        Returns the application's vendor name.
        """

    def SetAppDisplayName(self, name: str) -> None:
        """
        SetAppDisplayName(name) -> None
        
        Set the application name to be used in the user-visible places such as
        window titles.
        """

    def SetAppName(self, name: str) -> None:
        """
        SetAppName(name) -> None
        
        Sets the name of the application.
        """

    def SetClassName(self, name: str) -> None:
        """
        SetClassName(name) -> None
        
        Sets the class name of the application.
        """

    def SetVendorDisplayName(self, name: str) -> None:
        """
        SetVendorDisplayName(name) -> None
        
        Set the vendor name to be used in the user-visible places.
        """

    def SetVendorName(self, name: str) -> None:
        """
        SetVendorName(name) -> None
        
        Sets the name of application's vendor.
        """

    def Yield(self, onlyIfNeeded: bool=False) -> bool:
        """
        Yield(onlyIfNeeded=False) -> bool
        
        Yields control to pending messages in the event loop.
        """

    def SetCLocale(self) -> None:
        """
        SetCLocale() -> None
        
        Sets the C locale to the default locale for the current environment.
        """

    def SetErrorExitCode(self, code: int) -> None:
        """
        SetErrorExitCode(code) -> None
        
        Sets the error code to use in case of exit on error.
        """

    @staticmethod
    def SetInstance(app: AppConsole) -> None:
        """
        SetInstance(app) -> None
        
        Allows external code to modify global wxTheApp, but you should really
        know what you're doing if you call it.
        """

    @staticmethod
    def GetInstance() -> AppConsole:
        """
        GetInstance() -> AppConsole
        
        Returns the one and only global application object.
        """

    @staticmethod
    def IsMainLoopRunning() -> bool:
        """
        IsMainLoopRunning() -> bool
        
        Returns true if the main event loop is currently running, i.e. if the
        application is inside OnRun().
        """
    @property
    def AppDisplayName(self) -> str: ...
    @AppDisplayName.setter
    def AppDisplayName(self, value: str, /) -> None: ...
    @property
    def AppName(self) -> str: ...
    @AppName.setter
    def AppName(self, value: str, /) -> None: ...
    @property
    def ClassName(self) -> str: ...
    @ClassName.setter
    def ClassName(self, value: str, /) -> None: ...
    @property
    def VendorDisplayName(self) -> str: ...
    @VendorDisplayName.setter
    def VendorDisplayName(self, value: str, /) -> None: ...
    @property
    def VendorName(self) -> str: ...
    @VendorName.setter
    def VendorName(self, value: str, /) -> None: ...
    @property
    def Traits(self) -> AppTraits: ...
# end of class AppConsole


class _AppAssertMode(IntEnum):
    APP_ASSERT_SUPPRESS = auto()
    APP_ASSERT_EXCEPTION = auto()
    APP_ASSERT_DIALOG = auto()
    APP_ASSERT_LOG = auto()
AppAssertMode: TypeAlias = Union[_AppAssertMode, int]
APP_ASSERT_SUPPRESS = _AppAssertMode.APP_ASSERT_SUPPRESS
APP_ASSERT_EXCEPTION = _AppAssertMode.APP_ASSERT_EXCEPTION
APP_ASSERT_DIALOG = _AppAssertMode.APP_ASSERT_DIALOG
APP_ASSERT_LOG = _AppAssertMode.APP_ASSERT_LOG

class PyApp(AppConsole):
    """
    PyApp() -> None
    
    The wxApp class represents the application itself when wxUSE_GUI=1.
    """

    def __init__(self) -> None:
        """
        PyApp() -> None
        
        The wxApp class represents the application itself when wxUSE_GUI=1.
        """

    def MacNewFile(self) -> None:
        """
        MacNewFile() -> None
        
        Called in response of an "open-application" Apple event.
        """

    def MacOpenFiles(self, fileNames: List[str]) -> None:
        """
        MacOpenFiles(fileNames) -> None
        
        Called in response of an openFiles message.
        """

    def MacOpenFile(self, fileName: str) -> None:
        """
        MacOpenFile(fileName) -> None
        
        Called in response of an "open-document" Apple event.
        """

    def MacOpenURL(self, url: str) -> None:
        """
        MacOpenURL(url) -> None
        
        Called in response of a "get-url" Apple event.
        """

    def MacPrintFile(self, fileName: str) -> None:
        """
        MacPrintFile(fileName) -> None
        
        Called in response of a "print-document" Apple event.
        """

    def MacReopenApp(self) -> None:
        """
        MacReopenApp() -> None
        
        Called in response of a "reopen-application" Apple event.
        """

    def OSXIsGUIApplication(self) -> bool:
        """
        OSXIsGUIApplication() -> bool
        
        May be overridden to indicate that the application is not a foreground
        GUI application under macOS.
        """

    def OSXEnableAutomaticTabbing(self, enable: bool) -> None:
        """
        OSXEnableAutomaticTabbing(enable) -> None
        
        Enable the automatic tabbing features of macOS.
        """

    @staticmethod
    def GTKSuppressDiagnostics(flags: int=-1) -> None:
        """
        GTKSuppressDiagnostics(flags=-1) -> None
        
        Disables the printing of various GTK messages.
        """

    @staticmethod
    def GTKAllowDiagnosticsControl() -> None:
        """
        GTKAllowDiagnosticsControl() -> None
        
        Allows wxWidgets to selectively suppress some GTK messages.
        """

    def GetDisplayMode(self) -> VideoMode:
        """
        GetDisplayMode() -> VideoMode
        
        Get display mode that is used use.
        """

    def GetExitOnFrameDelete(self) -> bool:
        """
        GetExitOnFrameDelete() -> bool
        
        Returns true if the application will exit when the top-level frame is
        deleted.
        """

    def GetLayoutDirection(self) -> LayoutDirection:
        """
        GetLayoutDirection() -> LayoutDirection
        
        Return the layout direction for the current locale or wxLayout_Default
        if it's unknown.
        """

    def GetUseBestVisual(self) -> bool:
        """
        GetUseBestVisual() -> bool
        
        Returns true if the application will use the best visual on systems
        that support different visuals, false otherwise.
        """

    def GetTopWindow(self) -> Window:
        """
        GetTopWindow() -> Window
        
        Returns a pointer to the top window.
        """

    def IsActive(self) -> bool:
        """
        IsActive() -> bool
        
        Returns true if the application is active, i.e. if one of its windows
        is currently in the foreground.
        """

    def SafeYield(self, win: Window, onlyIfNeeded: bool) -> bool:
        """
        SafeYield(win, onlyIfNeeded) -> bool
        
        This function is similar to wxYield(), except that it disables the
        user input to all program windows before calling wxAppConsole::Yield
        and re-enables it again afterwards.
        """

    def SafeYieldFor(self, win: Window, eventsToProcess: int) -> bool:
        """
        SafeYieldFor(win, eventsToProcess) -> bool
        
        Works like SafeYield() with onlyIfNeeded == true except that it allows
        the caller to specify a mask of events to be processed.
        """

    def SetDisplayMode(self, info: VideoMode) -> bool:
        """
        SetDisplayMode(info) -> bool
        
        Set display mode to use.
        """

    def SetExitOnFrameDelete(self, flag: bool) -> None:
        """
        SetExitOnFrameDelete(flag) -> None
        
        Allows the programmer to specify whether the application will exit
        when the top-level frame is deleted.
        """

    def SetNativeTheme(self, theme: str) -> bool:
        """
        SetNativeTheme(theme) -> bool
        
        Allows runtime switching of the UI environment theme.
        """

    def SetTopWindow(self, window: Window) -> None:
        """
        SetTopWindow(window) -> None
        
        Sets the 'top' window.
        """

    def SetUseBestVisual(self, flag: bool, forceTrueColour: bool=False) -> None:
        """
        SetUseBestVisual(flag, forceTrueColour=False) -> None
        
        Allows the programmer to specify whether the application will use the
        best visual on systems that support several visual on the same
        display.
        """

    @staticmethod
    def GetMainTopWindow() -> Window:
        """
        GetMainTopWindow() -> Window
        
        Returns a pointer to the top application window if any.
        """

    def MacHideApp(self) -> None:
        """
        MacHideApp() -> None
        
        Hide all application windows just as the user can do with the
        system Hide command.  Mac only.
        """

    @staticmethod
    def GetComCtl32Version() -> int:
        """
        GetComCtl32Version() -> int
        
        Returns 400, 470, 471, etc. for comctl32.dll 4.00, 4.70, 4.71 or 0 if
        it wasn't found at all.  Raises an exception on non-Windows platforms.
        """

    def GetAssertMode(self) -> AppAssertMode:
        """
        GetAssertMode() -> AppAssertMode
        
        Returns the current mode for how the application responds to wx
        asserts.
        """

    def SetAssertMode(self, wxAppAssertMode: AppAssertMode) -> None:
        """
        SetAssertMode(wxAppAssertMode) -> None
        
        Set the mode indicating how the application responds to wx assertion
        statements. Valid settings are a combination of these flags:
        
            - wx.APP_ASSERT_SUPPRESS
            - wx.APP_ASSERT_EXCEPTION
            - wx.APP_ASSERT_DIALOG
            - wx.APP_ASSERT_LOG
        
        The default behavior is to raise a wx.wxAssertionError exception.
        """

    @staticmethod
    def IsDisplayAvailable() -> bool:
        """
        IsDisplayAvailable() -> bool
        
        Returns True if the application is able to connect to the system's
        display, or whatever the equivallent is for the platform.
        """
    @property
    def AssertMode(self) -> AppAssertMode: ...
    @AssertMode.setter
    def AssertMode(self, value: AppAssertMode, /) -> None: ...
    @property
    def DisplayMode(self) -> VideoMode: ...
    @DisplayMode.setter
    def DisplayMode(self, value: VideoMode, /) -> None: ...
    @property
    def ExitOnFrameDelete(self) -> bool: ...
    @ExitOnFrameDelete.setter
    def ExitOnFrameDelete(self, value: bool, /) -> None: ...
    @property
    def LayoutDirection(self) -> LayoutDirection: ...
    @property
    def UseBestVisual(self) -> bool: ...
    @UseBestVisual.setter
    def UseBestVisual(self, value: bool, /) -> None: ...
    @property
    def TopWindow(self) -> Window: ...
    @TopWindow.setter
    def TopWindow(self, value: Window, /) -> None: ...
# end of class PyApp


def GetApp() -> AppConsole:    """
    GetApp() -> AppConsole
    
    Returns the current application object.
    """

def HandleFatalExceptions(doIt: bool=True) -> bool:    """
    HandleFatalExceptions(doIt=True) -> bool
    
    If doIt is true, the fatal exceptions (also known as general
    protection faults under Windows or segmentation violations in the Unix
    world) will be caught and passed to wxApp::OnFatalException.
    """

def WakeUpIdle() -> None:    """
    WakeUpIdle() -> None
    
    This function wakes up the (internal and platform dependent) idle
    system, i.e.
    """

def Yield() -> bool:    """
    Yield() -> bool
    
    Calls wxAppConsole::Yield if there is an existing application object.
    """

def SafeYield(win: Optional[Window]=None, onlyIfNeeded: bool=False) -> bool:    """
    SafeYield(win=None, onlyIfNeeded=False) -> bool
    
    Calls wxApp::SafeYield.
    """

def Exit() -> None:    """
    Exit() -> None
    
    Exits application after calling wxApp::OnExit.
    """

def YieldIfNeeded():
    """
    Convenience function for wx.GetApp().Yield(True)
    """
    pass
class PyOnDemandOutputWindow(object):
    """
    A class that can be used for redirecting Python's stdout and
    stderr streams.  It will do nothing until something is wrriten to
    the stream at which point it will create a Frame with a text area
    and write the text there.
    """

    def __init__(self, title="wxPython: stdout/stderr"):
        pass

    def SetParent(self, parent):
        """
        Set the window to be used as the popup Frame's parent.
        """
        pass

    def CreateOutputWindow(self, txt):
        pass

    def OnCloseWindow(self, event):
        pass

    def write(self, text):
        """
        Create the output window if needed and write the string to it.
        If not called in the context of the gui thread then CallAfter is
        used to do the work there.
        """
        pass

    def close(self):
        pass

    def flush(self):
        pass
class App(PyApp):
    """
    The ``wx.App`` class represents the application and is used to:
    
      * bootstrap the wxPython system and initialize the underlying
        gui toolkit
      * set and get application-wide properties
      * implement the native windowing system main message or event loop,
        and to dispatch events to window instances
      * etc.
    
    Every wx application must have a single ``wx.App`` instance, and all
    creation of UI objects should be delayed until after the ``wx.App`` object
    has been created in order to ensure that the gui platform and wxWidgets
    have been fully initialized.
    
    Normally you would derive from this class and implement an ``OnInit``
    method that creates a frame and then calls ``self.SetTopWindow(frame)``,
    however ``wx.App`` is also usable on its own without derivation.
    
    :note: In Python the wrapper for the C++ class ``wxApp`` has been renamed tp
        :class:`wx.PyApp`. This ``wx.App`` class derives from ``wx.PyApp``, and is
        responsible for handling the Python-specific needs for bootstrapping the
        wxWidgets library and other Python integration related requirements.
    """

    outputWindowClass = PyOnDemandOutputWindow

    def __init__(self, redirect=False, filename=None, useBestVisual=False, clearSigInt=True):
        """
        Construct a ``wx.App`` object.
        
        :param redirect: Should ``sys.stdout`` and ``sys.stderr`` be
            redirected?  Defaults to False. If ``filename`` is None
            then output will be redirected to a window that pops up
            as needed.  (You can control what kind of window is created
            for the output by resetting the class variable
            ``outputWindowClass`` to a class of your choosing.)
        
        :param filename: The name of a file to redirect output to, if
            redirect is True.
        
        :param useBestVisual: Should the app try to use the best
            available visual provided by the system (only relevant on
            systems that have more than one visual.)  This parameter
            must be used instead of calling `SetUseBestVisual` later
            on because it must be set before the underlying GUI
            toolkit is initialized.
        
        :param clearSigInt: Should SIGINT be cleared?  This allows the
            app to terminate upon a Ctrl-C in the console like other
            GUI apps will.
        
        :note: You should override OnInit to do application
            initialization to ensure that the system, toolkit and
            wxWidgets are fully initialized.
        """
        pass

    def OnPreInit(self):
        """
        Things that must be done after _BootstrapApp has done its thing, but
        would be nice if they were already done by the time that OnInit is
        called.  This can be overridden in derived classes, but be sure to call
        this method from there.
        """
        pass

    def __del__(self):
        pass

    def SetTopWindow(self, frame):
        """
        Set the "main" top level window, which will be used for the parent of
        the on-demand output window as well as for dialogs that do not have
        an explicit parent set.
        """
        pass

    def MainLoop(self):
        """
        Execute the main GUI event loop
        """
        pass

    def RedirectStdio(self, filename=None):
        """
        Redirect sys.stdout and sys.stderr to a file or a popup window.
        """
        pass

    def RestoreStdio(self):
        pass

    def SetOutputWindowAttributes(self, title=None, pos=None, size=None):
        """
        Set the title, position and/or size of the output window if the stdio
        has been redirected. This should be called before any output would
        cause the output window to be created.
        """
        pass

    def InitLocale(self):
        """
        Starting with version 3.8 on Windows, Python is now setting the locale
        to what is defined by the system as the default locale. This causes
        problems with wxWidgets which expects to be able to manage the locale
        via the wx.Locale class, so the locale will be reset here to be the
        default "C" locale settings.
        
        If you have troubles from the default behavior of this method you can
        override it in a derived class to behave differently. Please report
        the problem you encountered.
        """
        pass

    def ResetLocale(self):
        """
        This method is now a NOP and will be deprecated.
        """
        pass

    @staticmethod
    def Get():
        """
        A staticmethod returning the currently active application object.
        Essentially just a more pythonic version of :meth:`GetApp`.
        """
        pass
@wx.deprecated
class PySimpleApp(App):
    """
    This class is deprecated.  Please use :class:`App` instead.
    """

    def __init__(self, *args, **kw):
        pass
#-- end-app --#
#-- begin-timer --#
TIMER_CONTINUOUS: bool
TIMER_ONE_SHOT: bool
wxEVT_TIMER: int

class Timer(EvtHandler):
    """
    Timer() -> None
    Timer(owner, id=-1) -> None
    
    The wxTimer class allows you to execute code at specified intervals.
    """

    @overload
    def __init__(self, owner: EvtHandler, id: int=-1) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Timer() -> None
        Timer(owner, id=-1) -> None
        
        The wxTimer class allows you to execute code at specified intervals.
        """

    def GetId(self) -> int:
        """
        GetId() -> int
        
        Returns the ID of the events generated by this timer.
        """

    def GetInterval(self) -> int:
        """
        GetInterval() -> int
        
        Returns the current interval for the timer (in milliseconds).
        """

    def GetOwner(self) -> EvtHandler:
        """
        GetOwner() -> EvtHandler
        
        Returns the current owner of the timer.
        """

    def IsOneShot(self) -> bool:
        """
        IsOneShot() -> bool
        
        Returns true if the timer is one shot, i.e. if it will stop after
        firing the first notification automatically.
        """

    def IsRunning(self) -> bool:
        """
        IsRunning() -> bool
        
        Returns true if the timer is running, false if it is stopped.
        """

    def Notify(self) -> None:
        """
        Notify() -> None
        
        This member should be overridden by the user if the default
        constructor was used and SetOwner() wasn't called.
        """

    def SetOwner(self, owner: EvtHandler, id: int=-1) -> None:
        """
        SetOwner(owner, id=-1) -> None
        
        Associates the timer with the given owner object.
        """

    def Start(self, milliseconds: int=-1, oneShot: bool=TIMER_CONTINUOUS) -> bool:
        """
        Start(milliseconds=-1, oneShot=TIMER_CONTINUOUS) -> bool
        
        (Re)starts the timer.
        """

    def StartOnce(self, milliseconds: int=-1) -> bool:
        """
        StartOnce(milliseconds=-1) -> bool
        
        Starts the timer for a once-only notification.
        """

    def Stop(self) -> None:
        """
        Stop() -> None
        
        Stops the timer.
        """
    @property
    def Id(self) -> int: ...
    @property
    def Interval(self) -> int: ...
    @property
    def Owner(self) -> EvtHandler: ...
    @Owner.setter
    def Owner(self, value: EvtHandler, /) -> None: ...
# end of class Timer


class TimerRunner:
    """
    TimerRunner(timer) -> None
    TimerRunner(timer, milli, oneShot=False) -> None
    
    Starts the timer in its ctor, stops in the dtor.
    """

    @overload
    def __init__(self, timer: Timer, milli: int, oneShot: bool=False) -> None:
        ...

    @overload
    def __init__(self, timer: Timer) -> None:
        """
        TimerRunner(timer) -> None
        TimerRunner(timer, milli, oneShot=False) -> None
        
        Starts the timer in its ctor, stops in the dtor.
        """

    def Start(self, milli: int, oneShot: bool=False) -> None:
        """
        Start(milli, oneShot=False) -> None
        """
# end of class TimerRunner


class TimerEvent(Event):
    """
    TimerEvent(timer) -> None
    
    wxTimerEvent object is passed to the event handler of timer events
    (see wxTimer::SetOwner).
    """

    def __init__(self, timer: Timer) -> None:
        """
        TimerEvent(timer) -> None
        
        wxTimerEvent object is passed to the event handler of timer events
        (see wxTimer::SetOwner).
        """

    def GetInterval(self) -> int:
        """
        GetInterval() -> int
        
        Returns the interval of the timer which generated this event.
        """

    def GetTimer(self) -> Timer:
        """
        GetTimer() -> Timer
        
        Returns the timer object which generated this event.
        """
    @property
    def Interval(self) -> int: ...
    @property
    def Timer(self) -> Timer: ...
# end of class TimerEvent


EVT_TIMER = wx.PyEventBinder( wxEVT_TIMER )

class PyTimer(Timer):
    '''This timer class is passed the callable object to be called when the timer expires.'''
    def __init__(self, notify):
        Timer.__init__(self)
        self.notify = notify

    def Notify(self):
        if self.notify:
            self.notify()
#-- end-timer --#
#-- begin-window --#

class _ShowEffect(IntEnum):
    SHOW_EFFECT_NONE = auto()
    SHOW_EFFECT_ROLL_TO_LEFT = auto()
    SHOW_EFFECT_ROLL_TO_RIGHT = auto()
    SHOW_EFFECT_ROLL_TO_TOP = auto()
    SHOW_EFFECT_ROLL_TO_BOTTOM = auto()
    SHOW_EFFECT_SLIDE_TO_LEFT = auto()
    SHOW_EFFECT_SLIDE_TO_RIGHT = auto()
    SHOW_EFFECT_SLIDE_TO_TOP = auto()
    SHOW_EFFECT_SLIDE_TO_BOTTOM = auto()
    SHOW_EFFECT_BLEND = auto()
    SHOW_EFFECT_EXPAND = auto()
    SHOW_EFFECT_MAX = auto()
ShowEffect: TypeAlias = Union[_ShowEffect, int]
SHOW_EFFECT_NONE = _ShowEffect.SHOW_EFFECT_NONE
SHOW_EFFECT_ROLL_TO_LEFT = _ShowEffect.SHOW_EFFECT_ROLL_TO_LEFT
SHOW_EFFECT_ROLL_TO_RIGHT = _ShowEffect.SHOW_EFFECT_ROLL_TO_RIGHT
SHOW_EFFECT_ROLL_TO_TOP = _ShowEffect.SHOW_EFFECT_ROLL_TO_TOP
SHOW_EFFECT_ROLL_TO_BOTTOM = _ShowEffect.SHOW_EFFECT_ROLL_TO_BOTTOM
SHOW_EFFECT_SLIDE_TO_LEFT = _ShowEffect.SHOW_EFFECT_SLIDE_TO_LEFT
SHOW_EFFECT_SLIDE_TO_RIGHT = _ShowEffect.SHOW_EFFECT_SLIDE_TO_RIGHT
SHOW_EFFECT_SLIDE_TO_TOP = _ShowEffect.SHOW_EFFECT_SLIDE_TO_TOP
SHOW_EFFECT_SLIDE_TO_BOTTOM = _ShowEffect.SHOW_EFFECT_SLIDE_TO_BOTTOM
SHOW_EFFECT_BLEND = _ShowEffect.SHOW_EFFECT_BLEND
SHOW_EFFECT_EXPAND = _ShowEffect.SHOW_EFFECT_EXPAND
SHOW_EFFECT_MAX = _ShowEffect.SHOW_EFFECT_MAX

class _enum_(IntEnum):
    TOUCH_NONE = auto()
    TOUCH_VERTICAL_PAN_GESTURE = auto()
    TOUCH_HORIZONTAL_PAN_GESTURE = auto()
    TOUCH_PAN_GESTURES = auto()
    TOUCH_ZOOM_GESTURE = auto()
    TOUCH_ROTATE_GESTURE = auto()
    TOUCH_PRESS_GESTURES = auto()
    TOUCH_ALL_GESTURES = auto()
TOUCH_NONE = _enum_.TOUCH_NONE
TOUCH_VERTICAL_PAN_GESTURE = _enum_.TOUCH_VERTICAL_PAN_GESTURE
TOUCH_HORIZONTAL_PAN_GESTURE = _enum_.TOUCH_HORIZONTAL_PAN_GESTURE
TOUCH_PAN_GESTURES = _enum_.TOUCH_PAN_GESTURES
TOUCH_ZOOM_GESTURE = _enum_.TOUCH_ZOOM_GESTURE
TOUCH_ROTATE_GESTURE = _enum_.TOUCH_ROTATE_GESTURE
TOUCH_PRESS_GESTURES = _enum_.TOUCH_PRESS_GESTURES
TOUCH_ALL_GESTURES = _enum_.TOUCH_ALL_GESTURES

class _enum_(IntEnum):
    SEND_EVENT_POST = auto()
SEND_EVENT_POST = _enum_.SEND_EVENT_POST

class _WindowVariant(IntEnum):
    WINDOW_VARIANT_NORMAL = auto()
    WINDOW_VARIANT_SMALL = auto()
    WINDOW_VARIANT_MINI = auto()
    WINDOW_VARIANT_LARGE = auto()
    WINDOW_VARIANT_MAX = auto()
WindowVariant: TypeAlias = Union[_WindowVariant, int]
WINDOW_VARIANT_NORMAL = _WindowVariant.WINDOW_VARIANT_NORMAL
WINDOW_VARIANT_SMALL = _WindowVariant.WINDOW_VARIANT_SMALL
WINDOW_VARIANT_MINI = _WindowVariant.WINDOW_VARIANT_MINI
WINDOW_VARIANT_LARGE = _WindowVariant.WINDOW_VARIANT_LARGE
WINDOW_VARIANT_MAX = _WindowVariant.WINDOW_VARIANT_MAX

class VisualAttributes:
    """
    Struct containing all the visual attributes of a control.
    """
    font: Font
    colFg: Colour
    colBg: Colour
# end of class VisualAttributes

PanelNameStr: str

class WindowBase(EvtHandler):
    """
    
    """

    def AddChild(self, child: WindowBase) -> None:
        """
        AddChild(child) -> None
        """

    def RemoveChild(self, child: WindowBase) -> None:
        """
        RemoveChild(child) -> None
        """
# end of class WindowBase


class Window(WindowBase):
    """
    Window() -> None
    Window(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> None
    
    wxWindow is the base class for all windows and represents any visible
    object on screen.
    """

    class ChildrenRepositioningGuard:
        """
        ChildrenRepositioningGuard(win) -> None
        
        Helper for ensuring EndRepositioningChildren() is called correctly.
        """

        def __init__(self, win: Window) -> None:
            """
            ChildrenRepositioningGuard(win) -> None
            
            Helper for ensuring EndRepositioningChildren() is called correctly.
            """
    # end of class ChildrenRepositioningGuard


    @overload
    def __init__(self, parent: Window, id: int=ID_ANY, pos: Point=DefaultPosition, size: Size=DefaultSize, style: int=0, name: str=PanelNameStr) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """
        Window() -> None
        Window(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> None
        
        wxWindow is the base class for all windows and represents any visible
        object on screen.
        """

    def AcceptsFocus(self) -> bool:
        """
        AcceptsFocus() -> bool
        
        This method may be overridden in the derived classes to return false
        to indicate that this control doesn't accept input at all (i.e.
        behaves like e.g. wxStaticText) and so doesn't need focus.
        """

    def AcceptsFocusFromKeyboard(self) -> bool:
        """
        AcceptsFocusFromKeyboard() -> bool
        
        This method may be overridden in the derived classes to return false
        to indicate that while this control can, in principle, have focus if
        the user clicks it with the mouse, it shouldn't be included in the TAB
        traversal chain when using the keyboard.
        """

    def AcceptsFocusRecursively(self) -> bool:
        """
        AcceptsFocusRecursively() -> bool
        
        Overridden to indicate whether this window or one of its children
        accepts focus.
        """

    def DisableFocusFromKeyboard(self) -> None:
        """
        DisableFocusFromKeyboard() -> None
        
        Disable giving focus to this window using the keyboard navigation
        keys.
        """

    def IsFocusable(self) -> bool:
        """
        IsFocusable() -> bool
        
        Can this window itself have focus?
        """

    def CanAcceptFocus(self) -> bool:
        """
        CanAcceptFocus() -> bool
        
        Can this window have focus right now?
        """

    def CanAcceptFocusFromKeyboard(self) -> bool:
        """
        CanAcceptFocusFromKeyboard() -> bool
        
        Can this window be assigned focus from keyboard right now?
        """

    def HasFocus(self) -> bool:
        """
        HasFocus() -> bool
        
        Returns true if the window (or in case of composite controls, its main
        child window) has focus.
        """

    def SetCanFocus(self, canFocus: bool) -> None:
        """
        SetCanFocus(canFocus) -> None
        
        This method is only implemented by ports which have support for native
        TAB traversal (such as GTK+ 2.0).
        """

    def EnableVisibleFocus(self, enable: bool) -> None:
        """
        EnableVisibleFocus(enable) -> None
        
        Enables or disables visible indication of keyboard focus.
        """

    def SetFocus(self) -> None:
        """
        SetFocus() -> None
        
        This sets the window to receive keyboard input.
        """

    def SetFocusFromKbd(self) -> None:
        """
        SetFocusFromKbd() -> None
        
        This function is called by wxWidgets keyboard navigation code when the
        user gives the focus to this window from keyboard (e.g. using TAB
        key).
        """

    def AddChild(self, child: WindowBase) -> None:
        """
        AddChild(child) -> None
        
        Adds a child window.
        """

    def DestroyChildren(self) -> bool:
        """
        DestroyChildren() -> bool
        
        Destroys all children of a window.
        """

    @overload
    def FindWindow(self, name: str) -> Window:
        ...

    @overload
    def FindWindow(self, id: int) -> Window:
        """
        FindWindow(id) -> Window
        FindWindow(name) -> Window
        
        Find a child of this window, by id.
        """

    def GetChildren(self) -> WindowList:
        """
        GetChildren() -> WindowList
        
        Returns a reference to the list of the window's children.
        """

    def RemoveChild(self, child: WindowBase) -> None:
        """
        RemoveChild(child) -> None
        
        Removes a child window.
        """

    def GetGrandParent(self) -> Window:
        """
        GetGrandParent() -> Window
        
        Returns the grandparent of a window, or NULL if there isn't one.
        """

    def GetNextSibling(self) -> Window:
        """
        GetNextSibling() -> Window
        
        Returns the next window after this one among the parent's children or
        NULL if this window is the last child.
        """

    def GetParent(self) -> Window:
        """
        GetParent() -> Window
        
        Returns the parent of the window, or NULL if there is no parent.
        """

    def GetPrevSibling(self) -> Window:
        """
        GetPrevSibling() -> Window
        
        Returns the previous window before this one among the parent's
        children or NULL if this window is the first child.
        """

    def IsDescendant(self, win: Window) -> bool:
        """
        IsDescendant(win) -> bool
        
        Check if the specified window is a descendant of this one.
        """

    def Reparent(self, newParent: Window) -> bool:
        """
        Reparent(newParent) -> bool
        
        Reparents the window, i.e. the window will be removed from its current parent window (e.g.
        """

    def AlwaysShowScrollbars(self, hflag: bool=True, vflag: bool=True) -> None:
        """
        AlwaysShowScrollbars(hflag=True, vflag=True) -> None
        
        Call this function to force one or both scrollbars to be always shown,
        even if the window is big enough to show its entire contents without
        scrolling.
        """

    def GetScrollPos(self, orientation: int) -> int:
        """
        GetScrollPos(orientation) -> int
        
        Returns the built-in scrollbar position.
        """

    def GetScrollRange(self, orientation: int) -> int:
        """
        GetScrollRange(orientation) -> int
        
        Returns the built-in scrollbar range.
        """

    def GetScrollThumb(self, orientation: int) -> int:
        """
        GetScrollThumb(orientation) -> int
        
        Returns the built-in scrollbar thumb size.
        """

    def CanScroll(self, orient: int) -> bool:
        """
        CanScroll(orient) -> bool
        
        Returns true if this window can have a scroll bar in this orientation.
        """

    def HasScrollbar(self, orient: int) -> bool:
        """
        HasScrollbar(orient) -> bool
        
        Returns true if this window currently has a scroll bar for this
        orientation.
        """

    def IsScrollbarAlwaysShown(self, orient: int) -> bool:
        """
        IsScrollbarAlwaysShown(orient) -> bool
        
        Return whether a scrollbar is always shown.
        """

    def ScrollLines(self, lines: int) -> bool:
        """
        ScrollLines(lines) -> bool
        
        Scrolls the window by the given number of lines down (if lines is
        positive) or up.
        """

    def ScrollPages(self, pages: int) -> bool:
        """
        ScrollPages(pages) -> bool
        
        Scrolls the window by the given number of pages down (if pages is
        positive) or up.
        """

    def ScrollWindow(self, dx: int, dy: int, rect: Optional[Rect]=None) -> None:
        """
        ScrollWindow(dx, dy, rect=None) -> None
        
        Physically scrolls the pixels in the window and move child windows
        accordingly.
        """

    def LineUp(self) -> bool:
        """
        LineUp() -> bool
        
        Same as ScrollLines (-1).
        """

    def LineDown(self) -> bool:
        """
        LineDown() -> bool
        
        Same as ScrollLines (1).
        """

    def PageUp(self) -> bool:
        """
        PageUp() -> bool
        
        Same as ScrollPages (-1).
        """

    def PageDown(self) -> bool:
        """
        PageDown() -> bool
        
        Same as ScrollPages (1).
        """

    def SetScrollPos(self, orientation: int, pos: int, refresh: bool=True) -> None:
        """
        SetScrollPos(orientation, pos, refresh=True) -> None
        
        Sets the position of one of the built-in scrollbars.
        """

    def SetScrollbar(self, orientation: int, position: int, thumbSize: int, range: int, refresh: bool=True) -> None:
        """
        SetScrollbar(orientation, position, thumbSize, range, refresh=True) -> None
        
        Sets the scrollbar properties of a built-in scrollbar.
        """

    def BeginRepositioningChildren(self) -> bool:
        """
        BeginRepositioningChildren() -> bool
        
        Prepare for changing positions of multiple child windows.
        """

    def EndRepositioningChildren(self) -> None:
        """
        EndRepositioningChildren() -> None
        
        Fix child window positions after setting all of them at once.
        """

    def CacheBestSize(self, size: Size) -> None:
        """
        CacheBestSize(size) -> None
        
        Sets the cached best size value.
        """

    def ClientToWindowSize(self, size: Size) -> Size:
        """
        ClientToWindowSize(size) -> Size
        
        Converts client area size size to corresponding window size.
        """

    def WindowToClientSize(self, size: Size) -> Size:
        """
        WindowToClientSize(size) -> Size
        
        Converts window size size to corresponding client area size In other
        words, the returned value is what would GetClientSize() return if this
        window had given window size.
        """

    def Fit(self) -> None:
        """
        Fit() -> None
        
        Sizes the window to fit its best size.
        """

    def FitInside(self) -> None:
        """
        FitInside() -> None
        
        Similar to Fit(), but sizes the interior (virtual) size of a window.
        """

    @overload
    def FromDIP(self, pt: Point) -> Point:
        ...

    @overload
    def FromDIP(self, d: int) -> int:
        ...

    @overload
    @staticmethod
    def FromDIP(sz: Size, w: Window) -> Size:
        ...

    @overload
    @staticmethod
    def FromDIP(pt: Point, w: Window) -> Point:
        ...

    @overload
    @staticmethod
    def FromDIP(d: int, w: Window) -> int:
        ...

    @overload
    def FromDIP(self, sz: Size) -> Size:
        """
        FromDIP(sz) -> Size
        FromDIP(pt) -> Point
        FromDIP(d) -> int
        FromDIP(sz, w) -> Size
        FromDIP(pt, w) -> Point
        FromDIP(d, w) -> int
        
        Convert DPI-independent pixel values to the value in pixels
        appropriate for the current toolkit.
        """

    @overload
    def ToDIP(self, pt: Point) -> Point:
        ...

    @overload
    def ToDIP(self, d: int) -> int:
        ...

    @overload
    @staticmethod
    def ToDIP(sz: Size, w: Window) -> Size:
        ...

    @overload
    @staticmethod
    def ToDIP(pt: Point, w: Window) -> Point:
        ...

    @overload
    @staticmethod
    def ToDIP(d: int, w: Window) -> int:
        ...

    @overload
    def ToDIP(self, sz: Size) -> Size:
        """
        ToDIP(sz) -> Size
        ToDIP(pt) -> Point
        ToDIP(d) -> int
        ToDIP(sz, w) -> Size
        ToDIP(pt, w) -> Point
        ToDIP(d, w) -> int
        
        Convert pixel values of the current toolkit to DPI-independent pixel
        values.
        """

    @overload
    def FromPhys(self, pt: Point) -> Point:
        ...

    @overload
    def FromPhys(self, d: int) -> int:
        ...

    @overload
    @staticmethod
    def FromPhys(sz: Size, w: Window) -> Size:
        ...

    @overload
    @staticmethod
    def FromPhys(pt: Point, w: Window) -> Point:
        ...

    @overload
    @staticmethod
    def FromPhys(d: int, w: Window) -> int:
        ...

    @overload
    def FromPhys(self, sz: Size) -> Size:
        """
        FromPhys(sz) -> Size
        FromPhys(pt) -> Point
        FromPhys(d) -> int
        FromPhys(sz, w) -> Size
        FromPhys(pt, w) -> Point
        FromPhys(d, w) -> int
        
        Convert from physical pixels to logical pixels.
        """

    @overload
    def ToPhys(self, pt: Point) -> Point:
        ...

    @overload
    def ToPhys(self, d: int) -> int:
        ...

    @overload
    @staticmethod
    def ToPhys(sz: Size, w: Window) -> Size:
        ...

    @overload
    @staticmethod
    def ToPhys(pt: Point, w: Window) -> Point:
        ...

    @overload
    @staticmethod
    def ToPhys(d: int, w: Window) -> int:
        ...

    @overload
    def ToPhys(self, sz: Size) -> Size:
        """
        ToPhys(sz) -> Size
        ToPhys(pt) -> Point
        ToPhys(d) -> int
        ToPhys(sz, w) -> Size
        ToPhys(pt, w) -> Point
        ToPhys(d, w) -> int
        
        Convert from logical pixels to physical pixels.
        """

    def GetBestSize(self) -> Size:
        """
        GetBestSize() -> Size
        
        This functions returns the best acceptable minimal size for the
        window.
        """

    def GetBestHeight(self, width: int) -> int:
        """
        GetBestHeight(width) -> int
        
        Returns the best height needed by this window if it had the given
        width.
        """

    def GetBestWidth(self, height: int) -> int:
        """
        GetBestWidth(height) -> int
        
        Returns the best width needed by this window if it had the given
        height.
        """

    def GetClientSize(self) -> Size:
        """
        GetClientSize() -> Size
        
        Returns the size of the window 'client area' in pixels.
        """

    def GetEffectiveMinSize(self) -> Size:
        """
        GetEffectiveMinSize() -> Size
        
        Merges the window's best size into the min size and returns the
        result.
        """

    def GetMaxClientSize(self) -> Size:
        """
        GetMaxClientSize() -> Size
        
        Returns the maximum size of window's client area.
        """

    def GetMaxSize(self) -> Size:
        """
        GetMaxSize() -> Size
        
        Returns the maximum size of the window.
        """

    def GetMinClientSize(self) -> Size:
        """
        GetMinClientSize() -> Size
        
        Returns the minimum size of window's client area, an indication to the
        sizer layout mechanism that this is the minimum required size of its
        client area.
        """

    def GetMinSize(self) -> Size:
        """
        GetMinSize() -> Size
        
        Returns the minimum size of the window, an indication to the sizer
        layout mechanism that this is the minimum required size.
        """

    def GetMinWidth(self) -> int:
        """
        GetMinWidth() -> int
        
        Returns the horizontal component of window minimal size.
        """

    def GetMinHeight(self) -> int:
        """
        GetMinHeight() -> int
        
        Returns the vertical component of window minimal size.
        """

    def GetMaxWidth(self) -> int:
        """
        GetMaxWidth() -> int
        
        Returns the horizontal component of window maximal size.
        """

    def GetMaxHeight(self) -> int:
        """
        GetMaxHeight() -> int
        
        Returns the vertical component of window maximal size.
        """

    def GetSize(self) -> Size:
        """
        GetSize() -> Size
        
        Returns the size of the entire window in pixels, including title bar,
        border, scrollbars, etc.
        """

    def GetVirtualSize(self) -> Size:
        """
        GetVirtualSize() -> Size
        
        This gets the virtual size of the window in pixels.
        """

    def GetBestVirtualSize(self) -> Size:
        """
        GetBestVirtualSize() -> Size
        
        Return the largest of ClientSize and BestSize (as determined by a
        sizer, interior children, or other means)
        """

    def GetContentScaleFactor(self) -> float:
        """
        GetContentScaleFactor() -> float
        
        Returns the factor mapping logical pixels of this window to physical
        pixels.
        """

    def GetDPIScaleFactor(self) -> float:
        """
        GetDPIScaleFactor() -> float
        
        Returns the ratio of the DPI used by this window to the standard DPI.
        """

    def GetWindowBorderSize(self) -> Size:
        """
        GetWindowBorderSize() -> Size
        
        Returns the size of the left/right and top/bottom borders of this
        window in x and y components of the result respectively.
        """

    def InformFirstDirection(self, direction: int, size: int, availableOtherDir: int) -> bool:
        """
        InformFirstDirection(direction, size, availableOtherDir) -> bool
        
        wxSizer and friends use this to give a chance to a component to recalc
        its min size once one of the final size components is known.
        """

    def InvalidateBestSize(self) -> None:
        """
        InvalidateBestSize() -> None
        
        Resets the cached best size value so it will be recalculated the next
        time it is needed.
        """

    def PostSizeEvent(self) -> None:
        """
        PostSizeEvent() -> None
        
        Posts a size event to the window.
        """

    def PostSizeEventToParent(self) -> None:
        """
        PostSizeEventToParent() -> None
        
        Posts a size event to the parent of this window.
        """

    def SendSizeEvent(self, flags: int=0) -> None:
        """
        SendSizeEvent(flags=0) -> None
        
        This function sends a dummy size event to the window allowing it to
        re-layout its children positions.
        """

    def SendSizeEventToParent(self, flags: int=0) -> None:
        """
        SendSizeEventToParent(flags=0) -> None
        
        Safe wrapper for GetParent()->SendSizeEvent().
        """

    @overload
    def SetClientSize(self, size: Size) -> None:
        ...

    @overload
    def SetClientSize(self, rect: Rect) -> None:
        ...

    @overload
    def SetClientSize(self, width: int, height: int) -> None:
        """
        SetClientSize(width, height) -> None
        SetClientSize(size) -> None
        SetClientSize(rect) -> None
        
        This sets the size of the window client area in pixels.
        """

    def SetContainingSizer(self, sizer: Sizer) -> None:
        """
        SetContainingSizer(sizer) -> None
        
        Used by wxSizer internally to notify the window about being managed by
        the given sizer.
        """

    def SetInitialSize(self, size: Size=DefaultSize) -> None:
        """
        SetInitialSize(size=DefaultSize) -> None
        
        A smart SetSize that will fill in default size components with the
        window's best size values.
        """

    def SetMaxClientSize(self, size: Size) -> None:
        """
        SetMaxClientSize(size) -> None
        
        Sets the maximum client size of the window, to indicate to the sizer
        layout mechanism that this is the maximum possible size of its client
        area.
        """

    def SetMaxSize(self, size: Size) -> None:
        """
        SetMaxSize(size) -> None
        
        Sets the maximum size of the window, to indicate to the sizer layout
        mechanism that this is the maximum possible size.
        """

    def SetMinClientSize(self, size: Size) -> None:
        """
        SetMinClientSize(size) -> None
        
        Sets the minimum client size of the window, to indicate to the sizer
        layout mechanism that this is the minimum required size of window's
        client area.
        """

    def SetMinSize(self, size: Size) -> None:
        """
        SetMinSize(size) -> None
        
        Sets the minimum size of the window, to indicate to the sizer layout
        mechanism that this is the minimum required size.
        """

    @overload
    def SetSize(self, rect: Rect) -> None:
        ...

    @overload
    def SetSize(self, size: Size) -> None:
        ...

    @overload
    def SetSize(self, width: int, height: int) -> None:
        ...

    @overload
    def SetSize(self, x: int, y: int, width: int, height: int, sizeFlags: int=SIZE_AUTO) -> None:
        """
        SetSize(x, y, width, height, sizeFlags=SIZE_AUTO) -> None
        SetSize(rect) -> None
        SetSize(size) -> None
        SetSize(width, height) -> None
        
        Sets the size of the window in pixels.
        """

    @overload
    def SetSizeHints(self, minW: int, minH: int, maxW: int=-1, maxH: int=-1, incW: int=-1, incH: int=-1) -> None:
        ...

    @overload
    def SetSizeHints(self, minSize: Size, maxSize: Size=DefaultSize, incSize: Size=DefaultSize) -> None:
        """
        SetSizeHints(minSize, maxSize=DefaultSize, incSize=DefaultSize) -> None
        SetSizeHints(minW, minH, maxW=-1, maxH=-1, incW=-1, incH=-1) -> None
        
        Use of this function for windows which are not toplevel windows (such
        as wxDialog or wxFrame) is discouraged.
        """

    @overload
    def SetVirtualSize(self, size: Size) -> None:
        ...

    @overload
    def SetVirtualSize(self, width: int, height: int) -> None:
        """
        SetVirtualSize(width, height) -> None
        SetVirtualSize(size) -> None
        
        Sets the virtual size of the window in pixels.
        """

    def Center(self, dir: int=BOTH) -> None:
        """
        Center(dir=BOTH) -> None
        
        A synonym for Centre().
        """

    def CenterOnParent(self, dir: int=BOTH) -> None:
        """
        CenterOnParent(dir=BOTH) -> None
        
        A synonym for CentreOnParent().
        """

    def Centre(self, direction: int=BOTH) -> None:
        """
        Centre(direction=BOTH) -> None
        
        Centres the window.
        """

    def CentreOnParent(self, direction: int=BOTH) -> None:
        """
        CentreOnParent(direction=BOTH) -> None
        
        Centres the window on its parent.
        """

    def GetPosition(self) -> Point:
        """
        GetPosition() -> Point
        
        This gets the position of the window in pixels, relative to the parent
        window for the child windows or relative to the display origin for the
        top level windows.
        """

    def GetRect(self) -> Rect:
        """
        GetRect() -> Rect
        
        Returns the position and size of the window as a wxRect object.
        """

    def GetScreenPosition(self) -> Point:
        """
        GetScreenPosition() -> Point
        
        Returns the window position in screen coordinates, whether the window
        is a child window or a top level one.
        """

    def GetScreenRect(self) -> Rect:
        """
        GetScreenRect() -> Rect
        
        Returns the position and size of the window on the screen as a wxRect
        object.
        """

    def GetClientAreaOrigin(self) -> Point:
        """
        GetClientAreaOrigin() -> Point
        
        Get the origin of the client area of the window relative to the window
        top left corner (the client area may be shifted because of the
        borders, scrollbars, other decorations...)
        """

    def GetClientRect(self) -> Rect:
        """
        GetClientRect() -> Rect
        
        Get the client rectangle in window (i.e. client) coordinates.
        """

    @overload
    def Move(self, pt: Point, flags: int=SIZE_USE_EXISTING) -> None:
        ...

    @overload
    def Move(self, x: int, y: int, flags: int=SIZE_USE_EXISTING) -> None:
        """
        Move(x, y, flags=SIZE_USE_EXISTING) -> None
        Move(pt, flags=SIZE_USE_EXISTING) -> None
        
        Moves the window to the given position.
        """

    def SetPosition(self, pt: Point) -> None:
        """
        SetPosition(pt) -> None
        
        Moves the window to the specified position.
        """

    @overload
    def ClientToScreen(self, pt: Point) -> Point:
        ...

    @overload
    def ClientToScreen(self, x: int, y: int) -> Tuple[int, int]:
        """
        ClientToScreen(x, y) -> Tuple[int, int]
        ClientToScreen(pt) -> Point
        
        Converts to screen coordinates from coordinates relative to this
        window.
        """

    @overload
    def ConvertDialogToPixels(self, sz: Size) -> Size:
        ...

    @overload
    def ConvertDialogToPixels(self, pt: Point) -> Point:
        """
        ConvertDialogToPixels(pt) -> Point
        ConvertDialogToPixels(sz) -> Size
        
        Converts a point or size from dialog units to pixels.
        """

    @overload
    def ConvertPixelsToDialog(self, sz: Size) -> Size:
        ...

    @overload
    def ConvertPixelsToDialog(self, pt: Point) -> Point:
        """
        ConvertPixelsToDialog(pt) -> Point
        ConvertPixelsToDialog(sz) -> Size
        
        Converts a point or size from pixels to dialog units.
        """

    @overload
    def ScreenToClient(self, pt: Point) -> Point:
        ...

    @overload
    def ScreenToClient(self, x: int, y: int) -> Tuple[int, int]:
        """
        ScreenToClient(x, y) -> Tuple[int, int]
        ScreenToClient(pt) -> Point
        
        Converts from screen to client window coordinates.
        """

    def ClearBackground(self) -> None:
        """
        ClearBackground() -> None
        
        Clears the window by filling it with the current background colour.
        """

    def Freeze(self) -> None:
        """
        Freeze() -> None
        
        Freezes the window or, in other words, prevents any updates from taking place on screen, the window is not redrawn at all.
        """

    def Thaw(self) -> None:
        """
        Thaw() -> None
        
        Re-enables window updating after a previous call to Freeze().
        """

    def IsFrozen(self) -> bool:
        """
        IsFrozen() -> bool
        
        Returns true if the window is currently frozen by a call to Freeze().
        """

    def GetBackgroundColour(self) -> Colour:
        """
        GetBackgroundColour() -> Colour
        
        Returns the background colour of the window.
        """

    def GetBackgroundStyle(self) -> BackgroundStyle:
        """
        GetBackgroundStyle() -> BackgroundStyle
        
        Returns the background style of the window.
        """

    def GetCharHeight(self) -> int:
        """
        GetCharHeight() -> int
        
        Returns the character height for this window.
        """

    def GetCharWidth(self) -> int:
        """
        GetCharWidth() -> int
        
        Returns the average character width for this window.
        """

    def GetDefaultAttributes(self) -> VisualAttributes:
        """
        GetDefaultAttributes() -> VisualAttributes
        
        Currently this is the same as calling
        wxWindow::GetClassDefaultAttributes(wxWindow::GetWindowVariant()).
        """

    def GetDPI(self) -> Size:
        """
        GetDPI() -> Size
        
        Return the DPI of the display used by this window.
        """

    def GetFont(self) -> Font:
        """
        GetFont() -> Font
        
        Returns the font for this window.
        """

    def GetForegroundColour(self) -> Colour:
        """
        GetForegroundColour() -> Colour
        
        Returns the foreground colour of the window.
        """

    def GetFullTextExtent(self, string: str, font: Optional[Font]=None) -> Tuple[int, int, int, int]:
        """
        GetFullTextExtent(string, font=None) -> Tuple[int, int, int, int]
        
        Gets the dimensions of the string as it would be drawn on the window
        with the currently selected font.
        """

    def GetTextExtent(self, string: str) -> Size:
        """
        GetTextExtent(string) -> Size
        
        Gets the dimensions of the string as it would be drawn on the window
        with the currently selected font.
        """

    def GetUpdateRegion(self) -> Region:
        """
        GetUpdateRegion() -> Region
        
        Returns the region specifying which parts of the window have been
        damaged.
        """

    def GetUpdateClientRect(self) -> Rect:
        """
        GetUpdateClientRect() -> Rect
        
        Get the update rectangle bounding box in client coords.
        """

    def HasTransparentBackground(self) -> bool:
        """
        HasTransparentBackground() -> bool
        
        Returns true if this window background is transparent (as, for
        example, for wxStaticText) and should show the parent window
        background.
        """

    def Refresh(self, eraseBackground: bool=True, rect: Optional[Rect]=None) -> None:
        """
        Refresh(eraseBackground=True, rect=None) -> None
        
        Causes this window, and all of its children recursively, to be
        repainted.
        """

    def RefreshRect(self, rect: Rect, eraseBackground: bool=True) -> None:
        """
        RefreshRect(rect, eraseBackground=True) -> None
        
        Redraws the contents of the given rectangle: only the area inside it
        will be repainted.
        """

    def Update(self) -> None:
        """
        Update() -> None
        
        Immediately repaints the invalidated area of the window and all of its
        children recursively.
        """

    def SetBackgroundColour(self, colour: Colour) -> bool:
        """
        SetBackgroundColour(colour) -> bool
        
        Sets the background colour of the window.
        """

    def SetBackgroundStyle(self, style: BackgroundStyle) -> bool:
        """
        SetBackgroundStyle(style) -> bool
        
        Sets the background style of the window.
        """

    def IsTransparentBackgroundSupported(self, reason: Optional[str]=None) -> bool:
        """
        IsTransparentBackgroundSupported(reason=None) -> bool
        
        Checks whether using transparent background might work.
        """

    def SetFont(self, font: Font) -> bool:
        """
        SetFont(font) -> bool
        
        Sets the font for this window.
        """

    def SetForegroundColour(self, colour: Colour) -> bool:
        """
        SetForegroundColour(colour) -> bool
        
        Sets the foreground colour of the window.
        """

    def SetOwnBackgroundColour(self, colour: Colour) -> None:
        """
        SetOwnBackgroundColour(colour) -> None
        
        Sets the background colour of the window but prevents it from being
        inherited by the children of this window.
        """

    def InheritsBackgroundColour(self) -> bool:
        """
        InheritsBackgroundColour() -> bool
        
        Return true if this window inherits the background colour from its
        parent.
        """

    def UseBgCol(self) -> bool:
        """
        UseBgCol() -> bool
        
        Return true if a background colour has been set for this window.
        """

    def UseBackgroundColour(self) -> bool:
        """
        UseBackgroundColour() -> bool
        
        Return true if a background colour has been set for this window.
        """

    def SetOwnFont(self, font: Font) -> None:
        """
        SetOwnFont(font) -> None
        
        Sets the font of the window but prevents it from being inherited by
        the children of this window.
        """

    def SetOwnForegroundColour(self, colour: Colour) -> None:
        """
        SetOwnForegroundColour(colour) -> None
        
        Sets the foreground colour of the window but prevents it from being
        inherited by the children of this window.
        """

    def UseForegroundColour(self) -> bool:
        """
        UseForegroundColour() -> bool
        
        Return true if a foreground colour has been set for this window.
        """

    def InheritsForegroundColour(self) -> bool:
        """
        InheritsForegroundColour() -> bool
        
        Return true if this window inherits the foreground colour from its
        parent.
        """

    def SetPalette(self, pal: Palette) -> None:
        """
        SetPalette(pal) -> None
        """

    def ShouldInheritColours(self) -> bool:
        """
        ShouldInheritColours() -> bool
        
        Return true from here to allow the colours of this window to be
        changed by InheritAttributes().
        """

    def SetThemeEnabled(self, enable: bool) -> None:
        """
        SetThemeEnabled(enable) -> None
        
        This function tells a window if it should use the system's "theme"
        code to draw the windows' background instead of its own background
        drawing code.
        """

    def GetThemeEnabled(self) -> bool:
        """
        GetThemeEnabled() -> bool
        
        Returns true if the window uses the system theme for drawing its
        background.
        """

    def CanSetTransparent(self) -> bool:
        """
        CanSetTransparent() -> bool
        
        Returns true if the system supports transparent windows and calling
        SetTransparent() may succeed.
        """

    def SetTransparent(self, alpha: Byte) -> bool:
        """
        SetTransparent(alpha) -> bool
        
        Set the transparency of the window.
        """

    def GetEventHandler(self) -> EvtHandler:
        """
        GetEventHandler() -> EvtHandler
        
        Returns the event handler for this window.
        """

    def HandleAsNavigationKey(self, event: KeyEvent) -> bool:
        """
        HandleAsNavigationKey(event) -> bool
        
        This function will generate the appropriate call to Navigate() if the
        key event is one normally used for keyboard navigation and return true
        in this case.
        """

    def HandleWindowEvent(self, event: Event) -> bool:
        """
        HandleWindowEvent(event) -> bool
        
        Shorthand for:
        """

    def ProcessWindowEvent(self, event: Event) -> bool:
        """
        ProcessWindowEvent(event) -> bool
        
        Convenient wrapper for ProcessEvent().
        """

    def ProcessWindowEventLocally(self, event: Event) -> bool:
        """
        ProcessWindowEventLocally(event) -> bool
        
        Wrapper for wxEvtHandler::ProcessEventLocally().
        """

    def PopEventHandler(self, deleteHandler: bool=False) -> EvtHandler:
        """
        PopEventHandler(deleteHandler=False) -> EvtHandler
        
        Removes and returns the top-most event handler on the event handler
        stack.
        """

    def PushEventHandler(self, handler: EvtHandler) -> None:
        """
        PushEventHandler(handler) -> None
        
        Pushes this event handler onto the event stack for the window.
        """

    def RemoveEventHandler(self, handler: EvtHandler) -> bool:
        """
        RemoveEventHandler(handler) -> bool
        
        Find the given handler in the windows event handler stack and removes
        (but does not delete) it from the stack.
        """

    def SetEventHandler(self, handler: EvtHandler) -> None:
        """
        SetEventHandler(handler) -> None
        
        Sets the event handler for this window.
        """

    def SetNextHandler(self, handler: EvtHandler) -> None:
        """
        SetNextHandler(handler) -> None
        
        wxWindows cannot be used to form event handler chains; this function
        thus will assert when called.
        """

    def SetPreviousHandler(self, handler: EvtHandler) -> None:
        """
        SetPreviousHandler(handler) -> None
        
        wxWindows cannot be used to form event handler chains; this function
        thus will assert when called.
        """

    def GetExtraStyle(self) -> int:
        """
        GetExtraStyle() -> int
        
        Returns the extra style bits for the window.
        """

    def GetWindowStyleFlag(self) -> int:
        """
        GetWindowStyleFlag() -> int
        
        Gets the window style that was passed to the constructor or Create()
        method.
        """

    def GetWindowStyle(self) -> int:
        """
        GetWindowStyle() -> int
        
        See GetWindowStyleFlag() for more info.
        """

    def HasExtraStyle(self, exFlag: int) -> bool:
        """
        HasExtraStyle(exFlag) -> bool
        
        Returns true if the window has the given exFlag bit set in its extra
        styles.
        """

    def HasFlag(self, flag: int) -> bool:
        """
        HasFlag(flag) -> bool
        
        Returns true if the window has the given flag bit set.
        """

    def SetExtraStyle(self, exStyle: int) -> None:
        """
        SetExtraStyle(exStyle) -> None
        
        Sets the extra style bits for the window.
        """

    def SetWindowStyleFlag(self, style: int) -> None:
        """
        SetWindowStyleFlag(style) -> None
        
        Sets the style of the window.
        """

    def SetWindowStyle(self, style: int) -> None:
        """
        SetWindowStyle(style) -> None
        
        See SetWindowStyleFlag() for more info.
        """

    def ToggleWindowStyle(self, flag: int) -> bool:
        """
        ToggleWindowStyle(flag) -> bool
        
        Turns the given flag on if it's currently turned off and vice versa.
        """

    def MoveAfterInTabOrder(self, win: Window) -> None:
        """
        MoveAfterInTabOrder(win) -> None
        
        Moves this window in the tab navigation order after the specified win.
        """

    def MoveBeforeInTabOrder(self, win: Window) -> None:
        """
        MoveBeforeInTabOrder(win) -> None
        
        Same as MoveAfterInTabOrder() except that it inserts this window just
        before win instead of putting it right after it.
        """

    def Navigate(self, flags: int=NavigationKeyEvent.IsForward) -> bool:
        """
        Navigate(flags=NavigationKeyEvent.IsForward) -> bool
        
        Performs a keyboard navigation action starting from this window.
        """

    def NavigateIn(self, flags: int=NavigationKeyEvent.IsForward) -> bool:
        """
        NavigateIn(flags=NavigationKeyEvent.IsForward) -> bool
        
        Performs a keyboard navigation action inside this window.
        """

    def Lower(self) -> None:
        """
        Lower() -> None
        
        Lowers the window to the bottom of the window hierarchy (Z-order).
        """

    def Raise(self) -> None:
        """
        Raise() -> None
        
        Raises the window to the top of the window hierarchy (Z-order).
        """

    def Hide(self) -> bool:
        """
        Hide() -> bool
        
        Equivalent to calling wxWindow::Show(false).
        """

    def HideWithEffect(self, effect: ShowEffect, timeout: int=0) -> bool:
        """
        HideWithEffect(effect, timeout=0) -> bool
        
        This function hides a window, like Hide(), but using a special visual
        effect if possible.
        """

    def IsEnabled(self) -> bool:
        """
        IsEnabled() -> bool
        
        Returns true if the window is enabled, i.e. if it accepts user input,
        false otherwise.
        """

    @overload
    def IsExposed(self, pt: Point) -> bool:
        ...

    @overload
    def IsExposed(self, x: int, y: int, w: int, h: int) -> bool:
        ...

    @overload
    def IsExposed(self, rect: Rect) -> bool:
        ...

    @overload
    def IsExposed(self, x: int, y: int) -> bool:
        """
        IsExposed(x, y) -> bool
        IsExposed(pt) -> bool
        IsExposed(x, y, w, h) -> bool
        IsExposed(rect) -> bool
        
        Returns true if the given point or rectangle area has been exposed
        since the last repaint.
        """

    def IsShown(self) -> bool:
        """
        IsShown() -> bool
        
        Returns true if the window is shown, false if it has been hidden.
        """

    def IsShownOnScreen(self) -> bool:
        """
        IsShownOnScreen() -> bool
        
        Returns true if the window is physically visible on the screen, i.e.
        it is shown and all its parents up to the toplevel window are shown as
        well.
        """

    def Disable(self) -> bool:
        """
        Disable() -> bool
        
        Disables the window.
        """

    def Enable(self, enable: bool=True) -> bool:
        """
        Enable(enable=True) -> bool
        
        Enable or disable the window for user input.
        """

    def Show(self, show: bool=True) -> bool:
        """
        Show(show=True) -> bool
        
        Shows or hides the window.
        """

    def ShowWithEffect(self, effect: ShowEffect, timeout: int=0) -> bool:
        """
        ShowWithEffect(effect, timeout=0) -> bool
        
        This function shows a window, like Show(), but using a special visual
        effect if possible.
        """

    def GetHelpText(self) -> str:
        """
        GetHelpText() -> str
        
        Gets the help text to be used as context-sensitive help for this
        window.
        """

    def SetHelpText(self, helpText: str) -> None:
        """
        SetHelpText(helpText) -> None
        
        Sets the help text to be used as context-sensitive help for this
        window.
        """

    def GetHelpTextAtPoint(self, point: Point, origin: HelpEvent.Origin) -> str:
        """
        GetHelpTextAtPoint(point, origin) -> str
        
        Gets the help text to be used as context-sensitive help for this
        window.
        """

    def GetToolTip(self) -> ToolTip:
        """
        GetToolTip() -> ToolTip
        
        Get the associated tooltip or NULL if none.
        """

    def GetToolTipText(self) -> str:
        """
        GetToolTipText() -> str
        
        Get the text of the associated tooltip or empty string if none.
        """

    @overload
    def SetToolTip(self, tip: ToolTip) -> None:
        ...

    @overload
    def SetToolTip(self, tipString: str) -> None:
        """
        SetToolTip(tipString) -> None
        SetToolTip(tip) -> None
        
        Attach a tooltip t