#ifndef CYTTHREAD_H
#define CYTTHREAD_H

#include <wx/thread.h>
#include "ytprotocol.h"


namespace tvlite
{

class CYTThread : public wxThread
{
private:
   CYTThread(const CYTThread&) = delete;
   CYTThread& operator=(const CYTThread&) = delete;
   CYTThread(CYTThread&&) = delete;
   CYTThread& operator=(CYTThread&&) = delete;
public:
   CYTThread() = delete;
   CYTThread(wxEvtHandler *handler, CYTProtocol *ytprocess); 
   virtual ~CYTThread();
   void SetRunning(bool run);
   bool GetRunning();
   

    // thread execution starts here
    virtual ExitCode Entry();
    
    protected:
    wxEvtHandler *m_ythandler;
    CYTProtocol  *m_ytprocess;
    bool m_running;
    wxMutex m_access;
};

}

#endif // CYTTHREAD_H
