#include "ytthread.h"

#include <wx/txtstrm.h>
#include "ytthread.h"
#include "debug.h"
#include "ytprotocolhandler.h"

using namespace tvlite;

CYTThread::CYTThread(wxEvtHandler *handler, CYTProtocol *process): 
                           wxThread(wxTHREAD_JOINABLE),
                           m_ythandler(handler),
                           m_ytprocess(process),
                           m_running(true)
{
   DBG_INFO(" YT Read Thread create");
}

CYTThread::~CYTThread()
{
}

void CYTThread::SetRunning(bool run)
{
   m_access.Lock();
   m_running = run;
   m_access.Unlock();
} 

bool CYTThread::GetRunning()
{
   bool state;
   m_access.Lock();
   state = m_running;
   m_access.Unlock();
   return state;
}

wxThread::ExitCode tvlite::CYTThread::Entry()
{
 
   DBG_INFO("YT Thread entered");
   if (!m_ytprocess->IsInputOpened())
   {
      DBG_ERROR("YT Input not opened. Leaving");
      
   }
   else
   {
       wxInputStream *errstream = m_ytprocess->GetErrorStream();
       if (errstream != NULL)
       {
            wxTextInputStream tis(*errstream);
            while (GetRunning())
            {           
                bool errdata = m_ytprocess->IsErrorAvailable();
                if (errdata )
                {
                  
                    wxString msg;
                    msg << tis.ReadLine();
                    wxLogDebug("%s\n", (const char*)msg.c_str());
                }
            }
        }
   }
   DBG_INFO("YT Protocol terminated");
   if  (!((CYTProtocolHandler*)m_ythandler)->WasStopped())
   {
           ((CYTProtocolHandler*)m_ythandler)->OnStopAsync();
   }
   DBG_INFO("YT Thread exit");
   
   return (wxThread::ExitCode)0;
}
