#ifndef CYTPROTOCOLHANDLER_H
#define CYTPROTOCOLHANDLER_H

#include <wx/timer.h>
#include "baseprotocolhandler.h"
#include "ytprotocol.h"
#include "ytthread.h"

namespace tvlite
{

class CYTProtocolHandler : public CBaseProtocolHandler
{
private:
   CYTProtocolHandler(const CYTProtocolHandler&) = delete;
   CYTProtocolHandler& operator=(const CYTProtocolHandler&) = delete;
   CYTProtocolHandler(CYTProtocolHandler&&) = delete;
   CYTProtocolHandler& operator=(CYTProtocolHandler&&) = delete;
   CYTProtocol *m_process;
   long m_protopid;

public:
   CYTProtocolHandler() = delete;
   CYTProtocolHandler(wxEvtHandler *parent, wxString url, wxString name, wxArrayString vlcoptions);
   virtual ~CYTProtocolHandler();
   int LaunchProcess();
   CYTProtocol *GetProtocol();
   void Start();
   void Stop();
   
   

};

}

#endif // CYTPROTOCOLHANDLER_H
