#include <wx/wfstream.h>
#include "ytprotocolhandler.h"
#include "debug.h"
#include "main.h"

using namespace tvlite;
//wxDEFINE_EVENT(thrEVT_EXIT, wxCommandEvent);

CYTProtocolHandler::CYTProtocolHandler(wxEvtHandler *parent, wxString url, wxString name, wxArrayString vlcoptions):
 CBaseProtocolHandler(parent, url, name, vlcoptions),
  m_process(NULL),
  m_protopid(0)
{
  
}

CYTProtocolHandler::~CYTProtocolHandler()
{
}

int CYTProtocolHandler::LaunchProcess()
{
   int result = E_OK;
   m_process = new CYTProtocol(this, m_url);
   if (!m_process)
   {
      DBG_ERROR("Could not create youtube protocol")
      result = E_ERROR;
   }
   if (result == E_OK)
   {
      result = m_process->StartProtocol(m_protopid);
   }
   else
   {
      DBG_ERROR("Could not start yt-dlp");
   }
   if (result == E_OK)
   {
      //Play VLC
      wxString addr;
      DBG_INFO("[YT Protocol handler]: Play VLC");
#ifndef __APPL_USE_FILESTREAM__  
      
      m_vlcPlayer->Play(elCallback, m_process, m_vlcoptions);
#else
      int fd  = m_process->GetFileDescriptor();
      if (fd > 0)
      {
         m_vlcPlayer->Play(elFileDescriptor, fd,  m_vlcoptions);
      }
      else
      {
         result = E_ERROR;
      }
#endif
   }
   
   return result;
}
   
   
void CYTProtocolHandler::Start()
{
   ((MainFrame*)wxGetApp().GetMainFrame())->SetStatusText(_("Starting yt-dlp"), 0);
   if ( LaunchProcess() == E_ERROR )
   {
      ((MainFrame*)wxGetApp().GetMainFrame())->SetStatusText(_("Could not start yt-dlp"), 0);
   }
}


void CYTProtocolHandler::Stop()
{
   if (!m_vlcPlayer->WasStopped())
   {
      m_vlcPlayer->Stop();
   }
   if (m_process)
   {
      m_process->StopProtocol();
   }
   OnStopAsync();
}

CYTProtocol * CYTProtocolHandler::GetProtocol()
{
    return m_process;
}