#ifndef CCHANNELEDIT_H
#define CCHANNELEDIT_H
#ifdef __WXMSW__

#include "gui-windows.h"
#else
#include "gui.h"
#endif

#include "main.h"
#include "channel.h"

namespace tvlite
{

class CChannelEdit:public CChannelEditBase
{
private:
   CChannelEdit(const CChannelEdit& rhs);
   CChannelEdit& operator=(const CChannelEdit& rhs);
   bool ValidateData();
   CStringToArrayStringHashMap m_vlcoptions;
   wxString m_oldurl;
   wxArrayString m_tempvlcopt;
   int m_editindex;

public:
   CChannelEdit();
   CChannelEdit(wxWindow *parent);
   virtual ~CChannelEdit();
   void GetData(CChannel *channel);
   void SetData(CChannel *channel);
   void FillGroups();
   
protected:
   virtual void OnAddAddress( wxCommandEvent& event ); 
   virtual void OnDeleteAddress( wxCommandEvent& event ); 
   virtual void OnOkClicked( wxCommandEvent& event );
   virtual void OnUpClicked( wxCommandEvent& event );
   virtual void OnDownClicked( wxCommandEvent& event );
   virtual void OnVLCOptClicked( wxCommandEvent& event );
   virtual void OnAddressEditDone( wxDataViewEvent& event );
   virtual void OnAddressEditStarted( wxDataViewEvent& event ); 
   virtual void OnItemChanged( wxDataViewEvent& event ); 

};

}

#endif // CCHANNELEDIT_H
