#include <wx/msgdlg.h>
#include <wx/wfstream.h>
#include <wx/string.h>
#include "main.h"
#include "debug.h"
#include "ytprotocol.h"
#include "ytprotocolhandler.h"
#include "configuration.h"


using namespace tvlite;

CYTProtocol::CYTProtocol(wxEvtHandler *parent, wxString url, wxString cmd):CBaseProtocol(parent,url, cmd),
 m_fileDescriptor(-1)
{
   Redirect();
}

tvlite::CYTProtocol::~CYTProtocol()
{
   DBG_INFO ("Youtube protocol -> delete"); 
}

int CYTProtocol::LoadConfig()
{
   //TODO stub
   return 0;   
}

int CYTProtocol::SaveConfig()
{
   //TODO stub
   return 0;
}

int CYTProtocol::GetFileDescriptor()
{
   return m_fileDescriptor;
}



int CYTProtocol::StartProtocol (long &pid)
{ 
   CConfiguration *conf = CConfiguration::Instance();
   DBG_INFO("Starting a new yt-dlp process");
   MainFrame *mainWindow = (MainFrame*)wxGetApp().GetTopWindow();
   pid = 0;
   int result = E_OK;
   m_cmd = conf->GetYTDlpConfiguration().GetFullPath();
   if (m_cmd == "")
   {
      if (SearchYT(m_cmd) != 0)
      {
         wxMessageBox(_("Could not search for yt-dlp.\n Check your installation!"), _("Error"), wxOK|wxICON_EXCLAMATION, mainWindow);
      }
      else
      {
         if (m_cmd == "")
         {
            wxMessageBox(_("Could not find yt-dlp in the path."), _("Error"), wxOK|wxICON_EXCLAMATION, mainWindow);
            result = E_ERROR;
         }   
      }
         
   }
   
   if (result == E_OK)
   {
      wxString cmd = m_cmd << " -o - " << conf->GetYTDlpConfiguration().GetParams();
      if (conf->GetYTDlpConfiguration().GetUseFFMpeg())
      {
         cmd << " --downloader ffmpeg ";
      }
      cmd << m_url; 
      DBG_INFO("yt-dlp command is '%s'.", (const char*)cmd.utf8_str());
      long rc = wxExecute(cmd, wxEXEC_ASYNC, this);
      pid = rc;
      if (rc == 0L)
      {
         DBG_ERROR("Execution of '%s' failed.", (const char*)cmd.utf8_str());
         wxMessageBox(_("Could not execute yt-dlp!"), _("Error"), wxOK|wxICON_EXCLAMATION, mainWindow);
         result = E_ERROR;
      }
   }
   if (result == E_OK)
   {  
      wxFileInputStream * pfis = (wxFileInputStream*)(GetInputStream());
      m_fileDescriptor =  pfis->GetFile()->fd();
   }
   if (result == E_OK)
   {
      m_ytthread = new CYTThread(m_pparent, this);
      if (m_ytthread == NULL)
      {
          DBG_ERROR("YT: Could not allocate thread");
          result = E_ERROR;
      }
   }
   if (result == E_OK)
   {
      if ( m_ytthread->Create() != wxTHREAD_NO_ERROR )
      {
          DBG_ERROR("Could not create thread");
          delete m_ytthread;
          m_ytthread = NULL;
          result = E_ERROR;
      }

   }
   if (result == E_OK)
   {
      if (m_ytthread->Run() != wxTHREAD_NO_ERROR)
      {
         DBG_ERROR("Could not run thread");
         result = E_ERROR;
      }

   }
   return result;
}

int CYTProtocol::SearchYT(wxString &cmd)
{
   wxArrayString res, err;
   long rc = wxExecute("which yt-dlp" , res, err);
   if (!rc)
   {
      if (!res.IsEmpty())
      {
         cmd = res[0];
      }   
   }
   return rc;
}

void CYTProtocol::StopProtocol()
{
   CBaseProtocol::StopProtocol();
   WaitThread();
  
}

void CYTProtocol::OnTerminate(int pid, int status)
{
   WaitThread();
}


void CYTProtocol::WaitThread()
{
   if (m_ytthread != NULL)
   {
      DBG_INFO("Waiting for thread");
      m_ytthread->SetRunning(false);
      m_ytthread->Wait();
      delete m_ytthread;
      m_ytthread = NULL;
      DBG_INFO("Finished wait");
   }
   else
   {
      DBG_INFO("Thread has been already destroyed");
   }
}