from typing import Any

from . import cairo as cairo
from . import constants as constants
from . import ffi as ffi
from .fonts import FontFace as FontFace
from .fonts import FontOptions as FontOptions
from .fonts import ScaledFont as ScaledFont
from .matrix import Matrix as Matrix
from .patterns import Pattern as Pattern
from .surfaces import Surface as Surface

PATH_POINTS_PER_TYPE: Any

class Context:
    def __init__(self, target) -> None: ...
    def get_target(self): ...
    def save(self) -> None: ...
    def restore(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type, exc_val, exc_tb) -> None: ...
    def push_group(self) -> None: ...
    def push_group_with_content(self, content) -> None: ...
    def pop_group(self): ...
    def pop_group_to_source(self) -> None: ...
    def get_group_target(self): ...
    def set_source_rgba(self, red, green, blue, alpha: int = ...) -> None: ...
    def set_source_rgb(self, red, green, blue) -> None: ...
    def set_source_surface(self, surface, x: int = ..., y: int = ...) -> None: ...
    def set_source(self, source) -> None: ...
    def get_source(self): ...
    def set_antialias(self, antialias) -> None: ...
    def get_antialias(self): ...
    def set_dash(self, dashes, offset: int = ...) -> None: ...
    def get_dash(self): ...
    def get_dash_count(self): ...
    def set_fill_rule(self, fill_rule) -> None: ...
    def get_fill_rule(self): ...
    def set_line_cap(self, line_cap) -> None: ...
    def get_line_cap(self): ...
    def set_line_join(self, line_join) -> None: ...
    def get_line_join(self): ...
    def set_line_width(self, width) -> None: ...
    def get_line_width(self): ...
    def set_miter_limit(self, limit) -> None: ...
    def get_miter_limit(self): ...
    def set_operator(self, operator) -> None: ...
    def get_operator(self): ...
    def set_tolerance(self, tolerance) -> None: ...
    def get_tolerance(self): ...
    def translate(self, tx, ty) -> None: ...
    def scale(self, sx, sy: Any | None = ...) -> None: ...
    def rotate(self, radians) -> None: ...
    def transform(self, matrix) -> None: ...
    def set_matrix(self, matrix) -> None: ...
    def get_matrix(self): ...
    def identity_matrix(self) -> None: ...
    def user_to_device(self, x, y): ...
    def user_to_device_distance(self, dx, dy): ...
    def device_to_user(self, x, y): ...
    def device_to_user_distance(self, dx, dy): ...
    def has_current_point(self): ...
    def get_current_point(self): ...
    def new_path(self) -> None: ...
    def new_sub_path(self) -> None: ...
    def move_to(self, x, y) -> None: ...
    def rel_move_to(self, dx, dy) -> None: ...
    def line_to(self, x, y) -> None: ...
    def rel_line_to(self, dx, dy) -> None: ...
    def rectangle(self, x, y, width, height) -> None: ...
    def arc(self, xc, yc, radius, angle1, angle2) -> None: ...
    def arc_negative(self, xc, yc, radius, angle1, angle2) -> None: ...
    def curve_to(self, x1, y1, x2, y2, x3, y3) -> None: ...
    def rel_curve_to(self, dx1, dy1, dx2, dy2, dx3, dy3) -> None: ...
    def text_path(self, text) -> None: ...
    def glyph_path(self, glyphs) -> None: ...
    def close_path(self) -> None: ...
    def copy_path(self): ...
    def copy_path_flat(self): ...
    def append_path(self, path) -> None: ...
    def path_extents(self): ...
    def paint(self) -> None: ...
    def paint_with_alpha(self, alpha) -> None: ...
    def mask(self, pattern) -> None: ...
    def mask_surface(self, surface, surface_x: int = ..., surface_y: int = ...) -> None: ...
    def fill(self) -> None: ...
    def fill_preserve(self) -> None: ...
    def fill_extents(self): ...
    def in_fill(self, x, y): ...
    def stroke(self) -> None: ...
    def stroke_preserve(self) -> None: ...
    def stroke_extents(self): ...
    def in_stroke(self, x, y): ...
    def clip(self) -> None: ...
    def clip_preserve(self) -> None: ...
    def clip_extents(self): ...
    def copy_clip_rectangle_list(self): ...
    def in_clip(self, x, y): ...
    def reset_clip(self) -> None: ...
    def select_font_face(self, family: str = ..., slant=..., weight=...) -> None: ...
    def set_font_face(self, font_face) -> None: ...
    def get_font_face(self): ...
    def set_font_size(self, size) -> None: ...
    def set_font_matrix(self, matrix) -> None: ...
    def get_font_matrix(self): ...
    def set_font_options(self, font_options) -> None: ...
    def get_font_options(self): ...
    def set_scaled_font(self, scaled_font) -> None: ...
    def get_scaled_font(self): ...
    def font_extents(self): ...
    def text_extents(self, text): ...
    def glyph_extents(self, glyphs): ...
    def show_text(self, text) -> None: ...
    def show_glyphs(self, glyphs) -> None: ...
    def show_text_glyphs(self, text, glyphs, clusters, cluster_flags: int = ...) -> None: ...
    def show_page(self) -> None: ...
    def copy_page(self) -> None: ...
    def tag_begin(self, tag_name, attributes: Any | None = ...) -> None: ...
    def tag_end(self, tag_name) -> None: ...
