/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nullable;

public enum ResourceRelevance {
    STANDARD,
    LIBRARY,
    SOURCE,
    MAPPED;


    public static ResourceRelevance getRelevance(VirtualFile resource2, @Nullable Module module, ProjectFileIndex fileIndex, @Nullable GlobalSearchScope additionalScope) {
        ExternalResourceManagerEx resourceManager;
        boolean inTest = fileIndex.isInTestSourceContent(resource2);
        if (module != null) {
            GlobalSearchScope scope = module.getModuleRuntimeScope(inTest);
            Module resourceModule = fileIndex.getModuleForFile(resource2);
            if (resourceModule != null && (resourceModule == module || scope.isSearchInModuleContent(resourceModule)) || scope.contains(resource2) || additionalScope != null && additionalScope.contains(resource2)) {
                return inTest || fileIndex.isInSource(resource2) ? SOURCE : LIBRARY;
            }
        } else {
            if (inTest || fileIndex.isInSource(resource2)) {
                return SOURCE;
            }
            if (fileIndex.isInLibraryClasses(resource2)) {
                return LIBRARY;
            }
        }
        return (resourceManager = (ExternalResourceManagerEx)ExternalResourceManager.getInstance()).isUserResource(resource2) ? MAPPED : STANDARD;
    }
}

