/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout.fontstore;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSCacheValue;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.FontResolverHelper;
import com.openhtmltopdf.pdfboxout.PDFontSupplier;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.fontstore.FontUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class FallbackFontStore
implements Closeable {
    private final List<PdfBoxFontResolver.FontDescription> fonts = new ArrayList<PdfBoxFontResolver.FontDescription>();
    private final List<TrueTypeCollection> _collectionsToClose = new ArrayList<TrueTypeCollection>();
    private final PDDocument _doc;
    private final FSCacheEx<String, FSCacheValue> _fontMetricsCache;

    public FallbackFontStore(SharedContext sharedContext, PDDocument doc, FSCacheEx<String, FSCacheValue> pdfMetricsCache) {
        this._doc = doc;
        this._fontMetricsCache = pdfMetricsCache;
    }

    private int getFontPriority(PdfBoxFontResolver.FontDescription font, String[] families, IdentValue weight, IdentValue desiredStyle, IdentValue variant) {
        String fontFamily = font.getFamily();
        int fontWeight = font.getWeight();
        IdentValue fontStyle = font.getStyle();
        List<String> desiredFamilies = families != null ? Arrays.asList(families) : Collections.emptyList();
        int desiredWeight = FontResolverHelper.convertWeightToInt(weight);
        if (fontWeight == desiredWeight && fontStyle == desiredStyle) {
            return this.getFamilyPriority(fontFamily, desiredFamilies);
        }
        if (Math.abs(fontWeight - desiredWeight) < 200 && fontStyle == desiredStyle) {
            return 3 + this.getFamilyPriority(fontFamily, desiredFamilies);
        }
        if (fontStyle == desiredStyle) {
            return 6 + this.getFamilyPriority(fontFamily, desiredFamilies);
        }
        return 9 + this.getFamilyPriority(fontFamily, desiredFamilies);
    }

    private int getFamilyPriority(String fontFamily, List<String> desiredFamilies) {
        if (!desiredFamilies.isEmpty() && desiredFamilies.get(0).equals(fontFamily)) {
            return 1;
        }
        if (desiredFamilies.contains(fontFamily)) {
            return 2;
        }
        return 3;
    }

    public List<PdfBoxFontResolver.FontDescription> resolveFonts(SharedContext ctx, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        if (this.fonts.size() <= 1) {
            return this.fonts;
        }
        ArrayList<PdfBoxFontResolver.FontDescription> ret = new ArrayList<PdfBoxFontResolver.FontDescription>(this.fonts);
        Collections.sort(ret, Comparator.comparing(font -> this.getFontPriority((PdfBoxFontResolver.FontDescription)font, families, weight, style, variant)));
        return ret;
    }

    public void addFont(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        PdfBoxFontResolver.FontDescription descr = new PdfBoxFontResolver.FontDescription(this._doc, supplier, FontUtil.normalizeFontWeight(fontWeightOverride), FontUtil.normalizeFontStyle(fontStyleOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        this.addFont(subset, descr);
    }

    public void addFont(PDFontSupplier supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        PdfBoxFontResolver.FontDescription descr = new PdfBoxFontResolver.FontDescription(this._doc, supplier, FontUtil.normalizeFontStyle(fontStyleOverride), FontUtil.normalizeFontWeight(fontWeightOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        this.addFont(subset, descr);
    }

    public void addFontLazy(FSSupplier<PDFont> font, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        PdfBoxFontResolver.FontDescription descr = new PdfBoxFontResolver.FontDescription(this._doc, font, FontUtil.normalizeFontStyle(fontStyleOverride), FontUtil.normalizeFontWeight(fontWeightOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        this.addFont(subset, descr);
    }

    private void addFont(boolean subset, PdfBoxFontResolver.FontDescription descr) {
        if (!subset) {
            if (descr.realizeFont()) {
                this.fonts.add(descr);
            }
        } else {
            this.fonts.add(descr);
        }
    }

    @Override
    public void close() throws IOException {
        for (TrueTypeCollection collection : this._collectionsToClose) {
            FontUtil.tryClose(collection);
        }
        this._collectionsToClose.clear();
    }

    void addFont(TrueTypeFont trueTypeFont, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        PDType0Font font = PDType0Font.load(this._doc, trueTypeFont, subset);
        this.addFontLazy(new PDFontSupplier(font), fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    public void addFontCollection(TrueTypeCollection collection, final String fontFamilyNameOverride, final Integer fontWeightOverride, final IdentValue fontStyleOverride, final boolean subset) throws IOException {
        collection.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

            @Override
            public void process(TrueTypeFont ttf) throws IOException {
                FallbackFontStore.this.addFont(ttf, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
            }
        });
        this._collectionsToClose.add(collection);
    }
}

