/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogMetadataPersistence
extends BaseEventLogMetadataPersistence {
    private static final String DEPRECATED_EVENTS_SCHEME_FILE = "white-list.json";
    public static final String EVENTS_SCHEME_FILE = "events-scheme.json";
    private static final Logger LOG = Logger.getInstance(EventLogMetadataPersistence.class);
    @NotNull
    private final String myRecorderId;

    public EventLogMetadataPersistence(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(0);
        }
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedEventsScheme() {
        try {
            Path file = this.getEventsSchemeFile();
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                return Files.readString(file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    private Path getEventsSchemeFile() throws IOException {
        EventsSchemePathSettings settings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        if (settings != null && settings.isUseCustomPath()) {
            Path path = Path.of(settings.getCustomPath(), new String[0]);
            if (path == null) {
                EventLogMetadataPersistence.$$$reportNull$$$0(1);
            }
            return path;
        }
        Path file = this.getDefaultFile();
        if (this.shouldBeRewrittenByBuiltinGroups(file)) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            this.initBuiltinMetadata(file);
        }
        Path path = file;
        if (path == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(2);
        }
        return path;
    }

    private boolean shouldBeRewrittenByBuiltinGroups(Path defaultFile) {
        try {
            if (!Files.exists(defaultFile, new LinkOption[0])) {
                return true;
            }
            BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
            String previousBuildNumberStr = EventLogMetadataSettingsPersistence.getInstance().getBuildNumber(this.myRecorderId);
            BuildNumber previousBuildNumber = BuildNumber.fromString((String)previousBuildNumberStr);
            if (previousBuildNumber != null && previousBuildNumber.compareTo(currentBuild) >= 0) {
                return false;
            }
            EventLogMetadataSettingsPersistence.getInstance().setBuildNumber(this.myRecorderId, currentBuild.asString());
            Path builtinFile = Files.createTempFile("builtin-events-scheme", ".json", new FileAttribute[0]);
            this.initBuiltinMetadata(builtinFile);
            String builtinEventsScheme = EventLogMetadataPersistence.readEventScheme(builtinFile);
            EventGroupRemoteDescriptors builtinEventGroupRemoteDescriptors = EventLogMetadataPersistence.getEventGroupRemoteDescriptors(builtinEventsScheme);
            if (builtinEventGroupRemoteDescriptors == null || builtinEventGroupRemoteDescriptors.version == null) {
                return false;
            }
            String defaultEventScheme = EventLogMetadataPersistence.readEventScheme(defaultFile);
            EventGroupRemoteDescriptors defaultEventGroupRemoteDescriptors = EventLogMetadataPersistence.getEventGroupRemoteDescriptors(defaultEventScheme);
            if (defaultEventGroupRemoteDescriptors == null || defaultEventGroupRemoteDescriptors.version == null) {
                return true;
            }
            return builtinEventGroupRemoteDescriptors.version.compareTo(defaultEventGroupRemoteDescriptors.version) > 0;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    @Nullable
    private static String readEventScheme(@NotNull Path file) {
        if (file == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(3);
        }
        try {
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                return Files.readString(file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Nullable
    private static EventGroupRemoteDescriptors getEventGroupRemoteDescriptors(@Nullable String data) {
        try {
            return EventLogMetadataUtils.parseGroupRemoteDescriptors(data);
        }
        catch (EventLogMetadataParseException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public void cacheEventsScheme(@NotNull String eventsSchemeJson, long lastModified) {
        if (eventsSchemeJson == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(4);
        }
        try {
            Path file = this.getDefaultFile();
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.writeString(file, (CharSequence)eventsSchemeJson, new OpenOption[0]);
            EventLogMetadataSettingsPersistence.getInstance().setLastModified(this.myRecorderId, lastModified);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void initBuiltinMetadata(@NotNull Path file) throws IOException {
        if (file == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(5);
        }
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.builtinEventSchemePath());){
            if (stream == null) {
                return;
            }
            Files.copy(stream, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private String builtinEventSchemePath() {
        return "resources/event-log-metadata/" + this.myRecorderId + "/events-scheme.json";
    }

    public long getLastModified() {
        return EventLogMetadataSettingsPersistence.getInstance().getLastModified(this.myRecorderId);
    }

    @NotNull
    public Path getDefaultFile() throws IOException {
        Path path = EventLogMetadataPersistence.getDefaultMetadataFile(this.myRecorderId, EVENTS_SCHEME_FILE, DEPRECATED_EVENTS_SCHEME_FILE);
        if (path == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(6);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataPersistence";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsSchemeJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataPersistence";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsSchemeFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readEventScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cacheEventsScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initBuiltinMetadata";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6 -> new IllegalStateException(string);
        };
    }
}

