// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies a cross-origin access rule for an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CorsRule {
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub id: ::std::option::Option<::std::string::String>,
    /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
    pub allowed_headers: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
    pub allowed_methods: ::std::vec::Vec<::std::string::String>,
    /// <p>One or more origins you want customers to be able to access the bucket from.</p>
    pub allowed_origins: ::std::vec::Vec<::std::string::String>,
    /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    pub expose_headers: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
    pub max_age_seconds: ::std::option::Option<i32>,
}
impl CorsRule {
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub fn id(&self) -> ::std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.allowed_headers.is_none()`.
    pub fn allowed_headers(&self) -> &[::std::string::String] {
        self.allowed_headers.as_deref().unwrap_or_default()
    }
    /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
    pub fn allowed_methods(&self) -> &[::std::string::String] {
        use std::ops::Deref;
        self.allowed_methods.deref()
    }
    /// <p>One or more origins you want customers to be able to access the bucket from.</p>
    pub fn allowed_origins(&self) -> &[::std::string::String] {
        use std::ops::Deref;
        self.allowed_origins.deref()
    }
    /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.expose_headers.is_none()`.
    pub fn expose_headers(&self) -> &[::std::string::String] {
        self.expose_headers.as_deref().unwrap_or_default()
    }
    /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
    pub fn max_age_seconds(&self) -> ::std::option::Option<i32> {
        self.max_age_seconds
    }
}
impl CorsRule {
    /// Creates a new builder-style object to manufacture [`CorsRule`](crate::types::CorsRule).
    pub fn builder() -> crate::types::builders::CorsRuleBuilder {
        crate::types::builders::CorsRuleBuilder::default()
    }
}

/// A builder for [`CorsRule`](crate::types::CorsRule).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CorsRuleBuilder {
    pub(crate) id: ::std::option::Option<::std::string::String>,
    pub(crate) allowed_headers: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) allowed_methods: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) allowed_origins: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) expose_headers: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) max_age_seconds: ::std::option::Option<i32>,
}
impl CorsRuleBuilder {
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub fn id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub fn set_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.id = input;
        self
    }
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub fn get_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.id
    }
    /// Appends an item to `allowed_headers`.
    ///
    /// To override the contents of this collection use [`set_allowed_headers`](Self::set_allowed_headers).
    ///
    /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
    pub fn allowed_headers(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.allowed_headers.unwrap_or_default();
        v.push(input.into());
        self.allowed_headers = ::std::option::Option::Some(v);
        self
    }
    /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
    pub fn set_allowed_headers(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.allowed_headers = input;
        self
    }
    /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
    pub fn get_allowed_headers(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.allowed_headers
    }
    /// Appends an item to `allowed_methods`.
    ///
    /// To override the contents of this collection use [`set_allowed_methods`](Self::set_allowed_methods).
    ///
    /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
    pub fn allowed_methods(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.allowed_methods.unwrap_or_default();
        v.push(input.into());
        self.allowed_methods = ::std::option::Option::Some(v);
        self
    }
    /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
    pub fn set_allowed_methods(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.allowed_methods = input;
        self
    }
    /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
    pub fn get_allowed_methods(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.allowed_methods
    }
    /// Appends an item to `allowed_origins`.
    ///
    /// To override the contents of this collection use [`set_allowed_origins`](Self::set_allowed_origins).
    ///
    /// <p>One or more origins you want customers to be able to access the bucket from.</p>
    pub fn allowed_origins(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.allowed_origins.unwrap_or_default();
        v.push(input.into());
        self.allowed_origins = ::std::option::Option::Some(v);
        self
    }
    /// <p>One or more origins you want customers to be able to access the bucket from.</p>
    pub fn set_allowed_origins(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.allowed_origins = input;
        self
    }
    /// <p>One or more origins you want customers to be able to access the bucket from.</p>
    pub fn get_allowed_origins(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.allowed_origins
    }
    /// Appends an item to `expose_headers`.
    ///
    /// To override the contents of this collection use [`set_expose_headers`](Self::set_expose_headers).
    ///
    /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    pub fn expose_headers(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.expose_headers.unwrap_or_default();
        v.push(input.into());
        self.expose_headers = ::std::option::Option::Some(v);
        self
    }
    /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    pub fn set_expose_headers(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.expose_headers = input;
        self
    }
    /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    pub fn get_expose_headers(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.expose_headers
    }
    /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
    pub fn max_age_seconds(mut self, input: i32) -> Self {
        self.max_age_seconds = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
    pub fn set_max_age_seconds(mut self, input: ::std::option::Option<i32>) -> Self {
        self.max_age_seconds = input;
        self
    }
    /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
    pub fn get_max_age_seconds(&self) -> &::std::option::Option<i32> {
        &self.max_age_seconds
    }
    /// Consumes the builder and constructs a [`CorsRule`](crate::types::CorsRule).
    /// This method will fail if any of the following fields are not set:
    /// - [`allowed_methods`](crate::types::builders::CorsRuleBuilder::allowed_methods)
    /// - [`allowed_origins`](crate::types::builders::CorsRuleBuilder::allowed_origins)
    pub fn build(self) -> ::std::result::Result<crate::types::CorsRule, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::CorsRule {
            id: self.id,
            allowed_headers: self.allowed_headers,
            allowed_methods: self.allowed_methods.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "allowed_methods",
                    "allowed_methods was not specified but it is required when building CorsRule",
                )
            })?,
            allowed_origins: self.allowed_origins.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "allowed_origins",
                    "allowed_origins was not specified but it is required when building CorsRule",
                )
            })?,
            expose_headers: self.expose_headers,
            max_age_seconds: self.max_age_seconds,
        })
    }
}
