#ifndef CYTPROTOCOL_H
#define CYTPROTOCOL_H
#include <wx/thread.h>
#include "baseprotocol.h"


#ifdef __WXGTK__
   #define __APPL_USE_FILESTREAM__
#endif 

#define CIRC_BUFFER_SIZE 33554432L
namespace tvlite
{
class CYTThread;
   
class CYTProtocol : public CBaseProtocol
{
private:
   CYTProtocol(const CYTProtocol&) = delete;
   CYTProtocol& operator=(const CYTProtocol&) = delete;
   CYTProtocol(CYTProtocol&&) = delete;
   CYTProtocol& operator=(CYTProtocol&&) = delete;
   wxInputStream *m_inputStream;
   int m_fileDescriptor;
   wxOutputStream *m_outputStream;
   CYTThread *m_ytthread;
   wxMutex m_accessMutex;

public:
   CYTProtocol(wxEvtHandler *parent, wxString url, wxString cmd ="");
   virtual ~CYTProtocol();
   virtual int  StartProtocol(long &pid);
   virtual void StopProtocol();

   virtual int LoadConfig();
   virtual int SaveConfig();
   wxString GetUrl();
   void SetURL(wxString url);

   
   int SearchYT(wxString &cmd);
   int GetFileDescriptor();
   virtual void OnTerminate(int pid, int status);
   void WaitThread();
   void LockAccessMutex();
   void UnlockAccessMutex();
};

}

#endif // CYTPROTOCOL_H
