#include "vlcquestiondialog.h"
#include "debug.h"

using namespace tvlite;

SDlgData::SDlgData(libvlc_dialog_id *p_id, const char *psz_title, const char *psz_text, 
                               libvlc_dialog_question_type i_type,
                               const char *psz_cancel, const char *psz_action1, const char *psz_action2):
                               m_p_id(p_id), m_i_type(i_type)
                               {
                                  if (psz_title != NULL)
                                  {
                                    m_title = wxString::FromUTF8(psz_title);
                                  } 
                                  if (psz_text != NULL)
                                  {
                                    m_text = wxString::FromUTF8(psz_text);
                                  } 
                                  if (psz_cancel != NULL)
                                  {
                                    m_cancel = wxString::FromUTF8(psz_cancel);
                                  } 
                                  if (psz_action1 != NULL)
                                  {
                                    m_action1 = wxString::FromUTF8(psz_action1);
                                  } 
                                  if (psz_action2 != NULL)
                                  {
                                    m_action2 = wxString::FromUTF8(psz_action2);
                                  } 
                                  
                               }

CVLCQuestionDialog::CVLCQuestionDialog(wxWindow* parent):CVLCQuestionDlgBase(parent)
{
}

CVLCQuestionDialog::~CVLCQuestionDialog()
{
}

void CVLCQuestionDialog::OnQuestionDlgShow( wxShowEvent& event ) 
{ 
    event.Skip();
}



void CVLCQuestionDialog::SetData(std::shared_ptr<SDlgData> &data)
{
   std::shared_ptr<SDlgData> d = data;
   m_text = wxString("");
   m_cancelString = wxString("");
   m_title = wxString("");
   m_text = d->m_text;
   m_title = d->m_title;
   m_cancelString = d->m_cancel;
   m_QuestionText->SetLabel(m_text);
   m_CancelButton->SetLabel(m_cancelString);
   SetTitle(m_title);
   
   if (d->m_action1 != wxString(""))
   { 
      m_act1String = d->m_action1;
      m_Act1Button->SetLabel(m_act1String);
      m_Act1Button->Show();
      m_buttonSizer->Layout();
      m_buttonSizer->Fit(this);
   }
   else
   {
      m_act1String = wxString("");
      m_Act1Button->Hide();
      m_buttonSizer->Layout();
      m_buttonSizer->Fit(this);
   }
   
   if (d->m_action2 != wxString(""))
   { 
      m_act2String = d->m_action2;
      m_Act2Button->SetLabel(m_act2String);
      m_Act2Button->Show();
      m_buttonSizer->Layout();
      m_buttonSizer->Fit(this);
   }
   else
   {
      m_act2String = wxString("");
      m_Act2Button->Hide();
      m_buttonSizer->Layout();
      m_buttonSizer->Fit(this);
   }
   m_i_type = d->m_i_type;
   
   this->Layout();
   this->Fit();
}  
 

int CVLCQuestionDialog::GetAction()
{
   return m_i_action;
}

void CVLCQuestionDialog::OnCancel( wxCommandEvent& event )
{
   EndModal(wxID_CANCEL);
   event.Skip();
}

void CVLCQuestionDialog::OnAction1( wxCommandEvent& event )
{
   event.Skip();
   m_i_action = 1;
   EndModal(wxID_OK);
   
}

void CVLCQuestionDialog::OnAction2( wxCommandEvent& event )
{
   event.Skip();
   m_i_action = 2;
   EndModal(wxID_OK);
   
}