;--------------------------------
;Include Modern UI

  !include "MUI2.nsh"

;--------------------------------
;General
;--------------------------------
 ; Get-ChildItem C:\msys64\home\Cristian\Projects\tv-lite\tv-lite-windows\kit-3.2\ -Recurse  | % { $_.FullName } > content_dir
  ;Name and file
  Name "TV-Lite"
  OutFile "tv-lite-windows-0.7.6.exe"
  Unicode True
	;--------------------------------
;Variables

  Var StartMenuFolder

  ;Default installation folder
  InstallDir "$PROGRAMFILES64\TV-Lite"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\TV-Lite" ""

  ;Request application privileges for Windows Vista
  RequestExecutionLevel admin
  
  ;Start Menu Folder Page Configuration
  !define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKCU" 
  !define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\TV-Lite" 
  !define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"
   
	!define MUI_FINISHPAGE_RUN
	!define MUI_FINISHPAGE_RUN_TEXT "Create desktop shortcut"
	!define MUI_FINISHPAGE_RUN_FUNCTION "shortcutfunc"
	!define APPNAME "TV-Lite"
	!define COMPANYNAME "TV-Lite"

Function "shortcutfunc"
CreateShortCut "$DESKTOP\TV-Lite.lnk" "$INSTDIR\tv-lite-windows.exe"
FunctionEnd 

;--------------------------------
;Interface Settings
;--------------------------------

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "..\gplv2.txt"
  ;!insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_STARTMENU Application $StartMenuFolder
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;--------------------------------
;Installer Sections

Section "Dummy Section"

  SetOutPath "$INSTDIR"

  ;ADD YOUR OWN FILES HERE...
  ;dir /s /b /o:gn
	File kit-3.2\curl-ca-bundle.crt
	File kit-3.2\libbrotlicommon.dll
	File kit-3.2\libbrotlidec.dll
	File kit-3.2\libbrotlienc.dll
	File kit-3.2\libcrypto-3-x64.dll
	File kit-3.2\libcurl-4.dll
	File kit-3.2\libdeflate.dll
	File kit-3.2\libgcc_s_seh-1.dll
	File kit-3.2\libiconv-2.dll
	File kit-3.2\libidn-12.dll
	File kit-3.2\libidn2-0.dll
	File kit-3.2\libintl-8.dll
	File kit-3.2\libjbig-0.dll
	File kit-3.2\libjpeg-8.dll
	File kit-3.2\libLerc.dll
	File kit-3.2\liblzma-5.dll
	File kit-3.2\libnghttp2-14.dll
    File kit-3.2\libnghttp3-9.dll
    File kit-3.2\libpcre2-16-0.dll
	File kit-3.2\libpng16-16.dll
	File kit-3.2\libpng16-config
	File kit-3.2\libpng-config
	File kit-3.2\libpsl-5.dll
	File kit-3.2\libsharpyuv-0.dll
	File kit-3.2\libsqlite3-0.dll
	File kit-3.2\libssh2-1.dll
	File kit-3.2\libssl-3-x64.dll
	File kit-3.2\libstdc++-6.dll
	File kit-3.2\libtiff-6.dll
	File kit-3.2\libtiffxx-6.dll
	File kit-3.2\libunistring-5.dll
	File kit-3.2\libvlc.dll
	File kit-3.2\libvlccore.dll
	File kit-3.2\libwebp-7.dll
	File kit-3.2\libwinpthread-1.dll
	File kit-3.2\libzstd.dll
	File kit-3.2\logo.png
	File kit-3.2\tv-lite-windows.exe
	File kit-3.2\vlc-cache-gen.exe
	File kit-3.2\wxbase32u_gcc_custom.dll
	File kit-3.2\wxmsw32u_adv_gcc_custom.dll
	File kit-3.2\wxmsw32u_core_gcc_custom.dll
	File kit-3.2\zlib1.dll
	SetOutPath "$INSTDIR\de"    
	File kit-3.2\de\tv-lite-windows.mo
	SetOutPath "$INSTDIR\el"    
	File kit-3.2\el\tv-lite-windows.mo
	SetOutPath "$INSTDIR\es"    
	File kit-3.2\es\tv-lite-windows.mo
	SetOutPath "$INSTDIR\it"    
	File kit-3.2\it\tv-lite-windows.mo
	SetOutPath "$INSTDIR\plugins"
	File kit-3.2\plugins\plugins.dat
	SetOutPath "$INSTDIR\plugins\access"
	File kit-3.2\plugins\access\libaccess_concat_plugin.dll
	File kit-3.2\plugins\access\libaccess_imem_plugin.dll
	File kit-3.2\plugins\access\libaccess_mms_plugin.dll
	File kit-3.2\plugins\access\libaccess_realrtsp_plugin.dll
	File kit-3.2\plugins\access\libaccess_srt_plugin.dll
	File kit-3.2\plugins\access\libaccess_wasapi_plugin.dll
	File kit-3.2\plugins\access\libattachment_plugin.dll
	File kit-3.2\plugins\access\libbluray-awt-j2se-1.3.2.jar
	File kit-3.2\plugins\access\libbluray-j2se-1.3.2.jar
	File kit-3.2\plugins\access\libcdda_plugin.dll
	File kit-3.2\plugins\access\libdcp_plugin.dll
	File kit-3.2\plugins\access\libdshow_plugin.dll
	File kit-3.2\plugins\access\libdtv_plugin.dll
	File kit-3.2\plugins\access\libdvdnav_plugin.dll
	File kit-3.2\plugins\access\libdvdread_plugin.dll
	File kit-3.2\plugins\access\libfilesystem_plugin.dll
	File kit-3.2\plugins\access\libftp_plugin.dll
	File kit-3.2\plugins\access\libhttp_plugin.dll
	File kit-3.2\plugins\access\libhttps_plugin.dll
	File kit-3.2\plugins\access\libidummy_plugin.dll
	File kit-3.2\plugins\access\libimem_plugin.dll
	File kit-3.2\plugins\access\liblibbluray_plugin.dll
	File kit-3.2\plugins\access\liblive555_plugin.dll
	File kit-3.2\plugins\access\libnfs_plugin.dll
	File kit-3.2\plugins\access\librist_plugin.dll
	File kit-3.2\plugins\access\librtp_plugin.dll
	File kit-3.2\plugins\access\libsatip_plugin.dll
	File kit-3.2\plugins\access\libscreen_plugin.dll
	File kit-3.2\plugins\access\libsdp_plugin.dll
	File kit-3.2\plugins\access\libsftp_plugin.dll
	File kit-3.2\plugins\access\libshm_plugin.dll
	File kit-3.2\plugins\access\libsmb_plugin.dll
	File kit-3.2\plugins\access\libtcp_plugin.dll
	File kit-3.2\plugins\access\libtimecode_plugin.dll
	File kit-3.2\plugins\access\libudp_plugin.dll
	File kit-3.2\plugins\access\libvcd_plugin.dll
	File kit-3.2\plugins\access\libvdr_plugin.dll
	File kit-3.2\plugins\access\libvnc_plugin.dll
                                             
	SetOutPath "$INSTDIR\plugins\access_output"
	File kit-3.2\plugins\access_output\libaccess_output_dummy_plugin.dll
	File kit-3.2\plugins\access_output\libaccess_output_file_plugin.dll
	File kit-3.2\plugins\access_output\libaccess_output_http_plugin.dll
	File kit-3.2\plugins\access_output\libaccess_output_livehttp_plugin.dll
	File kit-3.2\plugins\access_output\libaccess_output_rist_plugin.dll
	File kit-3.2\plugins\access_output\libaccess_output_shout_plugin.dll
	File kit-3.2\plugins\access_output\libaccess_output_srt_plugin.dll
	File kit-3.2\plugins\access_output\libaccess_output_udp_plugin.dll
                                
	SetOutPath "$INSTDIR\plugins\audio_filter"
	File kit-3.2\plugins\audio_filter\libaudio_format_plugin.dll
	File kit-3.2\plugins\audio_filter\libaudiobargraph_a_plugin.dll
	File kit-3.2\plugins\audio_filter\libchorus_flanger_plugin.dll
	File kit-3.2\plugins\audio_filter\libcompressor_plugin.dll
	File kit-3.2\plugins\audio_filter\libdolby_surround_decoder_plugin.dll
	File kit-3.2\plugins\audio_filter\libequalizer_plugin.dll
	File kit-3.2\plugins\audio_filter\libgain_plugin.dll
	File kit-3.2\plugins\audio_filter\libheadphone_channel_mixer_plugin.dll
	File kit-3.2\plugins\audio_filter\libkaraoke_plugin.dll
	File kit-3.2\plugins\audio_filter\libmad_plugin.dll
	File kit-3.2\plugins\audio_filter\libmono_plugin.dll
	File kit-3.2\plugins\audio_filter\libnormvol_plugin.dll
	File kit-3.2\plugins\audio_filter\libparam_eq_plugin.dll
	File kit-3.2\plugins\audio_filter\libremap_plugin.dll
	File kit-3.2\plugins\audio_filter\libsamplerate_plugin.dll
	File kit-3.2\plugins\audio_filter\libscaletempo_pitch_plugin.dll
	File kit-3.2\plugins\audio_filter\libscaletempo_plugin.dll
	File kit-3.2\plugins\audio_filter\libsimple_channel_mixer_plugin.dll
	File kit-3.2\plugins\audio_filter\libspatialaudio_plugin.dll
	File kit-3.2\plugins\audio_filter\libspatializer_plugin.dll
	File kit-3.2\plugins\audio_filter\libspeex_resampler_plugin.dll
	File kit-3.2\plugins\audio_filter\libstereo_widen_plugin.dll
	File kit-3.2\plugins\audio_filter\libtospdif_plugin.dll
	File kit-3.2\plugins\audio_filter\libtrivial_channel_mixer_plugin.dll
	File kit-3.2\plugins\audio_filter\libugly_resampler_plugin.dll
                                
	SetOutPath "$INSTDIR\plugins\audio_mixer"
	File kit-3.2\plugins\audio_mixer\libfloat_mixer_plugin.dll
	File kit-3.2\plugins\audio_mixer\libinteger_mixer_plugin.dll
                                
	SetOutPath "$INSTDIR\plugins\audio_output"
	File kit-3.2\plugins\audio_output\libadummy_plugin.dll
	File kit-3.2\plugins\audio_output\libafile_plugin.dll
	File kit-3.2\plugins\audio_output\libamem_plugin.dll
	File kit-3.2\plugins\audio_output\libdirectsound_plugin.dll
	File kit-3.2\plugins\audio_output\libmmdevice_plugin.dll
	File kit-3.2\plugins\audio_output\libwasapi_plugin.dll
	File kit-3.2\plugins\audio_output\libwaveout_plugin.dll
	
	SetOutPath "$INSTDIR\plugins\codec"
	File kit-3.2\plugins\codec\liba52_plugin.dll
	File kit-3.2\plugins\codec\libadpcm_plugin.dll
	File kit-3.2\plugins\codec\libaes3_plugin.dll
	File kit-3.2\plugins\codec\libaom_plugin.dll
	File kit-3.2\plugins\codec\libaraw_plugin.dll
	File kit-3.2\plugins\codec\libaribsub_plugin.dll
	File kit-3.2\plugins\codec\libavcodec_plugin.dll
	File kit-3.2\plugins\codec\libcc_plugin.dll
	File kit-3.2\plugins\codec\libcdg_plugin.dll
	File kit-3.2\plugins\codec\libcrystalhd_plugin.dll
	File kit-3.2\plugins\codec\libcvdsub_plugin.dll
	File kit-3.2\plugins\codec\libd3d11va_plugin.dll
	File kit-3.2\plugins\codec\libdav1d_plugin.dll
	File kit-3.2\plugins\codec\libdca_plugin.dll
	File kit-3.2\plugins\codec\libddummy_plugin.dll
	File kit-3.2\plugins\codec\libdmo_plugin.dll
	File kit-3.2\plugins\codec\libdvbsub_plugin.dll
	File kit-3.2\plugins\codec\libdxva2_plugin.dll
	File kit-3.2\plugins\codec\libedummy_plugin.dll
	File kit-3.2\plugins\codec\libfaad_plugin.dll
	File kit-3.2\plugins\codec\libflac_plugin.dll
	File kit-3.2\plugins\codec\libfluidsynth_plugin.dll
	File kit-3.2\plugins\codec\libg711_plugin.dll
	File kit-3.2\plugins\codec\libjpeg_plugin.dll
	File kit-3.2\plugins\codec\libkate_plugin.dll
	File kit-3.2\plugins\codec\liblibass_plugin.dll
	File kit-3.2\plugins\codec\liblibmpeg2_plugin.dll
	File kit-3.2\plugins\codec\liblpcm_plugin.dll
	File kit-3.2\plugins\codec\libmft_plugin.dll
	File kit-3.2\plugins\codec\libmpg123_plugin.dll
	File kit-3.2\plugins\codec\liboggspots_plugin.dll
	File kit-3.2\plugins\codec\libopus_plugin.dll
	File kit-3.2\plugins\codec\libpng_plugin.dll
	File kit-3.2\plugins\codec\libqsv_plugin.dll
	File kit-3.2\plugins\codec\librawvideo_plugin.dll
	File kit-3.2\plugins\codec\librtpvideo_plugin.dll
	File kit-3.2\plugins\codec\libschroedinger_plugin.dll
	File kit-3.2\plugins\codec\libscte18_plugin.dll
	File kit-3.2\plugins\codec\libscte27_plugin.dll
	File kit-3.2\plugins\codec\libsdl_image_plugin.dll
	File kit-3.2\plugins\codec\libspdif_plugin.dll
	File kit-3.2\plugins\codec\libspeex_plugin.dll
	File kit-3.2\plugins\codec\libspudec_plugin.dll
	File kit-3.2\plugins\codec\libstl_plugin.dll
	File kit-3.2\plugins\codec\libsubsdec_plugin.dll
	File kit-3.2\plugins\codec\libsubstx3g_plugin.dll
	File kit-3.2\plugins\codec\libsubsusf_plugin.dll
	File kit-3.2\plugins\codec\libsvcdsub_plugin.dll
	File kit-3.2\plugins\codec\libt140_plugin.dll
	File kit-3.2\plugins\codec\libtextst_plugin.dll
	File kit-3.2\plugins\codec\libtheora_plugin.dll
	File kit-3.2\plugins\codec\libttml_plugin.dll
	File kit-3.2\plugins\codec\libtwolame_plugin.dll
	File kit-3.2\plugins\codec\libuleaddvaudio_plugin.dll
	File kit-3.2\plugins\codec\libvorbis_plugin.dll
	File kit-3.2\plugins\codec\libvpx_plugin.dll
	File kit-3.2\plugins\codec\libwebvtt_plugin.dll
	File kit-3.2\plugins\codec\libx264_plugin.dll
	File kit-3.2\plugins\codec\libx26410b_plugin.dll
	File kit-3.2\plugins\codec\libx265_plugin.dll
	File kit-3.2\plugins\codec\libzvbi_plugin.dll
	
	SetOutPath "$INSTDIR\plugins\control"
	File kit-3.2\plugins\control\libdummy_plugin.dll
	File kit-3.2\plugins\control\libgestures_plugin.dll
	File kit-3.2\plugins\control\libhotkeys_plugin.dll
	File kit-3.2\plugins\control\libnetsync_plugin.dll
	File kit-3.2\plugins\control\libntservice_plugin.dll
	File kit-3.2\plugins\control\liboldrc_plugin.dll
	File kit-3.2\plugins\control\libwin_hotkeys_plugin.dll
	File kit-3.2\plugins\control\libwin_msg_plugin.dll
	
	SetOutPath "$INSTDIR\plugins\d3d11"
	File kit-3.2\plugins\d3d11\libdirect3d11_filters_plugin.dll
	
	SetOutPath "$INSTDIR\plugins\d3d9"
	File kit-3.2\plugins\d3d9\libdirect3d9_filters_plugin.dll
	
	SetOutPath "$INSTDIR\plugins\demux"
	File kit-3.2\plugins\demux\libadaptive_plugin.dll
	File kit-3.2\plugins\demux\libaiff_plugin.dll
	File kit-3.2\plugins\demux\libasf_plugin.dll
	File kit-3.2\plugins\demux\libau_plugin.dll
	File kit-3.2\plugins\demux\libavi_plugin.dll
	File kit-3.2\plugins\demux\libcaf_plugin.dll
	File kit-3.2\plugins\demux\libdemux_cdg_plugin.dll
	File kit-3.2\plugins\demux\libdemux_chromecast_plugin.dll
	File kit-3.2\plugins\demux\libdemux_stl_plugin.dll
	File kit-3.2\plugins\demux\libdemuxdump_plugin.dll
	File kit-3.2\plugins\demux\libdiracsys_plugin.dll
	File kit-3.2\plugins\demux\libdirectory_demux_plugin.dll
	File kit-3.2\plugins\demux\libes_plugin.dll
	File kit-3.2\plugins\demux\libflacsys_plugin.dll
	File kit-3.2\plugins\demux\libgme_plugin.dll
	File kit-3.2\plugins\demux\libh26x_plugin.dll
	File kit-3.2\plugins\demux\libimage_plugin.dll
	File kit-3.2\plugins\demux\libmjpeg_plugin.dll
	File kit-3.2\plugins\demux\libmkv_plugin.dll
	File kit-3.2\plugins\demux\libmod_plugin.dll
	File kit-3.2\plugins\demux\libmp4_plugin.dll
	File kit-3.2\plugins\demux\libmpc_plugin.dll
	File kit-3.2\plugins\demux\libmpgv_plugin.dll
	File kit-3.2\plugins\demux\libnoseek_plugin.dll
	File kit-3.2\plugins\demux\libnsc_plugin.dll
	File kit-3.2\plugins\demux\libnsv_plugin.dll
	File kit-3.2\plugins\demux\libnuv_plugin.dll
	File kit-3.2\plugins\demux\libogg_plugin.dll
	File kit-3.2\plugins\demux\libplaylist_plugin.dll
	File kit-3.2\plugins\demux\libps_plugin.dll
	File kit-3.2\plugins\demux\libpva_plugin.dll
	File kit-3.2\plugins\demux\librawaud_plugin.dll
	File kit-3.2\plugins\demux\librawdv_plugin.dll
	File kit-3.2\plugins\demux\librawvid_plugin.dll
	File kit-3.2\plugins\demux\libreal_plugin.dll
	File kit-3.2\plugins\demux\libsid_plugin.dll
	File kit-3.2\plugins\demux\libsmf_plugin.dll
	File kit-3.2\plugins\demux\libsubtitle_plugin.dll
	File kit-3.2\plugins\demux\libts_plugin.dll
	File kit-3.2\plugins\demux\libtta_plugin.dll
	File kit-3.2\plugins\demux\libty_plugin.dll
	File kit-3.2\plugins\demux\libvc1_plugin.dll
	File kit-3.2\plugins\demux\libvobsub_plugin.dll
	File kit-3.2\plugins\demux\libvoc_plugin.dll
	File kit-3.2\plugins\demux\libwav_plugin.dll
	File kit-3.2\plugins\demux\libxa_plugin.dll
	                            
	SetOutPath "$INSTDIR\plugins\keystore"
	File kit-3.2\plugins\keystore\libfile_keystore_plugin.dll
	File kit-3.2\plugins\keystore\libmemory_keystore_plugin.dll
	                            
	SetOutPath "$INSTDIR\plugins\logger"
	File kit-3.2\plugins\logger\libconsole_logger_plugin.dll
	File kit-3.2\plugins\logger\libfile_logger_plugin.dll
    SetOutPath "$INSTDIR\plugins\lua"
	File kit-3.2\plugins\lua\liblua_plugin.dll
	SetOutPath "$INSTDIR\plugins\meta_engine"
	File kit-3.2\plugins\meta_engine\libfolder_plugin.dll
	File kit-3.2\plugins\meta_engine\libtaglib_plugin.dll
	SetOutPath "$INSTDIR\plugins\misc"
	File kit-3.2\plugins\misc\libaddonsfsstorage_plugin.dll
	File kit-3.2\plugins\misc\libaddonsvorepository_plugin.dll
	File kit-3.2\plugins\misc\libaudioscrobbler_plugin.dll
	File kit-3.2\plugins\misc\libexport_plugin.dll
	File kit-3.2\plugins\misc\libfingerprinter_plugin.dll
	File kit-3.2\plugins\misc\libgnutls_plugin.dll
	File kit-3.2\plugins\misc\liblogger_plugin.dll
	File kit-3.2\plugins\misc\libstats_plugin.dll
	File kit-3.2\plugins\misc\libvod_rtsp_plugin.dll
	File kit-3.2\plugins\misc\libxml_plugin.dll	
	SetOutPath "$INSTDIR\plugins\mux"
	File kit-3.2\plugins\mux\libmux_asf_plugin.dll
	File kit-3.2\plugins\mux\libmux_avi_plugin.dll
	File kit-3.2\plugins\mux\libmux_dummy_plugin.dll
	File kit-3.2\plugins\mux\libmux_mp4_plugin.dll
	File kit-3.2\plugins\mux\libmux_mpjpeg_plugin.dll
	File kit-3.2\plugins\mux\libmux_ogg_plugin.dll
	File kit-3.2\plugins\mux\libmux_ps_plugin.dll
	File kit-3.2\plugins\mux\libmux_ts_plugin.dll
	File kit-3.2\plugins\mux\libmux_wav_plugin.dll	
	SetOutPath "$INSTDIR\plugins\packetizer"
	File kit-3.2\plugins\packetizer\libpacketizer_a52_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_av1_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_copy_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_dirac_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_dts_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_flac_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_h264_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_hevc_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_mlp_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_mpeg4audio_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_mpeg4video_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_mpegaudio_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_mpegvideo_plugin.dll
	File kit-3.2\plugins\packetizer\libpacketizer_vc1_plugin.dll
	SetOutPath "$INSTDIR\plugins\services_discovery"
	File kit-3.2\plugins\services_discovery\libmediadirs_plugin.dll
	File kit-3.2\plugins\services_discovery\libmicrodns_plugin.dll
	File kit-3.2\plugins\services_discovery\libpodcast_plugin.dll
	File kit-3.2\plugins\services_discovery\libsap_plugin.dll
	File kit-3.2\plugins\services_discovery\libupnp_plugin.dll
	File kit-3.2\plugins\services_discovery\libwindrive_plugin.dll
	SetOutPath "$INSTDIR\plugins\spu"
	File kit-3.2\plugins\spu\libaudiobargraph_v_plugin.dll
	File kit-3.2\plugins\spu\liblogo_plugin.dll
	File kit-3.2\plugins\spu\libmarq_plugin.dll
	File kit-3.2\plugins\spu\libmosaic_plugin.dll
	File kit-3.2\plugins\spu\libremoteosd_plugin.dll
	File kit-3.2\plugins\spu\librss_plugin.dll
	File kit-3.2\plugins\spu\libsubsdelay_plugin.dll
	SetOutPath "$INSTDIR\plugins\stream_extractor"
	File kit-3.2\plugins\stream_extractor\libarchive_plugin.dll
	SetOutPath "$INSTDIR\plugins\stream_filter"
	File kit-3.2\plugins\stream_filter\libadf_plugin.dll
	File kit-3.2\plugins\stream_filter\libaribcam_plugin.dll
	File kit-3.2\plugins\stream_filter\libcache_block_plugin.dll
	File kit-3.2\plugins\stream_filter\libcache_read_plugin.dll
	File kit-3.2\plugins\stream_filter\libhds_plugin.dll
	File kit-3.2\plugins\stream_filter\libinflate_plugin.dll
	File kit-3.2\plugins\stream_filter\libprefetch_plugin.dll
	File kit-3.2\plugins\stream_filter\librecord_plugin.dll
	File kit-3.2\plugins\stream_filter\libskiptags_plugin.dll
	SetOutPath "$INSTDIR\plugins\stream_out"
	File kit-3.2\plugins\stream_out\libstream_out_autodel_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_bridge_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_chromaprint_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_chromecast_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_cycle_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_delay_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_description_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_display_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_dummy_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_duplicate_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_es_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_gather_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_mosaic_bridge_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_record_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_rtp_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_setid_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_smem_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_standard_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_stats_plugin.dll
	File kit-3.2\plugins\stream_out\libstream_out_transcode_plugin.dll
	SetOutPath "$INSTDIR\plugins\text_renderer"
	File kit-3.2\plugins\text_renderer\libfreetype_plugin.dll
	File kit-3.2\plugins\text_renderer\libsapi_plugin.dll
	File kit-3.2\plugins\text_renderer\libtdummy_plugin.dll	
	SetOutPath "$INSTDIR\plugins\video_chroma"
	File kit-3.2\plugins\video_chroma\libchain_plugin.dll
	File kit-3.2\plugins\video_chroma\libgrey_yuv_plugin.dll
	File kit-3.2\plugins\video_chroma\libi420_10_p010_plugin.dll
	File kit-3.2\plugins\video_chroma\libi420_nv12_plugin.dll
	File kit-3.2\plugins\video_chroma\libi420_rgb_mmx_plugin.dll
	File kit-3.2\plugins\video_chroma\libi420_rgb_plugin.dll
	File kit-3.2\plugins\video_chroma\libi420_rgb_sse2_plugin.dll
	File kit-3.2\plugins\video_chroma\libi420_yuy2_mmx_plugin.dll
	File kit-3.2\plugins\video_chroma\libi420_yuy2_plugin.dll
	File kit-3.2\plugins\video_chroma\libi420_yuy2_sse2_plugin.dll
	File kit-3.2\plugins\video_chroma\libi422_i420_plugin.dll
	File kit-3.2\plugins\video_chroma\libi422_yuy2_mmx_plugin.dll
	File kit-3.2\plugins\video_chroma\libi422_yuy2_plugin.dll
	File kit-3.2\plugins\video_chroma\libi422_yuy2_sse2_plugin.dll
	File kit-3.2\plugins\video_chroma\librv32_plugin.dll
	File kit-3.2\plugins\video_chroma\libswscale_plugin.dll
	File kit-3.2\plugins\video_chroma\libyuvp_plugin.dll
	File kit-3.2\plugins\video_chroma\libyuy2_i420_plugin.dll
	File kit-3.2\plugins\video_chroma\libyuy2_i422_plugin.dll
	SetOutPath "$INSTDIR\plugins\video_filter"
	File kit-3.2\plugins\video_filter\libadjust_plugin.dll
	File kit-3.2\plugins\video_filter\libalphamask_plugin.dll
	File kit-3.2\plugins\video_filter\libanaglyph_plugin.dll
	File kit-3.2\plugins\video_filter\libantiflicker_plugin.dll
	File kit-3.2\plugins\video_filter\libball_plugin.dll
	File kit-3.2\plugins\video_filter\libblend_plugin.dll
	File kit-3.2\plugins\video_filter\libblendbench_plugin.dll
	File kit-3.2\plugins\video_filter\libbluescreen_plugin.dll
	File kit-3.2\plugins\video_filter\libcanvas_plugin.dll
	File kit-3.2\plugins\video_filter\libcolorthres_plugin.dll
	File kit-3.2\plugins\video_filter\libcroppadd_plugin.dll
	File kit-3.2\plugins\video_filter\libdeinterlace_plugin.dll
	File kit-3.2\plugins\video_filter\libedgedetection_plugin.dll
	File kit-3.2\plugins\video_filter\liberase_plugin.dll
	File kit-3.2\plugins\video_filter\libextract_plugin.dll
	File kit-3.2\plugins\video_filter\libfps_plugin.dll
	File kit-3.2\plugins\video_filter\libfreeze_plugin.dll
	File kit-3.2\plugins\video_filter\libgaussianblur_plugin.dll
	File kit-3.2\plugins\video_filter\libgradfun_plugin.dll
	File kit-3.2\plugins\video_filter\libgradient_plugin.dll
	File kit-3.2\plugins\video_filter\libgrain_plugin.dll
	File kit-3.2\plugins\video_filter\libhqdn3d_plugin.dll
	File kit-3.2\plugins\video_filter\libinvert_plugin.dll
	File kit-3.2\plugins\video_filter\libmagnify_plugin.dll
	File kit-3.2\plugins\video_filter\libmirror_plugin.dll
	File kit-3.2\plugins\video_filter\libmotionblur_plugin.dll
	File kit-3.2\plugins\video_filter\libmotiondetect_plugin.dll
	File kit-3.2\plugins\video_filter\liboldmovie_plugin.dll
	File kit-3.2\plugins\video_filter\libposterize_plugin.dll
	File kit-3.2\plugins\video_filter\libpostproc_plugin.dll
	File kit-3.2\plugins\video_filter\libpsychedelic_plugin.dll
	File kit-3.2\plugins\video_filter\libpuzzle_plugin.dll
	File kit-3.2\plugins\video_filter\libripple_plugin.dll
	File kit-3.2\plugins\video_filter\librotate_plugin.dll
	File kit-3.2\plugins\video_filter\libscale_plugin.dll
	File kit-3.2\plugins\video_filter\libscene_plugin.dll
	File kit-3.2\plugins\video_filter\libsepia_plugin.dll
	File kit-3.2\plugins\video_filter\libsharpen_plugin.dll
	File kit-3.2\plugins\video_filter\libtransform_plugin.dll
	File kit-3.2\plugins\video_filter\libvhs_plugin.dll
	File kit-3.2\plugins\video_filter\libwave_plugin.dll	
	SetOutPath "$INSTDIR\plugins\video_output"
	File kit-3.2\plugins\video_output\libcaca_plugin.dll
	File kit-3.2\plugins\video_output\libdirect3d11_plugin.dll
	File kit-3.2\plugins\video_output\libdirect3d9_plugin.dll
	File kit-3.2\plugins\video_output\libdirectdraw_plugin.dll
	File kit-3.2\plugins\video_output\libdrawable_plugin.dll
	File kit-3.2\plugins\video_output\libflaschen_plugin.dll
	File kit-3.2\plugins\video_output\libgl_plugin.dll
	File kit-3.2\plugins\video_output\libglwin32_plugin.dll
	File kit-3.2\plugins\video_output\libvdummy_plugin.dll
	File kit-3.2\plugins\video_output\libvmem_plugin.dll
	File kit-3.2\plugins\video_output\libwgl_plugin.dll
	File kit-3.2\plugins\video_output\libwingdi_plugin.dll
	File kit-3.2\plugins\video_output\libwinhibit_plugin.dll
	File kit-3.2\plugins\video_output\libyuv_plugin.dll	
	SetOutPath "$INSTDIR\plugins\visualization"
	File kit-3.2\plugins\visualization\libglspectrum_plugin.dll
	File kit-3.2\plugins\visualization\libgoom_plugin.dll
	File kit-3.2\plugins\visualization\libprojectm_plugin.dll
	File kit-3.2\plugins\visualization\libvisual_plugin.dll	
	SetOutPath "$INSTDIR\plugins\video_splitter"
	File kit-3.2\plugins\video_splitter\libclone_plugin.dll
	File kit-3.2\plugins\video_splitter\libpanoramix_plugin.dll
	File kit-3.2\plugins\video_splitter\libwall_plugin.dll
	SetOutPath "$INSTDIR\ro"    
	File kit-3.2\ro\tv-lite-windows.mo
	SetOutPath "$INSTDIR\ru"    
	File kit-3.2\ru\tv-lite-windows.mo
	SetOutPath "$INSTDIR\hr"    
	File kit-3.2\hr\tv-lite-windows.mo
	SetOutPath "$INSTDIR\hu"    
	File kit-3.2\hu\tv-lite-windows.mo
	SetOutPath "$INSTDIR\tr"    
	File kit-3.2\tr\tv-lite-windows.mo
                                
  ;Empty stale plugin cache     
  Exec '"$INSTDIR\vlc-cache-gen.exe" plugins'
                                
  ;Store installation folder    
  WriteRegStr HKCU "Software\TV-Lite" "" $INSTDIR
                                
  ;Create uninstaller           
  WriteUninstaller "$INSTDIR\Uninstall.exe"
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
                                
;Create shortcuts           
	CreateDirectory "$SMPROGRAMS\$StartMenuFolder"
	CreateShortcut "$SMPROGRAMS\$StartMenuFolder\Uninstall.lnk" "$INSTDIR\Uninstall.exe"
	CreateShortCut "$SMPROGRAMS\$StartMenuFolder\${APPNAME}.lnk" "$INSTDIR\tv-lite-windows.exe"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TV-Lite" \
					 "DisplayName" "TV-Lite"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TV-Lite" \
					 "UninstallString" "$\"$INSTDIR\uninstall.exe$\""			 
									
	!insertmacro MUI_STARTMENU_WRITE_END
                                
SectionEnd                      
                                
;--------------------------------
;Descriptions                   
                                
  ;Language strings             
  LangString DESC_SecDummy ${LANG_ENGLISH} "TV-Lite is a IPTV player, with Acestream handling capabilities."
                                
                                
;--------------------------------
;Uninstaller Section            
                                
Section "Uninstall"             
                                

Delete "$INSTDIR\curl-ca-bundle.crt"
Delete "$INSTDIR\libbrotlicommon.dll"
Delete "$INSTDIR\libbrotlidec.dll"
Delete "$INSTDIR\libbrotlienc.dll"
Delete "$INSTDIR\libcrypto-3-x64.dll"
Delete "$INSTDIR\libcurl-4.dll"
Delete "$INSTDIR\libdeflate.dll"
Delete "$INSTDIR\libgcc_s_seh-1.dll"
Delete "$INSTDIR\libiconv-2.dll"
Delete "$INSTDIR\libidn-12.dll"
Delete "$INSTDIR\libidn2-0.dll"
Delete "$INSTDIR\libintl-8.dll"
Delete "$INSTDIR\libjbig-0.dll"
Delete "$INSTDIR\libjpeg-8.dll"
Delete "$INSTDIR\libLerc.dll"
Delete "$INSTDIR\liblzma-5.dll"
Delete "$INSTDIR\libnghttp2-14.dll"
Delete "$INSTDIR\libnghttp3-9.dll"
Delete "$INSTDIR\libpcre2-16-0.dll"
Delete "$INSTDIR\libpng16-16.dll"
Delete "$INSTDIR\libpng16-config"
Delete "$INSTDIR\libpng-config"
Delete "$INSTDIR\libpsl-5.dll"
Delete "$INSTDIR\libsharpyuv-0.dll"
Delete "$INSTDIR\libsqlite3-0.dll"
Delete "$INSTDIR\libssh2-1.dll"
Delete "$INSTDIR\libssl-3-x64.dll"
Delete "$INSTDIR\libssp-0.dll"
Delete "$INSTDIR\libstdc++-6.dll"
Delete "$INSTDIR\libtiff-6.dll"
Delete "$INSTDIR\libtiffxx-6.dll"
Delete "$INSTDIR\libunistring-5.dll"
Delete "$INSTDIR\libvlc.dll"
Delete "$INSTDIR\libvlccore.dll"
Delete "$INSTDIR\libwebp-7.dll"
Delete "$INSTDIR\libwinpthread-1.dll"
Delete "$INSTDIR\libzstd.dll"
Delete "$INSTDIR\logo.png"
Delete "$INSTDIR\tv-lite-windows.exe"
Delete "$INSTDIR\vlc-cache-gen.exe"
Delete "$INSTDIR\wxbase32u_gcc_custom.dll"
Delete "$INSTDIR\wxmsw32u_adv_gcc_custom.dll"
Delete "$INSTDIR\wxmsw32u_core_gcc_custom.dll"
Delete "$INSTDIR\zlib1.dll"
Delete "$INSTDIR\de\tv-lite-windows.mo"
Delete "$INSTDIR\el\tv-lite-windows.mo"
Delete "$INSTDIR\es\tv-lite-windows.mo"
Delete "$INSTDIR\hr\tv-lite-windows.mo"
Delete "$INSTDIR\hu\tv-lite-windows.mo"
Delete "$INSTDIR\it\tv-lite-windows.mo"


	Delete "$INSTDIR\plugins\plugins.dat"
	Delete "$INSTDIR\ro\tv-lite-windows.mo"
	Delete "$INSTDIR\ru\tv-lite-windows.mo"
	Delete "$INSTDIR\hr\tv-lite-windows.mo"
	Delete "$INSTDIR\hu\tv-lite-windows.mo"
	Delete "$INSTDIR\tr\tv-lite-windows.mo"
	Delete "$INSTDIR\vlc-cache-gen.exe"
	Delete "$INSTDIR\Uninstall.exe"
	Delete "$INSTDIR\plugins\access"
	Delete "$INSTDIR\plugins\access_output"
	Delete "$INSTDIR\plugins\audio_filter"
	Delete "$INSTDIR\plugins\audio_mixer"
	Delete "$INSTDIR\plugins\audio_output"
	Delete "$INSTDIR\plugins\codec"
	Delete "$INSTDIR\plugins\control"
	Delete "$INSTDIR\plugins\d3d11"
	Delete "$INSTDIR\plugins\d3d9"
	Delete "$INSTDIR\plugins\demux"
	Delete "$INSTDIR\plugins\gui"
	Delete "$INSTDIR\plugins\keystore"
	Delete "$INSTDIR\plugins\logger"
	Delete "$INSTDIR\plugins\lua"
	Delete "$INSTDIR\plugins\meta_engine"
	Delete "$INSTDIR\plugins\misc"
	Delete "$INSTDIR\plugins\mux"
	Delete "$INSTDIR\plugins\packetizer"
	Delete "$INSTDIR\plugins\services_discovery"
	Delete "$INSTDIR\plugins\spu"
	Delete "$INSTDIR\plugins\stream_extractor"
	Delete "$INSTDIR\plugins\stream_filter"
	Delete "$INSTDIR\plugins\stream_out"
	Delete "$INSTDIR\plugins\text_renderer"
	Delete "$INSTDIR\plugins\video_chroma"
	Delete "$INSTDIR\plugins\video_filter"
	Delete "$INSTDIR\plugins\video_output"
	Delete "$INSTDIR\plugins\video_splitter"
	Delete "$INSTDIR\plugins\visualization"
	Delete "$INSTDIR\plugins\plugins.dat"
	Delete "$INSTDIR\plugins\plugins.txt"
	Delete "$INSTDIR\plugins\access\libaccess_concat_plugin.dll"
	Delete "$INSTDIR\plugins\access\libaccess_imem_plugin.dll"
	Delete "$INSTDIR\plugins\access\libaccess_mms_plugin.dll"
	Delete "$INSTDIR\plugins\access\libaccess_realrtsp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libaccess_srt_plugin.dll"
	Delete "$INSTDIR\plugins\access\libaccess_wasapi_plugin.dll"
	Delete "$INSTDIR\plugins\access\libattachment_plugin.dll"
	Delete "$INSTDIR\plugins\access\libbluray-awt-j2se-1.3.2.jar"
	Delete "$INSTDIR\plugins\access\libbluray-j2se-1.3.2.jar"
	Delete "$INSTDIR\plugins\access\libcdda_plugin.dll"
	Delete "$INSTDIR\plugins\access\libdcp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libdshow_plugin.dll"
	Delete "$INSTDIR\plugins\access\libdtv_plugin.dll"
	Delete "$INSTDIR\plugins\access\libdvdnav_plugin.dll"
	Delete "$INSTDIR\plugins\access\libdvdread_plugin.dll"
	Delete "$INSTDIR\plugins\access\libfilesystem_plugin.dll"
	Delete "$INSTDIR\plugins\access\libftp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libhttp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libhttps_plugin.dll"
	Delete "$INSTDIR\plugins\access\libidummy_plugin.dll"
	Delete "$INSTDIR\plugins\access\libimem_plugin.dll"
	Delete "$INSTDIR\plugins\access\liblibbluray_plugin.dll"
	Delete "$INSTDIR\plugins\access\liblive555_plugin.dll"
	Delete "$INSTDIR\plugins\access\libnfs_plugin.dll"
	Delete "$INSTDIR\plugins\access\librist_plugin.dll"
	Delete "$INSTDIR\plugins\access\librtp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libsatip_plugin.dll"
	Delete "$INSTDIR\plugins\access\libscreen_plugin.dll"
	Delete "$INSTDIR\plugins\access\libsdp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libsftp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libshm_plugin.dll"
	Delete "$INSTDIR\plugins\access\libsmb_plugin.dll"
	Delete "$INSTDIR\plugins\access\libtcp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libtimecode_plugin.dll"
	Delete "$INSTDIR\plugins\access\libudp_plugin.dll"
	Delete "$INSTDIR\plugins\access\libvcd_plugin.dll"
	Delete "$INSTDIR\plugins\access\libvdr_plugin.dll"
	Delete "$INSTDIR\plugins\access\libvnc_plugin.dll"
	Delete "$INSTDIR\plugins\access_output\libaccess_output_dummy_plugin.dll"
	Delete "$INSTDIR\plugins\access_output\libaccess_output_file_plugin.dll"
	Delete "$INSTDIR\plugins\access_output\libaccess_output_http_plugin.dll"
	Delete "$INSTDIR\plugins\access_output\libaccess_output_livehttp_plugin.dll"
	Delete "$INSTDIR\plugins\access_output\libaccess_output_rist_plugin.dll"
	Delete "$INSTDIR\plugins\access_output\libaccess_output_shout_plugin.dll"
	Delete "$INSTDIR\plugins\access_output\libaccess_output_srt_plugin.dll"
	Delete "$INSTDIR\plugins\access_output\libaccess_output_udp_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libaudio_format_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libaudiobargraph_a_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libchorus_flanger_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libcompressor_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libdolby_surround_decoder_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libequalizer_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libgain_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libheadphone_channel_mixer_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libkaraoke_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libmad_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libmono_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libnormvol_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libparam_eq_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libremap_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libsamplerate_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libscaletempo_pitch_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libscaletempo_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libsimple_channel_mixer_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libspatialaudio_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libspatializer_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libspeex_resampler_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libstereo_widen_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libtospdif_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libtrivial_channel_mixer_plugin.dll"
	Delete "$INSTDIR\plugins\audio_filter\libugly_resampler_plugin.dll"
	Delete "$INSTDIR\plugins\audio_mixer\libfloat_mixer_plugin.dll"
	Delete "$INSTDIR\plugins\audio_mixer\libinteger_mixer_plugin.dll"
	Delete "$INSTDIR\plugins\audio_output\libadummy_plugin.dll"
	Delete "$INSTDIR\plugins\audio_output\libafile_plugin.dll"
	Delete "$INSTDIR\plugins\audio_output\libamem_plugin.dll"
	Delete "$INSTDIR\plugins\audio_output\libdirectsound_plugin.dll"
	Delete "$INSTDIR\plugins\audio_output\libmmdevice_plugin.dll"
	Delete "$INSTDIR\plugins\audio_output\libwasapi_plugin.dll"
	Delete "$INSTDIR\plugins\audio_output\libwaveout_plugin.dll"
	Delete "$INSTDIR\plugins\codec\liba52_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libadpcm_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libaes3_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libaom_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libaraw_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libaribsub_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libavcodec_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libcc_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libcdg_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libcrystalhd_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libcvdsub_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libd3d11va_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libdav1d_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libdca_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libddummy_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libdmo_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libdvbsub_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libdxva2_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libedummy_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libfaad_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libflac_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libfluidsynth_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libg711_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libjpeg_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libkate_plugin.dll"
	Delete "$INSTDIR\plugins\codec\liblibass_plugin.dll"
	Delete "$INSTDIR\plugins\codec\liblibmpeg2_plugin.dll"
	Delete "$INSTDIR\plugins\codec\liblpcm_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libmft_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libmpg123_plugin.dll"
	Delete "$INSTDIR\plugins\codec\liboggspots_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libopus_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libpng_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libqsv_plugin.dll"
	Delete "$INSTDIR\plugins\codec\librawvideo_plugin.dll"
	Delete "$INSTDIR\plugins\codec\librtpvideo_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libschroedinger_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libscte18_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libscte27_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libsdl_image_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libspdif_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libspeex_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libspudec_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libstl_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libsubsdec_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libsubstx3g_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libsubsusf_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libsvcdsub_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libt140_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libtextst_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libtheora_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libttml_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libtwolame_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libuleaddvaudio_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libvorbis_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libvpx_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libwebvtt_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libx264_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libx26410b_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libx265_plugin.dll"
	Delete "$INSTDIR\plugins\codec\libzvbi_plugin.dll"
	Delete "$INSTDIR\plugins\control\libdummy_plugin.dll"
	Delete "$INSTDIR\plugins\control\libgestures_plugin.dll"
	Delete "$INSTDIR\plugins\control\libhotkeys_plugin.dll"
	Delete "$INSTDIR\plugins\control\libnetsync_plugin.dll"
	Delete "$INSTDIR\plugins\control\libntservice_plugin.dll"
	Delete "$INSTDIR\plugins\control\liboldrc_plugin.dll"
	Delete "$INSTDIR\plugins\control\libwin_hotkeys_plugin.dll"
	Delete "$INSTDIR\plugins\control\libwin_msg_plugin.dll"
	Delete "$INSTDIR\plugins\d3d11\libdirect3d11_filters_plugin.dll"
	Delete "$INSTDIR\plugins\d3d9\libdirect3d9_filters_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libadaptive_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libaiff_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libasf_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libau_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libavi_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libcaf_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libdemux_cdg_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libdemux_chromecast_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libdemux_stl_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libdemuxdump_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libdiracsys_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libdirectory_demux_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libes_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libflacsys_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libgme_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libh26x_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libimage_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libmjpeg_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libmkv_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libmod_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libmp4_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libmpc_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libmpgv_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libnoseek_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libnsc_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libnsv_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libnuv_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libogg_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libplaylist_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libps_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libpva_plugin.dll"
	Delete "$INSTDIR\plugins\demux\librawaud_plugin.dll"
	Delete "$INSTDIR\plugins\demux\librawdv_plugin.dll"
	Delete "$INSTDIR\plugins\demux\librawvid_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libreal_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libsid_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libsmf_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libsubtitle_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libts_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libtta_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libty_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libvc1_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libvobsub_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libvoc_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libwav_plugin.dll"
	Delete "$INSTDIR\plugins\demux\libxa_plugin.dll"
	Delete "$INSTDIR\plugins\gui\libqt_plugin.dll"
	Delete "$INSTDIR\plugins\gui\libskins2_plugin.dll"
	Delete "$INSTDIR\plugins\keystore\libfile_keystore_plugin.dll"
	Delete "$INSTDIR\plugins\keystore\libmemory_keystore_plugin.dll"
	Delete "$INSTDIR\plugins\logger\libconsole_logger_plugin.dll"
	Delete "$INSTDIR\plugins\logger\libfile_logger_plugin.dll"
	Delete "$INSTDIR\plugins\lua\liblua_plugin.dll"
	Delete "$INSTDIR\plugins\meta_engine\libfolder_plugin.dll"
	Delete "$INSTDIR\plugins\meta_engine\libtaglib_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libaddonsfsstorage_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libaddonsvorepository_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libaudioscrobbler_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libexport_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libfingerprinter_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libgnutls_plugin.dll"
	Delete "$INSTDIR\plugins\misc\liblogger_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libstats_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libvod_rtsp_plugin.dll"
	Delete "$INSTDIR\plugins\misc\libxml_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_asf_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_avi_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_dummy_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_mp4_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_mpjpeg_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_ogg_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_ps_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_ts_plugin.dll"
	Delete "$INSTDIR\plugins\mux\libmux_wav_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_a52_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_av1_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_copy_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_dirac_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_dts_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_flac_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_h264_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_hevc_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_mlp_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_mpeg4audio_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_mpeg4video_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_mpegaudio_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_mpegvideo_plugin.dll"
	Delete "$INSTDIR\plugins\packetizer\libpacketizer_vc1_plugin.dll"
	Delete "$INSTDIR\plugins\services_discovery\libmediadirs_plugin.dll"
	Delete "$INSTDIR\plugins\services_discovery\libmicrodns_plugin.dll"
	Delete "$INSTDIR\plugins\services_discovery\libpodcast_plugin.dll"
	Delete "$INSTDIR\plugins\services_discovery\libsap_plugin.dll"
	Delete "$INSTDIR\plugins\services_discovery\libupnp_plugin.dll"
	Delete "$INSTDIR\plugins\services_discovery\libwindrive_plugin.dll"
	Delete "$INSTDIR\plugins\spu\libaudiobargraph_v_plugin.dll"
	Delete "$INSTDIR\plugins\spu\liblogo_plugin.dll"
	Delete "$INSTDIR\plugins\spu\libmarq_plugin.dll"
	Delete "$INSTDIR\plugins\spu\libmosaic_plugin.dll"
	Delete "$INSTDIR\plugins\spu\libremoteosd_plugin.dll"
	Delete "$INSTDIR\plugins\spu\librss_plugin.dll"
	Delete "$INSTDIR\plugins\spu\libsubsdelay_plugin.dll"
	Delete "$INSTDIR\plugins\stream_extractor\libarchive_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\libadf_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\libaribcam_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\libcache_block_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\libcache_read_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\libhds_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\libinflate_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\libprefetch_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\librecord_plugin.dll"
	Delete "$INSTDIR\plugins\stream_filter\libskiptags_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_autodel_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_bridge_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_chromaprint_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_chromecast_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_cycle_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_delay_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_description_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_display_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_dummy_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_duplicate_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_es_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_gather_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_mosaic_bridge_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_record_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_rtp_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_setid_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_smem_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_standard_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_stats_plugin.dll"
	Delete "$INSTDIR\plugins\stream_out\libstream_out_transcode_plugin.dll"
	Delete "$INSTDIR\plugins\stream_extractor\libarchive_plugin.dll"
	Delete "$INSTDIR\plugins\text_renderer\libfreetype_plugin.dll"
	Delete "$INSTDIR\plugins\text_renderer\libsapi_plugin.dll"
	Delete "$INSTDIR\plugins\text_renderer\libtdummy_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libchain_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libgrey_yuv_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi420_10_p010_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi420_nv12_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi420_rgb_mmx_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi420_rgb_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi420_rgb_sse2_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi420_yuy2_mmx_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi420_yuy2_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi420_yuy2_sse2_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi422_i420_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi422_yuy2_mmx_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi422_yuy2_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libi422_yuy2_sse2_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\librv32_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libswscale_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libyuvp_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libyuy2_i420_plugin.dll"
	Delete "$INSTDIR\plugins\video_chroma\libyuy2_i422_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libadjust_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libalphamask_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libanaglyph_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libantiflicker_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libball_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libblend_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libblendbench_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libbluescreen_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libcanvas_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libcolorthres_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libcroppadd_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libdeinterlace_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libedgedetection_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\liberase_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libextract_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libfps_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libfreeze_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libgaussianblur_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libgradfun_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libgradient_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libgrain_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libhqdn3d_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libinvert_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libmagnify_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libmirror_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libmotionblur_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libmotiondetect_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\liboldmovie_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libposterize_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libpostproc_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libpsychedelic_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libpuzzle_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libripple_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\librotate_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libscale_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libscene_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libsepia_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libsharpen_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libtransform_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libvhs_plugin.dll"
	Delete "$INSTDIR\plugins\video_filter\libwave_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libcaca_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libdirect3d11_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libdirect3d9_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libdirectdraw_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libdrawable_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libflaschen_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libgl_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libglwin32_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libvdummy_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libvmem_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libwgl_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libwingdi_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libwinhibit_plugin.dll"
	Delete "$INSTDIR\plugins\video_output\libyuv_plugin.dll"
	Delete "$INSTDIR\plugins\video_splitter\libclone_plugin.dll"
	Delete "$INSTDIR\plugins\video_splitter\libpanoramix_plugin.dll"
	Delete "$INSTDIR\plugins\video_splitter\libwall_plugin.dll"
	Delete "$INSTDIR\plugins\visualization\libglspectrum_plugin.dll"
	Delete "$INSTDIR\plugins\visualization\libgoom_plugin.dll"
	Delete "$INSTDIR\plugins\visualization\libprojectm_plugin.dll"
	Delete "$INSTDIR\plugins\visualization\libvisual_plugin.dll"
	RMDir "$INSTDIR\de"         
	RMDir "$INSTDIR\el"         
	RMDir "$INSTDIR\es"         
	RMDir "$INSTDIR\it"         
	RMDir "$INSTDIR\ro"         
	RMDir "$INSTDIR\ru"         
	RMDir "$INSTDIR\hr"         
	RMDir "$INSTDIR\hu"         
	RMDir "$INSTDIR\tr"         
	RMDir "$INSTDIR\plugins\access"
	RMDir "$INSTDIR\plugins\access_output"
	RMDir "$INSTDIR\plugins\audio_filter"
	RMDir "$INSTDIR\plugins\audio_mixer"
	RMDir "$INSTDIR\plugins\audio_output"
	RMDir "$INSTDIR\plugins\codec"
	RMDir "$INSTDIR\plugins\control"
	RMDir "$INSTDIR\plugins\d3d9"
	RMDir "$INSTDIR\plugins\d3d11"
	RMDir "$INSTDIR\plugins\demux"
	;RMDir "$INSTDIR\plugins\gui"
	RMDir "$INSTDIR\plugins\keystore"
	RMDir "$INSTDIR\plugins\logger"
	RMDir "$INSTDIR\plugins\lua"
	RMDir "$INSTDIR\plugins\meta_engine"
	RMDir "$INSTDIR\plugins\misc"
	RMDir "$INSTDIR\plugins\mux"
	RMDir "$INSTDIR\plugins\packetizer"
	RMDir "$INSTDIR\plugins\services_discovery"
	RMDir "$INSTDIR\plugins\spu"
	RMDir "$INSTDIR\plugins\stream_filter"
	RMDir "$INSTDIR\plugins\stream_extractor"
                                
	RMDir "$INSTDIR\plugins\stream_out"
	RMDir "$INSTDIR\plugins\text_renderer"
	RMDir "$INSTDIR\plugins\video_chroma"
	RMDir "$INSTDIR\plugins\video_filter"
	RMDir "$INSTDIR\plugins\video_output"
	RMDir "$INSTDIR\plugins\video_splitter"
	RMDir "$INSTDIR\plugins\visualization"
	RMDir "$INSTDIR\plugins"    
	RMDir "$INSTDIR"            
	                            
    !insertmacro MUI_STARTMENU_GETFOLDER Application $StartMenuFolder								
	Delete "$SMPROGRAMS\$StartMenuFolder\Uninstall.lnk"
	Delete "$SMPROGRAMS\$StartMenuFolder\${APPNAME}.lnk"
	RMDir  "$SMPROGRAMS\$StartMenuFolder"
	                            
    Delete "$DESKTOP\TV-Lite.lnk" 
	DeleteRegKey HKCU "Software\TV-Lite\Start Menu Folder"
	DeleteRegKey HKCU "Software\TV-Lite"
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TV-Lite"
                                
SectionEnd                      
                                
                                