#include "ytthread.h"

#include <wx/txtstrm.h>
#include "ytthread.h"
#include "debug.h"
#include "ytprotocolhandler.h"

using namespace tvlite;

CYTThread::CYTThread(wxEvtHandler *handler, CYTProtocol *process): 
                           wxThread(wxTHREAD_JOINABLE),
                           m_ythandler(handler),
                           m_ytprocess(process),
                           m_running(true)
{
   DBG_INFO(" YT Read Thread create");
}

CYTThread::~CYTThread()
{
}

void CYTThread::SetRunning(bool run)
{
   m_access.Lock();
   m_running = run;
   m_access.Unlock();
} 

bool CYTThread::GetRunning()
{
   bool state;
   m_access.Lock();
   state = m_running;
   m_access.Unlock();
   return state;
}

wxThread::ExitCode tvlite::CYTThread::Entry()
{
 
   bool bailout = false;
   DBG_INFO("YT Thread entered");
   if (!m_ytprocess->IsInputOpened())
   {
      DBG_ERROR("YT Input not opened. Leaving");
      bailout = true;
   }
   if (!bailout)
   {   
      wxTextInputStream tis(*m_ytprocess->GetErrorStream());
      while (GetRunning())
      {
         if (m_ytprocess->IsErrorAvailable())
         {
            wxString msg;
            wxMutexGuiEnter();
            msg << tis.ReadLine();
            wxMutexGuiLeave();
            if (m_ytprocess->GetInputStream()->Eof())
            {
               DBG_ERROR("Eof from pipe. Exiting")
               bailout = true;
               break;
            }   
            printf("%s\n", (const char*)msg.c_str());
         }
      }
       wxThread::Yield();
   }
   
    if(bailout ==true)
    {
       DBG_INFO("YT Thread bailed out");
    } 
    DBG_INFO("YT Thread exit");
    return NULL;
}