#ifndef CYTPROTOCOL_H
#define CYTPROTOCOL_H
#include "baseprotocol.h"


namespace tvlite
{
class CYTThread;
   
class CYTProtocol : public CBaseProtocol
{
private:
   CYTProtocol(const CYTProtocol&) = delete;
   CYTProtocol& operator=(const CYTProtocol&) = delete;
   CYTProtocol(CYTProtocol&&) = delete;
   CYTProtocol& operator=(CYTProtocol&&) = delete;
   int m_fileDescriptor;
   CYTThread *m_ytthread;

public:
   CYTProtocol(wxEvtHandler *parent, wxString url, wxString cmd ="");
   virtual ~CYTProtocol();
   virtual int  StartProtocol(long &pid);
   virtual void StopProtocol();

   virtual int LoadConfig();
   virtual int SaveConfig();

   wxString GetUrl();
   void SetURL(wxString url);

   
   int SearchYT(wxString &cmd);
   int GetFileDescriptor();
   virtual void OnTerminate(int pid, int status);
   void WaitThread();

};

}

#endif // CYTPROTOCOL_H
