#ifndef CVLCQuestionDialog_H
#define CVLCQuestionDialog_H
#ifdef __WXMSW__
#include "gui-windows.h"
#else
#include "gui.h"
#endif
#include <memory>
#include <vlc/vlc.h>

#include <wx/string.h>

namespace tvlite
{

struct SDlgData
{
    libvlc_dialog_id *m_p_id;
    wxString m_title;
    wxString m_text;
    libvlc_dialog_question_type m_i_type;
    wxString m_cancel;
    wxString m_action1;
    wxString m_action2;    
    SDlgData(libvlc_dialog_id *p_id, const char *psz_title, const char *psz_text, 
                               libvlc_dialog_question_type i_type,
                               const char *psz_cancel, const char *psz_action1, const char *psz_action2);
    SDlgData() = delete;
    //implicit destructor
};    
    
class CVLCQuestionDialog : public CVLCQuestionDlgBase
{
private:
    CVLCQuestionDialog(const CVLCQuestionDialog&) = delete;
    CVLCQuestionDialog& operator=(const CVLCQuestionDialog&) = delete;
    CVLCQuestionDialog(CVLCQuestionDialog&&) = delete;
    CVLCQuestionDialog& operator=(CVLCQuestionDialog&&) = delete;
    //members
    wxString m_title;
    wxString m_text;
    libvlc_dialog_question_type m_i_type;
    wxString m_cancelString;
    wxString m_act1String;
    wxString m_act2String;
    int m_i_action;

public:
    CVLCQuestionDialog(wxWindow* parent);
    void SetData(std::shared_ptr<SDlgData> &data);
    ~CVLCQuestionDialog();
    int GetAction();
    virtual void OnCancel( wxCommandEvent& event ); 
    virtual void OnAction1( wxCommandEvent& event );
    virtual void OnAction2( wxCommandEvent& event );
    virtual void OnQuestionDlgShow( wxShowEvent& event );
};
}

#endif // CVLCQuestionDialog_H
