from typing import Any

from . import cairo as cairo
from . import constants as constants
from . import ffi as ffi
from .fonts import FontOptions as FontOptions

SURFACE_TARGET_KEY: Any

def from_buffer(obj): ...

class KeepAlive:
    instances: Any
    objects: Any
    closure: Any
    def __init__(self, *objects) -> None: ...
    def save(self) -> None: ...

class Surface:
    def __init__(self, pointer, target_keep_alive: Any | None = ...) -> None: ...
    def create_similar(self, content, width, height): ...
    def create_similar_image(self, content, width, height): ...
    def create_for_rectangle(self, x, y, width, height): ...
    def get_content(self): ...
    def has_show_text_glyphs(self): ...
    def set_device_offset(self, x_offset, y_offset) -> None: ...
    def get_device_offset(self): ...
    def set_fallback_resolution(self, x_pixels_per_inch, y_pixels_per_inch) -> None: ...
    def get_fallback_resolution(self): ...
    def get_font_options(self): ...
    def set_device_scale(self, x_scale, y_scale) -> None: ...
    def get_device_scale(self): ...
    def set_mime_data(self, mime_type, data) -> None: ...
    def get_mime_data(self, mime_type): ...
    def supports_mime_type(self, mime_type): ...
    def mark_dirty(self) -> None: ...
    def mark_dirty_rectangle(self, x, y, width, height) -> None: ...
    def show_page(self) -> None: ...
    def copy_page(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def write_to_png(self, target: Any | None = ...): ...

class ImageSurface(Surface):
    def __init__(
        self, format, width, height, data: Any | None = ..., stride: Any | None = ...
    ) -> None: ...
    @classmethod
    def create_for_data(cls, data, format, width, height, stride: Any | None = ...): ...
    @staticmethod
    def format_stride_for_width(format, width): ...
    @classmethod
    def create_from_png(cls, source): ...
    def get_data(self): ...
    def get_format(self): ...
    def get_width(self): ...
    def get_height(self): ...
    def get_stride(self): ...

class PDFSurface(Surface):
    def __init__(self, target, width_in_points, height_in_points) -> None: ...
    def set_size(self, width_in_points, height_in_points) -> None: ...
    def add_outline(self, parent_id, utf8, link_attribs, flags: Any | None = ...): ...
    def set_metadata(self, metadata, utf8) -> None: ...
    def set_page_label(self, utf8) -> None: ...
    def set_thumbnail_size(self, width, height) -> None: ...
    def restrict_to_version(self, version) -> None: ...
    @staticmethod
    def get_versions(): ...
    @staticmethod
    def version_to_string(version): ...

class PSSurface(Surface):
    def __init__(self, target, width_in_points, height_in_points) -> None: ...
    def dsc_comment(self, comment) -> None: ...
    def dsc_begin_setup(self) -> None: ...
    def dsc_begin_page_setup(self) -> None: ...
    def set_eps(self, eps) -> None: ...
    def get_eps(self): ...
    def set_size(self, width_in_points, height_in_points) -> None: ...
    def restrict_to_level(self, level) -> None: ...
    @staticmethod
    def get_levels(): ...
    @staticmethod
    def ps_level_to_string(level): ...

class SVGSurface(Surface):
    def __init__(self, target, width_in_points, height_in_points) -> None: ...
    def restrict_to_version(self, version) -> None: ...
    def set_document_unit(self, unit) -> None: ...
    def get_document_unit(self): ...
    @staticmethod
    def get_versions(): ...
    @staticmethod
    def version_to_string(version): ...

class RecordingSurface(Surface):
    def __init__(self, content, extents) -> None: ...
    def get_extents(self): ...
    def ink_extents(self): ...

class Win32Surface(Surface):
    def __init__(self, hdc) -> None: ...

class Win32PrintingSurface(Surface):
    def __init__(self, hdc) -> None: ...

SURFACE_TYPE_TO_CLASS: Any
