from typing import Any

from . import cairo as cairo
from . import constants as constants
from . import ffi as ffi
from .matrix import Matrix as Matrix
from .surfaces import Surface as Surface

class Pattern:
    def __init__(self, pointer) -> None: ...
    def set_extend(self, extend) -> None: ...
    def get_extend(self): ...
    def set_filter(self, filter) -> None: ...
    def get_filter(self): ...
    def set_matrix(self, matrix) -> None: ...
    def get_matrix(self): ...

class SolidPattern(Pattern):
    def __init__(self, red, green, blue, alpha: int = ...) -> None: ...
    def get_rgba(self): ...

class SurfacePattern(Pattern):
    def __init__(self, surface) -> None: ...
    def get_surface(self): ...

class Gradient(Pattern):
    def add_color_stop_rgba(self, offset, red, green, blue, alpha: int = ...) -> None: ...
    def add_color_stop_rgb(self, offset, red, green, blue) -> None: ...
    def get_color_stops(self): ...

class LinearGradient(Gradient):
    def __init__(self, x0, y0, x1, y1) -> None: ...
    def get_linear_points(self): ...

class RadialGradient(Gradient):
    def __init__(self, cx0, cy0, radius0, cx1, cy1, radius1) -> None: ...
    def get_radial_circles(self): ...

PATTERN_TYPE_TO_CLASS: Any
