/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstReferenceOwner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstReferenceExpression
extends PyAstQualifiedExpression,
PyAstReferenceOwner {
    public static final PyAstReferenceExpression[] EMPTY_ARRAY = new PyAstReferenceExpression[0];

    @Override
    @Nullable
    default public PyAstExpression getQualifier() {
        ASTNode[] nodes = this.getNode().getChildren(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens());
        return (PyAstExpression)(nodes.length == 1 ? nodes[0].getPsi() : null);
    }

    @Override
    default public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    @Nullable
    default public String getReferencedName() {
        ASTNode nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getText() : null;
    }

    @Override
    @Nullable
    default public ASTNode getNameElement() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    @Nullable
    default public String getName() {
        return this.getReferencedName();
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyReferenceExpression(this);
    }
}

