/*
 * Decompiled with CFR 0.152.
 */
package plan;

import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.reader.UniversalProjectReader;
import plan.PlanWriter;

public class Convert {
    public static void main(String[] stringArray) {
        System.out.println("Convert");
        try {
            System.out.println("Convert args: " + stringArray.length);
            Convert convert = new Convert();
            if (stringArray.length < 1 || stringArray.length > 6) {
                convert.usage();
            } else {
                List<String> list = convert.extractOptions(stringArray);
                System.out.println("Convert args: options = " + list);
                if (!(list.isEmpty() || list.size() == 2 && stringArray.length >= list.size() * 2 + 1)) {
                    convert.usage();
                } else {
                    Integer n = list.size() * 2;
                    String string = new String();
                    String string2 = new String();
                    if (!list.isEmpty()) {
                        string = list.get(0);
                        string2 = list.get(1);
                    }
                    System.out.println("Reading input file started: " + stringArray[n]);
                    long l = System.currentTimeMillis();
                    ProjectFile projectFile = Convert.readFile(stringArray[n], string, string2);
                    long l2 = System.currentTimeMillis() - l;
                    System.out.println("Reading input file completed in " + l2 + "ms.");
                    if (stringArray.length == n + 2) {
                        System.out.println("Writing Plan output file started: " + stringArray[n + 1]);
                        PlanWriter planWriter = new PlanWriter();
                        planWriter.write(projectFile, stringArray[n + 1]);
                        System.out.println("Writing Plan output file completed.");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("Convert Exception");
            throwable.printStackTrace(System.out);
        }
    }

    public void usage() {
        System.out.println("Usage: Convert [--type <file type> --password <password>] <input file name> [<plan file name>]");
    }

    public List<String> extractOptions(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray.length < 4) {
            return arrayList;
        }
        if (!stringArray[0].startsWith("--type") || !stringArray[2].startsWith("--password")) {
            System.out.println("extractOptions: failed: args[0] = " + stringArray[0] + ", args[2] = " + stringArray[2]);
            return arrayList;
        }
        arrayList.add(stringArray[1]);
        arrayList.add(stringArray[3]);
        return arrayList;
    }

    public static ProjectFile readFile(String string, String string2, String string3) throws MPXJException {
        ProjectFile projectFile;
        if (string2.contentEquals("mpp")) {
            MPPReader mPPReader = new MPPReader();
            mPPReader.setReadPassword(string3);
            projectFile = mPPReader.read(string);
        } else {
            System.out.println("readFile: read any project type");
            UniversalProjectReader universalProjectReader = new UniversalProjectReader();
            projectFile = universalProjectReader.read(string);
        }
        if (projectFile == null) {
            throw new IllegalArgumentException("Unsupported file type");
        }
        return projectFile;
    }
}

