/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.projectcommander;

import java.util.Set;
import net.sf.mpxj.common.ByteArrayHelper;
import net.sf.mpxj.projectcommander.BlockPatternValidator;

final class BlockPattern {
    private final String m_name;
    private final byte[] m_pattern;
    private final BlockPatternValidator m_validator;

    public BlockPattern(String name, BlockPatternValidator validator, byte ... pattern) {
        this.m_name = name;
        this.m_validator = validator;
        this.m_pattern = pattern;
    }

    public BlockPattern(String name, byte ... pattern) {
        this(name, null, pattern);
    }

    public BlockPattern(String name, byte[] data, int offset) {
        this(name, data[offset], data[offset + 1]);
    }

    public BlockPattern(String name, BlockPatternValidator validator, byte[] data, int offset) {
        this(name, validator, data[offset], data[offset + 1]);
    }

    public String getName() {
        return this.m_name;
    }

    public byte[] getPattern() {
        return this.m_pattern;
    }

    public boolean getValid(Set<String> matchedPatternNames) {
        return this.m_validator == null || this.m_validator.valid(matchedPatternNames);
    }

    public String toString() {
        return this.m_name + ": " + ByteArrayHelper.hexdump(this.m_pattern, false);
    }
}

