/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.TreeMap;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

final class PropsBlock
extends Props {
    PropsBlock(byte[] data) {
        int dataSize = MPPUtility.getInt(data, 0);
        int itemCount = MPPUtility.getInt(data, 4);
        int offset = 8;
        TreeMap<Integer, Integer> offsetMap = new TreeMap<Integer, Integer>();
        for (int loop = 0; loop < itemCount; ++loop) {
            int itemKey = MPPUtility.getInt(data, offset);
            int itemOffset = MPPUtility.getInt(data, offset += 4);
            offset += 4;
            offsetMap.put(itemOffset, itemKey);
        }
        Integer previousItemOffset = null;
        Integer previousItemKey = null;
        for (Integer itemOffset : offsetMap.keySet()) {
            this.populateMap(data, previousItemOffset, previousItemKey, itemOffset);
            previousItemOffset = itemOffset;
            previousItemKey = (Integer)offsetMap.get(previousItemOffset);
        }
        if (previousItemOffset != null) {
            Integer itemOffset = dataSize;
            this.populateMap(data, previousItemOffset, previousItemKey, itemOffset);
        }
    }

    private void populateMap(byte[] data, Integer previousItemOffset, Integer previousItemKey, Integer itemOffset) {
        if (previousItemOffset != null) {
            int itemSize = itemOffset - previousItemOffset;
            byte[] itemData = new byte[itemSize];
            System.arraycopy(data, previousItemOffset, itemData, 0, itemSize);
            this.m_map.put(previousItemKey, itemData);
        }
    }
}

