/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FixedLengthInputStream
extends FilterInputStream {
    private long m_remaining;

    public FixedLengthInputStream(InputStream in, long length) {
        super(in);
        this.m_remaining = length;
    }

    @Override
    public void close() throws IOException {
        if (this.m_remaining > 0L) {
            long skippedLast = this.skip(this.m_remaining);
            while (this.m_remaining > 0L && skippedLast > 0L) {
                skippedLast = this.skip(this.m_remaining);
            }
        }
    }

    @Override
    public int available() {
        return this.m_remaining > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.m_remaining;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        int b = -1;
        if (this.m_remaining > 0L && (b = this.in.read()) != -1) {
            --this.m_remaining;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = -1;
        if (this.m_remaining > 0L && (bytesRead = this.in.read(b, off, (int)Math.min((long)len, this.m_remaining))) > 0) {
            this.m_remaining -= (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = 0L;
        if (this.m_remaining > 0L) {
            bytesSkipped = this.in.skip(Math.min(n, this.m_remaining));
            this.m_remaining -= bytesSkipped;
        }
        return bytesSkipped;
    }
}

