/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkContainer;
import net.sf.mpxj.common.TimephasedNormaliser;

public class DefaultTimephasedWorkContainer
implements TimephasedWorkContainer {
    private final List<TimephasedWork> m_data;
    private boolean m_raw;
    private final TimephasedNormaliser<TimephasedWork> m_normaliser;
    private final ResourceAssignment m_assignment;

    public DefaultTimephasedWorkContainer(ResourceAssignment assignment, TimephasedNormaliser<TimephasedWork> normaliser, List<TimephasedWork> data, boolean raw) {
        this.m_data = data;
        this.m_raw = raw;
        this.m_assignment = assignment;
        this.m_normaliser = normaliser;
    }

    private DefaultTimephasedWorkContainer(DefaultTimephasedWorkContainer source, double perDayFactor, double totalFactor) {
        this.m_data = new ArrayList<TimephasedWork>();
        this.m_raw = source.m_raw;
        this.m_assignment = source.m_assignment;
        this.m_normaliser = source.m_normaliser;
        for (TimephasedWork sourceItem : source.m_data) {
            this.m_data.add(new TimephasedWork(sourceItem, totalFactor, perDayFactor));
        }
    }

    @Override
    public List<TimephasedWork> getData() {
        if (this.m_raw) {
            this.m_normaliser.normalise(this.m_assignment, this.m_data);
            this.m_raw = false;
        }
        return this.m_data;
    }

    @Override
    public boolean hasData() {
        return !this.m_data.isEmpty();
    }

    @Override
    public TimephasedWorkContainer applyFactor(double perDayFactor, double totalFactor) {
        return new DefaultTimephasedWorkContainer(this, perDayFactor, totalFactor);
    }
}

