/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.CustomFieldValueMask;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GraphicalIndicator;
import net.sf.mpxj.common.FieldTypeHelper;

public class CustomField {
    private final FieldType m_field;
    private final CustomFieldContainer m_parent;
    private final CustomFieldLookupTable m_table;
    private final GraphicalIndicator m_indicator;
    private final List<CustomFieldValueMask> m_masks;
    private Integer m_uniqueID;
    private String m_alias;
    private DataType m_customFieldDataType;

    public CustomField(FieldType field, CustomFieldContainer parent) {
        this.m_field = field;
        this.m_parent = parent;
        this.m_table = new CustomFieldLookupTable();
        this.m_indicator = new GraphicalIndicator();
        this.m_masks = new ArrayList<CustomFieldValueMask>();
    }

    public FieldType getFieldType() {
        return this.m_field;
    }

    public CustomFieldLookupTable getLookupTable() {
        return this.m_table;
    }

    public GraphicalIndicator getGraphicalIndicator() {
        return this.m_indicator;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public CustomField setAlias(String alias) {
        this.m_alias = alias;
        this.m_parent.registerAlias(this.m_field, alias);
        return this;
    }

    public Integer getUniqueID() {
        if (this.m_uniqueID == null) {
            this.m_uniqueID = FieldTypeHelper.getFieldID(this.m_field);
        }
        return this.m_uniqueID;
    }

    public CustomField setUniqueID(Integer uniqueID) {
        this.m_uniqueID = uniqueID;
        return this;
    }

    public DataType getCustomFieldDataType() {
        return this.m_customFieldDataType;
    }

    public CustomField setCustomFieldDataType(DataType type) {
        this.m_customFieldDataType = type;
        return this;
    }

    public List<CustomFieldValueMask> getMasks() {
        return this.m_masks;
    }

    public String toString() {
        return "[CustomField field=" + this.m_field + " alias=" + this.m_alias + "]";
    }
}

