// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeUInt16Array
 * @brief   soa array of vtkTypeUInt16.
 *
 * vtkSOATypeUInt16Array is a soa array of values of type vtkTypeUInt16.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeUInt16Array_h
#define vtkSOATypeUInt16Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeUInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeUInt16Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeUInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeUInt16Array* New();
  static vtkSOATypeUInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeUInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeUInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeUInt16Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeUInt16Array();
  ~vtkSOATypeUInt16Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeUInt16> RealSuperclass;

  vtkSOATypeUInt16Array(const vtkSOATypeUInt16Array&) = delete;
  void operator=(const vtkSOATypeUInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeUInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
