// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedUnsignedLongArray
 * @brief   indexed implicit array of unsigned long.
 *
 * vtkIndexedUnsignedLongArray is an indexed implicit array of values of type unsigned long.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkIndexedUnsignedLongArray_h
#define vtkIndexedUnsignedLongArray_h

#include "vtkIndexedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<unsigned long>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkIndexedType*Array instead") vtkIndexedUnsignedLongArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedUnsignedLongArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedUnsignedLongArray* New();
  static vtkIndexedUnsignedLongArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned long);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedUnsignedLongArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedUnsignedLongArray*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedUnsignedLongArray();
  ~vtkIndexedUnsignedLongArray() override;

private:
  typedef vtkIndexedArray<unsigned long> RealSuperclass;

  vtkIndexedUnsignedLongArray(const vtkIndexedUnsignedLongArray&) = delete;
  void operator=(const vtkIndexedUnsignedLongArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedUnsignedLongArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
