// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantTypeInt16Array
 * @brief   constant implicit array of vtkTypeInt16.
 *
 * vtkConstantTypeInt16Array is a constant implicit array of values of type vtkTypeInt16.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantTypeInt16Array_h
#define vtkConstantTypeInt16Array_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<vtkTypeInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkConstantTypeInt16Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantTypeInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt16);
#endif

  static vtkConstantTypeInt16Array* New();
  static vtkConstantTypeInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantTypeInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantTypeInt16Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(vtkTypeInt16 value);

protected:
  vtkConstantTypeInt16Array();
  ~vtkConstantTypeInt16Array() override;

private:
  typedef vtkConstantArray<vtkTypeInt16> RealSuperclass;

  vtkConstantTypeInt16Array(const vtkConstantTypeInt16Array&) = delete;
  void operator=(const vtkConstantTypeInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantTypeInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
