// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeTypeUInt16Array
 * @brief   composite implicit array of vtkTypeUInt16.
 *
 * vtkCompositeTypeUInt16Array is a composite implicit array of values of type vtkTypeUInt16.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeTypeUInt16Array_h
#define vtkCompositeTypeUInt16Array_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<vtkTypeUInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT  vtkCompositeTypeUInt16Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeTypeUInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeTypeUInt16Array* New();
  static vtkCompositeTypeUInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeTypeUInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeTypeUInt16Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeTypeUInt16Array();
  ~vtkCompositeTypeUInt16Array() override;

private:
  typedef vtkCompositeArray<vtkTypeUInt16> RealSuperclass;

  vtkCompositeTypeUInt16Array(const vtkCompositeTypeUInt16Array&) = delete;
  void operator=(const vtkCompositeTypeUInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeTypeUInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
