// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeIdTypeArray
 * @brief   composite implicit array of vtkIdType.
 *
 * vtkCompositeIdTypeArray is a composite implicit array of values of type vtkIdType.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeIdTypeArray_h
#define vtkCompositeIdTypeArray_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<vtkIdType>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkCompositeType*Array instead") vtkCompositeIdTypeArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeIdTypeArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeIdTypeArray* New();
  static vtkCompositeIdTypeArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkIdType);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeIdTypeArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeIdTypeArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeIdTypeArray();
  ~vtkCompositeIdTypeArray() override;

private:
  typedef vtkCompositeArray<vtkIdType> RealSuperclass;

  vtkCompositeIdTypeArray(const vtkCompositeIdTypeArray&) = delete;
  void operator=(const vtkCompositeIdTypeArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeIdTypeArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
