/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.custom.utils;

import com.virtuslab.using_directives.custom.utils.Position;
import java.util.ArrayList;
import java.util.List;

public class Source {
    protected final char[] content;
    protected final List<Integer> lineStarts;

    public Source(char[] content) {
        this.lineStarts = this.calculateLineStarts(content);
        this.content = content;
    }

    public char[] getContent() {
        return this.content;
    }

    public Position getPositionFromOffset(int offset) {
        int lineNumber = -1;
        int columnNumber = -1;
        for (int i = this.lineStarts.size() - 1; i >= 0; --i) {
            if (this.lineStarts.get(i) > offset) continue;
            lineNumber = i;
            columnNumber = offset - this.lineStarts.get(i);
            break;
        }
        return new Position(lineNumber, columnNumber, offset);
    }

    public int translateOffset(int offset) {
        return offset;
    }

    private List<Integer> calculateLineStarts(char[] content) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(0);
        for (int i = 0; i < content.length; ++i) {
            if (content[i] != '\n') continue;
            result.add(i + 1);
        }
        return result;
    }
}

