/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.custom;

public class SimpleCommentExtractor {
    public static char USING_DIRECTIVE_INDICATOR = (char)62;
    char[] source;
    boolean useIndicator;
    char[] res;
    char c;
    int i;
    boolean insideSingleLineComment = false;
    boolean insideDirective = false;

    public SimpleCommentExtractor(char[] source, boolean useIndicator) {
        this.source = source;
        this.useIndicator = useIndicator;
    }

    public boolean isEndOfLine() {
        return this.c == '\f' || this.c == '\r' || this.c == '\n';
    }

    public boolean aWhiteSpace() {
        return this.c == ' ' || this.c == '\t' || this.c == '\u001a' || this.isEndOfLine();
    }

    char next() {
        if (this.i + 1 < this.source.length) {
            return this.source[this.i + 1];
        }
        return '\u001a';
    }

    void use() {
        if (this.i < this.res.length) {
            this.res[this.i] = this.source[this.i];
        }
    }

    void skip() {
        if (this.i < this.res.length) {
            this.res[this.i] = 32;
        }
    }

    void skipNext() {
        if (this.i + 1 < this.res.length) {
            this.res[this.i + 1] = 32;
            ++this.i;
        }
    }

    public char[] extractComments() {
        this.res = new char[this.source.length];
        this.i = 0;
        while (this.i < this.res.length) {
            this.c = this.source[this.i];
            if (this.insideSingleLineComment) {
                if (this.isEndOfLine()) {
                    this.insideDirective = false;
                    this.insideSingleLineComment = false;
                    this.use();
                } else if (this.insideDirective) {
                    this.use();
                } else {
                    this.skip();
                }
            } else if (this.aWhiteSpace()) {
                this.use();
            } else {
                if (this.c == '/') {
                    if (this.next() == '/') {
                        this.insideSingleLineComment = true;
                    }
                    this.skip();
                    if (this.insideSingleLineComment) {
                        this.skipNext();
                        boolean hasIndicator = this.next() == USING_DIRECTIVE_INDICATOR;
                        boolean bl = this.insideDirective = hasIndicator == this.useIndicator;
                        if (this.useIndicator && hasIndicator) {
                            this.skipNext();
                        }
                    }
                }
                this.skip();
            }
            ++this.i;
        }
        return this.res;
    }
}

