/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

import scala.math.ScalaNumber;

public final class BoxesRunTime {
    private static final int CHAR = 0;
    private static final int INT = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;
    private static final int OTHER = 7;

    private static int typeCode(Object object) {
        if (object instanceof Integer) {
            return 3;
        }
        if (object instanceof Double) {
            return 6;
        }
        if (object instanceof Long) {
            return 4;
        }
        if (object instanceof Character) {
            return 0;
        }
        if (object instanceof Float) {
            return 5;
        }
        if (object instanceof Byte || object instanceof Short) {
            return 3;
        }
        return 7;
    }

    public static Boolean boxToBoolean(boolean bl) {
        return bl;
    }

    public static Character boxToCharacter(char c) {
        return Character.valueOf(c);
    }

    public static Byte boxToByte(byte by) {
        return by;
    }

    public static Short boxToShort(short s) {
        return s;
    }

    public static Integer boxToInteger(int n) {
        return n;
    }

    public static Long boxToLong(long l) {
        return l;
    }

    public static Float boxToFloat(float f) {
        return Float.valueOf(f);
    }

    public static Double boxToDouble(double d) {
        return d;
    }

    public static boolean unboxToBoolean(Object object) {
        return object == null ? false : (Boolean)object;
    }

    public static char unboxToChar(Object object) {
        return object == null ? (char)'\u0000' : ((Character)object).charValue();
    }

    public static byte unboxToByte(Object object) {
        return object == null ? (byte)0 : (Byte)object;
    }

    public static short unboxToShort(Object object) {
        return object == null ? (short)0 : (Short)object;
    }

    public static int unboxToInt(Object object) {
        return object == null ? 0 : (Integer)object;
    }

    public static long unboxToLong(Object object) {
        return object == null ? 0L : (Long)object;
    }

    public static float unboxToFloat(Object object) {
        return object == null ? 0.0f : ((Float)object).floatValue();
    }

    public static double unboxToDouble(Object object) {
        return object == null ? 0.0 : (Double)object;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        return BoxesRunTime.equals2(object, object2);
    }

    public static boolean equals2(Object object, Object object2) {
        if (object instanceof Number) {
            return BoxesRunTime.equalsNumObject((Number)object, object2);
        }
        if (object instanceof Character) {
            return BoxesRunTime.equalsCharObject((Character)object, object2);
        }
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static boolean equalsNumObject(Number number, Object object) {
        if (object instanceof Number) {
            return BoxesRunTime.equalsNumNum(number, (Number)object);
        }
        if (object instanceof Character) {
            return BoxesRunTime.equalsNumChar(number, (Character)object);
        }
        if (number == null) {
            return object == null;
        }
        return number.equals(object);
    }

    public static boolean equalsNumNum(Number number, Number number2) {
        int n = BoxesRunTime.typeCode(number);
        int n2 = BoxesRunTime.typeCode(number2);
        switch (n2 > n ? n2 : n) {
            case 3: {
                return number.intValue() == number2.intValue();
            }
            case 4: {
                return number.longValue() == number2.longValue();
            }
            case 5: {
                return number.floatValue() == number2.floatValue();
            }
            case 6: {
                return number.doubleValue() == number2.doubleValue();
            }
        }
        if (number2 instanceof ScalaNumber && !(number instanceof ScalaNumber)) {
            return number2.equals(number);
        }
        if (number == null) {
            return number2 == null;
        }
        return number.equals(number2);
    }

    public static boolean equalsCharObject(Character c, Object object) {
        if (object instanceof Character) {
            return c.charValue() == ((Character)object).charValue();
        }
        if (object instanceof Number) {
            return BoxesRunTime.equalsNumChar((Number)object, c);
        }
        if (c == null) {
            return object == null;
        }
        return c.equals(object);
    }

    public static boolean equalsNumChar(Number number, Character c) {
        if (c == null) {
            return number == null;
        }
        char c2 = c.charValue();
        switch (BoxesRunTime.typeCode(number)) {
            case 3: {
                return number.intValue() == c2;
            }
            case 4: {
                return number.longValue() == (long)c2;
            }
            case 5: {
                return number.floatValue() == (float)c2;
            }
            case 6: {
                return number.doubleValue() == (double)c2;
            }
        }
        return number.equals(c);
    }

    private static int unboxCharOrInt(Object object, int n) {
        if (n == 0) {
            return ((Character)object).charValue();
        }
        return ((Number)object).intValue();
    }

    private static long unboxCharOrLong(Object object, int n) {
        if (n == 0) {
            return ((Character)object).charValue();
        }
        return ((Number)object).longValue();
    }

    private static float unboxCharOrFloat(Object object, int n) {
        if (n == 0) {
            return ((Character)object).charValue();
        }
        return ((Number)object).floatValue();
    }

    private static double unboxCharOrDouble(Object object, int n) {
        if (n == 0) {
            return ((Character)object).charValue();
        }
        return ((Number)object).doubleValue();
    }

    public static Object add(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n3) + BoxesRunTime.unboxCharOrInt(object2, n));
        }
        if (n2 <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n3) + BoxesRunTime.unboxCharOrLong(object2, n));
        }
        if (n2 <= 5) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxCharOrFloat(object, n3) + BoxesRunTime.unboxCharOrFloat(object2, n));
        }
        if (n2 <= 6) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxCharOrDouble(object, n3) + BoxesRunTime.unboxCharOrDouble(object2, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object subtract(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n3) - BoxesRunTime.unboxCharOrInt(object2, n));
        }
        if (n2 <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n3) - BoxesRunTime.unboxCharOrLong(object2, n));
        }
        if (n2 <= 5) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxCharOrFloat(object, n3) - BoxesRunTime.unboxCharOrFloat(object2, n));
        }
        if (n2 <= 6) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxCharOrDouble(object, n3) - BoxesRunTime.unboxCharOrDouble(object2, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object multiply(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n3) * BoxesRunTime.unboxCharOrInt(object2, n));
        }
        if (n2 <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n3) * BoxesRunTime.unboxCharOrLong(object2, n));
        }
        if (n2 <= 5) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxCharOrFloat(object, n3) * BoxesRunTime.unboxCharOrFloat(object2, n));
        }
        if (n2 <= 6) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxCharOrDouble(object, n3) * BoxesRunTime.unboxCharOrDouble(object2, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object divide(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n3) / BoxesRunTime.unboxCharOrInt(object2, n));
        }
        if (n2 <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n3) / BoxesRunTime.unboxCharOrLong(object2, n));
        }
        if (n2 <= 5) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxCharOrFloat(object, n3) / BoxesRunTime.unboxCharOrFloat(object2, n));
        }
        if (n2 <= 6) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxCharOrDouble(object, n3) / BoxesRunTime.unboxCharOrDouble(object2, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object takeModulo(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n3) % BoxesRunTime.unboxCharOrInt(object2, n));
        }
        if (n2 <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n3) % BoxesRunTime.unboxCharOrLong(object2, n));
        }
        if (n2 <= 5) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxCharOrFloat(object, n3) % BoxesRunTime.unboxCharOrFloat(object2, n));
        }
        if (n2 <= 6) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxCharOrDouble(object, n3) % BoxesRunTime.unboxCharOrDouble(object2, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftSignedRight(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3 = BoxesRunTime.unboxCharOrInt(object, n);
            if (n2 <= 3) {
                int n4 = BoxesRunTime.unboxCharOrInt(object2, n2);
                return BoxesRunTime.boxToInteger(n3 >> n4);
            }
            if (n2 <= 4) {
                long l = BoxesRunTime.unboxCharOrLong(object2, n2);
                return BoxesRunTime.boxToInteger(n3 >> (int)l);
            }
        }
        if (n <= 4) {
            long l = BoxesRunTime.unboxCharOrLong(object, n);
            if (n2 <= 3) {
                int n5 = BoxesRunTime.unboxCharOrInt(object2, n2);
                return BoxesRunTime.boxToLong(l >> n5);
            }
            if (n2 <= 4) {
                long l2 = BoxesRunTime.unboxCharOrLong(object2, n2);
                return BoxesRunTime.boxToLong(l >> (int)l2);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftSignedLeft(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3 = BoxesRunTime.unboxCharOrInt(object, n);
            if (n2 <= 3) {
                int n4 = BoxesRunTime.unboxCharOrInt(object2, n2);
                return BoxesRunTime.boxToInteger(n3 << n4);
            }
            if (n2 <= 4) {
                long l = BoxesRunTime.unboxCharOrLong(object2, n2);
                return BoxesRunTime.boxToInteger(n3 << (int)l);
            }
        }
        if (n <= 4) {
            long l = BoxesRunTime.unboxCharOrLong(object, n);
            if (n2 <= 3) {
                int n5 = BoxesRunTime.unboxCharOrInt(object2, n2);
                return BoxesRunTime.boxToLong(l << n5);
            }
            if (n2 <= 4) {
                long l2 = BoxesRunTime.unboxCharOrLong(object2, n2);
                return BoxesRunTime.boxToLong(l << (int)l2);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftLogicalRight(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3 = BoxesRunTime.unboxCharOrInt(object, n);
            if (n2 <= 3) {
                int n4 = BoxesRunTime.unboxCharOrInt(object2, n2);
                return BoxesRunTime.boxToInteger(n3 >>> n4);
            }
            if (n2 <= 4) {
                long l = BoxesRunTime.unboxCharOrLong(object2, n2);
                return BoxesRunTime.boxToInteger(n3 >>> (int)l);
            }
        }
        if (n <= 4) {
            long l = BoxesRunTime.unboxCharOrLong(object, n);
            if (n2 <= 3) {
                int n5 = BoxesRunTime.unboxCharOrInt(object2, n2);
                return BoxesRunTime.boxToLong(l >>> n5);
            }
            if (n2 <= 4) {
                long l2 = BoxesRunTime.unboxCharOrLong(object2, n2);
                return BoxesRunTime.boxToLong(l >>> (int)l2);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object negate(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            int n2 = BoxesRunTime.unboxCharOrInt(object, n);
            return BoxesRunTime.boxToInteger(-n2);
        }
        if (n <= 4) {
            long l = BoxesRunTime.unboxCharOrLong(object, n);
            return BoxesRunTime.boxToLong(-l);
        }
        if (n <= 5) {
            float f = BoxesRunTime.unboxCharOrFloat(object, n);
            return BoxesRunTime.boxToFloat(-f);
        }
        if (n <= 6) {
            double d = BoxesRunTime.unboxCharOrDouble(object, n);
            return BoxesRunTime.boxToDouble(-d);
        }
        throw new NoSuchMethodException();
    }

    public static Object positive(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n));
        }
        if (n <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n));
        }
        if (n <= 5) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxCharOrFloat(object, n));
        }
        if (n <= 6) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxCharOrDouble(object, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object takeAnd(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (object instanceof Boolean && object2 instanceof Boolean) {
                return BoxesRunTime.boxToBoolean((Boolean)object & (Boolean)object2);
            }
            throw new NoSuchMethodException();
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n3) & BoxesRunTime.unboxCharOrInt(object2, n));
        }
        if (n2 <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n3) & BoxesRunTime.unboxCharOrLong(object2, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object takeOr(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (object instanceof Boolean && object2 instanceof Boolean) {
                return BoxesRunTime.boxToBoolean((Boolean)object | (Boolean)object2);
            }
            throw new NoSuchMethodException();
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n3) | BoxesRunTime.unboxCharOrInt(object2, n));
        }
        if (n2 <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n3) | BoxesRunTime.unboxCharOrLong(object2, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object takeXor(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (object instanceof Boolean && object2 instanceof Boolean) {
                return BoxesRunTime.boxToBoolean((Boolean)object ^ (Boolean)object2);
            }
            throw new NoSuchMethodException();
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxCharOrInt(object, n3) ^ BoxesRunTime.unboxCharOrInt(object2, n));
        }
        if (n2 <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n3) ^ BoxesRunTime.unboxCharOrLong(object2, n));
        }
        throw new NoSuchMethodException();
    }

    public static Object takeConditionalAnd(Object object, Object object2) throws NoSuchMethodException {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object != false && (Boolean)object2 != false);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeConditionalOr(Object object, Object object2) throws NoSuchMethodException {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object != false || (Boolean)object2 != false);
        }
        throw new NoSuchMethodException();
    }

    public static Object complement(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            return BoxesRunTime.boxToInteger(~BoxesRunTime.unboxCharOrInt(object, n));
        }
        if (n <= 4) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxCharOrLong(object, n) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeNot(Object object) throws NoSuchMethodException {
        if (object instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object == false);
        }
        throw new NoSuchMethodException();
    }

    public static Object testEqual(Object object, Object object2) throws NoSuchMethodException {
        return BoxesRunTime.boxToBoolean(object == object2);
    }

    public static Object testNotEqual(Object object, Object object2) throws NoSuchMethodException {
        return BoxesRunTime.boxToBoolean(object != object2);
    }

    public static Object testLessThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5;
            int n6 = BoxesRunTime.unboxCharOrInt(object, n3);
            return BoxesRunTime.boxToBoolean(n6 < (n5 = BoxesRunTime.unboxCharOrInt(object2, n)));
        }
        if (n2 <= 4) {
            long l;
            long l2 = BoxesRunTime.unboxCharOrLong(object, n3);
            return BoxesRunTime.boxToBoolean(l2 < (l = BoxesRunTime.unboxCharOrLong(object2, n)));
        }
        if (n2 <= 5) {
            float f;
            float f2 = BoxesRunTime.unboxCharOrFloat(object, n3);
            return BoxesRunTime.boxToBoolean(f2 < (f = BoxesRunTime.unboxCharOrFloat(object2, n)));
        }
        if (n2 <= 6) {
            double d;
            double d2 = BoxesRunTime.unboxCharOrDouble(object, n3);
            return BoxesRunTime.boxToBoolean(d2 < (d = BoxesRunTime.unboxCharOrDouble(object2, n)));
        }
        throw new NoSuchMethodException();
    }

    public static Object testLessOrEqualThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5;
            int n6 = BoxesRunTime.unboxCharOrInt(object, n3);
            return BoxesRunTime.boxToBoolean(n6 <= (n5 = BoxesRunTime.unboxCharOrInt(object2, n)));
        }
        if (n2 <= 4) {
            long l;
            long l2 = BoxesRunTime.unboxCharOrLong(object, n3);
            return BoxesRunTime.boxToBoolean(l2 <= (l = BoxesRunTime.unboxCharOrLong(object2, n)));
        }
        if (n2 <= 5) {
            float f;
            float f2 = BoxesRunTime.unboxCharOrFloat(object, n3);
            return BoxesRunTime.boxToBoolean(f2 <= (f = BoxesRunTime.unboxCharOrFloat(object2, n)));
        }
        if (n2 <= 6) {
            double d;
            double d2 = BoxesRunTime.unboxCharOrDouble(object, n3);
            return BoxesRunTime.boxToBoolean(d2 <= (d = BoxesRunTime.unboxCharOrDouble(object2, n)));
        }
        throw new NoSuchMethodException();
    }

    public static Object testGreaterOrEqualThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5;
            int n6 = BoxesRunTime.unboxCharOrInt(object, n3);
            return BoxesRunTime.boxToBoolean(n6 >= (n5 = BoxesRunTime.unboxCharOrInt(object2, n)));
        }
        if (n2 <= 4) {
            long l;
            long l2 = BoxesRunTime.unboxCharOrLong(object, n3);
            return BoxesRunTime.boxToBoolean(l2 >= (l = BoxesRunTime.unboxCharOrLong(object2, n)));
        }
        if (n2 <= 5) {
            float f;
            float f2 = BoxesRunTime.unboxCharOrFloat(object, n3);
            return BoxesRunTime.boxToBoolean(f2 >= (f = BoxesRunTime.unboxCharOrFloat(object2, n)));
        }
        if (n2 <= 6) {
            double d;
            double d2 = BoxesRunTime.unboxCharOrDouble(object, n3);
            return BoxesRunTime.boxToBoolean(d2 >= (d = BoxesRunTime.unboxCharOrDouble(object2, n)));
        }
        throw new NoSuchMethodException();
    }

    public static Object testGreaterThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5;
            int n6 = BoxesRunTime.unboxCharOrInt(object, n3);
            return BoxesRunTime.boxToBoolean(n6 > (n5 = BoxesRunTime.unboxCharOrInt(object2, n)));
        }
        if (n2 <= 4) {
            long l;
            long l2 = BoxesRunTime.unboxCharOrLong(object, n3);
            return BoxesRunTime.boxToBoolean(l2 > (l = BoxesRunTime.unboxCharOrLong(object2, n)));
        }
        if (n2 <= 5) {
            float f;
            float f2 = BoxesRunTime.unboxCharOrFloat(object, n3);
            return BoxesRunTime.boxToBoolean(f2 > (f = BoxesRunTime.unboxCharOrFloat(object2, n)));
        }
        if (n2 <= 6) {
            double d;
            double d2 = BoxesRunTime.unboxCharOrDouble(object, n3);
            return BoxesRunTime.boxToBoolean(d2 > (d = BoxesRunTime.unboxCharOrDouble(object2, n)));
        }
        throw new NoSuchMethodException();
    }

    public static boolean isBoxedNumberOrBoolean(Object object) {
        return object instanceof Boolean || BoxesRunTime.isBoxedNumber(object);
    }

    public static boolean isBoxedNumber(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Float || object instanceof Short || object instanceof Character || object instanceof Byte;
    }

    public static Character toCharacter(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToShort(object));
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Byte toByte(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToShort(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Short toShort(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToShort(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Integer toInteger(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Long toLong(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Float toFloat(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Double toDouble(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }
}

