/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.concurrent;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;

public interface Map<K, V>
extends scala.collection.mutable.Map<K, V> {
    public static void $init$(Map $this) {
    }

    public Option<V> putIfAbsent(K var1, V var2);

    public boolean remove(K var1, V var2);

    public boolean replace(K var1, V var2, V var3);

    public Option<V> replace(K var1, V var2);

    public static Object getOrElseUpdate$(Map $this, Object key, Function0 defaultValue) {
        return $this.getOrElseUpdate(key, defaultValue);
    }

    @Override
    default public V getOrElseUpdate(K key, Function0<V> defaultValue) {
        Option option = this.get(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            return (V)v;
        }
        if (None$.MODULE$.equals(option)) {
            V v = defaultValue.apply();
            Option<V> option2 = this.putIfAbsent(key, v);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Object ov = some.value();
                return (V)ov;
            }
            if (None$.MODULE$.equals(option2)) {
                return v;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public static boolean removeRefEq$(Map $this, Object k, Object v) {
        return $this.removeRefEq(k, v);
    }

    default public boolean removeRefEq(K k, V v) {
        return this.remove(k, v);
    }

    public static boolean replaceRefEq$(Map $this, Object k, Object oldValue, Object newValue) {
        return $this.replaceRefEq(k, oldValue, newValue);
    }

    default public boolean replaceRefEq(K k, V oldValue, V newValue) {
        return this.replace(k, oldValue, newValue);
    }

    public static Option updateWith$(Map $this, Object key, Function1 remappingFunction) {
        return $this.updateWith(key, remappingFunction);
    }

    @Override
    default public Option<V> updateWith(K key, Function1<Option<V>, Option<V>> remappingFunction) {
        return this.updateWithAux(key, remappingFunction);
    }

    private Option<V> updateWithAux(K key, Function1<Option<V>, Option<V>> remappingFunction) {
        block3: {
            Option<V> nextValue;
            while (true) {
                Option previousValue = this.get(key);
                nextValue = remappingFunction.apply(previousValue);
                Option option = previousValue;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object prev = some.value();
                    Option<V> option2 = nextValue;
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Object next = some2.value();
                        if (!this.replaceRefEq(key, prev, next)) continue;
                        return nextValue;
                    }
                    if (!this.removeRefEq(key, prev)) continue;
                    return None$.MODULE$;
                }
                Option<V> option3 = nextValue;
                if (!(option3 instanceof Some)) break block3;
                Some some = (Some)option3;
                Object next = some.value();
                if (this.putIfAbsent(key, next).isEmpty()) break;
            }
            return nextValue;
        }
        return None$.MODULE$;
    }

    public static Map filterInPlaceImpl$(Map $this, Function2 p) {
        return $this.filterInPlaceImpl(p);
    }

    default public Map<K, V> filterInPlaceImpl(Function2<K, V, Object> p) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object v;
            Tuple2 tuple2 = (Tuple2)it.next();
            Tuple2 $1$ = tuple2;
            Tuple2 tuple22 = $1$;
            Object k = tuple22._1();
            if (BoxesRunTime.unboxToBoolean(p.apply(k, v = tuple22._2()))) continue;
            this.removeRefEq(k, v);
        }
        return this;
    }

    public static Map mapValuesInPlaceImpl$(Map $this, Function2 f) {
        return $this.mapValuesInPlaceImpl(f);
    }

    default public Map<K, V> mapValuesInPlaceImpl(Function2<K, V, V> f) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Tuple2 tuple2;
            Tuple2 $3$;
            Tuple2 tuple22 = $3$ = (tuple2 = (Tuple2)it.next());
            Object k = tuple22._1();
            Object v = tuple22._2();
            this.replaceRefEq(k, v, f.apply(k, v));
        }
        return this;
    }
}

