/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.sjs.ir;

import dotty.tools.sjs.ir.UTF8String;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import scala.Predef$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.hashing.MurmurHash3$;

public final class UTF8String$
implements Serializable {
    public static final UTF8String$ MODULE$ = new UTF8String$();

    private UTF8String$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UTF8String$.class);
    }

    public byte[] unsafeCreate(byte[] bytes) {
        return bytes;
    }

    public byte[] apply(byte[] bytes) {
        return (byte[])this.validateUTF8(bytes).clone();
    }

    public byte[] apply(String str) {
        return this.encodeUTF8(str);
    }

    public byte[] createAcquiringByteArray(byte[] bytes) {
        return this.validateUTF8(bytes);
    }

    public boolean equals(byte[] x, byte[] y) {
        return Arrays.equals(x, y);
    }

    public int hashCode(byte[] x) {
        return MurmurHash3$.MODULE$.bytesHash(x);
    }

    private byte[] validateUTF8(byte[] bytes) {
        int len = bytes.length;
        int i = 0;
        while (i != len) {
            byte b = bytes[i];
            if (b >= 0) {
                ++i;
                continue;
            }
            i += this.validateMultibyteCodePointAndGetByteLen(bytes, len, i, b);
        }
        return bytes;
    }

    private int validateMultibyteCodePointAndGetByteLen(byte[] bytes, int end, int i, int b1) {
        if ((b1 & 0xE0) == 192) {
            if (i > end - 2) {
                throw this.throwInvalid$1(bytes, i);
            }
            int b2 = bytes[i + 1] & 0xFF;
            if (this.isInvalidNextByte$1(b2)) {
                throw this.throwInvalid$1(bytes, i);
            }
            int cp = (b1 & 0x1F) << 6 | b2 & 0x3F;
            if (cp >= 128) {
                return 2;
            }
            throw this.throwInvalid$1(bytes, i);
        }
        if ((b1 & 0xF0) == 224) {
            if (i > end - 3) {
                throw this.throwInvalid$1(bytes, i);
            }
            int b2 = bytes[i + 1] & 0xFF;
            int b3 = bytes[i + 2] & 0xFF;
            if (this.isInvalidNextByte$1(b2) || this.isInvalidNextByte$1(b3)) {
                throw this.throwInvalid$1(bytes, i);
            }
            int cp = (b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F;
            if (cp >= 2048 && !Character.isSurrogate((char)cp)) {
                return 3;
            }
            throw this.throwInvalid$1(bytes, i);
        }
        if ((b1 & 0xF8) == 240) {
            if (i > end - 4) {
                throw this.throwInvalid$1(bytes, i);
            }
            int b2 = bytes[i + 1] & 0xFF;
            int b3 = bytes[i + 2] & 0xFF;
            int b4 = bytes[i + 3] & 0xFF;
            if (this.isInvalidNextByte$1(b2) || this.isInvalidNextByte$1(b3) || this.isInvalidNextByte$1(b4)) {
                throw this.throwInvalid$1(bytes, i);
            }
            int cp = (b1 & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
            if (cp >= 65536 && cp <= 0x10FFFF) {
                return 4;
            }
            throw this.throwInvalid$1(bytes, i);
        }
        throw this.throwInvalid$1(bytes, i);
    }

    private byte[] encodeUTF8(String str) {
        int len = str.length();
        byte[] result = new byte[len];
        for (int i = 0; i != len; ++i) {
            char c = str.charAt(i);
            if ((c & 0x7F) != c) {
                return this.encodeUTF8WithNonASCII(str);
            }
            result[i] = (byte)c;
        }
        return result;
    }

    private byte[] encodeUTF8WithNonASCII(String str) {
        byte[] byArray;
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPORT);
        try {
            ByteBuffer outputBuffer = encoder.encode(CharBuffer.wrap(str));
            byte[] result = new byte[outputBuffer.remaining()];
            outputBuffer.get(result);
            byArray = result;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalArgumentException("Not a valid UTF-16 string: " + str);
        }
        return byArray;
    }

    private String decodeUTF8(byte[] bytes) {
        int len = bytes.length;
        char[] result = new char[len];
        for (int i = 0; i != len; ++i) {
            byte b = bytes[i];
            if (b < 0) {
                return new String(bytes, StandardCharsets.UTF_8);
            }
            result[i] = (char)(b & 0xFF);
        }
        return new String(result);
    }

    public final int hashCode$extension(byte[] $this) {
        return Objects.hashCode($this);
    }

    public final boolean equals$extension(byte[] $this, Object x$0) {
        Object object = x$0;
        if (object instanceof UTF8String) {
            byte[] byArray;
            byte[] byArray2 = byArray = object == null ? (byte[])null : ((UTF8String)object).bytes();
            return $this == byArray2;
        }
        return false;
    }

    public final int length$extension(byte[] $this) {
        return $this.length;
    }

    public final byte apply$extension(byte[] $this, int i) {
        return $this[i];
    }

    public final String toString$extension(byte[] $this) {
        return this.decodeUTF8($this);
    }

    public final byte[] $plus$plus$extension(byte[] $this, byte[] that) {
        int thisLen = this.length$extension($this);
        int thatLen = this.length$extension(that);
        byte[] result = Arrays.copyOf($this, thisLen + thatLen);
        System.arraycopy(that, 0, result, thisLen, thatLen);
        return result;
    }

    public final void writeTo$extension(byte[] $this, ByteBuffer buffer) {
        buffer.put($this);
    }

    private final boolean isInvalidNextByte$1(int b) {
        return (b & 0xC0) != 128;
    }

    private final Nothing$ throwInvalid$1(byte[] bytes$1, int i$1) {
        throw new IllegalArgumentException("Invalid UTF-8 byte sequence " + Predef$.MODULE$.wrapByteArray(bytes$1).mkString("[", ",", "]") + (" (error at index " + i$1 + ")"));
    }
}

