/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liqp.ParseSettings;
import liqp.ProtectionSettings;
import liqp.RenderSettings;
import liqp.parser.Flavor;

public class TemplateContext {
    public static final String REGISTRY_CYCLE = "cycle";
    public static final String REGISTRY_IFCHANGED = "ifchanged";
    public static final String REGISTRY_FOR = "for";
    public static final String REGISTRY_FOR_STACK = "for_stack";
    protected TemplateContext parent = null;
    public final ProtectionSettings protectionSettings;
    public final RenderSettings renderSettings;
    public final ParseSettings parseSettings;
    private Map<String, Object> variables;
    private Map<String, Object> environmentMap;
    private Map<String, Object> registry;
    private List<RuntimeException> errors;

    public TemplateContext() {
        this(new ProtectionSettings.Builder().build(), new RenderSettings.Builder().build(), new ParseSettings.Builder().withFlavor(Flavor.LIQUID).build(), new LinkedHashMap<String, Object>());
    }

    @Deprecated
    public TemplateContext(ProtectionSettings protectionSettings, RenderSettings renderSettings, Flavor flavor, Map<String, Object> variables) {
        this(protectionSettings, renderSettings, new ParseSettings.Builder().withFlavor(flavor).build(), variables);
    }

    public TemplateContext(ProtectionSettings protectionSettings, RenderSettings renderSettings, ParseSettings parseSettings, Map<String, Object> variables) {
        this.protectionSettings = protectionSettings;
        this.renderSettings = renderSettings;
        this.parseSettings = parseSettings;
        this.variables = new LinkedHashMap<String, Object>(variables);
        this.errors = new ArrayList<RuntimeException>();
    }

    public TemplateContext(TemplateContext parent) {
        this(parent.protectionSettings, parent.renderSettings, parent.parseSettings, new LinkedHashMap<String, Object>());
        this.parent = parent;
    }

    public TemplateContext(TemplateContext parent, Map<String, Object> variables) {
        this(parent);
        this.variables = variables;
    }

    public void addError(RuntimeException exception) {
        this.errors.add(exception);
    }

    public List<RuntimeException> errors() {
        return new ArrayList<RuntimeException>(this.errors);
    }

    public void incrementIterations() {
        this.protectionSettings.incrementIterations();
    }

    public boolean containsKey(String key) {
        if (this.variables.containsKey(key)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsKey(key);
        }
        return false;
    }

    public Object get(String key) {
        Object value = this.variables.get(key);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public Object put(String key, Object value) {
        return this.put(key, value, false);
    }

    public Object put(String key, Object value, boolean putInRootContext) {
        if (!putInRootContext || this.parent == null) {
            return this.variables.put(key, value);
        }
        return this.parent.put(key, value, putInRootContext);
    }

    public Object remove(String key) {
        if (this.variables.containsKey(key)) {
            return this.variables.remove(key);
        }
        if (this.parent != null) {
            return this.parent.remove(key);
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        return new LinkedHashMap<String, Object>(this.variables);
    }

    public Map<String, Object> getEnvironmentMap() {
        if (this.parent != null) {
            return this.parent.getEnvironmentMap();
        }
        if (this.environmentMap == null) {
            this.environmentMap = new HashMap<String, Object>();
        }
        return this.environmentMap;
    }

    public <T extends Map<String, ?>> T getRegistry(String registryName) {
        if (this.parent != null) {
            return this.parent.getRegistry(registryName);
        }
        if (!Arrays.asList(REGISTRY_CYCLE, REGISTRY_IFCHANGED, REGISTRY_FOR, REGISTRY_FOR_STACK).contains(registryName)) {
            throw new RuntimeException("unknown registry type: " + registryName);
        }
        if (this.registry == null) {
            this.registry = new HashMap<String, Object>();
        }
        if (!this.registry.containsKey(registryName)) {
            this.registry.put(registryName, new HashMap());
        }
        return (T)((Map)this.registry.get(registryName));
    }
}

