/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Hashing$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.BitmapIndexedMapNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionMapNode;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class HashMapBuilder<K, V>
implements ReusableBuilder<Tuple2<K, V>, HashMap<K, V>> {
    private HashMap<K, V> aliased;
    public BitmapIndexedMapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode;

    public HashMapBuilder() {
        Growable.$init$(this);
        Builder.$init$(this);
        this.scala$collection$immutable$HashMapBuilder$$rootNode = this.newEmptyRootNode();
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable $plus$plus$eq(IterableOnce elems) {
        return Growable.$plus$plus$eq$(this, elems);
    }

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<Tuple2<K, V>, NewTo> mapResult(Function1<HashMap<K, V>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    private BitmapIndexedMapNode<K, V> newEmptyRootNode() {
        return new BitmapIndexedMapNode(0, 0, Array$.MODULE$.emptyObjectArray(), Array$.MODULE$.emptyIntArray(), 0, 0);
    }

    private boolean isAliased() {
        return this.aliased != null;
    }

    public <V0> V0 getOrElse(K key, V0 value) {
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode.size() == 0) {
            return value;
        }
        int originalHash = Statics.anyHash(key);
        return (V0)this.scala$collection$immutable$HashMapBuilder$$rootNode.getOrElse(key, originalHash, Hashing$.MODULE$.improve(originalHash), 0, () -> HashMapBuilder.getOrElse$$anonfun$1(value));
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <V1> void insertValue(BitmapIndexedMapNode<K, V> bm, int bitpos, K key, int originalHash, int keyHash, V1 value) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    public void update(MapNode<K, V> mapNode, K key, V value, int originalHash, int keyHash, int shift) {
        MapNode<K, V> mapNode2 = mapNode;
        if (mapNode2 instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode;
            BitmapIndexedMapNode bm = bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode2;
            int mask = Node$.MODULE$.maskFrom(keyHash, shift);
            int bitpos = Node$.MODULE$.bitposFrom(mask);
            if ((bm.dataMap() & bitpos) != 0) {
                int index = Node$.MODULE$.indexFrom(bm.dataMap(), mask, bitpos);
                Object key0 = bm.getKey(index);
                int key0UnimprovedHash = bm.getHash(index);
                if (key0UnimprovedHash == originalHash && BoxesRunTime.equals(key0, key)) {
                    bm.content()[2 * index + 1] = value;
                    return;
                }
                Object value0 = bm.getValue(index);
                int key0Hash = Hashing$.MODULE$.improve(key0UnimprovedHash);
                MapNode subNodeNew = bm.mergeTwoKeyValPairs(key0, value0, key0UnimprovedHash, key0Hash, key, value, originalHash, keyHash, shift + 5);
                bm.migrateFromInlineToNodeInPlace(bitpos, key0Hash, subNodeNew);
                return;
            }
            if ((bm.nodeMap() & bitpos) != 0) {
                int index = Node$.MODULE$.indexFrom(bm.nodeMap(), mask, bitpos);
                Node subNode = bm.getNode(index);
                int beforeSize = ((MapNode)subNode).size();
                int beforeHash = subNode.cachedJavaKeySetHashCode();
                this.update((MapNode<K, V>)subNode, key, value, originalHash, keyHash, shift + 5);
                bm.size_$eq(bm.size() + (((MapNode)subNode).size() - beforeSize));
                bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHash));
                return;
            }
            this.insertValue(bm, bitpos, key, originalHash, keyHash, value);
            return;
        }
        if (mapNode2 instanceof HashCollisionMapNode) {
            HashCollisionMapNode hashCollisionMapNode = (HashCollisionMapNode)mapNode2;
            HashCollisionMapNode hc = hashCollisionMapNode;
            int index = hc.indexOf(key);
            if (index < 0) {
                hc.content_$eq(hc.content().appended(Tuple2$.MODULE$.apply(key, value)));
                return;
            }
            hc.content_$eq(hc.content().updated(index, Tuple2$.MODULE$.apply(key, value)));
            return;
        }
        throw new MatchError(mapNode2);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased = null;
    }

    private void copyElems() {
        this.scala$collection$immutable$HashMapBuilder$$rootNode = this.scala$collection$immutable$HashMapBuilder$$rootNode.copy();
    }

    @Override
    public HashMap<K, V> result() {
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode.size() == 0) {
            return HashMap$.MODULE$.empty();
        }
        if (this.aliased != null) {
            return this.aliased;
        }
        this.aliased = new HashMap<K, V>(this.scala$collection$immutable$HashMapBuilder$$rootNode);
        Statics.releaseFence();
        return this.aliased;
    }

    public HashMapBuilder<K, V> addOne(Tuple2<K, V> elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem._1());
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode, elem._1(), elem._2(), h, im, 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value) {
        this.ensureUnaliased();
        int originalHash = Statics.anyHash(key);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode, key, value, originalHash, Hashing$.MODULE$.improve(originalHash), 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value, int originalHash) {
        this.ensureUnaliased();
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode, key, value, originalHash, Hashing$.MODULE$.improve(originalHash), 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value, int originalHash, int hash) {
        this.ensureUnaliased();
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode, key, value, originalHash, hash, 0);
        return this;
    }

    public HashMapBuilder<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        this.ensureUnaliased();
        IterableOnce<Tuple2<K, V>> iterableOnce = xs;
        if (iterableOnce instanceof HashMap) {
            HashMap hashMap;
            HashMap hm = hashMap = (HashMap)iterableOnce;
            v0 = new ChampBaseIterator<Tuple2<K, V>, MapNode<K, V>>(hm, this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(hm$1.rootNode());
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashMapBuilder$$rootNode, ((MapNode)this.currentValueNode()).getKey(this.currentValueCursor()), ((MapNode)this.currentValueNode()).getValue(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }

                public Tuple2 next() {
                    return (Tuple2)Iterator$.MODULE$.empty().next();
                }
            };
        } else if (iterableOnce instanceof scala.collection.mutable.HashMap) {
            scala.collection.mutable.HashMap hashMap;
            scala.collection.mutable.HashMap hm = hashMap = (scala.collection.mutable.HashMap)iterableOnce;
            Iterator iter = hm.nodeIterator();
            while (iter.hasNext()) {
                HashMap.Node next = iter.next();
                int originalHash = hm.unimproveHash(next.hash());
                int hash = Hashing$.MODULE$.improve(originalHash);
                this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode, next.key(), next.value(), originalHash, hash, 0);
            }
            v0 = BoxedUnit.UNIT;
        } else if (iterableOnce instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap;
            LinkedHashMap lhm = linkedHashMap = (LinkedHashMap)iterableOnce;
            Iterator iter = lhm.entryIterator();
            while (iter.hasNext()) {
                LinkedHashMap.LinkedEntry next = iter.next();
                int originalHash = lhm.unimproveHash(next.hash());
                int hash = Hashing$.MODULE$.improve(originalHash);
                this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode, next.key(), next.value(), originalHash, hash, 0);
            }
            v0 = BoxedUnit.UNIT;
        } else if (iterableOnce instanceof Map) {
            Map map;
            Map thatMap = map = (Map)iterableOnce;
            thatMap.foreachEntry((Function2<Object, Object, HashMapBuilder> & Serializable)(key, value) -> this.addOne(key, value));
            v0 = BoxedUnit.UNIT;
        } else {
            IterableOnce<Tuple2<K, V>> other = iterableOnce;
            Iterator<Tuple2<K, V>> it = other.iterator();
            while (it.hasNext()) {
                this.addOne(it.next());
            }
            v0 = BoxedUnit.UNIT;
        }
        return this;
    }

    @Override
    public void clear() {
        this.aliased = null;
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode.size() > 0) {
            this.scala$collection$immutable$HashMapBuilder$$rootNode = this.newEmptyRootNode();
            return;
        }
    }

    public int size() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode.size();
    }

    @Override
    public int knownSize() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode.size();
    }

    private static final Object getOrElse$$anonfun$1(Object value$1) {
        return value$1;
    }
}

