// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeUInt8Array
 * @brief   soa array of vtkTypeUInt8.
 *
 * vtkSOATypeUInt8Array is a soa array of values of type vtkTypeUInt8.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeUInt8Array_h
#define vtkSOATypeUInt8Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeUInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeUInt8Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeUInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeUInt8Array* New();
  static vtkSOATypeUInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeUInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeUInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeUInt8Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeUInt8Array();
  ~vtkSOATypeUInt8Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeUInt8> RealSuperclass;

  vtkSOATypeUInt8Array(const vtkSOATypeUInt8Array&) = delete;
  void operator=(const vtkSOATypeUInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeUInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
