// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantTypeUInt16Array
 * @brief   constant implicit array of vtkTypeUInt16.
 *
 * vtkConstantTypeUInt16Array is a constant implicit array of values of type vtkTypeUInt16.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantTypeUInt16Array_h
#define vtkConstantTypeUInt16Array_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<vtkTypeUInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkConstantTypeUInt16Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantTypeUInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt16);
#endif

  static vtkConstantTypeUInt16Array* New();
  static vtkConstantTypeUInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantTypeUInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantTypeUInt16Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(vtkTypeUInt16 value);

protected:
  vtkConstantTypeUInt16Array();
  ~vtkConstantTypeUInt16Array() override;

private:
  typedef vtkConstantArray<vtkTypeUInt16> RealSuperclass;

  vtkConstantTypeUInt16Array(const vtkConstantTypeUInt16Array&) = delete;
  void operator=(const vtkConstantTypeUInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantTypeUInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
