// When writing files on Windows, translate the characters to their
// 0xf000 higher-encoded versions.
const raw = ['|', '<', '>', '?', ':'];
const win = raw.map(char => String.fromCharCode(0xf000 + char.charCodeAt(0)));
const toWin = new Map(raw.map((char, i) => [char, win[i]]));
const toRaw = new Map(win.map((char, i) => [char, raw[i]]));
export const encode = (s) => raw.reduce((s, c) => s.split(c).join(toWin.get(c)), s);
export const decode = (s) => win.reduce((s, c) => s.split(c).join(toRaw.get(c)), s);//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/2a5b258b5b38d3d4c830bdaaa6e5c610eaacbd15/node_modules-tar-dist-esm-winchars.js.map