/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import org.scilab.modules.preferences.Component.Panel;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.scilab.modules.scinotes.KeywordAdapter;
import org.scilab.modules.scinotes.KeywordEvent;
import org.scilab.modules.scinotes.KeywordListener;
import org.scilab.modules.scinotes.ScilabEditorKit;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabLexerConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreviewCode
extends Panel
implements XComponent,
XChooser {
    private static final long serialVersionUID = 3462302313959678932L;
    private static final int GAP = 5;
    private final ScilabEditorPane previewEditorPane;
    private ActionListener actionListener = null;
    String chosenItem;

    public PreviewCode(Node node) {
        super(node);
        this.fixedHeight = false;
        this.previewEditorPane = new ScilabEditorPane(null);
        ScilabEditorKit scilabEditorKit = new ScilabEditorKit();
        this.previewEditorPane.setEditorKit((EditorKit)scilabEditorKit);
        this.previewEditorPane.setFont(scilabEditorKit.getStylePreferences().tokenFonts[0]);
        String string = "// A comment with whites    and tabulations \t\t\n// Email: <contact@scilab.org>\n// Scilab website: https://www.scilab.org\n//\n// LaTeX $\\sum_{n=1}^{+\\infty}\\frac1{n^2}=\\frac{\\pi^2}6$\n// TODO: blah blah\nfunction [a, b] = myfunction(d, e, f)\n\ta = 2.71828 + %pi + f($, :);\n\tb = cos(a) + sind(a) + \"$\\frac12$\";\n\tif d == e then\n\t\tb = 10 - e.field;\n\telse\n\t\tb = \"\t\ttest     \" + home\n\t\treturn\n\tend\n\tmyvar = 1.23e-45;\nendfunction";
        this.previewEditorPane.setText(string);
        this.previewEditorPane.setCaret((Caret)new DefaultCaret(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        this.previewEditorPane.setBackground(Color.WHITE);
        this.previewEditorPane.getCaret().setBlinkRate(500);
        this.previewEditorPane.getCaret().setVisible(true);
        this.previewEditorPane.setEditable(false);
        this.previewEditorPane.addKeywordListener((KeywordListener)new KeywordAdapter.MouseOverAdapter(){

            public void caughtKeyword(KeywordEvent keywordEvent) {
                PreviewCode.this.previewEditorPane.setToolTipText(ScilabLexerConstants.getStringRep((int)keywordEvent.getType()));
            }
        });
        this.previewEditorPane.addKeywordListener((KeywordListener)new KeywordAdapter.MouseClickedAdapter(){

            public void caughtKeyword(KeywordEvent keywordEvent) {
                PreviewCode.this.keywordClicked(keywordEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)this.previewEditorPane);
        this.previewEditorPane.setRequestFocusEnabled(true);
        this.previewEditorPane.setFocusable(true);
        this.add(jScrollPane);
    }

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{};
        return stringArray;
    }

    @Override
    public void refresh(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("tableRow")) continue;
            String string = XConfigManager.getAttribute(node2, "name");
            String string2 = XConfigManager.getAttribute(node2, "color");
            Color color = XConfigManager.getColor(string2);
            this.previewEditorPane.resetColor(string, color);
            int n = 0;
            if (XConfigManager.getAttribute(node2, "underline").equals("true")) {
                n = 1;
            }
            if (XConfigManager.getAttribute(node2, "strike-through").equals("true")) {
                n += 2;
            }
            this.previewEditorPane.resetAttribute(string, n);
            int n2 = -1;
            if (XConfigManager.getAttribute(node2, "bold").equals("true")) {
                n2 = 1;
            }
            int n3 = -2;
            if (XConfigManager.getAttribute(node2, "italic").equals("true")) {
                n3 = 2;
            }
            this.previewEditorPane.resetFont(string, n2);
            this.previewEditorPane.resetFont(string, n3);
        }
        this.previewEditorPane.repaint();
    }

    @Override
    public final Object choose() {
        return this.chosenItem;
    }

    public void keywordClicked(KeywordEvent keywordEvent) {
        if (this.actionListener != null) {
            int n = keywordEvent.getType();
            this.chosenItem = ScilabLexerConstants.getStringRep((int)n);
            ActionEvent actionEvent = new ActionEvent(this, 0, "Keyword changed", System.currentTimeMillis(), 0);
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public final void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public final String toString() {
        return "PreviewCode";
    }
}

