/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import org.scilab.modules.xcos.palette.view.ModifiedFlowLayout;
import org.scilab.modules.xcos.palette.view.PaletteBlockView;
import org.scilab.modules.xcos.palette.view.PaletteManagerPanel;
import org.scilab.modules.xcos.utils.XcosConstants;

public class PaletteView
extends JPanel
implements Scrollable {
    private static Rectangle2D.Double selectionRect;
    private boolean isLoaded;

    public PaletteView() {
        this.setName("PaletteView");
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(Color.WHITE);
        this.setLayout(new ModifiedFlowLayout(3, 5, 5));
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                try {
                    if (PaletteView.this.getComponentCount() > 0) {
                        ((PaletteBlockView)PaletteView.this.getComponent(0)).getController().setSelected(true);
                    }
                }
                catch (ClassCastException classCastException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    public void setSelectionRectangle(Rectangle2D.Double double_) {
        selectionRect = double_;
        this.repaint();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean bl) {
        if (!bl) {
            this.removeAll();
        }
        this.isLoaded = bl;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        XcosConstants.PaletteBlockSize paletteBlockSize = PaletteManagerPanel.getCurrentSize();
        if (n == 1) {
            return paletteBlockSize.getBlockDimension().height + 5;
        }
        return paletteBlockSize.getBlockDimension().width + 5;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        XcosConstants.PaletteBlockSize paletteBlockSize = PaletteManagerPanel.getCurrentSize();
        if (n == 1) {
            return paletteBlockSize.getBlockDimension().height;
        }
        return paletteBlockSize.getBlockDimension().width;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (selectionRect == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.1f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.BLUE);
        graphics2D.fill(selectionRect);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(selectionRect);
    }
}

