/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.listener;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import org.scilab.modules.xcos.palette.PaletteCtrl;
import org.scilab.modules.xcos.palette.view.PaletteBlockView;
import org.scilab.modules.xcos.palette.view.PaletteView;

public final class PaletteMouseListener
extends MouseAdapter {
    private Point startPoint;

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        PaletteCtrl.clearSelections();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.startPoint = mouseEvent.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Component[] componentArray;
        super.mouseDragged(mouseEvent);
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        double d = Math.min(this.startPoint.getX(), point.getX());
        double d2 = Math.min(this.startPoint.getY(), point.getY());
        double d3 = Math.abs(this.startPoint.getX() - point.getX());
        double d4 = Math.abs(this.startPoint.getY() - point.getY());
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        PaletteView paletteView = (PaletteView)mouseEvent.getSource();
        paletteView.setSelectionRectangle(double_);
        for (Component component : componentArray = paletteView.getComponents()) {
            Rectangle rectangle = component.getBounds();
            boolean bl = double_.contains(rectangle.getCenterX(), rectangle.getCenterY());
            ((PaletteBlockView)component).getController().setSelected(bl);
        }
        paletteView.scrollRectToVisible(new Rectangle(point));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        PaletteView paletteView = (PaletteView)mouseEvent.getSource();
        paletteView.setSelectionRectangle(null);
        Component[] componentArray = paletteView.getComponents();
        if (componentArray.length > 0) {
            componentArray[0].requestFocus();
        }
    }
}

