/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.listener;

import java.awt.MouseInfo;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.contextmenu.ContextMenu;
import org.scilab.modules.gui.contextmenu.ScilabContextMenu;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.xcos.palette.model.Category;
import org.scilab.modules.xcos.palette.model.Palette;
import org.scilab.modules.xcos.palette.model.PaletteNode;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.utils.XcosMessages;

public class PaletteManagerMouseListener
implements MouseListener {
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1 && SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isPopupTrigger() || XcosMessages.isMacOsPopupTrigger(mouseEvent)) {
            if (PaletteManagerView.get() == null) {
                PaletteManagerView.restore();
            }
            JTree jTree = PaletteManagerView.get().getTree();
            TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            jTree.setSelectionPath(treePath);
            ContextMenu contextMenu = ScilabContextMenu.createContextMenu();
            MenuItem menuItem = ScilabMenuItem.createMenuItem();
            this.setupCreateOrAdd(jTree, treePath, menuItem);
            contextMenu.add(menuItem);
            MenuItem menuItem2 = ScilabMenuItem.createMenuItem();
            this.setupRename(jTree, treePath, menuItem2);
            contextMenu.add(menuItem2);
            MenuItem menuItem3 = ScilabMenuItem.createMenuItem();
            this.setupRemove(jTree, treePath, menuItem3);
            contextMenu.add(menuItem3);
            contextMenu.setVisible(true);
            ((SwingScilabContextMenu)contextMenu.getAsSimpleContextMenu()).setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        }
    }

    private void setupCreateOrAdd(JTree jTree, TreePath treePath, MenuItem menuItem) {
        PaletteNode paletteNode = treePath != null ? (PaletteNode)treePath.getLastPathComponent() : (PaletteNode)jTree.getModel().getRoot();
        final PaletteNode paletteNode2 = paletteNode;
        if (paletteNode2 instanceof Category) {
            menuItem.setText(XcosMessages.CREATE);
        } else if (paletteNode2 instanceof Palette) {
            menuItem.setText(XcosMessages.ADDTO_CATEGORY);
        } else {
            throw new IllegalArgumentException("Invalid node selected");
        }
        menuItem.setCallback(new CommonCallBack(XcosMessages.CREATE){
            private static final long serialVersionUID = 0L;

            public void callBack() {
                String string = JOptionPane.showInputDialog(XcosMessages.ASK_FOR_A_NAME, (Object)XcosMessages.DEFAULT_CATEGORY_NAME);
                if (string == null || string.isEmpty()) {
                    return;
                }
                Category category = paletteNode2.getParent();
                Category category2 = new Category();
                category2.setEnable(true);
                category2.setName(string);
                if (paletteNode2 instanceof Category) {
                    ((Category)paletteNode2).getNode().add(category2);
                    category2.setParent((Category)paletteNode2);
                    PaletteNode.refreshView(paletteNode2, category2);
                } else if (paletteNode2 instanceof Palette) {
                    int n = category.getIndex(paletteNode2);
                    category.getNode().set(n, category2);
                    category2.getNode().add(paletteNode2);
                    paletteNode2.setParent(category2);
                    category2.setParent(category);
                    PaletteNode.refreshView(category, paletteNode2);
                }
            }
        });
        menuItem.setEnabled(true);
    }

    private void setupRename(JTree jTree, final TreePath treePath, MenuItem menuItem) {
        menuItem.setText(XcosMessages.RENAME);
        menuItem.setCallback(new CommonCallBack(XcosMessages.RENAME){
            private static final long serialVersionUID = 0L;

            public void callBack() {
                if (treePath == null) {
                    return;
                }
                try {
                    PaletteNode paletteNode = (PaletteNode)treePath.getLastPathComponent();
                    String string = JOptionPane.showInputDialog(XcosMessages.ASK_FOR_A_NAME, (Object)paletteNode.getName());
                    if (string == null || string.isEmpty()) {
                        return;
                    }
                    paletteNode.setName(string);
                }
                catch (Exception exception) {
                    Logger.getLogger(PaletteManagerMouseListener.class.getName()).severe(exception.toString());
                }
            }
        });
    }

    private void setupRemove(JTree jTree, final TreePath treePath, MenuItem menuItem) {
        menuItem.setText(XcosMessages.REMOVE);
        menuItem.setCallback(new CommonCallBack(XcosMessages.REMOVE){
            private static final long serialVersionUID = 0L;

            public void callBack() {
                if (treePath == null) {
                    return;
                }
                try {
                    PaletteNode paletteNode = (PaletteNode)treePath.getLastPathComponent();
                    PaletteNode.remove(paletteNode);
                }
                catch (Exception exception) {
                    Logger.getLogger(PaletteManagerMouseListener.class.getName()).severe(exception.toString());
                }
            }
        });
        boolean bl = true;
        try {
            PaletteNode.checkRemoving((PaletteNode)treePath.getLastPathComponent());
        }
        catch (Exception exception) {
            bl = false;
        }
        menuItem.setEnabled(bl);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

