/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.modelica.listener;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.xcos.modelica.ModelStatistics;
import org.scilab.modules.xcos.modelica.Modelica;
import org.scilab.modules.xcos.modelica.ModelicaController;
import org.scilab.modules.xcos.modelica.ModelicaMessages;
import org.scilab.modules.xcos.modelica.model.Model;

public final class SolveAction
extends AbstractAction {
    private static final String COMPILE_STRING = "fw='%s'; paremb='%s'; jaco='%s'; if(compile_init_modelica(fw, paremb, jaco)) then mopen('%s', 'w'); end ";
    private static final String COMPUTE_STRING = "method='%s'; Nunknowns='%s'; if(Compute_cic(method,Nunknowns)) then mopen('%s', 'w'); end ";
    private static final String IMF_INIT = "_init";
    private static final String EXTENSION = ".xml";
    private static final String INCIDENCE = "i_incidence_matrix";
    private final ModelicaController controller;
    private final JProgressBar progress;

    public SolveAction(ModelicaController modelicaController, JProgressBar jProgressBar) {
        this.putValue("Name", ModelicaMessages.SOLVE);
        this.controller = modelicaController;
        this.progress = jProgressBar;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        new Worker(this.controller, this.progress).execute();
    }

    private static class Worker
    extends SwingWorker<Void, ActionToPerform> {
        private final ModelicaController controller;
        private final JProgressBar progress;

        public Worker(ModelicaController modelicaController, JProgressBar jProgressBar) {
            this.controller = modelicaController;
            this.progress = jProgressBar;
        }

        @Override
        protected Void doInBackground() throws Exception {
            String string = this.controller.getRoot().getName();
            File file = File.createTempFile(string, null);
            if (!this.controller.isSquare()) {
                Logger.getLogger(SolveAction.class.getName()).severe(ModelicaMessages.MODEL_INVALID);
            }
            this.publish(ActionToPerform.EXPORT);
            File file2 = new File(ScilabConstants.TMPDIR, string + "_init.xml");
            Modelica.getInstance().save(this.controller.getRoot(), file2);
            this.publish(ActionToPerform.COMPILE);
            int n = this.controller.isParameterEmbedded() ? 1 : 0;
            int n2 = this.controller.isJacobianEnable() ? 1 : 0;
            if (!file.delete()) {
                System.err.println("Cannot delete '" + String.valueOf(file) + "'");
            }
            String string2 = String.format(SolveAction.COMPILE_STRING, string, n, n2, file.getAbsolutePath());
            Logger.getLogger(SolveAction.class.getName()).finest("Compiling");
            ScilabInterpreterManagement.synchronousScilabExec((String)string2);
            if (!file.exists()) {
                this.publish(ActionToPerform.FINISH);
                return null;
            }
            if (!file.delete()) {
                System.err.println("Cannot delete '" + String.valueOf(file) + "'");
            }
            this.publish(ActionToPerform.COMPUTE);
            File file3 = new File(ScilabConstants.TMPDIR, string + "i_incidence_matrix.xml");
            Model model = Modelica.getInstance().load(file3);
            this.controller.getRoot().setIdentifiers(model.getIdentifiers());
            this.controller.getRoot().setOutputs(model.getOutputs());
            this.controller.getStatistics().fireChange();
            this.controller.setCompileNeeded(false);
            if (!file.delete()) {
                System.err.println("Cannot delete '" + String.valueOf(file) + "'");
            }
            ModelStatistics modelStatistics = this.controller.getStatistics();
            long l = modelStatistics.getUnknowns() - modelStatistics.getEquations();
            string2 = String.format(SolveAction.COMPUTE_STRING, new Object[]{this.controller.getComputeMethod(), l, file.getAbsolutePath()});
            Logger.getLogger(SolveAction.class.getName()).finest("Computing");
            ScilabInterpreterManagement.synchronousScilabExec((String)string2);
            if (!file.exists()) {
                this.publish(ActionToPerform.FINISH);
                return null;
            }
            if (!file.delete()) {
                System.err.println("Cannot delete '" + String.valueOf(file) + "'");
            }
            this.publish(ActionToPerform.FINISH);
            return null;
        }

        @Override
        protected void process(List<ActionToPerform> list) {
            ActionToPerform actionToPerform = list.get(list.size() - 1);
            switch (actionToPerform) {
                case EXPORT: 
                case COMPILE: 
                case COMPUTE: {
                    if (this.progress.isIndeterminate()) break;
                    this.progress.setIndeterminate(true);
                    break;
                }
                default: {
                    this.progress.setIndeterminate(false);
                }
            }
        }
    }

    private static enum ActionToPerform {
        EXPORT,
        COMPILE,
        COMPUTE,
        FINISH;

    }
}

