/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block.custom;

import java.util.ArrayList;
import java.util.List;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.port.input.InputPort;

public class ProdPortLabeler {
    private static final String NOT_PRINTED_LABEL = "\u00d7";
    private static ProdPortLabeler instance;

    public static ProdPortLabeler getInstance() {
        if (instance == null) {
            instance = new ProdPortLabeler();
        }
        return instance;
    }

    public void updateLabel(BasicBlock basicBlock) {
        Object object;
        ArrayList<InputPort> arrayList = new ArrayList<InputPort>();
        for (int i = 0; i < basicBlock.getChildCount(); ++i) {
            object = basicBlock.getChildAt(i);
            if (!(object instanceof InputPort)) continue;
            arrayList.add((InputPort)((Object)object));
        }
        JavaController javaController = new JavaController();
        object = new VectorOfInt();
        javaController.getObjectProperty(basicBlock.getUID(), Kind.BLOCK, ObjectProperties.IPAR, (VectorOfInt)object);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = i < ((VectorOfInt)object).size() ? ((VectorOfInt)object).get(i) : 1;
            ((InputPort)((Object)arrayList.get(i))).setValue(this.getLabel(n));
        }
        if (!this.hasDefaultValue(arrayList)) {
            return;
        }
        basicBlock.setValue(NOT_PRINTED_LABEL);
        for (InputPort inputPort : arrayList) {
            inputPort.setValue("");
        }
    }

    private boolean hasDefaultValue(List<InputPort> list) {
        boolean bl = true;
        for (InputPort inputPort : list) {
            String string;
            if (!(inputPort.getValue() instanceof String) || NOT_PRINTED_LABEL.equals(string = inputPort.getValue().toString())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private String getLabel(double d) {
        if (d > 0.0) {
            return NOT_PRINTED_LABEL;
        }
        return "\u00f7";
    }
}

